# Third Party Licenses

This project uses the following open source packages with their respective licenses:

## MIT License

The majority of dependencies use the MIT License, which is compatible with this project's MIT License.

### Main Dependencies (MIT)

- @modelcontextprotocol/sdk - Model Context Protocol SDK by Anthropic
- @types/cli-progress - TypeScript definitions for cli-progress
- chalk - Terminal string styling
- cli-progress - Easy to use progress-bar for command-line/terminal applications
- commander - Node.js command-line interfaces
- conf - Simple config handling for your app or module
- execa - A better child_process
- inquirer - Interactive command line user interfaces
- open - Open stuff like URLs, files, executables
- ora - Elegant terminal spinner
- p-limit - Run multiple promise-returning & async functions with limited concurrency
- simple-git - A light weight interface for running git commands
- zod - TypeScript-first schema validation

## Apache License 2.0

The following packages are licensed under Apache-2.0:

- @ampproject/remapping
- @eslint/* packages (config-array, config-helpers, core, object-schema)
- @humanwhocodes/* packages (module-importer, retry, compat)
- @inquirer/figures
- @jridgewell/* packages (gen-mapping, resolve-uri, set-array, sourcemap-codec, trace-mapping)
- @vitest/* packages
- fast-xml-parser
- js-tiktoken
- spdx-correct
- spdx-expression-parse
- strnum
- validate-npm-package-license

## ISC License

The following packages are licensed under ISC:

- anymatch
- chokidar
- fastq
- glob-parent  
- graceful-fs
- inherits
- lru-cache
- minimatch
- npmlog
- rimraf
- semver
- signal-exit
- which
- yallist

## BSD Licenses

### BSD-2-Clause
- dotenv
- tslib

### BSD-3-Clause  
- execa
- source-map

## Other Licenses

### BlueOak-1.0.0
- spdx-exceptions

### Python-2.0
- argparse

### 0BSD
- tsup

### (MIT OR CC0-1.0)
- type-fest

## Full License Texts

For the complete text of each license, please refer to:

- MIT: https://opensource.org/licenses/MIT
- Apache-2.0: https://www.apache.org/licenses/LICENSE-2.0
- ISC: https://opensource.org/licenses/ISC
- BSD-2-Clause: https://opensource.org/licenses/BSD-2-Clause
- BSD-3-Clause: https://opensource.org/licenses/BSD-3-Clause
- BlueOak-1.0.0: https://blueoakcouncil.org/license/1.0.0
- Python-2.0: https://opensource.org/licenses/Python-2.0
- 0BSD: https://opensource.org/licenses/0BSD

All of these licenses are compatible with the MIT License under which maestro is distributed.