package compute

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.14.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CachingTypes enumerates the values for caching types.
type CachingTypes string

const (
	// None specifies the none state for caching types.
	None CachingTypes = "None"
	// ReadOnly specifies the read only state for caching types.
	ReadOnly CachingTypes = "ReadOnly"
	// ReadWrite specifies the read write state for caching types.
	ReadWrite CachingTypes = "ReadWrite"
)

// ComponentNames enumerates the values for component names.
type ComponentNames string

const (
	// MicrosoftWindowsShellSetup specifies the microsoft windows shell setup
	// state for component names.
	MicrosoftWindowsShellSetup ComponentNames = "Microsoft-Windows-Shell-Setup"
)

// DiskCreateOptionTypes enumerates the values for disk create option types.
type DiskCreateOptionTypes string

const (
	// Attach specifies the attach state for disk create option types.
	Attach DiskCreateOptionTypes = "attach"
	// Empty specifies the empty state for disk create option types.
	Empty DiskCreateOptionTypes = "empty"
	// FromImage specifies the from image state for disk create option types.
	FromImage DiskCreateOptionTypes = "fromImage"
)

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// Linux specifies the linux state for operating system types.
	Linux OperatingSystemTypes = "Linux"
	// Windows specifies the windows state for operating system types.
	Windows OperatingSystemTypes = "Windows"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed specifies the failed state for operation status.
	Failed OperationStatus = "Failed"
	// InProgress specifies the in progress state for operation status.
	InProgress OperationStatus = "InProgress"
	// Succeeded specifies the succeeded state for operation status.
	Succeeded OperationStatus = "Succeeded"
)

// OperationStatusEnum enumerates the values for operation status enum.
type OperationStatusEnum string

const (
	// OperationStatusEnumFailed specifies the operation status enum failed
	// state for operation status enum.
	OperationStatusEnumFailed OperationStatusEnum = "Failed"
	// OperationStatusEnumInProgress specifies the operation status enum in
	// progress state for operation status enum.
	OperationStatusEnumInProgress OperationStatusEnum = "InProgress"
	// OperationStatusEnumPreempted specifies the operation status enum
	// preempted state for operation status enum.
	OperationStatusEnumPreempted OperationStatusEnum = "Preempted"
	// OperationStatusEnumSucceeded specifies the operation status enum
	// succeeded state for operation status enum.
	OperationStatusEnumSucceeded OperationStatusEnum = "Succeeded"
)

// PassNames enumerates the values for pass names.
type PassNames string

const (
	// OobeSystem specifies the oobe system state for pass names.
	OobeSystem PassNames = "oobeSystem"
)

// ProtocolTypes enumerates the values for protocol types.
type ProtocolTypes string

const (
	// HTTP specifies the http state for protocol types.
	HTTP ProtocolTypes = "Http"
	// HTTPS specifies the https state for protocol types.
	HTTPS ProtocolTypes = "Https"
)

// SettingNames enumerates the values for setting names.
type SettingNames string

const (
	// AutoLogon specifies the auto logon state for setting names.
	AutoLogon SettingNames = "AutoLogon"
	// FirstLogonCommands specifies the first logon commands state for setting
	// names.
	FirstLogonCommands SettingNames = "FirstLogonCommands"
)

// StatusLevelTypes enumerates the values for status level types.
type StatusLevelTypes string

const (
	// Error specifies the error state for status level types.
	Error StatusLevelTypes = "Error"
	// Info specifies the info state for status level types.
	Info StatusLevelTypes = "Info"
	// Warning specifies the warning state for status level types.
	Warning StatusLevelTypes = "Warning"
)

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// Automatic specifies the automatic state for upgrade mode.
	Automatic UpgradeMode = "Automatic"
	// Manual specifies the manual state for upgrade mode.
	Manual UpgradeMode = "Manual"
)

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Count specifies the count state for usage unit.
	Count UsageUnit = "Count"
)

// VirtualMachineScaleSetSkuScaleType enumerates the values for virtual
// machine scale set sku scale type.
type VirtualMachineScaleSetSkuScaleType string

const (
	// VirtualMachineScaleSetSkuScaleTypeAutomatic specifies the virtual
	// machine scale set sku scale type automatic state for virtual machine
	// scale set sku scale type.
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = "Automatic"
	// VirtualMachineScaleSetSkuScaleTypeNone specifies the virtual machine
	// scale set sku scale type none state for virtual machine scale set sku
	// scale type.
	VirtualMachineScaleSetSkuScaleTypeNone VirtualMachineScaleSetSkuScaleType = "None"
)

// VirtualMachineSizeTypes enumerates the values for virtual machine size
// types.
type VirtualMachineSizeTypes string

const (
	// BasicA0 specifies the basic a0 state for virtual machine size types.
	BasicA0 VirtualMachineSizeTypes = "Basic_A0"
	// BasicA1 specifies the basic a1 state for virtual machine size types.
	BasicA1 VirtualMachineSizeTypes = "Basic_A1"
	// BasicA2 specifies the basic a2 state for virtual machine size types.
	BasicA2 VirtualMachineSizeTypes = "Basic_A2"
	// BasicA3 specifies the basic a3 state for virtual machine size types.
	BasicA3 VirtualMachineSizeTypes = "Basic_A3"
	// BasicA4 specifies the basic a4 state for virtual machine size types.
	BasicA4 VirtualMachineSizeTypes = "Basic_A4"
	// StandardA0 specifies the standard a0 state for virtual machine size
	// types.
	StandardA0 VirtualMachineSizeTypes = "Standard_A0"
	// StandardA1 specifies the standard a1 state for virtual machine size
	// types.
	StandardA1 VirtualMachineSizeTypes = "Standard_A1"
	// StandardA10 specifies the standard a10 state for virtual machine size
	// types.
	StandardA10 VirtualMachineSizeTypes = "Standard_A10"
	// StandardA11 specifies the standard a11 state for virtual machine size
	// types.
	StandardA11 VirtualMachineSizeTypes = "Standard_A11"
	// StandardA2 specifies the standard a2 state for virtual machine size
	// types.
	StandardA2 VirtualMachineSizeTypes = "Standard_A2"
	// StandardA3 specifies the standard a3 state for virtual machine size
	// types.
	StandardA3 VirtualMachineSizeTypes = "Standard_A3"
	// StandardA4 specifies the standard a4 state for virtual machine size
	// types.
	StandardA4 VirtualMachineSizeTypes = "Standard_A4"
	// StandardA5 specifies the standard a5 state for virtual machine size
	// types.
	StandardA5 VirtualMachineSizeTypes = "Standard_A5"
	// StandardA6 specifies the standard a6 state for virtual machine size
	// types.
	StandardA6 VirtualMachineSizeTypes = "Standard_A6"
	// StandardA7 specifies the standard a7 state for virtual machine size
	// types.
	StandardA7 VirtualMachineSizeTypes = "Standard_A7"
	// StandardA8 specifies the standard a8 state for virtual machine size
	// types.
	StandardA8 VirtualMachineSizeTypes = "Standard_A8"
	// StandardA9 specifies the standard a9 state for virtual machine size
	// types.
	StandardA9 VirtualMachineSizeTypes = "Standard_A9"
	// StandardD1 specifies the standard d1 state for virtual machine size
	// types.
	StandardD1 VirtualMachineSizeTypes = "Standard_D1"
	// StandardD11 specifies the standard d11 state for virtual machine size
	// types.
	StandardD11 VirtualMachineSizeTypes = "Standard_D11"
	// StandardD11V2 specifies the standard d11v2 state for virtual machine
	// size types.
	StandardD11V2 VirtualMachineSizeTypes = "Standard_D11_v2"
	// StandardD12 specifies the standard d12 state for virtual machine size
	// types.
	StandardD12 VirtualMachineSizeTypes = "Standard_D12"
	// StandardD12V2 specifies the standard d12v2 state for virtual machine
	// size types.
	StandardD12V2 VirtualMachineSizeTypes = "Standard_D12_v2"
	// StandardD13 specifies the standard d13 state for virtual machine size
	// types.
	StandardD13 VirtualMachineSizeTypes = "Standard_D13"
	// StandardD13V2 specifies the standard d13v2 state for virtual machine
	// size types.
	StandardD13V2 VirtualMachineSizeTypes = "Standard_D13_v2"
	// StandardD14 specifies the standard d14 state for virtual machine size
	// types.
	StandardD14 VirtualMachineSizeTypes = "Standard_D14"
	// StandardD14V2 specifies the standard d14v2 state for virtual machine
	// size types.
	StandardD14V2 VirtualMachineSizeTypes = "Standard_D14_v2"
	// StandardD1V2 specifies the standard d1v2 state for virtual machine size
	// types.
	StandardD1V2 VirtualMachineSizeTypes = "Standard_D1_v2"
	// StandardD2 specifies the standard d2 state for virtual machine size
	// types.
	StandardD2 VirtualMachineSizeTypes = "Standard_D2"
	// StandardD2V2 specifies the standard d2v2 state for virtual machine size
	// types.
	StandardD2V2 VirtualMachineSizeTypes = "Standard_D2_v2"
	// StandardD3 specifies the standard d3 state for virtual machine size
	// types.
	StandardD3 VirtualMachineSizeTypes = "Standard_D3"
	// StandardD3V2 specifies the standard d3v2 state for virtual machine size
	// types.
	StandardD3V2 VirtualMachineSizeTypes = "Standard_D3_v2"
	// StandardD4 specifies the standard d4 state for virtual machine size
	// types.
	StandardD4 VirtualMachineSizeTypes = "Standard_D4"
	// StandardD4V2 specifies the standard d4v2 state for virtual machine size
	// types.
	StandardD4V2 VirtualMachineSizeTypes = "Standard_D4_v2"
	// StandardD5V2 specifies the standard d5v2 state for virtual machine size
	// types.
	StandardD5V2 VirtualMachineSizeTypes = "Standard_D5_v2"
	// StandardDS1 specifies the standard ds1 state for virtual machine size
	// types.
	StandardDS1 VirtualMachineSizeTypes = "Standard_DS1"
	// StandardDS11 specifies the standard ds11 state for virtual machine size
	// types.
	StandardDS11 VirtualMachineSizeTypes = "Standard_DS11"
	// StandardDS12 specifies the standard ds12 state for virtual machine size
	// types.
	StandardDS12 VirtualMachineSizeTypes = "Standard_DS12"
	// StandardDS13 specifies the standard ds13 state for virtual machine size
	// types.
	StandardDS13 VirtualMachineSizeTypes = "Standard_DS13"
	// StandardDS14 specifies the standard ds14 state for virtual machine size
	// types.
	StandardDS14 VirtualMachineSizeTypes = "Standard_DS14"
	// StandardDS2 specifies the standard ds2 state for virtual machine size
	// types.
	StandardDS2 VirtualMachineSizeTypes = "Standard_DS2"
	// StandardDS3 specifies the standard ds3 state for virtual machine size
	// types.
	StandardDS3 VirtualMachineSizeTypes = "Standard_DS3"
	// StandardDS4 specifies the standard ds4 state for virtual machine size
	// types.
	StandardDS4 VirtualMachineSizeTypes = "Standard_DS4"
	// StandardG1 specifies the standard g1 state for virtual machine size
	// types.
	StandardG1 VirtualMachineSizeTypes = "Standard_G1"
	// StandardG2 specifies the standard g2 state for virtual machine size
	// types.
	StandardG2 VirtualMachineSizeTypes = "Standard_G2"
	// StandardG3 specifies the standard g3 state for virtual machine size
	// types.
	StandardG3 VirtualMachineSizeTypes = "Standard_G3"
	// StandardG4 specifies the standard g4 state for virtual machine size
	// types.
	StandardG4 VirtualMachineSizeTypes = "Standard_G4"
	// StandardG5 specifies the standard g5 state for virtual machine size
	// types.
	StandardG5 VirtualMachineSizeTypes = "Standard_G5"
	// StandardGS1 specifies the standard gs1 state for virtual machine size
	// types.
	StandardGS1 VirtualMachineSizeTypes = "Standard_GS1"
	// StandardGS2 specifies the standard gs2 state for virtual machine size
	// types.
	StandardGS2 VirtualMachineSizeTypes = "Standard_GS2"
	// StandardGS3 specifies the standard gs3 state for virtual machine size
	// types.
	StandardGS3 VirtualMachineSizeTypes = "Standard_GS3"
	// StandardGS4 specifies the standard gs4 state for virtual machine size
	// types.
	StandardGS4 VirtualMachineSizeTypes = "Standard_GS4"
	// StandardGS5 specifies the standard gs5 state for virtual machine size
	// types.
	StandardGS5 VirtualMachineSizeTypes = "Standard_GS5"
)

// AdditionalUnattendContent is gets or sets additional XML formatted
// information that can be included in the Unattend.xml file, which is used
// by Windows Setup. Contents are defined by setting name, component name,
// and the pass in which the content is a applied.
type AdditionalUnattendContent struct {
	PassName      PassNames      `json:"passName,omitempty"`
	ComponentName ComponentNames `json:"componentName,omitempty"`
	SettingName   SettingNames   `json:"settingName,omitempty"`
	Content       *string        `json:"content,omitempty"`
}

// APIEntityReference is the API entity reference.
type APIEntityReference struct {
	ID *string `json:"id,omitempty"`
}

// APIError is api error.
type APIError struct {
	Details    *[]APIErrorBase `json:"details,omitempty"`
	Innererror *InnerError     `json:"innererror,omitempty"`
	Code       *string         `json:"code,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Message    *string         `json:"message,omitempty"`
}

// APIErrorBase is api error base.
type APIErrorBase struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// AvailabilitySet is create or update Availability Set parameters.
type AvailabilitySet struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	Properties        *AvailabilitySetProperties `json:"properties,omitempty"`
}

// AvailabilitySetListResult is the List Availability Set operation response.
type AvailabilitySetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]AvailabilitySet `json:"value,omitempty"`
	NextLink          *string            `json:",omitempty"`
}

// AvailabilitySetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AvailabilitySetListResult) AvailabilitySetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AvailabilitySetProperties is the instance view of a resource.
type AvailabilitySetProperties struct {
	PlatformUpdateDomainCount *int                  `json:"platformUpdateDomainCount,omitempty"`
	PlatformFaultDomainCount  *int                  `json:"platformFaultDomainCount,omitempty"`
	VirtualMachines           *[]SubResource        `json:"virtualMachines,omitempty"`
	Statuses                  *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// BootDiagnostics is describes Boot Diagnostics.
type BootDiagnostics struct {
	Enabled    *bool   `json:"enabled,omitempty"`
	StorageURI *string `json:"storageUri,omitempty"`
}

// BootDiagnosticsInstanceView is the instance view of a virtual machine boot
// diagnostics.
type BootDiagnosticsInstanceView struct {
	ConsoleScreenshotBlobURI *string `json:"consoleScreenshotBlobUri,omitempty"`
	SerialConsoleLogBlobURI  *string `json:"serialConsoleLogBlobUri,omitempty"`
}

// DataDisk is describes a data disk.
type DataDisk struct {
	Lun          *int                  `json:"lun,omitempty"`
	Name         *string               `json:"name,omitempty"`
	Vhd          *VirtualHardDisk      `json:"vhd,omitempty"`
	Image        *VirtualHardDisk      `json:"image,omitempty"`
	Caching      CachingTypes          `json:"caching,omitempty"`
	CreateOption DiskCreateOptionTypes `json:"createOption,omitempty"`
	DiskSizeGB   *int                  `json:"diskSizeGB,omitempty"`
}

// DataDiskImage is contains the data disk images information.
type DataDiskImage struct {
	Lun *int `json:"lun,omitempty"`
}

// DeleteOperationResult is the compute long running operation response.
type DeleteOperationResult struct {
	OperationID *string         `json:"operationId,omitempty"`
	Status      OperationStatus `json:"status,omitempty"`
	StartTime   *date.Time      `json:"startTime,omitempty"`
	EndTime     *date.Time      `json:"endTime,omitempty"`
	Error       *APIError       `json:"error,omitempty"`
}

// DiagnosticsProfile is describes a diagnostics profile.
type DiagnosticsProfile struct {
	BootDiagnostics *BootDiagnostics `json:"bootDiagnostics,omitempty"`
}

// DiskEncryptionSettings is describes a Encryption Settings for a Disk
type DiskEncryptionSettings struct {
	DiskEncryptionKey *KeyVaultSecretReference `json:"diskEncryptionKey,omitempty"`
	KeyEncryptionKey  *KeyVaultKeyReference    `json:"keyEncryptionKey,omitempty"`
}

// DiskInstanceView is the instance view of the disk.
type DiskInstanceView struct {
	Name     *string               `json:"name,omitempty"`
	Statuses *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// HardwareProfile is describes a hardware profile.
type HardwareProfile struct {
	VMSize VirtualMachineSizeTypes `json:"vmSize,omitempty"`
}

// ImageReference is the image reference.
type ImageReference struct {
	Publisher *string `json:"publisher,omitempty"`
	Offer     *string `json:"offer,omitempty"`
	Sku       *string `json:"sku,omitempty"`
	Version   *string `json:"version,omitempty"`
}

// InnerError is inner error details.
type InnerError struct {
	Exceptiontype *string `json:"exceptiontype,omitempty"`
	Errordetail   *string `json:"errordetail,omitempty"`
}

// InstanceViewStatus is instance view status.
type InstanceViewStatus struct {
	Code          *string          `json:"code,omitempty"`
	Level         StatusLevelTypes `json:"level,omitempty"`
	DisplayStatus *string          `json:"displayStatus,omitempty"`
	Message       *string          `json:"message,omitempty"`
	Time          *date.Time       `json:"time,omitempty"`
}

// KeyVaultKeyReference is describes a reference to Key Vault Key
type KeyVaultKeyReference struct {
	KeyURL      *string      `json:"keyUrl,omitempty"`
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// KeyVaultSecretReference is describes a reference to Key Vault Secret
type KeyVaultSecretReference struct {
	SecretURL   *string      `json:"secretUrl,omitempty"`
	SourceVault *SubResource `json:"sourceVault,omitempty"`
}

// LinuxConfiguration is describes Windows Configuration of the OS Profile.
type LinuxConfiguration struct {
	DisablePasswordAuthentication *bool             `json:"disablePasswordAuthentication,omitempty"`
	SSH                           *SSHConfiguration `json:"ssh,omitempty"`
}

// ListUsagesResult is the List Usages operation response.
type ListUsagesResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
	NextLink          *string  `json:",omitempty"`
}

// ListUsagesResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ListUsagesResult) ListUsagesResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LongRunningOperationProperties is compute-specific operation properties,
// including output
type LongRunningOperationProperties struct {
	Output *map[string]interface{} `json:"output,omitempty"`
}

// LongRunningOperationResult is the Compute service response for long-running
// operations.
type LongRunningOperationResult struct {
	OperationID *string                         `json:"operationId,omitempty"`
	Status      OperationStatusEnum             `json:"status,omitempty"`
	StartTime   *date.Time                      `json:"startTime,omitempty"`
	EndTime     *date.Time                      `json:"endTime,omitempty"`
	Properties  *LongRunningOperationProperties `json:"properties,omitempty"`
	Error       *APIError                       `json:"error,omitempty"`
}

// NetworkInterfaceReference is describes a network interface reference.
type NetworkInterfaceReference struct {
	ID         *string                              `json:"id,omitempty"`
	Properties *NetworkInterfaceReferenceProperties `json:"properties,omitempty"`
}

// NetworkInterfaceReferenceProperties is describes a network interface
// reference properties.
type NetworkInterfaceReferenceProperties struct {
	Primary *bool `json:"primary,omitempty"`
}

// NetworkProfile is describes a network profile.
type NetworkProfile struct {
	NetworkInterfaces *[]NetworkInterfaceReference `json:"networkInterfaces,omitempty"`
}

// OSDisk is describes an Operating System disk.
type OSDisk struct {
	OsType             OperatingSystemTypes    `json:"osType,omitempty"`
	EncryptionSettings *DiskEncryptionSettings `json:"encryptionSettings,omitempty"`
	Name               *string                 `json:"name,omitempty"`
	Vhd                *VirtualHardDisk        `json:"vhd,omitempty"`
	Image              *VirtualHardDisk        `json:"image,omitempty"`
	Caching            CachingTypes            `json:"caching,omitempty"`
	CreateOption       DiskCreateOptionTypes   `json:"createOption,omitempty"`
	DiskSizeGB         *int                    `json:"diskSizeGB,omitempty"`
}

// OSDiskImage is contains the os disk image information.
type OSDiskImage struct {
	OperatingSystem OperatingSystemTypes `json:"operatingSystem,omitempty"`
}

// OSProfile is describes an OS profile.
type OSProfile struct {
	ComputerName         *string               `json:"computerName,omitempty"`
	AdminUsername        *string               `json:"adminUsername,omitempty"`
	AdminPassword        *string               `json:"adminPassword,omitempty"`
	CustomData           *string               `json:"customData,omitempty"`
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	LinuxConfiguration   *LinuxConfiguration   `json:"linuxConfiguration,omitempty"`
	Secrets              *[]VaultSecretGroup   `json:"secrets,omitempty"`
}

// Plan is plan for the resource.
type Plan struct {
	Name          *string `json:"name,omitempty"`
	Publisher     *string `json:"publisher,omitempty"`
	Product       *string `json:"product,omitempty"`
	PromotionCode *string `json:"promotionCode,omitempty"`
}

// PurchasePlan is used for establishing the purchase context of any 3rd Party
// artifact through MarketPlace.
type PurchasePlan struct {
	Publisher *string `json:"publisher,omitempty"`
	Name      *string `json:"name,omitempty"`
	Product   *string `json:"product,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// Sku is describes a virtual machine scale set sku.
type Sku struct {
	Name     *string `json:"name,omitempty"`
	Tier     *string `json:"tier,omitempty"`
	Capacity *int32  `json:"capacity,omitempty"`
}

// SSHConfiguration is sSH configuration for Linux based VMs running on Azure
type SSHConfiguration struct {
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey is contains information about SSH certificate public key and
// the path on the Linux VM where the public key is placed.
type SSHPublicKey struct {
	Path    *string `json:"path,omitempty"`
	KeyData *string `json:"keyData,omitempty"`
}

// StorageProfile is describes a storage profile.
type StorageProfile struct {
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	OsDisk         *OSDisk         `json:"osDisk,omitempty"`
	DataDisks      *[]DataDisk     `json:"dataDisks,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// UpgradePolicy is describes an upgrade policy - automatic or manual.
type UpgradePolicy struct {
	Mode UpgradeMode `json:"mode,omitempty"`
}

// Usage is describes Compute Resource Usage.
type Usage struct {
	Unit         UsageUnit  `json:"unit,omitempty"`
	CurrentValue *int       `json:"currentValue,omitempty"`
	Limit        *int32     `json:"limit,omitempty"`
	Name         *UsageName `json:"name,omitempty"`
}

// UsageName is the Usage Names.
type UsageName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// VaultCertificate is describes a single certificate reference in a Key
// Vault, and where the certificate should reside on the VM.
type VaultCertificate struct {
	CertificateURL   *string `json:"certificateUrl,omitempty"`
	CertificateStore *string `json:"certificateStore,omitempty"`
}

// VaultSecretGroup is describes a set of certificates which are all in the
// same Key Vault.
type VaultSecretGroup struct {
	SourceVault       *SubResource        `json:"sourceVault,omitempty"`
	VaultCertificates *[]VaultCertificate `json:"vaultCertificates,omitempty"`
}

// VirtualHardDisk is describes the uri of a disk.
type VirtualHardDisk struct {
	URI *string `json:"uri,omitempty"`
}

// VirtualMachine is describes a Virtual Machine.
type VirtualMachine struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	Plan              *Plan                      `json:"plan,omitempty"`
	Properties        *VirtualMachineProperties  `json:"properties,omitempty"`
	Resources         *[]VirtualMachineExtension `json:"resources,omitempty"`
}

// VirtualMachineAgentInstanceView is the instance view of the VM Agent
// running on the virtual machine.
type VirtualMachineAgentInstanceView struct {
	VMAgentVersion    *string                                       `json:"vmAgentVersion,omitempty"`
	ExtensionHandlers *[]VirtualMachineExtensionHandlerInstanceView `json:"extensionHandlers,omitempty"`
	Statuses          *[]InstanceViewStatus                         `json:"statuses,omitempty"`
}

// VirtualMachineCaptureParameters is capture Virtual Machine parameters.
type VirtualMachineCaptureParameters struct {
	VhdPrefix                *string `json:"vhdPrefix,omitempty"`
	DestinationContainerName *string `json:"destinationContainerName,omitempty"`
	OverwriteVhds            *bool   `json:"overwriteVhds,omitempty"`
}

// VirtualMachineCaptureResult is resource Id.
type VirtualMachineCaptureResult struct {
	autorest.Response `json:"-"`
	ID                *string                                `json:"id,omitempty"`
	Properties        *VirtualMachineCaptureResultProperties `json:"properties,omitempty"`
}

// VirtualMachineCaptureResultProperties is compute-specific operation
// properties, including output
type VirtualMachineCaptureResultProperties struct {
	Output *map[string]interface{} `json:"output,omitempty"`
}

// VirtualMachineExtension is describes a Virtual Machine Extension.
type VirtualMachineExtension struct {
	autorest.Response `json:"-"`
	ID                *string                            `json:"id,omitempty"`
	Name              *string                            `json:"name,omitempty"`
	Type              *string                            `json:"type,omitempty"`
	Location          *string                            `json:"location,omitempty"`
	Tags              *map[string]*string                `json:"tags,omitempty"`
	Properties        *VirtualMachineExtensionProperties `json:"properties,omitempty"`
}

// VirtualMachineExtensionHandlerInstanceView is the instance view of a
// virtual machine extension handler.
type VirtualMachineExtensionHandlerInstanceView struct {
	Type               *string             `json:"type,omitempty"`
	TypeHandlerVersion *string             `json:"typeHandlerVersion,omitempty"`
	Status             *InstanceViewStatus `json:"status,omitempty"`
}

// VirtualMachineExtensionImage is describes a Virtual Machine Extension Image.
type VirtualMachineExtensionImage struct {
	autorest.Response `json:"-"`
	ID                *string                                 `json:"id,omitempty"`
	Properties        *VirtualMachineExtensionImageProperties `json:"properties,omitempty"`
	Name              *string                                 `json:"name,omitempty"`
	Location          *string                                 `json:"location,omitempty"`
	Tags              *map[string]*string                     `json:"tags,omitempty"`
}

// VirtualMachineExtensionImageProperties is describes the properties of a
// Virtual Machine Extension Image.
type VirtualMachineExtensionImageProperties struct {
	OperatingSystem            *string `json:"operatingSystem,omitempty"`
	ComputeRole                *string `json:"computeRole,omitempty"`
	HandlerSchema              *string `json:"handlerSchema,omitempty"`
	VMScaleSetEnabled          *bool   `json:"vmScaleSetEnabled,omitempty"`
	SupportsMultipleExtensions *bool   `json:"supportsMultipleExtensions,omitempty"`
}

// VirtualMachineExtensionInstanceView is the instance view of a virtual
// machine extension.
type VirtualMachineExtensionInstanceView struct {
	Name               *string               `json:"name,omitempty"`
	Type               *string               `json:"type,omitempty"`
	TypeHandlerVersion *string               `json:"typeHandlerVersion,omitempty"`
	Substatuses        *[]InstanceViewStatus `json:"substatuses,omitempty"`
	Statuses           *[]InstanceViewStatus `json:"statuses,omitempty"`
}

// VirtualMachineExtensionProperties is describes the properties of a Virtual
// Machine Extension.
type VirtualMachineExtensionProperties struct {
	Publisher               *string                              `json:"publisher,omitempty"`
	Type                    *string                              `json:"type,omitempty"`
	TypeHandlerVersion      *string                              `json:"typeHandlerVersion,omitempty"`
	AutoUpgradeMinorVersion *bool                                `json:"autoUpgradeMinorVersion,omitempty"`
	Settings                *map[string]interface{}              `json:"settings,omitempty"`
	ProtectedSettings       *map[string]interface{}              `json:"protectedSettings,omitempty"`
	ProvisioningState       *string                              `json:"provisioningState,omitempty"`
	InstanceView            *VirtualMachineExtensionInstanceView `json:"instanceView,omitempty"`
}

// VirtualMachineImage is describes a Virtual Machine Image.
type VirtualMachineImage struct {
	autorest.Response `json:"-"`
	ID                *string                        `json:"id,omitempty"`
	Properties        *VirtualMachineImageProperties `json:"properties,omitempty"`
	Name              *string                        `json:"name,omitempty"`
	Location          *string                        `json:"location,omitempty"`
	Tags              *map[string]*string            `json:"tags,omitempty"`
}

// VirtualMachineImageProperties is describes the properties of a Virtual
// Machine Image.
type VirtualMachineImageProperties struct {
	Plan           *PurchasePlan    `json:"plan,omitempty"`
	OsDiskImage    *OSDiskImage     `json:"osDiskImage,omitempty"`
	DataDiskImages *[]DataDiskImage `json:"dataDiskImages,omitempty"`
}

// VirtualMachineImageResource is virtual machine image resource information.
type VirtualMachineImageResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineImageResourceList is
type VirtualMachineImageResourceList struct {
	autorest.Response `json:"-"`
	Value             *VirtualMachineImageResource `json:"value,omitempty"`
}

// VirtualMachineInstanceView is the instance view of a virtual machine.
type VirtualMachineInstanceView struct {
	PlatformUpdateDomain *int                                   `json:"platformUpdateDomain,omitempty"`
	PlatformFaultDomain  *int                                   `json:"platformFaultDomain,omitempty"`
	RdpThumbPrint        *string                                `json:"rdpThumbPrint,omitempty"`
	VMAgent              *VirtualMachineAgentInstanceView       `json:"vmAgent,omitempty"`
	Disks                *[]DiskInstanceView                    `json:"disks,omitempty"`
	Extensions           *[]VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`
	BootDiagnostics      *BootDiagnosticsInstanceView           `json:"bootDiagnostics,omitempty"`
	Statuses             *[]InstanceViewStatus                  `json:"statuses,omitempty"`
}

// VirtualMachineListResult is the List Virtual Machine operation response.
type VirtualMachineListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachine `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// VirtualMachineListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineListResult) VirtualMachineListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineProperties is describes the properties of a Virtual Machine.
type VirtualMachineProperties struct {
	HardwareProfile    *HardwareProfile            `json:"hardwareProfile,omitempty"`
	StorageProfile     *StorageProfile             `json:"storageProfile,omitempty"`
	OsProfile          *OSProfile                  `json:"osProfile,omitempty"`
	NetworkProfile     *NetworkProfile             `json:"networkProfile,omitempty"`
	DiagnosticsProfile *DiagnosticsProfile         `json:"diagnosticsProfile,omitempty"`
	AvailabilitySet    *SubResource                `json:"availabilitySet,omitempty"`
	ProvisioningState  *string                     `json:"provisioningState,omitempty"`
	InstanceView       *VirtualMachineInstanceView `json:"instanceView,omitempty"`
}

// VirtualMachineScaleSet is describes a Virtual Machine Scale Set.
type VirtualMachineScaleSet struct {
	autorest.Response `json:"-"`
	ID                *string                           `json:"id,omitempty"`
	Name              *string                           `json:"name,omitempty"`
	Type              *string                           `json:"type,omitempty"`
	Location          *string                           `json:"location,omitempty"`
	Tags              *map[string]*string               `json:"tags,omitempty"`
	Sku               *Sku                              `json:"sku,omitempty"`
	Properties        *VirtualMachineScaleSetProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetExtension is describes a Virtual Machine Scale Set
// Extension.
type VirtualMachineScaleSetExtension struct {
	ID         *string                                    `json:"id,omitempty"`
	Name       *string                                    `json:"name,omitempty"`
	Properties *VirtualMachineScaleSetExtensionProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetExtensionProfile is describes a virtual machine scale
// set extension profile.
type VirtualMachineScaleSetExtensionProfile struct {
	Extensions *[]VirtualMachineScaleSetExtension `json:"extensions,omitempty"`
}

// VirtualMachineScaleSetExtensionProperties is describes the properties of a
// Virtual Machine Scale Set Extension.
type VirtualMachineScaleSetExtensionProperties struct {
	Publisher               *string                 `json:"publisher,omitempty"`
	Type                    *string                 `json:"type,omitempty"`
	TypeHandlerVersion      *string                 `json:"typeHandlerVersion,omitempty"`
	AutoUpgradeMinorVersion *bool                   `json:"autoUpgradeMinorVersion,omitempty"`
	Settings                *map[string]interface{} `json:"settings,omitempty"`
	ProtectedSettings       *map[string]interface{} `json:"protectedSettings,omitempty"`
	ProvisioningState       *string                 `json:"provisioningState,omitempty"`
}

// VirtualMachineScaleSetInstanceView is the instance view of a virtual
// machine scale set.
type VirtualMachineScaleSetInstanceView struct {
	autorest.Response `json:"-"`
	VirtualMachine    *VirtualMachineScaleSetInstanceViewStatusesSummary `json:"virtualMachine,omitempty"`
	Extensions        *[]VirtualMachineScaleSetVMExtensionsSummary       `json:"extensions,omitempty"`
	Statuses          *[]InstanceViewStatus                              `json:"statuses,omitempty"`
}

// VirtualMachineScaleSetInstanceViewStatusesSummary is instance view statuses
// summary for virtual machines of a virtual machine scale set.
type VirtualMachineScaleSetInstanceViewStatusesSummary struct {
	StatusesSummary *[]VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty"`
}

// VirtualMachineScaleSetIPConfiguration is describes a virtual machine scale
// set network profile's IP configuration.
type VirtualMachineScaleSetIPConfiguration struct {
	ID         *string                                          `json:"id,omitempty"`
	Name       *string                                          `json:"name,omitempty"`
	Properties *VirtualMachineScaleSetIPConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetIPConfigurationProperties is describes a virtual
// machine scale set network profile's IP configuration properties.
type VirtualMachineScaleSetIPConfigurationProperties struct {
	Subnet                          *APIEntityReference `json:"subnet,omitempty"`
	LoadBalancerBackendAddressPools *[]SubResource      `json:"loadBalancerBackendAddressPools,omitempty"`
}

// VirtualMachineScaleSetListResult is the List Virtual Machine operation
// response.
type VirtualMachineScaleSetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSet `json:"value,omitempty"`
	NextLink          *string                   `json:",omitempty"`
}

// VirtualMachineScaleSetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetListResult) VirtualMachineScaleSetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetListSkusResult is the Virtual Machine Scale Set List
// Skus operation response.
type VirtualMachineScaleSetListSkusResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSetSku `json:"value,omitempty"`
	NextLink          *string                      `json:",omitempty"`
}

// VirtualMachineScaleSetListSkusResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetListSkusResult) VirtualMachineScaleSetListSkusResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetListWithLinkResult is the List Virtual Machine
// operation response.
type VirtualMachineScaleSetListWithLinkResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSet `json:"value,omitempty"`
	NextLink          *string                   `json:"nextLink,omitempty"`
}

// VirtualMachineScaleSetListWithLinkResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetListWithLinkResult) VirtualMachineScaleSetListWithLinkResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetNetworkConfiguration is describes a virtual machine
// scale set network profile's network configurations.
type VirtualMachineScaleSetNetworkConfiguration struct {
	ID         *string                                               `json:"id,omitempty"`
	Name       *string                                               `json:"name,omitempty"`
	Properties *VirtualMachineScaleSetNetworkConfigurationProperties `json:"properties,omitempty"`
}

// VirtualMachineScaleSetNetworkConfigurationProperties is describes a virtual
// machine scale set network profile's IP configuration.
type VirtualMachineScaleSetNetworkConfigurationProperties struct {
	Primary          *bool                                    `json:"primary,omitempty"`
	IPConfigurations *[]VirtualMachineScaleSetIPConfiguration `json:"ipConfigurations,omitempty"`
}

// VirtualMachineScaleSetNetworkProfile is describes a virtual machine scale
// set network profile.
type VirtualMachineScaleSetNetworkProfile struct {
	NetworkInterfaceConfigurations *[]VirtualMachineScaleSetNetworkConfiguration `json:"networkInterfaceConfigurations,omitempty"`
}

// VirtualMachineScaleSetOSDisk is describes a virtual machine scale set
// operating system disk.
type VirtualMachineScaleSetOSDisk struct {
	Name          *string               `json:"name,omitempty"`
	Caching       CachingTypes          `json:"caching,omitempty"`
	CreateOption  DiskCreateOptionTypes `json:"createOption,omitempty"`
	OsType        OperatingSystemTypes  `json:"osType,omitempty"`
	Image         *VirtualHardDisk      `json:"image,omitempty"`
	VhdContainers *[]string             `json:"vhdContainers,omitempty"`
}

// VirtualMachineScaleSetOSProfile is describes a virtual machine scale set OS
// profile.
type VirtualMachineScaleSetOSProfile struct {
	ComputerNamePrefix   *string               `json:"computerNamePrefix,omitempty"`
	AdminUsername        *string               `json:"adminUsername,omitempty"`
	AdminPassword        *string               `json:"adminPassword,omitempty"`
	CustomData           *string               `json:"customData,omitempty"`
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	LinuxConfiguration   *LinuxConfiguration   `json:"linuxConfiguration,omitempty"`
	Secrets              *[]VaultSecretGroup   `json:"secrets,omitempty"`
}

// VirtualMachineScaleSetProperties is describes the properties of a Virtual
// Machine Scale Set.
type VirtualMachineScaleSetProperties struct {
	UpgradePolicy         *UpgradePolicy                   `json:"upgradePolicy,omitempty"`
	VirtualMachineProfile *VirtualMachineScaleSetVMProfile `json:"virtualMachineProfile,omitempty"`
	ProvisioningState     *string                          `json:"provisioningState,omitempty"`
}

// VirtualMachineScaleSetSku is describes an available virtual machine scale
// set sku.
type VirtualMachineScaleSetSku struct {
	ResourceType *string                            `json:"resourceType,omitempty"`
	Sku          *Sku                               `json:"sku,omitempty"`
	Capacity     *VirtualMachineScaleSetSkuCapacity `json:"capacity,omitempty"`
}

// VirtualMachineScaleSetSkuCapacity is describes scaling information of a sku.
type VirtualMachineScaleSetSkuCapacity struct {
	Minimum         *int32                             `json:"minimum,omitempty"`
	Maximum         *int32                             `json:"maximum,omitempty"`
	DefaultCapacity *int32                             `json:"defaultCapacity,omitempty"`
	ScaleType       VirtualMachineScaleSetSkuScaleType `json:"scaleType,omitempty"`
}

// VirtualMachineScaleSetStorageProfile is describes a virtual machine scale
// set storage profile.
type VirtualMachineScaleSetStorageProfile struct {
	ImageReference *ImageReference               `json:"imageReference,omitempty"`
	OsDisk         *VirtualMachineScaleSetOSDisk `json:"osDisk,omitempty"`
}

// VirtualMachineScaleSetVM is describes a virtual machine scale set virtual
// machine.
type VirtualMachineScaleSetVM struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Tags              *map[string]*string                 `json:"tags,omitempty"`
	InstanceID        *string                             `json:"instanceId,omitempty"`
	Sku               *Sku                                `json:"sku,omitempty"`
	Properties        *VirtualMachineScaleSetVMProperties `json:"properties,omitempty"`
	Plan              *Plan                               `json:"plan,omitempty"`
	Resources         *[]VirtualMachineExtension          `json:"resources,omitempty"`
}

// VirtualMachineScaleSetVMExtensionsSummary is extensions summary for virtual
// machines of a virtual machine scale set.
type VirtualMachineScaleSetVMExtensionsSummary struct {
	Name            *string                          `json:"name,omitempty"`
	StatusesSummary *[]VirtualMachineStatusCodeCount `json:"statusesSummary,omitempty"`
}

// VirtualMachineScaleSetVMInstanceIDs is specifies the list of virtual
// machine scale set instance IDs.
type VirtualMachineScaleSetVMInstanceIDs struct {
	InstanceIds *[]string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceRequiredIDs is specifies the list of
// virtual machine scale set instance IDs.
type VirtualMachineScaleSetVMInstanceRequiredIDs struct {
	InstanceIds *[]string `json:"instanceIds,omitempty"`
}

// VirtualMachineScaleSetVMInstanceView is the instance view of a virtual
// machine scale set VM.
type VirtualMachineScaleSetVMInstanceView struct {
	autorest.Response    `json:"-"`
	PlatformUpdateDomain *int                                   `json:"platformUpdateDomain,omitempty"`
	PlatformFaultDomain  *int                                   `json:"platformFaultDomain,omitempty"`
	RdpThumbPrint        *string                                `json:"rdpThumbPrint,omitempty"`
	VMAgent              *VirtualMachineAgentInstanceView       `json:"vmAgent,omitempty"`
	Disks                *[]DiskInstanceView                    `json:"disks,omitempty"`
	Extensions           *[]VirtualMachineExtensionInstanceView `json:"extensions,omitempty"`
	BootDiagnostics      *BootDiagnosticsInstanceView           `json:"bootDiagnostics,omitempty"`
	Statuses             *[]InstanceViewStatus                  `json:"statuses,omitempty"`
}

// VirtualMachineScaleSetVMListResult is the List Virtual Machine Scale Set
// VMs operation response.
type VirtualMachineScaleSetVMListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineScaleSetVM `json:"value,omitempty"`
	NextLink          *string                     `json:",omitempty"`
}

// VirtualMachineScaleSetVMListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineScaleSetVMListResult) VirtualMachineScaleSetVMListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineScaleSetVMProfile is describes a virtual machine scale set
// virtual machine profile.
type VirtualMachineScaleSetVMProfile struct {
	OsProfile        *VirtualMachineScaleSetOSProfile        `json:"osProfile,omitempty"`
	StorageProfile   *VirtualMachineScaleSetStorageProfile   `json:"storageProfile,omitempty"`
	NetworkProfile   *VirtualMachineScaleSetNetworkProfile   `json:"networkProfile,omitempty"`
	ExtensionProfile *VirtualMachineScaleSetExtensionProfile `json:"extensionProfile,omitempty"`
}

// VirtualMachineScaleSetVMProperties is describes the properties of a virtual
// machine scale set virtual machine.
type VirtualMachineScaleSetVMProperties struct {
	LatestModelApplied *bool                       `json:"latestModelApplied,omitempty"`
	InstanceView       *VirtualMachineInstanceView `json:"instanceView,omitempty"`
	HardwareProfile    *HardwareProfile            `json:"hardwareProfile,omitempty"`
	StorageProfile     *StorageProfile             `json:"storageProfile,omitempty"`
	OsProfile          *OSProfile                  `json:"osProfile,omitempty"`
	NetworkProfile     *NetworkProfile             `json:"networkProfile,omitempty"`
	DiagnosticsProfile *DiagnosticsProfile         `json:"diagnosticsProfile,omitempty"`
	AvailabilitySet    *SubResource                `json:"availabilitySet,omitempty"`
	ProvisioningState  *string                     `json:"provisioningState,omitempty"`
}

// VirtualMachineSize is describes the properties of a VM size.
type VirtualMachineSize struct {
	Name                 *string `json:"name,omitempty"`
	NumberOfCores        *int    `json:"numberOfCores,omitempty"`
	OsDiskSizeInMB       *int    `json:"osDiskSizeInMB,omitempty"`
	ResourceDiskSizeInMB *int    `json:"resourceDiskSizeInMB,omitempty"`
	MemoryInMB           *int    `json:"memoryInMB,omitempty"`
	MaxDataDiskCount     *int    `json:"maxDataDiskCount,omitempty"`
}

// VirtualMachineSizeListResult is the List Virtual Machine operation response.
type VirtualMachineSizeListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualMachineSize `json:"value,omitempty"`
	NextLink          *string               `json:",omitempty"`
}

// VirtualMachineSizeListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualMachineSizeListResult) VirtualMachineSizeListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualMachineStatusCodeCount is the status code and count of the virtual
// machine scale set instance view status summary.
type VirtualMachineStatusCodeCount struct {
	Code  *string `json:"code,omitempty"`
	Count *int    `json:"count,omitempty"`
}

// WindowsConfiguration is describes Windows Configuration of the OS Profile.
type WindowsConfiguration struct {
	ProvisionVMAgent          *bool                        `json:"provisionVMAgent,omitempty"`
	EnableAutomaticUpdates    *bool                        `json:"enableAutomaticUpdates,omitempty"`
	TimeZone                  *string                      `json:"timeZone,omitempty"`
	AdditionalUnattendContent *[]AdditionalUnattendContent `json:"additionalUnattendContent,omitempty"`
	WinRM                     *WinRMConfiguration          `json:"winRM,omitempty"`
}

// WinRMConfiguration is describes Windows Remote Management configuration of
// the VM
type WinRMConfiguration struct {
	Listeners *[]WinRMListener `json:"listeners,omitempty"`
}

// WinRMListener is describes Protocol and thumbprint of Windows Remote
// Management listener
type WinRMListener struct {
	Protocol       ProtocolTypes `json:"protocol,omitempty"`
	CertificateURL *string       `json:"certificateUrl,omitempty"`
}
