// Code is generated by ucloud-model, DO NOT EDIT IT.

package vpc

/*
IpInfo -
*/
type IpInfo struct {

	//
	Gateway string

	//
	Ip string

	//
	Mac string

	//
	Mask string

	//
	SubnetId string

	//
	VPCId string
}

/*
VIPSet - VIPSet
*/
type VIPSet struct {

	// 虚拟ip
	VIP string

	// 虚拟ip id
	VIPId string

	// VPC id
	VPCId string
}

/*
AssociationInfo - 绑定信息
*/
type AssociationInfo struct {

	// ACL的ID
	AclId string

	// 绑定ID
	AssociationId string

	// 创建的Unix时间戳
	CreateTime int

	// 绑定的子网ID
	SubnetworkId string

	// 所属的VPC ID
	VpcId string
}

/*
NatGWIPResInfo - IP信息
*/
type NatGWIPResInfo struct {

	// 外网IP
	EIP string

	// IP的运营商信息
	OperatorName string
}

/*
NatGatewaySubnetSet - natgw里面的子网信息
*/
type NatGatewaySubnetSet struct {

	// 子网网段
	Subnet string

	// 子网名字
	SubnetName string

	// 子网id
	SubnetworkId string
}

/*
NatGatewayIPSet - IPSet信息
*/
type NatGatewayIPSet struct {

	// 带宽
	Bandwidth int

	// EIP带宽类型
	BandwidthType string

	// 外网IP的 EIPId
	EIPId string

	// 外网IP信息
	IPResInfo []NatGWIPResInfo

	// 权重为100的为出口
	Weight int
}

/*
NatGatewayDataSet - natgw的信息
*/
type NatGatewayDataSet struct {

	// natgw创建时间
	CreateTime int

	// 绑定的防火墙Id
	FirewallId string

	// 绑定的EIP 信息
	IPSet []NatGatewayIPSet

	// natgw id
	NATGWId string

	// natgw名称
	NATGWName string

	// 转发策略Id
	PolicyId []string

	// 备注
	Remark string

	// 子网 Id
	SubnetSet []NatGatewaySubnetSet

	// 业务组
	Tag string

	// 所属VPC Id
	VPCId string

	// 所属VPC 信息
	VPCInfo string
}

/*
NATGWPolicyDataSet - DescribeNATGWPolicy
*/
type NATGWPolicyDataSet struct {

	// 目的地址
	DstIP string

	// 目的端口
	DstPort string

	// NAT网关Id
	NATGWId string

	// 转发策略Id
	PolicyId string

	// 转发策略名称
	PolicyName string

	// 协议类型
	Protocol string

	// 端口转发前端EIP
	SrcEIP string

	// 端口转发前端EIP Id
	SrcEIPId string

	// 源端口
	SrcPort string
}

/*
TargetResourceInfo - ACL规则应用目标资源信息。
*/
type TargetResourceInfo struct {

	// 资源内网IP
	PrivateIP string

	// 资源ID
	ResourceId string

	// 资源名称
	ResourceName string

	// 资源类型
	ResourceType int

	// 资源绑定的虚拟网卡的ID
	SubResourceId string

	// 资源绑定的虚拟网卡的名称
	SubResourceName string

	// 资源绑定虚拟网卡的类型
	SubResourceType int

	// 子网ID
	SubnetworkId string
}

/*
AclEntryInfo - Entry的详细信息
*/
type AclEntryInfo struct {

	// IP段的CIDR信息
	CidrBlock string

	// 创建的Unix时间戳
	CreateTime int

	// 出向或者入向
	Direction string

	// 匹配规则的动作
	EntryAction string

	// Entry的ID
	EntryId string

	// 针对的IP协议
	IpProtocol string

	// Port的段信息
	PortRange string

	// 优先级
	Priority string

	// 应用目标资源数量。TargetType为0时不返回该值。
	TargetResourceCount int

	// 应用目标资源信息。TargetType为0时不返回该值。具体结构见下方TargetResourceInfo
	TargetResourceList []TargetResourceInfo

	// 应用目标类型。 0代表“子网内全部资源” ，1代表“子网内指定资源” 。
	TargetType int

	// 更改的Unix时间戳
	UpdateTime int
}

/*
AclInfo - Acl的基础信息
*/
type AclInfo struct {

	// ACL的ID
	AclId string

	// 名称
	AclName string

	// 所有的绑定关系，具体结构见下方AssociationInfo
	Associations []AssociationInfo

	// 创建的Unix时间戳
	CreateTime int

	// 描述
	Description string

	// 所有的规则
	Entries []AclEntryInfo

	// 更改的Unix时间戳
	UpdateTime int

	// ACL所属的VPC ID
	VpcId string
}

/*
RouteRuleInfo - 路由规则信息
*/
type RouteRuleInfo struct {

	// 项目ID信息
	AccountId int

	// 目的地址
	DstAddr string

	// 保留字段，暂未使用
	DstPort int

	// 路由下一跳资源ID
	NexthopId string

	// 路由表下一跳类型。LOCAL，本VPC内部通信路由；PUBLIC，公共服务路由；CNAT，外网路由；UDPN，跨域高速通道路由；HYBRIDGW，混合云路由；INSTANCE，实例路由；VNET，VPC联通路由；IPSEC VPN，指向VPN网关的路由。
	NexthopType string

	// 保留字段，暂未使用
	OriginAddr string

	// 保留字段，暂未使用
	Priority int

	// 路由规则备注
	Remark string

	// 规则ID
	RouteRuleId string

	// 路由表资源ID
	RouteTableId string

	// 路由规则类型。0，系统路由规则；1，自定义路由规则
	RuleType int

	// 保留字段，暂未使用
	SrcAddr string

	// 保留字段，暂未使用
	SrcPort int

	// 所属的VPC
	VNetId string
}

/*
RouteTableInfo - 路由表信息
*/
type RouteTableInfo struct {

	// 创建时间戳
	CreateTime int

	// 路由表备注
	Remark string

	// 路由规则
	RouteRules []RouteRuleInfo

	// 路由表资源ID
	RouteTableId string

	// 路由表类型。1为默认路由表，0为自定义路由表
	RouteTableType int

	// 绑定该路由表的子网数量
	SubnetCount int

	// 路由表所属业务组
	Tag string

	// 路由表所属的VPC资源ID
	VPCId string

	// 路由表所属的VPC资源名称
	VPCName string
}

/*
VPCSubnetInfoSet - 子网信息
*/
type VPCSubnetInfoSet struct {
	// 名称 【已废弃】
	Name string `deprecated:"true"`

	// 虚拟路由 id【已废弃】
	VRouterId string `deprecated:"true"`

	// 可用IP数量
	AvailableIPs int

	// 创建时间
	CreateTime int

	// 子网网关
	Gateway string

	// 是否有natgw
	HasNATGW bool

	// 子网关联的IPv6网段
	IPv6Network string

	// 子网掩码
	Netmask string

	// 备注
	Remark string

	// 路由表Id
	RouteTableId string

	// 子网网段
	Subnet string

	// 子网Id
	SubnetId string

	// 子网名称
	SubnetName string

	// 子网类型
	SubnetType int

	// 业务组
	Tag string

	// VPCId
	VPCId string

	// VPC名称
	VPCName string

	// 可用区名称
	Zone string
}

/*
ResourceInfo - 子网下资源
*/
type ResourceInfo struct {

	// 资源ip
	IP string

	// 名称
	Name string

	// 资源Id
	ResourceId string

	// 资源类型。对应的资源类型：UHOST，云主机；PHOST，物理云主机；ULB，负载均衡；UHADOOP_HOST，hadoop节点；UFORTRESS_HOST，堡垒机；UNATGW，NAT网关；UKAFKA，分布式消息系统；UMEM，内存存储；DOCKER，容器集群；UDB，数据库；UDW，数据仓库；VIP，内网VIP.
	ResourceType string
}

/*
VIPDetailSet - VIPDetailSet
*/
type VIPDetailSet struct {

	// 创建时间
	CreateTime int

	// VIP名称
	Name string

	// 真实主机ip
	RealIp string

	// VIP备注
	Remark string

	// 子网id
	SubnetId string

	// VIP所属业务组
	Tag string

	// 虚拟ip
	VIP string

	// 虚拟ip id
	VIPId string

	// VPC id
	VPCId string

	// 地域
	Zone string
}

/*
VPCNetworkInfo - vpc地址空间信息
*/
type VPCNetworkInfo struct {

	// vpc地址空间
	Network string

	// 地址空间中子网数量
	SubnetCount int
}

/*
VPCInfo - VPC信息
*/
type VPCInfo struct {

	//
	CreateTime int

	// VPC关联的IPv6网段
	IPv6Network string

	//
	Name string

	//
	Network []string

	//
	NetworkInfo []VPCNetworkInfo

	// VPC关联的IPv6网段所属运营商
	OperatorName string

	//
	SubnetCount int

	//
	Tag string

	//
	UpdateTime int

	// VPCId
	VPCId string
}

/*
VPCIntercomInfo -
*/
type VPCIntercomInfo struct {

	// 所属地域
	DstRegion string

	// VPC名字
	Name string

	// VPC的地址空间
	Network []string

	// 项目Id
	ProjectId string

	// 业务组（未分组显示为 Default）
	Tag string

	// VPCId
	VPCId string
}

/*
DescribeWhiteListResourceObjectIPInfo - DescribeWhiteListResource
*/
type DescribeWhiteListResourceObjectIPInfo struct {

	// natgw字符串
	GwType string

	// 白名单资源的内网IP
	PrivateIP string

	// 白名单资源Id信息
	ResourceId string

	// 白名单资源名称
	ResourceName string

	// 白名单资源类型
	ResourceType string

	// 资源绑定的虚拟网卡的实例ID
	SubResourceId string

	// 资源绑定的虚拟网卡的实例名称
	SubResourceName string

	// 资源绑定的虚拟网卡的类型
	SubResourceType string

	// 白名单资源所属VPCId
	VPCId string
}

/*
NatGWWhitelistDataSet - nat网关白名单数据
*/
type NatGWWhitelistDataSet struct {

	// 白名单开关标记
	IfOpen int

	// NATGateWay Id
	NATGWId string

	// 白名单详情
	ObjectIPInfo []DescribeWhiteListResourceObjectIPInfo
}

/*
GetAvailableResourceForPolicyDataSet - GetAvailableResourceForPolicy
*/
type GetAvailableResourceForPolicyDataSet struct {

	// 资源对应的内网Ip
	PrivateIP string

	// 资源的Id
	ResourceId string

	// 资源类型。"uhost"：云主机； "upm"，物理云主机； "hadoophost"：hadoop节点； "fortresshost"：堡垒机： "udockhost"，容器
	ResourceType string
}

/*
GetAvailableResourceForWhiteListDataSet - GetAvailableResourceForWhiteList
*/
type GetAvailableResourceForWhiteListDataSet struct {

	// 资源的内网Ip
	PrivateIP string

	// 资源类型Id
	ResourceId string

	// 资源名称
	ResourceName string

	// 资源类型。"uhost"：云主机； "upm"，物理云主机； "hadoophost"：hadoop节点； "fortresshost"：堡垒机： "udockhost"，容器
	ResourceType string

	// 资源绑定的虚拟网卡的实例ID
	SubResouceId string

	// 资源绑定的虚拟网卡的实例类型
	SubResouceType string

	// 资源绑定的虚拟网卡的实例名称
	SubResourceName string

	// 资源所属子网Id
	SubnetworkId string

	// 资源所属VPCId
	VPCId string
}

/*
NatgwSubnetDataSet - natgw可以绑定的子网
*/
type NatgwSubnetDataSet struct {

	// 是否绑定NATGW
	HasNATGW bool

	// 掩码
	Netmask string

	// 子网网段
	Subnet string

	// 子网id
	SubnetId string

	// 子网名字
	SubnetName string
}
