// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/instance.proto

package compute

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type IpVersion int32

const (
	IpVersion_IP_VERSION_UNSPECIFIED IpVersion = 0
	// IPv4 address, for example 192.0.2.235.
	IpVersion_IPV4 IpVersion = 1
	// IPv6 address. Not available yet.
	IpVersion_IPV6 IpVersion = 2
)

var IpVersion_name = map[int32]string{
	0: "IP_VERSION_UNSPECIFIED",
	1: "IPV4",
	2: "IPV6",
}

var IpVersion_value = map[string]int32{
	"IP_VERSION_UNSPECIFIED": 0,
	"IPV4":                   1,
	"IPV6":                   2,
}

func (x IpVersion) String() string {
	return proto.EnumName(IpVersion_name, int32(x))
}

func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{0}
}

type Instance_Status int32

const (
	Instance_STATUS_UNSPECIFIED Instance_Status = 0
	// Instance is waiting for resources to be allocated.
	Instance_PROVISIONING Instance_Status = 1
	// Instance is running normally.
	Instance_RUNNING Instance_Status = 2
	// Instance is being stopped.
	Instance_STOPPING Instance_Status = 3
	// Instance stopped.
	Instance_STOPPED Instance_Status = 4
	// Instance is being started.
	Instance_STARTING Instance_Status = 5
	// Instance is being restarted.
	Instance_RESTARTING Instance_Status = 6
	// Instance is being updated.
	Instance_UPDATING Instance_Status = 7
	// Instance encountered a problem and cannot operate.
	Instance_ERROR Instance_Status = 8
	// Instance crashed and will be restarted automatically.
	Instance_CRASHED Instance_Status = 9
	// Instance is being deleted.
	Instance_DELETING Instance_Status = 10
)

var Instance_Status_name = map[int32]string{
	0:  "STATUS_UNSPECIFIED",
	1:  "PROVISIONING",
	2:  "RUNNING",
	3:  "STOPPING",
	4:  "STOPPED",
	5:  "STARTING",
	6:  "RESTARTING",
	7:  "UPDATING",
	8:  "ERROR",
	9:  "CRASHED",
	10: "DELETING",
}

var Instance_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"STOPPING":           3,
	"STOPPED":            4,
	"STARTING":           5,
	"RESTARTING":         6,
	"UPDATING":           7,
	"ERROR":              8,
	"CRASHED":            9,
	"DELETING":           10,
}

func (x Instance_Status) String() string {
	return proto.EnumName(Instance_Status_name, int32(x))
}

func (Instance_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{0, 0}
}

type AttachedDisk_Mode int32

const (
	AttachedDisk_MODE_UNSPECIFIED AttachedDisk_Mode = 0
	// Read-only access.
	AttachedDisk_READ_ONLY AttachedDisk_Mode = 1
	// Read/Write access.
	AttachedDisk_READ_WRITE AttachedDisk_Mode = 2
)

var AttachedDisk_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "READ_ONLY",
	2: "READ_WRITE",
}

var AttachedDisk_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED": 0,
	"READ_ONLY":        1,
	"READ_WRITE":       2,
}

func (x AttachedDisk_Mode) String() string {
	return proto.EnumName(AttachedDisk_Mode_name, int32(x))
}

func (AttachedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{2, 0}
}

type NetworkSettings_Type int32

const (
	NetworkSettings_TYPE_UNSPECIFIED NetworkSettings_Type = 0
	// Standard network.
	NetworkSettings_STANDARD NetworkSettings_Type = 1
	// Software accelerated network.
	NetworkSettings_SOFTWARE_ACCELERATED NetworkSettings_Type = 2
	// Hardware accelerated network (not available yet, reserved for future use).
	NetworkSettings_HARDWARE_ACCELERATED NetworkSettings_Type = 3
)

var NetworkSettings_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "STANDARD",
	2: "SOFTWARE_ACCELERATED",
	3: "HARDWARE_ACCELERATED",
}

var NetworkSettings_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":     0,
	"STANDARD":             1,
	"SOFTWARE_ACCELERATED": 2,
	"HARDWARE_ACCELERATED": 3,
}

func (x NetworkSettings_Type) String() string {
	return proto.EnumName(NetworkSettings_Type_name, int32(x))
}

func (NetworkSettings_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{7, 0}
}

// An Instance resource. For more information, see [Instances](/docs/compute/concepts/vm).
type Instance struct {
	// ID of the instance.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the instance belongs to.
	FolderId  string               `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the instance. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs. Maximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the availability zone where the instance resides.
	ZoneId string `protobuf:"bytes,7,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the hardware platform configuration for the instance.
	PlatformId string `protobuf:"bytes,8,opt,name=platform_id,json=platformId,proto3" json:"platform_id,omitempty"`
	// Computing resources of the instance such as the amount of memory and number of cores.
	Resources *Resources `protobuf:"bytes,9,opt,name=resources,proto3" json:"resources,omitempty"`
	// Status of the instance.
	Status Instance_Status `protobuf:"varint,10,opt,name=status,proto3,enum=yandex.cloud.compute.v1.Instance_Status" json:"status,omitempty"`
	// The metadata `key:value` pairs assigned to this instance. This includes custom metadata and predefined keys.
	//
	// For example, you may use the metadata in order to provide your public SSH key to the instance.
	// For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
	Metadata map[string]string `protobuf:"bytes,11,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Boot disk that is attached to the instance.
	BootDisk *AttachedDisk `protobuf:"bytes,12,opt,name=boot_disk,json=bootDisk,proto3" json:"boot_disk,omitempty"`
	// Array of secondary disks that are attached to the instance.
	SecondaryDisks []*AttachedDisk `protobuf:"bytes,13,rep,name=secondary_disks,json=secondaryDisks,proto3" json:"secondary_disks,omitempty"`
	// Array of network interfaces that are attached to the instance.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,14,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// A domain name of the instance. FQDN is defined by the server
	// in the format `<hostname>.<region_id>.internal` when the instance is created.
	// If the hostname were not specified when the instance was created, FQDN would be `<id>.auto.internal`.
	Fqdn string `protobuf:"bytes,16,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
	// Scheduling policy configuration.
	SchedulingPolicy *SchedulingPolicy `protobuf:"bytes,17,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
	// ID of the service account to use for [authentication inside the instance](/docs/compute/operations/vm-connect/auth-inside-vm).
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	ServiceAccountId string `protobuf:"bytes,18,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Network Settings
	NetworkSettings *NetworkSettings `protobuf:"bytes,19,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// Placement policy configuration.
	PlacementPolicy      *PlacementPolicy `protobuf:"bytes,20,opt,name=placement_policy,json=placementPolicy,proto3" json:"placement_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{0}
}

func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (m *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(m, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Instance) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Instance) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Instance) GetPlatformId() string {
	if m != nil {
		return m.PlatformId
	}
	return ""
}

func (m *Instance) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Instance) GetStatus() Instance_Status {
	if m != nil {
		return m.Status
	}
	return Instance_STATUS_UNSPECIFIED
}

func (m *Instance) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Instance) GetBootDisk() *AttachedDisk {
	if m != nil {
		return m.BootDisk
	}
	return nil
}

func (m *Instance) GetSecondaryDisks() []*AttachedDisk {
	if m != nil {
		return m.SecondaryDisks
	}
	return nil
}

func (m *Instance) GetNetworkInterfaces() []*NetworkInterface {
	if m != nil {
		return m.NetworkInterfaces
	}
	return nil
}

func (m *Instance) GetFqdn() string {
	if m != nil {
		return m.Fqdn
	}
	return ""
}

func (m *Instance) GetSchedulingPolicy() *SchedulingPolicy {
	if m != nil {
		return m.SchedulingPolicy
	}
	return nil
}

func (m *Instance) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *Instance) GetNetworkSettings() *NetworkSettings {
	if m != nil {
		return m.NetworkSettings
	}
	return nil
}

func (m *Instance) GetPlacementPolicy() *PlacementPolicy {
	if m != nil {
		return m.PlacementPolicy
	}
	return nil
}

type Resources struct {
	// The amount of memory available to the instance, specified in bytes.
	Memory int64 `protobuf:"varint,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// The number of cores available to the instance.
	Cores int64 `protobuf:"varint,2,opt,name=cores,proto3" json:"cores,omitempty"`
	// Baseline level of CPU performance with the ability to burst performance above that baseline level.
	// This field sets baseline performance for each core.
	CoreFraction int64 `protobuf:"varint,3,opt,name=core_fraction,json=coreFraction,proto3" json:"core_fraction,omitempty"`
	// The number of GPUs available to the instance.
	Gpus                 int64    `protobuf:"varint,4,opt,name=gpus,proto3" json:"gpus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{1}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetMemory() int64 {
	if m != nil {
		return m.Memory
	}
	return 0
}

func (m *Resources) GetCores() int64 {
	if m != nil {
		return m.Cores
	}
	return 0
}

func (m *Resources) GetCoreFraction() int64 {
	if m != nil {
		return m.CoreFraction
	}
	return 0
}

func (m *Resources) GetGpus() int64 {
	if m != nil {
		return m.Gpus
	}
	return 0
}

type AttachedDisk struct {
	// Access mode to the Disk resource.
	Mode AttachedDisk_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=yandex.cloud.compute.v1.AttachedDisk_Mode" json:"mode,omitempty"`
	// Serial number that is reflected into the /dev/disk/by-id/ tree
	// of a Linux operating system running within the instance.
	//
	// This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
	DeviceName string `protobuf:"bytes,2,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Specifies whether the disk will be auto-deleted when the instance is deleted.
	AutoDelete bool `protobuf:"varint,3,opt,name=auto_delete,json=autoDelete,proto3" json:"auto_delete,omitempty"`
	// ID of the disk that is attached to the instance.
	DiskId               string   `protobuf:"bytes,4,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachedDisk) Reset()         { *m = AttachedDisk{} }
func (m *AttachedDisk) String() string { return proto.CompactTextString(m) }
func (*AttachedDisk) ProtoMessage()    {}
func (*AttachedDisk) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{2}
}

func (m *AttachedDisk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachedDisk.Unmarshal(m, b)
}
func (m *AttachedDisk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachedDisk.Marshal(b, m, deterministic)
}
func (m *AttachedDisk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachedDisk.Merge(m, src)
}
func (m *AttachedDisk) XXX_Size() int {
	return xxx_messageInfo_AttachedDisk.Size(m)
}
func (m *AttachedDisk) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachedDisk.DiscardUnknown(m)
}

var xxx_messageInfo_AttachedDisk proto.InternalMessageInfo

func (m *AttachedDisk) GetMode() AttachedDisk_Mode {
	if m != nil {
		return m.Mode
	}
	return AttachedDisk_MODE_UNSPECIFIED
}

func (m *AttachedDisk) GetDeviceName() string {
	if m != nil {
		return m.DeviceName
	}
	return ""
}

func (m *AttachedDisk) GetAutoDelete() bool {
	if m != nil {
		return m.AutoDelete
	}
	return false
}

func (m *AttachedDisk) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type NetworkInterface struct {
	// The index of the network interface, generated by the server, 0,1,2... etc.
	// Currently only one network interface is supported per instance.
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// MAC address that is assigned to the network interface.
	MacAddress string `protobuf:"bytes,2,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// ID of the subnet.
	SubnetId string `protobuf:"bytes,3,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Primary IPv4 address that is assigned to the instance for this network interface.
	PrimaryV4Address *PrimaryAddress `protobuf:"bytes,4,opt,name=primary_v4_address,json=primaryV4Address,proto3" json:"primary_v4_address,omitempty"`
	// Primary IPv6 address that is assigned to the instance for this network interface. IPv6 not available yet.
	PrimaryV6Address *PrimaryAddress `protobuf:"bytes,5,opt,name=primary_v6_address,json=primaryV6Address,proto3" json:"primary_v6_address,omitempty"`
	// ID's of security groups attached to the interface
	SecurityGroupIds     []string `protobuf:"bytes,6,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkInterface) Reset()         { *m = NetworkInterface{} }
func (m *NetworkInterface) String() string { return proto.CompactTextString(m) }
func (*NetworkInterface) ProtoMessage()    {}
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{3}
}

func (m *NetworkInterface) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkInterface.Unmarshal(m, b)
}
func (m *NetworkInterface) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkInterface.Marshal(b, m, deterministic)
}
func (m *NetworkInterface) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterface.Merge(m, src)
}
func (m *NetworkInterface) XXX_Size() int {
	return xxx_messageInfo_NetworkInterface.Size(m)
}
func (m *NetworkInterface) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterface.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterface proto.InternalMessageInfo

func (m *NetworkInterface) GetIndex() string {
	if m != nil {
		return m.Index
	}
	return ""
}

func (m *NetworkInterface) GetMacAddress() string {
	if m != nil {
		return m.MacAddress
	}
	return ""
}

func (m *NetworkInterface) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *NetworkInterface) GetPrimaryV4Address() *PrimaryAddress {
	if m != nil {
		return m.PrimaryV4Address
	}
	return nil
}

func (m *NetworkInterface) GetPrimaryV6Address() *PrimaryAddress {
	if m != nil {
		return m.PrimaryV6Address
	}
	return nil
}

func (m *NetworkInterface) GetSecurityGroupIds() []string {
	if m != nil {
		return m.SecurityGroupIds
	}
	return nil
}

type PrimaryAddress struct {
	// An IPv4 internal network address that is assigned to the instance for this network interface.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// One-to-one NAT configuration. If missing, NAT has not been set up.
	OneToOneNat          *OneToOneNat `protobuf:"bytes,2,opt,name=one_to_one_nat,json=oneToOneNat,proto3" json:"one_to_one_nat,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PrimaryAddress) Reset()         { *m = PrimaryAddress{} }
func (m *PrimaryAddress) String() string { return proto.CompactTextString(m) }
func (*PrimaryAddress) ProtoMessage()    {}
func (*PrimaryAddress) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{4}
}

func (m *PrimaryAddress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrimaryAddress.Unmarshal(m, b)
}
func (m *PrimaryAddress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrimaryAddress.Marshal(b, m, deterministic)
}
func (m *PrimaryAddress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimaryAddress.Merge(m, src)
}
func (m *PrimaryAddress) XXX_Size() int {
	return xxx_messageInfo_PrimaryAddress.Size(m)
}
func (m *PrimaryAddress) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimaryAddress.DiscardUnknown(m)
}

var xxx_messageInfo_PrimaryAddress proto.InternalMessageInfo

func (m *PrimaryAddress) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *PrimaryAddress) GetOneToOneNat() *OneToOneNat {
	if m != nil {
		return m.OneToOneNat
	}
	return nil
}

type OneToOneNat struct {
	// An external IP address associated with this instance.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// IP version for the external IP address.
	IpVersion            IpVersion `protobuf:"varint,2,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.compute.v1.IpVersion" json:"ip_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *OneToOneNat) Reset()         { *m = OneToOneNat{} }
func (m *OneToOneNat) String() string { return proto.CompactTextString(m) }
func (*OneToOneNat) ProtoMessage()    {}
func (*OneToOneNat) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{5}
}

func (m *OneToOneNat) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OneToOneNat.Unmarshal(m, b)
}
func (m *OneToOneNat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OneToOneNat.Marshal(b, m, deterministic)
}
func (m *OneToOneNat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OneToOneNat.Merge(m, src)
}
func (m *OneToOneNat) XXX_Size() int {
	return xxx_messageInfo_OneToOneNat.Size(m)
}
func (m *OneToOneNat) XXX_DiscardUnknown() {
	xxx_messageInfo_OneToOneNat.DiscardUnknown(m)
}

var xxx_messageInfo_OneToOneNat proto.InternalMessageInfo

func (m *OneToOneNat) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *OneToOneNat) GetIpVersion() IpVersion {
	if m != nil {
		return m.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

type SchedulingPolicy struct {
	// True for short-lived compute instances. For more information, see [Preemptible VMs](/docs/compute/concepts/preemptible-vm).
	Preemptible          bool     `protobuf:"varint,1,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SchedulingPolicy) Reset()         { *m = SchedulingPolicy{} }
func (m *SchedulingPolicy) String() string { return proto.CompactTextString(m) }
func (*SchedulingPolicy) ProtoMessage()    {}
func (*SchedulingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{6}
}

func (m *SchedulingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SchedulingPolicy.Unmarshal(m, b)
}
func (m *SchedulingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SchedulingPolicy.Marshal(b, m, deterministic)
}
func (m *SchedulingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SchedulingPolicy.Merge(m, src)
}
func (m *SchedulingPolicy) XXX_Size() int {
	return xxx_messageInfo_SchedulingPolicy.Size(m)
}
func (m *SchedulingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_SchedulingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_SchedulingPolicy proto.InternalMessageInfo

func (m *SchedulingPolicy) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

type NetworkSettings struct {
	// Network Type
	Type                 NetworkSettings_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.compute.v1.NetworkSettings_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *NetworkSettings) Reset()         { *m = NetworkSettings{} }
func (m *NetworkSettings) String() string { return proto.CompactTextString(m) }
func (*NetworkSettings) ProtoMessage()    {}
func (*NetworkSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{7}
}

func (m *NetworkSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkSettings.Unmarshal(m, b)
}
func (m *NetworkSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkSettings.Marshal(b, m, deterministic)
}
func (m *NetworkSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkSettings.Merge(m, src)
}
func (m *NetworkSettings) XXX_Size() int {
	return xxx_messageInfo_NetworkSettings.Size(m)
}
func (m *NetworkSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkSettings.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkSettings proto.InternalMessageInfo

func (m *NetworkSettings) GetType() NetworkSettings_Type {
	if m != nil {
		return m.Type
	}
	return NetworkSettings_TYPE_UNSPECIFIED
}

type PlacementPolicy struct {
	// Placement group ID.
	PlacementGroupId     string   `protobuf:"bytes,1,opt,name=placement_group_id,json=placementGroupId,proto3" json:"placement_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PlacementPolicy) Reset()         { *m = PlacementPolicy{} }
func (m *PlacementPolicy) String() string { return proto.CompactTextString(m) }
func (*PlacementPolicy) ProtoMessage()    {}
func (*PlacementPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_212f781fc401ff8e, []int{8}
}

func (m *PlacementPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlacementPolicy.Unmarshal(m, b)
}
func (m *PlacementPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlacementPolicy.Marshal(b, m, deterministic)
}
func (m *PlacementPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlacementPolicy.Merge(m, src)
}
func (m *PlacementPolicy) XXX_Size() int {
	return xxx_messageInfo_PlacementPolicy.Size(m)
}
func (m *PlacementPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_PlacementPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_PlacementPolicy proto.InternalMessageInfo

func (m *PlacementPolicy) GetPlacementGroupId() string {
	if m != nil {
		return m.PlacementGroupId
	}
	return ""
}

func init() {
	proto.RegisterEnum("yandex.cloud.compute.v1.IpVersion", IpVersion_name, IpVersion_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.Instance_Status", Instance_Status_name, Instance_Status_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.AttachedDisk_Mode", AttachedDisk_Mode_name, AttachedDisk_Mode_value)
	proto.RegisterEnum("yandex.cloud.compute.v1.NetworkSettings_Type", NetworkSettings_Type_name, NetworkSettings_Type_value)
	proto.RegisterType((*Instance)(nil), "yandex.cloud.compute.v1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.Instance.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.Instance.MetadataEntry")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.compute.v1.Resources")
	proto.RegisterType((*AttachedDisk)(nil), "yandex.cloud.compute.v1.AttachedDisk")
	proto.RegisterType((*NetworkInterface)(nil), "yandex.cloud.compute.v1.NetworkInterface")
	proto.RegisterType((*PrimaryAddress)(nil), "yandex.cloud.compute.v1.PrimaryAddress")
	proto.RegisterType((*OneToOneNat)(nil), "yandex.cloud.compute.v1.OneToOneNat")
	proto.RegisterType((*SchedulingPolicy)(nil), "yandex.cloud.compute.v1.SchedulingPolicy")
	proto.RegisterType((*NetworkSettings)(nil), "yandex.cloud.compute.v1.NetworkSettings")
	proto.RegisterType((*PlacementPolicy)(nil), "yandex.cloud.compute.v1.PlacementPolicy")
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/instance.proto", fileDescriptor_212f781fc401ff8e)
}

var fileDescriptor_212f781fc401ff8e = []byte{
	// 1270 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xdb, 0x6e, 0xdb, 0x46,
	0x13, 0xfe, 0x75, 0xb0, 0x2c, 0x8d, 0x6c, 0x99, 0xd9, 0xdf, 0x48, 0x08, 0xe7, 0x22, 0x06, 0xff,
	0x43, 0xdd, 0xa0, 0x96, 0x10, 0xd7, 0x08, 0x9a, 0x1a, 0x68, 0xc3, 0x98, 0x4c, 0x42, 0xd4, 0x91,
	0x84, 0x95, 0xec, 0x34, 0xbd, 0x28, 0x41, 0x71, 0xd7, 0x0a, 0x6b, 0x91, 0xcb, 0x72, 0x97, 0x6e,
	0xd5, 0x67, 0xea, 0x65, 0x9f, 0xa0, 0xaf, 0xd0, 0x77, 0xe8, 0x73, 0x14, 0xbb, 0x4b, 0xca, 0xb2,
	0x0a, 0xd5, 0x69, 0xaf, 0xb4, 0x73, 0xfa, 0x66, 0x67, 0x34, 0xf3, 0x2d, 0xe1, 0xff, 0xf3, 0x20,
	0x21, 0xf4, 0xc7, 0x5e, 0x38, 0x63, 0x39, 0xe9, 0x85, 0x2c, 0x4e, 0x73, 0x41, 0x7b, 0xd7, 0x4f,
	0x7a, 0x51, 0xc2, 0x45, 0x90, 0x84, 0xb4, 0x9b, 0x66, 0x4c, 0x30, 0xf4, 0x40, 0xfb, 0x75, 0x95,
	0x5f, 0xb7, 0xf0, 0xeb, 0x5e, 0x3f, 0xd9, 0x7b, 0x34, 0x65, 0x6c, 0x3a, 0xa3, 0x3d, 0xe5, 0x36,
	0xc9, 0x2f, 0x7b, 0x22, 0x8a, 0x29, 0x17, 0x41, 0x9c, 0xea, 0x48, 0xeb, 0x37, 0x80, 0xa6, 0x57,
	0x80, 0xa1, 0x0e, 0x54, 0x23, 0x62, 0x56, 0xf6, 0x2b, 0x07, 0x2d, 0x5c, 0x8d, 0x08, 0x7a, 0x08,
	0xad, 0x4b, 0x36, 0x23, 0x34, 0xf3, 0x23, 0x62, 0x56, 0x95, 0xba, 0xa9, 0x15, 0x1e, 0x41, 0xcf,
	0x00, 0xc2, 0x8c, 0x06, 0x82, 0x12, 0x3f, 0x10, 0x66, 0x6d, 0xbf, 0x72, 0xd0, 0x3e, 0xda, 0xeb,
	0xea, 0x7c, 0xdd, 0x32, 0x5f, 0x77, 0x5c, 0xe6, 0xc3, 0xad, 0xc2, 0xdb, 0x16, 0x08, 0x41, 0x3d,
	0x09, 0x62, 0x6a, 0xd6, 0x15, 0xa4, 0x3a, 0xa3, 0x7d, 0x68, 0x13, 0xca, 0xc3, 0x2c, 0x4a, 0x45,
	0xc4, 0x12, 0x73, 0x43, 0x99, 0x96, 0x55, 0xc8, 0x85, 0xc6, 0x2c, 0x98, 0xd0, 0x19, 0x37, 0x1b,
	0xfb, 0xb5, 0x83, 0xf6, 0xd1, 0x61, 0x77, 0x4d, 0xd5, 0xdd, 0xb2, 0xa0, 0xee, 0x99, 0xf2, 0x77,
	0x13, 0x91, 0xcd, 0x71, 0x11, 0x8c, 0x1e, 0xc0, 0xe6, 0x4f, 0x2c, 0xa1, 0xb2, 0xa4, 0x4d, 0x95,
	0xa4, 0x21, 0x45, 0x8f, 0xa0, 0x47, 0xd0, 0x4e, 0x67, 0x81, 0xb8, 0x64, 0x59, 0x2c, 0x8d, 0x4d,
	0x65, 0x84, 0x52, 0xe5, 0x11, 0xf4, 0x1c, 0x5a, 0x19, 0xe5, 0x2c, 0xcf, 0x42, 0xca, 0xcd, 0x96,
	0x2a, 0xd8, 0x5a, 0x7b, 0x07, 0x5c, 0x7a, 0xe2, 0x9b, 0x20, 0xf4, 0x1c, 0x1a, 0x5c, 0x04, 0x22,
	0xe7, 0x26, 0xec, 0x57, 0x0e, 0x3a, 0x47, 0x07, 0x77, 0x97, 0x30, 0x52, 0xfe, 0xb8, 0x88, 0x43,
	0x5f, 0x41, 0x33, 0xa6, 0x22, 0x20, 0x81, 0x08, 0xcc, 0xb6, 0x6a, 0x43, 0xef, 0x6e, 0x8c, 0x37,
	0x45, 0x84, 0x6e, 0xc4, 0x02, 0x00, 0xbd, 0x80, 0xd6, 0x84, 0x31, 0xe1, 0x93, 0x88, 0x5f, 0x99,
	0x5b, 0xaa, 0xa0, 0xff, 0xad, 0x45, 0xb3, 0x85, 0x08, 0xc2, 0xf7, 0x94, 0x38, 0x11, 0xbf, 0xc2,
	0x4d, 0x19, 0x27, 0x4f, 0xa8, 0x0f, 0x3b, 0x9c, 0x86, 0x2c, 0x21, 0x41, 0x36, 0x57, 0x40, 0xdc,
	0xdc, 0x56, 0xf7, 0xfa, 0x40, 0xa4, 0xce, 0x22, 0x5a, 0x8a, 0x1c, 0x7d, 0x0d, 0x28, 0xa1, 0xe2,
	0x07, 0x96, 0x5d, 0xf9, 0x51, 0x22, 0x68, 0x76, 0x19, 0xc8, 0x6e, 0x77, 0x14, 0xe4, 0xc7, 0x6b,
	0x21, 0xfb, 0x3a, 0xc4, 0x2b, 0x23, 0xf0, 0xbd, 0x64, 0x45, 0xc3, 0xe5, 0xd4, 0x5d, 0x7e, 0x4f,
	0x12, 0xd3, 0xd0, 0x53, 0x27, 0xcf, 0xe8, 0x02, 0xee, 0x71, 0x79, 0x95, 0x7c, 0x16, 0x25, 0x53,
	0x3f, 0x65, 0xb3, 0x28, 0x9c, 0x9b, 0xf7, 0x54, 0x27, 0xd6, 0x27, 0x1b, 0x2d, 0x22, 0x86, 0x2a,
	0x00, 0x1b, 0x7c, 0x45, 0x83, 0x3e, 0x01, 0xc4, 0x69, 0x76, 0x1d, 0x85, 0xd4, 0x0f, 0xc2, 0x90,
	0xe5, 0x89, 0x90, 0x23, 0x85, 0x54, 0x66, 0xa3, 0xb0, 0xd8, 0xda, 0xe0, 0x11, 0x34, 0x02, 0xa3,
	0xac, 0x99, 0x53, 0x21, 0xa2, 0x64, 0xca, 0xcd, 0x7f, 0xab, 0x4b, 0x1c, 0xdc, 0x55, 0xf1, 0xa8,
	0xf0, 0xc7, 0x3b, 0xc9, 0x6d, 0x85, 0x04, 0x4d, 0x67, 0x41, 0x48, 0x63, 0x9a, 0x88, 0xb2, 0xb2,
	0xdd, 0x3b, 0x40, 0x87, 0x65, 0x40, 0x51, 0xd8, 0x4e, 0x7a, 0x5b, 0xb1, 0xf7, 0x0c, 0xda, 0x4b,
	0x3b, 0x85, 0x0c, 0xa8, 0x5d, 0xd1, 0x79, 0xc1, 0x18, 0xf2, 0x88, 0x76, 0x61, 0xe3, 0x3a, 0x98,
	0xe5, 0xb4, 0xa0, 0x0b, 0x2d, 0x7c, 0x5e, 0xfd, 0xac, 0xb2, 0x77, 0x02, 0xdb, 0xb7, 0xe6, 0xf0,
	0xef, 0x04, 0x5b, 0x3f, 0x57, 0xa0, 0xa1, 0x37, 0x01, 0xdd, 0x07, 0x34, 0x1a, 0xdb, 0xe3, 0xf3,
	0x91, 0x7f, 0xde, 0x1f, 0x0d, 0xdd, 0x53, 0xef, 0xa5, 0xe7, 0x3a, 0xc6, 0xbf, 0x90, 0x01, 0x5b,
	0x43, 0x3c, 0xb8, 0xf0, 0x46, 0xde, 0xa0, 0xef, 0xf5, 0x5f, 0x19, 0x15, 0xd4, 0x86, 0x4d, 0x7c,
	0xde, 0x57, 0x42, 0x15, 0x6d, 0x41, 0x73, 0x34, 0x1e, 0x0c, 0x87, 0x52, 0xaa, 0x49, 0x93, 0x92,
	0x5c, 0xc7, 0xa8, 0x6b, 0x93, 0x8d, 0xc7, 0xd2, 0xb4, 0x81, 0x3a, 0x00, 0xd8, 0x5d, 0xc8, 0x0d,
	0x69, 0x3d, 0x1f, 0x3a, 0xb6, 0x92, 0x36, 0x51, 0x0b, 0x36, 0x5c, 0x8c, 0x07, 0xd8, 0x68, 0x4a,
	0x8c, 0x53, 0x6c, 0x8f, 0x5e, 0xbb, 0x8e, 0xd1, 0x92, 0x5e, 0x8e, 0x7b, 0xe6, 0x2a, 0x2f, 0xb0,
	0x32, 0x68, 0x2d, 0xf6, 0x1f, 0xdd, 0x87, 0x46, 0x4c, 0x63, 0x96, 0xe9, 0x52, 0x6b, 0xb8, 0x90,
	0x64, 0xb5, 0x21, 0xcb, 0x28, 0x57, 0xd5, 0xd6, 0xb0, 0x16, 0xd0, 0x7f, 0x60, 0x5b, 0x1e, 0xfc,
	0xcb, 0x2c, 0x08, 0x15, 0x13, 0xd6, 0x94, 0x75, 0x4b, 0x2a, 0x5f, 0x16, 0x3a, 0x39, 0xca, 0xd3,
	0x34, 0xe7, 0x8a, 0x40, 0x6b, 0x58, 0x9d, 0xad, 0xdf, 0x2b, 0xb0, 0xb5, 0xbc, 0x59, 0xe8, 0x0b,
	0xa8, 0xc7, 0x8c, 0x50, 0x95, 0xb5, 0x73, 0xf4, 0xf8, 0x83, 0xd6, 0xb1, 0xfb, 0x86, 0x11, 0x8a,
	0x55, 0x9c, 0xe4, 0x43, 0x42, 0xd5, 0x08, 0x2b, 0xb2, 0xd6, 0xff, 0x09, 0x68, 0x55, 0x5f, 0x52,
	0xf6, 0x23, 0x68, 0x07, 0xb9, 0x60, 0x3e, 0xa1, 0x33, 0x2a, 0xa8, 0xba, 0x68, 0x13, 0x83, 0x54,
	0x39, 0x4a, 0x23, 0xa9, 0x56, 0x32, 0x82, 0x1c, 0x7d, 0x4d, 0xf5, 0x0d, 0x29, 0x7a, 0xc4, 0x3a,
	0x81, 0xba, 0x4c, 0x84, 0x76, 0xc1, 0x78, 0x33, 0x70, 0xdc, 0x95, 0x7f, 0x72, 0x1b, 0x5a, 0xd8,
	0xb5, 0x1d, 0x7f, 0xd0, 0x3f, 0x7b, 0x67, 0x54, 0xf4, 0x1f, 0x62, 0x3b, 0xfe, 0x5b, 0xec, 0x8d,
	0x5d, 0xa3, 0x6a, 0xfd, 0x5a, 0x05, 0x63, 0x75, 0xdf, 0x65, 0x33, 0x23, 0x59, 0x5e, 0x31, 0x4e,
	0x5a, 0x90, 0x37, 0x8c, 0x83, 0xd0, 0x0f, 0x08, 0xc9, 0x28, 0xe7, 0x65, 0x09, 0x71, 0x10, 0xda,
	0x5a, 0x23, 0x5f, 0x38, 0x9e, 0x4f, 0x12, 0xaa, 0xd6, 0xb3, 0xa6, 0x5f, 0x38, 0xad, 0xf0, 0x08,
	0x3a, 0x07, 0x94, 0x66, 0x51, 0x2c, 0x89, 0xed, 0xfa, 0x78, 0x01, 0x52, 0x57, 0x3b, 0xf4, 0xd1,
	0xfa, 0x1d, 0xd2, 0x21, 0x45, 0x06, 0x6c, 0x14, 0x10, 0x17, 0xc7, 0x65, 0xce, 0x65, 0xd8, 0xa7,
	0x0b, 0xd8, 0x8d, 0x7f, 0x08, 0xfb, 0xb4, 0x84, 0x55, 0x94, 0x13, 0xe6, 0x59, 0x24, 0xe6, 0xfe,
	0x34, 0x63, 0x79, 0xea, 0x47, 0x44, 0x3f, 0x95, 0x8a, 0x72, 0xb4, 0xe5, 0x95, 0x34, 0x78, 0x84,
	0x5b, 0x39, 0x74, 0x6e, 0x23, 0x22, 0x13, 0x36, 0xcb, 0xbb, 0xe8, 0x1e, 0x96, 0x22, 0xf2, 0xa0,
	0x23, 0x1f, 0x4c, 0xc1, 0x7c, 0xf9, 0x93, 0x04, 0x42, 0x35, 0xb2, 0x7d, 0xf4, 0xdf, 0xb5, 0x97,
	0x1d, 0x24, 0x74, 0xcc, 0x06, 0x09, 0xed, 0x07, 0x02, 0xb7, 0xd9, 0x8d, 0x60, 0x7d, 0x07, 0xed,
	0x25, 0xdb, 0x5f, 0xe4, 0xb4, 0x01, 0xa2, 0xd4, 0xbf, 0xa6, 0x19, 0x97, 0x3b, 0x50, 0x55, 0x23,
	0xbc, 0xfe, 0xb1, 0xf5, 0xd2, 0x0b, 0xed, 0x89, 0x5b, 0x51, 0x79, 0xb4, 0x8e, 0xc1, 0x58, 0x65,
	0x6a, 0xf9, 0x95, 0x91, 0x66, 0x94, 0xc6, 0xa9, 0x88, 0x26, 0x33, 0xbd, 0x1a, 0x4d, 0xbc, 0xac,
	0xb2, 0x7e, 0xa9, 0xc0, 0xce, 0x0a, 0xb7, 0x22, 0x1b, 0xea, 0x62, 0x9e, 0x96, 0x9b, 0x74, 0xf8,
	0xa1, 0x9c, 0xdc, 0x1d, 0xcf, 0x53, 0x8a, 0x55, 0xa8, 0xf5, 0x2d, 0xd4, 0xa5, 0x24, 0x27, 0x7e,
	0xfc, 0x6e, 0xb8, 0x3a, 0xf1, 0x9a, 0x81, 0xfa, 0x8e, 0x8d, 0x1d, 0xa3, 0x82, 0x4c, 0xd8, 0x1d,
	0x0d, 0x5e, 0x8e, 0xdf, 0xda, 0xd8, 0xf5, 0xed, 0xd3, 0x53, 0xf7, 0xcc, 0xc5, 0xf6, 0xd8, 0x75,
	0x8c, 0xaa, 0xb4, 0xbc, 0xb6, 0xb1, 0xf3, 0x27, 0x4b, 0xcd, 0xfa, 0x12, 0x76, 0x56, 0xc8, 0x5b,
	0x0e, 0xc4, 0xcd, 0x03, 0x50, 0x4e, 0x44, 0xd1, 0xe7, 0x9b, 0xa7, 0xa1, 0x98, 0x88, 0xc7, 0x27,
	0xd0, 0x5a, 0x74, 0x11, 0xed, 0xc1, 0x7d, 0x6f, 0xe8, 0x5f, 0xb8, 0x58, 0x92, 0xe9, 0xca, 0x5d,
	0x9b, 0x50, 0xf7, 0x86, 0x17, 0xc7, 0x46, 0xa5, 0x38, 0x3d, 0x35, 0xaa, 0x2f, 0x26, 0xf0, 0xf0,
	0x56, 0x4f, 0x82, 0x34, 0x5a, 0xea, 0xcb, 0x37, 0xa7, 0xd3, 0x48, 0xbc, 0xcf, 0x27, 0x52, 0xd5,
	0xd3, 0x7e, 0x87, 0xfa, 0x8b, 0x76, 0xca, 0x0e, 0xa7, 0x34, 0x51, 0x1f, 0x8b, 0xbd, 0x35, 0x9f,
	0xba, 0x27, 0xc5, 0x71, 0xd2, 0x50, 0x6e, 0x9f, 0xfe, 0x11, 0x00, 0x00, 0xff, 0xff, 0xe9, 0xb1,
	0x00, 0x30, 0x14, 0x0b, 0x00, 0x00,
}
