// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/compute/v1/snapshot_service.proto

package compute

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetSnapshotRequest struct {
	// ID of the Snapshot resource to return.
	// To get the snapshot ID, use a [SnapshotService.List] request.
	SnapshotId           string   `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSnapshotRequest) Reset()         { *m = GetSnapshotRequest{} }
func (m *GetSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*GetSnapshotRequest) ProtoMessage()    {}
func (*GetSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{0}
}

func (m *GetSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSnapshotRequest.Unmarshal(m, b)
}
func (m *GetSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *GetSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSnapshotRequest.Merge(m, src)
}
func (m *GetSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_GetSnapshotRequest.Size(m)
}
func (m *GetSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSnapshotRequest proto.InternalMessageInfo

func (m *GetSnapshotRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

type ListSnapshotsRequest struct {
	// ID of the folder to list snapshots in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListSnapshotsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSnapshotsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Snapshot.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Мust be 3-63 characters long and match the regular expression `^[a-z]([-a-z0-9]{,61}[a-z0-9])?$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsRequest) Reset()         { *m = ListSnapshotsRequest{} }
func (m *ListSnapshotsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsRequest) ProtoMessage()    {}
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{1}
}

func (m *ListSnapshotsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsRequest.Unmarshal(m, b)
}
func (m *ListSnapshotsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsRequest.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsRequest.Merge(m, src)
}
func (m *ListSnapshotsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsRequest.Size(m)
}
func (m *ListSnapshotsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsRequest proto.InternalMessageInfo

func (m *ListSnapshotsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListSnapshotsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSnapshotsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListSnapshotsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListSnapshotsResponse struct {
	// List of snapshots.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSnapshotsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListSnapshotsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsResponse) Reset()         { *m = ListSnapshotsResponse{} }
func (m *ListSnapshotsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse) ProtoMessage()    {}
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{2}
}

func (m *ListSnapshotsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsResponse.Unmarshal(m, b)
}
func (m *ListSnapshotsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsResponse.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsResponse.Merge(m, src)
}
func (m *ListSnapshotsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsResponse.Size(m)
}
func (m *ListSnapshotsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsResponse proto.InternalMessageInfo

func (m *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *ListSnapshotsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateSnapshotRequest struct {
	// ID of the folder to create a snapshot in.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// ID of the disk to create the snapshot from.
	// To get the disk ID use a [yandex.cloud.compute.v1.DiskService.List] request.
	DiskId string `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	// Name of the snapshot.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the snapshot.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels               map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateSnapshotRequest) Reset()         { *m = CreateSnapshotRequest{} }
func (m *CreateSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSnapshotRequest) ProtoMessage()    {}
func (*CreateSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{3}
}

func (m *CreateSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSnapshotRequest.Unmarshal(m, b)
}
func (m *CreateSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *CreateSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSnapshotRequest.Merge(m, src)
}
func (m *CreateSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSnapshotRequest.Size(m)
}
func (m *CreateSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSnapshotRequest proto.InternalMessageInfo

func (m *CreateSnapshotRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateSnapshotRequest) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

func (m *CreateSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateSnapshotRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateSnapshotRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateSnapshotMetadata struct {
	// ID of the snapshot that is being created.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// ID of the source disk used to create this snapshot.
	DiskId               string   `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSnapshotMetadata) Reset()         { *m = CreateSnapshotMetadata{} }
func (m *CreateSnapshotMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateSnapshotMetadata) ProtoMessage()    {}
func (*CreateSnapshotMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{4}
}

func (m *CreateSnapshotMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSnapshotMetadata.Unmarshal(m, b)
}
func (m *CreateSnapshotMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSnapshotMetadata.Marshal(b, m, deterministic)
}
func (m *CreateSnapshotMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSnapshotMetadata.Merge(m, src)
}
func (m *CreateSnapshotMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateSnapshotMetadata.Size(m)
}
func (m *CreateSnapshotMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSnapshotMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSnapshotMetadata proto.InternalMessageInfo

func (m *CreateSnapshotMetadata) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *CreateSnapshotMetadata) GetDiskId() string {
	if m != nil {
		return m.DiskId
	}
	return ""
}

type UpdateSnapshotRequest struct {
	// ID of the Snapshot resource to update.
	// To get the snapshot ID use a [SnapshotService.List] request.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// Field mask that specifies which fields of the Snapshot resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the snapshot.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the snapshot.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateSnapshotRequest) Reset()         { *m = UpdateSnapshotRequest{} }
func (m *UpdateSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSnapshotRequest) ProtoMessage()    {}
func (*UpdateSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{5}
}

func (m *UpdateSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSnapshotRequest.Unmarshal(m, b)
}
func (m *UpdateSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSnapshotRequest.Merge(m, src)
}
func (m *UpdateSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSnapshotRequest.Size(m)
}
func (m *UpdateSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSnapshotRequest proto.InternalMessageInfo

func (m *UpdateSnapshotRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *UpdateSnapshotRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateSnapshotRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateSnapshotRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateSnapshotMetadata struct {
	// ID of the Snapshot resource that is being updated.
	SnapshotId           string   `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateSnapshotMetadata) Reset()         { *m = UpdateSnapshotMetadata{} }
func (m *UpdateSnapshotMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateSnapshotMetadata) ProtoMessage()    {}
func (*UpdateSnapshotMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{6}
}

func (m *UpdateSnapshotMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSnapshotMetadata.Unmarshal(m, b)
}
func (m *UpdateSnapshotMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSnapshotMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateSnapshotMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSnapshotMetadata.Merge(m, src)
}
func (m *UpdateSnapshotMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateSnapshotMetadata.Size(m)
}
func (m *UpdateSnapshotMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSnapshotMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSnapshotMetadata proto.InternalMessageInfo

func (m *UpdateSnapshotMetadata) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

type DeleteSnapshotRequest struct {
	// ID of the snapshot to delete.
	// To get the snapshot ID, use a [SnapshotService.List] request.
	SnapshotId           string   `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSnapshotRequest) Reset()         { *m = DeleteSnapshotRequest{} }
func (m *DeleteSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSnapshotRequest) ProtoMessage()    {}
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{7}
}

func (m *DeleteSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSnapshotRequest.Unmarshal(m, b)
}
func (m *DeleteSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSnapshotRequest.Merge(m, src)
}
func (m *DeleteSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSnapshotRequest.Size(m)
}
func (m *DeleteSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSnapshotRequest proto.InternalMessageInfo

func (m *DeleteSnapshotRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

type DeleteSnapshotMetadata struct {
	// ID of the snapshot that is being deleted.
	SnapshotId           string   `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSnapshotMetadata) Reset()         { *m = DeleteSnapshotMetadata{} }
func (m *DeleteSnapshotMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteSnapshotMetadata) ProtoMessage()    {}
func (*DeleteSnapshotMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{8}
}

func (m *DeleteSnapshotMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSnapshotMetadata.Unmarshal(m, b)
}
func (m *DeleteSnapshotMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSnapshotMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteSnapshotMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSnapshotMetadata.Merge(m, src)
}
func (m *DeleteSnapshotMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteSnapshotMetadata.Size(m)
}
func (m *DeleteSnapshotMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSnapshotMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSnapshotMetadata proto.InternalMessageInfo

func (m *DeleteSnapshotMetadata) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

type ListSnapshotOperationsRequest struct {
	// ID of the Snapshot resource to list operations for.
	SnapshotId string `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListSnapshotOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSnapshotOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotOperationsRequest) Reset()         { *m = ListSnapshotOperationsRequest{} }
func (m *ListSnapshotOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotOperationsRequest) ProtoMessage()    {}
func (*ListSnapshotOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{9}
}

func (m *ListSnapshotOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotOperationsRequest.Unmarshal(m, b)
}
func (m *ListSnapshotOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListSnapshotOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotOperationsRequest.Merge(m, src)
}
func (m *ListSnapshotOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotOperationsRequest.Size(m)
}
func (m *ListSnapshotOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotOperationsRequest proto.InternalMessageInfo

func (m *ListSnapshotOperationsRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *ListSnapshotOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSnapshotOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListSnapshotOperationsResponse struct {
	// List of operations for the specified snapshot.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSnapshotOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListSnapshotOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotOperationsResponse) Reset()         { *m = ListSnapshotOperationsResponse{} }
func (m *ListSnapshotOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotOperationsResponse) ProtoMessage()    {}
func (*ListSnapshotOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3c8b118c8b9bc9c, []int{10}
}

func (m *ListSnapshotOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotOperationsResponse.Unmarshal(m, b)
}
func (m *ListSnapshotOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListSnapshotOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotOperationsResponse.Merge(m, src)
}
func (m *ListSnapshotOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotOperationsResponse.Size(m)
}
func (m *ListSnapshotOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotOperationsResponse proto.InternalMessageInfo

func (m *ListSnapshotOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListSnapshotOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetSnapshotRequest)(nil), "yandex.cloud.compute.v1.GetSnapshotRequest")
	proto.RegisterType((*ListSnapshotsRequest)(nil), "yandex.cloud.compute.v1.ListSnapshotsRequest")
	proto.RegisterType((*ListSnapshotsResponse)(nil), "yandex.cloud.compute.v1.ListSnapshotsResponse")
	proto.RegisterType((*CreateSnapshotRequest)(nil), "yandex.cloud.compute.v1.CreateSnapshotRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.CreateSnapshotRequest.LabelsEntry")
	proto.RegisterType((*CreateSnapshotMetadata)(nil), "yandex.cloud.compute.v1.CreateSnapshotMetadata")
	proto.RegisterType((*UpdateSnapshotRequest)(nil), "yandex.cloud.compute.v1.UpdateSnapshotRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.compute.v1.UpdateSnapshotRequest.LabelsEntry")
	proto.RegisterType((*UpdateSnapshotMetadata)(nil), "yandex.cloud.compute.v1.UpdateSnapshotMetadata")
	proto.RegisterType((*DeleteSnapshotRequest)(nil), "yandex.cloud.compute.v1.DeleteSnapshotRequest")
	proto.RegisterType((*DeleteSnapshotMetadata)(nil), "yandex.cloud.compute.v1.DeleteSnapshotMetadata")
	proto.RegisterType((*ListSnapshotOperationsRequest)(nil), "yandex.cloud.compute.v1.ListSnapshotOperationsRequest")
	proto.RegisterType((*ListSnapshotOperationsResponse)(nil), "yandex.cloud.compute.v1.ListSnapshotOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/compute/v1/snapshot_service.proto", fileDescriptor_b3c8b118c8b9bc9c)
}

var fileDescriptor_b3c8b118c8b9bc9c = []byte{
	// 1000 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xc1, 0x6f, 0xdb, 0x54,
	0x18, 0xd7, 0x6b, 0x52, 0xaf, 0xf9, 0x02, 0x14, 0x3d, 0x35, 0x6d, 0x64, 0x28, 0x04, 0xc3, 0x46,
	0x96, 0x62, 0x3b, 0xce, 0x58, 0x58, 0xbb, 0x4d, 0x83, 0x96, 0xb5, 0xaa, 0xb4, 0x09, 0xe4, 0x8e,
	0x0b, 0x65, 0x44, 0x2f, 0xf5, 0x6b, 0x66, 0xc5, 0xb5, 0x4d, 0x9e, 0x13, 0xad, 0x1d, 0x93, 0x50,
	0xc5, 0xa9, 0x1c, 0x39, 0x72, 0x42, 0x9c, 0x38, 0xd2, 0x13, 0x88, 0x23, 0x87, 0xf6, 0x3c, 0xfe,
	0x05, 0x0e, 0x5c, 0xd9, 0x91, 0x13, 0xf2, 0xb3, 0x9d, 0x3a, 0xa9, 0xbd, 0xba, 0x80, 0x04, 0x37,
	0xdb, 0xdf, 0xef, 0xfb, 0xf9, 0xf7, 0xbe, 0xef, 0x7b, 0xbf, 0xf7, 0x40, 0xd9, 0x25, 0xb6, 0x41,
	0x1f, 0xaa, 0x5b, 0x96, 0xd3, 0x37, 0xd4, 0x2d, 0x67, 0xc7, 0xed, 0x7b, 0x54, 0x1d, 0x68, 0x2a,
	0xb3, 0x89, 0xcb, 0x1e, 0x38, 0x5e, 0x8b, 0xd1, 0xde, 0xc0, 0xdc, 0xa2, 0x8a, 0xdb, 0x73, 0x3c,
	0x07, 0xcf, 0x05, 0x78, 0x85, 0xe3, 0x95, 0x10, 0xaf, 0x0c, 0x34, 0xf1, 0xe5, 0x8e, 0xe3, 0x74,
	0x2c, 0xaa, 0x12, 0xd7, 0x54, 0x89, 0x6d, 0x3b, 0x1e, 0xf1, 0x4c, 0xc7, 0x66, 0x41, 0x9a, 0x58,
	0x09, 0xa3, 0xfc, 0xad, 0xdd, 0xdf, 0x56, 0xb7, 0x4d, 0x6a, 0x19, 0xad, 0x1d, 0xc2, 0xba, 0x11,
	0x62, 0x44, 0x88, 0xcf, 0xe2, 0xb8, 0xb4, 0xc7, 0x49, 0x42, 0xc4, 0xa5, 0xb3, 0xa4, 0x26, 0xe2,
	0x86, 0x2c, 0xa7, 0xf8, 0xe6, 0x47, 0x70, 0x03, 0x62, 0x99, 0x46, 0x2c, 0x2c, 0xad, 0x00, 0x5e,
	0xa3, 0xde, 0x46, 0xc8, 0xad, 0xd3, 0xcf, 0xfa, 0x94, 0x79, 0x58, 0x86, 0xe2, 0xb0, 0x32, 0xa6,
	0x51, 0x46, 0x15, 0x54, 0x2d, 0x2c, 0x3f, 0xf7, 0xfb, 0x91, 0x86, 0x0e, 0x8e, 0xb5, 0xfc, 0x8d,
	0x9b, 0x57, 0xeb, 0x3a, 0x44, 0x80, 0x75, 0x43, 0xfa, 0x11, 0xc1, 0xcc, 0x1d, 0x93, 0x0d, 0x69,
	0x58, 0xc4, 0x73, 0x19, 0x0a, 0xdb, 0x8e, 0x65, 0xd0, 0x5e, 0x1a, 0xcb, 0x54, 0x10, 0x5e, 0x37,
	0xf0, 0x9b, 0x50, 0x70, 0x49, 0x87, 0xb6, 0x98, 0xb9, 0x47, 0xcb, 0x13, 0x15, 0x54, 0xcd, 0x2d,
	0xc3, 0x9f, 0x47, 0x9a, 0x70, 0xe3, 0xa6, 0x56, 0xaf, 0xd7, 0xf5, 0x29, 0x3f, 0xb8, 0x61, 0xee,
	0x51, 0x5c, 0x05, 0xe0, 0x40, 0xcf, 0xe9, 0x52, 0xbb, 0x9c, 0xe3, 0xa4, 0x85, 0x83, 0x63, 0x6d,
	0x92, 0x23, 0x75, 0xce, 0x72, 0xcf, 0x8f, 0x61, 0x09, 0x84, 0x6d, 0xd3, 0xf2, 0x68, 0xaf, 0x9c,
	0xe7, 0x28, 0x38, 0x38, 0x1e, 0xf2, 0x85, 0x11, 0xe9, 0x0b, 0x04, 0xa5, 0x31, 0xe9, 0xcc, 0x75,
	0x6c, 0x46, 0xf1, 0x2d, 0x28, 0x44, 0x4b, 0x64, 0x65, 0x54, 0xc9, 0x55, 0x8b, 0x8d, 0xd7, 0x94,
	0x94, 0xb9, 0x50, 0x86, 0x05, 0x3c, 0xc9, 0xc1, 0x97, 0x60, 0xda, 0xa6, 0x0f, 0xbd, 0x56, 0x4c,
	0xad, 0xbf, 0xae, 0x82, 0xfe, 0xbc, 0xff, 0xf9, 0xc3, 0x48, 0xa6, 0xf4, 0x7d, 0x0e, 0x4a, 0x2b,
	0x3d, 0x4a, 0x3c, 0x3a, 0xde, 0x86, 0x73, 0x94, 0xef, 0x22, 0x5c, 0x30, 0x4c, 0xd6, 0xf5, 0x81,
	0x13, 0x09, 0x40, 0xc1, 0x0f, 0xae, 0x1b, 0xf8, 0x1a, 0xe4, 0x6d, 0xb2, 0x43, 0xc3, 0xb2, 0xbd,
	0xf1, 0xf4, 0x48, 0xab, 0x7c, 0xbe, 0x49, 0xe4, 0xbd, 0xfb, 0xd5, 0x4d, 0x99, 0xc8, 0x7b, 0x75,
	0x79, 0xf1, 0xfe, 0xa3, 0xfa, 0x5b, 0x4d, 0xed, 0xf1, 0x66, 0xf8, 0x76, 0xf9, 0x96, 0xce, 0x33,
	0xf0, 0x02, 0x14, 0x0d, 0xca, 0xb6, 0x7a, 0xa6, 0xeb, 0x4f, 0x4f, 0x58, 0xd1, 0xb0, 0xee, 0x8d,
	0xab, 0x4d, 0x3d, 0x1e, 0xc5, 0xdf, 0x20, 0x10, 0x2c, 0xd2, 0xa6, 0x16, 0x2b, 0x0b, 0xbc, 0x72,
	0x4b, 0xa9, 0x95, 0x4b, 0x5c, 0xb9, 0x72, 0x87, 0x27, 0xdf, 0xb6, 0xbd, 0xde, 0xee, 0xf2, 0xda,
	0xd3, 0x23, 0x6d, 0x7a, 0x53, 0x6e, 0x29, 0xea, 0x27, 0xef, 0xd6, 0xe5, 0x45, 0x5f, 0x6d, 0x6d,
	0x9f, 0x2f, 0xac, 0xf9, 0x76, 0xb0, 0xc0, 0xe6, 0x95, 0xc3, 0x63, 0x4d, 0x10, 0xf3, 0x9a, 0xcc,
	0x9f, 0x66, 0xf1, 0x0c, 0x5f, 0xd3, 0x58, 0x8e, 0x1e, 0x4a, 0x12, 0x17, 0xa1, 0x18, 0xe3, 0xc7,
	0x2f, 0x42, 0xae, 0x4b, 0x77, 0x83, 0xfa, 0xea, 0xfe, 0x23, 0x9e, 0x81, 0xc9, 0x01, 0xb1, 0xfa,
	0x34, 0xec, 0x57, 0xf0, 0xb2, 0x34, 0x71, 0x0d, 0x49, 0x3a, 0xcc, 0x8e, 0x0a, 0xbe, 0x4b, 0x3d,
	0x62, 0x10, 0x8f, 0xe0, 0x57, 0x13, 0xb6, 0x4c, 0x7c, 0x93, 0xe0, 0xb9, 0xb1, 0x0e, 0x45, 0x3d,
	0x91, 0x7e, 0xc9, 0x41, 0xe9, 0x23, 0xd7, 0x48, 0xe8, 0xff, 0xf9, 0xb6, 0x21, 0xbe, 0x0e, 0xc5,
	0x3e, 0xe7, 0xe1, 0x8e, 0xc3, 0xff, 0x52, 0x6c, 0x88, 0x4a, 0x60, 0x4a, 0x4a, 0x64, 0x4a, 0xca,
	0xaa, 0x6f, 0x4a, 0x77, 0x09, 0xeb, 0xea, 0x10, 0xc0, 0xfd, 0xe7, 0xff, 0x60, 0x32, 0x26, 0xcf,
	0x98, 0x8c, 0xc4, 0x9a, 0xfc, 0x6f, 0x27, 0x63, 0x11, 0x66, 0x47, 0x05, 0x67, 0x9e, 0x0c, 0x69,
	0x15, 0x4a, 0xef, 0x53, 0x8b, 0xfe, 0xd3, 0xfe, 0xfb, 0x12, 0x46, 0x79, 0xb2, 0x4b, 0xf8, 0x16,
	0xc1, 0x7c, 0xdc, 0x06, 0x3f, 0x88, 0x4e, 0x11, 0xf6, 0x37, 0x67, 0xf1, 0xdf, 0xb7, 0x73, 0xe9,
	0x2b, 0x04, 0xaf, 0xa4, 0x69, 0x0c, 0x3d, 0xfb, 0x3d, 0x80, 0xe1, 0xf9, 0x97, 0x62, 0xda, 0x27,
	0xe7, 0xe3, 0x30, 0x5f, 0x8f, 0x25, 0x65, 0x75, 0xed, 0xc6, 0x1f, 0x17, 0x60, 0x3a, 0x52, 0xb2,
	0x11, 0x5c, 0x1e, 0xf0, 0x3e, 0x82, 0xdc, 0x1a, 0xf5, 0xf0, 0x42, 0xea, 0x4c, 0x9f, 0x3e, 0x6b,
	0xc5, 0xb3, 0x0f, 0x15, 0x69, 0x61, 0xff, 0xd7, 0xdf, 0xbe, 0x9e, 0xb8, 0x88, 0x5f, 0x4f, 0xba,
	0x0f, 0x30, 0xf5, 0x51, 0xac, 0x31, 0x8f, 0xf1, 0x97, 0x08, 0xf2, 0x7e, 0x99, 0xb0, 0x9c, 0x4a,
	0x9c, 0x74, 0x56, 0x8b, 0x4a, 0x56, 0x78, 0x50, 0x6b, 0x69, 0x9e, 0x8b, 0x9a, 0xc3, 0xa5, 0x44,
	0x51, 0xf8, 0x3b, 0x04, 0x42, 0x60, 0x95, 0x58, 0x39, 0x9f, 0xf9, 0x8b, 0x67, 0x77, 0x4c, 0x5a,
	0x3d, 0x7c, 0x52, 0x93, 0x52, 0xbd, 0x78, 0x2a, 0xfa, 0xc2, 0x25, 0x8a, 0x52, 0xb2, 0xc4, 0x25,
	0x54, 0xc3, 0x3f, 0x20, 0x10, 0x82, 0x6d, 0xfb, 0x0c, 0x95, 0x89, 0x46, 0x94, 0x45, 0xe5, 0xbd,
	0x40, 0x65, 0x8a, 0x2f, 0x8c, 0xaa, 0xac, 0x36, 0xb2, 0x74, 0xd7, 0xd7, 0xfc, 0x33, 0x02, 0x21,
	0xd8, 0xe7, 0xcf, 0xd0, 0x9c, 0x68, 0x28, 0x59, 0x34, 0x7f, 0x7a, 0xf8, 0xa4, 0xa6, 0xa6, 0x1a,
	0x49, 0x69, 0xfc, 0x30, 0xb9, 0xbd, 0xe3, 0x7a, 0xbb, 0xc1, 0x78, 0xd6, 0x32, 0x8d, 0xe7, 0x4f,
	0x08, 0x5e, 0xf0, 0x07, 0xea, 0x64, 0xf7, 0xe2, 0x66, 0xa6, 0xc9, 0x3b, 0x65, 0x49, 0xe2, 0x3b,
	0xe7, 0xce, 0x0b, 0x47, 0xb7, 0xc9, 0x05, 0xd7, 0xb1, 0x92, 0x41, 0xf0, 0xc9, 0x85, 0x9a, 0x2d,
	0xb7, 0xe1, 0xa5, 0x91, 0x3f, 0x12, 0xd7, 0x8c, 0xfd, 0xf5, 0xe3, 0x95, 0x8e, 0xe9, 0x3d, 0xe8,
	0xb7, 0xfd, 0x4f, 0x6a, 0x80, 0x93, 0x83, 0x5b, 0x77, 0xc7, 0x91, 0x3b, 0xd4, 0xe6, 0x35, 0x53,
	0x53, 0xae, 0xf7, 0xd7, 0xc3, 0xc7, 0xb6, 0xc0, 0x61, 0x57, 0xfe, 0x0a, 0x00, 0x00, 0xff, 0xff,
	0x2f, 0x42, 0x92, 0x9f, 0xb3, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SnapshotServiceClient is the client API for SnapshotService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SnapshotServiceClient interface {
	// Returns the specified Snapshot resource.
	//
	// To get the list of available Snapshot resources, make a [List] request.
	Get(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Retrieves the list of Snapshot resources in the specified folder.
	List(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Creates a snapshot of the specified disk.
	Create(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified snapshot.
	//
	// Values of omitted parameters are not changed.
	Update(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified snapshot.
	//
	// Deleting a snapshot removes its data permanently and is irreversible.
	Delete(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified snapshot.
	ListOperations(ctx context.Context, in *ListSnapshotOperationsRequest, opts ...grpc.CallOption) (*ListSnapshotOperationsResponse, error)
}

type snapshotServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSnapshotServiceClient(cc grpc.ClientConnInterface) SnapshotServiceClient {
	return &snapshotServiceClient{cc}
}

func (c *snapshotServiceClient) Get(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.SnapshotService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snapshotServiceClient) List(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.SnapshotService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snapshotServiceClient) Create(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.SnapshotService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snapshotServiceClient) Update(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.SnapshotService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snapshotServiceClient) Delete(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.SnapshotService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snapshotServiceClient) ListOperations(ctx context.Context, in *ListSnapshotOperationsRequest, opts ...grpc.CallOption) (*ListSnapshotOperationsResponse, error) {
	out := new(ListSnapshotOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.compute.v1.SnapshotService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SnapshotServiceServer is the server API for SnapshotService service.
type SnapshotServiceServer interface {
	// Returns the specified Snapshot resource.
	//
	// To get the list of available Snapshot resources, make a [List] request.
	Get(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Retrieves the list of Snapshot resources in the specified folder.
	List(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Creates a snapshot of the specified disk.
	Create(context.Context, *CreateSnapshotRequest) (*operation.Operation, error)
	// Updates the specified snapshot.
	//
	// Values of omitted parameters are not changed.
	Update(context.Context, *UpdateSnapshotRequest) (*operation.Operation, error)
	// Deletes the specified snapshot.
	//
	// Deleting a snapshot removes its data permanently and is irreversible.
	Delete(context.Context, *DeleteSnapshotRequest) (*operation.Operation, error)
	// Lists operations for the specified snapshot.
	ListOperations(context.Context, *ListSnapshotOperationsRequest) (*ListSnapshotOperationsResponse, error)
}

// UnimplementedSnapshotServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSnapshotServiceServer struct {
}

func (*UnimplementedSnapshotServiceServer) Get(ctx context.Context, req *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSnapshotServiceServer) List(ctx context.Context, req *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSnapshotServiceServer) Create(ctx context.Context, req *CreateSnapshotRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedSnapshotServiceServer) Update(ctx context.Context, req *UpdateSnapshotRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedSnapshotServiceServer) Delete(ctx context.Context, req *DeleteSnapshotRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSnapshotServiceServer) ListOperations(ctx context.Context, req *ListSnapshotOperationsRequest) (*ListSnapshotOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}

func RegisterSnapshotServiceServer(s *grpc.Server, srv SnapshotServiceServer) {
	s.RegisterService(&_SnapshotService_serviceDesc, srv)
}

func _SnapshotService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnapshotServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.SnapshotService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnapshotServiceServer).Get(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnapshotService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnapshotServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.SnapshotService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnapshotServiceServer).List(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnapshotService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnapshotServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.SnapshotService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnapshotServiceServer).Create(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnapshotService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnapshotServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.SnapshotService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnapshotServiceServer).Update(ctx, req.(*UpdateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnapshotService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnapshotServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.SnapshotService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnapshotServiceServer).Delete(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnapshotService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnapshotServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.compute.v1.SnapshotService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnapshotServiceServer).ListOperations(ctx, req.(*ListSnapshotOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SnapshotService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.compute.v1.SnapshotService",
	HandlerType: (*SnapshotServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SnapshotService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SnapshotService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _SnapshotService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SnapshotService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SnapshotService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _SnapshotService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/compute/v1/snapshot_service.proto",
}
