// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/containerregistry/v1/registry_service.proto

package containerregistry

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetRegistryRequest struct {
	// ID of the Registry resource to return.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRegistryRequest) Reset()         { *m = GetRegistryRequest{} }
func (m *GetRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*GetRegistryRequest) ProtoMessage()    {}
func (*GetRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{0}
}

func (m *GetRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRegistryRequest.Unmarshal(m, b)
}
func (m *GetRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRegistryRequest.Marshal(b, m, deterministic)
}
func (m *GetRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRegistryRequest.Merge(m, src)
}
func (m *GetRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_GetRegistryRequest.Size(m)
}
func (m *GetRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRegistryRequest proto.InternalMessageInfo

func (m *GetRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type ListRegistriesRequest struct {
	// ID of the folder to list registries in.
	//
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListRegistriesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListRegistriesResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Registry.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. Value or a list of values to compare against the values of the field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRegistriesRequest) Reset()         { *m = ListRegistriesRequest{} }
func (m *ListRegistriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListRegistriesRequest) ProtoMessage()    {}
func (*ListRegistriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{1}
}

func (m *ListRegistriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRegistriesRequest.Unmarshal(m, b)
}
func (m *ListRegistriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRegistriesRequest.Marshal(b, m, deterministic)
}
func (m *ListRegistriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRegistriesRequest.Merge(m, src)
}
func (m *ListRegistriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListRegistriesRequest.Size(m)
}
func (m *ListRegistriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRegistriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRegistriesRequest proto.InternalMessageInfo

func (m *ListRegistriesRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListRegistriesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRegistriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRegistriesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListRegistriesResponse struct {
	// List of Registry resources.
	Registries []*Registry `protobuf:"bytes,1,rep,name=registries,proto3" json:"registries,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListRegistriesRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListRegistriesRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRegistriesResponse) Reset()         { *m = ListRegistriesResponse{} }
func (m *ListRegistriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListRegistriesResponse) ProtoMessage()    {}
func (*ListRegistriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{2}
}

func (m *ListRegistriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRegistriesResponse.Unmarshal(m, b)
}
func (m *ListRegistriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRegistriesResponse.Marshal(b, m, deterministic)
}
func (m *ListRegistriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRegistriesResponse.Merge(m, src)
}
func (m *ListRegistriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListRegistriesResponse.Size(m)
}
func (m *ListRegistriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRegistriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRegistriesResponse proto.InternalMessageInfo

func (m *ListRegistriesResponse) GetRegistries() []*Registry {
	if m != nil {
		return m.Registries
	}
	return nil
}

func (m *ListRegistriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateRegistryRequest struct {
	// ID of the folder to create a registry in.
	//
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateRegistryRequest) Reset()         { *m = CreateRegistryRequest{} }
func (m *CreateRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateRegistryRequest) ProtoMessage()    {}
func (*CreateRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{3}
}

func (m *CreateRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRegistryRequest.Unmarshal(m, b)
}
func (m *CreateRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRegistryRequest.Marshal(b, m, deterministic)
}
func (m *CreateRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRegistryRequest.Merge(m, src)
}
func (m *CreateRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateRegistryRequest.Size(m)
}
func (m *CreateRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRegistryRequest proto.InternalMessageInfo

func (m *CreateRegistryRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateRegistryRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateRegistryMetadata struct {
	// ID of the registry that is being created.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateRegistryMetadata) Reset()         { *m = CreateRegistryMetadata{} }
func (m *CreateRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateRegistryMetadata) ProtoMessage()    {}
func (*CreateRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{4}
}

func (m *CreateRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRegistryMetadata.Unmarshal(m, b)
}
func (m *CreateRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRegistryMetadata.Marshal(b, m, deterministic)
}
func (m *CreateRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRegistryMetadata.Merge(m, src)
}
func (m *CreateRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateRegistryMetadata.Size(m)
}
func (m *CreateRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRegistryMetadata proto.InternalMessageInfo

func (m *CreateRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type UpdateRegistryRequest struct {
	// ID of the Registry resource to update.
	//
	// To get the registry ID use a [RegistryService.List] request.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// Field mask that specifies which fields of the Registry resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the registry.
	//
	// There may be only one registry per folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateRegistryRequest) Reset()         { *m = UpdateRegistryRequest{} }
func (m *UpdateRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRegistryRequest) ProtoMessage()    {}
func (*UpdateRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{5}
}

func (m *UpdateRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRegistryRequest.Unmarshal(m, b)
}
func (m *UpdateRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRegistryRequest.Marshal(b, m, deterministic)
}
func (m *UpdateRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRegistryRequest.Merge(m, src)
}
func (m *UpdateRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateRegistryRequest.Size(m)
}
func (m *UpdateRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRegistryRequest proto.InternalMessageInfo

func (m *UpdateRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func (m *UpdateRegistryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateRegistryRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateRegistryMetadata struct {
	// ID of the Registry resource that is being updated.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateRegistryMetadata) Reset()         { *m = UpdateRegistryMetadata{} }
func (m *UpdateRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateRegistryMetadata) ProtoMessage()    {}
func (*UpdateRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{6}
}

func (m *UpdateRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRegistryMetadata.Unmarshal(m, b)
}
func (m *UpdateRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRegistryMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRegistryMetadata.Merge(m, src)
}
func (m *UpdateRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateRegistryMetadata.Size(m)
}
func (m *UpdateRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRegistryMetadata proto.InternalMessageInfo

func (m *UpdateRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type DeleteRegistryRequest struct {
	// ID of the registry to delete.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRegistryRequest) Reset()         { *m = DeleteRegistryRequest{} }
func (m *DeleteRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRegistryRequest) ProtoMessage()    {}
func (*DeleteRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{7}
}

func (m *DeleteRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRegistryRequest.Unmarshal(m, b)
}
func (m *DeleteRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRegistryRequest.Marshal(b, m, deterministic)
}
func (m *DeleteRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRegistryRequest.Merge(m, src)
}
func (m *DeleteRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteRegistryRequest.Size(m)
}
func (m *DeleteRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRegistryRequest proto.InternalMessageInfo

func (m *DeleteRegistryRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

type DeleteRegistryMetadata struct {
	// ID of the registry that is being deleted.
	RegistryId           string   `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRegistryMetadata) Reset()         { *m = DeleteRegistryMetadata{} }
func (m *DeleteRegistryMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteRegistryMetadata) ProtoMessage()    {}
func (*DeleteRegistryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_9e6479678b0fb5ad, []int{8}
}

func (m *DeleteRegistryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRegistryMetadata.Unmarshal(m, b)
}
func (m *DeleteRegistryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRegistryMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteRegistryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRegistryMetadata.Merge(m, src)
}
func (m *DeleteRegistryMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteRegistryMetadata.Size(m)
}
func (m *DeleteRegistryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRegistryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRegistryMetadata proto.InternalMessageInfo

func (m *DeleteRegistryMetadata) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func init() {
	proto.RegisterType((*GetRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.GetRegistryRequest")
	proto.RegisterType((*ListRegistriesRequest)(nil), "yandex.cloud.containerregistry.v1.ListRegistriesRequest")
	proto.RegisterType((*ListRegistriesResponse)(nil), "yandex.cloud.containerregistry.v1.ListRegistriesResponse")
	proto.RegisterType((*CreateRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryRequest.LabelsEntry")
	proto.RegisterType((*CreateRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.CreateRegistryMetadata")
	proto.RegisterType((*UpdateRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryRequest.LabelsEntry")
	proto.RegisterType((*UpdateRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.UpdateRegistryMetadata")
	proto.RegisterType((*DeleteRegistryRequest)(nil), "yandex.cloud.containerregistry.v1.DeleteRegistryRequest")
	proto.RegisterType((*DeleteRegistryMetadata)(nil), "yandex.cloud.containerregistry.v1.DeleteRegistryMetadata")
}

func init() {
	proto.RegisterFile("yandex/cloud/containerregistry/v1/registry_service.proto", fileDescriptor_9e6479678b0fb5ad)
}

var fileDescriptor_9e6479678b0fb5ad = []byte{
	// 1028 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x97, 0x41, 0x6f, 0x1b, 0x45,
	0x14, 0xc7, 0x35, 0xb1, 0x6b, 0xc5, 0xcf, 0x45, 0x2d, 0xa3, 0xba, 0xb2, 0x2c, 0x2a, 0x9c, 0xad,
	0x08, 0xa9, 0x61, 0x77, 0xbd, 0x69, 0x13, 0xe2, 0x34, 0x15, 0xaa, 0x9b, 0xa6, 0x0a, 0xb4, 0x02,
	0x6d, 0x40, 0x48, 0x44, 0x95, 0x99, 0x78, 0x27, 0x66, 0xc8, 0x66, 0xd7, 0xec, 0xac, 0xad, 0x26,
	0xa5, 0x12, 0xea, 0x8d, 0x48, 0x88, 0x03, 0xe2, 0xc8, 0x85, 0x03, 0x1f, 0x20, 0xb7, 0x1e, 0x39,
	0x39, 0x57, 0x02, 0x1f, 0x81, 0x03, 0xd7, 0xf6, 0x88, 0x84, 0x84, 0x76, 0x66, 0xd7, 0xcd, 0xda,
	0x6b, 0xb2, 0x0e, 0x17, 0x4e, 0x9e, 0xdd, 0x79, 0xef, 0xcd, 0xef, 0x3f, 0xef, 0xbd, 0x19, 0x2f,
	0x2c, 0xed, 0x11, 0xc7, 0xa2, 0x8f, 0xf4, 0x96, 0xed, 0x76, 0x2d, 0xbd, 0xe5, 0x3a, 0x3e, 0x61,
	0x0e, 0xf5, 0x3c, 0xda, 0x66, 0xdc, 0xf7, 0xf6, 0xf4, 0x9e, 0xa1, 0x47, 0xe3, 0x26, 0xa7, 0x5e,
	0x8f, 0xb5, 0xa8, 0xd6, 0xf1, 0x5c, 0xdf, 0xc5, 0x33, 0xd2, 0x53, 0x13, 0x9e, 0xda, 0x88, 0xa7,
	0xd6, 0x33, 0xca, 0x95, 0x58, 0x70, 0xd2, 0x61, 0xba, 0xdb, 0xa1, 0x1e, 0xf1, 0x99, 0xeb, 0xc8,
	0x20, 0xc3, 0x16, 0xad, 0x16, 0xe5, 0x3c, 0xfc, 0x09, 0x2d, 0x6a, 0xe9, 0x01, 0x43, 0x8f, 0xd9,
	0x98, 0xc7, 0x60, 0xc5, 0x91, 0xb5, 0xaf, 0xc4, 0xec, 0x7a, 0xc4, 0x66, 0x56, 0x0c, 0xad, 0xed,
	0xba, 0x6d, 0x9b, 0xea, 0xe2, 0x69, 0xab, 0xbb, 0xad, 0x6f, 0x33, 0x6a, 0x5b, 0xcd, 0x5d, 0xc2,
	0x77, 0x42, 0x8b, 0xd7, 0x42, 0x8b, 0x40, 0x18, 0x71, 0x1c, 0xd7, 0x17, 0xee, 0x21, 0xb8, 0x72,
	0x07, 0xf0, 0x3d, 0xea, 0x9b, 0x21, 0x9b, 0x49, 0xbf, 0xec, 0x52, 0xee, 0x63, 0x15, 0x0a, 0x83,
	0xfd, 0x64, 0x56, 0x09, 0x55, 0xd0, 0x5c, 0xbe, 0x71, 0xfe, 0xcf, 0xbe, 0x81, 0x0e, 0x8e, 0x8c,
	0xec, 0xca, 0xad, 0x85, 0x9a, 0x09, 0x91, 0xc1, 0xba, 0xa5, 0x3c, 0x43, 0x50, 0xbc, 0xcf, 0x78,
	0x14, 0x86, 0x51, 0x1e, 0x05, 0xba, 0x06, 0xf9, 0x6d, 0xd7, 0xb6, 0xa8, 0x37, 0x2e, 0xcc, 0xb4,
	0x9c, 0x5e, 0xb7, 0xf0, 0x9b, 0x90, 0xef, 0x90, 0x36, 0x6d, 0x72, 0xb6, 0x4f, 0x4b, 0x53, 0x15,
	0x34, 0x97, 0x69, 0xc0, 0x5f, 0x7d, 0x23, 0xb7, 0x72, 0xcb, 0xa8, 0xd5, 0x6a, 0xe6, 0x74, 0x30,
	0xb9, 0xc1, 0xf6, 0x29, 0x9e, 0x03, 0x10, 0x86, 0xbe, 0xbb, 0x43, 0x9d, 0x52, 0x46, 0x04, 0xcd,
	0x1f, 0x1c, 0x19, 0xe7, 0x84, 0xa5, 0x29, 0xa2, 0x7c, 0x14, 0xcc, 0x61, 0x05, 0x72, 0xdb, 0xcc,
	0xf6, 0xa9, 0x57, 0xca, 0x0a, 0x2b, 0x38, 0x38, 0x1a, 0xc4, 0x0b, 0x67, 0x94, 0x6f, 0x11, 0x5c,
	0x1e, 0x66, 0xe7, 0x1d, 0xd7, 0xe1, 0x14, 0xbf, 0x0f, 0x91, 0x48, 0x46, 0x79, 0x09, 0x55, 0x32,
	0x73, 0x85, 0xf9, 0xb7, 0xb4, 0x53, 0x0b, 0x4a, 0x1b, 0xec, 0xe6, 0x09, 0x77, 0x3c, 0x0b, 0x17,
	0x1c, 0xfa, 0xc8, 0x6f, 0x9e, 0x40, 0x0f, 0x44, 0xe6, 0xcd, 0x57, 0x82, 0xd7, 0x1f, 0x46, 0xcc,
	0xca, 0xef, 0x53, 0x50, 0xbc, 0xe3, 0x51, 0xe2, 0xd3, 0xe1, 0xa4, 0x4c, 0xb0, 0x97, 0x0b, 0x90,
	0x75, 0xc8, 0xae, 0xdc, 0xc6, 0x7c, 0x63, 0xe6, 0x45, 0xdf, 0xb8, 0xf2, 0xd5, 0x26, 0x51, 0xf7,
	0x1f, 0x6e, 0xaa, 0x44, 0xdd, 0xaf, 0xa9, 0xf5, 0x87, 0x8f, 0x8d, 0xb7, 0x17, 0x8d, 0x27, 0x9b,
	0xe1, 0x93, 0x29, 0xcc, 0xf1, 0x8f, 0x08, 0x72, 0x36, 0xd9, 0xa2, 0x36, 0x2f, 0x65, 0x84, 0xda,
	0xd5, 0x14, 0x6a, 0x13, 0x61, 0xb5, 0xfb, 0x22, 0xcc, 0x5d, 0xc7, 0xf7, 0xf6, 0x1a, 0xef, 0xbe,
	0xe8, 0x1b, 0x85, 0x4d, 0xb5, 0x59, 0x53, 0xeb, 0x01, 0x43, 0xf5, 0xa9, 0x00, 0x5e, 0xbc, 0x21,
	0xc1, 0x17, 0xaf, 0x1f, 0x1e, 0x19, 0xb9, 0x72, 0xd6, 0x50, 0xc5, 0x08, 0xe3, 0x8b, 0x21, 0xe9,
	0xc0, 0xde, 0x0c, 0xa1, 0xca, 0x75, 0x28, 0x9c, 0x88, 0x8b, 0x2f, 0x42, 0x66, 0x87, 0xee, 0xc9,
	0xad, 0x30, 0x83, 0x21, 0xbe, 0x04, 0xe7, 0x7a, 0xc4, 0xee, 0x86, 0xc2, 0x4d, 0xf9, 0xb0, 0x3c,
	0xb5, 0x84, 0x94, 0x3a, 0x5c, 0x8e, 0x83, 0x3e, 0xa0, 0x3e, 0xb1, 0x88, 0x4f, 0xf0, 0xeb, 0x09,
	0xb5, 0x1e, 0xab, 0xee, 0x1f, 0x32, 0x50, 0xfc, 0xb8, 0x63, 0x25, 0x64, 0x64, 0xb2, 0x36, 0xc1,
	0x37, 0xa1, 0xd0, 0x15, 0x71, 0x44, 0x7b, 0x0a, 0xc6, 0xc2, 0x7c, 0x59, 0x93, 0xfd, 0xa9, 0x45,
	0x1d, 0xac, 0xad, 0x05, 0x1d, 0xfc, 0x80, 0xf0, 0x1d, 0x13, 0xa4, 0x79, 0x30, 0x1e, 0xa4, 0x34,
	0x73, 0xe6, 0x94, 0x66, 0x53, 0xa7, 0x34, 0x51, 0xed, 0xff, 0x31, 0xa5, 0x71, 0xd0, 0xf4, 0x29,
	0x5d, 0x83, 0xe2, 0x2a, 0xb5, 0xe9, 0x7f, 0xcd, 0x68, 0x80, 0x10, 0x8f, 0x93, 0x1a, 0x61, 0xfe,
	0xf9, 0x79, 0xb8, 0x10, 0x79, 0x6d, 0xc8, 0x2b, 0x0b, 0xff, 0x84, 0x20, 0x73, 0x8f, 0xfa, 0x78,
	0x21, 0x45, 0x8e, 0x46, 0x4f, 0xed, 0xf2, 0x24, 0x67, 0x93, 0xf2, 0xce, 0xd3, 0xdf, 0xfe, 0xf8,
	0x7e, 0xca, 0xc0, 0xfa, 0xcb, 0xdb, 0x4a, 0x4d, 0xb8, 0xae, 0x18, 0xe5, 0xfa, 0xe3, 0x13, 0x4a,
	0x9e, 0xe0, 0x9f, 0x11, 0x64, 0x83, 0x03, 0x13, 0x2f, 0xa5, 0x58, 0x2e, 0xf1, 0x56, 0x28, 0xd7,
	0xcf, 0xe0, 0x29, 0xcf, 0x64, 0xe5, 0x9a, 0xc0, 0xbe, 0x8a, 0x67, 0x4e, 0xc5, 0xc6, 0xcf, 0x10,
	0xe4, 0x64, 0xcf, 0xa7, 0x42, 0x4d, 0x3c, 0xc7, 0xca, 0x33, 0x71, 0xcf, 0x97, 0xb7, 0xf3, 0x07,
	0xd1, 0x48, 0x31, 0x0f, 0x8f, 0xab, 0xca, 0xd8, 0xe3, 0x65, 0x3a, 0x7a, 0x23, 0xc0, 0x67, 0x95,
	0xd3, 0xc1, 0x97, 0x51, 0x15, 0xf7, 0x11, 0xe4, 0x64, 0x71, 0xa7, 0x62, 0x4f, 0x6c, 0xd8, 0x34,
	0xec, 0x9f, 0x49, 0xf6, 0x31, 0x7d, 0x14, 0x67, 0xbf, 0x31, 0x3f, 0x69, 0xad, 0x04, 0x4a, 0x7e,
	0x45, 0x90, 0x93, 0x3d, 0x92, 0x4a, 0x49, 0x62, 0x5b, 0xa6, 0x51, 0xf2, 0xc5, 0xe1, 0x71, 0x55,
	0x1f, 0xdb, 0x8e, 0xc5, 0xe1, 0x43, 0xf6, 0xee, 0x6e, 0xc7, 0x97, 0xb2, 0x8c, 0xea, 0xc4, 0x2d,
	0xf0, 0x0b, 0x02, 0x1c, 0xd4, 0xe7, 0x6d, 0xf1, 0x17, 0xb0, 0xc1, 0x1c, 0x8b, 0x39, 0x6d, 0x8e,
	0xb5, 0x38, 0x65, 0xf8, 0x07, 0x71, 0xd4, 0x30, 0x52, 0xa5, 0xa7, 0xb6, 0x0f, 0x8b, 0xff, 0x3d,
	0x01, 0xbc, 0x8a, 0x1b, 0xa9, 0x80, 0xb9, 0xdb, 0xf5, 0x5a, 0x54, 0xe4, 0xc1, 0x1e, 0x85, 0x7d,
	0x8e, 0xe0, 0xd5, 0x0d, 0x3a, 0xfc, 0x56, 0x4d, 0x44, 0x1a, 0xb1, 0x9b, 0x20, 0x2f, 0xdf, 0xa0,
	0xc3, 0xe3, 0x6a, 0x1d, 0x2a, 0xe3, 0x42, 0xa5, 0x49, 0xd1, 0x9a, 0x72, 0x7b, 0x52, 0xc5, 0x7c,
	0x78, 0x9d, 0xa0, 0x16, 0xff, 0x46, 0x70, 0x49, 0x96, 0xfa, 0x90, 0xec, 0x5a, 0xa2, 0xec, 0x24,
	0xd3, 0x09, 0x94, 0x7f, 0x17, 0x28, 0x5f, 0x81, 0xab, 0xff, 0x12, 0x2d, 0x8d, 0xf8, 0x75, 0x65,
	0x75, 0x52, 0xf1, 0xdd, 0x84, 0xa5, 0x96, 0x51, 0xb5, 0xf1, 0x35, 0x82, 0x37, 0xe2, 0x42, 0x3b,
	0x2c, 0xb1, 0x0d, 0x3f, 0xfd, 0xa4, 0xcd, 0xfc, 0xcf, 0xbb, 0x5b, 0x5a, 0xcb, 0xdd, 0xd5, 0xa5,
	0x87, 0x2a, 0x3f, 0x40, 0xda, 0xae, 0xda, 0xa6, 0x8e, 0xc0, 0xd4, 0x4f, 0xfd, 0xe6, 0xb9, 0x39,
	0xf2, 0x72, 0x2b, 0x27, 0x5c, 0xaf, 0xff, 0x13, 0x00, 0x00, 0xff, 0xff, 0xd4, 0x50, 0xd6, 0x4d,
	0xd2, 0x0d, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RegistryServiceClient is the client API for RegistryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RegistryServiceClient interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [List] request.
	Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified registry.
	Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists access bindings for the specified registry.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified registry.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified registry.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type registryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRegistryServiceClient(cc grpc.ClientConnInterface) RegistryServiceClient {
	return &registryServiceClient{cc}
}

func (c *registryServiceClient) Get(ctx context.Context, in *GetRegistryRequest, opts ...grpc.CallOption) (*Registry, error) {
	out := new(Registry)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) List(ctx context.Context, in *ListRegistriesRequest, opts ...grpc.CallOption) (*ListRegistriesResponse, error) {
	out := new(ListRegistriesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Create(ctx context.Context, in *CreateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Update(ctx context.Context, in *UpdateRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) Delete(ctx context.Context, in *DeleteRegistryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.containerregistry.v1.RegistryService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RegistryServiceServer is the server API for RegistryService service.
type RegistryServiceServer interface {
	// Returns the specified Registry resource.
	//
	// To get the list of available Registry resources, make a [List] request.
	Get(context.Context, *GetRegistryRequest) (*Registry, error)
	// Retrieves the list of Registry resources in the specified folder.
	List(context.Context, *ListRegistriesRequest) (*ListRegistriesResponse, error)
	// Creates a registry in the specified folder.
	Create(context.Context, *CreateRegistryRequest) (*operation.Operation, error)
	// Updates the specified registry.
	Update(context.Context, *UpdateRegistryRequest) (*operation.Operation, error)
	// Deletes the specified registry.
	Delete(context.Context, *DeleteRegistryRequest) (*operation.Operation, error)
	// Lists access bindings for the specified registry.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the specified registry.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified registry.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
}

// UnimplementedRegistryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRegistryServiceServer struct {
}

func (*UnimplementedRegistryServiceServer) Get(ctx context.Context, req *GetRegistryRequest) (*Registry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedRegistryServiceServer) List(ctx context.Context, req *ListRegistriesRequest) (*ListRegistriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedRegistryServiceServer) Create(ctx context.Context, req *CreateRegistryRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedRegistryServiceServer) Update(ctx context.Context, req *UpdateRegistryRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedRegistryServiceServer) Delete(ctx context.Context, req *DeleteRegistryRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedRegistryServiceServer) ListAccessBindings(ctx context.Context, req *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (*UnimplementedRegistryServiceServer) SetAccessBindings(ctx context.Context, req *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (*UnimplementedRegistryServiceServer) UpdateAccessBindings(ctx context.Context, req *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}

func RegisterRegistryServiceServer(s *grpc.Server, srv RegistryServiceServer) {
	s.RegisterService(&_RegistryService_serviceDesc, srv)
}

func _RegistryService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Get(ctx, req.(*GetRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).List(ctx, req.(*ListRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Create(ctx, req.(*CreateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Update(ctx, req.(*UpdateRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).Delete(ctx, req.(*DeleteRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegistryService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.containerregistry.v1.RegistryService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RegistryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.containerregistry.v1.RegistryService",
	HandlerType: (*RegistryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _RegistryService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _RegistryService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _RegistryService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _RegistryService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _RegistryService_Delete_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _RegistryService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _RegistryService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _RegistryService_UpdateAccessBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/containerregistry/v1/registry_service.proto",
}
