// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/dataproc/v1/cluster.proto

package dataproc

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 4
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 5
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 6
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "STOPPING",
	5: "STOPPED",
	6: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"STOPPING":       4,
	"STOPPED":        5,
	"STARTING":       6,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_62f0592e5d92313c, []int{0, 0}
}

type HadoopConfig_Service int32

const (
	HadoopConfig_SERVICE_UNSPECIFIED HadoopConfig_Service = 0
	HadoopConfig_HDFS                HadoopConfig_Service = 1
	HadoopConfig_YARN                HadoopConfig_Service = 2
	HadoopConfig_MAPREDUCE           HadoopConfig_Service = 3
	HadoopConfig_HIVE                HadoopConfig_Service = 4
	HadoopConfig_TEZ                 HadoopConfig_Service = 5
	HadoopConfig_ZOOKEEPER           HadoopConfig_Service = 6
	HadoopConfig_HBASE               HadoopConfig_Service = 7
	HadoopConfig_SQOOP               HadoopConfig_Service = 8
	HadoopConfig_FLUME               HadoopConfig_Service = 9
	HadoopConfig_SPARK               HadoopConfig_Service = 10
	HadoopConfig_ZEPPELIN            HadoopConfig_Service = 11
	HadoopConfig_OOZIE               HadoopConfig_Service = 12
)

var HadoopConfig_Service_name = map[int32]string{
	0:  "SERVICE_UNSPECIFIED",
	1:  "HDFS",
	2:  "YARN",
	3:  "MAPREDUCE",
	4:  "HIVE",
	5:  "TEZ",
	6:  "ZOOKEEPER",
	7:  "HBASE",
	8:  "SQOOP",
	9:  "FLUME",
	10: "SPARK",
	11: "ZEPPELIN",
	12: "OOZIE",
}

var HadoopConfig_Service_value = map[string]int32{
	"SERVICE_UNSPECIFIED": 0,
	"HDFS":                1,
	"YARN":                2,
	"MAPREDUCE":           3,
	"HIVE":                4,
	"TEZ":                 5,
	"ZOOKEEPER":           6,
	"HBASE":               7,
	"SQOOP":               8,
	"FLUME":               9,
	"SPARK":               10,
	"ZEPPELIN":            11,
	"OOZIE":               12,
}

func (x HadoopConfig_Service) String() string {
	return proto.EnumName(HadoopConfig_Service_name, int32(x))
}

func (HadoopConfig_Service) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_62f0592e5d92313c, []int{2, 0}
}

// A Data Proc cluster. For details about the concept, see [documentation](/docs/data-proc/concepts/).
type Cluster struct {
	// ID of the cluster. Generated at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the cluster. The name is unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the cluster.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Cluster labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Monitoring systems relevant to the cluster.
	Monitoring []*Monitoring `protobuf:"bytes,7,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the cluster.
	Config *ClusterConfig `protobuf:"bytes,8,opt,name=config,proto3" json:"config,omitempty"`
	// Aggregated cluster health.
	Health Health `protobuf:"varint,9,opt,name=health,proto3,enum=yandex.cloud.dataproc.v1.Health" json:"health,omitempty"`
	// Cluster status.
	Status Cluster_Status `protobuf:"varint,10,opt,name=status,proto3,enum=yandex.cloud.dataproc.v1.Cluster_Status" json:"status,omitempty"`
	// ID of the availability zone where the cluster resides.
	ZoneId string `protobuf:"bytes,11,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of service account for the Data Proc manager agent.
	ServiceAccountId string `protobuf:"bytes,12,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Object Storage bucket to be used for Data Proc jobs that are run in the cluster.
	Bucket               string   `protobuf:"bytes,13,opt,name=bucket,proto3" json:"bucket,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_62f0592e5d92313c, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetHealth() Health {
	if m != nil {
		return m.Health
	}
	return Health_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (m *Cluster) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Cluster) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *Cluster) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

// Metadata of a monitoring system for a Data Proc cluster.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_62f0592e5d92313c, []int{1}
}

func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (m *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(m, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

// Hadoop configuration that describes services installed in a cluster,
// their properties and settings.
type HadoopConfig struct {
	// Set of services used in the cluster (if empty, the default set is used).
	Services []HadoopConfig_Service `protobuf:"varint,1,rep,packed,name=services,proto3,enum=yandex.cloud.dataproc.v1.HadoopConfig_Service" json:"services,omitempty"`
	// Properties set for all hosts in `*-site.xml` configurations. The key should indicate
	// the service and the property.
	//
	// For example, use the key 'hdfs:dfs.replication' to set the `dfs.replication` property
	// in the file `/etc/hadoop/conf/hdfs-site.xml`.
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// List of public SSH keys to access to cluster hosts.
	SshPublicKeys        []string `protobuf:"bytes,3,rep,name=ssh_public_keys,json=sshPublicKeys,proto3" json:"ssh_public_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HadoopConfig) Reset()         { *m = HadoopConfig{} }
func (m *HadoopConfig) String() string { return proto.CompactTextString(m) }
func (*HadoopConfig) ProtoMessage()    {}
func (*HadoopConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_62f0592e5d92313c, []int{2}
}

func (m *HadoopConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HadoopConfig.Unmarshal(m, b)
}
func (m *HadoopConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HadoopConfig.Marshal(b, m, deterministic)
}
func (m *HadoopConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HadoopConfig.Merge(m, src)
}
func (m *HadoopConfig) XXX_Size() int {
	return xxx_messageInfo_HadoopConfig.Size(m)
}
func (m *HadoopConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HadoopConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HadoopConfig proto.InternalMessageInfo

func (m *HadoopConfig) GetServices() []HadoopConfig_Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *HadoopConfig) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *HadoopConfig) GetSshPublicKeys() []string {
	if m != nil {
		return m.SshPublicKeys
	}
	return nil
}

type ClusterConfig struct {
	// Image version for cluster provisioning.
	// All available versions are listed in the [documentation](/docs/managed-hadoop/concepts/image-versions).
	VersionId string `protobuf:"bytes,1,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Data Proc specific configuration options.
	Hadoop               *HadoopConfig `protobuf:"bytes,2,opt,name=hadoop,proto3" json:"hadoop,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_62f0592e5d92313c, []int{3}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

func (m *ClusterConfig) GetHadoop() *HadoopConfig {
	if m != nil {
		return m.Hadoop
	}
	return nil
}

func init() {
	proto.RegisterEnum("yandex.cloud.dataproc.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.dataproc.v1.HadoopConfig_Service", HadoopConfig_Service_name, HadoopConfig_Service_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.dataproc.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.dataproc.v1.Monitoring")
	proto.RegisterType((*HadoopConfig)(nil), "yandex.cloud.dataproc.v1.HadoopConfig")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.dataproc.v1.HadoopConfig.PropertiesEntry")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.dataproc.v1.ClusterConfig")
}

func init() {
	proto.RegisterFile("yandex/cloud/dataproc/v1/cluster.proto", fileDescriptor_62f0592e5d92313c)
}

var fileDescriptor_62f0592e5d92313c = []byte{
	// 901 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x95, 0xe1, 0x92, 0xe2, 0x44,
	0x10, 0xc7, 0x0f, 0x02, 0x81, 0x34, 0xbb, 0x7b, 0x53, 0xa3, 0xe5, 0xa5, 0xd6, 0xbb, 0x92, 0xa2,
	0xf4, 0xa4, 0x4a, 0x09, 0xc2, 0xe9, 0xd6, 0x9d, 0x7a, 0x2a, 0x0b, 0xb3, 0x6e, 0xdc, 0x5d, 0x12,
	0x27, 0xb0, 0x96, 0x7c, 0xa1, 0x42, 0x32, 0x0b, 0x29, 0x42, 0x86, 0x4a, 0x02, 0x25, 0x7e, 0xf4,
	0xe3, 0xbd, 0x80, 0x2f, 0xe1, 0x83, 0xec, 0x63, 0x59, 0x99, 0x84, 0x15, 0xac, 0xc2, 0x3b, 0xbf,
	0xf5, 0x74, 0xff, 0xfe, 0x4d, 0x4f, 0x77, 0x67, 0x80, 0xe7, 0x1b, 0x3b, 0x70, 0xd9, 0x6f, 0x4d,
	0xc7, 0xe7, 0x2b, 0xb7, 0xe9, 0xda, 0xb1, 0xbd, 0x0c, 0xb9, 0xd3, 0x5c, 0xb7, 0x9a, 0x8e, 0xbf,
	0x8a, 0x62, 0x16, 0x6a, 0xcb, 0x90, 0xc7, 0x1c, 0xab, 0x29, 0xa7, 0x09, 0x4e, 0xdb, 0x72, 0xda,
	0xba, 0x75, 0xfa, 0xd1, 0x94, 0xf3, 0xa9, 0xcf, 0x9a, 0x82, 0x9b, 0xac, 0xee, 0x9a, 0xb1, 0xb7,
	0x60, 0x51, 0x6c, 0x2f, 0x96, 0xa9, 0xf4, 0xf4, 0x93, 0xc3, 0x3f, 0xc1, 0x17, 0x0b, 0x1e, 0x64,
	0xd8, 0xb3, 0x3d, 0x6c, 0x6d, 0xfb, 0x9e, 0x6b, 0xc7, 0xde, 0x36, 0x5c, 0xfb, 0x53, 0x86, 0x52,
	0x37, 0x2d, 0x09, 0x9f, 0x40, 0xde, 0x73, 0xd5, 0x5c, 0x35, 0x57, 0x57, 0x68, 0xde, 0x73, 0xf1,
	0x87, 0xa0, 0xdc, 0x71, 0xdf, 0x65, 0xe1, 0xd8, 0x73, 0xd5, 0xbc, 0x70, 0x97, 0x53, 0x87, 0xee,
	0xe2, 0x57, 0x00, 0x4e, 0xc8, 0xec, 0x98, 0xb9, 0x63, 0x3b, 0x56, 0xa5, 0x6a, 0xae, 0x5e, 0x69,
	0x9f, 0x6a, 0x69, 0xd1, 0xda, 0xb6, 0x68, 0x6d, 0xb0, 0x2d, 0x9a, 0x2a, 0x19, 0xdd, 0x89, 0xf1,
	0x53, 0x28, 0x04, 0xf6, 0x82, 0xa9, 0x85, 0x24, 0xe5, 0x79, 0xf9, 0xcd, 0x7d, 0xab, 0xd0, 0x6a,
	0x9c, 0xbd, 0xa0, 0xc2, 0x8b, 0x3f, 0x83, 0x8a, 0xcb, 0x22, 0x27, 0xf4, 0x96, 0x49, 0x99, 0x6a,
	0x51, 0x40, 0xca, 0x9b, 0xfb, 0x56, 0xf1, 0x8b, 0x46, 0xfb, 0xab, 0x33, 0xba, 0x1b, 0xc5, 0x06,
	0xc8, 0xbe, 0x3d, 0x61, 0x7e, 0xa4, 0xca, 0x55, 0xa9, 0x5e, 0x69, 0x37, 0xb4, 0x43, 0x0d, 0xd5,
	0xb2, 0x5b, 0x6a, 0xd7, 0x82, 0x27, 0x41, 0x1c, 0x6e, 0xce, 0xcb, 0x7f, 0xdc, 0xb7, 0x0a, 0xdf,
	0xbe, 0x3e, 0xfb, 0x92, 0x66, 0x69, 0x70, 0x0f, 0x60, 0xc1, 0x03, 0x2f, 0xe6, 0xa1, 0x17, 0x4c,
	0xd5, 0x92, 0x48, 0xfa, 0xf1, 0xe1, 0xa4, 0x37, 0x0f, 0x2c, 0xdd, 0xd1, 0xe1, 0xef, 0x41, 0x76,
	0x78, 0x70, 0xe7, 0x4d, 0xd5, 0xb2, 0x68, 0xcc, 0xa7, 0x6f, 0x2d, 0xab, 0x2b, 0x70, 0x9a, 0xc9,
	0xf0, 0x4b, 0x90, 0x67, 0xcc, 0xf6, 0xe3, 0x99, 0xaa, 0x54, 0x73, 0xf5, 0x93, 0x76, 0xf5, 0x70,
	0x82, 0x4b, 0xc1, 0xd1, 0x8c, 0xc7, 0x3f, 0x80, 0x1c, 0xc5, 0x76, 0xbc, 0x8a, 0x54, 0x10, 0xca,
	0xfa, 0xdb, 0x3b, 0x62, 0x09, 0x9e, 0x66, 0x3a, 0xfc, 0x04, 0x4a, 0xbf, 0xf3, 0x80, 0x25, 0x43,
	0xaf, 0x88, 0xa1, 0xcb, 0xc9, 0x51, 0x77, 0xf1, 0xe7, 0x80, 0x23, 0x16, 0xae, 0x3d, 0x87, 0x8d,
	0x6d, 0xc7, 0xe1, 0xab, 0x20, 0x4e, 0x98, 0x23, 0xc1, 0xa0, 0x2c, 0xd2, 0x49, 0x03, 0xba, 0x8b,
	0x3f, 0x00, 0x79, 0xb2, 0x72, 0xe6, 0x2c, 0x56, 0x8f, 0xd3, 0x2c, 0xe9, 0xe9, 0xf4, 0x15, 0x54,
	0x76, 0x46, 0x80, 0x11, 0x48, 0x73, 0xb6, 0xc9, 0xb6, 0x2e, 0x31, 0xf1, 0xfb, 0x50, 0x5c, 0xdb,
	0xfe, 0x8a, 0x65, 0x2b, 0x97, 0x1e, 0xbe, 0xce, 0xbf, 0xcc, 0xd5, 0xe6, 0x20, 0xa7, 0xb5, 0x62,
	0x0c, 0x27, 0xd6, 0xa0, 0x33, 0x18, 0x5a, 0xe3, 0x61, 0xff, 0xaa, 0x6f, 0xfc, 0xd2, 0x47, 0x8f,
	0xf0, 0x11, 0x94, 0xbb, 0x94, 0x74, 0x06, 0x7a, 0xff, 0x47, 0x94, 0xc3, 0x15, 0x28, 0xd1, 0x61,
	0xbf, 0x9f, 0x1c, 0xf2, 0x58, 0x81, 0x22, 0xa1, 0xd4, 0xa0, 0x48, 0x4a, 0x28, 0x6b, 0x60, 0x98,
	0x66, 0x12, 0x28, 0x24, 0x94, 0x38, 0x91, 0x1e, 0x2a, 0xa6, 0xa1, 0x0e, 0x15, 0x09, 0xe4, 0xda,
	0x2d, 0xc0, 0x3f, 0xd3, 0xc5, 0x38, 0xdb, 0xd9, 0xb4, 0xce, 0x74, 0x53, 0xab, 0xfb, 0x9b, 0x9a,
	0x96, 0xbb, 0xb7, 0x9e, 0x18, 0x0a, 0xbe, 0x17, 0xcc, 0xc5, 0xe7, 0xa1, 0x50, 0x61, 0xd7, 0xee,
	0x25, 0x38, 0xba, 0xb4, 0x5d, 0xce, 0x97, 0xe9, 0xcc, 0xf1, 0x4f, 0x50, 0xce, 0x9a, 0x17, 0xa9,
	0xb9, 0xaa, 0x54, 0x3f, 0x69, 0x6b, 0xff, 0x31, 0xed, 0x1d, 0xa5, 0x66, 0xa5, 0x32, 0xfa, 0xa0,
	0xc7, 0xb7, 0x00, 0xcb, 0x90, 0x2f, 0x59, 0x18, 0x7b, 0x2c, 0x52, 0xf3, 0x62, 0x7d, 0xcf, 0xde,
	0x31, 0x9b, 0xf9, 0x20, 0x14, 0x93, 0xa1, 0x3b, 0x99, 0xf0, 0x73, 0x78, 0x1c, 0x45, 0xb3, 0xf1,
	0x72, 0x35, 0xf1, 0x3d, 0x67, 0x3c, 0x67, 0x9b, 0x48, 0x95, 0xaa, 0x52, 0x5d, 0xa1, 0xc7, 0x51,
	0x34, 0x33, 0x85, 0xf7, 0x8a, 0x6d, 0xa2, 0xd3, 0xd7, 0xf0, 0xf8, 0x5f, 0x69, 0xfe, 0xd7, 0x80,
	0xff, 0xca, 0x41, 0x29, 0xbb, 0x14, 0x7e, 0x02, 0xef, 0x59, 0x84, 0xde, 0xea, 0x5d, 0x32, 0x1e,
	0xf6, 0x2d, 0x93, 0x74, 0xf5, 0x0b, 0x9d, 0xf4, 0xd0, 0x23, 0x5c, 0x86, 0xc2, 0x65, 0xef, 0xc2,
	0x42, 0xb9, 0xc4, 0xfa, 0xb5, 0x43, 0xfb, 0x28, 0x8f, 0x8f, 0x41, 0xb9, 0xe9, 0x98, 0x94, 0xf4,
	0x86, 0x5d, 0x82, 0x24, 0x81, 0xe8, 0xb7, 0x04, 0x15, 0x70, 0x09, 0xa4, 0x01, 0x19, 0xa1, 0x62,
	0x42, 0x8c, 0x0c, 0xe3, 0x8a, 0x10, 0x93, 0x50, 0x24, 0x27, 0x1b, 0x71, 0x79, 0xde, 0xb1, 0x08,
	0x2a, 0x25, 0xa6, 0xf5, 0xb3, 0x61, 0x98, 0xa8, 0x9c, 0x98, 0x17, 0xd7, 0xc3, 0x1b, 0x82, 0x14,
	0xe1, 0x35, 0x3b, 0xf4, 0x0a, 0x41, 0xb2, 0x17, 0x23, 0x62, 0x9a, 0xe4, 0x5a, 0xef, 0xa3, 0x4a,
	0x12, 0x30, 0x8c, 0x91, 0x4e, 0xd0, 0x51, 0x2d, 0x80, 0xe3, 0xbd, 0xcf, 0x17, 0x3f, 0x03, 0x58,
	0xb3, 0x30, 0xf2, 0x78, 0x30, 0x7e, 0x78, 0x49, 0x95, 0xcc, 0xa3, 0xbb, 0xf8, 0x3b, 0x90, 0x67,
	0xa2, 0xe3, 0xe2, 0xe6, 0x95, 0xf6, 0xf3, 0x77, 0x9b, 0x0c, 0xcd, 0x54, 0xe7, 0x0c, 0x9e, 0xee,
	0x09, 0xec, 0xa5, 0xb7, 0x2b, 0x1a, 0x91, 0xa9, 0x17, 0xcf, 0x56, 0x13, 0xcd, 0xe1, 0x8b, 0x66,
	0x0a, 0x36, 0xd2, 0x67, 0x7f, 0xca, 0x1b, 0x53, 0x16, 0x88, 0x57, 0xb9, 0x79, 0xe8, 0x6f, 0xe3,
	0x9b, 0xad, 0x3d, 0x91, 0x05, 0xf8, 0xe2, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x81, 0x07, 0x34,
	0xd9, 0xc5, 0x06, 0x00, 0x00,
}
