// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/dataproc/v1/job_service.proto

package dataproc

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetJobRequest struct {
	// ID of the cluster to request a job from.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the job to return.
	//
	// To get a job ID make a [JobService.List] request.
	JobId                string   `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobRequest) Reset()         { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()    {}
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17500a3fdd75bbf9, []int{0}
}

func (m *GetJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobRequest.Unmarshal(m, b)
}
func (m *GetJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobRequest.Marshal(b, m, deterministic)
}
func (m *GetJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobRequest.Merge(m, src)
}
func (m *GetJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobRequest.Size(m)
}
func (m *GetJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobRequest proto.InternalMessageInfo

func (m *GetJobRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type ListJobsRequest struct {
	// ID of the cluster to list jobs for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListJobsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListJobsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters jobs listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [Job.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9].
	// Example of a filter: `name=my-job`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsRequest) Reset()         { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()    {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17500a3fdd75bbf9, []int{1}
}

func (m *ListJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsRequest.Unmarshal(m, b)
}
func (m *ListJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsRequest.Marshal(b, m, deterministic)
}
func (m *ListJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsRequest.Merge(m, src)
}
func (m *ListJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListJobsRequest.Size(m)
}
func (m *ListJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsRequest proto.InternalMessageInfo

func (m *ListJobsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListJobsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListJobsResponse struct {
	// List of jobs for the specified cluster.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListJobsRequest.page_size], use `next_page_token` as the value
	// for the [ListJobsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsResponse) Reset()         { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()    {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17500a3fdd75bbf9, []int{2}
}

func (m *ListJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsResponse.Unmarshal(m, b)
}
func (m *ListJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsResponse.Marshal(b, m, deterministic)
}
func (m *ListJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsResponse.Merge(m, src)
}
func (m *ListJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListJobsResponse.Size(m)
}
func (m *ListJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsResponse proto.InternalMessageInfo

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *ListJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateJobRequest struct {
	// ID of the cluster to create a job for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the job.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Specification for the job.
	//
	// Types that are valid to be assigned to JobSpec:
	//	*CreateJobRequest_MapreduceJob
	//	*CreateJobRequest_SparkJob
	//	*CreateJobRequest_PysparkJob
	//	*CreateJobRequest_HiveJob
	JobSpec              isCreateJobRequest_JobSpec `protobuf_oneof:"job_spec"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *CreateJobRequest) Reset()         { *m = CreateJobRequest{} }
func (m *CreateJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateJobRequest) ProtoMessage()    {}
func (*CreateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17500a3fdd75bbf9, []int{3}
}

func (m *CreateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateJobRequest.Unmarshal(m, b)
}
func (m *CreateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateJobRequest.Marshal(b, m, deterministic)
}
func (m *CreateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateJobRequest.Merge(m, src)
}
func (m *CreateJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateJobRequest.Size(m)
}
func (m *CreateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateJobRequest proto.InternalMessageInfo

func (m *CreateJobRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isCreateJobRequest_JobSpec interface {
	isCreateJobRequest_JobSpec()
}

type CreateJobRequest_MapreduceJob struct {
	MapreduceJob *MapreduceJob `protobuf:"bytes,3,opt,name=mapreduce_job,json=mapreduceJob,proto3,oneof"`
}

type CreateJobRequest_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,4,opt,name=spark_job,json=sparkJob,proto3,oneof"`
}

type CreateJobRequest_PysparkJob struct {
	PysparkJob *PysparkJob `protobuf:"bytes,5,opt,name=pyspark_job,json=pysparkJob,proto3,oneof"`
}

type CreateJobRequest_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,6,opt,name=hive_job,json=hiveJob,proto3,oneof"`
}

func (*CreateJobRequest_MapreduceJob) isCreateJobRequest_JobSpec() {}

func (*CreateJobRequest_SparkJob) isCreateJobRequest_JobSpec() {}

func (*CreateJobRequest_PysparkJob) isCreateJobRequest_JobSpec() {}

func (*CreateJobRequest_HiveJob) isCreateJobRequest_JobSpec() {}

func (m *CreateJobRequest) GetJobSpec() isCreateJobRequest_JobSpec {
	if m != nil {
		return m.JobSpec
	}
	return nil
}

func (m *CreateJobRequest) GetMapreduceJob() *MapreduceJob {
	if x, ok := m.GetJobSpec().(*CreateJobRequest_MapreduceJob); ok {
		return x.MapreduceJob
	}
	return nil
}

func (m *CreateJobRequest) GetSparkJob() *SparkJob {
	if x, ok := m.GetJobSpec().(*CreateJobRequest_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *CreateJobRequest) GetPysparkJob() *PysparkJob {
	if x, ok := m.GetJobSpec().(*CreateJobRequest_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *CreateJobRequest) GetHiveJob() *HiveJob {
	if x, ok := m.GetJobSpec().(*CreateJobRequest_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CreateJobRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CreateJobRequest_MapreduceJob)(nil),
		(*CreateJobRequest_SparkJob)(nil),
		(*CreateJobRequest_PysparkJob)(nil),
		(*CreateJobRequest_HiveJob)(nil),
	}
}

type CreateJobMetadata struct {
	// ID of the cluster that the job is being created for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the job being created.
	JobId                string   `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateJobMetadata) Reset()         { *m = CreateJobMetadata{} }
func (m *CreateJobMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateJobMetadata) ProtoMessage()    {}
func (*CreateJobMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_17500a3fdd75bbf9, []int{4}
}

func (m *CreateJobMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateJobMetadata.Unmarshal(m, b)
}
func (m *CreateJobMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateJobMetadata.Marshal(b, m, deterministic)
}
func (m *CreateJobMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateJobMetadata.Merge(m, src)
}
func (m *CreateJobMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateJobMetadata.Size(m)
}
func (m *CreateJobMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateJobMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateJobMetadata proto.InternalMessageInfo

func (m *CreateJobMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateJobMetadata) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type ListJobLogRequest struct {
	// ID of the cluster that the job is being created for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the job being created.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The maximum bytes of job log per response to return. If the number of available
	// bytes is larger than [page_size], the service returns a [ListJobLogResponse.next_page_token]
	// that can be used to get the next page of output in subsequent list requests.
	// Default value: 1048576.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListJobLogResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobLogRequest) Reset()         { *m = ListJobLogRequest{} }
func (m *ListJobLogRequest) String() string { return proto.CompactTextString(m) }
func (*ListJobLogRequest) ProtoMessage()    {}
func (*ListJobLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17500a3fdd75bbf9, []int{5}
}

func (m *ListJobLogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobLogRequest.Unmarshal(m, b)
}
func (m *ListJobLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobLogRequest.Marshal(b, m, deterministic)
}
func (m *ListJobLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobLogRequest.Merge(m, src)
}
func (m *ListJobLogRequest) XXX_Size() int {
	return xxx_messageInfo_ListJobLogRequest.Size(m)
}
func (m *ListJobLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobLogRequest proto.InternalMessageInfo

func (m *ListJobLogRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListJobLogRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *ListJobLogRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListJobLogRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListJobLogResponse struct {
	// Requested part of Data Proc Job log.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// This token allows you to get the next page of results for ListLog requests,
	// if the number of results is larger than `page_size` specified in the request.
	// To get the next page, specify the value of `next_page_token` as a value for
	// the `page_token` parameter in the next ListLog request. Subsequent ListLog
	// requests will have their own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobLogResponse) Reset()         { *m = ListJobLogResponse{} }
func (m *ListJobLogResponse) String() string { return proto.CompactTextString(m) }
func (*ListJobLogResponse) ProtoMessage()    {}
func (*ListJobLogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17500a3fdd75bbf9, []int{6}
}

func (m *ListJobLogResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobLogResponse.Unmarshal(m, b)
}
func (m *ListJobLogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobLogResponse.Marshal(b, m, deterministic)
}
func (m *ListJobLogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobLogResponse.Merge(m, src)
}
func (m *ListJobLogResponse) XXX_Size() int {
	return xxx_messageInfo_ListJobLogResponse.Size(m)
}
func (m *ListJobLogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobLogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobLogResponse proto.InternalMessageInfo

func (m *ListJobLogResponse) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *ListJobLogResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetJobRequest)(nil), "yandex.cloud.dataproc.v1.GetJobRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "yandex.cloud.dataproc.v1.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "yandex.cloud.dataproc.v1.ListJobsResponse")
	proto.RegisterType((*CreateJobRequest)(nil), "yandex.cloud.dataproc.v1.CreateJobRequest")
	proto.RegisterType((*CreateJobMetadata)(nil), "yandex.cloud.dataproc.v1.CreateJobMetadata")
	proto.RegisterType((*ListJobLogRequest)(nil), "yandex.cloud.dataproc.v1.ListJobLogRequest")
	proto.RegisterType((*ListJobLogResponse)(nil), "yandex.cloud.dataproc.v1.ListJobLogResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/dataproc/v1/job_service.proto", fileDescriptor_17500a3fdd75bbf9)
}

var fileDescriptor_17500a3fdd75bbf9 = []byte{
	// 833 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4d, 0x4f, 0xeb, 0x46,
	0x14, 0xad, 0x5f, 0x4c, 0x48, 0x2e, 0x2f, 0x7a, 0xef, 0xcd, 0xca, 0x8a, 0x40, 0x05, 0xb7, 0xe2,
	0x23, 0x90, 0x38, 0x4e, 0x1b, 0xa0, 0x14, 0x2a, 0x35, 0x55, 0x05, 0x44, 0xd0, 0x22, 0xa7, 0xea,
	0xa2, 0x08, 0x45, 0x63, 0x7b, 0x6a, 0x1c, 0x12, 0x8f, 0x6b, 0x4f, 0x22, 0x08, 0x65, 0xd3, 0x4d,
	0x25, 0x16, 0xdd, 0x74, 0xdd, 0x55, 0x17, 0xdd, 0x57, 0xaa, 0xfa, 0x13, 0xc2, 0xba, 0xfd, 0x0b,
	0x5d, 0x74, 0xdd, 0x4d, 0x25, 0x56, 0x4f, 0x1e, 0x3b, 0xe4, 0x43, 0x18, 0x02, 0xbb, 0x19, 0xdf,
	0xe3, 0x73, 0xcf, 0xdc, 0x7b, 0xcf, 0x0c, 0xe4, 0x2e, 0xb0, 0x63, 0x92, 0x73, 0xc5, 0x68, 0xd2,
	0xb6, 0xa9, 0x98, 0x98, 0x61, 0xd7, 0xa3, 0x86, 0xd2, 0x51, 0x95, 0x06, 0xd5, 0xeb, 0x3e, 0xf1,
	0x3a, 0xb6, 0x41, 0x0a, 0xae, 0x47, 0x19, 0x45, 0x52, 0x88, 0x2d, 0x70, 0x6c, 0xa1, 0x8f, 0x2d,
	0x74, 0xd4, 0xec, 0xac, 0x45, 0xa9, 0xd5, 0x24, 0x0a, 0x76, 0x6d, 0x05, 0x3b, 0x0e, 0x65, 0x98,
	0xd9, 0xd4, 0xf1, 0xc3, 0xff, 0xb2, 0xf2, 0x43, 0x39, 0x22, 0xcc, 0xe2, 0x08, 0x86, 0xba, 0xc4,
	0xe3, 0x14, 0x83, 0x55, 0x84, 0x9b, 0x1b, 0xc1, 0x75, 0x70, 0xd3, 0x36, 0x87, 0xc3, 0xf3, 0x23,
	0xe1, 0x40, 0xce, 0x18, 0x81, 0x8c, 0x21, 0xb3, 0x4b, 0x58, 0x95, 0xea, 0x1a, 0xf9, 0xae, 0x4d,
	0x7c, 0x86, 0x56, 0x01, 0x8c, 0x66, 0xdb, 0x67, 0xc4, 0xab, 0xdb, 0xa6, 0x24, 0xcc, 0x0b, 0xcb,
	0xe9, 0xca, 0xcb, 0x7f, 0x7b, 0xaa, 0x70, 0x7d, 0xa3, 0x8a, 0xdb, 0x3b, 0xe5, 0xa2, 0x96, 0x8e,
	0xe2, 0xfb, 0x26, 0x7a, 0x0f, 0x92, 0x41, 0x5d, 0x6c, 0x53, 0x7a, 0x71, 0x0f, 0x70, 0xaa, 0x41,
	0xf5, 0x7d, 0x53, 0xfe, 0x43, 0x80, 0x57, 0x07, 0xb6, 0x1f, 0x24, 0xf1, 0x9f, 0x95, 0x65, 0x09,
	0xd2, 0x2e, 0xb6, 0x48, 0xdd, 0xb7, 0xbb, 0x84, 0x27, 0x4a, 0x54, 0xe0, 0xb6, 0xa7, 0x26, 0xb7,
	0x77, 0xd4, 0x62, 0xb1, 0xa8, 0xa5, 0x82, 0x60, 0xcd, 0xee, 0x12, 0xb4, 0x0c, 0xc0, 0x81, 0x8c,
	0x9e, 0x11, 0x47, 0x4a, 0x70, 0xd6, 0xf4, 0xf5, 0x8d, 0x3a, 0xc5, 0x91, 0x1a, 0x67, 0xf9, 0x2a,
	0x88, 0x21, 0x19, 0x92, 0xdf, 0xda, 0x4d, 0x46, 0x3c, 0x49, 0xe4, 0x28, 0xb8, 0xbe, 0xb9, 0xe3,
	0x8b, 0x22, 0x72, 0x0b, 0x5e, 0x0f, 0x64, 0xfb, 0x2e, 0x75, 0x7c, 0x82, 0x54, 0x10, 0x1b, 0x54,
	0xf7, 0x25, 0x61, 0x3e, 0xb1, 0x3c, 0x53, 0x9a, 0x2b, 0xc4, 0x8d, 0x40, 0x21, 0xa8, 0x28, 0x87,
	0xa2, 0x45, 0x78, 0xe5, 0x90, 0x73, 0x56, 0x1f, 0x52, 0xc6, 0x8b, 0xa5, 0x65, 0x82, 0xcf, 0x47,
	0x7d, 0x49, 0xf2, 0x2f, 0x09, 0x78, 0xfd, 0x99, 0x47, 0x30, 0x23, 0xcf, 0xed, 0x46, 0x19, 0x44,
	0x07, 0xb7, 0x48, 0xd4, 0x8b, 0x85, 0xff, 0x7a, 0xea, 0xdc, 0xf7, 0xc7, 0x38, 0xdf, 0x3d, 0x39,
	0xce, 0xe3, 0x7c, 0xb7, 0x98, 0xff, 0xe8, 0xe4, 0x52, 0x5d, 0x5b, 0x57, 0xaf, 0x8e, 0xa3, 0x9d,
	0xc6, 0xe1, 0xe8, 0x10, 0x32, 0x2d, 0xec, 0x7a, 0xc4, 0x6c, 0x1b, 0xa4, 0xde, 0xa0, 0x3a, 0x2f,
	0xdc, 0x4c, 0x69, 0x31, 0xfe, 0x70, 0x87, 0x7d, 0x78, 0x95, 0xea, 0x7b, 0xef, 0x68, 0x2f, 0x5b,
	0x43, 0x7b, 0xf4, 0x29, 0xa4, 0x7d, 0x17, 0x7b, 0x67, 0x9c, 0x4a, 0xe4, 0x54, 0x72, 0x3c, 0x55,
	0x2d, 0x80, 0x86, 0x34, 0x29, 0x3f, 0x5a, 0xa3, 0x5d, 0x98, 0x71, 0x2f, 0x06, 0x24, 0x53, 0x9c,
	0xe4, 0xfd, 0x78, 0x92, 0xa3, 0x0b, 0x7f, 0x40, 0x03, 0xee, 0xdd, 0x0e, 0x7d, 0x02, 0xa9, 0x53,
	0xbb, 0x13, 0x9e, 0x2a, 0xc9, 0x59, 0x16, 0xe2, 0x59, 0xf6, 0xec, 0x4e, 0x74, 0xa0, 0xe9, 0xd3,
	0x70, 0x59, 0x01, 0x48, 0x71, 0xdf, 0xbb, 0xc4, 0x90, 0x31, 0xbc, 0xb9, 0x6b, 0xcf, 0x21, 0x61,
	0x38, 0xf8, 0xf5, 0x69, 0xfd, 0x79, 0x77, 0xcc, 0x2d, 0xa9, 0x71, 0xa7, 0xfc, 0x29, 0xc0, 0x9b,
	0x68, 0xe4, 0x0e, 0xa8, 0xf5, 0xac, 0x19, 0x78, 0x2c, 0x07, 0xca, 0x0d, 0x9b, 0x29, 0xc1, 0xcd,
	0x94, 0xb9, 0xed, 0xa9, 0xe9, 0x60, 0xf8, 0x3f, 0xdc, 0x2c, 0x6f, 0xac, 0xc7, 0xfa, 0x49, 0x8c,
	0xf7, 0x93, 0xfc, 0x35, 0xa0, 0x61, 0xe1, 0x91, 0x5b, 0x24, 0x98, 0x36, 0xa8, 0xc3, 0x88, 0xc3,
	0x42, 0xd9, 0x5a, 0x7f, 0x3b, 0xa9, 0x29, 0x4a, 0xff, 0x8b, 0x00, 0x55, 0xaa, 0xd7, 0xc2, 0x8b,
	0x17, 0xfd, 0x24, 0x80, 0x18, 0xe4, 0x41, 0x2b, 0xf1, 0x6d, 0x1c, 0xbb, 0x6a, 0xb2, 0xb9, 0x49,
	0xa0, 0xa1, 0x60, 0x59, 0xf9, 0xe1, 0xef, 0x7f, 0x7e, 0x7e, 0xb1, 0x82, 0x96, 0x46, 0xae, 0xe5,
	0xa8, 0xba, 0xbe, 0x72, 0x39, 0xe8, 0xc3, 0x95, 0xc2, 0xcd, 0xfd, 0x9b, 0x00, 0xc9, 0x70, 0x2a,
	0xd0, 0x03, 0x79, 0xc6, 0x6d, 0x9d, 0x1d, 0x9b, 0xc2, 0xc1, 0xa5, 0xfc, 0x65, 0x7f, 0x25, 0x7f,
	0xf1, 0xfb, 0x5f, 0x39, 0xe9, 0xbe, 0x91, 0x4b, 0x54, 0xa9, 0xce, 0x65, 0xae, 0xc9, 0x93, 0xca,
	0xdc, 0x12, 0x72, 0xe8, 0x47, 0x01, 0x12, 0xbb, 0x84, 0xa1, 0xa5, 0x78, 0x99, 0x23, 0x0f, 0x41,
	0xf6, 0xe1, 0xcb, 0x4d, 0xde, 0xe4, 0x1a, 0x4a, 0xa8, 0x38, 0xa1, 0x06, 0xe5, 0x32, 0x9c, 0xcb,
	0x2b, 0xf4, 0xab, 0x00, 0xd3, 0x41, 0xe5, 0x0f, 0xa8, 0x85, 0x56, 0x1f, 0x6d, 0xce, 0xc0, 0x08,
	0xd9, 0xb5, 0xc9, 0xc0, 0x51, 0x2f, 0x77, 0xb8, 0xc0, 0x0d, 0x54, 0x7e, 0xaa, 0xc0, 0xad, 0x26,
	0xb5, 0xfc, 0xca, 0x19, 0xcc, 0x8e, 0x64, 0xc3, 0xae, 0x3d, 0x9c, 0xb1, 0x22, 0x1e, 0xed, 0x55,
	0x6b, 0xdf, 0x7c, 0x6e, 0xd9, 0xec, 0xb4, 0xad, 0x17, 0x0c, 0xda, 0x52, 0x42, 0x78, 0x3e, 0x7c,
	0x6b, 0x2d, 0x9a, 0xb7, 0x88, 0xc3, 0xdf, 0x58, 0x25, 0xee, 0xbd, 0xff, 0xb8, 0xbf, 0xd6, 0x93,
	0x1c, 0xf8, 0xc1, 0xdb, 0x00, 0x00, 0x00, 0xff, 0xff, 0x23, 0xb0, 0x91, 0x1d, 0x7f, 0x08, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Retrieves a list of jobs for a cluster.
	List(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Creates a job for a cluster.
	Create(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the specified job.
	Get(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Returns a log for specified job.
	ListLog(ctx context.Context, in *ListJobLogRequest, opts ...grpc.CallOption) (*ListJobLogResponse, error)
}

type jobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewJobServiceClient(cc grpc.ClientConnInterface) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) List(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.JobService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Create(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.JobService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Get(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.JobService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListLog(ctx context.Context, in *ListJobLogRequest, opts ...grpc.CallOption) (*ListJobLogResponse, error) {
	out := new(ListJobLogResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.dataproc.v1.JobService/ListLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Retrieves a list of jobs for a cluster.
	List(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Creates a job for a cluster.
	Create(context.Context, *CreateJobRequest) (*operation.Operation, error)
	// Returns the specified job.
	Get(context.Context, *GetJobRequest) (*Job, error)
	// Returns a log for specified job.
	ListLog(context.Context, *ListJobLogRequest) (*ListJobLogResponse, error)
}

// UnimplementedJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedJobServiceServer struct {
}

func (*UnimplementedJobServiceServer) List(ctx context.Context, req *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedJobServiceServer) Create(ctx context.Context, req *CreateJobRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedJobServiceServer) Get(ctx context.Context, req *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedJobServiceServer) ListLog(ctx context.Context, req *ListJobLogRequest) (*ListJobLogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLog not implemented")
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.JobService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).List(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.JobService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Create(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.JobService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Get(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.dataproc.v1.JobService/ListLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListLog(ctx, req.(*ListJobLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.dataproc.v1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _JobService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _JobService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _JobService_Get_Handler,
		},
		{
			MethodName: "ListLog",
			Handler:    _JobService_ListLog_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/dataproc/v1/job_service.proto",
}
