// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/iam/v1/key_service.proto

package iam

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type KeyFormat int32

const (
	// Privacy-Enhanced Mail (PEM) format. Default value.
	KeyFormat_PEM_FILE KeyFormat = 0
)

var KeyFormat_name = map[int32]string{
	0: "PEM_FILE",
}

var KeyFormat_value = map[string]int32{
	"PEM_FILE": 0,
}

func (x KeyFormat) String() string {
	return proto.EnumName(KeyFormat_name, int32(x))
}

func (KeyFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{0}
}

type GetKeyRequest struct {
	// ID of the Key resource to return.
	// To get the ID use a [KeyService.List] request.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Output format of the key.
	Format               KeyFormat `protobuf:"varint,2,opt,name=format,proto3,enum=yandex.cloud.iam.v1.KeyFormat" json:"format,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetKeyRequest) Reset()         { *m = GetKeyRequest{} }
func (m *GetKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeyRequest) ProtoMessage()    {}
func (*GetKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{0}
}

func (m *GetKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeyRequest.Unmarshal(m, b)
}
func (m *GetKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeyRequest.Merge(m, src)
}
func (m *GetKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeyRequest.Size(m)
}
func (m *GetKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeyRequest proto.InternalMessageInfo

func (m *GetKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *GetKeyRequest) GetFormat() KeyFormat {
	if m != nil {
		return m.Format
	}
	return KeyFormat_PEM_FILE
}

type ListKeysRequest struct {
	// Output format of the key.
	Format KeyFormat `protobuf:"varint,1,opt,name=format,proto3,enum=yandex.cloud.iam.v1.KeyFormat" json:"format,omitempty"`
	// ID of the service account to list key pairs for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,2,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListKeysResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListKeysResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeysRequest) Reset()         { *m = ListKeysRequest{} }
func (m *ListKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListKeysRequest) ProtoMessage()    {}
func (*ListKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{1}
}

func (m *ListKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeysRequest.Unmarshal(m, b)
}
func (m *ListKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeysRequest.Merge(m, src)
}
func (m *ListKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListKeysRequest.Size(m)
}
func (m *ListKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeysRequest proto.InternalMessageInfo

func (m *ListKeysRequest) GetFormat() KeyFormat {
	if m != nil {
		return m.Format
	}
	return KeyFormat_PEM_FILE
}

func (m *ListKeysRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *ListKeysRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListKeysResponse struct {
	// List of Key resources.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListKeysRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListKeysRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeysResponse) Reset()         { *m = ListKeysResponse{} }
func (m *ListKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListKeysResponse) ProtoMessage()    {}
func (*ListKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{2}
}

func (m *ListKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeysResponse.Unmarshal(m, b)
}
func (m *ListKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeysResponse.Merge(m, src)
}
func (m *ListKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListKeysResponse.Size(m)
}
func (m *ListKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeysResponse proto.InternalMessageInfo

func (m *ListKeysResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *ListKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateKeyRequest struct {
	// ID of the service account to create a key pair for.
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	// If not specified, it defaults to the subject that made the request.
	ServiceAccountId string `protobuf:"bytes,1,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Description of the key pair.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output format of the key.
	Format KeyFormat `protobuf:"varint,3,opt,name=format,proto3,enum=yandex.cloud.iam.v1.KeyFormat" json:"format,omitempty"`
	// An algorithm used to generate a key pair of the Key resource.
	KeyAlgorithm         Key_Algorithm `protobuf:"varint,4,opt,name=key_algorithm,json=keyAlgorithm,proto3,enum=yandex.cloud.iam.v1.Key_Algorithm" json:"key_algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateKeyRequest) Reset()         { *m = CreateKeyRequest{} }
func (m *CreateKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateKeyRequest) ProtoMessage()    {}
func (*CreateKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{3}
}

func (m *CreateKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyRequest.Unmarshal(m, b)
}
func (m *CreateKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyRequest.Merge(m, src)
}
func (m *CreateKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateKeyRequest.Size(m)
}
func (m *CreateKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyRequest proto.InternalMessageInfo

func (m *CreateKeyRequest) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *CreateKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateKeyRequest) GetFormat() KeyFormat {
	if m != nil {
		return m.Format
	}
	return KeyFormat_PEM_FILE
}

func (m *CreateKeyRequest) GetKeyAlgorithm() Key_Algorithm {
	if m != nil {
		return m.KeyAlgorithm
	}
	return Key_ALGORITHM_UNSPECIFIED
}

type CreateKeyResponse struct {
	// Key resource.
	Key *Key `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// A private key of the Key resource.
	// This key must be stored securely.
	PrivateKey           string   `protobuf:"bytes,2,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateKeyResponse) Reset()         { *m = CreateKeyResponse{} }
func (m *CreateKeyResponse) String() string { return proto.CompactTextString(m) }
func (*CreateKeyResponse) ProtoMessage()    {}
func (*CreateKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{4}
}

func (m *CreateKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyResponse.Unmarshal(m, b)
}
func (m *CreateKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyResponse.Marshal(b, m, deterministic)
}
func (m *CreateKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyResponse.Merge(m, src)
}
func (m *CreateKeyResponse) XXX_Size() int {
	return xxx_messageInfo_CreateKeyResponse.Size(m)
}
func (m *CreateKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyResponse proto.InternalMessageInfo

func (m *CreateKeyResponse) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *CreateKeyResponse) GetPrivateKey() string {
	if m != nil {
		return m.PrivateKey
	}
	return ""
}

type UpdateKeyRequest struct {
	// ID of the Key resource to update.
	// To get key pair ID, use a [KeyService.List] request.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Field mask that specifies which fields of the Key resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Description of the key pair.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateKeyRequest) Reset()         { *m = UpdateKeyRequest{} }
func (m *UpdateKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateKeyRequest) ProtoMessage()    {}
func (*UpdateKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{5}
}

func (m *UpdateKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateKeyRequest.Unmarshal(m, b)
}
func (m *UpdateKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateKeyRequest.Merge(m, src)
}
func (m *UpdateKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateKeyRequest.Size(m)
}
func (m *UpdateKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateKeyRequest proto.InternalMessageInfo

func (m *UpdateKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *UpdateKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type UpdateKeyMetadata struct {
	// ID of the Key resource that is being updated.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateKeyMetadata) Reset()         { *m = UpdateKeyMetadata{} }
func (m *UpdateKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateKeyMetadata) ProtoMessage()    {}
func (*UpdateKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{6}
}

func (m *UpdateKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateKeyMetadata.Unmarshal(m, b)
}
func (m *UpdateKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateKeyMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateKeyMetadata.Merge(m, src)
}
func (m *UpdateKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateKeyMetadata.Size(m)
}
func (m *UpdateKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateKeyMetadata proto.InternalMessageInfo

func (m *UpdateKeyMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type DeleteKeyRequest struct {
	// ID of the key to delete.
	// To get key ID use a [KeyService.List] request.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteKeyRequest) Reset()         { *m = DeleteKeyRequest{} }
func (m *DeleteKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteKeyRequest) ProtoMessage()    {}
func (*DeleteKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{7}
}

func (m *DeleteKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteKeyRequest.Unmarshal(m, b)
}
func (m *DeleteKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteKeyRequest.Merge(m, src)
}
func (m *DeleteKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteKeyRequest.Size(m)
}
func (m *DeleteKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteKeyRequest proto.InternalMessageInfo

func (m *DeleteKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type DeleteKeyMetadata struct {
	// ID of the key that is being deleted.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteKeyMetadata) Reset()         { *m = DeleteKeyMetadata{} }
func (m *DeleteKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteKeyMetadata) ProtoMessage()    {}
func (*DeleteKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{8}
}

func (m *DeleteKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteKeyMetadata.Unmarshal(m, b)
}
func (m *DeleteKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteKeyMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteKeyMetadata.Merge(m, src)
}
func (m *DeleteKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteKeyMetadata.Size(m)
}
func (m *DeleteKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteKeyMetadata proto.InternalMessageInfo

func (m *DeleteKeyMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type ListKeyOperationsRequest struct {
	// ID of the key to list operations for.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListKeyOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListKeyOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyOperationsRequest) Reset()         { *m = ListKeyOperationsRequest{} }
func (m *ListKeyOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListKeyOperationsRequest) ProtoMessage()    {}
func (*ListKeyOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{9}
}

func (m *ListKeyOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyOperationsRequest.Unmarshal(m, b)
}
func (m *ListKeyOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListKeyOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyOperationsRequest.Merge(m, src)
}
func (m *ListKeyOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListKeyOperationsRequest.Size(m)
}
func (m *ListKeyOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyOperationsRequest proto.InternalMessageInfo

func (m *ListKeyOperationsRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *ListKeyOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKeyOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListKeyOperationsResponse struct {
	// List of operations for the specified key.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListKeyOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListKeyOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyOperationsResponse) Reset()         { *m = ListKeyOperationsResponse{} }
func (m *ListKeyOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListKeyOperationsResponse) ProtoMessage()    {}
func (*ListKeyOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_dce2d1f6e04851f2, []int{10}
}

func (m *ListKeyOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyOperationsResponse.Unmarshal(m, b)
}
func (m *ListKeyOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListKeyOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyOperationsResponse.Merge(m, src)
}
func (m *ListKeyOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListKeyOperationsResponse.Size(m)
}
func (m *ListKeyOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyOperationsResponse proto.InternalMessageInfo

func (m *ListKeyOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListKeyOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("yandex.cloud.iam.v1.KeyFormat", KeyFormat_name, KeyFormat_value)
	proto.RegisterType((*GetKeyRequest)(nil), "yandex.cloud.iam.v1.GetKeyRequest")
	proto.RegisterType((*ListKeysRequest)(nil), "yandex.cloud.iam.v1.ListKeysRequest")
	proto.RegisterType((*ListKeysResponse)(nil), "yandex.cloud.iam.v1.ListKeysResponse")
	proto.RegisterType((*CreateKeyRequest)(nil), "yandex.cloud.iam.v1.CreateKeyRequest")
	proto.RegisterType((*CreateKeyResponse)(nil), "yandex.cloud.iam.v1.CreateKeyResponse")
	proto.RegisterType((*UpdateKeyRequest)(nil), "yandex.cloud.iam.v1.UpdateKeyRequest")
	proto.RegisterType((*UpdateKeyMetadata)(nil), "yandex.cloud.iam.v1.UpdateKeyMetadata")
	proto.RegisterType((*DeleteKeyRequest)(nil), "yandex.cloud.iam.v1.DeleteKeyRequest")
	proto.RegisterType((*DeleteKeyMetadata)(nil), "yandex.cloud.iam.v1.DeleteKeyMetadata")
	proto.RegisterType((*ListKeyOperationsRequest)(nil), "yandex.cloud.iam.v1.ListKeyOperationsRequest")
	proto.RegisterType((*ListKeyOperationsResponse)(nil), "yandex.cloud.iam.v1.ListKeyOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/iam/v1/key_service.proto", fileDescriptor_dce2d1f6e04851f2)
}

var fileDescriptor_dce2d1f6e04851f2 = []byte{
	// 923 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0x41, 0x73, 0xdb, 0x44,
	0x14, 0x66, 0xe3, 0xd4, 0x93, 0x3c, 0x27, 0xa9, 0xb3, 0xd0, 0x89, 0xab, 0xa1, 0x60, 0x04, 0x0d,
	0x1e, 0x43, 0x24, 0xdb, 0x4c, 0xc3, 0x0c, 0x49, 0x0f, 0x09, 0x24, 0x99, 0x8c, 0x9b, 0xa1, 0xa3,
	0x02, 0x07, 0x2e, 0x66, 0x63, 0xbd, 0x38, 0x3b, 0xb6, 0x25, 0x61, 0xad, 0x3d, 0x55, 0x19, 0x2e,
	0x1c, 0x38, 0xf4, 0xc4, 0xc0, 0x89, 0x0b, 0x0c, 0x7f, 0xa1, 0x7f, 0xa2, 0x3d, 0x17, 0x7e, 0x02,
	0x07, 0x7e, 0x02, 0xc3, 0x89, 0xd9, 0x95, 0x2c, 0x4b, 0xae, 0x6c, 0x27, 0x37, 0x4b, 0xef, 0xdb,
	0xf7, 0xbd, 0xfd, 0xde, 0xfb, 0x9e, 0x05, 0x77, 0x03, 0xe6, 0xd8, 0xf8, 0xd8, 0x6c, 0xf7, 0xdc,
	0xa1, 0x6d, 0x72, 0xd6, 0x37, 0x47, 0x75, 0xb3, 0x8b, 0x41, 0xcb, 0xc7, 0xc1, 0x88, 0xb7, 0xd1,
	0xf0, 0x06, 0xae, 0x70, 0xe9, 0xeb, 0x21, 0xcc, 0x50, 0x30, 0x83, 0xb3, 0xbe, 0x31, 0xaa, 0x6b,
	0x6f, 0x76, 0x5c, 0xb7, 0xd3, 0x43, 0x93, 0x79, 0xdc, 0x64, 0x8e, 0xe3, 0x0a, 0x26, 0xb8, 0xeb,
	0xf8, 0xe1, 0x11, 0xad, 0x1c, 0x45, 0xd5, 0xd3, 0xf9, 0xf0, 0xc2, 0xbc, 0xe0, 0xd8, 0xb3, 0x5b,
	0x7d, 0xe6, 0x77, 0x23, 0xc4, 0x9d, 0x19, 0xdc, 0xe3, 0x04, 0xa9, 0xb0, 0x24, 0x71, 0x3d, 0x1c,
	0x28, 0x8e, 0x08, 0xb1, 0x9d, 0x42, 0xc4, 0xd1, 0x57, 0x70, 0x69, 0xa2, 0x11, 0xeb, 0x71, 0x3b,
	0x11, 0xd6, 0x7b, 0xb0, 0x7e, 0x82, 0xa2, 0x89, 0x81, 0x85, 0xdf, 0x0e, 0xd1, 0x17, 0xf4, 0x5d,
	0xc8, 0x4b, 0x09, 0xb8, 0x5d, 0x22, 0x65, 0x52, 0x59, 0x3d, 0x5c, 0xfb, 0xe7, 0x79, 0x9d, 0x3c,
	0x7d, 0x51, 0x5f, 0xde, 0xbf, 0x7f, 0xaf, 0x66, 0xdd, 0xe8, 0x62, 0x70, 0x6a, 0xd3, 0x5d, 0xc8,
	0x5f, 0xb8, 0x83, 0x3e, 0x13, 0xa5, 0xa5, 0x32, 0xa9, 0x6c, 0x34, 0xde, 0x32, 0x32, 0x34, 0x32,
	0x9a, 0x18, 0x1c, 0x2b, 0x94, 0x15, 0xa1, 0xf5, 0xbf, 0x08, 0xdc, 0x7c, 0xc0, 0x7d, 0xc9, 0xe7,
	0x8f, 0x09, 0x27, 0xb9, 0xc8, 0x75, 0x72, 0xd1, 0x5d, 0xa0, 0x51, 0x9f, 0x5a, 0xac, 0xdd, 0x76,
	0x87, 0x8e, 0x90, 0x45, 0x2f, 0xa9, 0xa2, 0x57, 0xe2, 0x82, 0x8b, 0x11, 0xe6, 0x20, 0x84, 0x9c,
	0xda, 0xf4, 0x7d, 0x58, 0xf5, 0x58, 0x07, 0x5b, 0x3e, 0x7f, 0x82, 0xa5, 0x5c, 0x99, 0x54, 0x72,
	0x87, 0xf0, 0xdf, 0xf3, 0x7a, 0x7e, 0xff, 0x7e, 0xbd, 0x56, 0xab, 0x59, 0x2b, 0x32, 0xf8, 0x88,
	0x3f, 0x41, 0x5a, 0x01, 0x50, 0x40, 0xe1, 0x76, 0xd1, 0x29, 0x2d, 0xab, 0xc4, 0xab, 0x4f, 0x5f,
	0xd4, 0x6f, 0x28, 0xa4, 0xa5, 0xb2, 0x7c, 0x21, 0x63, 0xfa, 0x25, 0x14, 0x27, 0xb7, 0xf2, 0x3d,
	0xd7, 0xf1, 0x91, 0x7e, 0x08, 0xcb, 0x5d, 0x0c, 0xfc, 0x12, 0x29, 0xe7, 0x2a, 0x85, 0x46, 0x69,
	0xd6, 0xa5, 0x2c, 0x85, 0xa2, 0xdb, 0x70, 0xd3, 0xc1, 0xc7, 0xa2, 0x95, 0x20, 0x54, 0x37, 0xb1,
	0xd6, 0xe5, 0xeb, 0x87, 0x31, 0xd3, 0xbf, 0x04, 0x8a, 0x9f, 0x0e, 0x90, 0x09, 0x4c, 0xb4, 0x2c,
	0x5b, 0x09, 0xb2, 0x50, 0x89, 0x0f, 0xa0, 0x60, 0xa3, 0xdf, 0x1e, 0x70, 0x4f, 0x0e, 0x44, 0x24,
	0x5d, 0x74, 0xc3, 0xc6, 0xbd, 0x5d, 0x2b, 0x19, 0x4d, 0xb4, 0x29, 0x77, 0xad, 0x36, 0x9d, 0xc0,
	0xba, 0x9c, 0x27, 0xd6, 0xeb, 0xb8, 0x03, 0x2e, 0x2e, 0xfb, 0x4a, 0xc8, 0x8d, 0x86, 0x3e, 0xeb,
	0xb8, 0x71, 0x30, 0x46, 0x5a, 0x6b, 0x5d, 0x0c, 0xe2, 0x27, 0xfd, 0x1b, 0xd8, 0x4c, 0xdc, 0x3c,
	0x52, 0xb9, 0x0a, 0xb9, 0x2e, 0x06, 0xea, 0xae, 0xf3, 0x44, 0x96, 0x20, 0xfa, 0x36, 0x14, 0xbc,
	0x01, 0x1f, 0x31, 0x81, 0x2d, 0x79, 0x26, 0xd4, 0x17, 0xa2, 0x57, 0x4d, 0x0c, 0xf4, 0x3f, 0x08,
	0x14, 0xbf, 0xf4, 0xec, 0xb4, 0xb8, 0x57, 0xf2, 0xc3, 0x1e, 0x14, 0x86, 0xea, 0xa0, 0xb2, 0xb8,
	0x4a, 0x5d, 0x68, 0x68, 0x46, 0xb8, 0x05, 0x8c, 0xf1, 0x16, 0x30, 0x8e, 0xe5, 0x16, 0x38, 0x63,
	0x7e, 0xd7, 0x82, 0x10, 0x2e, 0x7f, 0x4f, 0xb7, 0x21, 0x37, 0xaf, 0x0d, 0x7a, 0x15, 0x36, 0xe3,
	0x12, 0xcf, 0x50, 0x30, 0x9b, 0x09, 0x46, 0x6f, 0xa5, 0x6b, 0x8c, 0xaa, 0xd2, 0x3f, 0x86, 0xe2,
	0x67, 0xd8, 0xc3, 0x6b, 0x5f, 0x47, 0x92, 0xc4, 0x07, 0x17, 0x91, 0xfc, 0x4c, 0xa0, 0x14, 0x0d,
	0xff, 0xe7, 0xe3, 0xd5, 0xe3, 0x5f, 0x4b, 0xbc, 0x94, 0x21, 0x97, 0x26, 0x86, 0xac, 0xed, 0xcc,
	0x35, 0x64, 0x6e, 0x8e, 0x21, 0x7f, 0x24, 0x70, 0x3b, 0xa3, 0xa8, 0x68, 0x68, 0x0e, 0x00, 0xe2,
	0x2d, 0x39, 0x36, 0xe8, 0x3b, 0xe9, 0xd9, 0x99, 0x6c, 0xd1, 0xf8, 0xbc, 0x95, 0x38, 0x74, 0x55,
	0xbf, 0x56, 0x6f, 0xc3, 0x6a, 0x6c, 0x09, 0xba, 0x06, 0x2b, 0x0f, 0x8f, 0xce, 0x5a, 0xc7, 0xa7,
	0x0f, 0x8e, 0x8a, 0xaf, 0x35, 0x7e, 0xcb, 0x03, 0x34, 0x31, 0x78, 0x14, 0xba, 0x92, 0x9e, 0x43,
	0xee, 0x04, 0x05, 0xcd, 0xf6, 0x45, 0x6a, 0x45, 0x6b, 0x33, 0xe7, 0x5c, 0xbf, 0xf3, 0xc3, 0x9f,
	0x7f, 0xff, 0xb2, 0xb4, 0x45, 0x6f, 0x25, 0xfe, 0x51, 0x7c, 0xf3, 0xbb, 0xb0, 0x07, 0xdf, 0x53,
	0x0e, 0xcb, 0x52, 0x15, 0xfa, 0x5e, 0x66, 0x82, 0xa9, 0xc5, 0xac, 0xdd, 0x5d, 0x80, 0x0a, 0xd5,
	0xd4, 0xdf, 0x50, 0x9c, 0x1b, 0x74, 0x2d, 0xc9, 0x49, 0x3d, 0xc8, 0x87, 0x6e, 0xa5, 0xd9, 0x69,
	0xa6, 0x97, 0x98, 0xb6, 0xbd, 0x08, 0x16, 0xd1, 0x6d, 0x29, 0xba, 0x4d, 0x3d, 0x45, 0xf7, 0x09,
	0xa9, 0xd2, 0x9f, 0x08, 0xe4, 0x43, 0x6b, 0xcc, 0xa0, 0x9c, 0xb6, 0xb6, 0xb6, 0xb8, 0xe7, 0xfa,
	0xfe, 0xb3, 0x97, 0xd5, 0x52, 0x96, 0xe5, 0x72, 0x4d, 0x0c, 0x54, 0x25, 0x5a, 0x23, 0x5b, 0x6c,
	0x59, 0xd2, 0xef, 0x04, 0xf2, 0xa1, 0x91, 0x66, 0x94, 0x34, 0x6d, 0xcf, 0xab, 0x94, 0xd4, 0x7c,
	0xf6, 0xb2, 0x9a, 0x6d, 0xd0, 0xe9, 0x75, 0x73, 0xd4, 0xf7, 0x44, 0x58, 0xe4, 0x56, 0x75, 0xc6,
	0x44, 0xfc, 0x4a, 0x60, 0x43, 0x76, 0x74, 0xe2, 0x12, 0xba, 0x33, 0xaf, 0xed, 0xaf, 0x58, 0x5c,
	0x33, 0xae, 0x0a, 0x8f, 0xfa, 0x57, 0x51, 0x05, 0xe9, 0xb4, 0x9c, 0x59, 0xd0, 0xe4, 0xf3, 0xc5,
	0x3f, 0xfc, 0x0a, 0xb6, 0x52, 0xa9, 0x99, 0xc7, 0xa3, 0xf4, 0x5f, 0xef, 0x75, 0xb8, 0xb8, 0x1c,
	0x9e, 0x1b, 0x6d, 0xb7, 0x6f, 0x86, 0x98, 0x9d, 0xf0, 0xfb, 0xa6, 0xe3, 0xee, 0x74, 0xd0, 0x51,
	0x0a, 0x98, 0x19, 0x5f, 0x58, 0x7b, 0x9c, 0xf5, 0xcf, 0xf3, 0x2a, 0xfc, 0xd1, 0xff, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xde, 0xfb, 0x78, 0xd3, 0xff, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// KeyServiceClient is the client API for KeyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeyServiceClient interface {
	// Returns the specified Key resource.
	//
	// To get the list of available Key resources, make a [List] request.
	Get(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Retrieves the list of Key resources for the specified service account.
	List(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// Creates a key pair for the specified service account.
	Create(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*CreateKeyResponse, error)
	// Updates the specified key pair.
	Update(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified key pair.
	Delete(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified key.
	ListOperations(ctx context.Context, in *ListKeyOperationsRequest, opts ...grpc.CallOption) (*ListKeyOperationsResponse, error)
}

type keyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKeyServiceClient(cc grpc.ClientConnInterface) KeyServiceClient {
	return &keyServiceClient{cc}
}

func (c *keyServiceClient) Get(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) List(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) Create(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*CreateKeyResponse, error) {
	out := new(CreateKeyResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) Update(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) Delete(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyServiceClient) ListOperations(ctx context.Context, in *ListKeyOperationsRequest, opts ...grpc.CallOption) (*ListKeyOperationsResponse, error) {
	out := new(ListKeyOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iam.v1.KeyService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyServiceServer is the server API for KeyService service.
type KeyServiceServer interface {
	// Returns the specified Key resource.
	//
	// To get the list of available Key resources, make a [List] request.
	Get(context.Context, *GetKeyRequest) (*Key, error)
	// Retrieves the list of Key resources for the specified service account.
	List(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// Creates a key pair for the specified service account.
	Create(context.Context, *CreateKeyRequest) (*CreateKeyResponse, error)
	// Updates the specified key pair.
	Update(context.Context, *UpdateKeyRequest) (*operation.Operation, error)
	// Deletes the specified key pair.
	Delete(context.Context, *DeleteKeyRequest) (*operation.Operation, error)
	// Lists operations for the specified key.
	ListOperations(context.Context, *ListKeyOperationsRequest) (*ListKeyOperationsResponse, error)
}

// UnimplementedKeyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedKeyServiceServer struct {
}

func (*UnimplementedKeyServiceServer) Get(ctx context.Context, req *GetKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedKeyServiceServer) List(ctx context.Context, req *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedKeyServiceServer) Create(ctx context.Context, req *CreateKeyRequest) (*CreateKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedKeyServiceServer) Update(ctx context.Context, req *UpdateKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedKeyServiceServer) Delete(ctx context.Context, req *DeleteKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedKeyServiceServer) ListOperations(ctx context.Context, req *ListKeyOperationsRequest) (*ListKeyOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}

func RegisterKeyServiceServer(s *grpc.Server, srv KeyServiceServer) {
	s.RegisterService(&_KeyService_serviceDesc, srv)
}

func _KeyService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).Get(ctx, req.(*GetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).List(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).Create(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).Update(ctx, req.(*UpdateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).Delete(ctx, req.(*DeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iam.v1.KeyService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyServiceServer).ListOperations(ctx, req.(*ListKeyOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iam.v1.KeyService",
	HandlerType: (*KeyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _KeyService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _KeyService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _KeyService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _KeyService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _KeyService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _KeyService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iam/v1/key_service.proto",
}
