// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/iot/devices/v1/device_service.proto

package devices

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetDeviceRequest struct {
	// ID of the device to return.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDeviceRequest) Reset()         { *m = GetDeviceRequest{} }
func (m *GetDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceRequest) ProtoMessage()    {}
func (*GetDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{0}
}

func (m *GetDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceRequest.Unmarshal(m, b)
}
func (m *GetDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceRequest.Marshal(b, m, deterministic)
}
func (m *GetDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceRequest.Merge(m, src)
}
func (m *GetDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceRequest.Size(m)
}
func (m *GetDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceRequest proto.InternalMessageInfo

func (m *GetDeviceRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

type ListDevicesRequest struct {
	// Types that are valid to be assigned to Id:
	//	*ListDevicesRequest_RegistryId
	//	*ListDevicesRequest_FolderId
	Id isListDevicesRequest_Id `protobuf_oneof:"id"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `page_size`, the service returns a [ListDevicesResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListDevicesResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDevicesRequest) Reset()         { *m = ListDevicesRequest{} }
func (m *ListDevicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDevicesRequest) ProtoMessage()    {}
func (*ListDevicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{1}
}

func (m *ListDevicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicesRequest.Unmarshal(m, b)
}
func (m *ListDevicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicesRequest.Marshal(b, m, deterministic)
}
func (m *ListDevicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicesRequest.Merge(m, src)
}
func (m *ListDevicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDevicesRequest.Size(m)
}
func (m *ListDevicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicesRequest proto.InternalMessageInfo

type isListDevicesRequest_Id interface {
	isListDevicesRequest_Id()
}

type ListDevicesRequest_RegistryId struct {
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3,oneof"`
}

type ListDevicesRequest_FolderId struct {
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

func (*ListDevicesRequest_RegistryId) isListDevicesRequest_Id() {}

func (*ListDevicesRequest_FolderId) isListDevicesRequest_Id() {}

func (m *ListDevicesRequest) GetId() isListDevicesRequest_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *ListDevicesRequest) GetRegistryId() string {
	if x, ok := m.GetId().(*ListDevicesRequest_RegistryId); ok {
		return x.RegistryId
	}
	return ""
}

func (m *ListDevicesRequest) GetFolderId() string {
	if x, ok := m.GetId().(*ListDevicesRequest_FolderId); ok {
		return x.FolderId
	}
	return ""
}

func (m *ListDevicesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDevicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ListDevicesRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ListDevicesRequest_RegistryId)(nil),
		(*ListDevicesRequest_FolderId)(nil),
	}
}

type ListDevicesResponse struct {
	// List of devices.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListDevicesRequest.page_size], use `next_page_token` as the value
	// for the [ListDevicesRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDevicesResponse) Reset()         { *m = ListDevicesResponse{} }
func (m *ListDevicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDevicesResponse) ProtoMessage()    {}
func (*ListDevicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{2}
}

func (m *ListDevicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicesResponse.Unmarshal(m, b)
}
func (m *ListDevicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicesResponse.Marshal(b, m, deterministic)
}
func (m *ListDevicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicesResponse.Merge(m, src)
}
func (m *ListDevicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDevicesResponse.Size(m)
}
func (m *ListDevicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicesResponse proto.InternalMessageInfo

func (m *ListDevicesResponse) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *ListDevicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateDeviceRequest struct {
	// ID of the registry to create a device in.
	//
	// To get a registry ID, make a [yandex.cloud.iot.devices.v1.RegistryService.List] request.
	RegistryId string `protobuf:"bytes,1,opt,name=registry_id,json=registryId,proto3" json:"registry_id,omitempty"`
	// Name of the device. The name must be unique within the registry.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the device.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Device certificate.
	Certificates []*CreateDeviceRequest_Certificate `protobuf:"bytes,4,rep,name=certificates,proto3" json:"certificates,omitempty"`
	// Alias of a device topic.
	//
	// Alias is an alternate name of a device topic assigned by the user. Map alias to canonical topic name prefix, e.g. `my/custom/alias` match to `$device/{id}/events`.
	TopicAliases map[string]string `protobuf:"bytes,5,rep,name=topic_aliases,json=topicAliases,proto3" json:"topic_aliases,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Device password.
	//
	// The password must contain at least three character categories among the following: upper case latin, lower case latin, numbers and special symbols.
	Password             string   `protobuf:"bytes,6,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDeviceRequest) Reset()         { *m = CreateDeviceRequest{} }
func (m *CreateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceRequest) ProtoMessage()    {}
func (*CreateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{3}
}

func (m *CreateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceRequest.Unmarshal(m, b)
}
func (m *CreateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *CreateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceRequest.Merge(m, src)
}
func (m *CreateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceRequest.Size(m)
}
func (m *CreateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceRequest proto.InternalMessageInfo

func (m *CreateDeviceRequest) GetRegistryId() string {
	if m != nil {
		return m.RegistryId
	}
	return ""
}

func (m *CreateDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateDeviceRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateDeviceRequest) GetCertificates() []*CreateDeviceRequest_Certificate {
	if m != nil {
		return m.Certificates
	}
	return nil
}

func (m *CreateDeviceRequest) GetTopicAliases() map[string]string {
	if m != nil {
		return m.TopicAliases
	}
	return nil
}

func (m *CreateDeviceRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// Specification of a device certificate.
type CreateDeviceRequest_Certificate struct {
	// Public part of the device certificate.
	CertificateData      string   `protobuf:"bytes,1,opt,name=certificate_data,json=certificateData,proto3" json:"certificate_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDeviceRequest_Certificate) Reset()         { *m = CreateDeviceRequest_Certificate{} }
func (m *CreateDeviceRequest_Certificate) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceRequest_Certificate) ProtoMessage()    {}
func (*CreateDeviceRequest_Certificate) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{3, 1}
}

func (m *CreateDeviceRequest_Certificate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceRequest_Certificate.Unmarshal(m, b)
}
func (m *CreateDeviceRequest_Certificate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceRequest_Certificate.Marshal(b, m, deterministic)
}
func (m *CreateDeviceRequest_Certificate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceRequest_Certificate.Merge(m, src)
}
func (m *CreateDeviceRequest_Certificate) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceRequest_Certificate.Size(m)
}
func (m *CreateDeviceRequest_Certificate) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceRequest_Certificate.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceRequest_Certificate proto.InternalMessageInfo

func (m *CreateDeviceRequest_Certificate) GetCertificateData() string {
	if m != nil {
		return m.CertificateData
	}
	return ""
}

type CreateDeviceMetadata struct {
	// ID of the device that is being created.
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDeviceMetadata) Reset()         { *m = CreateDeviceMetadata{} }
func (m *CreateDeviceMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceMetadata) ProtoMessage()    {}
func (*CreateDeviceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{4}
}

func (m *CreateDeviceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceMetadata.Unmarshal(m, b)
}
func (m *CreateDeviceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceMetadata.Marshal(b, m, deterministic)
}
func (m *CreateDeviceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceMetadata.Merge(m, src)
}
func (m *CreateDeviceMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceMetadata.Size(m)
}
func (m *CreateDeviceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceMetadata proto.InternalMessageInfo

func (m *CreateDeviceMetadata) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

type UpdateDeviceRequest struct {
	// ID of the device to update.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Field mask that specifies which fields of the device are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the device. The name must be unique within the registry.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the device.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Alias of a device topic.
	//
	// Alias is an alternate name of a device topic assigned by the user. Map alias to canonical topic name prefix, e.g. `my/custom/alias` match to `$device/{id}/events`.
	TopicAliases         map[string]string `protobuf:"bytes,5,rep,name=topic_aliases,json=topicAliases,proto3" json:"topic_aliases,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateDeviceRequest) Reset()         { *m = UpdateDeviceRequest{} }
func (m *UpdateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceRequest) ProtoMessage()    {}
func (*UpdateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{5}
}

func (m *UpdateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceRequest.Unmarshal(m, b)
}
func (m *UpdateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceRequest.Merge(m, src)
}
func (m *UpdateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceRequest.Size(m)
}
func (m *UpdateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceRequest proto.InternalMessageInfo

func (m *UpdateDeviceRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *UpdateDeviceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateDeviceRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateDeviceRequest) GetTopicAliases() map[string]string {
	if m != nil {
		return m.TopicAliases
	}
	return nil
}

type UpdateDeviceMetadata struct {
	// ID of the device that is being updated.
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateDeviceMetadata) Reset()         { *m = UpdateDeviceMetadata{} }
func (m *UpdateDeviceMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceMetadata) ProtoMessage()    {}
func (*UpdateDeviceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{6}
}

func (m *UpdateDeviceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceMetadata.Unmarshal(m, b)
}
func (m *UpdateDeviceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateDeviceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceMetadata.Merge(m, src)
}
func (m *UpdateDeviceMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceMetadata.Size(m)
}
func (m *UpdateDeviceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceMetadata proto.InternalMessageInfo

func (m *UpdateDeviceMetadata) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

type DeleteDeviceRequest struct {
	// ID of the device to delete.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceRequest) Reset()         { *m = DeleteDeviceRequest{} }
func (m *DeleteDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceRequest) ProtoMessage()    {}
func (*DeleteDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{7}
}

func (m *DeleteDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceRequest.Merge(m, src)
}
func (m *DeleteDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceRequest.Size(m)
}
func (m *DeleteDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceRequest proto.InternalMessageInfo

func (m *DeleteDeviceRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

type DeleteDeviceMetadata struct {
	// ID of the device that is being deleted.
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceMetadata) Reset()         { *m = DeleteDeviceMetadata{} }
func (m *DeleteDeviceMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceMetadata) ProtoMessage()    {}
func (*DeleteDeviceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{8}
}

func (m *DeleteDeviceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceMetadata.Unmarshal(m, b)
}
func (m *DeleteDeviceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceMetadata.Merge(m, src)
}
func (m *DeleteDeviceMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceMetadata.Size(m)
}
func (m *DeleteDeviceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceMetadata proto.InternalMessageInfo

func (m *DeleteDeviceMetadata) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

type ListDeviceCertificatesRequest struct {
	// ID of the device to list certificates for.
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceCertificatesRequest) Reset()         { *m = ListDeviceCertificatesRequest{} }
func (m *ListDeviceCertificatesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceCertificatesRequest) ProtoMessage()    {}
func (*ListDeviceCertificatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{9}
}

func (m *ListDeviceCertificatesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceCertificatesRequest.Unmarshal(m, b)
}
func (m *ListDeviceCertificatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceCertificatesRequest.Marshal(b, m, deterministic)
}
func (m *ListDeviceCertificatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceCertificatesRequest.Merge(m, src)
}
func (m *ListDeviceCertificatesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceCertificatesRequest.Size(m)
}
func (m *ListDeviceCertificatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceCertificatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceCertificatesRequest proto.InternalMessageInfo

func (m *ListDeviceCertificatesRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

type ListDeviceCertificatesResponse struct {
	// List of certificates for the specified device.
	Certificates         []*DeviceCertificate `protobuf:"bytes,1,rep,name=certificates,proto3" json:"certificates,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListDeviceCertificatesResponse) Reset()         { *m = ListDeviceCertificatesResponse{} }
func (m *ListDeviceCertificatesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceCertificatesResponse) ProtoMessage()    {}
func (*ListDeviceCertificatesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{10}
}

func (m *ListDeviceCertificatesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceCertificatesResponse.Unmarshal(m, b)
}
func (m *ListDeviceCertificatesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceCertificatesResponse.Marshal(b, m, deterministic)
}
func (m *ListDeviceCertificatesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceCertificatesResponse.Merge(m, src)
}
func (m *ListDeviceCertificatesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceCertificatesResponse.Size(m)
}
func (m *ListDeviceCertificatesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceCertificatesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceCertificatesResponse proto.InternalMessageInfo

func (m *ListDeviceCertificatesResponse) GetCertificates() []*DeviceCertificate {
	if m != nil {
		return m.Certificates
	}
	return nil
}

type AddDeviceCertificateRequest struct {
	// ID of the device for which the certificate is being added.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Public part of the certificate.
	CertificateData      string   `protobuf:"bytes,3,opt,name=certificate_data,json=certificateData,proto3" json:"certificate_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddDeviceCertificateRequest) Reset()         { *m = AddDeviceCertificateRequest{} }
func (m *AddDeviceCertificateRequest) String() string { return proto.CompactTextString(m) }
func (*AddDeviceCertificateRequest) ProtoMessage()    {}
func (*AddDeviceCertificateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{11}
}

func (m *AddDeviceCertificateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddDeviceCertificateRequest.Unmarshal(m, b)
}
func (m *AddDeviceCertificateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddDeviceCertificateRequest.Marshal(b, m, deterministic)
}
func (m *AddDeviceCertificateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddDeviceCertificateRequest.Merge(m, src)
}
func (m *AddDeviceCertificateRequest) XXX_Size() int {
	return xxx_messageInfo_AddDeviceCertificateRequest.Size(m)
}
func (m *AddDeviceCertificateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddDeviceCertificateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddDeviceCertificateRequest proto.InternalMessageInfo

func (m *AddDeviceCertificateRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *AddDeviceCertificateRequest) GetCertificateData() string {
	if m != nil {
		return m.CertificateData
	}
	return ""
}

type AddDeviceCertificateMetadata struct {
	// ID of the device certificate that is being added.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Fingerprint of the certificate that is being added.
	Fingerprint          string   `protobuf:"bytes,2,opt,name=fingerprint,proto3" json:"fingerprint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddDeviceCertificateMetadata) Reset()         { *m = AddDeviceCertificateMetadata{} }
func (m *AddDeviceCertificateMetadata) String() string { return proto.CompactTextString(m) }
func (*AddDeviceCertificateMetadata) ProtoMessage()    {}
func (*AddDeviceCertificateMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{12}
}

func (m *AddDeviceCertificateMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddDeviceCertificateMetadata.Unmarshal(m, b)
}
func (m *AddDeviceCertificateMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddDeviceCertificateMetadata.Marshal(b, m, deterministic)
}
func (m *AddDeviceCertificateMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddDeviceCertificateMetadata.Merge(m, src)
}
func (m *AddDeviceCertificateMetadata) XXX_Size() int {
	return xxx_messageInfo_AddDeviceCertificateMetadata.Size(m)
}
func (m *AddDeviceCertificateMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddDeviceCertificateMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddDeviceCertificateMetadata proto.InternalMessageInfo

func (m *AddDeviceCertificateMetadata) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *AddDeviceCertificateMetadata) GetFingerprint() string {
	if m != nil {
		return m.Fingerprint
	}
	return ""
}

type DeleteDeviceCertificateRequest struct {
	// ID of the device to delete a certificate for.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Fingerprint of the certificate to delete.
	Fingerprint          string   `protobuf:"bytes,2,opt,name=fingerprint,proto3" json:"fingerprint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceCertificateRequest) Reset()         { *m = DeleteDeviceCertificateRequest{} }
func (m *DeleteDeviceCertificateRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceCertificateRequest) ProtoMessage()    {}
func (*DeleteDeviceCertificateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{13}
}

func (m *DeleteDeviceCertificateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceCertificateRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceCertificateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceCertificateRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceCertificateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceCertificateRequest.Merge(m, src)
}
func (m *DeleteDeviceCertificateRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceCertificateRequest.Size(m)
}
func (m *DeleteDeviceCertificateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceCertificateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceCertificateRequest proto.InternalMessageInfo

func (m *DeleteDeviceCertificateRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *DeleteDeviceCertificateRequest) GetFingerprint() string {
	if m != nil {
		return m.Fingerprint
	}
	return ""
}

type DeleteDeviceCertificateMetadata struct {
	// ID of the device certificate that is being deleted.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Fingerprint of the certificate that is being deleted.
	Fingerprint          string   `protobuf:"bytes,2,opt,name=fingerprint,proto3" json:"fingerprint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceCertificateMetadata) Reset()         { *m = DeleteDeviceCertificateMetadata{} }
func (m *DeleteDeviceCertificateMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceCertificateMetadata) ProtoMessage()    {}
func (*DeleteDeviceCertificateMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{14}
}

func (m *DeleteDeviceCertificateMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceCertificateMetadata.Unmarshal(m, b)
}
func (m *DeleteDeviceCertificateMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceCertificateMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceCertificateMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceCertificateMetadata.Merge(m, src)
}
func (m *DeleteDeviceCertificateMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceCertificateMetadata.Size(m)
}
func (m *DeleteDeviceCertificateMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceCertificateMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceCertificateMetadata proto.InternalMessageInfo

func (m *DeleteDeviceCertificateMetadata) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *DeleteDeviceCertificateMetadata) GetFingerprint() string {
	if m != nil {
		return m.Fingerprint
	}
	return ""
}

type ListDevicePasswordsRequest struct {
	// ID of the registry to list passwords in.
	//
	// To get a registry ID make a [RegistryService.List] request.
	DeviceId             string   `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDevicePasswordsRequest) Reset()         { *m = ListDevicePasswordsRequest{} }
func (m *ListDevicePasswordsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDevicePasswordsRequest) ProtoMessage()    {}
func (*ListDevicePasswordsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{15}
}

func (m *ListDevicePasswordsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicePasswordsRequest.Unmarshal(m, b)
}
func (m *ListDevicePasswordsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicePasswordsRequest.Marshal(b, m, deterministic)
}
func (m *ListDevicePasswordsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicePasswordsRequest.Merge(m, src)
}
func (m *ListDevicePasswordsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDevicePasswordsRequest.Size(m)
}
func (m *ListDevicePasswordsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicePasswordsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicePasswordsRequest proto.InternalMessageInfo

func (m *ListDevicePasswordsRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

type ListDevicePasswordsResponse struct {
	// List of passwords for the specified device.
	Passwords            []*DevicePassword `protobuf:"bytes,1,rep,name=passwords,proto3" json:"passwords,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListDevicePasswordsResponse) Reset()         { *m = ListDevicePasswordsResponse{} }
func (m *ListDevicePasswordsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDevicePasswordsResponse) ProtoMessage()    {}
func (*ListDevicePasswordsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{16}
}

func (m *ListDevicePasswordsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicePasswordsResponse.Unmarshal(m, b)
}
func (m *ListDevicePasswordsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicePasswordsResponse.Marshal(b, m, deterministic)
}
func (m *ListDevicePasswordsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicePasswordsResponse.Merge(m, src)
}
func (m *ListDevicePasswordsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDevicePasswordsResponse.Size(m)
}
func (m *ListDevicePasswordsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicePasswordsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicePasswordsResponse proto.InternalMessageInfo

func (m *ListDevicePasswordsResponse) GetPasswords() []*DevicePassword {
	if m != nil {
		return m.Passwords
	}
	return nil
}

type AddDevicePasswordRequest struct {
	// ID of the device to add a password for.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Passwords for the device.
	//
	// The password must contain at least three character categories among the following: upper case latin, lower case latin, numbers and special symbols.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddDevicePasswordRequest) Reset()         { *m = AddDevicePasswordRequest{} }
func (m *AddDevicePasswordRequest) String() string { return proto.CompactTextString(m) }
func (*AddDevicePasswordRequest) ProtoMessage()    {}
func (*AddDevicePasswordRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{17}
}

func (m *AddDevicePasswordRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddDevicePasswordRequest.Unmarshal(m, b)
}
func (m *AddDevicePasswordRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddDevicePasswordRequest.Marshal(b, m, deterministic)
}
func (m *AddDevicePasswordRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddDevicePasswordRequest.Merge(m, src)
}
func (m *AddDevicePasswordRequest) XXX_Size() int {
	return xxx_messageInfo_AddDevicePasswordRequest.Size(m)
}
func (m *AddDevicePasswordRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddDevicePasswordRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddDevicePasswordRequest proto.InternalMessageInfo

func (m *AddDevicePasswordRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *AddDevicePasswordRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

type AddDevicePasswordMetadata struct {
	// ID of the device for which the password is being added.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// ID of the password that is being added.
	PasswordId           string   `protobuf:"bytes,2,opt,name=password_id,json=passwordId,proto3" json:"password_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddDevicePasswordMetadata) Reset()         { *m = AddDevicePasswordMetadata{} }
func (m *AddDevicePasswordMetadata) String() string { return proto.CompactTextString(m) }
func (*AddDevicePasswordMetadata) ProtoMessage()    {}
func (*AddDevicePasswordMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{18}
}

func (m *AddDevicePasswordMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddDevicePasswordMetadata.Unmarshal(m, b)
}
func (m *AddDevicePasswordMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddDevicePasswordMetadata.Marshal(b, m, deterministic)
}
func (m *AddDevicePasswordMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddDevicePasswordMetadata.Merge(m, src)
}
func (m *AddDevicePasswordMetadata) XXX_Size() int {
	return xxx_messageInfo_AddDevicePasswordMetadata.Size(m)
}
func (m *AddDevicePasswordMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddDevicePasswordMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddDevicePasswordMetadata proto.InternalMessageInfo

func (m *AddDevicePasswordMetadata) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *AddDevicePasswordMetadata) GetPasswordId() string {
	if m != nil {
		return m.PasswordId
	}
	return ""
}

type DeleteDevicePasswordRequest struct {
	// ID of the device to delete a password for.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// ID of the password to delete.
	//
	// To get a password ID make a [DeviceService.ListPasswords] request.
	PasswordId           string   `protobuf:"bytes,2,opt,name=password_id,json=passwordId,proto3" json:"password_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDevicePasswordRequest) Reset()         { *m = DeleteDevicePasswordRequest{} }
func (m *DeleteDevicePasswordRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDevicePasswordRequest) ProtoMessage()    {}
func (*DeleteDevicePasswordRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{19}
}

func (m *DeleteDevicePasswordRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDevicePasswordRequest.Unmarshal(m, b)
}
func (m *DeleteDevicePasswordRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDevicePasswordRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDevicePasswordRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDevicePasswordRequest.Merge(m, src)
}
func (m *DeleteDevicePasswordRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDevicePasswordRequest.Size(m)
}
func (m *DeleteDevicePasswordRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDevicePasswordRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDevicePasswordRequest proto.InternalMessageInfo

func (m *DeleteDevicePasswordRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *DeleteDevicePasswordRequest) GetPasswordId() string {
	if m != nil {
		return m.PasswordId
	}
	return ""
}

type DeleteDevicePasswordMetadata struct {
	// ID of the device for which the password is being deleted.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// ID of the password that is being deleted.
	PasswordId           string   `protobuf:"bytes,2,opt,name=password_id,json=passwordId,proto3" json:"password_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDevicePasswordMetadata) Reset()         { *m = DeleteDevicePasswordMetadata{} }
func (m *DeleteDevicePasswordMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteDevicePasswordMetadata) ProtoMessage()    {}
func (*DeleteDevicePasswordMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{20}
}

func (m *DeleteDevicePasswordMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDevicePasswordMetadata.Unmarshal(m, b)
}
func (m *DeleteDevicePasswordMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDevicePasswordMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteDevicePasswordMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDevicePasswordMetadata.Merge(m, src)
}
func (m *DeleteDevicePasswordMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteDevicePasswordMetadata.Size(m)
}
func (m *DeleteDevicePasswordMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDevicePasswordMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDevicePasswordMetadata proto.InternalMessageInfo

func (m *DeleteDevicePasswordMetadata) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *DeleteDevicePasswordMetadata) GetPasswordId() string {
	if m != nil {
		return m.PasswordId
	}
	return ""
}

type ListDeviceOperationsRequest struct {
	// ID of the device to list operations for.
	//
	// To get a device ID make a [DeviceService.List] request.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than `page_size`, the service returns a [ListDeviceOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListDeviceOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// Currently you can use filtering only on [Device.name] field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceOperationsRequest) Reset()         { *m = ListDeviceOperationsRequest{} }
func (m *ListDeviceOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceOperationsRequest) ProtoMessage()    {}
func (*ListDeviceOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{21}
}

func (m *ListDeviceOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceOperationsRequest.Unmarshal(m, b)
}
func (m *ListDeviceOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListDeviceOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceOperationsRequest.Merge(m, src)
}
func (m *ListDeviceOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceOperationsRequest.Size(m)
}
func (m *ListDeviceOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceOperationsRequest proto.InternalMessageInfo

func (m *ListDeviceOperationsRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *ListDeviceOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDeviceOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDeviceOperationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListDeviceOperationsResponse struct {
	// List of operations for the specified device certificate.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListDeviceOperationsRequest.page_size], use `next_page_token` as the value
	// for the [ListDeviceOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceOperationsResponse) Reset()         { *m = ListDeviceOperationsResponse{} }
func (m *ListDeviceOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceOperationsResponse) ProtoMessage()    {}
func (*ListDeviceOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f9432a8c0088851, []int{22}
}

func (m *ListDeviceOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceOperationsResponse.Unmarshal(m, b)
}
func (m *ListDeviceOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListDeviceOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceOperationsResponse.Merge(m, src)
}
func (m *ListDeviceOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceOperationsResponse.Size(m)
}
func (m *ListDeviceOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceOperationsResponse proto.InternalMessageInfo

func (m *ListDeviceOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListDeviceOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetDeviceRequest)(nil), "yandex.cloud.iot.devices.v1.GetDeviceRequest")
	proto.RegisterType((*ListDevicesRequest)(nil), "yandex.cloud.iot.devices.v1.ListDevicesRequest")
	proto.RegisterType((*ListDevicesResponse)(nil), "yandex.cloud.iot.devices.v1.ListDevicesResponse")
	proto.RegisterType((*CreateDeviceRequest)(nil), "yandex.cloud.iot.devices.v1.CreateDeviceRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.iot.devices.v1.CreateDeviceRequest.TopicAliasesEntry")
	proto.RegisterType((*CreateDeviceRequest_Certificate)(nil), "yandex.cloud.iot.devices.v1.CreateDeviceRequest.Certificate")
	proto.RegisterType((*CreateDeviceMetadata)(nil), "yandex.cloud.iot.devices.v1.CreateDeviceMetadata")
	proto.RegisterType((*UpdateDeviceRequest)(nil), "yandex.cloud.iot.devices.v1.UpdateDeviceRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.iot.devices.v1.UpdateDeviceRequest.TopicAliasesEntry")
	proto.RegisterType((*UpdateDeviceMetadata)(nil), "yandex.cloud.iot.devices.v1.UpdateDeviceMetadata")
	proto.RegisterType((*DeleteDeviceRequest)(nil), "yandex.cloud.iot.devices.v1.DeleteDeviceRequest")
	proto.RegisterType((*DeleteDeviceMetadata)(nil), "yandex.cloud.iot.devices.v1.DeleteDeviceMetadata")
	proto.RegisterType((*ListDeviceCertificatesRequest)(nil), "yandex.cloud.iot.devices.v1.ListDeviceCertificatesRequest")
	proto.RegisterType((*ListDeviceCertificatesResponse)(nil), "yandex.cloud.iot.devices.v1.ListDeviceCertificatesResponse")
	proto.RegisterType((*AddDeviceCertificateRequest)(nil), "yandex.cloud.iot.devices.v1.AddDeviceCertificateRequest")
	proto.RegisterType((*AddDeviceCertificateMetadata)(nil), "yandex.cloud.iot.devices.v1.AddDeviceCertificateMetadata")
	proto.RegisterType((*DeleteDeviceCertificateRequest)(nil), "yandex.cloud.iot.devices.v1.DeleteDeviceCertificateRequest")
	proto.RegisterType((*DeleteDeviceCertificateMetadata)(nil), "yandex.cloud.iot.devices.v1.DeleteDeviceCertificateMetadata")
	proto.RegisterType((*ListDevicePasswordsRequest)(nil), "yandex.cloud.iot.devices.v1.ListDevicePasswordsRequest")
	proto.RegisterType((*ListDevicePasswordsResponse)(nil), "yandex.cloud.iot.devices.v1.ListDevicePasswordsResponse")
	proto.RegisterType((*AddDevicePasswordRequest)(nil), "yandex.cloud.iot.devices.v1.AddDevicePasswordRequest")
	proto.RegisterType((*AddDevicePasswordMetadata)(nil), "yandex.cloud.iot.devices.v1.AddDevicePasswordMetadata")
	proto.RegisterType((*DeleteDevicePasswordRequest)(nil), "yandex.cloud.iot.devices.v1.DeleteDevicePasswordRequest")
	proto.RegisterType((*DeleteDevicePasswordMetadata)(nil), "yandex.cloud.iot.devices.v1.DeleteDevicePasswordMetadata")
	proto.RegisterType((*ListDeviceOperationsRequest)(nil), "yandex.cloud.iot.devices.v1.ListDeviceOperationsRequest")
	proto.RegisterType((*ListDeviceOperationsResponse)(nil), "yandex.cloud.iot.devices.v1.ListDeviceOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/iot/devices/v1/device_service.proto", fileDescriptor_4f9432a8c0088851)
}

var fileDescriptor_4f9432a8c0088851 = []byte{
	// 1482 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcf, 0x73, 0xdb, 0xc4,
	0x1e, 0x7f, 0x8a, 0x5d, 0xbf, 0xe4, 0xeb, 0x26, 0x4d, 0x37, 0x7d, 0xf3, 0x5c, 0x25, 0x4d, 0x52,
	0xf5, 0xbd, 0x92, 0x3a, 0x63, 0x49, 0x76, 0x49, 0x71, 0x9b, 0xa6, 0x34, 0x69, 0x4a, 0x08, 0x43,
	0x87, 0x8e, 0x5a, 0x0e, 0x14, 0x3a, 0x46, 0xb5, 0x36, 0xae, 0x88, 0x63, 0x09, 0x49, 0x49, 0x9b,
	0xa6, 0xbd, 0x74, 0x18, 0x18, 0x72, 0xe5, 0xcc, 0x89, 0x3f, 0x80, 0x99, 0x5c, 0x18, 0x86, 0x61,
	0x06, 0x0e, 0x4c, 0xcb, 0x8d, 0x09, 0x7f, 0x00, 0x17, 0x0e, 0xcc, 0x70, 0xe3, 0xc4, 0x70, 0x62,
	0x56, 0x2b, 0xc9, 0x2b, 0x5b, 0xb6, 0xd7, 0xee, 0x70, 0xb2, 0xb4, 0xfb, 0xfd, 0xfd, 0xfd, 0xec,
	0x57, 0x9f, 0x35, 0xa8, 0xbb, 0x7a, 0xc3, 0xc0, 0x0f, 0x95, 0x6a, 0xdd, 0xda, 0x36, 0x14, 0xd3,
	0xf2, 0x14, 0x03, 0xef, 0x98, 0x55, 0xec, 0x2a, 0x3b, 0xc5, 0xe0, 0xb1, 0xe2, 0x62, 0x87, 0xfc,
	0xca, 0xb6, 0x63, 0x79, 0x16, 0x9a, 0xa4, 0x1a, 0xb2, 0xaf, 0x21, 0x9b, 0x96, 0x27, 0x07, 0x1a,
	0xf2, 0x4e, 0x51, 0x9c, 0xaa, 0x59, 0x56, 0xad, 0x8e, 0x15, 0xdd, 0x36, 0x15, 0xbd, 0xd1, 0xb0,
	0x3c, 0xdd, 0x33, 0xad, 0x86, 0x4b, 0x55, 0xc5, 0xd9, 0x60, 0xd7, 0x7f, 0xbb, 0xb7, 0xbd, 0xa1,
	0x6c, 0x98, 0xb8, 0x6e, 0x54, 0xb6, 0x74, 0x77, 0x33, 0x90, 0x38, 0x15, 0x0b, 0x67, 0x47, 0xaf,
	0x9b, 0x86, 0x6f, 0x21, 0x34, 0x10, 0xdb, 0x26, 0x4e, 0x2c, 0x1b, 0x3b, 0xac, 0xc4, 0xd9, 0x98,
	0x44, 0xb4, 0xdb, 0x26, 0x37, 0xd7, 0x3b, 0x6f, 0x2a, 0x29, 0x2d, 0xc1, 0xf8, 0x1a, 0xf6, 0x56,
	0xfd, 0x25, 0x0d, 0x7f, 0xb8, 0x8d, 0x5d, 0x0f, 0x9d, 0x83, 0x91, 0xa0, 0x36, 0xa6, 0x91, 0x13,
	0x66, 0x85, 0xb9, 0x91, 0x95, 0xa3, 0xbf, 0x3d, 0x2b, 0x0a, 0xfb, 0xcf, 0x8b, 0xe9, 0xcb, 0x4b,
	0x0b, 0xaa, 0x36, 0x4c, 0xb7, 0xd7, 0x0d, 0xe9, 0x47, 0x01, 0xd0, 0x9b, 0xa6, 0x1b, 0x18, 0x70,
	0x43, 0x0b, 0xf3, 0x90, 0x75, 0x70, 0xcd, 0x74, 0x3d, 0x67, 0xb7, 0x69, 0x63, 0x38, 0xd4, 0x7f,
	0xfd, 0x5f, 0x1a, 0x84, 0xdb, 0xeb, 0x06, 0x7a, 0x09, 0x46, 0x36, 0xac, 0xba, 0x81, 0x1d, 0x22,
	0x3a, 0xd4, 0x26, 0x3a, 0x4c, 0x37, 0xa9, 0xa0, 0xad, 0xd7, 0x70, 0xc5, 0x35, 0x1f, 0xe1, 0x5c,
	0x6a, 0x56, 0x98, 0x4b, 0xad, 0xc0, 0x5f, 0xcf, 0x8a, 0x19, 0xb5, 0x50, 0x54, 0x55, 0x55, 0x1b,
	0x26, 0x9b, 0xb7, 0xcc, 0x47, 0x18, 0xcd, 0x01, 0xf8, 0x82, 0x9e, 0xb5, 0x89, 0x1b, 0xb9, 0xb4,
	0x6f, 0x72, 0x64, 0xff, 0x79, 0xf1, 0xc8, 0xe5, 0xa5, 0xa2, 0xaa, 0x6a, 0xbe, 0x95, 0xdb, 0x64,
	0x6f, 0x05, 0x60, 0xc8, 0x34, 0x50, 0xfa, 0xbb, 0xef, 0x8b, 0x82, 0xf4, 0x18, 0x26, 0x62, 0xa9,
	0xb8, 0xb6, 0xd5, 0x70, 0x31, 0x5a, 0x82, 0x7f, 0x07, 0xc5, 0xcb, 0x09, 0xb3, 0xa9, 0xb9, 0x6c,
	0xe9, 0x8c, 0xdc, 0x05, 0x23, 0x72, 0x50, 0xca, 0x50, 0x07, 0x9d, 0x85, 0x63, 0x0d, 0xfc, 0xd0,
	0xab, 0x30, 0x01, 0xf9, 0x39, 0x6a, 0xa3, 0x64, 0xf9, 0x66, 0x18, 0x89, 0xf4, 0x49, 0x1a, 0x26,
	0xae, 0x39, 0x58, 0xf7, 0x70, 0xbc, 0x19, 0x85, 0xa4, 0x52, 0xc6, 0xdb, 0xc1, 0x16, 0xb3, 0x04,
	0xe9, 0x86, 0xbe, 0x85, 0x83, 0x3a, 0x4e, 0x13, 0xb9, 0x3f, 0x9e, 0x15, 0xc7, 0xde, 0xd5, 0x0b,
	0x8f, 0x96, 0x0b, 0x77, 0xd4, 0xc2, 0xc5, 0x4a, 0xe1, 0x6e, 0x3e, 0xd2, 0xf4, 0x65, 0x49, 0xb7,
	0x0c, 0xec, 0x56, 0x1d, 0xd3, 0x26, 0x10, 0xf2, 0x2b, 0x1b, 0xd5, 0xab, 0xb4, 0x70, 0x41, 0x63,
	0x77, 0xd1, 0xfb, 0x70, 0xb4, 0x8a, 0x1d, 0xcf, 0xdc, 0x30, 0xab, 0xba, 0x87, 0xdd, 0x5c, 0xda,
	0xaf, 0xc9, 0xe5, 0xae, 0x35, 0x49, 0xc8, 0x4b, 0xbe, 0xd6, 0x34, 0xa2, 0xc5, 0x2c, 0xa2, 0x1a,
	0x8c, 0x7a, 0x96, 0x6d, 0x56, 0x2b, 0x7a, 0xdd, 0xd4, 0x5d, 0xec, 0xe6, 0x8e, 0xf8, 0x2e, 0x56,
	0xfa, 0x76, 0x71, 0x9b, 0x58, 0x59, 0xa6, 0x46, 0xae, 0x37, 0x3c, 0x67, 0x57, 0x3b, 0xea, 0x31,
	0x4b, 0x48, 0x84, 0x61, 0x5b, 0x77, 0xdd, 0x07, 0x96, 0x63, 0xe4, 0x32, 0x7e, 0x4f, 0xa2, 0x77,
	0xf1, 0x55, 0x38, 0xde, 0xa6, 0x8e, 0xc6, 0x21, 0xb5, 0x89, 0x77, 0x69, 0x0f, 0x34, 0xf2, 0x88,
	0x4e, 0xc0, 0x91, 0x1d, 0xbd, 0xbe, 0x1d, 0xd4, 0x5b, 0xa3, 0x2f, 0x97, 0x86, 0xca, 0x82, 0x58,
	0x86, 0x2c, 0x93, 0x22, 0x3a, 0x07, 0xe3, 0x4c, 0x92, 0x15, 0x43, 0xf7, 0xf4, 0xc0, 0xce, 0x31,
	0x66, 0x7d, 0x55, 0xf7, 0x74, 0xe9, 0x3c, 0x9c, 0x60, 0xb3, 0xb9, 0x81, 0x3d, 0x9d, 0x88, 0xa3,
	0xc9, 0xb6, 0x63, 0xc9, 0x1c, 0xc4, 0x8f, 0x52, 0x30, 0xf1, 0xb6, 0x6d, 0xb4, 0xc1, 0x87, 0xff,
	0x2c, 0xa3, 0x45, 0xc8, 0x6e, 0xfb, 0x16, 0xfc, 0x91, 0xe5, 0x67, 0x94, 0x2d, 0x89, 0x32, 0x9d,
	0x6a, 0x72, 0x38, 0xd5, 0xe4, 0xd7, 0xc8, 0x54, 0xbb, 0xa1, 0xbb, 0x9b, 0x1a, 0x50, 0x71, 0xf2,
	0x8c, 0xe4, 0x00, 0x77, 0x14, 0x3c, 0x62, 0xbf, 0x98, 0x4b, 0x77, 0xc5, 0xdc, 0x40, 0x88, 0x48,
	0xa8, 0x46, 0x2f, 0x44, 0xbc, 0x70, 0xd7, 0x49, 0xef, 0x58, 0xbf, 0x7c, 0xbd, 0xbb, 0x0a, 0x13,
	0xab, 0xb8, 0x8e, 0x07, 0x6f, 0x1d, 0x71, 0xcb, 0x5a, 0xe0, 0x73, 0xfb, 0x06, 0x9c, 0x6a, 0xce,
	0x3b, 0x06, 0xab, 0xee, 0x00, 0x01, 0x78, 0x30, 0xdd, 0xc9, 0x56, 0x30, 0x46, 0xb5, 0x96, 0xb9,
	0x41, 0x67, 0xa9, 0xcc, 0x31, 0x4b, 0x3b, 0x4e, 0x0a, 0xc9, 0x85, 0xc9, 0x65, 0xc3, 0x68, 0x97,
	0xea, 0x1f, 0xfb, 0x49, 0xc7, 0x33, 0x95, 0x7c, 0x3c, 0xef, 0xc2, 0x54, 0x92, 0x53, 0xae, 0x9a,
	0xa3, 0x59, 0xc8, 0x6e, 0x98, 0x8d, 0x1a, 0x76, 0x6c, 0xc7, 0x6c, 0x78, 0x01, 0x7e, 0xd8, 0x25,
	0x69, 0x0f, 0xa6, 0xd9, 0x56, 0xbe, 0x58, 0x5a, 0x72, 0x82, 0xbb, 0x16, 0xe1, 0x98, 0xf3, 0xc7,
	0x30, 0xd3, 0xc1, 0x79, 0x94, 0xde, 0x3f, 0xe8, 0x7d, 0x0d, 0xc4, 0x26, 0x88, 0x6e, 0x06, 0x93,
	0x78, 0x10, 0x34, 0xde, 0x87, 0xc9, 0x44, 0x43, 0x01, 0x14, 0xd7, 0x09, 0x8f, 0x08, 0x16, 0x03,
	0x1c, 0xce, 0x73, 0xe0, 0x30, 0x34, 0xa4, 0x35, 0xb5, 0xa5, 0x4d, 0xc8, 0x45, 0x60, 0x88, 0xf6,
	0xfb, 0xef, 0xd3, 0xff, 0x98, 0x2f, 0x11, 0xc3, 0x80, 0xae, 0x2c, 0x15, 0x5f, 0x6e, 0x7e, 0x93,
	0xa4, 0x77, 0xe0, 0x64, 0x9b, 0x33, 0x3e, 0xd8, 0xcd, 0x40, 0x36, 0xb4, 0x12, 0x91, 0x2c, 0x0d,
	0xc2, 0xa5, 0x75, 0x43, 0x7a, 0x00, 0x93, 0x6c, 0xe3, 0x5f, 0x20, 0x95, 0x42, 0x82, 0xab, 0x56,
	0xbe, 0xc2, 0x38, 0x7e, 0x08, 0x53, 0x49, 0x8e, 0x07, 0x81, 0x5b, 0x9f, 0x9e, 0xbf, 0x12, 0x58,
	0x94, 0xbc, 0x15, 0x32, 0xe8, 0x08, 0x6f, 0xa7, 0xdb, 0x3d, 0xa7, 0x89, 0x31, 0xc6, 0x63, 0x8c,
	0x90, 0x0e, 0x71, 0x13, 0xd2, 0x54, 0x67, 0x42, 0x8a, 0x24, 0xc8, 0x6c, 0x98, 0x75, 0x0f, 0x3b,
	0xc1, 0x27, 0x11, 0xf6, 0x9f, 0x17, 0x33, 0xbe, 0x94, 0xaa, 0x05, 0x3b, 0xd2, 0xa7, 0x02, 0x4c,
	0x25, 0x47, 0x1e, 0x00, 0x7c, 0x19, 0x20, 0xba, 0x11, 0x84, 0x08, 0x3f, 0x1d, 0x47, 0x78, 0xf3,
	0xc6, 0x10, 0xe9, 0x6b, 0x8c, 0x12, 0x2f, 0x6d, 0x2d, 0x7d, 0x8e, 0x60, 0x94, 0xc6, 0x71, 0x8b,
	0xde, 0xa3, 0xd0, 0xc7, 0x02, 0xa4, 0xd6, 0xb0, 0x87, 0x0a, 0x5d, 0x8f, 0x54, 0xeb, 0xa5, 0x43,
	0xe4, 0x61, 0xd5, 0xd2, 0xfc, 0xd3, 0x9f, 0x7f, 0xfd, 0x6c, 0xe8, 0xff, 0xe8, 0x0c, 0xb9, 0xd3,
	0x14, 0xda, 0xee, 0x34, 0xae, 0xb2, 0x17, 0xb5, 0xec, 0x09, 0xda, 0x17, 0x20, 0x4d, 0xca, 0x84,
	0x94, 0xae, 0xa6, 0xdb, 0xaf, 0x2f, 0xa2, 0xca, 0xaf, 0x40, 0x2b, 0x2e, 0xcd, 0xf8, 0x81, 0x9d,
	0x44, 0xff, 0xed, 0x10, 0x18, 0xfa, 0x42, 0x80, 0x0c, 0x65, 0x75, 0x48, 0xed, 0x97, 0xc8, 0x8a,
	0xbd, 0x7b, 0x27, 0xad, 0x1e, 0x1c, 0xe6, 0xa7, 0x3b, 0x10, 0xc7, 0x0c, 0x7d, 0xf7, 0x43, 0x9c,
	0x92, 0x3a, 0x85, 0x78, 0x49, 0xc8, 0xa3, 0x2f, 0x05, 0xc8, 0x50, 0xfe, 0xd2, 0x23, 0xca, 0x04,
	0x72, 0xc5, 0x13, 0xe5, 0x4d, 0x1a, 0x65, 0x22, 0x45, 0x62, 0xa3, 0x9c, 0x2b, 0xf1, 0x74, 0x98,
	0x44, 0xfc, 0x8d, 0x00, 0x19, 0x3a, 0x40, 0x7a, 0x44, 0x9c, 0xc0, 0xb0, 0x78, 0x22, 0x7e, 0xef,
	0xe0, 0x30, 0x5f, 0xe8, 0xc0, 0xae, 0xfe, 0xd3, 0x4a, 0x8d, 0xaf, 0x6f, 0xd9, 0xde, 0x2e, 0x85,
	0x68, 0x9e, 0x0b, 0xa2, 0x3f, 0x08, 0x30, 0x4e, 0xe0, 0xc4, 0x32, 0x26, 0x74, 0x89, 0x13, 0x7d,
	0x09, 0x94, 0x4d, 0x5c, 0x1c, 0x48, 0x37, 0x00, 0x71, 0xd9, 0x0f, 0xbd, 0x84, 0x54, 0x8e, 0xd0,
	0x95, 0xd8, 0x95, 0xed, 0x17, 0x01, 0xc6, 0x96, 0x0d, 0x83, 0xbd, 0xf0, 0x94, 0xbb, 0x46, 0xd2,
	0x85, 0xb6, 0xf1, 0x74, 0xc5, 0x3e, 0x38, 0xcc, 0x17, 0x7b, 0xf0, 0xb0, 0xe3, 0x6d, 0x5b, 0x7e,
	0x7a, 0x0b, 0x52, 0xdf, 0xe9, 0x11, 0x9c, 0xfd, 0x29, 0xc0, 0x71, 0x0a, 0x02, 0x36, 0xc9, 0x45,
	0x6e, 0xc8, 0x0d, 0x96, 0xe7, 0x53, 0xe1, 0xe0, 0x30, 0x5f, 0xee, 0x4d, 0xca, 0xba, 0x20, 0xf1,
	0x6a, 0xfe, 0x4a, 0xbf, 0xf9, 0x2a, 0x7b, 0x0c, 0x2b, 0x7b, 0x82, 0xbe, 0x16, 0x60, 0x94, 0x20,
	0x27, 0x22, 0x52, 0xe8, 0x15, 0x4e, 0x94, 0xb5, 0x72, 0x38, 0xb1, 0xdc, 0xbf, 0x62, 0x80, 0xcd,
	0x05, 0x3f, 0x19, 0x05, 0x15, 0x78, 0x92, 0x89, 0xf8, 0x19, 0xfa, 0x49, 0x80, 0xec, 0xb2, 0x61,
	0x84, 0xf6, 0xd0, 0x02, 0x1f, 0x2a, 0x5b, 0xf8, 0x0f, 0x4f, 0xab, 0x6a, 0x07, 0x87, 0xf9, 0xf9,
	0x6e, 0x04, 0x6d, 0x2c, 0xbe, 0x4e, 0xcf, 0x9a, 0xd4, 0x5f, 0x3e, 0x04, 0x89, 0xbf, 0x0b, 0x30,
	0x46, 0xf1, 0x10, 0x65, 0x55, 0xe6, 0x86, 0xe1, 0x00, 0x89, 0x3d, 0x3e, 0x38, 0xcc, 0x2f, 0xf4,
	0x60, 0x69, 0x5d, 0xf0, 0xb7, 0x94, 0x5f, 0xec, 0x2b, 0x45, 0x65, 0x8f, 0x21, 0x71, 0x4f, 0xd0,
	0xb7, 0x02, 0x8c, 0x11, 0x5c, 0x34, 0x59, 0x0e, 0xe2, 0x05, 0x51, 0x1b, 0xa5, 0x13, 0x2f, 0x0e,
	0xa0, 0x19, 0xe0, 0xef, 0x82, 0x9f, 0x8c, 0x8a, 0x64, 0x9e, 0x64, 0x9a, 0x3c, 0x6a, 0xe5, 0x03,
	0x98, 0x89, 0xf9, 0xd4, 0x6d, 0xb3, 0xc5, 0xef, 0x9d, 0xb5, 0x9a, 0xe9, 0xdd, 0xdf, 0xbe, 0x27,
	0x57, 0xad, 0x2d, 0x85, 0xca, 0x16, 0xe8, 0xff, 0xb6, 0x35, 0xab, 0x50, 0xc3, 0x0d, 0xbf, 0xa6,
	0x4a, 0x97, 0x3f, 0x74, 0x17, 0x83, 0xc7, 0x7b, 0x19, 0x5f, 0xf4, 0xfc, 0xdf, 0x01, 0x00, 0x00,
	0xff, 0xff, 0xd9, 0xda, 0x51, 0x72, 0xf6, 0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DeviceServiceClient is the client API for DeviceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DeviceServiceClient interface {
	// Returns the specified device.
	//
	// To get the list of available devices, make a [List] request.
	Get(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Retrieves the list of devices in the specified registry.
	List(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error)
	// Creates a device in the specified registry.
	Create(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified device.
	Update(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified device.
	Delete(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of device certificates for the specified device.
	ListCertificates(ctx context.Context, in *ListDeviceCertificatesRequest, opts ...grpc.CallOption) (*ListDeviceCertificatesResponse, error)
	// Adds a certificate.
	AddCertificate(ctx context.Context, in *AddDeviceCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified device certificate.
	DeleteCertificate(ctx context.Context, in *DeleteDeviceCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the list of passwords for the specified device.
	ListPasswords(ctx context.Context, in *ListDevicePasswordsRequest, opts ...grpc.CallOption) (*ListDevicePasswordsResponse, error)
	// Adds password for the specified device.
	AddPassword(ctx context.Context, in *AddDevicePasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified password.
	DeletePassword(ctx context.Context, in *DeleteDevicePasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified device.
	ListOperations(ctx context.Context, in *ListDeviceOperationsRequest, opts ...grpc.CallOption) (*ListDeviceOperationsResponse, error)
}

type deviceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDeviceServiceClient(cc grpc.ClientConnInterface) DeviceServiceClient {
	return &deviceServiceClient{cc}
}

func (c *deviceServiceClient) Get(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) List(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error) {
	out := new(ListDevicesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Create(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Update(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Delete(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) ListCertificates(ctx context.Context, in *ListDeviceCertificatesRequest, opts ...grpc.CallOption) (*ListDeviceCertificatesResponse, error) {
	out := new(ListDeviceCertificatesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/ListCertificates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) AddCertificate(ctx context.Context, in *AddDeviceCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/AddCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) DeleteCertificate(ctx context.Context, in *DeleteDeviceCertificateRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/DeleteCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) ListPasswords(ctx context.Context, in *ListDevicePasswordsRequest, opts ...grpc.CallOption) (*ListDevicePasswordsResponse, error) {
	out := new(ListDevicePasswordsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/ListPasswords", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) AddPassword(ctx context.Context, in *AddDevicePasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/AddPassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) DeletePassword(ctx context.Context, in *DeleteDevicePasswordRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/DeletePassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) ListOperations(ctx context.Context, in *ListDeviceOperationsRequest, opts ...grpc.CallOption) (*ListDeviceOperationsResponse, error) {
	out := new(ListDeviceOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.iot.devices.v1.DeviceService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeviceServiceServer is the server API for DeviceService service.
type DeviceServiceServer interface {
	// Returns the specified device.
	//
	// To get the list of available devices, make a [List] request.
	Get(context.Context, *GetDeviceRequest) (*Device, error)
	// Retrieves the list of devices in the specified registry.
	List(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error)
	// Creates a device in the specified registry.
	Create(context.Context, *CreateDeviceRequest) (*operation.Operation, error)
	// Updates the specified device.
	Update(context.Context, *UpdateDeviceRequest) (*operation.Operation, error)
	// Deletes the specified device.
	Delete(context.Context, *DeleteDeviceRequest) (*operation.Operation, error)
	// Retrieves the list of device certificates for the specified device.
	ListCertificates(context.Context, *ListDeviceCertificatesRequest) (*ListDeviceCertificatesResponse, error)
	// Adds a certificate.
	AddCertificate(context.Context, *AddDeviceCertificateRequest) (*operation.Operation, error)
	// Deletes the specified device certificate.
	DeleteCertificate(context.Context, *DeleteDeviceCertificateRequest) (*operation.Operation, error)
	// Retrieves the list of passwords for the specified device.
	ListPasswords(context.Context, *ListDevicePasswordsRequest) (*ListDevicePasswordsResponse, error)
	// Adds password for the specified device.
	AddPassword(context.Context, *AddDevicePasswordRequest) (*operation.Operation, error)
	// Deletes the specified password.
	DeletePassword(context.Context, *DeleteDevicePasswordRequest) (*operation.Operation, error)
	// Lists operations for the specified device.
	ListOperations(context.Context, *ListDeviceOperationsRequest) (*ListDeviceOperationsResponse, error)
}

// UnimplementedDeviceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDeviceServiceServer struct {
}

func (*UnimplementedDeviceServiceServer) Get(ctx context.Context, req *GetDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedDeviceServiceServer) List(ctx context.Context, req *ListDevicesRequest) (*ListDevicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedDeviceServiceServer) Create(ctx context.Context, req *CreateDeviceRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedDeviceServiceServer) Update(ctx context.Context, req *UpdateDeviceRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedDeviceServiceServer) Delete(ctx context.Context, req *DeleteDeviceRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedDeviceServiceServer) ListCertificates(ctx context.Context, req *ListDeviceCertificatesRequest) (*ListDeviceCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificates not implemented")
}
func (*UnimplementedDeviceServiceServer) AddCertificate(ctx context.Context, req *AddDeviceCertificateRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddCertificate not implemented")
}
func (*UnimplementedDeviceServiceServer) DeleteCertificate(ctx context.Context, req *DeleteDeviceCertificateRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificate not implemented")
}
func (*UnimplementedDeviceServiceServer) ListPasswords(ctx context.Context, req *ListDevicePasswordsRequest) (*ListDevicePasswordsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPasswords not implemented")
}
func (*UnimplementedDeviceServiceServer) AddPassword(ctx context.Context, req *AddDevicePasswordRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPassword not implemented")
}
func (*UnimplementedDeviceServiceServer) DeletePassword(ctx context.Context, req *DeleteDevicePasswordRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePassword not implemented")
}
func (*UnimplementedDeviceServiceServer) ListOperations(ctx context.Context, req *ListDeviceOperationsRequest) (*ListDeviceOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}

func RegisterDeviceServiceServer(s *grpc.Server, srv DeviceServiceServer) {
	s.RegisterService(&_DeviceService_serviceDesc, srv)
}

func _DeviceService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Get(ctx, req.(*GetDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).List(ctx, req.(*ListDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Create(ctx, req.(*CreateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Update(ctx, req.(*UpdateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Delete(ctx, req.(*DeleteDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_ListCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).ListCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/ListCertificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).ListCertificates(ctx, req.(*ListDeviceCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_AddCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddDeviceCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).AddCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/AddCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).AddCertificate(ctx, req.(*AddDeviceCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_DeleteCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).DeleteCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/DeleteCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).DeleteCertificate(ctx, req.(*DeleteDeviceCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_ListPasswords_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDevicePasswordsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).ListPasswords(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/ListPasswords",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).ListPasswords(ctx, req.(*ListDevicePasswordsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_AddPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddDevicePasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).AddPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/AddPassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).AddPassword(ctx, req.(*AddDevicePasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_DeletePassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDevicePasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).DeletePassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/DeletePassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).DeletePassword(ctx, req.(*DeleteDevicePasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.iot.devices.v1.DeviceService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).ListOperations(ctx, req.(*ListDeviceOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DeviceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.iot.devices.v1.DeviceService",
	HandlerType: (*DeviceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _DeviceService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _DeviceService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _DeviceService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _DeviceService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _DeviceService_Delete_Handler,
		},
		{
			MethodName: "ListCertificates",
			Handler:    _DeviceService_ListCertificates_Handler,
		},
		{
			MethodName: "AddCertificate",
			Handler:    _DeviceService_AddCertificate_Handler,
		},
		{
			MethodName: "DeleteCertificate",
			Handler:    _DeviceService_DeleteCertificate_Handler,
		},
		{
			MethodName: "ListPasswords",
			Handler:    _DeviceService_ListPasswords_Handler,
		},
		{
			MethodName: "AddPassword",
			Handler:    _DeviceService_AddPassword_Handler,
		},
		{
			MethodName: "DeletePassword",
			Handler:    _DeviceService_DeletePassword_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _DeviceService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/iot/devices/v1/device_service.proto",
}
