// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/k8s/v1/cluster.proto

package k8s

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ReleaseChannel int32

const (
	ReleaseChannel_RELEASE_CHANNEL_UNSPECIFIED ReleaseChannel = 0
	// Minor updates with new functions and improvements are often added.
	// You can't disable automatic updates in this channel, but you can specify a time period for automatic updates.
	ReleaseChannel_RAPID ReleaseChannel = 1
	// New functions and improvements are added in chunks shortly after they appear on `RAPID`.
	ReleaseChannel_REGULAR ReleaseChannel = 2
	// Only updates related to bug fixes or security improvements are added.
	ReleaseChannel_STABLE ReleaseChannel = 3
)

var ReleaseChannel_name = map[int32]string{
	0: "RELEASE_CHANNEL_UNSPECIFIED",
	1: "RAPID",
	2: "REGULAR",
	3: "STABLE",
}

var ReleaseChannel_value = map[string]int32{
	"RELEASE_CHANNEL_UNSPECIFIED": 0,
	"RAPID":                       1,
	"REGULAR":                     2,
	"STABLE":                      3,
}

func (x ReleaseChannel) String() string {
	return proto.EnumName(ReleaseChannel_name, int32(x))
}

func (ReleaseChannel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{0}
}

type Cluster_Status int32

const (
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// Kubernetes cluster is waiting for resources to be allocated.
	Cluster_PROVISIONING Cluster_Status = 1
	// Kubernetes cluster is running.
	Cluster_RUNNING Cluster_Status = 2
	// Kubernetes cluster is being reconciled.
	Cluster_RECONCILING Cluster_Status = 3
	// Kubernetes cluster is being stopped.
	Cluster_STOPPING Cluster_Status = 4
	// Kubernetes cluster stopped.
	Cluster_STOPPED Cluster_Status = 5
	// Kubernetes cluster is being deleted.
	Cluster_DELETING Cluster_Status = 6
	// Kubernetes cluster is being started.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RECONCILING",
	4: "STOPPING",
	5: "STOPPED",
	6: "DELETING",
	7: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RECONCILING":        3,
	"STOPPING":           4,
	"STOPPED":            5,
	"DELETING":           6,
	"STARTING":           7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{0, 0}
}

type Cluster_Health int32

const (
	Cluster_HEALTH_UNSPECIFIED Cluster_Health = 0
	// Kubernetes cluster is alive and well.
	Cluster_HEALTHY Cluster_Health = 1
	// Kubernetes cluster is inoperable.
	Cluster_UNHEALTHY Cluster_Health = 2
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNSPECIFIED",
	1: "HEALTHY",
	2: "UNHEALTHY",
}

var Cluster_Health_value = map[string]int32{
	"HEALTH_UNSPECIFIED": 0,
	"HEALTHY":            1,
	"UNHEALTHY":          2,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}

func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{0, 1}
}

type NetworkPolicy_Provider int32

const (
	NetworkPolicy_PROVIDER_UNSPECIFIED NetworkPolicy_Provider = 0
	NetworkPolicy_CALICO               NetworkPolicy_Provider = 1
)

var NetworkPolicy_Provider_name = map[int32]string{
	0: "PROVIDER_UNSPECIFIED",
	1: "CALICO",
}

var NetworkPolicy_Provider_value = map[string]int32{
	"PROVIDER_UNSPECIFIED": 0,
	"CALICO":               1,
}

func (x NetworkPolicy_Provider) String() string {
	return proto.EnumName(NetworkPolicy_Provider_name, int32(x))
}

func (NetworkPolicy_Provider) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{8, 0}
}

// A Kubernetes cluster.
type Cluster struct {
	// ID of the Kubernetes cluster.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Kubernetes cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Kubernetes cluster.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the Kubernetes cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs. Мaximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Status of the Kubernetes cluster.
	Status Cluster_Status `protobuf:"varint,7,opt,name=status,proto3,enum=yandex.cloud.k8s.v1.Cluster_Status" json:"status,omitempty"`
	// Health of the Kubernetes cluster.
	Health Cluster_Health `protobuf:"varint,8,opt,name=health,proto3,enum=yandex.cloud.k8s.v1.Cluster_Health" json:"health,omitempty"`
	// ID of the network the Kubernetes cluster belongs to.
	NetworkId string `protobuf:"bytes,9,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Properties of the master for the Kubernetes cluster.
	Master *Master `protobuf:"bytes,10,opt,name=master,proto3" json:"master,omitempty"`
	// Allocation policy for IP addresses of services and pods inside the Kubernetes cluster in different availability zones.
	IpAllocationPolicy *IPAllocationPolicy `protobuf:"bytes,11,opt,name=ip_allocation_policy,json=ipAllocationPolicy,proto3" json:"ip_allocation_policy,omitempty"`
	// Types that are valid to be assigned to InternetGateway:
	//	*Cluster_GatewayIpv4Address
	InternetGateway isCluster_InternetGateway `protobuf_oneof:"internet_gateway"`
	// Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster.
	ServiceAccountId string `protobuf:"bytes,13,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
	NodeServiceAccountId string `protobuf:"bytes,14,opt,name=node_service_account_id,json=nodeServiceAccountId,proto3" json:"node_service_account_id,omitempty"`
	// When creating a Kubernetes cluster, you should specify one of three release channels. The release channel contains several Kubernetes versions.
	// Channels differ in the set of available versions, the management of auto-updates, and the updates received.
	// You can't change the channel once the Kubernetes cluster is created, you can only recreate the Kubernetes cluster and specify a new release channel.
	// For more details see [documentation](https://cloud.yandex.com/docs/managed-kubernetes/concepts/release-channels-and-updates).
	ReleaseChannel ReleaseChannel `protobuf:"varint,15,opt,name=release_channel,json=releaseChannel,proto3,enum=yandex.cloud.k8s.v1.ReleaseChannel" json:"release_channel,omitempty"`
	NetworkPolicy  *NetworkPolicy `protobuf:"bytes,16,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// KMS provider configuration.
	KmsProvider          *KMSProvider `protobuf:"bytes,17,opt,name=kms_provider,json=kmsProvider,proto3" json:"kms_provider,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNSPECIFIED
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetMaster() *Master {
	if m != nil {
		return m.Master
	}
	return nil
}

func (m *Cluster) GetIpAllocationPolicy() *IPAllocationPolicy {
	if m != nil {
		return m.IpAllocationPolicy
	}
	return nil
}

type isCluster_InternetGateway interface {
	isCluster_InternetGateway()
}

type Cluster_GatewayIpv4Address struct {
	GatewayIpv4Address string `protobuf:"bytes,12,opt,name=gateway_ipv4_address,json=gatewayIpv4Address,proto3,oneof"`
}

func (*Cluster_GatewayIpv4Address) isCluster_InternetGateway() {}

func (m *Cluster) GetInternetGateway() isCluster_InternetGateway {
	if m != nil {
		return m.InternetGateway
	}
	return nil
}

func (m *Cluster) GetGatewayIpv4Address() string {
	if x, ok := m.GetInternetGateway().(*Cluster_GatewayIpv4Address); ok {
		return x.GatewayIpv4Address
	}
	return ""
}

func (m *Cluster) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

func (m *Cluster) GetNodeServiceAccountId() string {
	if m != nil {
		return m.NodeServiceAccountId
	}
	return ""
}

func (m *Cluster) GetReleaseChannel() ReleaseChannel {
	if m != nil {
		return m.ReleaseChannel
	}
	return ReleaseChannel_RELEASE_CHANNEL_UNSPECIFIED
}

func (m *Cluster) GetNetworkPolicy() *NetworkPolicy {
	if m != nil {
		return m.NetworkPolicy
	}
	return nil
}

func (m *Cluster) GetKmsProvider() *KMSProvider {
	if m != nil {
		return m.KmsProvider
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Cluster) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Cluster_GatewayIpv4Address)(nil),
	}
}

type Master struct {
	// Types that are valid to be assigned to MasterType:
	//	*Master_ZonalMaster
	//	*Master_RegionalMaster
	MasterType isMaster_MasterType `protobuf_oneof:"master_type"`
	// Version of Kubernetes components that runs on the master.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Endpoints of the master. Endpoints constitute of scheme and port (i.e. `https://ip-address:port`)
	//and can be used by the clients to communicate with the Kubernetes API of the Kubernetes cluster.
	Endpoints *MasterEndpoints `protobuf:"bytes,3,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Master authentication parameters are used to establish trust between the master and a client.
	MasterAuth *MasterAuth `protobuf:"bytes,4,opt,name=master_auth,json=masterAuth,proto3" json:"master_auth,omitempty"`
	// Detailed information about the Kubernetes version that is running on the master.
	VersionInfo *VersionInfo `protobuf:"bytes,5,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// Maintenance policy of the master.
	MaintenancePolicy    *MasterMaintenancePolicy `protobuf:"bytes,6,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Master) Reset()         { *m = Master{} }
func (m *Master) String() string { return proto.CompactTextString(m) }
func (*Master) ProtoMessage()    {}
func (*Master) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{1}
}

func (m *Master) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Master.Unmarshal(m, b)
}
func (m *Master) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Master.Marshal(b, m, deterministic)
}
func (m *Master) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Master.Merge(m, src)
}
func (m *Master) XXX_Size() int {
	return xxx_messageInfo_Master.Size(m)
}
func (m *Master) XXX_DiscardUnknown() {
	xxx_messageInfo_Master.DiscardUnknown(m)
}

var xxx_messageInfo_Master proto.InternalMessageInfo

type isMaster_MasterType interface {
	isMaster_MasterType()
}

type Master_ZonalMaster struct {
	ZonalMaster *ZonalMaster `protobuf:"bytes,1,opt,name=zonal_master,json=zonalMaster,proto3,oneof"`
}

type Master_RegionalMaster struct {
	RegionalMaster *RegionalMaster `protobuf:"bytes,7,opt,name=regional_master,json=regionalMaster,proto3,oneof"`
}

func (*Master_ZonalMaster) isMaster_MasterType() {}

func (*Master_RegionalMaster) isMaster_MasterType() {}

func (m *Master) GetMasterType() isMaster_MasterType {
	if m != nil {
		return m.MasterType
	}
	return nil
}

func (m *Master) GetZonalMaster() *ZonalMaster {
	if x, ok := m.GetMasterType().(*Master_ZonalMaster); ok {
		return x.ZonalMaster
	}
	return nil
}

func (m *Master) GetRegionalMaster() *RegionalMaster {
	if x, ok := m.GetMasterType().(*Master_RegionalMaster); ok {
		return x.RegionalMaster
	}
	return nil
}

func (m *Master) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Master) GetEndpoints() *MasterEndpoints {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

func (m *Master) GetMasterAuth() *MasterAuth {
	if m != nil {
		return m.MasterAuth
	}
	return nil
}

func (m *Master) GetVersionInfo() *VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return nil
}

func (m *Master) GetMaintenancePolicy() *MasterMaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Master) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Master_ZonalMaster)(nil),
		(*Master_RegionalMaster)(nil),
	}
}

type MasterAuth struct {
	// PEM-encoded public certificate that is the root of trust for the Kubernetes cluster.
	ClusterCaCertificate string   `protobuf:"bytes,1,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterAuth) Reset()         { *m = MasterAuth{} }
func (m *MasterAuth) String() string { return proto.CompactTextString(m) }
func (*MasterAuth) ProtoMessage()    {}
func (*MasterAuth) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{2}
}

func (m *MasterAuth) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterAuth.Unmarshal(m, b)
}
func (m *MasterAuth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterAuth.Marshal(b, m, deterministic)
}
func (m *MasterAuth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterAuth.Merge(m, src)
}
func (m *MasterAuth) XXX_Size() int {
	return xxx_messageInfo_MasterAuth.Size(m)
}
func (m *MasterAuth) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterAuth.DiscardUnknown(m)
}

var xxx_messageInfo_MasterAuth proto.InternalMessageInfo

func (m *MasterAuth) GetClusterCaCertificate() string {
	if m != nil {
		return m.ClusterCaCertificate
	}
	return ""
}

type ZonalMaster struct {
	// ID of the availability zone where the master resides.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// IPv4 internal network address that is assigned to the master.
	InternalV4Address string `protobuf:"bytes,2,opt,name=internal_v4_address,json=internalV4Address,proto3" json:"internal_v4_address,omitempty"`
	// IPv4 external network address that is assigned to the master.
	ExternalV4Address    string   `protobuf:"bytes,3,opt,name=external_v4_address,json=externalV4Address,proto3" json:"external_v4_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZonalMaster) Reset()         { *m = ZonalMaster{} }
func (m *ZonalMaster) String() string { return proto.CompactTextString(m) }
func (*ZonalMaster) ProtoMessage()    {}
func (*ZonalMaster) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{3}
}

func (m *ZonalMaster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZonalMaster.Unmarshal(m, b)
}
func (m *ZonalMaster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZonalMaster.Marshal(b, m, deterministic)
}
func (m *ZonalMaster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZonalMaster.Merge(m, src)
}
func (m *ZonalMaster) XXX_Size() int {
	return xxx_messageInfo_ZonalMaster.Size(m)
}
func (m *ZonalMaster) XXX_DiscardUnknown() {
	xxx_messageInfo_ZonalMaster.DiscardUnknown(m)
}

var xxx_messageInfo_ZonalMaster proto.InternalMessageInfo

func (m *ZonalMaster) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *ZonalMaster) GetInternalV4Address() string {
	if m != nil {
		return m.InternalV4Address
	}
	return ""
}

func (m *ZonalMaster) GetExternalV4Address() string {
	if m != nil {
		return m.ExternalV4Address
	}
	return ""
}

type RegionalMaster struct {
	// ID of the region where the master resides.
	RegionId string `protobuf:"bytes,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// IPv4 internal network address that is assigned to the master.
	InternalV4Address string `protobuf:"bytes,2,opt,name=internal_v4_address,json=internalV4Address,proto3" json:"internal_v4_address,omitempty"`
	// IPv4 external network address that is assigned to the master.
	ExternalV4Address    string   `protobuf:"bytes,3,opt,name=external_v4_address,json=externalV4Address,proto3" json:"external_v4_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegionalMaster) Reset()         { *m = RegionalMaster{} }
func (m *RegionalMaster) String() string { return proto.CompactTextString(m) }
func (*RegionalMaster) ProtoMessage()    {}
func (*RegionalMaster) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{4}
}

func (m *RegionalMaster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegionalMaster.Unmarshal(m, b)
}
func (m *RegionalMaster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegionalMaster.Marshal(b, m, deterministic)
}
func (m *RegionalMaster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionalMaster.Merge(m, src)
}
func (m *RegionalMaster) XXX_Size() int {
	return xxx_messageInfo_RegionalMaster.Size(m)
}
func (m *RegionalMaster) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionalMaster.DiscardUnknown(m)
}

var xxx_messageInfo_RegionalMaster proto.InternalMessageInfo

func (m *RegionalMaster) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *RegionalMaster) GetInternalV4Address() string {
	if m != nil {
		return m.InternalV4Address
	}
	return ""
}

func (m *RegionalMaster) GetExternalV4Address() string {
	if m != nil {
		return m.ExternalV4Address
	}
	return ""
}

type MasterEndpoints struct {
	// Internal endpoint that can be used to connect to the master from cloud networks.
	InternalV4Endpoint string `protobuf:"bytes,1,opt,name=internal_v4_endpoint,json=internalV4Endpoint,proto3" json:"internal_v4_endpoint,omitempty"`
	// External endpoint that can be used to access Kubernetes cluster API from the internet (outside of the cloud).
	ExternalV4Endpoint   string   `protobuf:"bytes,2,opt,name=external_v4_endpoint,json=externalV4Endpoint,proto3" json:"external_v4_endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterEndpoints) Reset()         { *m = MasterEndpoints{} }
func (m *MasterEndpoints) String() string { return proto.CompactTextString(m) }
func (*MasterEndpoints) ProtoMessage()    {}
func (*MasterEndpoints) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{5}
}

func (m *MasterEndpoints) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterEndpoints.Unmarshal(m, b)
}
func (m *MasterEndpoints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterEndpoints.Marshal(b, m, deterministic)
}
func (m *MasterEndpoints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterEndpoints.Merge(m, src)
}
func (m *MasterEndpoints) XXX_Size() int {
	return xxx_messageInfo_MasterEndpoints.Size(m)
}
func (m *MasterEndpoints) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterEndpoints.DiscardUnknown(m)
}

var xxx_messageInfo_MasterEndpoints proto.InternalMessageInfo

func (m *MasterEndpoints) GetInternalV4Endpoint() string {
	if m != nil {
		return m.InternalV4Endpoint
	}
	return ""
}

func (m *MasterEndpoints) GetExternalV4Endpoint() string {
	if m != nil {
		return m.ExternalV4Endpoint
	}
	return ""
}

type IPAllocationPolicy struct {
	// CIDR block. IP range for allocating pod addresses.
	//
	// It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be
	// set up for this CIDR blocks in node subnets.
	ClusterIpv4CidrBlock string `protobuf:"bytes,1,opt,name=cluster_ipv4_cidr_block,json=clusterIpv4CidrBlock,proto3" json:"cluster_ipv4_cidr_block,omitempty"`
	// Size of the masks that are assigned for each node in the cluster.
	//
	// If not specified, 24 is used.
	NodeIpv4CidrMaskSize int64 `protobuf:"varint,5,opt,name=node_ipv4_cidr_mask_size,json=nodeIpv4CidrMaskSize,proto3" json:"node_ipv4_cidr_mask_size,omitempty"`
	// CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from.
	//
	// It should not overlap with any subnet in the network the Kubernetes cluster located in.
	ServiceIpv4CidrBlock string   `protobuf:"bytes,2,opt,name=service_ipv4_cidr_block,json=serviceIpv4CidrBlock,proto3" json:"service_ipv4_cidr_block,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPAllocationPolicy) Reset()         { *m = IPAllocationPolicy{} }
func (m *IPAllocationPolicy) String() string { return proto.CompactTextString(m) }
func (*IPAllocationPolicy) ProtoMessage()    {}
func (*IPAllocationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{6}
}

func (m *IPAllocationPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IPAllocationPolicy.Unmarshal(m, b)
}
func (m *IPAllocationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IPAllocationPolicy.Marshal(b, m, deterministic)
}
func (m *IPAllocationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPAllocationPolicy.Merge(m, src)
}
func (m *IPAllocationPolicy) XXX_Size() int {
	return xxx_messageInfo_IPAllocationPolicy.Size(m)
}
func (m *IPAllocationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_IPAllocationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_IPAllocationPolicy proto.InternalMessageInfo

func (m *IPAllocationPolicy) GetClusterIpv4CidrBlock() string {
	if m != nil {
		return m.ClusterIpv4CidrBlock
	}
	return ""
}

func (m *IPAllocationPolicy) GetNodeIpv4CidrMaskSize() int64 {
	if m != nil {
		return m.NodeIpv4CidrMaskSize
	}
	return 0
}

func (m *IPAllocationPolicy) GetServiceIpv4CidrBlock() string {
	if m != nil {
		return m.ServiceIpv4CidrBlock
	}
	return ""
}

type MasterMaintenancePolicy struct {
	// If set to true, automatic updates are installed in the specified period of time with no interaction from the user.
	// If set to false, automatic upgrades are disabled.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade,proto3" json:"auto_upgrade,omitempty"`
	// Maintenance window settings. Update will start at the specified time and last no more than the specified duration.
	// The time is set in UTC.
	MaintenanceWindow    *MaintenanceWindow `protobuf:"bytes,2,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MasterMaintenancePolicy) Reset()         { *m = MasterMaintenancePolicy{} }
func (m *MasterMaintenancePolicy) String() string { return proto.CompactTextString(m) }
func (*MasterMaintenancePolicy) ProtoMessage()    {}
func (*MasterMaintenancePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{7}
}

func (m *MasterMaintenancePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MasterMaintenancePolicy.Unmarshal(m, b)
}
func (m *MasterMaintenancePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MasterMaintenancePolicy.Marshal(b, m, deterministic)
}
func (m *MasterMaintenancePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterMaintenancePolicy.Merge(m, src)
}
func (m *MasterMaintenancePolicy) XXX_Size() int {
	return xxx_messageInfo_MasterMaintenancePolicy.Size(m)
}
func (m *MasterMaintenancePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterMaintenancePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_MasterMaintenancePolicy proto.InternalMessageInfo

func (m *MasterMaintenancePolicy) GetAutoUpgrade() bool {
	if m != nil {
		return m.AutoUpgrade
	}
	return false
}

func (m *MasterMaintenancePolicy) GetMaintenanceWindow() *MaintenanceWindow {
	if m != nil {
		return m.MaintenanceWindow
	}
	return nil
}

type NetworkPolicy struct {
	Provider             NetworkPolicy_Provider `protobuf:"varint,1,opt,name=provider,proto3,enum=yandex.cloud.k8s.v1.NetworkPolicy_Provider" json:"provider,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *NetworkPolicy) Reset()         { *m = NetworkPolicy{} }
func (m *NetworkPolicy) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicy) ProtoMessage()    {}
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{8}
}

func (m *NetworkPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkPolicy.Unmarshal(m, b)
}
func (m *NetworkPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkPolicy.Marshal(b, m, deterministic)
}
func (m *NetworkPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicy.Merge(m, src)
}
func (m *NetworkPolicy) XXX_Size() int {
	return xxx_messageInfo_NetworkPolicy.Size(m)
}
func (m *NetworkPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicy proto.InternalMessageInfo

func (m *NetworkPolicy) GetProvider() NetworkPolicy_Provider {
	if m != nil {
		return m.Provider
	}
	return NetworkPolicy_PROVIDER_UNSPECIFIED
}

type KMSProvider struct {
	// KMS key ID for secrets encryption.
	// To obtain a KMS key ID use a [yandex.cloud.kms.v1.SymmetricKeyService.List] request.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KMSProvider) Reset()         { *m = KMSProvider{} }
func (m *KMSProvider) String() string { return proto.CompactTextString(m) }
func (*KMSProvider) ProtoMessage()    {}
func (*KMSProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_978615dae5f27f2e, []int{9}
}

func (m *KMSProvider) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KMSProvider.Unmarshal(m, b)
}
func (m *KMSProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KMSProvider.Marshal(b, m, deterministic)
}
func (m *KMSProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KMSProvider.Merge(m, src)
}
func (m *KMSProvider) XXX_Size() int {
	return xxx_messageInfo_KMSProvider.Size(m)
}
func (m *KMSProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_KMSProvider.DiscardUnknown(m)
}

var xxx_messageInfo_KMSProvider proto.InternalMessageInfo

func (m *KMSProvider) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func init() {
	proto.RegisterEnum("yandex.cloud.k8s.v1.ReleaseChannel", ReleaseChannel_name, ReleaseChannel_value)
	proto.RegisterEnum("yandex.cloud.k8s.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.k8s.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.k8s.v1.NetworkPolicy_Provider", NetworkPolicy_Provider_name, NetworkPolicy_Provider_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.k8s.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Master)(nil), "yandex.cloud.k8s.v1.Master")
	proto.RegisterType((*MasterAuth)(nil), "yandex.cloud.k8s.v1.MasterAuth")
	proto.RegisterType((*ZonalMaster)(nil), "yandex.cloud.k8s.v1.ZonalMaster")
	proto.RegisterType((*RegionalMaster)(nil), "yandex.cloud.k8s.v1.RegionalMaster")
	proto.RegisterType((*MasterEndpoints)(nil), "yandex.cloud.k8s.v1.MasterEndpoints")
	proto.RegisterType((*IPAllocationPolicy)(nil), "yandex.cloud.k8s.v1.IPAllocationPolicy")
	proto.RegisterType((*MasterMaintenancePolicy)(nil), "yandex.cloud.k8s.v1.MasterMaintenancePolicy")
	proto.RegisterType((*NetworkPolicy)(nil), "yandex.cloud.k8s.v1.NetworkPolicy")
	proto.RegisterType((*KMSProvider)(nil), "yandex.cloud.k8s.v1.KMSProvider")
}

func init() {
	proto.RegisterFile("yandex/cloud/k8s/v1/cluster.proto", fileDescriptor_978615dae5f27f2e)
}

var fileDescriptor_978615dae5f27f2e = []byte{
	// 1352 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcd, 0x6e, 0xdb, 0xd6,
	0x12, 0x0e, 0x2d, 0x5b, 0x3f, 0x43, 0xff, 0x28, 0x27, 0xba, 0x31, 0xe1, 0x20, 0x88, 0xa3, 0x9b,
	0x7b, 0xaf, 0x71, 0xab, 0x50, 0xb1, 0xe2, 0xb4, 0x4e, 0x93, 0x02, 0xa1, 0x64, 0x36, 0x26, 0x2a,
	0xcb, 0x02, 0x25, 0xb9, 0x48, 0xba, 0x20, 0x8e, 0xc9, 0x63, 0x99, 0x10, 0x45, 0x0a, 0x24, 0x25,
	0x47, 0x7e, 0x80, 0x16, 0x08, 0xd0, 0x55, 0xdf, 0xa2, 0x2f, 0xd2, 0x2e, 0xfb, 0x28, 0x5d, 0x77,
	0x55, 0x9c, 0x1f, 0xea, 0x2f, 0xb2, 0xdb, 0x55, 0x77, 0x9c, 0x99, 0x6f, 0xe6, 0xcc, 0x9c, 0x33,
	0x33, 0x1f, 0xe1, 0xf1, 0x18, 0xfb, 0x0e, 0xf9, 0x50, 0xb6, 0xbd, 0x60, 0xe8, 0x94, 0x7b, 0x87,
	0x51, 0x79, 0xb4, 0x5f, 0xb6, 0xbd, 0x61, 0x14, 0x93, 0x50, 0x1d, 0x84, 0x41, 0x1c, 0xa0, 0x7b,
	0x1c, 0xa2, 0x32, 0x88, 0xda, 0x3b, 0x8c, 0xd4, 0xd1, 0xfe, 0xce, 0xa3, 0x6e, 0x10, 0x74, 0x3d,
	0x52, 0x66, 0x90, 0xf3, 0xe1, 0x45, 0x39, 0x76, 0xfb, 0x24, 0x8a, 0x71, 0x7f, 0xc0, 0xbd, 0x76,
	0xfe, 0xb3, 0x2c, 0x70, 0x1f, 0xbb, 0x7e, 0x4c, 0x7c, 0xec, 0xdb, 0x44, 0xc0, 0x96, 0x9e, 0x3f,
	0x22, 0x61, 0xe4, 0x06, 0xbe, 0x80, 0x3c, 0x9c, 0x83, 0x8c, 0xb0, 0xe7, 0x3a, 0x38, 0x9e, 0x98,
	0x8b, 0x3f, 0xe7, 0x20, 0x53, 0xe3, 0x09, 0xa3, 0x4d, 0x58, 0x71, 0x1d, 0x45, 0xda, 0x95, 0xf6,
	0x72, 0xe6, 0x8a, 0xeb, 0xa0, 0x07, 0x90, 0xbb, 0x08, 0x3c, 0x87, 0x84, 0x96, 0xeb, 0x28, 0x2b,
	0x4c, 0x9d, 0xe5, 0x0a, 0xc3, 0x41, 0x2f, 0x01, 0xec, 0x90, 0xe0, 0x98, 0x38, 0x16, 0x8e, 0x95,
	0xd4, 0xae, 0xb4, 0x27, 0x57, 0x76, 0x54, 0x5e, 0x97, 0x9a, 0xd4, 0xa5, 0xb6, 0x93, 0xba, 0xcc,
	0x9c, 0x40, 0x6b, 0x31, 0x42, 0xb0, 0xea, 0xe3, 0x3e, 0x51, 0x56, 0x59, 0x48, 0xf6, 0x8d, 0x76,
	0x41, 0x76, 0x48, 0x64, 0x87, 0xee, 0x80, 0x26, 0xa7, 0xac, 0x31, 0xd3, 0xac, 0x0a, 0xbd, 0x81,
	0xb4, 0x87, 0xcf, 0x89, 0x17, 0x29, 0xe9, 0xdd, 0xd4, 0x9e, 0x5c, 0xd9, 0x53, 0x97, 0xdc, 0xac,
	0x2a, 0x6a, 0x51, 0xeb, 0x0c, 0xaa, 0xfb, 0x71, 0x38, 0x36, 0x85, 0x1f, 0x7a, 0x05, 0xe9, 0x28,
	0xc6, 0xf1, 0x30, 0x52, 0x32, 0xbb, 0xd2, 0xde, 0x66, 0xe5, 0xdf, 0xb7, 0x46, 0x68, 0x31, 0xa8,
	0x29, 0x5c, 0xa8, 0xf3, 0x25, 0xc1, 0x5e, 0x7c, 0xa9, 0x64, 0xff, 0x86, 0xf3, 0x31, 0x83, 0x9a,
	0xc2, 0x05, 0x3d, 0x04, 0xf0, 0x49, 0x7c, 0x15, 0x84, 0x3d, 0x7a, 0x95, 0x39, 0x56, 0x5c, 0x4e,
	0x68, 0x0c, 0x07, 0x3d, 0x87, 0x74, 0x1f, 0x53, 0x3f, 0x05, 0xd8, 0x3d, 0x3e, 0x58, 0x1a, 0xfb,
	0x84, 0x41, 0x4c, 0x01, 0x45, 0xef, 0xa0, 0xe0, 0x0e, 0x2c, 0xec, 0x79, 0x81, 0xcd, 0x1e, 0xd4,
	0x1a, 0x04, 0x9e, 0x6b, 0x8f, 0x15, 0x99, 0x85, 0xf8, 0xdf, 0xd2, 0x10, 0x46, 0x53, 0x9b, 0xe0,
	0x9b, 0x0c, 0x6e, 0x22, 0x77, 0xb0, 0xa8, 0x43, 0xaf, 0xa1, 0xd0, 0xc5, 0x31, 0xb9, 0xc2, 0x63,
	0xcb, 0x1d, 0x8c, 0x0e, 0x2c, 0xec, 0x38, 0x21, 0x89, 0x22, 0x65, 0x9d, 0x26, 0x5e, 0xcd, 0x7e,
	0xfc, 0x75, 0x7f, 0xf5, 0xf5, 0x57, 0xfb, 0x2f, 0x8e, 0xef, 0x98, 0x48, 0xe0, 0x8c, 0xc1, 0xe8,
	0x40, 0xe3, 0x28, 0x54, 0x02, 0x14, 0x91, 0x70, 0xe4, 0xda, 0xc4, 0xc2, 0xb6, 0x1d, 0x0c, 0xfd,
	0x98, 0x16, 0xbd, 0xc1, 0x8a, 0xce, 0x0b, 0x8b, 0xc6, 0x0d, 0x86, 0x83, 0x5e, 0xc0, 0xb6, 0x1f,
	0x38, 0xc4, 0x5a, 0xe2, 0xb2, 0xc9, 0x5c, 0x0a, 0xd4, 0xdc, 0x5a, 0x74, 0xab, 0xc3, 0x56, 0x48,
	0x3c, 0x82, 0x23, 0x62, 0xd9, 0x97, 0xd8, 0xf7, 0x89, 0xa7, 0x6c, 0xdd, 0xf2, 0x2e, 0x26, 0xc7,
	0xd6, 0x38, 0xd4, 0xdc, 0x0c, 0xe7, 0x64, 0x64, 0xc0, 0x66, 0xf2, 0x3e, 0xe2, 0x16, 0xf3, 0xec,
	0x16, 0x8b, 0x4b, 0x83, 0x35, 0x38, 0x54, 0x5c, 0xe0, 0x86, 0x3f, 0x2b, 0xa2, 0x1a, 0xac, 0xf7,
	0xfa, 0x91, 0x35, 0x08, 0x83, 0x91, 0xeb, 0x90, 0x50, 0xb9, 0xcb, 0x02, 0xed, 0x2e, 0x0d, 0xf4,
	0xcd, 0x49, 0xab, 0x29, 0x70, 0xa6, 0xdc, 0xeb, 0x47, 0x89, 0xb0, 0xf3, 0x12, 0xe4, 0x99, 0x06,
	0x46, 0x79, 0x48, 0xf5, 0xc8, 0x58, 0x4c, 0x26, 0xfd, 0x44, 0x05, 0x58, 0x1b, 0x61, 0x6f, 0x48,
	0xc4, 0x58, 0x72, 0xe1, 0xcb, 0x95, 0x43, 0xa9, 0xf8, 0x83, 0x04, 0x69, 0xde, 0xba, 0xe8, 0x3e,
	0xa0, 0x56, 0x5b, 0x6b, 0x77, 0x5a, 0x56, 0xa7, 0xd1, 0x6a, 0xea, 0x35, 0xe3, 0x6b, 0x43, 0x3f,
	0xca, 0xdf, 0x41, 0x79, 0x58, 0x6f, 0x9a, 0xa7, 0x67, 0x46, 0xcb, 0x38, 0x6d, 0x18, 0x8d, 0xb7,
	0x79, 0x09, 0xc9, 0x90, 0x31, 0x3b, 0x0d, 0x26, 0xac, 0xa0, 0x2d, 0x90, 0x4d, 0xbd, 0x76, 0xda,
	0xa8, 0x19, 0x75, 0xaa, 0x48, 0xa1, 0x75, 0xc8, 0xb6, 0xda, 0xa7, 0xcd, 0x26, 0x95, 0x56, 0x29,
	0x96, 0x49, 0xfa, 0x51, 0x7e, 0x8d, 0x9a, 0x8e, 0xf4, 0xba, 0xde, 0xa6, 0xa6, 0x34, 0x07, 0x6a,
	0x26, 0x93, 0x32, 0xc5, 0xd7, 0x90, 0xe6, 0x63, 0x40, 0x13, 0x39, 0xd6, 0xb5, 0x7a, 0xfb, 0x78,
	0x21, 0x11, 0x19, 0x32, 0x5c, 0xff, 0x2e, 0x2f, 0xa1, 0x0d, 0xc8, 0x75, 0x1a, 0x89, 0xb8, 0x52,
	0x45, 0x90, 0xa7, 0xdb, 0x2e, 0xf4, 0x49, 0x6c, 0x89, 0x26, 0x2b, 0xfe, 0x9e, 0x82, 0x34, 0x9f,
	0x02, 0xa4, 0xc3, 0xfa, 0x75, 0xe0, 0x63, 0xcf, 0x12, 0x83, 0x23, 0xdd, 0x72, 0xcd, 0xef, 0x29,
	0x90, 0xfb, 0x1d, 0xdf, 0x31, 0xe5, 0xeb, 0xa9, 0x88, 0x1a, 0xb4, 0x8d, 0xba, 0xee, 0x6c, 0xa4,
	0x0c, 0x8b, 0x74, 0x53, 0x1b, 0x71, 0xec, 0x24, 0xd8, 0x66, 0x38, 0xa7, 0x41, 0x0a, 0x64, 0xc4,
	0xfa, 0x15, 0x2f, 0x93, 0x88, 0xa8, 0x0a, 0x39, 0xe2, 0x3b, 0x83, 0xc0, 0xf5, 0xe3, 0x48, 0xac,
	0xcb, 0x27, 0xb7, 0x8c, 0xb9, 0x9e, 0x60, 0xcd, 0xa9, 0x1b, 0x7a, 0x03, 0x32, 0x4f, 0xd2, 0xc2,
	0xc3, 0xf8, 0x92, 0xed, 0x4f, 0xb9, 0xf2, 0xe8, 0x96, 0x28, 0xda, 0x30, 0xbe, 0x34, 0xa1, 0x3f,
	0xf9, 0xa6, 0xdd, 0x29, 0x12, 0xb2, 0x5c, 0xff, 0x22, 0x60, 0x7b, 0xf6, 0xa6, 0x6b, 0x3b, 0xe3,
	0x40, 0xc3, 0xbf, 0x08, 0x4c, 0x79, 0x34, 0x15, 0xd0, 0x77, 0x80, 0x66, 0xa8, 0x28, 0x99, 0x98,
	0x34, 0x0b, 0x55, 0xba, 0x25, 0x9b, 0x93, 0xa9, 0x93, 0x98, 0x9d, 0xbb, 0xfd, 0x45, 0x55, 0x75,
	0x63, 0x52, 0x63, 0x3c, 0x1e, 0x90, 0x62, 0x15, 0x60, 0x5a, 0x0a, 0x3a, 0x80, 0xfb, 0x82, 0x5d,
	0x2d, 0x1b, 0x5b, 0x36, 0x09, 0x63, 0xf7, 0xc2, 0xb5, 0x71, 0x4c, 0xc4, 0x6c, 0x14, 0x84, 0xb5,
	0x86, 0x6b, 0x53, 0x5b, 0xf1, 0x7b, 0x09, 0xe4, 0x99, 0x1e, 0x40, 0xdb, 0x90, 0xb9, 0x0e, 0x7c,
	0x62, 0x4d, 0xc8, 0x2e, 0x4d, 0x45, 0xc3, 0x41, 0x2a, 0xdc, 0xe3, 0x3d, 0x87, 0x3d, 0x6b, 0x66,
	0xed, 0xf1, 0x97, 0xbc, 0x9b, 0x98, 0xce, 0x26, 0x9b, 0x4e, 0x85, 0x7b, 0xe4, 0xc3, 0xa7, 0xf8,
	0x14, 0xc7, 0x27, 0xa6, 0x09, 0xbe, 0xf8, 0xa3, 0x04, 0x9b, 0xf3, 0x2d, 0x44, 0x39, 0x96, 0xb7,
	0xd0, 0x34, 0x9b, 0x2c, 0x57, 0xfc, 0x03, 0xf9, 0x0c, 0x61, 0x6b, 0xa1, 0xdb, 0xd0, 0x33, 0x28,
	0xcc, 0x1e, 0x99, 0xf4, 0x9e, 0x48, 0x0d, 0x4d, 0xcf, 0x4c, 0x5c, 0xa8, 0xc7, 0xec, 0xa1, 0x13,
	0x0f, 0x9e, 0x25, 0x9a, 0x9e, 0x9a, 0x78, 0x14, 0x7f, 0x93, 0x00, 0x7d, 0xca, 0x44, 0x94, 0x09,
	0x92, 0xc7, 0x65, 0xac, 0x63, 0xbb, 0x4e, 0x68, 0x9d, 0x7b, 0x81, 0xdd, 0x5b, 0x78, 0x5d, 0x4a,
	0x36, 0x35, 0xd7, 0x09, 0xab, 0xd4, 0x86, 0xea, 0xa0, 0x30, 0x02, 0x99, 0xfa, 0xf4, 0x71, 0xd4,
	0xb3, 0x22, 0xf7, 0x9a, 0xb0, 0xf6, 0x4e, 0x55, 0x0b, 0x7f, 0xfc, 0xb2, 0x9f, 0x7f, 0x56, 0xaa,
	0x1c, 0x94, 0x2a, 0x2f, 0x4a, 0x95, 0xcf, 0x4b, 0x95, 0x2f, 0x4a, 0x95, 0x43, 0xce, 0x2b, 0x49,
	0xa8, 0x13, 0x1c, 0xf5, 0x5a, 0xee, 0x35, 0xa1, 0x49, 0x24, 0x4c, 0xb4, 0x98, 0x04, 0x2f, 0xa8,
	0x20, 0xcc, 0x73, 0x49, 0x14, 0x7f, 0x92, 0x60, 0xfb, 0x86, 0x26, 0x47, 0x8f, 0x61, 0x1d, 0x0f,
	0xe3, 0xc0, 0x1a, 0x0e, 0xba, 0x21, 0x76, 0x78, 0xab, 0x66, 0x4d, 0x99, 0xea, 0x3a, 0x5c, 0x85,
	0x3a, 0xf3, 0x13, 0x75, 0xe5, 0xfa, 0x4e, 0x70, 0xc5, 0x0e, 0x94, 0x2b, 0xff, 0xbd, 0x61, 0xa2,
	0x26, 0xf0, 0x6f, 0x19, 0x7a, 0x6e, 0x96, 0xb8, 0xaa, 0xf8, 0x51, 0x82, 0x8d, 0x39, 0xb2, 0x42,
	0x6f, 0x21, 0x3b, 0x61, 0x26, 0x89, 0xf1, 0xe5, 0x67, 0x7f, 0x4d, 0x71, 0xea, 0x84, 0xa4, 0x26,
	0xce, 0xc5, 0x67, 0x90, 0x4d, 0xb4, 0x48, 0x81, 0x02, 0xe3, 0x93, 0x23, 0xdd, 0x5c, 0x58, 0xf0,
	0x00, 0xe9, 0x9a, 0x56, 0x37, 0x6a, 0xa7, 0x79, 0xa9, 0xf8, 0x04, 0xe4, 0x19, 0xbe, 0x43, 0xff,
	0x82, 0x74, 0x8f, 0x8c, 0xa7, 0x5d, 0xbf, 0xd6, 0x23, 0x63, 0xc3, 0xf9, 0x7f, 0x87, 0x4e, 0xc8,
	0x1c, 0x37, 0x3f, 0x82, 0x07, 0xa6, 0x5e, 0xd7, 0xb5, 0x96, 0x6e, 0xd5, 0x8e, 0xb5, 0x46, 0x43,
	0xaf, 0x2f, 0x1c, 0x92, 0x83, 0x35, 0x53, 0x6b, 0x1a, 0x47, 0x82, 0xc7, 0xf4, 0xb7, 0x9d, 0xba,
	0x66, 0xe6, 0x57, 0xe8, 0xe1, 0xad, 0xb6, 0x56, 0xad, 0xeb, 0xf9, 0x54, 0xf5, 0x0c, 0xb6, 0xe7,
	0xca, 0xc4, 0x03, 0x57, 0x94, 0xfa, 0xfe, 0x55, 0xd7, 0x8d, 0x2f, 0x87, 0xe7, 0xaa, 0x1d, 0xf4,
	0xcb, 0x1c, 0xf3, 0x94, 0xff, 0x2b, 0x77, 0x83, 0xa7, 0x5d, 0xe2, 0xb3, 0x5f, 0xd9, 0xf2, 0x92,
	0xff, 0xec, 0x57, 0xbd, 0xc3, 0xe8, 0x3c, 0xcd, 0xcc, 0xcf, 0xff, 0x0c, 0x00, 0x00, 0xff, 0xff,
	0x76, 0xd5, 0x67, 0xed, 0x09, 0x0c, 0x00, 0x00,
}
