// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/k8s/v1/node_group.proto

package k8s

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type NodeGroup_Status int32

const (
	NodeGroup_STATUS_UNSPECIFIED NodeGroup_Status = 0
	// Node group is waiting for resources to be allocated.
	NodeGroup_PROVISIONING NodeGroup_Status = 1
	// Node group is running.
	NodeGroup_RUNNING NodeGroup_Status = 2
	// Node group is waiting for some work to be done, such as upgrading node software.
	NodeGroup_RECONCILING NodeGroup_Status = 3
	// Node group is being stopped.
	NodeGroup_STOPPING NodeGroup_Status = 4
	// Node group stopped.
	NodeGroup_STOPPED NodeGroup_Status = 5
	// Node group is being deleted.
	NodeGroup_DELETING NodeGroup_Status = 6
	// Node group is being started.
	NodeGroup_STARTING NodeGroup_Status = 7
)

var NodeGroup_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RECONCILING",
	4: "STOPPING",
	5: "STOPPED",
	6: "DELETING",
	7: "STARTING",
}

var NodeGroup_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RECONCILING":        3,
	"STOPPING":           4,
	"STOPPED":            5,
	"DELETING":           6,
	"STARTING":           7,
}

func (x NodeGroup_Status) String() string {
	return proto.EnumName(NodeGroup_Status_name, int32(x))
}

func (NodeGroup_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{0, 0}
}

type NodeGroup struct {
	// ID of the node group.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the cluster that the node group belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the node group.
	// The name is unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the node group. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs. Мaximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Status of the node group.
	Status NodeGroup_Status `protobuf:"varint,7,opt,name=status,proto3,enum=yandex.cloud.k8s.v1.NodeGroup_Status" json:"status,omitempty"`
	// Node template that specifies parameters of the compute instances for the node group.
	NodeTemplate *NodeTemplate `protobuf:"bytes,8,opt,name=node_template,json=nodeTemplate,proto3" json:"node_template,omitempty"`
	// Scale policy of the node group.  For more information, see [Scaling policy](/docs/compute/concepts/instance-groups/policies#scale-policy).
	ScalePolicy *ScalePolicy `protobuf:"bytes,9,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	// Allocation policy by which resources for node group are allocated to zones and regions.
	AllocationPolicy *NodeGroupAllocationPolicy `protobuf:"bytes,10,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Deploy policy according to which the updates are rolled out.
	DeployPolicy *DeployPolicy `protobuf:"bytes,18,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// ID of the managed instance group associated with this node group.
	InstanceGroupId string `protobuf:"bytes,11,opt,name=instance_group_id,json=instanceGroupId,proto3" json:"instance_group_id,omitempty"`
	// Version of Kubernetes components that runs on the nodes.
	// Deprecated. Use version_info.current_version.
	NodeVersion string `protobuf:"bytes,12,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
	// Detailed information about the Kubernetes version that is running on the node.
	VersionInfo *VersionInfo `protobuf:"bytes,13,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// Maintenance policy of the node group.
	MaintenancePolicy *NodeGroupMaintenancePolicy `protobuf:"bytes,14,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Support for unsafe sysctl parameters. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster/).
	AllowedUnsafeSysctls []string `protobuf:"bytes,15,rep,name=allowed_unsafe_sysctls,json=allowedUnsafeSysctls,proto3" json:"allowed_unsafe_sysctls,omitempty"`
	// Taints that are applied to the nodes of the node group at creation time.
	NodeTaints []*Taint `protobuf:"bytes,16,rep,name=node_taints,json=nodeTaints,proto3" json:"node_taints,omitempty"`
	// Labels that are assigned to the nodes of the node group at creation time.
	NodeLabels           map[string]string `protobuf:"bytes,17,rep,name=node_labels,json=nodeLabels,proto3" json:"node_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *NodeGroup) Reset()         { *m = NodeGroup{} }
func (m *NodeGroup) String() string { return proto.CompactTextString(m) }
func (*NodeGroup) ProtoMessage()    {}
func (*NodeGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{0}
}

func (m *NodeGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGroup.Unmarshal(m, b)
}
func (m *NodeGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGroup.Marshal(b, m, deterministic)
}
func (m *NodeGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGroup.Merge(m, src)
}
func (m *NodeGroup) XXX_Size() int {
	return xxx_messageInfo_NodeGroup.Size(m)
}
func (m *NodeGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGroup.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGroup proto.InternalMessageInfo

func (m *NodeGroup) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NodeGroup) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *NodeGroup) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *NodeGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NodeGroup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *NodeGroup) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NodeGroup) GetStatus() NodeGroup_Status {
	if m != nil {
		return m.Status
	}
	return NodeGroup_STATUS_UNSPECIFIED
}

func (m *NodeGroup) GetNodeTemplate() *NodeTemplate {
	if m != nil {
		return m.NodeTemplate
	}
	return nil
}

func (m *NodeGroup) GetScalePolicy() *ScalePolicy {
	if m != nil {
		return m.ScalePolicy
	}
	return nil
}

func (m *NodeGroup) GetAllocationPolicy() *NodeGroupAllocationPolicy {
	if m != nil {
		return m.AllocationPolicy
	}
	return nil
}

func (m *NodeGroup) GetDeployPolicy() *DeployPolicy {
	if m != nil {
		return m.DeployPolicy
	}
	return nil
}

func (m *NodeGroup) GetInstanceGroupId() string {
	if m != nil {
		return m.InstanceGroupId
	}
	return ""
}

func (m *NodeGroup) GetNodeVersion() string {
	if m != nil {
		return m.NodeVersion
	}
	return ""
}

func (m *NodeGroup) GetVersionInfo() *VersionInfo {
	if m != nil {
		return m.VersionInfo
	}
	return nil
}

func (m *NodeGroup) GetMaintenancePolicy() *NodeGroupMaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *NodeGroup) GetAllowedUnsafeSysctls() []string {
	if m != nil {
		return m.AllowedUnsafeSysctls
	}
	return nil
}

func (m *NodeGroup) GetNodeTaints() []*Taint {
	if m != nil {
		return m.NodeTaints
	}
	return nil
}

func (m *NodeGroup) GetNodeLabels() map[string]string {
	if m != nil {
		return m.NodeLabels
	}
	return nil
}

type ScalePolicy struct {
	// Types that are valid to be assigned to ScaleType:
	//	*ScalePolicy_FixedScale_
	//	*ScalePolicy_AutoScale_
	ScaleType            isScalePolicy_ScaleType `protobuf_oneof:"scale_type"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ScalePolicy) Reset()         { *m = ScalePolicy{} }
func (m *ScalePolicy) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy) ProtoMessage()    {}
func (*ScalePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{1}
}

func (m *ScalePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy.Unmarshal(m, b)
}
func (m *ScalePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy.Marshal(b, m, deterministic)
}
func (m *ScalePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy.Merge(m, src)
}
func (m *ScalePolicy) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy.Size(m)
}
func (m *ScalePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy proto.InternalMessageInfo

type isScalePolicy_ScaleType interface {
	isScalePolicy_ScaleType()
}

type ScalePolicy_FixedScale_ struct {
	FixedScale *ScalePolicy_FixedScale `protobuf:"bytes,1,opt,name=fixed_scale,json=fixedScale,proto3,oneof"`
}

type ScalePolicy_AutoScale_ struct {
	AutoScale *ScalePolicy_AutoScale `protobuf:"bytes,2,opt,name=auto_scale,json=autoScale,proto3,oneof"`
}

func (*ScalePolicy_FixedScale_) isScalePolicy_ScaleType() {}

func (*ScalePolicy_AutoScale_) isScalePolicy_ScaleType() {}

func (m *ScalePolicy) GetScaleType() isScalePolicy_ScaleType {
	if m != nil {
		return m.ScaleType
	}
	return nil
}

func (m *ScalePolicy) GetFixedScale() *ScalePolicy_FixedScale {
	if x, ok := m.GetScaleType().(*ScalePolicy_FixedScale_); ok {
		return x.FixedScale
	}
	return nil
}

func (m *ScalePolicy) GetAutoScale() *ScalePolicy_AutoScale {
	if x, ok := m.GetScaleType().(*ScalePolicy_AutoScale_); ok {
		return x.AutoScale
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScalePolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScalePolicy_FixedScale_)(nil),
		(*ScalePolicy_AutoScale_)(nil),
	}
}

type ScalePolicy_FixedScale struct {
	// Number of nodes in the node group.
	Size                 int64    `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalePolicy_FixedScale) Reset()         { *m = ScalePolicy_FixedScale{} }
func (m *ScalePolicy_FixedScale) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_FixedScale) ProtoMessage()    {}
func (*ScalePolicy_FixedScale) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{1, 0}
}

func (m *ScalePolicy_FixedScale) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_FixedScale.Unmarshal(m, b)
}
func (m *ScalePolicy_FixedScale) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_FixedScale.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_FixedScale) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_FixedScale.Merge(m, src)
}
func (m *ScalePolicy_FixedScale) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_FixedScale.Size(m)
}
func (m *ScalePolicy_FixedScale) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_FixedScale.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_FixedScale proto.InternalMessageInfo

func (m *ScalePolicy_FixedScale) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type ScalePolicy_AutoScale struct {
	// Minimum number of nodes in the node group.
	MinSize int64 `protobuf:"varint,1,opt,name=min_size,json=minSize,proto3" json:"min_size,omitempty"`
	// Maximum number of nodes in the node group.
	MaxSize int64 `protobuf:"varint,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Initial number of nodes in the node group.
	InitialSize          int64    `protobuf:"varint,3,opt,name=initial_size,json=initialSize,proto3" json:"initial_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalePolicy_AutoScale) Reset()         { *m = ScalePolicy_AutoScale{} }
func (m *ScalePolicy_AutoScale) String() string { return proto.CompactTextString(m) }
func (*ScalePolicy_AutoScale) ProtoMessage()    {}
func (*ScalePolicy_AutoScale) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{1, 1}
}

func (m *ScalePolicy_AutoScale) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalePolicy_AutoScale.Unmarshal(m, b)
}
func (m *ScalePolicy_AutoScale) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalePolicy_AutoScale.Marshal(b, m, deterministic)
}
func (m *ScalePolicy_AutoScale) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalePolicy_AutoScale.Merge(m, src)
}
func (m *ScalePolicy_AutoScale) XXX_Size() int {
	return xxx_messageInfo_ScalePolicy_AutoScale.Size(m)
}
func (m *ScalePolicy_AutoScale) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalePolicy_AutoScale.DiscardUnknown(m)
}

var xxx_messageInfo_ScalePolicy_AutoScale proto.InternalMessageInfo

func (m *ScalePolicy_AutoScale) GetMinSize() int64 {
	if m != nil {
		return m.MinSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetMaxSize() int64 {
	if m != nil {
		return m.MaxSize
	}
	return 0
}

func (m *ScalePolicy_AutoScale) GetInitialSize() int64 {
	if m != nil {
		return m.InitialSize
	}
	return 0
}

type NodeGroupAllocationPolicy struct {
	// List of locations where resources for the node group will be allocated.
	Locations            []*NodeGroupLocation `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *NodeGroupAllocationPolicy) Reset()         { *m = NodeGroupAllocationPolicy{} }
func (m *NodeGroupAllocationPolicy) String() string { return proto.CompactTextString(m) }
func (*NodeGroupAllocationPolicy) ProtoMessage()    {}
func (*NodeGroupAllocationPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{2}
}

func (m *NodeGroupAllocationPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGroupAllocationPolicy.Unmarshal(m, b)
}
func (m *NodeGroupAllocationPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGroupAllocationPolicy.Marshal(b, m, deterministic)
}
func (m *NodeGroupAllocationPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGroupAllocationPolicy.Merge(m, src)
}
func (m *NodeGroupAllocationPolicy) XXX_Size() int {
	return xxx_messageInfo_NodeGroupAllocationPolicy.Size(m)
}
func (m *NodeGroupAllocationPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGroupAllocationPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGroupAllocationPolicy proto.InternalMessageInfo

func (m *NodeGroupAllocationPolicy) GetLocations() []*NodeGroupLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

type NodeGroupLocation struct {
	// ID of the availability zone where the nodes may reside.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet. If a network chosen for the Kubernetes cluster has only one subnet in the specified zone, subnet ID may be omitted.
	SubnetId             string   `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeGroupLocation) Reset()         { *m = NodeGroupLocation{} }
func (m *NodeGroupLocation) String() string { return proto.CompactTextString(m) }
func (*NodeGroupLocation) ProtoMessage()    {}
func (*NodeGroupLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{3}
}

func (m *NodeGroupLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGroupLocation.Unmarshal(m, b)
}
func (m *NodeGroupLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGroupLocation.Marshal(b, m, deterministic)
}
func (m *NodeGroupLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGroupLocation.Merge(m, src)
}
func (m *NodeGroupLocation) XXX_Size() int {
	return xxx_messageInfo_NodeGroupLocation.Size(m)
}
func (m *NodeGroupLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGroupLocation.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGroupLocation proto.InternalMessageInfo

func (m *NodeGroupLocation) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *NodeGroupLocation) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

type NodeGroupMaintenancePolicy struct {
	// If set to true, automatic updates are installed in the specified period of time with no interaction from the user.
	// If set to false, automatic upgrades are disabled.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade,proto3" json:"auto_upgrade,omitempty"`
	// If set to true, automatic repairs are enabled. Default value is false.
	AutoRepair bool `protobuf:"varint,2,opt,name=auto_repair,json=autoRepair,proto3" json:"auto_repair,omitempty"`
	// Maintenance window settings. Update will start at the specified time and last no more than the specified duration.
	// The time is set in UTC.
	MaintenanceWindow    *MaintenanceWindow `protobuf:"bytes,3,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *NodeGroupMaintenancePolicy) Reset()         { *m = NodeGroupMaintenancePolicy{} }
func (m *NodeGroupMaintenancePolicy) String() string { return proto.CompactTextString(m) }
func (*NodeGroupMaintenancePolicy) ProtoMessage()    {}
func (*NodeGroupMaintenancePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{4}
}

func (m *NodeGroupMaintenancePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeGroupMaintenancePolicy.Unmarshal(m, b)
}
func (m *NodeGroupMaintenancePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeGroupMaintenancePolicy.Marshal(b, m, deterministic)
}
func (m *NodeGroupMaintenancePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeGroupMaintenancePolicy.Merge(m, src)
}
func (m *NodeGroupMaintenancePolicy) XXX_Size() int {
	return xxx_messageInfo_NodeGroupMaintenancePolicy.Size(m)
}
func (m *NodeGroupMaintenancePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeGroupMaintenancePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_NodeGroupMaintenancePolicy proto.InternalMessageInfo

func (m *NodeGroupMaintenancePolicy) GetAutoUpgrade() bool {
	if m != nil {
		return m.AutoUpgrade
	}
	return false
}

func (m *NodeGroupMaintenancePolicy) GetAutoRepair() bool {
	if m != nil {
		return m.AutoRepair
	}
	return false
}

func (m *NodeGroupMaintenancePolicy) GetMaintenanceWindow() *MaintenanceWindow {
	if m != nil {
		return m.MaintenanceWindow
	}
	return nil
}

type DeployPolicy struct {
	// The maximum number of running instances that can be taken offline (i.e.,
	// stopped or deleted) at the same time during the update process.
	// If [max_expansion] is not specified or set to zero, [max_unavailable] must
	// be set to a non-zero value.
	MaxUnavailable int64 `protobuf:"varint,1,opt,name=max_unavailable,json=maxUnavailable,proto3" json:"max_unavailable,omitempty"`
	// The maximum number of instances that can be temporarily allocated above
	// the group's target size during the update process.
	// If [max_unavailable] is not specified or set to zero, [max_expansion] must
	// be set to a non-zero value.
	MaxExpansion         int64    `protobuf:"varint,2,opt,name=max_expansion,json=maxExpansion,proto3" json:"max_expansion,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployPolicy) Reset()         { *m = DeployPolicy{} }
func (m *DeployPolicy) String() string { return proto.CompactTextString(m) }
func (*DeployPolicy) ProtoMessage()    {}
func (*DeployPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_d5c271823cf8486a, []int{5}
}

func (m *DeployPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployPolicy.Unmarshal(m, b)
}
func (m *DeployPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployPolicy.Marshal(b, m, deterministic)
}
func (m *DeployPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployPolicy.Merge(m, src)
}
func (m *DeployPolicy) XXX_Size() int {
	return xxx_messageInfo_DeployPolicy.Size(m)
}
func (m *DeployPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_DeployPolicy proto.InternalMessageInfo

func (m *DeployPolicy) GetMaxUnavailable() int64 {
	if m != nil {
		return m.MaxUnavailable
	}
	return 0
}

func (m *DeployPolicy) GetMaxExpansion() int64 {
	if m != nil {
		return m.MaxExpansion
	}
	return 0
}

func init() {
	proto.RegisterEnum("yandex.cloud.k8s.v1.NodeGroup_Status", NodeGroup_Status_name, NodeGroup_Status_value)
	proto.RegisterType((*NodeGroup)(nil), "yandex.cloud.k8s.v1.NodeGroup")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.NodeGroup.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.NodeGroup.NodeLabelsEntry")
	proto.RegisterType((*ScalePolicy)(nil), "yandex.cloud.k8s.v1.ScalePolicy")
	proto.RegisterType((*ScalePolicy_FixedScale)(nil), "yandex.cloud.k8s.v1.ScalePolicy.FixedScale")
	proto.RegisterType((*ScalePolicy_AutoScale)(nil), "yandex.cloud.k8s.v1.ScalePolicy.AutoScale")
	proto.RegisterType((*NodeGroupAllocationPolicy)(nil), "yandex.cloud.k8s.v1.NodeGroupAllocationPolicy")
	proto.RegisterType((*NodeGroupLocation)(nil), "yandex.cloud.k8s.v1.NodeGroupLocation")
	proto.RegisterType((*NodeGroupMaintenancePolicy)(nil), "yandex.cloud.k8s.v1.NodeGroupMaintenancePolicy")
	proto.RegisterType((*DeployPolicy)(nil), "yandex.cloud.k8s.v1.DeployPolicy")
}

func init() {
	proto.RegisterFile("yandex/cloud/k8s/v1/node_group.proto", fileDescriptor_d5c271823cf8486a)
}

var fileDescriptor_d5c271823cf8486a = []byte{
	// 1090 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xcf, 0x6f, 0xe2, 0x46,
	0x14, 0x5e, 0x03, 0x21, 0xf0, 0x4c, 0x12, 0x32, 0x5d, 0x6d, 0x5d, 0xaa, 0x74, 0x09, 0xda, 0xad,
	0xa2, 0x6c, 0x63, 0x42, 0xda, 0x43, 0xb6, 0xd1, 0x1e, 0xf2, 0x83, 0x6c, 0x51, 0x53, 0x88, 0x0c,
	0xa4, 0x52, 0x2b, 0xd5, 0x1a, 0xf0, 0x40, 0x47, 0x31, 0x36, 0xc2, 0x36, 0x81, 0xdc, 0xab, 0xfe,
	0x13, 0xfd, 0x3f, 0x7a, 0x6d, 0x4f, 0xfb, 0xaf, 0xf4, 0xde, 0x5b, 0x4f, 0xd5, 0xbc, 0x19, 0x07,
	0x92, 0x90, 0x44, 0x7b, 0xf3, 0xfb, 0xbe, 0xef, 0x7d, 0x9e, 0x37, 0xf3, 0xe6, 0xd9, 0xf0, 0x6a,
	0x4a, 0x3d, 0x87, 0x4d, 0xca, 0x5d, 0xd7, 0x8f, 0x9c, 0xf2, 0xe5, 0x7e, 0x50, 0x1e, 0x57, 0xca,
	0x9e, 0xef, 0x30, 0xbb, 0x3f, 0xf2, 0xa3, 0xa1, 0x39, 0x1c, 0xf9, 0xa1, 0x4f, 0x3e, 0x91, 0x2a,
	0x13, 0x55, 0xe6, 0xe5, 0x7e, 0x60, 0x8e, 0x2b, 0x85, 0x97, 0x7d, 0xdf, 0xef, 0xbb, 0xac, 0x8c,
	0x92, 0x4e, 0xd4, 0x2b, 0x87, 0x7c, 0xc0, 0x82, 0x90, 0x0e, 0x54, 0x56, 0xe1, 0xf5, 0x22, 0xef,
	0x01, 0xe5, 0x5e, 0xc8, 0x3c, 0xea, 0x75, 0x99, 0x92, 0x7d, 0xf1, 0xd0, 0x12, 0x14, 0xbf, 0xb9,
	0x88, 0x1f, 0xb3, 0x51, 0xc0, 0x7d, 0x4f, 0x49, 0x36, 0x6e, 0x49, 0xc6, 0xd4, 0xe5, 0x0e, 0x0d,
	0x6f, 0xe8, 0xd2, 0x1f, 0x00, 0xd9, 0xba, 0xef, 0xb0, 0xf7, 0xa2, 0x24, 0xb2, 0x0a, 0x09, 0xee,
	0x18, 0x5a, 0x51, 0xdb, 0xca, 0x5a, 0x09, 0xee, 0x90, 0x0d, 0x80, 0xae, 0x1b, 0x05, 0x21, 0x1b,
	0xd9, 0xdc, 0x31, 0x12, 0x88, 0x67, 0x15, 0x52, 0x73, 0xc8, 0x5b, 0x80, 0xee, 0x88, 0xd1, 0x90,
	0x39, 0x36, 0x0d, 0x8d, 0x64, 0x51, 0xdb, 0xd2, 0xf7, 0x0a, 0xa6, 0xac, 0xdd, 0x8c, 0x6b, 0x37,
	0x5b, 0x71, 0xed, 0x56, 0x56, 0xa9, 0x0f, 0x43, 0x42, 0x20, 0xe5, 0xd1, 0x01, 0x33, 0x52, 0xe8,
	0x89, 0xcf, 0xa4, 0x08, 0xba, 0xc3, 0x82, 0xee, 0x88, 0x0f, 0xc5, 0x02, 0x8d, 0x25, 0xa4, 0xe6,
	0x21, 0x72, 0x04, 0x69, 0x97, 0x76, 0x98, 0x1b, 0x18, 0xe9, 0x62, 0x72, 0x4b, 0xdf, 0xdb, 0x36,
	0x17, 0xec, 0xbe, 0x79, 0x53, 0x8f, 0x79, 0x86, 0xe2, 0xaa, 0x17, 0x8e, 0xa6, 0x96, 0xca, 0x24,
	0xef, 0x20, 0x1d, 0x84, 0x34, 0x8c, 0x02, 0x63, 0xb9, 0xa8, 0x6d, 0xad, 0xee, 0xbd, 0x7e, 0xc2,
	0xa3, 0x89, 0x62, 0x4b, 0x25, 0x91, 0x53, 0x58, 0xc1, 0x1e, 0x08, 0xd9, 0x60, 0xe8, 0xd2, 0x90,
	0x19, 0x19, 0x2c, 0x7b, 0xf3, 0x41, 0x97, 0x96, 0x12, 0x5a, 0x39, 0x6f, 0x2e, 0x22, 0xc7, 0x90,
	0x0b, 0xba, 0xd4, 0x65, 0xf6, 0xd0, 0x77, 0x79, 0x77, 0x6a, 0x64, 0xd1, 0xa6, 0xb8, 0xd0, 0xa6,
	0x29, 0x84, 0xe7, 0xa8, 0xb3, 0xf4, 0x60, 0x16, 0x90, 0x9f, 0x61, 0x9d, 0xba, 0xae, 0xdf, 0xc5,
	0x13, 0x8d, 0x9d, 0x00, 0x9d, 0xcc, 0xc7, 0xcb, 0x3a, 0xbc, 0x49, 0x53, 0xbe, 0x79, 0x7a, 0x07,
	0x11, 0x95, 0x3a, 0x6c, 0xe8, 0xfa, 0xd3, 0xd8, 0x98, 0x3c, 0x52, 0xe9, 0x09, 0x2a, 0x95, 0x57,
	0xce, 0x99, 0x8b, 0xc8, 0x36, 0xac, 0x73, 0x2f, 0x08, 0x45, 0x5b, 0xcb, 0x9b, 0x23, 0x7a, 0x49,
	0xc7, 0xc3, 0x5d, 0x8b, 0x09, 0x5c, 0x53, 0xcd, 0x21, 0x9b, 0x80, 0xbb, 0x64, 0xab, 0x1e, 0x36,
	0x72, 0xb2, 0x07, 0x04, 0x76, 0x21, 0x21, 0xb1, 0x71, 0x8a, 0xb5, 0xb9, 0xd7, 0xf3, 0x8d, 0x95,
	0x47, 0x36, 0x4e, 0xe5, 0xd4, 0xbc, 0x9e, 0x6f, 0xe9, 0xe3, 0x59, 0x40, 0x7e, 0x01, 0x32, 0x77,
	0xdb, 0xe2, 0x02, 0x57, 0xd1, 0xaa, 0xfc, 0xf8, 0xce, 0xfd, 0x30, 0xcb, 0x53, 0xe5, 0xae, 0x0f,
	0xee, 0x42, 0xe4, 0x1b, 0x78, 0x21, 0xf6, 0xf3, 0x8a, 0x39, 0x76, 0xe4, 0x05, 0xb4, 0xc7, 0xec,
	0x60, 0x1a, 0x74, 0x43, 0x37, 0x30, 0xd6, 0x8a, 0xc9, 0xad, 0xac, 0xf5, 0x5c, 0xb1, 0x6d, 0x24,
	0x9b, 0x92, 0x23, 0x07, 0xa0, 0xcb, 0xde, 0x12, 0x7e, 0x81, 0x91, 0xc7, 0x1e, 0x2f, 0x2c, 0x5c,
	0x4e, 0x4b, 0x48, 0x2c, 0xc0, 0x96, 0x42, 0x35, 0x69, 0xa8, 0x64, 0x75, 0x41, 0xd6, 0x31, 0xf9,
	0x89, 0x2e, 0xc0, 0xa7, 0xf9, 0x4b, 0x82, 0x86, 0x12, 0x28, 0xbc, 0x05, 0x7d, 0x8e, 0x22, 0x79,
	0x48, 0x5e, 0xb2, 0xa9, 0x1a, 0x0e, 0xe2, 0x91, 0x3c, 0x87, 0xa5, 0x31, 0x75, 0x23, 0xa6, 0x06,
	0x83, 0x0c, 0xbe, 0x4d, 0xec, 0x6b, 0x85, 0x77, 0xb0, 0x76, 0xc7, 0xf9, 0x63, 0xd2, 0x4b, 0xbf,
	0x6b, 0x90, 0x96, 0xd7, 0x8e, 0xbc, 0x00, 0xd2, 0x6c, 0x1d, 0xb6, 0xda, 0x4d, 0xbb, 0x5d, 0x6f,
	0x9e, 0x57, 0x8f, 0x6b, 0xa7, 0xb5, 0xea, 0x49, 0xfe, 0x19, 0xc9, 0x43, 0xee, 0xdc, 0x6a, 0x5c,
	0xd4, 0x9a, 0xb5, 0x46, 0xbd, 0x56, 0x7f, 0x9f, 0xd7, 0x88, 0x0e, 0xcb, 0x56, 0xbb, 0x8e, 0x41,
	0x82, 0xac, 0x81, 0x6e, 0x55, 0x8f, 0x1b, 0xf5, 0xe3, 0xda, 0x99, 0x00, 0x92, 0x24, 0x07, 0x99,
	0x66, 0xab, 0x71, 0x7e, 0x2e, 0xa2, 0x94, 0xd0, 0x62, 0x54, 0x3d, 0xc9, 0x2f, 0x09, 0xea, 0xa4,
	0x7a, 0x56, 0x6d, 0x09, 0x2a, 0x2d, 0x85, 0x87, 0x16, 0x46, 0xcb, 0xa5, 0x7f, 0x13, 0xa0, 0xcf,
	0xdd, 0x3e, 0x52, 0x07, 0xbd, 0xc7, 0x27, 0xcc, 0xb1, 0xf1, 0x16, 0x62, 0x35, 0xfa, 0xde, 0x9b,
	0xa7, 0x2e, 0xad, 0x79, 0x2a, 0x72, 0x10, 0xf8, 0xee, 0x99, 0x05, 0xbd, 0x9b, 0x88, 0x7c, 0x0f,
	0x40, 0xa3, 0xd0, 0x57, 0x76, 0x09, 0xb4, 0xdb, 0x7e, 0xd2, 0xee, 0x30, 0x0a, 0xfd, 0xd8, 0x2d,
	0x4b, 0xe3, 0xa0, 0xf0, 0x06, 0x60, 0xf6, 0x22, 0xb2, 0x01, 0xa9, 0x80, 0x5f, 0xcb, 0x35, 0x26,
	0x8f, 0xb2, 0xff, 0x7d, 0xa8, 0x2c, 0xed, 0xee, 0x54, 0x76, 0x77, 0x2d, 0x84, 0x0b, 0xbf, 0x69,
	0x90, 0xbd, 0xf1, 0x21, 0xaf, 0x20, 0x33, 0xe0, 0x9e, 0xbd, 0x38, 0x61, 0x79, 0xc0, 0xbd, 0x26,
	0xbf, 0x96, 0x2a, 0x3a, 0x91, 0xaa, 0xc4, 0x7d, 0x15, 0x9d, 0xa0, 0xea, 0x2b, 0xc8, 0x71, 0x8f,
	0x87, 0x9c, 0xba, 0x52, 0x99, 0xbc, 0xab, 0xd4, 0x15, 0x2d, 0xd4, 0x47, 0x04, 0x40, 0xce, 0xc1,
	0x70, 0x3a, 0x64, 0x24, 0xf5, 0xd7, 0xdf, 0x15, 0xad, 0x44, 0xe1, 0xb3, 0x07, 0x07, 0x15, 0x39,
	0x81, 0x6c, 0x8c, 0x04, 0x86, 0x86, 0x5d, 0xfe, 0xe5, 0xe3, 0x5d, 0x7e, 0xa6, 0xe4, 0xd6, 0x2c,
	0xb1, 0xd4, 0x80, 0xf5, 0x7b, 0x3c, 0xd9, 0x80, 0xe5, 0x6b, 0xdf, 0x63, 0x76, 0xfc, 0x0d, 0x3c,
	0x4a, 0xfd, 0xf3, 0xa1, 0xa2, 0x59, 0x69, 0x01, 0xd6, 0x1c, 0xf2, 0x39, 0x64, 0x83, 0xa8, 0xe3,
	0xb1, 0x70, 0xf6, 0x31, 0xcc, 0x48, 0xa0, 0xe6, 0x94, 0xfe, 0xd4, 0xa0, 0xf0, 0xf0, 0x8c, 0x10,
	0x83, 0x0d, 0x0f, 0x3a, 0x1a, 0xf6, 0x47, 0xd4, 0x91, 0x9b, 0x9c, 0xb1, 0x74, 0x81, 0xb5, 0x25,
	0x44, 0x5e, 0x02, 0x86, 0xf6, 0x88, 0x0d, 0x29, 0x1f, 0xe1, 0x0b, 0x32, 0x16, 0xb6, 0x87, 0x85,
	0x08, 0x69, 0xdf, 0x1e, 0x5a, 0x57, 0xdc, 0x73, 0xfc, 0x2b, 0xf5, 0xd9, 0x5d, 0xbc, 0x05, 0x73,
	0xeb, 0xf8, 0x11, 0xd5, 0xb7, 0x66, 0x95, 0x84, 0x4a, 0x23, 0xc8, 0xcd, 0x4f, 0x6f, 0xb2, 0x07,
	0x6b, 0xe2, 0x94, 0x23, 0x8f, 0x8e, 0x29, 0x77, 0x69, 0xc7, 0x5d, 0xd0, 0x12, 0xab, 0x03, 0x3a,
	0x69, 0xcf, 0x04, 0xc4, 0x84, 0x15, 0x91, 0xc3, 0x26, 0x43, 0xea, 0xe1, 0xe0, 0xbe, 0xd7, 0x1e,
	0xb9, 0x01, 0x9d, 0x54, 0x63, 0xfa, 0xe8, 0x02, 0x3e, 0xbd, 0xb5, 0x5e, 0x3a, 0xe4, 0x6a, 0xcd,
	0x3f, 0x1d, 0xf4, 0x79, 0xf8, 0x6b, 0xd4, 0x31, 0xbb, 0xfe, 0xa0, 0x2c, 0x35, 0x3b, 0xf2, 0xdf,
	0xa5, 0xef, 0xef, 0xf4, 0x99, 0x87, 0xbf, 0x15, 0xe5, 0x05, 0xff, 0x3d, 0x07, 0x97, 0xfb, 0x41,
	0x27, 0x8d, 0xf4, 0xd7, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x73, 0xad, 0xaf, 0x17, 0xbc, 0x09,
	0x00, 0x00,
}
