// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/k8s/v1/node_group_service.proto

package k8s

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetNodeGroupRequest struct {
	// ID of the node group to return.
	// To get the node group ID use a [NodeGroupService.List] request.
	NodeGroupId          string   `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNodeGroupRequest) Reset()         { *m = GetNodeGroupRequest{} }
func (m *GetNodeGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetNodeGroupRequest) ProtoMessage()    {}
func (*GetNodeGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{0}
}

func (m *GetNodeGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNodeGroupRequest.Unmarshal(m, b)
}
func (m *GetNodeGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNodeGroupRequest.Marshal(b, m, deterministic)
}
func (m *GetNodeGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNodeGroupRequest.Merge(m, src)
}
func (m *GetNodeGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetNodeGroupRequest.Size(m)
}
func (m *GetNodeGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNodeGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNodeGroupRequest proto.InternalMessageInfo

func (m *GetNodeGroupRequest) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

type ListNodeGroupsRequest struct {
	// ID of the folder to list node groups in.
	// To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListNodeGroupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListNodeGroupsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on [NodeGroup.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 1-61 characters long and match the regular expression `|[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodeGroupsRequest) Reset()         { *m = ListNodeGroupsRequest{} }
func (m *ListNodeGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNodeGroupsRequest) ProtoMessage()    {}
func (*ListNodeGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{1}
}

func (m *ListNodeGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodeGroupsRequest.Unmarshal(m, b)
}
func (m *ListNodeGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodeGroupsRequest.Marshal(b, m, deterministic)
}
func (m *ListNodeGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodeGroupsRequest.Merge(m, src)
}
func (m *ListNodeGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNodeGroupsRequest.Size(m)
}
func (m *ListNodeGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodeGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodeGroupsRequest proto.InternalMessageInfo

func (m *ListNodeGroupsRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListNodeGroupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNodeGroupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListNodeGroupsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListNodeGroupsResponse struct {
	// List of node groups.
	NodeGroups []*NodeGroup `protobuf:"bytes,1,rep,name=node_groups,json=nodeGroups,proto3" json:"node_groups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNodeGroupsRequest.page_size], use
	// the `next_page_token` as the value
	// for the [ListNodeGroupsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodeGroupsResponse) Reset()         { *m = ListNodeGroupsResponse{} }
func (m *ListNodeGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNodeGroupsResponse) ProtoMessage()    {}
func (*ListNodeGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{2}
}

func (m *ListNodeGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodeGroupsResponse.Unmarshal(m, b)
}
func (m *ListNodeGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodeGroupsResponse.Marshal(b, m, deterministic)
}
func (m *ListNodeGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodeGroupsResponse.Merge(m, src)
}
func (m *ListNodeGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNodeGroupsResponse.Size(m)
}
func (m *ListNodeGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodeGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodeGroupsResponse proto.InternalMessageInfo

func (m *ListNodeGroupsResponse) GetNodeGroups() []*NodeGroup {
	if m != nil {
		return m.NodeGroups
	}
	return nil
}

func (m *ListNodeGroupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListNodeGroupNodesRequest struct {
	// ID of the node group to list.
	// To get the node group ID use a [NodeGroupService.List] request.
	NodeGroupId string `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListNodeGroupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListNodeGroupNodesResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodeGroupNodesRequest) Reset()         { *m = ListNodeGroupNodesRequest{} }
func (m *ListNodeGroupNodesRequest) String() string { return proto.CompactTextString(m) }
func (*ListNodeGroupNodesRequest) ProtoMessage()    {}
func (*ListNodeGroupNodesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{3}
}

func (m *ListNodeGroupNodesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodeGroupNodesRequest.Unmarshal(m, b)
}
func (m *ListNodeGroupNodesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodeGroupNodesRequest.Marshal(b, m, deterministic)
}
func (m *ListNodeGroupNodesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodeGroupNodesRequest.Merge(m, src)
}
func (m *ListNodeGroupNodesRequest) XXX_Size() int {
	return xxx_messageInfo_ListNodeGroupNodesRequest.Size(m)
}
func (m *ListNodeGroupNodesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodeGroupNodesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodeGroupNodesRequest proto.InternalMessageInfo

func (m *ListNodeGroupNodesRequest) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

func (m *ListNodeGroupNodesRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNodeGroupNodesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListNodeGroupNodesResponse struct {
	// List of nodes.
	Nodes []*Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNodeGroupNodesRequest.page_size], use
	// the `next_page_token` as the value
	// for the [ListNodeGroupNodesRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodeGroupNodesResponse) Reset()         { *m = ListNodeGroupNodesResponse{} }
func (m *ListNodeGroupNodesResponse) String() string { return proto.CompactTextString(m) }
func (*ListNodeGroupNodesResponse) ProtoMessage()    {}
func (*ListNodeGroupNodesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{4}
}

func (m *ListNodeGroupNodesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodeGroupNodesResponse.Unmarshal(m, b)
}
func (m *ListNodeGroupNodesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodeGroupNodesResponse.Marshal(b, m, deterministic)
}
func (m *ListNodeGroupNodesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodeGroupNodesResponse.Merge(m, src)
}
func (m *ListNodeGroupNodesResponse) XXX_Size() int {
	return xxx_messageInfo_ListNodeGroupNodesResponse.Size(m)
}
func (m *ListNodeGroupNodesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodeGroupNodesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodeGroupNodesResponse proto.InternalMessageInfo

func (m *ListNodeGroupNodesResponse) GetNodes() []*Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *ListNodeGroupNodesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type DeleteNodeGroupRequest struct {
	// ID of the node group to delete.
	// To get node group ID use a [NodeGroupService.List] request.
	NodeGroupId          string   `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNodeGroupRequest) Reset()         { *m = DeleteNodeGroupRequest{} }
func (m *DeleteNodeGroupRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNodeGroupRequest) ProtoMessage()    {}
func (*DeleteNodeGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{5}
}

func (m *DeleteNodeGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNodeGroupRequest.Unmarshal(m, b)
}
func (m *DeleteNodeGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNodeGroupRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNodeGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNodeGroupRequest.Merge(m, src)
}
func (m *DeleteNodeGroupRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNodeGroupRequest.Size(m)
}
func (m *DeleteNodeGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNodeGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNodeGroupRequest proto.InternalMessageInfo

func (m *DeleteNodeGroupRequest) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

type DeleteNodeGroupMetadata struct {
	// ID of the node group that is being deleted.
	NodeGroupId          string   `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNodeGroupMetadata) Reset()         { *m = DeleteNodeGroupMetadata{} }
func (m *DeleteNodeGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteNodeGroupMetadata) ProtoMessage()    {}
func (*DeleteNodeGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{6}
}

func (m *DeleteNodeGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNodeGroupMetadata.Unmarshal(m, b)
}
func (m *DeleteNodeGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNodeGroupMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteNodeGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNodeGroupMetadata.Merge(m, src)
}
func (m *DeleteNodeGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteNodeGroupMetadata.Size(m)
}
func (m *DeleteNodeGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNodeGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNodeGroupMetadata proto.InternalMessageInfo

func (m *DeleteNodeGroupMetadata) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

type UpdateNodeGroupRequest struct {
	// ID of the node group to update.
	// To get the node group ID use a [NodeGroupService.List] request.
	NodeGroupId string `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	// Field mask that specifies which fields of the node group are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the node group.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the node group.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	//
	// Existing set of `labels` is completely replaced by the provided set.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Node template for the node group.
	// Change may trigger nodes rolling reboot or recreate.
	NodeTemplate *NodeTemplate `protobuf:"bytes,8,opt,name=node_template,json=nodeTemplate,proto3" json:"node_template,omitempty"`
	// Scale policy of the node group.
	ScalePolicy *ScalePolicy `protobuf:"bytes,6,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	// Allocation policy of the node group by the zones and regions.
	AllocationPolicy *NodeGroupAllocationPolicy `protobuf:"bytes,9,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Deploy policy according to which the updates are rolled out. If not specified,
	// the default is used.
	DeployPolicy *DeployPolicy `protobuf:"bytes,15,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// Version of Kubernetes components that runs on the nodes.
	Version *UpdateVersionSpec `protobuf:"bytes,10,opt,name=version,proto3" json:"version,omitempty"`
	// Maintenance policy of the node group.
	MaintenancePolicy *NodeGroupMaintenancePolicy `protobuf:"bytes,11,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Support for unsafe sysctl parameters. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster/).
	AllowedUnsafeSysctls []string `protobuf:"bytes,12,rep,name=allowed_unsafe_sysctls,json=allowedUnsafeSysctls,proto3" json:"allowed_unsafe_sysctls,omitempty"`
	// Taints that are applied to the nodes of the node group at creation time.
	NodeTaints []*Taint `protobuf:"bytes,13,rep,name=node_taints,json=nodeTaints,proto3" json:"node_taints,omitempty"`
	// Labels that are assigned to the nodes of the node group at creation time.
	NodeLabels           map[string]string `protobuf:"bytes,14,rep,name=node_labels,json=nodeLabels,proto3" json:"node_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateNodeGroupRequest) Reset()         { *m = UpdateNodeGroupRequest{} }
func (m *UpdateNodeGroupRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNodeGroupRequest) ProtoMessage()    {}
func (*UpdateNodeGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{7}
}

func (m *UpdateNodeGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNodeGroupRequest.Unmarshal(m, b)
}
func (m *UpdateNodeGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNodeGroupRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNodeGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNodeGroupRequest.Merge(m, src)
}
func (m *UpdateNodeGroupRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNodeGroupRequest.Size(m)
}
func (m *UpdateNodeGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNodeGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNodeGroupRequest proto.InternalMessageInfo

func (m *UpdateNodeGroupRequest) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

func (m *UpdateNodeGroupRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateNodeGroupRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateNodeGroupRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetNodeTemplate() *NodeTemplate {
	if m != nil {
		return m.NodeTemplate
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetScalePolicy() *ScalePolicy {
	if m != nil {
		return m.ScalePolicy
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetAllocationPolicy() *NodeGroupAllocationPolicy {
	if m != nil {
		return m.AllocationPolicy
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetDeployPolicy() *DeployPolicy {
	if m != nil {
		return m.DeployPolicy
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetVersion() *UpdateVersionSpec {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetMaintenancePolicy() *NodeGroupMaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetAllowedUnsafeSysctls() []string {
	if m != nil {
		return m.AllowedUnsafeSysctls
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetNodeTaints() []*Taint {
	if m != nil {
		return m.NodeTaints
	}
	return nil
}

func (m *UpdateNodeGroupRequest) GetNodeLabels() map[string]string {
	if m != nil {
		return m.NodeLabels
	}
	return nil
}

type UpdateNodeGroupMetadata struct {
	// ID of the Node group that is being updated.
	NodeGroupId          string   `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateNodeGroupMetadata) Reset()         { *m = UpdateNodeGroupMetadata{} }
func (m *UpdateNodeGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateNodeGroupMetadata) ProtoMessage()    {}
func (*UpdateNodeGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{8}
}

func (m *UpdateNodeGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNodeGroupMetadata.Unmarshal(m, b)
}
func (m *UpdateNodeGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNodeGroupMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateNodeGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNodeGroupMetadata.Merge(m, src)
}
func (m *UpdateNodeGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateNodeGroupMetadata.Size(m)
}
func (m *UpdateNodeGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNodeGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNodeGroupMetadata proto.InternalMessageInfo

func (m *UpdateNodeGroupMetadata) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

type CreateNodeGroupRequest struct {
	// ID of the Kubernetes cluster to create a node group in.
	// To get the Kubernetes cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the node group.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the node group.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Node template for creating the node group.
	NodeTemplate *NodeTemplate `protobuf:"bytes,5,opt,name=node_template,json=nodeTemplate,proto3" json:"node_template,omitempty"`
	// Scale policy of the node group.
	ScalePolicy *ScalePolicy `protobuf:"bytes,6,opt,name=scale_policy,json=scalePolicy,proto3" json:"scale_policy,omitempty"`
	// Allocation policy of the node group by the zones and regions.
	AllocationPolicy *NodeGroupAllocationPolicy `protobuf:"bytes,7,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// Deploy policy according to which the updates are rolled out. If not specified,
	// the default is used.
	DeployPolicy *DeployPolicy `protobuf:"bytes,13,opt,name=deploy_policy,json=deployPolicy,proto3" json:"deploy_policy,omitempty"`
	// Version of Kubernetes components that runs on the nodes.
	Version string `protobuf:"bytes,8,opt,name=version,proto3" json:"version,omitempty"`
	// Maintenance policy of the node group.
	MaintenancePolicy *NodeGroupMaintenancePolicy `protobuf:"bytes,9,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Support for unsafe sysctl parameters. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster/).
	AllowedUnsafeSysctls []string `protobuf:"bytes,10,rep,name=allowed_unsafe_sysctls,json=allowedUnsafeSysctls,proto3" json:"allowed_unsafe_sysctls,omitempty"`
	// Taints that are applied to the nodes of the node group at creation time.
	NodeTaints []*Taint `protobuf:"bytes,11,rep,name=node_taints,json=nodeTaints,proto3" json:"node_taints,omitempty"`
	// Labels that are assigned to the nodes of the node group at creation time.
	NodeLabels           map[string]string `protobuf:"bytes,12,rep,name=node_labels,json=nodeLabels,proto3" json:"node_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateNodeGroupRequest) Reset()         { *m = CreateNodeGroupRequest{} }
func (m *CreateNodeGroupRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNodeGroupRequest) ProtoMessage()    {}
func (*CreateNodeGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{9}
}

func (m *CreateNodeGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNodeGroupRequest.Unmarshal(m, b)
}
func (m *CreateNodeGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNodeGroupRequest.Marshal(b, m, deterministic)
}
func (m *CreateNodeGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNodeGroupRequest.Merge(m, src)
}
func (m *CreateNodeGroupRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNodeGroupRequest.Size(m)
}
func (m *CreateNodeGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNodeGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNodeGroupRequest proto.InternalMessageInfo

func (m *CreateNodeGroupRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateNodeGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateNodeGroupRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateNodeGroupRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetNodeTemplate() *NodeTemplate {
	if m != nil {
		return m.NodeTemplate
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetScalePolicy() *ScalePolicy {
	if m != nil {
		return m.ScalePolicy
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetAllocationPolicy() *NodeGroupAllocationPolicy {
	if m != nil {
		return m.AllocationPolicy
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetDeployPolicy() *DeployPolicy {
	if m != nil {
		return m.DeployPolicy
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *CreateNodeGroupRequest) GetMaintenancePolicy() *NodeGroupMaintenancePolicy {
	if m != nil {
		return m.MaintenancePolicy
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetAllowedUnsafeSysctls() []string {
	if m != nil {
		return m.AllowedUnsafeSysctls
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetNodeTaints() []*Taint {
	if m != nil {
		return m.NodeTaints
	}
	return nil
}

func (m *CreateNodeGroupRequest) GetNodeLabels() map[string]string {
	if m != nil {
		return m.NodeLabels
	}
	return nil
}

type CreateNodeGroupMetadata struct {
	// ID of the node group that is being created.
	NodeGroupId          string   `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateNodeGroupMetadata) Reset()         { *m = CreateNodeGroupMetadata{} }
func (m *CreateNodeGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateNodeGroupMetadata) ProtoMessage()    {}
func (*CreateNodeGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{10}
}

func (m *CreateNodeGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNodeGroupMetadata.Unmarshal(m, b)
}
func (m *CreateNodeGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNodeGroupMetadata.Marshal(b, m, deterministic)
}
func (m *CreateNodeGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNodeGroupMetadata.Merge(m, src)
}
func (m *CreateNodeGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateNodeGroupMetadata.Size(m)
}
func (m *CreateNodeGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNodeGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNodeGroupMetadata proto.InternalMessageInfo

func (m *CreateNodeGroupMetadata) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

type AutoUpgradeNodeGroupMetadata struct {
	// ID of the node group that is being auto upgraded.
	NodeGroupId          string   `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutoUpgradeNodeGroupMetadata) Reset()         { *m = AutoUpgradeNodeGroupMetadata{} }
func (m *AutoUpgradeNodeGroupMetadata) String() string { return proto.CompactTextString(m) }
func (*AutoUpgradeNodeGroupMetadata) ProtoMessage()    {}
func (*AutoUpgradeNodeGroupMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{11}
}

func (m *AutoUpgradeNodeGroupMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoUpgradeNodeGroupMetadata.Unmarshal(m, b)
}
func (m *AutoUpgradeNodeGroupMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoUpgradeNodeGroupMetadata.Marshal(b, m, deterministic)
}
func (m *AutoUpgradeNodeGroupMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoUpgradeNodeGroupMetadata.Merge(m, src)
}
func (m *AutoUpgradeNodeGroupMetadata) XXX_Size() int {
	return xxx_messageInfo_AutoUpgradeNodeGroupMetadata.Size(m)
}
func (m *AutoUpgradeNodeGroupMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoUpgradeNodeGroupMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AutoUpgradeNodeGroupMetadata proto.InternalMessageInfo

func (m *AutoUpgradeNodeGroupMetadata) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

type ListNodeGroupOperationsRequest struct {
	// ID of the node group to list operations for.
	NodeGroupId string `protobuf:"bytes,1,opt,name=node_group_id,json=nodeGroupId,proto3" json:"node_group_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size], the service returns a [ListNodeGroupOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListNodeGroupOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// Currently you can use filtering only on [NodeGroup.name] field.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodeGroupOperationsRequest) Reset()         { *m = ListNodeGroupOperationsRequest{} }
func (m *ListNodeGroupOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNodeGroupOperationsRequest) ProtoMessage()    {}
func (*ListNodeGroupOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{12}
}

func (m *ListNodeGroupOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodeGroupOperationsRequest.Unmarshal(m, b)
}
func (m *ListNodeGroupOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodeGroupOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListNodeGroupOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodeGroupOperationsRequest.Merge(m, src)
}
func (m *ListNodeGroupOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNodeGroupOperationsRequest.Size(m)
}
func (m *ListNodeGroupOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodeGroupOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodeGroupOperationsRequest proto.InternalMessageInfo

func (m *ListNodeGroupOperationsRequest) GetNodeGroupId() string {
	if m != nil {
		return m.NodeGroupId
	}
	return ""
}

func (m *ListNodeGroupOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNodeGroupOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListNodeGroupOperationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListNodeGroupOperationsResponse struct {
	// List of operations for the specified node group.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNodeGroupOperationsRequest.page_size], use the `next_page_token` as the value
	// for the [ListNodeGroupOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNodeGroupOperationsResponse) Reset()         { *m = ListNodeGroupOperationsResponse{} }
func (m *ListNodeGroupOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNodeGroupOperationsResponse) ProtoMessage()    {}
func (*ListNodeGroupOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b7cf1411620c03ca, []int{13}
}

func (m *ListNodeGroupOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNodeGroupOperationsResponse.Unmarshal(m, b)
}
func (m *ListNodeGroupOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNodeGroupOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListNodeGroupOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNodeGroupOperationsResponse.Merge(m, src)
}
func (m *ListNodeGroupOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNodeGroupOperationsResponse.Size(m)
}
func (m *ListNodeGroupOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNodeGroupOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNodeGroupOperationsResponse proto.InternalMessageInfo

func (m *ListNodeGroupOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListNodeGroupOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*GetNodeGroupRequest)(nil), "yandex.cloud.k8s.v1.GetNodeGroupRequest")
	proto.RegisterType((*ListNodeGroupsRequest)(nil), "yandex.cloud.k8s.v1.ListNodeGroupsRequest")
	proto.RegisterType((*ListNodeGroupsResponse)(nil), "yandex.cloud.k8s.v1.ListNodeGroupsResponse")
	proto.RegisterType((*ListNodeGroupNodesRequest)(nil), "yandex.cloud.k8s.v1.ListNodeGroupNodesRequest")
	proto.RegisterType((*ListNodeGroupNodesResponse)(nil), "yandex.cloud.k8s.v1.ListNodeGroupNodesResponse")
	proto.RegisterType((*DeleteNodeGroupRequest)(nil), "yandex.cloud.k8s.v1.DeleteNodeGroupRequest")
	proto.RegisterType((*DeleteNodeGroupMetadata)(nil), "yandex.cloud.k8s.v1.DeleteNodeGroupMetadata")
	proto.RegisterType((*UpdateNodeGroupRequest)(nil), "yandex.cloud.k8s.v1.UpdateNodeGroupRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.UpdateNodeGroupRequest.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.UpdateNodeGroupRequest.NodeLabelsEntry")
	proto.RegisterType((*UpdateNodeGroupMetadata)(nil), "yandex.cloud.k8s.v1.UpdateNodeGroupMetadata")
	proto.RegisterType((*CreateNodeGroupRequest)(nil), "yandex.cloud.k8s.v1.CreateNodeGroupRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.CreateNodeGroupRequest.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.k8s.v1.CreateNodeGroupRequest.NodeLabelsEntry")
	proto.RegisterType((*CreateNodeGroupMetadata)(nil), "yandex.cloud.k8s.v1.CreateNodeGroupMetadata")
	proto.RegisterType((*AutoUpgradeNodeGroupMetadata)(nil), "yandex.cloud.k8s.v1.AutoUpgradeNodeGroupMetadata")
	proto.RegisterType((*ListNodeGroupOperationsRequest)(nil), "yandex.cloud.k8s.v1.ListNodeGroupOperationsRequest")
	proto.RegisterType((*ListNodeGroupOperationsResponse)(nil), "yandex.cloud.k8s.v1.ListNodeGroupOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/k8s/v1/node_group_service.proto", fileDescriptor_b7cf1411620c03ca)
}

var fileDescriptor_b7cf1411620c03ca = []byte{
	// 1444 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcf, 0x6f, 0x13, 0xc7,
	0x17, 0xd7, 0x26, 0x8e, 0xc9, 0x3e, 0x27, 0x10, 0x06, 0x48, 0x8c, 0x05, 0xf9, 0x26, 0x06, 0xe5,
	0xeb, 0x18, 0xbc, 0xeb, 0x4d, 0x20, 0x4d, 0x08, 0x69, 0x8a, 0xf9, 0xa5, 0x48, 0x50, 0xd0, 0x26,
	0x70, 0x68, 0xa0, 0xd6, 0xc4, 0x3b, 0x71, 0x57, 0x5e, 0xef, 0x6e, 0x3d, 0xeb, 0x14, 0x87, 0x72,
	0x28, 0x52, 0x0f, 0x8d, 0x7a, 0xa8, 0xda, 0x4b, 0xff, 0x8a, 0x4a, 0xe5, 0x0f, 0xa8, 0xc4, 0x29,
	0x39, 0xd3, 0x7f, 0xa1, 0x52, 0x7b, 0xe6, 0xd8, 0x53, 0xb5, 0xb3, 0xb3, 0xeb, 0x1f, 0xac, 0x7f,
	0x25, 0xa2, 0xe5, 0x94, 0x9d, 0x99, 0xcf, 0x7b, 0xf3, 0x79, 0x6f, 0xde, 0x7c, 0x32, 0xcf, 0x70,
	0xb9, 0x86, 0x4d, 0x8d, 0x3c, 0x93, 0x0b, 0x86, 0x55, 0xd5, 0xe4, 0xd2, 0x22, 0x95, 0x77, 0x14,
	0xd9, 0xb4, 0x34, 0x92, 0x2f, 0x56, 0xac, 0xaa, 0x9d, 0xa7, 0xa4, 0xb2, 0xa3, 0x17, 0x88, 0x64,
	0x57, 0x2c, 0xc7, 0x42, 0xa7, 0x3c, 0xb4, 0xc4, 0xd0, 0x52, 0x69, 0x91, 0x4a, 0x3b, 0x4a, 0xe2,
	0x5c, 0xd1, 0xb2, 0x8a, 0x06, 0x91, 0xb1, 0xad, 0xcb, 0xd8, 0x34, 0x2d, 0x07, 0x3b, 0xba, 0x65,
	0x52, 0xcf, 0x24, 0x31, 0xc5, 0x57, 0xd9, 0x68, 0xab, 0xba, 0x2d, 0x6f, 0xeb, 0xc4, 0xd0, 0xf2,
	0x65, 0x4c, 0x4b, 0x3e, 0xa2, 0x89, 0x82, 0xeb, 0xc5, 0xb2, 0x49, 0x85, 0x39, 0xe1, 0x88, 0x8b,
	0x9d, 0x49, 0x72, 0xd4, 0x64, 0x3b, 0x14, 0x5f, 0x9f, 0x0e, 0x5b, 0xdf, 0x21, 0x15, 0x5a, 0xdf,
	0x68, 0xa6, 0x09, 0x12, 0xd0, 0x78, 0x87, 0xd0, 0xf9, 0x26, 0xdc, 0x0e, 0x36, 0x74, 0xad, 0x61,
	0x39, 0xb9, 0x0a, 0xa7, 0xee, 0x12, 0xe7, 0x53, 0x4b, 0x23, 0x77, 0x5d, 0x7e, 0x2a, 0xf9, 0xb2,
	0x4a, 0xa8, 0x83, 0x52, 0x30, 0xda, 0x90, 0x59, 0x5d, 0x8b, 0x0b, 0x53, 0x42, 0x4a, 0xcc, 0x45,
	0xfe, 0xda, 0x57, 0x04, 0x35, 0x66, 0xfa, 0xf0, 0x35, 0x2d, 0xf9, 0xab, 0x00, 0x67, 0xee, 0xe9,
	0xb4, 0xee, 0x82, 0xfa, 0x3e, 0xa6, 0x41, 0xdc, 0xb6, 0x0c, 0x8d, 0x54, 0x5a, 0xed, 0x87, 0xbd,
	0xe9, 0x35, 0x0d, 0xfd, 0x1f, 0x44, 0x1b, 0x17, 0x49, 0x9e, 0xea, 0xbb, 0x24, 0x3e, 0x30, 0x25,
	0xa4, 0x06, 0x73, 0xf0, 0xf7, 0xbe, 0x12, 0xcd, 0x66, 0x94, 0x6c, 0x36, 0xab, 0x0e, 0xbb, 0x8b,
	0xeb, 0xfa, 0x2e, 0x41, 0x29, 0x00, 0x06, 0x74, 0xac, 0x12, 0x31, 0xe3, 0x83, 0xcc, 0x99, 0xb8,
	0x77, 0xa0, 0x0c, 0x5d, 0x5f, 0x51, 0xb2, 0x59, 0x95, 0x79, 0xd9, 0x70, 0xd7, 0x50, 0x12, 0xa2,
	0xdb, 0xba, 0xe1, 0x90, 0x4a, 0x3c, 0xc2, 0x50, 0xb0, 0x77, 0xa0, 0x44, 0x19, 0x2a, 0xab, 0xf2,
	0x95, 0xe4, 0x37, 0x02, 0x8c, 0xb7, 0x72, 0xa6, 0xb6, 0x65, 0x52, 0x82, 0x56, 0x21, 0x56, 0x0f,
	0x9c, 0xc6, 0x85, 0xa9, 0xc1, 0x54, 0x6c, 0x6e, 0x52, 0x0a, 0x29, 0x26, 0xa9, 0x9e, 0x34, 0x08,
	0x12, 0x42, 0xd1, 0x0c, 0x9c, 0x30, 0xc9, 0x33, 0x27, 0xdf, 0x40, 0xd7, 0x0d, 0x4c, 0x54, 0x47,
	0xdd, 0xe9, 0x87, 0x3e, 0xcf, 0xe4, 0xcf, 0x02, 0x9c, 0x6d, 0xe2, 0xe0, 0x7e, 0xd0, 0xbe, 0xf3,
	0xff, 0x1e, 0x52, 0x98, 0xac, 0x42, 0x22, 0x8c, 0x19, 0xcf, 0x90, 0x0c, 0x43, 0xee, 0xfe, 0x7e,
	0x6e, 0xce, 0xb6, 0xcd, 0x8d, 0xea, 0xe1, 0x7a, 0xce, 0x48, 0x0e, 0xc6, 0x6f, 0x11, 0x83, 0x38,
	0xe4, 0x08, 0xd5, 0xb8, 0x02, 0x13, 0x2d, 0x3e, 0xee, 0x13, 0x07, 0x6b, 0xd8, 0xc1, 0x28, 0x19,
	0xea, 0xa4, 0xd9, 0xfc, 0x4f, 0x11, 0xc6, 0x1f, 0xd9, 0x1a, 0x3e, 0x0a, 0x07, 0xb4, 0x0c, 0xb1,
	0x2a, 0xf3, 0xc1, 0x94, 0x83, 0xc5, 0x1a, 0x9b, 0x4b, 0x48, 0x9e, 0xb8, 0x48, 0xbe, 0xb8, 0x48,
	0x77, 0x5c, 0x71, 0xb9, 0x8f, 0x69, 0x49, 0x05, 0x0f, 0xee, 0x7e, 0xa3, 0xab, 0x10, 0x31, 0x71,
	0x99, 0xf0, 0xf3, 0x99, 0x7e, 0xbb, 0xaf, 0x9c, 0xff, 0x7a, 0x13, 0x67, 0x76, 0x9f, 0x6e, 0x66,
	0x70, 0x66, 0x37, 0x9b, 0x59, 0x7a, 0xfa, 0x5c, 0xb9, 0xbc, 0xa0, 0xbc, 0xd8, 0xe4, 0x23, 0x95,
	0xc1, 0xd1, 0x25, 0x88, 0x69, 0x84, 0x16, 0x2a, 0xba, 0xed, 0xde, 0x6d, 0x5e, 0xfa, 0xfc, 0x74,
	0xe7, 0xae, 0x2e, 0xa8, 0x8d, 0xab, 0xe8, 0x07, 0x01, 0xa2, 0x06, 0xde, 0x22, 0x06, 0x8d, 0x0f,
	0xb1, 0x33, 0xfc, 0x28, 0xf4, 0x0c, 0xc3, 0x13, 0x21, 0xdd, 0x63, 0x96, 0xb7, 0x4d, 0xa7, 0x52,
	0xcb, 0xad, 0xbe, 0xdd, 0x57, 0x62, 0x9b, 0x99, 0x7c, 0x36, 0xb3, 0xe4, 0x72, 0x4c, 0xbf, 0x3c,
	0x50, 0x22, 0xd7, 0x57, 0x16, 0xae, 0xec, 0x79, 0x7f, 0xe7, 0x5f, 0x1d, 0x28, 0xd1, 0x44, 0x44,
	0xc9, 0xb0, 0x2f, 0x84, 0xc6, 0x78, 0x24, 0x01, 0x5e, 0xe5, 0x3c, 0xd0, 0x1d, 0x9e, 0x5d, 0x87,
	0x94, 0x6d, 0x03, 0x3b, 0x24, 0x3e, 0xcc, 0xb2, 0x36, 0xdd, 0xb6, 0xb8, 0x36, 0x38, 0x50, 0x1d,
	0x31, 0x1b, 0x46, 0xe8, 0x26, 0x8c, 0xd0, 0x02, 0x36, 0x48, 0xde, 0xb6, 0x0c, 0xbd, 0x50, 0x8b,
	0x47, 0x99, 0x9b, 0xa9, 0x50, 0x37, 0xeb, 0x2e, 0xf0, 0x21, 0xc3, 0xa9, 0x31, 0x5a, 0x1f, 0xa0,
	0x4d, 0x38, 0x89, 0x0d, 0xc3, 0x2a, 0x30, 0x9d, 0xf4, 0x3d, 0x89, 0xcc, 0x93, 0xd4, 0x59, 0x09,
	0x6e, 0x04, 0x66, 0xdc, 0xef, 0x18, 0x6e, 0x99, 0x71, 0x23, 0xd5, 0x88, 0x6d, 0x58, 0x35, 0xdf,
	0xf1, 0x89, 0x0e, 0x91, 0xde, 0x62, 0x48, 0xee, 0x6b, 0x44, 0x6b, 0x18, 0xa1, 0x4f, 0xe0, 0x18,
	0xff, 0x87, 0x10, 0x07, 0xe6, 0x61, 0xa6, 0xc3, 0x21, 0x3e, 0xf6, 0x90, 0xeb, 0x36, 0x29, 0xa8,
	0xbe, 0x19, 0xfa, 0x1c, 0x50, 0x19, 0xeb, 0xa6, 0x43, 0x4c, 0x6c, 0x16, 0x82, 0x8c, 0xc5, 0x98,
	0x33, 0xb9, 0x73, 0x9c, 0xf7, 0xeb, 0x76, 0x9c, 0xdc, 0xc9, 0x72, 0xeb, 0x14, 0xfa, 0x56, 0x80,
	0x71, 0x37, 0xfc, 0xaf, 0x88, 0x96, 0xaf, 0x9a, 0x14, 0x6f, 0x93, 0x3c, 0xad, 0xd1, 0x82, 0x63,
	0xd0, 0xf8, 0xc8, 0xd4, 0x60, 0x4a, 0xcc, 0x3d, 0x78, 0xbb, 0xaf, 0xe4, 0x52, 0x7e, 0x25, 0xa7,
	0x36, 0x33, 0x79, 0xfe, 0x99, 0xf6, 0xe7, 0x66, 0x57, 0x9f, 0x48, 0xb3, 0xe9, 0x00, 0xd2, 0x80,
	0x98, 0x5d, 0xe5, 0x93, 0xe9, 0xa7, 0x7e, 0x95, 0xcf, 0xab, 0xa7, 0xf9, 0x76, 0x8f, 0xd8, 0x6e,
	0xeb, 0xde, 0x66, 0xee, 0x7d, 0xf4, 0x6a, 0xcb, 0x65, 0x48, 0xe3, 0xa3, 0xac, 0xe4, 0x13, 0xa1,
	0x01, 0x6e, 0xb8, 0x10, 0x4f, 0xce, 0xd9, 0x27, 0x45, 0x4f, 0xb8, 0x31, 0xbf, 0x2f, 0xc7, 0x99,
	0xf1, 0x72, 0x3f, 0xf7, 0xc5, 0x9d, 0x68, 0xb8, 0x33, 0x9e, 0x77, 0x6f, 0x22, 0xb1, 0x04, 0xb1,
	0x86, 0x25, 0x34, 0x06, 0x83, 0x25, 0x52, 0xe3, 0xc2, 0xe4, 0x7e, 0xa2, 0xd3, 0x30, 0xb4, 0x83,
	0x8d, 0x2a, 0xe1, 0x8a, 0xe9, 0x0d, 0xae, 0x0d, 0x2c, 0x0a, 0x89, 0x15, 0x38, 0xd1, 0xe2, 0xb9,
	0x1f, 0xf3, 0xe4, 0x4d, 0x98, 0x68, 0xe1, 0x1b, 0x08, 0x65, 0xef, 0x6a, 0xfb, 0x9d, 0x08, 0xe3,
	0x37, 0x2b, 0x24, 0x4c, 0x2e, 0x2f, 0x00, 0x14, 0x8c, 0x2a, 0x75, 0xde, 0xfd, 0xef, 0x2f, 0xf2,
	0xf9, 0x35, 0x2d, 0x10, 0xbb, 0x81, 0x23, 0x89, 0xdd, 0x60, 0xaf, 0x62, 0x17, 0xe9, 0x20, 0x76,
	0xe1, 0x61, 0xbc, 0x1f, 0xb1, 0xbb, 0xd7, 0x2a, 0x76, 0x43, 0x3d, 0x8a, 0x1d, 0xcf, 0x60, 0xb3,
	0xe4, 0xad, 0x1d, 0x4e, 0xf2, 0xfc, 0xf3, 0xec, 0x2a, 0x7c, 0xc7, 0xde, 0x97, 0xf0, 0x8d, 0x1e,
	0x4e, 0xf8, 0xe2, 0x75, 0xe1, 0x1b, 0x66, 0x55, 0xdd, 0x45, 0xd0, 0xc4, 0x7f, 0x43, 0xd0, 0xe0,
	0x3f, 0x14, 0xb4, 0xd8, 0x51, 0x04, 0x6d, 0xa4, 0x83, 0xa0, 0xb5, 0xb9, 0x13, 0x1f, 0xa6, 0xa0,
	0xad, 0xc0, 0x44, 0x0b, 0xdf, 0xbe, 0x5e, 0x7e, 0x39, 0x38, 0x77, 0xa3, 0xea, 0x58, 0x8f, 0xec,
	0x62, 0x05, 0x6b, 0x87, 0xf4, 0xf1, 0x5a, 0x80, 0xc9, 0xa6, 0x87, 0xf3, 0x03, 0xbf, 0x17, 0xfb,
	0x20, 0xde, 0xf5, 0x3d, 0xb5, 0x46, 0xdf, 0x0b, 0xf0, 0xbf, 0xb6, 0x31, 0xf0, 0x0e, 0xe0, 0x06,
	0x40, 0xd0, 0x65, 0xfa, 0x6d, 0x40, 0xcb, 0x35, 0xae, 0x77, 0xa1, 0x81, 0xbd, 0xda, 0x60, 0xd4,
	0x6b, 0x4f, 0x30, 0xf7, 0x5a, 0x84, 0xb1, 0x80, 0xca, 0xba, 0xd7, 0xe0, 0xa3, 0x3d, 0x01, 0x06,
	0xef, 0x12, 0x07, 0xa5, 0x42, 0xab, 0x36, 0xa4, 0x9d, 0x4d, 0x74, 0x69, 0xe0, 0x92, 0x4b, 0x2f,
	0x7f, 0xff, 0xe3, 0xa7, 0x81, 0x79, 0xa4, 0xc8, 0x65, 0x6c, 0xe2, 0x22, 0xd1, 0x32, 0xa5, 0xea,
	0x16, 0xa9, 0x98, 0xc4, 0x21, 0x41, 0x6b, 0xee, 0xf5, 0x77, 0xf2, 0xf3, 0xa6, 0xf3, 0x7b, 0xe1,
	0x92, 0x89, 0xb8, 0x09, 0x43, 0xe9, 0xd0, 0x3d, 0x42, 0x5b, 0xe3, 0xc4, 0xa5, 0x9e, 0xb0, 0x5e,
	0xba, 0x93, 0xb3, 0x8c, 0xdc, 0x05, 0x34, 0xdd, 0x95, 0x1c, 0xfa, 0x45, 0x80, 0xa8, 0x77, 0x0b,
	0xd0, 0xa5, 0x3e, 0xae, 0x74, 0xa2, 0xfb, 0xe9, 0x25, 0x37, 0x5e, 0xbd, 0x49, 0x5f, 0x6c, 0x7f,
	0xc7, 0xc4, 0x60, 0x8a, 0xb1, 0x9d, 0x49, 0x76, 0x67, 0x7b, 0x4d, 0x48, 0xa3, 0xdf, 0x04, 0x88,
	0x7a, 0xef, 0x90, 0x36, 0x84, 0xc3, 0x1f, 0x55, 0xbd, 0x10, 0xd6, 0x3c, 0xc2, 0xed, 0x5e, 0x39,
	0x2d, 0x84, 0x17, 0xe6, 0xfa, 0x3f, 0x7b, 0x37, 0x80, 0x7d, 0x01, 0xa2, 0x5e, 0xc7, 0xd9, 0x26,
	0x80, 0xf0, 0x96, 0xb6, 0x97, 0x00, 0xca, 0xaf, 0xde, 0xa4, 0xb3, 0xed, 0xfb, 0xd9, 0x33, 0xad,
	0x0d, 0xe5, 0xed, 0xb2, 0xed, 0xd4, 0xbc, 0x42, 0x4e, 0x1f, 0xa2, 0x90, 0x5f, 0x0b, 0x70, 0xdc,
	0xad, 0xc0, 0xfa, 0x85, 0x47, 0xf3, 0xdd, 0xcb, 0xf4, 0x1d, 0x89, 0x4b, 0x5c, 0xe9, 0xcf, 0x88,
	0x17, 0xf9, 0x2d, 0x46, 0xfc, 0x63, 0x74, 0xbd, 0x6f, 0xe2, 0x72, 0x83, 0xac, 0xfc, 0x28, 0x80,
	0xe8, 0xef, 0x44, 0x91, 0xd4, 0x9d, 0x49, 0xe3, 0x8f, 0x2e, 0x09, 0xb9, 0x67, 0x3c, 0x27, 0x7d,
	0x91, 0x91, 0x9e, 0x44, 0xe7, 0x3a, 0x90, 0xa6, 0xb9, 0xc7, 0x30, 0xd1, 0xe4, 0x17, 0xdb, 0x3a,
	0xf7, 0xfd, 0xd9, 0x72, 0x51, 0x77, 0xbe, 0xa8, 0x6e, 0x49, 0x05, 0xab, 0x2c, 0x7b, 0x98, 0x8c,
	0xf7, 0x3b, 0x5d, 0xd1, 0xca, 0x14, 0x89, 0xc9, 0x8e, 0x56, 0x0e, 0xf9, 0x2d, 0x70, 0xb9, 0xb4,
	0x48, 0xb7, 0xa2, 0x6c, 0x79, 0xfe, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdb, 0xbd, 0x9e, 0xf1,
	0x18, 0x15, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NodeGroupServiceClient is the client API for NodeGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NodeGroupServiceClient interface {
	// Returns the specified node group.
	//
	// To get the list of available node group, make a [List] request.
	Get(ctx context.Context, in *GetNodeGroupRequest, opts ...grpc.CallOption) (*NodeGroup, error)
	// Retrieves the list of node group in the specified Kubernetes cluster.
	List(ctx context.Context, in *ListNodeGroupsRequest, opts ...grpc.CallOption) (*ListNodeGroupsResponse, error)
	// Creates a node group in the specified Kubernetes cluster.
	Create(ctx context.Context, in *CreateNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified node group.
	Update(ctx context.Context, in *UpdateNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified node group.
	Delete(ctx context.Context, in *DeleteNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified node group.
	ListOperations(ctx context.Context, in *ListNodeGroupOperationsRequest, opts ...grpc.CallOption) (*ListNodeGroupOperationsResponse, error)
	// Retrieves the list of nodes in the specified Kubernetes cluster.
	ListNodes(ctx context.Context, in *ListNodeGroupNodesRequest, opts ...grpc.CallOption) (*ListNodeGroupNodesResponse, error)
}

type nodeGroupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNodeGroupServiceClient(cc grpc.ClientConnInterface) NodeGroupServiceClient {
	return &nodeGroupServiceClient{cc}
}

func (c *nodeGroupServiceClient) Get(ctx context.Context, in *GetNodeGroupRequest, opts ...grpc.CallOption) (*NodeGroup, error) {
	out := new(NodeGroup)
	err := c.cc.Invoke(ctx, "/yandex.cloud.k8s.v1.NodeGroupService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupServiceClient) List(ctx context.Context, in *ListNodeGroupsRequest, opts ...grpc.CallOption) (*ListNodeGroupsResponse, error) {
	out := new(ListNodeGroupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.k8s.v1.NodeGroupService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupServiceClient) Create(ctx context.Context, in *CreateNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.k8s.v1.NodeGroupService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupServiceClient) Update(ctx context.Context, in *UpdateNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.k8s.v1.NodeGroupService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupServiceClient) Delete(ctx context.Context, in *DeleteNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.k8s.v1.NodeGroupService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupServiceClient) ListOperations(ctx context.Context, in *ListNodeGroupOperationsRequest, opts ...grpc.CallOption) (*ListNodeGroupOperationsResponse, error) {
	out := new(ListNodeGroupOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.k8s.v1.NodeGroupService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupServiceClient) ListNodes(ctx context.Context, in *ListNodeGroupNodesRequest, opts ...grpc.CallOption) (*ListNodeGroupNodesResponse, error) {
	out := new(ListNodeGroupNodesResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.k8s.v1.NodeGroupService/ListNodes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NodeGroupServiceServer is the server API for NodeGroupService service.
type NodeGroupServiceServer interface {
	// Returns the specified node group.
	//
	// To get the list of available node group, make a [List] request.
	Get(context.Context, *GetNodeGroupRequest) (*NodeGroup, error)
	// Retrieves the list of node group in the specified Kubernetes cluster.
	List(context.Context, *ListNodeGroupsRequest) (*ListNodeGroupsResponse, error)
	// Creates a node group in the specified Kubernetes cluster.
	Create(context.Context, *CreateNodeGroupRequest) (*operation.Operation, error)
	// Updates the specified node group.
	Update(context.Context, *UpdateNodeGroupRequest) (*operation.Operation, error)
	// Deletes the specified node group.
	Delete(context.Context, *DeleteNodeGroupRequest) (*operation.Operation, error)
	// Lists operations for the specified node group.
	ListOperations(context.Context, *ListNodeGroupOperationsRequest) (*ListNodeGroupOperationsResponse, error)
	// Retrieves the list of nodes in the specified Kubernetes cluster.
	ListNodes(context.Context, *ListNodeGroupNodesRequest) (*ListNodeGroupNodesResponse, error)
}

// UnimplementedNodeGroupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNodeGroupServiceServer struct {
}

func (*UnimplementedNodeGroupServiceServer) Get(ctx context.Context, req *GetNodeGroupRequest) (*NodeGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedNodeGroupServiceServer) List(ctx context.Context, req *ListNodeGroupsRequest) (*ListNodeGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedNodeGroupServiceServer) Create(ctx context.Context, req *CreateNodeGroupRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedNodeGroupServiceServer) Update(ctx context.Context, req *UpdateNodeGroupRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedNodeGroupServiceServer) Delete(ctx context.Context, req *DeleteNodeGroupRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedNodeGroupServiceServer) ListOperations(ctx context.Context, req *ListNodeGroupOperationsRequest) (*ListNodeGroupOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedNodeGroupServiceServer) ListNodes(ctx context.Context, req *ListNodeGroupNodesRequest) (*ListNodeGroupNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodes not implemented")
}

func RegisterNodeGroupServiceServer(s *grpc.Server, srv NodeGroupServiceServer) {
	s.RegisterService(&_NodeGroupService_serviceDesc, srv)
}

func _NodeGroupService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.k8s.v1.NodeGroupService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupServiceServer).Get(ctx, req.(*GetNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.k8s.v1.NodeGroupService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupServiceServer).List(ctx, req.(*ListNodeGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.k8s.v1.NodeGroupService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupServiceServer).Create(ctx, req.(*CreateNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.k8s.v1.NodeGroupService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupServiceServer).Update(ctx, req.(*UpdateNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.k8s.v1.NodeGroupService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupServiceServer).Delete(ctx, req.(*DeleteNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeGroupOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.k8s.v1.NodeGroupService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupServiceServer).ListOperations(ctx, req.(*ListNodeGroupOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroupService_ListNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeGroupNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupServiceServer).ListNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.k8s.v1.NodeGroupService/ListNodes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupServiceServer).ListNodes(ctx, req.(*ListNodeGroupNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NodeGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.k8s.v1.NodeGroupService",
	HandlerType: (*NodeGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _NodeGroupService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NodeGroupService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _NodeGroupService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _NodeGroupService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NodeGroupService_Delete_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _NodeGroupService_ListOperations_Handler,
		},
		{
			MethodName: "ListNodes",
			Handler:    _NodeGroupService_ListNodes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/k8s/v1/node_group_service.proto",
}
