// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/kms/v1/symmetric_key.proto

package kms

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Supported symmetric encryption algorithms.
type SymmetricAlgorithm int32

const (
	SymmetricAlgorithm_SYMMETRIC_ALGORITHM_UNSPECIFIED SymmetricAlgorithm = 0
	// AES algorithm with 128-bit keys.
	SymmetricAlgorithm_AES_128 SymmetricAlgorithm = 1
	// AES algorithm with 192-bit keys.
	SymmetricAlgorithm_AES_192 SymmetricAlgorithm = 2
	// AES algorithm with 256-bit keys.
	SymmetricAlgorithm_AES_256 SymmetricAlgorithm = 3
)

var SymmetricAlgorithm_name = map[int32]string{
	0: "SYMMETRIC_ALGORITHM_UNSPECIFIED",
	1: "AES_128",
	2: "AES_192",
	3: "AES_256",
}

var SymmetricAlgorithm_value = map[string]int32{
	"SYMMETRIC_ALGORITHM_UNSPECIFIED": 0,
	"AES_128":                         1,
	"AES_192":                         2,
	"AES_256":                         3,
}

func (x SymmetricAlgorithm) String() string {
	return proto.EnumName(SymmetricAlgorithm_name, int32(x))
}

func (SymmetricAlgorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_01ef0714cb9d79e1, []int{0}
}

type SymmetricKey_Status int32

const (
	SymmetricKey_STATUS_UNSPECIFIED SymmetricKey_Status = 0
	// The key is being created.
	SymmetricKey_CREATING SymmetricKey_Status = 1
	// The key is active and can be used for encryption and decryption.
	// Can be set to INACTIVE using the [SymmetricKeyService.Update] method.
	SymmetricKey_ACTIVE SymmetricKey_Status = 2
	// The key is inactive and unusable.
	// Can be set to ACTIVE using the [SymmetricKeyService.Update] method.
	SymmetricKey_INACTIVE SymmetricKey_Status = 3
)

var SymmetricKey_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "CREATING",
	2: "ACTIVE",
	3: "INACTIVE",
}

var SymmetricKey_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"CREATING":           1,
	"ACTIVE":             2,
	"INACTIVE":           3,
}

func (x SymmetricKey_Status) String() string {
	return proto.EnumName(SymmetricKey_Status_name, int32(x))
}

func (SymmetricKey_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_01ef0714cb9d79e1, []int{0, 0}
}

// Possible version status.
type SymmetricKeyVersion_Status int32

const (
	SymmetricKeyVersion_STATUS_UNSPECIFIED SymmetricKeyVersion_Status = 0
	// The version is active and can be used for encryption and decryption.
	SymmetricKeyVersion_ACTIVE SymmetricKeyVersion_Status = 1
	// The version is scheduled for destruction, the time when it will be destroyed
	// is specified in the [SymmetricKeyVersion.destroy_at] field.
	SymmetricKeyVersion_SCHEDULED_FOR_DESTRUCTION SymmetricKeyVersion_Status = 2
	// The version is destroyed and cannot be recovered.
	SymmetricKeyVersion_DESTROYED SymmetricKeyVersion_Status = 3
)

var SymmetricKeyVersion_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "ACTIVE",
	2: "SCHEDULED_FOR_DESTRUCTION",
	3: "DESTROYED",
}

var SymmetricKeyVersion_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED":        0,
	"ACTIVE":                    1,
	"SCHEDULED_FOR_DESTRUCTION": 2,
	"DESTROYED":                 3,
}

func (x SymmetricKeyVersion_Status) String() string {
	return proto.EnumName(SymmetricKeyVersion_Status_name, int32(x))
}

func (SymmetricKeyVersion_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_01ef0714cb9d79e1, []int{1, 0}
}

// A symmetric KMS key that may contain several versions of the cryptographic material.
type SymmetricKey struct {
	// ID of the key.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the key belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Time when the key was created.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the key.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the key.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the key as `key:value` pairs. Maximum 64 per key.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Current status of the key.
	Status SymmetricKey_Status `protobuf:"varint,7,opt,name=status,proto3,enum=yandex.cloud.kms.v1.SymmetricKey_Status" json:"status,omitempty"`
	// Primary version of the key, used as the default for all encrypt/decrypt operations,
	// when no version ID is specified.
	PrimaryVersion *SymmetricKeyVersion `protobuf:"bytes,8,opt,name=primary_version,json=primaryVersion,proto3" json:"primary_version,omitempty"`
	// Default encryption algorithm to be used with new versions of the key.
	DefaultAlgorithm SymmetricAlgorithm `protobuf:"varint,9,opt,name=default_algorithm,json=defaultAlgorithm,proto3,enum=yandex.cloud.kms.v1.SymmetricAlgorithm" json:"default_algorithm,omitempty"`
	// Time of the last key rotation (time when the last version was created).
	// Empty if the key does not have versions yet.
	RotatedAt *timestamp.Timestamp `protobuf:"bytes,10,opt,name=rotated_at,json=rotatedAt,proto3" json:"rotated_at,omitempty"`
	// Time period between automatic key rotations.
	RotationPeriod       *duration.Duration `protobuf:"bytes,11,opt,name=rotation_period,json=rotationPeriod,proto3" json:"rotation_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SymmetricKey) Reset()         { *m = SymmetricKey{} }
func (m *SymmetricKey) String() string { return proto.CompactTextString(m) }
func (*SymmetricKey) ProtoMessage()    {}
func (*SymmetricKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_01ef0714cb9d79e1, []int{0}
}

func (m *SymmetricKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SymmetricKey.Unmarshal(m, b)
}
func (m *SymmetricKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SymmetricKey.Marshal(b, m, deterministic)
}
func (m *SymmetricKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SymmetricKey.Merge(m, src)
}
func (m *SymmetricKey) XXX_Size() int {
	return xxx_messageInfo_SymmetricKey.Size(m)
}
func (m *SymmetricKey) XXX_DiscardUnknown() {
	xxx_messageInfo_SymmetricKey.DiscardUnknown(m)
}

var xxx_messageInfo_SymmetricKey proto.InternalMessageInfo

func (m *SymmetricKey) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SymmetricKey) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *SymmetricKey) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *SymmetricKey) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SymmetricKey) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *SymmetricKey) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *SymmetricKey) GetStatus() SymmetricKey_Status {
	if m != nil {
		return m.Status
	}
	return SymmetricKey_STATUS_UNSPECIFIED
}

func (m *SymmetricKey) GetPrimaryVersion() *SymmetricKeyVersion {
	if m != nil {
		return m.PrimaryVersion
	}
	return nil
}

func (m *SymmetricKey) GetDefaultAlgorithm() SymmetricAlgorithm {
	if m != nil {
		return m.DefaultAlgorithm
	}
	return SymmetricAlgorithm_SYMMETRIC_ALGORITHM_UNSPECIFIED
}

func (m *SymmetricKey) GetRotatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.RotatedAt
	}
	return nil
}

func (m *SymmetricKey) GetRotationPeriod() *duration.Duration {
	if m != nil {
		return m.RotationPeriod
	}
	return nil
}

// Symmetric KMS key version: metadata about actual cryptographic data.
type SymmetricKeyVersion struct {
	// ID of the key version.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the symmetric KMS key that the version belongs to.
	KeyId string `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Status of the key version.
	Status SymmetricKeyVersion_Status `protobuf:"varint,3,opt,name=status,proto3,enum=yandex.cloud.kms.v1.SymmetricKeyVersion_Status" json:"status,omitempty"`
	// Encryption algorithm that should be used when using the key version to encrypt plaintext.
	Algorithm SymmetricAlgorithm `protobuf:"varint,4,opt,name=algorithm,proto3,enum=yandex.cloud.kms.v1.SymmetricAlgorithm" json:"algorithm,omitempty"`
	// Time when the key version was created.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Indication of a primary version, that is to be used by default for all cryptographic
	// operations that don't have a key version explicitly specified.
	Primary bool `protobuf:"varint,6,opt,name=primary,proto3" json:"primary,omitempty"`
	// Time when the key version is going to be destroyed. Empty unless the status
	// is `SCHEDULED_FOR_DESTRUCTION`.
	DestroyAt            *timestamp.Timestamp `protobuf:"bytes,7,opt,name=destroy_at,json=destroyAt,proto3" json:"destroy_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SymmetricKeyVersion) Reset()         { *m = SymmetricKeyVersion{} }
func (m *SymmetricKeyVersion) String() string { return proto.CompactTextString(m) }
func (*SymmetricKeyVersion) ProtoMessage()    {}
func (*SymmetricKeyVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_01ef0714cb9d79e1, []int{1}
}

func (m *SymmetricKeyVersion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SymmetricKeyVersion.Unmarshal(m, b)
}
func (m *SymmetricKeyVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SymmetricKeyVersion.Marshal(b, m, deterministic)
}
func (m *SymmetricKeyVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SymmetricKeyVersion.Merge(m, src)
}
func (m *SymmetricKeyVersion) XXX_Size() int {
	return xxx_messageInfo_SymmetricKeyVersion.Size(m)
}
func (m *SymmetricKeyVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_SymmetricKeyVersion.DiscardUnknown(m)
}

var xxx_messageInfo_SymmetricKeyVersion proto.InternalMessageInfo

func (m *SymmetricKeyVersion) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SymmetricKeyVersion) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *SymmetricKeyVersion) GetStatus() SymmetricKeyVersion_Status {
	if m != nil {
		return m.Status
	}
	return SymmetricKeyVersion_STATUS_UNSPECIFIED
}

func (m *SymmetricKeyVersion) GetAlgorithm() SymmetricAlgorithm {
	if m != nil {
		return m.Algorithm
	}
	return SymmetricAlgorithm_SYMMETRIC_ALGORITHM_UNSPECIFIED
}

func (m *SymmetricKeyVersion) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *SymmetricKeyVersion) GetPrimary() bool {
	if m != nil {
		return m.Primary
	}
	return false
}

func (m *SymmetricKeyVersion) GetDestroyAt() *timestamp.Timestamp {
	if m != nil {
		return m.DestroyAt
	}
	return nil
}

func init() {
	proto.RegisterEnum("yandex.cloud.kms.v1.SymmetricAlgorithm", SymmetricAlgorithm_name, SymmetricAlgorithm_value)
	proto.RegisterEnum("yandex.cloud.kms.v1.SymmetricKey_Status", SymmetricKey_Status_name, SymmetricKey_Status_value)
	proto.RegisterEnum("yandex.cloud.kms.v1.SymmetricKeyVersion_Status", SymmetricKeyVersion_Status_name, SymmetricKeyVersion_Status_value)
	proto.RegisterType((*SymmetricKey)(nil), "yandex.cloud.kms.v1.SymmetricKey")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.kms.v1.SymmetricKey.LabelsEntry")
	proto.RegisterType((*SymmetricKeyVersion)(nil), "yandex.cloud.kms.v1.SymmetricKeyVersion")
}

func init() {
	proto.RegisterFile("yandex/cloud/kms/v1/symmetric_key.proto", fileDescriptor_01ef0714cb9d79e1)
}

var fileDescriptor_01ef0714cb9d79e1 = []byte{
	// 702 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x6f, 0x4f, 0xda, 0x5e,
	0x14, 0xfe, 0x95, 0x4a, 0x81, 0x83, 0x3f, 0xec, 0xae, 0xfb, 0x53, 0x59, 0x36, 0x09, 0x7b, 0x21,
	0x59, 0x62, 0x1b, 0x59, 0xb6, 0xe8, 0x7c, 0xb3, 0x0a, 0x55, 0x9b, 0x29, 0xb8, 0xb6, 0x98, 0xe8,
	0x9b, 0xae, 0xd0, 0x2b, 0x36, 0xb4, 0x94, 0xb4, 0x17, 0xb2, 0x7e, 0xb3, 0x7d, 0x9e, 0x7d, 0x92,
	0x85, 0xdb, 0x5b, 0x71, 0x68, 0xc6, 0x7c, 0xd7, 0x73, 0xee, 0xf3, 0x3c, 0xf7, 0xf4, 0x3c, 0x4f,
	0x0b, 0x3b, 0x89, 0x33, 0x76, 0xf1, 0x0f, 0x65, 0xe0, 0x87, 0x53, 0x57, 0x19, 0x05, 0xb1, 0x32,
	0xdb, 0x53, 0xe2, 0x24, 0x08, 0x30, 0x89, 0xbc, 0x81, 0x3d, 0xc2, 0x89, 0x3c, 0x89, 0x42, 0x12,
	0xa2, 0xcd, 0x14, 0x28, 0x53, 0xa0, 0x3c, 0x0a, 0x62, 0x79, 0xb6, 0x57, 0xdd, 0x1e, 0x86, 0xe1,
	0xd0, 0xc7, 0x0a, 0x85, 0xf4, 0xa7, 0x37, 0x0a, 0xf1, 0x02, 0x1c, 0x13, 0x27, 0x98, 0xa4, 0xac,
	0xea, 0xdb, 0x65, 0x80, 0x3b, 0x8d, 0x1c, 0xe2, 0x85, 0xe3, 0xf4, 0xbc, 0xfe, 0x2b, 0x0f, 0xeb,
	0x66, 0x76, 0xdb, 0x57, 0x9c, 0xa0, 0x0a, 0xe4, 0x3c, 0x57, 0xe2, 0x6a, 0x5c, 0xa3, 0x64, 0xe4,
	0x3c, 0x17, 0xbd, 0x86, 0xd2, 0x4d, 0xe8, 0xbb, 0x38, 0xb2, 0x3d, 0x57, 0xca, 0xd1, 0x76, 0x31,
	0x6d, 0xe8, 0x2e, 0x3a, 0x00, 0x18, 0x44, 0xd8, 0x21, 0xd8, 0xb5, 0x1d, 0x22, 0xf1, 0x35, 0xae,
	0x51, 0x6e, 0x56, 0xe5, 0xf4, 0x4a, 0x39, 0xbb, 0x52, 0xb6, 0xb2, 0x99, 0x8c, 0x12, 0x43, 0xab,
	0x04, 0x21, 0x58, 0x1b, 0x3b, 0x01, 0x96, 0xd6, 0xa8, 0x24, 0x7d, 0x46, 0x35, 0x28, 0xbb, 0x38,
	0x1e, 0x44, 0xde, 0x64, 0x3e, 0xa1, 0x94, 0xa7, 0x47, 0xf7, 0x5b, 0x48, 0x03, 0xc1, 0x77, 0xfa,
	0xd8, 0x8f, 0x25, 0xa1, 0xc6, 0x37, 0xca, 0xcd, 0x5d, 0xf9, 0x91, 0xad, 0xc8, 0xf7, 0x5f, 0x48,
	0x3e, 0xa3, 0x78, 0x6d, 0x4c, 0xa2, 0xc4, 0x60, 0x64, 0xf4, 0x05, 0x84, 0x98, 0x38, 0x64, 0x1a,
	0x4b, 0x85, 0x1a, 0xd7, 0xa8, 0x34, 0x1b, 0xab, 0x65, 0x4c, 0x8a, 0x37, 0x18, 0x0f, 0x7d, 0x83,
	0x8d, 0x49, 0xe4, 0x05, 0x4e, 0x94, 0xd8, 0x33, 0x1c, 0xc5, 0xf3, 0x71, 0x8b, 0xf4, 0xf5, 0x57,
	0x4b, 0x5d, 0xa6, 0x78, 0xa3, 0xc2, 0x04, 0x58, 0x8d, 0x2c, 0x78, 0xe6, 0xe2, 0x1b, 0x67, 0xea,
	0x13, 0xdb, 0xf1, 0x87, 0x61, 0xe4, 0x91, 0xdb, 0x40, 0x2a, 0xd1, 0xf9, 0x76, 0xfe, 0x2e, 0xaa,
	0x66, 0x70, 0x43, 0x64, 0x0a, 0x77, 0x9d, 0xb9, 0x45, 0x51, 0x48, 0x32, 0x8b, 0x60, 0xb5, 0x45,
	0x0c, 0xad, 0x12, 0x74, 0x04, 0x1b, 0xb4, 0xf0, 0xc2, 0xb1, 0x3d, 0xc1, 0x91, 0x17, 0xba, 0x52,
	0x99, 0xf2, 0xb7, 0x1e, 0xf0, 0xdb, 0x2c, 0x55, 0x46, 0x25, 0x63, 0x5c, 0x50, 0x42, 0xf5, 0x00,
	0xca, 0xf7, 0x0c, 0x40, 0x22, 0xf0, 0x23, 0x9c, 0xb0, 0x78, 0xcd, 0x1f, 0xd1, 0x73, 0xc8, 0xcf,
	0x1c, 0x7f, 0x8a, 0x59, 0xb6, 0xd2, 0xe2, 0x73, 0x6e, 0x9f, 0xab, 0x9f, 0x82, 0x90, 0x2e, 0x1d,
	0xbd, 0x04, 0x64, 0x5a, 0xaa, 0xd5, 0x33, 0xed, 0x5e, 0xc7, 0xbc, 0xd0, 0x5a, 0xfa, 0xb1, 0xae,
	0xb5, 0xc5, 0xff, 0xd0, 0x3a, 0x14, 0x5b, 0x86, 0xa6, 0x5a, 0x7a, 0xe7, 0x44, 0xe4, 0x10, 0x80,
	0xa0, 0xb6, 0x2c, 0xfd, 0x52, 0x13, 0x73, 0xf3, 0x13, 0xbd, 0xc3, 0x2a, 0xbe, 0xfe, 0x93, 0x87,
	0xcd, 0x47, 0x1c, 0x78, 0x90, 0xf5, 0x17, 0x20, 0x8c, 0x70, 0xb2, 0x08, 0x7a, 0x7e, 0x84, 0x13,
	0xdd, 0x45, 0x27, 0x77, 0x69, 0xe1, 0xa9, 0x1b, 0xca, 0xbf, 0x5a, 0xbc, 0x1c, 0x1a, 0x0d, 0x4a,
	0x0b, 0x67, 0xd7, 0x9e, 0xe6, 0xec, 0x82, 0xb9, 0xf4, 0xd5, 0xe5, 0x9f, 0xf2, 0xd5, 0x49, 0x50,
	0x60, 0xa9, 0x93, 0x84, 0x1a, 0xd7, 0x28, 0x1a, 0x59, 0x39, 0x17, 0x75, 0x71, 0x4c, 0xa2, 0x30,
	0x99, 0x8b, 0x16, 0x56, 0x8b, 0x32, 0xb4, 0x4a, 0xea, 0xd7, 0x2b, 0x8d, 0x5a, 0x58, 0xc3, 0xa1,
	0x37, 0xb0, 0x65, 0xb6, 0x4e, 0xb5, 0x76, 0xef, 0x4c, 0x6b, 0xdb, 0xc7, 0x5d, 0xc3, 0x6e, 0x6b,
	0xa6, 0x65, 0xf4, 0x5a, 0x96, 0xde, 0xed, 0x88, 0x39, 0xf4, 0x3f, 0x94, 0x68, 0xa3, 0x7b, 0xa5,
	0xb5, 0x45, 0xfe, 0xfd, 0x77, 0x40, 0x0f, 0x97, 0x81, 0xde, 0xc1, 0xb6, 0x79, 0x75, 0x7e, 0xae,
	0x59, 0x86, 0xde, 0xb2, 0xd5, 0xb3, 0x93, 0xae, 0xa1, 0x5b, 0xa7, 0xe7, 0x4b, 0x97, 0x96, 0xa1,
	0xa0, 0x6a, 0xa6, 0xbd, 0xd7, 0xdc, 0x17, 0xb9, 0xbb, 0xe2, 0xa0, 0x29, 0xe6, 0xb2, 0xa2, 0xf9,
	0xf1, 0x93, 0xc8, 0x1f, 0x5d, 0xc2, 0xab, 0x3f, 0x2c, 0x70, 0x26, 0x1e, 0xb3, 0xe1, 0xfa, 0x70,
	0xe8, 0x91, 0xdb, 0x69, 0x5f, 0x1e, 0x84, 0x81, 0x92, 0x62, 0x76, 0xd3, 0xdf, 0xf4, 0x30, 0xdc,
	0x1d, 0xe2, 0x31, 0xdd, 0x8a, 0xf2, 0xc8, 0xff, 0xfb, 0x70, 0x14, 0xc4, 0x7d, 0x81, 0x1e, 0x7f,
	0xf8, 0x1d, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x90, 0x72, 0x69, 0xe1, 0x05, 0x00, 0x00,
}
