// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/kms/v1/symmetric_key_service.proto

package kms

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type CreateSymmetricKeyRequest struct {
	// ID of the folder to create a symmetric KMS key in.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the key.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the key.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the symmetric KMS key as `key:value` pairs. Maximum 64 per key.
	// For example, `"project": "mvp"` or `"source": "dictionary"`.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Encryption algorithm to be used with a new key version, generated with the next rotation.
	DefaultAlgorithm SymmetricAlgorithm `protobuf:"varint,5,opt,name=default_algorithm,json=defaultAlgorithm,proto3,enum=yandex.cloud.kms.v1.SymmetricAlgorithm" json:"default_algorithm,omitempty"`
	// Interval between automatic rotations. To disable automatic rotation, don't include
	// this field in the creation request.
	RotationPeriod       *duration.Duration `protobuf:"bytes,6,opt,name=rotation_period,json=rotationPeriod,proto3" json:"rotation_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateSymmetricKeyRequest) Reset()         { *m = CreateSymmetricKeyRequest{} }
func (m *CreateSymmetricKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSymmetricKeyRequest) ProtoMessage()    {}
func (*CreateSymmetricKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{0}
}

func (m *CreateSymmetricKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSymmetricKeyRequest.Unmarshal(m, b)
}
func (m *CreateSymmetricKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSymmetricKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateSymmetricKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSymmetricKeyRequest.Merge(m, src)
}
func (m *CreateSymmetricKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSymmetricKeyRequest.Size(m)
}
func (m *CreateSymmetricKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSymmetricKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSymmetricKeyRequest proto.InternalMessageInfo

func (m *CreateSymmetricKeyRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateSymmetricKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateSymmetricKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateSymmetricKeyRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateSymmetricKeyRequest) GetDefaultAlgorithm() SymmetricAlgorithm {
	if m != nil {
		return m.DefaultAlgorithm
	}
	return SymmetricAlgorithm_SYMMETRIC_ALGORITHM_UNSPECIFIED
}

func (m *CreateSymmetricKeyRequest) GetRotationPeriod() *duration.Duration {
	if m != nil {
		return m.RotationPeriod
	}
	return nil
}

type CreateSymmetricKeyMetadata struct {
	// ID of the key being created.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the primary version of the key being created.
	PrimaryVersionId     string   `protobuf:"bytes,2,opt,name=primary_version_id,json=primaryVersionId,proto3" json:"primary_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSymmetricKeyMetadata) Reset()         { *m = CreateSymmetricKeyMetadata{} }
func (m *CreateSymmetricKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateSymmetricKeyMetadata) ProtoMessage()    {}
func (*CreateSymmetricKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{1}
}

func (m *CreateSymmetricKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSymmetricKeyMetadata.Unmarshal(m, b)
}
func (m *CreateSymmetricKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSymmetricKeyMetadata.Marshal(b, m, deterministic)
}
func (m *CreateSymmetricKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSymmetricKeyMetadata.Merge(m, src)
}
func (m *CreateSymmetricKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateSymmetricKeyMetadata.Size(m)
}
func (m *CreateSymmetricKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSymmetricKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSymmetricKeyMetadata proto.InternalMessageInfo

func (m *CreateSymmetricKeyMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *CreateSymmetricKeyMetadata) GetPrimaryVersionId() string {
	if m != nil {
		return m.PrimaryVersionId
	}
	return ""
}

type GetSymmetricKeyRequest struct {
	// ID of the symmetric KMS key to return.
	// To get the ID of a symmetric KMS key use a [SymmetricKeyService.List] request.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSymmetricKeyRequest) Reset()         { *m = GetSymmetricKeyRequest{} }
func (m *GetSymmetricKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetSymmetricKeyRequest) ProtoMessage()    {}
func (*GetSymmetricKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{2}
}

func (m *GetSymmetricKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSymmetricKeyRequest.Unmarshal(m, b)
}
func (m *GetSymmetricKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSymmetricKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetSymmetricKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSymmetricKeyRequest.Merge(m, src)
}
func (m *GetSymmetricKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetSymmetricKeyRequest.Size(m)
}
func (m *GetSymmetricKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSymmetricKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSymmetricKeyRequest proto.InternalMessageInfo

func (m *GetSymmetricKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type ListSymmetricKeysRequest struct {
	// ID of the folder to list symmetric KMS keys in.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListSymmetricKeysResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSymmetricKeysResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSymmetricKeysRequest) Reset()         { *m = ListSymmetricKeysRequest{} }
func (m *ListSymmetricKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListSymmetricKeysRequest) ProtoMessage()    {}
func (*ListSymmetricKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{3}
}

func (m *ListSymmetricKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSymmetricKeysRequest.Unmarshal(m, b)
}
func (m *ListSymmetricKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSymmetricKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListSymmetricKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSymmetricKeysRequest.Merge(m, src)
}
func (m *ListSymmetricKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListSymmetricKeysRequest.Size(m)
}
func (m *ListSymmetricKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSymmetricKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSymmetricKeysRequest proto.InternalMessageInfo

func (m *ListSymmetricKeysRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListSymmetricKeysRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSymmetricKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListSymmetricKeysResponse struct {
	// List of symmetric KMS keys in the specified folder.
	Keys []*SymmetricKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number
	// of results is greater than the specified [ListSymmetricKeysRequest.page_size], use
	// the [next_page_token] as the value for the [ListSymmetricKeysRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSymmetricKeysResponse) Reset()         { *m = ListSymmetricKeysResponse{} }
func (m *ListSymmetricKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListSymmetricKeysResponse) ProtoMessage()    {}
func (*ListSymmetricKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{4}
}

func (m *ListSymmetricKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSymmetricKeysResponse.Unmarshal(m, b)
}
func (m *ListSymmetricKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSymmetricKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListSymmetricKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSymmetricKeysResponse.Merge(m, src)
}
func (m *ListSymmetricKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListSymmetricKeysResponse.Size(m)
}
func (m *ListSymmetricKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSymmetricKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSymmetricKeysResponse proto.InternalMessageInfo

func (m *ListSymmetricKeysResponse) GetKeys() []*SymmetricKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *ListSymmetricKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListSymmetricKeyVersionsRequest struct {
	// ID of the symmetric KMS key to list versions for.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListSymmetricKeyVersionsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSymmetricKeyVersionsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSymmetricKeyVersionsRequest) Reset()         { *m = ListSymmetricKeyVersionsRequest{} }
func (m *ListSymmetricKeyVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSymmetricKeyVersionsRequest) ProtoMessage()    {}
func (*ListSymmetricKeyVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{5}
}

func (m *ListSymmetricKeyVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSymmetricKeyVersionsRequest.Unmarshal(m, b)
}
func (m *ListSymmetricKeyVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSymmetricKeyVersionsRequest.Marshal(b, m, deterministic)
}
func (m *ListSymmetricKeyVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSymmetricKeyVersionsRequest.Merge(m, src)
}
func (m *ListSymmetricKeyVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSymmetricKeyVersionsRequest.Size(m)
}
func (m *ListSymmetricKeyVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSymmetricKeyVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSymmetricKeyVersionsRequest proto.InternalMessageInfo

func (m *ListSymmetricKeyVersionsRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *ListSymmetricKeyVersionsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSymmetricKeyVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListSymmetricKeyVersionsResponse struct {
	// List of versions for the specified symmetric KMS key.
	KeyVersions []*SymmetricKeyVersion `protobuf:"bytes,1,rep,name=key_versions,json=keyVersions,proto3" json:"key_versions,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number
	// of results is greater than the specified [ListSymmetricKeyVersionsRequest.page_size], use
	// the [next_page_token] as the value for the [ListSymmetricKeyVersionsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSymmetricKeyVersionsResponse) Reset()         { *m = ListSymmetricKeyVersionsResponse{} }
func (m *ListSymmetricKeyVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSymmetricKeyVersionsResponse) ProtoMessage()    {}
func (*ListSymmetricKeyVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{6}
}

func (m *ListSymmetricKeyVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSymmetricKeyVersionsResponse.Unmarshal(m, b)
}
func (m *ListSymmetricKeyVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSymmetricKeyVersionsResponse.Marshal(b, m, deterministic)
}
func (m *ListSymmetricKeyVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSymmetricKeyVersionsResponse.Merge(m, src)
}
func (m *ListSymmetricKeyVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSymmetricKeyVersionsResponse.Size(m)
}
func (m *ListSymmetricKeyVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSymmetricKeyVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSymmetricKeyVersionsResponse proto.InternalMessageInfo

func (m *ListSymmetricKeyVersionsResponse) GetKeyVersions() []*SymmetricKeyVersion {
	if m != nil {
		return m.KeyVersions
	}
	return nil
}

func (m *ListSymmetricKeyVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type UpdateSymmetricKeyRequest struct {
	// ID of the symmetric KMS key to update.
	// To get the ID of a symmetric KMS key use a [SymmetricKeyService.List] request.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Field mask that specifies which attributes of the symmetric KMS key are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New name for the symmetric KMS key.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// New description for the symmetric KMS key.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// New status for the symmetric KMS key.
	// Using the [SymmetricKeyService.Update] method you can only set ACTIVE or INACTIVE status.
	Status SymmetricKey_Status `protobuf:"varint,5,opt,name=status,proto3,enum=yandex.cloud.kms.v1.SymmetricKey_Status" json:"status,omitempty"`
	// Custom labels for the symmetric KMS key as `key:value` pairs. Maximum 64 per key.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Default encryption algorithm to be used with new versions of the symmetric KMS key.
	DefaultAlgorithm SymmetricAlgorithm `protobuf:"varint,7,opt,name=default_algorithm,json=defaultAlgorithm,proto3,enum=yandex.cloud.kms.v1.SymmetricAlgorithm" json:"default_algorithm,omitempty"`
	// Time period between automatic symmetric KMS key rotations.
	RotationPeriod       *duration.Duration `protobuf:"bytes,8,opt,name=rotation_period,json=rotationPeriod,proto3" json:"rotation_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UpdateSymmetricKeyRequest) Reset()         { *m = UpdateSymmetricKeyRequest{} }
func (m *UpdateSymmetricKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSymmetricKeyRequest) ProtoMessage()    {}
func (*UpdateSymmetricKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{7}
}

func (m *UpdateSymmetricKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSymmetricKeyRequest.Unmarshal(m, b)
}
func (m *UpdateSymmetricKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSymmetricKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSymmetricKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSymmetricKeyRequest.Merge(m, src)
}
func (m *UpdateSymmetricKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSymmetricKeyRequest.Size(m)
}
func (m *UpdateSymmetricKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSymmetricKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSymmetricKeyRequest proto.InternalMessageInfo

func (m *UpdateSymmetricKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *UpdateSymmetricKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateSymmetricKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateSymmetricKeyRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateSymmetricKeyRequest) GetStatus() SymmetricKey_Status {
	if m != nil {
		return m.Status
	}
	return SymmetricKey_STATUS_UNSPECIFIED
}

func (m *UpdateSymmetricKeyRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateSymmetricKeyRequest) GetDefaultAlgorithm() SymmetricAlgorithm {
	if m != nil {
		return m.DefaultAlgorithm
	}
	return SymmetricAlgorithm_SYMMETRIC_ALGORITHM_UNSPECIFIED
}

func (m *UpdateSymmetricKeyRequest) GetRotationPeriod() *duration.Duration {
	if m != nil {
		return m.RotationPeriod
	}
	return nil
}

type UpdateSymmetricKeyMetadata struct {
	// ID of the key being updated.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateSymmetricKeyMetadata) Reset()         { *m = UpdateSymmetricKeyMetadata{} }
func (m *UpdateSymmetricKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateSymmetricKeyMetadata) ProtoMessage()    {}
func (*UpdateSymmetricKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{8}
}

func (m *UpdateSymmetricKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSymmetricKeyMetadata.Unmarshal(m, b)
}
func (m *UpdateSymmetricKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSymmetricKeyMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateSymmetricKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSymmetricKeyMetadata.Merge(m, src)
}
func (m *UpdateSymmetricKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateSymmetricKeyMetadata.Size(m)
}
func (m *UpdateSymmetricKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSymmetricKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSymmetricKeyMetadata proto.InternalMessageInfo

func (m *UpdateSymmetricKeyMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type DeleteSymmetricKeyRequest struct {
	// ID of the key to be deleted.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSymmetricKeyRequest) Reset()         { *m = DeleteSymmetricKeyRequest{} }
func (m *DeleteSymmetricKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSymmetricKeyRequest) ProtoMessage()    {}
func (*DeleteSymmetricKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{9}
}

func (m *DeleteSymmetricKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSymmetricKeyRequest.Unmarshal(m, b)
}
func (m *DeleteSymmetricKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSymmetricKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSymmetricKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSymmetricKeyRequest.Merge(m, src)
}
func (m *DeleteSymmetricKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSymmetricKeyRequest.Size(m)
}
func (m *DeleteSymmetricKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSymmetricKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSymmetricKeyRequest proto.InternalMessageInfo

func (m *DeleteSymmetricKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type DeleteSymmetricKeyMetadata struct {
	// ID of the key being deleted.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSymmetricKeyMetadata) Reset()         { *m = DeleteSymmetricKeyMetadata{} }
func (m *DeleteSymmetricKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteSymmetricKeyMetadata) ProtoMessage()    {}
func (*DeleteSymmetricKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{10}
}

func (m *DeleteSymmetricKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSymmetricKeyMetadata.Unmarshal(m, b)
}
func (m *DeleteSymmetricKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSymmetricKeyMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteSymmetricKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSymmetricKeyMetadata.Merge(m, src)
}
func (m *DeleteSymmetricKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteSymmetricKeyMetadata.Size(m)
}
func (m *DeleteSymmetricKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSymmetricKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSymmetricKeyMetadata proto.InternalMessageInfo

func (m *DeleteSymmetricKeyMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type SetPrimarySymmetricKeyVersionRequest struct {
	// ID of the key to set a primary version for.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the version that should become primary for the specified key.
	VersionId            string   `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetPrimarySymmetricKeyVersionRequest) Reset()         { *m = SetPrimarySymmetricKeyVersionRequest{} }
func (m *SetPrimarySymmetricKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*SetPrimarySymmetricKeyVersionRequest) ProtoMessage()    {}
func (*SetPrimarySymmetricKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{11}
}

func (m *SetPrimarySymmetricKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetPrimarySymmetricKeyVersionRequest.Unmarshal(m, b)
}
func (m *SetPrimarySymmetricKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetPrimarySymmetricKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *SetPrimarySymmetricKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetPrimarySymmetricKeyVersionRequest.Merge(m, src)
}
func (m *SetPrimarySymmetricKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_SetPrimarySymmetricKeyVersionRequest.Size(m)
}
func (m *SetPrimarySymmetricKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetPrimarySymmetricKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetPrimarySymmetricKeyVersionRequest proto.InternalMessageInfo

func (m *SetPrimarySymmetricKeyVersionRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *SetPrimarySymmetricKeyVersionRequest) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

type SetPrimarySymmetricKeyVersionMetadata struct {
	// ID of the key that the primary version if being changed for.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the version that is being made primary for the key.
	VersionId            string   `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetPrimarySymmetricKeyVersionMetadata) Reset()         { *m = SetPrimarySymmetricKeyVersionMetadata{} }
func (m *SetPrimarySymmetricKeyVersionMetadata) String() string { return proto.CompactTextString(m) }
func (*SetPrimarySymmetricKeyVersionMetadata) ProtoMessage()    {}
func (*SetPrimarySymmetricKeyVersionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{12}
}

func (m *SetPrimarySymmetricKeyVersionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetPrimarySymmetricKeyVersionMetadata.Unmarshal(m, b)
}
func (m *SetPrimarySymmetricKeyVersionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetPrimarySymmetricKeyVersionMetadata.Marshal(b, m, deterministic)
}
func (m *SetPrimarySymmetricKeyVersionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetPrimarySymmetricKeyVersionMetadata.Merge(m, src)
}
func (m *SetPrimarySymmetricKeyVersionMetadata) XXX_Size() int {
	return xxx_messageInfo_SetPrimarySymmetricKeyVersionMetadata.Size(m)
}
func (m *SetPrimarySymmetricKeyVersionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_SetPrimarySymmetricKeyVersionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_SetPrimarySymmetricKeyVersionMetadata proto.InternalMessageInfo

func (m *SetPrimarySymmetricKeyVersionMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *SetPrimarySymmetricKeyVersionMetadata) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

type RotateSymmetricKeyRequest struct {
	// ID of the key to be rotated.
	KeyId                string   `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RotateSymmetricKeyRequest) Reset()         { *m = RotateSymmetricKeyRequest{} }
func (m *RotateSymmetricKeyRequest) String() string { return proto.CompactTextString(m) }
func (*RotateSymmetricKeyRequest) ProtoMessage()    {}
func (*RotateSymmetricKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{13}
}

func (m *RotateSymmetricKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RotateSymmetricKeyRequest.Unmarshal(m, b)
}
func (m *RotateSymmetricKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RotateSymmetricKeyRequest.Marshal(b, m, deterministic)
}
func (m *RotateSymmetricKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RotateSymmetricKeyRequest.Merge(m, src)
}
func (m *RotateSymmetricKeyRequest) XXX_Size() int {
	return xxx_messageInfo_RotateSymmetricKeyRequest.Size(m)
}
func (m *RotateSymmetricKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RotateSymmetricKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RotateSymmetricKeyRequest proto.InternalMessageInfo

func (m *RotateSymmetricKeyRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

type RotateSymmetricKeyMetadata struct {
	// ID of the key being rotated.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the version generated as a result of key rotation.
	NewPrimaryVersionId  string   `protobuf:"bytes,2,opt,name=new_primary_version_id,json=newPrimaryVersionId,proto3" json:"new_primary_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RotateSymmetricKeyMetadata) Reset()         { *m = RotateSymmetricKeyMetadata{} }
func (m *RotateSymmetricKeyMetadata) String() string { return proto.CompactTextString(m) }
func (*RotateSymmetricKeyMetadata) ProtoMessage()    {}
func (*RotateSymmetricKeyMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{14}
}

func (m *RotateSymmetricKeyMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RotateSymmetricKeyMetadata.Unmarshal(m, b)
}
func (m *RotateSymmetricKeyMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RotateSymmetricKeyMetadata.Marshal(b, m, deterministic)
}
func (m *RotateSymmetricKeyMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RotateSymmetricKeyMetadata.Merge(m, src)
}
func (m *RotateSymmetricKeyMetadata) XXX_Size() int {
	return xxx_messageInfo_RotateSymmetricKeyMetadata.Size(m)
}
func (m *RotateSymmetricKeyMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RotateSymmetricKeyMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RotateSymmetricKeyMetadata proto.InternalMessageInfo

func (m *RotateSymmetricKeyMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *RotateSymmetricKeyMetadata) GetNewPrimaryVersionId() string {
	if m != nil {
		return m.NewPrimaryVersionId
	}
	return ""
}

type ScheduleSymmetricKeyVersionDestructionRequest struct {
	// ID of the key whose version should be scheduled for destruction.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the version to be destroyed.
	VersionId string `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Time interval between the version destruction request and actual destruction.
	// Default value: 7 days.
	PendingPeriod        *duration.Duration `protobuf:"bytes,3,opt,name=pending_period,json=pendingPeriod,proto3" json:"pending_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ScheduleSymmetricKeyVersionDestructionRequest) Reset() {
	*m = ScheduleSymmetricKeyVersionDestructionRequest{}
}
func (m *ScheduleSymmetricKeyVersionDestructionRequest) String() string {
	return proto.CompactTextString(m)
}
func (*ScheduleSymmetricKeyVersionDestructionRequest) ProtoMessage() {}
func (*ScheduleSymmetricKeyVersionDestructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{15}
}

func (m *ScheduleSymmetricKeyVersionDestructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionRequest.Unmarshal(m, b)
}
func (m *ScheduleSymmetricKeyVersionDestructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionRequest.Marshal(b, m, deterministic)
}
func (m *ScheduleSymmetricKeyVersionDestructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionRequest.Merge(m, src)
}
func (m *ScheduleSymmetricKeyVersionDestructionRequest) XXX_Size() int {
	return xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionRequest.Size(m)
}
func (m *ScheduleSymmetricKeyVersionDestructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionRequest proto.InternalMessageInfo

func (m *ScheduleSymmetricKeyVersionDestructionRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *ScheduleSymmetricKeyVersionDestructionRequest) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

func (m *ScheduleSymmetricKeyVersionDestructionRequest) GetPendingPeriod() *duration.Duration {
	if m != nil {
		return m.PendingPeriod
	}
	return nil
}

type ScheduleSymmetricKeyVersionDestructionMetadata struct {
	// ID of the key whose version is being scheduled for destruction.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the version that is being scheduled for destruction.
	VersionId string `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Time when the version is scheduled to be destroyed.
	DestroyAt            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=destroy_at,json=destroyAt,proto3" json:"destroy_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ScheduleSymmetricKeyVersionDestructionMetadata) Reset() {
	*m = ScheduleSymmetricKeyVersionDestructionMetadata{}
}
func (m *ScheduleSymmetricKeyVersionDestructionMetadata) String() string {
	return proto.CompactTextString(m)
}
func (*ScheduleSymmetricKeyVersionDestructionMetadata) ProtoMessage() {}
func (*ScheduleSymmetricKeyVersionDestructionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{16}
}

func (m *ScheduleSymmetricKeyVersionDestructionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionMetadata.Unmarshal(m, b)
}
func (m *ScheduleSymmetricKeyVersionDestructionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionMetadata.Marshal(b, m, deterministic)
}
func (m *ScheduleSymmetricKeyVersionDestructionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionMetadata.Merge(m, src)
}
func (m *ScheduleSymmetricKeyVersionDestructionMetadata) XXX_Size() int {
	return xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionMetadata.Size(m)
}
func (m *ScheduleSymmetricKeyVersionDestructionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleSymmetricKeyVersionDestructionMetadata proto.InternalMessageInfo

func (m *ScheduleSymmetricKeyVersionDestructionMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *ScheduleSymmetricKeyVersionDestructionMetadata) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

func (m *ScheduleSymmetricKeyVersionDestructionMetadata) GetDestroyAt() *timestamp.Timestamp {
	if m != nil {
		return m.DestroyAt
	}
	return nil
}

type CancelSymmetricKeyVersionDestructionRequest struct {
	// ID of the key to cancel a version's destruction for.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the version whose scheduled destruction should be cancelled.
	VersionId            string   `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelSymmetricKeyVersionDestructionRequest) Reset() {
	*m = CancelSymmetricKeyVersionDestructionRequest{}
}
func (m *CancelSymmetricKeyVersionDestructionRequest) String() string {
	return proto.CompactTextString(m)
}
func (*CancelSymmetricKeyVersionDestructionRequest) ProtoMessage() {}
func (*CancelSymmetricKeyVersionDestructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{17}
}

func (m *CancelSymmetricKeyVersionDestructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelSymmetricKeyVersionDestructionRequest.Unmarshal(m, b)
}
func (m *CancelSymmetricKeyVersionDestructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelSymmetricKeyVersionDestructionRequest.Marshal(b, m, deterministic)
}
func (m *CancelSymmetricKeyVersionDestructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelSymmetricKeyVersionDestructionRequest.Merge(m, src)
}
func (m *CancelSymmetricKeyVersionDestructionRequest) XXX_Size() int {
	return xxx_messageInfo_CancelSymmetricKeyVersionDestructionRequest.Size(m)
}
func (m *CancelSymmetricKeyVersionDestructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelSymmetricKeyVersionDestructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelSymmetricKeyVersionDestructionRequest proto.InternalMessageInfo

func (m *CancelSymmetricKeyVersionDestructionRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *CancelSymmetricKeyVersionDestructionRequest) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

type CancelSymmetricKeyVersionDestructionMetadata struct {
	// ID of the key whose version's destruction is being cancelled.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// ID of the version whose scheduled destruction is being cancelled.
	VersionId            string   `protobuf:"bytes,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelSymmetricKeyVersionDestructionMetadata) Reset() {
	*m = CancelSymmetricKeyVersionDestructionMetadata{}
}
func (m *CancelSymmetricKeyVersionDestructionMetadata) String() string {
	return proto.CompactTextString(m)
}
func (*CancelSymmetricKeyVersionDestructionMetadata) ProtoMessage() {}
func (*CancelSymmetricKeyVersionDestructionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{18}
}

func (m *CancelSymmetricKeyVersionDestructionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelSymmetricKeyVersionDestructionMetadata.Unmarshal(m, b)
}
func (m *CancelSymmetricKeyVersionDestructionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelSymmetricKeyVersionDestructionMetadata.Marshal(b, m, deterministic)
}
func (m *CancelSymmetricKeyVersionDestructionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelSymmetricKeyVersionDestructionMetadata.Merge(m, src)
}
func (m *CancelSymmetricKeyVersionDestructionMetadata) XXX_Size() int {
	return xxx_messageInfo_CancelSymmetricKeyVersionDestructionMetadata.Size(m)
}
func (m *CancelSymmetricKeyVersionDestructionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelSymmetricKeyVersionDestructionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CancelSymmetricKeyVersionDestructionMetadata proto.InternalMessageInfo

func (m *CancelSymmetricKeyVersionDestructionMetadata) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *CancelSymmetricKeyVersionDestructionMetadata) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

type ListSymmetricKeyOperationsRequest struct {
	// ID of the symmetric KMS key to get operations for.
	//
	// To get the key ID, use a [SymmetricKeyService.List] request.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size], the service returns a [ListSymmetricKeyOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListSymmetricKeyOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSymmetricKeyOperationsRequest) Reset()         { *m = ListSymmetricKeyOperationsRequest{} }
func (m *ListSymmetricKeyOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSymmetricKeyOperationsRequest) ProtoMessage()    {}
func (*ListSymmetricKeyOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{19}
}

func (m *ListSymmetricKeyOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSymmetricKeyOperationsRequest.Unmarshal(m, b)
}
func (m *ListSymmetricKeyOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSymmetricKeyOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListSymmetricKeyOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSymmetricKeyOperationsRequest.Merge(m, src)
}
func (m *ListSymmetricKeyOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSymmetricKeyOperationsRequest.Size(m)
}
func (m *ListSymmetricKeyOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSymmetricKeyOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSymmetricKeyOperationsRequest proto.InternalMessageInfo

func (m *ListSymmetricKeyOperationsRequest) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *ListSymmetricKeyOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSymmetricKeyOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListSymmetricKeyOperationsResponse struct {
	// List of operations for the specified key.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListSymmetricKeyOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListSymmetricKeyOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSymmetricKeyOperationsResponse) Reset()         { *m = ListSymmetricKeyOperationsResponse{} }
func (m *ListSymmetricKeyOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSymmetricKeyOperationsResponse) ProtoMessage()    {}
func (*ListSymmetricKeyOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ca66c5a96ca41ef, []int{20}
}

func (m *ListSymmetricKeyOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSymmetricKeyOperationsResponse.Unmarshal(m, b)
}
func (m *ListSymmetricKeyOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSymmetricKeyOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListSymmetricKeyOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSymmetricKeyOperationsResponse.Merge(m, src)
}
func (m *ListSymmetricKeyOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSymmetricKeyOperationsResponse.Size(m)
}
func (m *ListSymmetricKeyOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSymmetricKeyOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSymmetricKeyOperationsResponse proto.InternalMessageInfo

func (m *ListSymmetricKeyOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListSymmetricKeyOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateSymmetricKeyRequest)(nil), "yandex.cloud.kms.v1.CreateSymmetricKeyRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.kms.v1.CreateSymmetricKeyRequest.LabelsEntry")
	proto.RegisterType((*CreateSymmetricKeyMetadata)(nil), "yandex.cloud.kms.v1.CreateSymmetricKeyMetadata")
	proto.RegisterType((*GetSymmetricKeyRequest)(nil), "yandex.cloud.kms.v1.GetSymmetricKeyRequest")
	proto.RegisterType((*ListSymmetricKeysRequest)(nil), "yandex.cloud.kms.v1.ListSymmetricKeysRequest")
	proto.RegisterType((*ListSymmetricKeysResponse)(nil), "yandex.cloud.kms.v1.ListSymmetricKeysResponse")
	proto.RegisterType((*ListSymmetricKeyVersionsRequest)(nil), "yandex.cloud.kms.v1.ListSymmetricKeyVersionsRequest")
	proto.RegisterType((*ListSymmetricKeyVersionsResponse)(nil), "yandex.cloud.kms.v1.ListSymmetricKeyVersionsResponse")
	proto.RegisterType((*UpdateSymmetricKeyRequest)(nil), "yandex.cloud.kms.v1.UpdateSymmetricKeyRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.kms.v1.UpdateSymmetricKeyRequest.LabelsEntry")
	proto.RegisterType((*UpdateSymmetricKeyMetadata)(nil), "yandex.cloud.kms.v1.UpdateSymmetricKeyMetadata")
	proto.RegisterType((*DeleteSymmetricKeyRequest)(nil), "yandex.cloud.kms.v1.DeleteSymmetricKeyRequest")
	proto.RegisterType((*DeleteSymmetricKeyMetadata)(nil), "yandex.cloud.kms.v1.DeleteSymmetricKeyMetadata")
	proto.RegisterType((*SetPrimarySymmetricKeyVersionRequest)(nil), "yandex.cloud.kms.v1.SetPrimarySymmetricKeyVersionRequest")
	proto.RegisterType((*SetPrimarySymmetricKeyVersionMetadata)(nil), "yandex.cloud.kms.v1.SetPrimarySymmetricKeyVersionMetadata")
	proto.RegisterType((*RotateSymmetricKeyRequest)(nil), "yandex.cloud.kms.v1.RotateSymmetricKeyRequest")
	proto.RegisterType((*RotateSymmetricKeyMetadata)(nil), "yandex.cloud.kms.v1.RotateSymmetricKeyMetadata")
	proto.RegisterType((*ScheduleSymmetricKeyVersionDestructionRequest)(nil), "yandex.cloud.kms.v1.ScheduleSymmetricKeyVersionDestructionRequest")
	proto.RegisterType((*ScheduleSymmetricKeyVersionDestructionMetadata)(nil), "yandex.cloud.kms.v1.ScheduleSymmetricKeyVersionDestructionMetadata")
	proto.RegisterType((*CancelSymmetricKeyVersionDestructionRequest)(nil), "yandex.cloud.kms.v1.CancelSymmetricKeyVersionDestructionRequest")
	proto.RegisterType((*CancelSymmetricKeyVersionDestructionMetadata)(nil), "yandex.cloud.kms.v1.CancelSymmetricKeyVersionDestructionMetadata")
	proto.RegisterType((*ListSymmetricKeyOperationsRequest)(nil), "yandex.cloud.kms.v1.ListSymmetricKeyOperationsRequest")
	proto.RegisterType((*ListSymmetricKeyOperationsResponse)(nil), "yandex.cloud.kms.v1.ListSymmetricKeyOperationsResponse")
}

func init() {
	proto.RegisterFile("yandex/cloud/kms/v1/symmetric_key_service.proto", fileDescriptor_8ca66c5a96ca41ef)
}

var fileDescriptor_8ca66c5a96ca41ef = []byte{
	// 1611 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0xcd, 0x6f, 0x13, 0xd7,
	0x16, 0xd7, 0xc4, 0x8e, 0x1f, 0x39, 0x0e, 0x21, 0xdc, 0x04, 0x70, 0x46, 0x04, 0xcc, 0xf0, 0x1e,
	0xc9, 0x33, 0xf1, 0xd8, 0xce, 0x07, 0xef, 0x25, 0x80, 0x9a, 0x18, 0x52, 0x84, 0x80, 0x36, 0x9a,
	0x50, 0x16, 0x45, 0xc8, 0x9a, 0x78, 0x6e, 0x9c, 0x91, 0x3f, 0xc6, 0x9d, 0x3b, 0x0e, 0x38, 0xa8,
	0x6a, 0x85, 0xba, 0xca, 0xa6, 0x0b, 0x16, 0x6d, 0xd5, 0x55, 0xdb, 0x4d, 0x25, 0x2a, 0x55, 0xca,
	0xbf, 0xd0, 0x05, 0x59, 0xa7, 0xcb, 0x4a, 0x5d, 0x55, 0x6a, 0xd7, 0x5d, 0x74, 0x51, 0xa9, 0x55,
	0x35, 0xf7, 0xde, 0x71, 0xec, 0xf9, 0xb0, 0xc7, 0x20, 0x60, 0x95, 0x78, 0xee, 0x39, 0xe7, 0xfe,
	0xce, 0xef, 0x9e, 0x7b, 0xce, 0x6f, 0x6c, 0xc8, 0x34, 0xd5, 0x9a, 0x86, 0x1f, 0x65, 0x8a, 0x15,
	0xa3, 0xa1, 0x65, 0xca, 0x55, 0x92, 0xd9, 0xce, 0x65, 0x48, 0xb3, 0x5a, 0xc5, 0x96, 0xa9, 0x17,
	0x0b, 0x65, 0xdc, 0x2c, 0x10, 0x6c, 0x6e, 0xeb, 0x45, 0x2c, 0xd7, 0x4d, 0xc3, 0x32, 0xd0, 0x18,
	0x73, 0x90, 0xa9, 0x83, 0x5c, 0xae, 0x12, 0x79, 0x3b, 0x27, 0x9e, 0x2e, 0x19, 0x46, 0xa9, 0x82,
	0x33, 0x6a, 0x5d, 0xcf, 0xa8, 0xb5, 0x9a, 0x61, 0xa9, 0x96, 0x6e, 0xd4, 0x08, 0x73, 0x11, 0x93,
	0x7c, 0x95, 0x7e, 0xda, 0x68, 0x6c, 0x66, 0x36, 0x75, 0x5c, 0xd1, 0x0a, 0x55, 0x95, 0x94, 0xb9,
	0xc5, 0x59, 0xb7, 0x85, 0xa5, 0x57, 0x31, 0xb1, 0xd4, 0x6a, 0x9d, 0x1b, 0x9c, 0x71, 0x1b, 0x68,
	0x0d, 0x93, 0xee, 0xe1, 0x6c, 0xd1, 0x91, 0x86, 0x5a, 0x2c, 0x62, 0x42, 0xf8, 0x1f, 0x7f, 0x8b,
	0xba, 0x9e, 0x31, 0xea, 0xb8, 0x23, 0xc6, 0x85, 0x0e, 0x8b, 0xd6, 0xaa, 0xc7, 0x6e, 0xb2, 0xc3,
	0x6e, 0x5b, 0xad, 0xe8, 0x5a, 0xfb, 0xf2, 0x54, 0x4f, 0x46, 0x99, 0xa1, 0xf4, 0x77, 0x04, 0x26,
	0xae, 0x99, 0x58, 0xb5, 0xf0, 0xba, 0xb3, 0x7a, 0x0b, 0x37, 0x15, 0xfc, 0x41, 0x03, 0x13, 0x0b,
	0xfd, 0x17, 0x86, 0x36, 0x8d, 0x8a, 0x86, 0xcd, 0x82, 0xae, 0x25, 0x84, 0xa4, 0x30, 0x3d, 0x94,
	0x1f, 0xfe, 0xed, 0x79, 0x4e, 0xd8, 0xdd, 0xcf, 0x45, 0xaf, 0x5c, 0x5d, 0xc8, 0x2a, 0x47, 0xd8,
	0xf2, 0x4d, 0x0d, 0x4d, 0x42, 0xb4, 0xa6, 0x56, 0x71, 0x62, 0x80, 0x5a, 0x0d, 0xed, 0xee, 0xe7,
	0x06, 0xaf, 0x5c, 0xcd, 0x65, 0xb3, 0x0a, 0x7d, 0x8c, 0x66, 0x20, 0xae, 0x61, 0x52, 0x34, 0xf5,
	0xba, 0x8d, 0x32, 0x11, 0xa1, 0x56, 0xb0, 0xbb, 0x9f, 0x8b, 0xd9, 0x56, 0xb3, 0xf3, 0x4a, 0xfb,
	0x32, 0x7a, 0x2a, 0x40, 0xac, 0xa2, 0x6e, 0xe0, 0x0a, 0x49, 0x44, 0x93, 0x91, 0xe9, 0xf8, 0xec,
	0x92, 0xec, 0x73, 0xe2, 0x72, 0x20, 0x70, 0xf9, 0x36, 0x75, 0x5e, 0xad, 0x59, 0x66, 0x33, 0xff,
	0xd6, 0xef, 0xcf, 0x73, 0xf1, 0xfb, 0xe9, 0x42, 0x36, 0xbd, 0xa8, 0xa6, 0x77, 0x1e, 0xa4, 0x9e,
	0x50, 0xf0, 0x97, 0xe6, 0x59, 0x12, 0x97, 0xe6, 0xf6, 0xf6, 0x73, 0x31, 0xd1, 0xf9, 0x0f, 0xa1,
	0xd1, 0xfb, 0xb6, 0x55, 0x9b, 0xbd, 0xc2, 0xa1, 0xa0, 0xbb, 0x70, 0x5c, 0xc3, 0x9b, 0x6a, 0xa3,
	0x62, 0x15, 0xd4, 0x4a, 0xc9, 0x30, 0x75, 0x6b, 0xab, 0x9a, 0x18, 0x4c, 0x0a, 0xd3, 0x23, 0xb3,
	0x53, 0xbe, 0xf8, 0x5a, 0xc8, 0x56, 0x1c, 0x73, 0x65, 0x94, 0x47, 0x68, 0x3d, 0x41, 0x79, 0x38,
	0x66, 0xf2, 0x5a, 0x2d, 0xd4, 0xb1, 0xa9, 0x1b, 0x5a, 0x22, 0x96, 0x14, 0xa6, 0xe3, 0xb3, 0x13,
	0x32, 0xab, 0x37, 0xd9, 0xa9, 0x37, 0xf9, 0x3a, 0xaf, 0x37, 0x65, 0xc4, 0xf1, 0x58, 0xa3, 0x0e,
	0xe2, 0x22, 0xc4, 0xdb, 0x32, 0x46, 0xa3, 0x10, 0x29, 0xe3, 0x26, 0x3b, 0x30, 0xc5, 0xfe, 0x17,
	0x8d, 0xc3, 0xe0, 0xb6, 0x5a, 0x69, 0xf0, 0xe3, 0x51, 0xd8, 0x87, 0xa5, 0x81, 0xff, 0x0b, 0x92,
	0x0a, 0xa2, 0x97, 0xc6, 0x3b, 0xd8, 0x52, 0x35, 0xd5, 0x52, 0xd1, 0x09, 0x88, 0xd9, 0xb7, 0xcf,
	0x39, 0x7d, 0x65, 0xb0, 0x8c, 0x9b, 0x37, 0x35, 0x34, 0x03, 0xa8, 0x6e, 0xea, 0x55, 0xd5, 0x6c,
	0x16, 0xb6, 0xb1, 0x49, 0x6c, 0xe8, 0xba, 0xc6, 0x63, 0x8f, 0xf2, 0x95, 0x7b, 0x6c, 0xe1, 0xa6,
	0x26, 0x5d, 0x85, 0x93, 0x37, 0xb0, 0xe5, 0x57, 0x5f, 0xe7, 0x3b, 0xc3, 0xbb, 0x8a, 0x8b, 0x6d,
	0x26, 0x7d, 0x2e, 0x40, 0xe2, 0xb6, 0x4e, 0x3a, 0x02, 0x90, 0x17, 0xa8, 0xd0, 0x29, 0x18, 0xaa,
	0xab, 0x25, 0x5c, 0x20, 0xfa, 0x0e, 0xe3, 0x21, 0x92, 0x87, 0x3f, 0x9f, 0xb3, 0x02, 0xcc, 0x66,
	0x95, 0x23, 0xf6, 0xe2, 0xba, 0xbe, 0x83, 0xd1, 0x34, 0x00, 0x35, 0xb4, 0x8c, 0x32, 0x76, 0x4a,
	0xb5, 0xad, 0xa0, 0x69, 0x94, 0xbb, 0xf6, 0x9a, 0xb4, 0x03, 0x13, 0x3e, 0xc8, 0x48, 0xdd, 0xa8,
	0x11, 0x8c, 0x16, 0x20, 0x5a, 0xc6, 0x4d, 0x92, 0x10, 0x68, 0x05, 0x9f, 0xeb, 0x5e, 0x21, 0x36,
	0x29, 0xd4, 0x1c, 0x5d, 0x80, 0x63, 0x35, 0xfc, 0xc8, 0x2a, 0xb4, 0x41, 0x60, 0xc4, 0x1e, 0xb5,
	0x1f, 0xaf, 0xb5, 0xf6, 0xfe, 0x42, 0x80, 0xb3, 0xee, 0xcd, 0x39, 0xe7, 0xa4, 0x1f, 0x7e, 0x5f,
	0x05, 0x2f, 0x9f, 0x09, 0x90, 0x0c, 0xc6, 0xc6, 0xf9, 0xb9, 0x05, 0xc3, 0x36, 0x38, 0x5e, 0x40,
	0x0e, 0x4f, 0xd3, 0x3d, 0x79, 0xe2, 0x81, 0x94, 0x78, 0xf9, 0x30, 0x68, 0x68, 0xd6, 0xfe, 0x8a,
	0xc2, 0xc4, 0x7b, 0x75, 0x2d, 0xa0, 0xdf, 0x85, 0xe2, 0x6b, 0x05, 0xe2, 0x0d, 0x1a, 0x81, 0x0e,
	0x0f, 0xba, 0x4d, 0x7c, 0x56, 0xf4, 0x5c, 0xd6, 0xb7, 0xed, 0xf9, 0x72, 0x47, 0x25, 0xe5, 0x7c,
	0xd4, 0x8e, 0xa2, 0x00, 0x73, 0xb2, 0x9f, 0xb4, 0x9a, 0x65, 0x24, 0x54, 0xb3, 0x8c, 0x76, 0x6f,
	0x96, 0xcb, 0x10, 0x23, 0x96, 0x6a, 0x35, 0x08, 0xef, 0x45, 0xbd, 0x19, 0x94, 0xd7, 0xa9, 0xbd,
	0xc2, 0xfd, 0xda, 0xdb, 0x6d, 0xac, 0x4b, 0xbb, 0x0d, 0xe4, 0xed, 0x35, 0xb6, 0xdb, 0x7f, 0xbd,
	0x82, 0x76, 0x7b, 0xe4, 0x35, 0xb6, 0xdb, 0x39, 0x10, 0xbd, 0x34, 0xf6, 0x68, 0xb7, 0xd2, 0x32,
	0x4c, 0x5c, 0xc7, 0x15, 0xfc, 0xe2, 0x35, 0x6b, 0x6f, 0xeb, 0x8d, 0xd0, 0x6b, 0xdb, 0x47, 0xf0,
	0xef, 0x75, 0x6c, 0xad, 0xb1, 0x76, 0xee, 0x77, 0x03, 0xfb, 0xb9, 0x35, 0x17, 0x01, 0xdc, 0xa3,
	0xc2, 0x65, 0x38, 0xb4, 0xdd, 0x9a, 0x18, 0x0f, 0xe0, 0x3f, 0x5d, 0x77, 0xee, 0x35, 0x9f, 0x26,
	0xbd, 0x9b, 0xb5, 0x87, 0x5f, 0x86, 0x09, 0xc5, 0x3e, 0xd1, 0x17, 0xe7, 0x73, 0x0b, 0x44, 0x6f,
	0x84, 0x5e, 0xa8, 0xe6, 0xe0, 0x64, 0x0d, 0x3f, 0x2c, 0x04, 0x4e, 0xce, 0xb1, 0x1a, 0x7e, 0xb8,
	0xe6, 0x1e, 0x9e, 0x3f, 0x08, 0x90, 0x5e, 0x2f, 0x6e, 0x61, 0xad, 0x51, 0xc1, 0x3e, 0x4c, 0x5c,
	0xc7, 0xc4, 0x32, 0x1b, 0x45, 0xeb, 0x55, 0x1e, 0x07, 0x5a, 0x86, 0x91, 0x3a, 0xae, 0x69, 0x7a,
	0xad, 0xe4, 0x5c, 0x99, 0x48, 0xaf, 0x2b, 0x73, 0x94, 0x3b, 0xb0, 0x1b, 0x23, 0x7d, 0x25, 0x80,
	0x1c, 0x2e, 0x8b, 0x97, 0x3b, 0x5a, 0xb4, 0x08, 0xa0, 0xd9, 0xc1, 0x8c, 0x66, 0x41, 0xb5, 0x38,
	0x4c, 0x6f, 0x6f, 0xbe, 0xeb, 0x28, 0x7b, 0x65, 0x88, 0x5b, 0xaf, 0x58, 0xd2, 0x47, 0x70, 0xf1,
	0x9a, 0x5a, 0x2b, 0xe2, 0xca, 0x1b, 0xa2, 0x59, 0xd2, 0x60, 0x26, 0x0c, 0x80, 0x97, 0x2c, 0xfe,
	0x2f, 0x05, 0x38, 0xe7, 0x9e, 0xcd, 0xef, 0x3a, 0x6f, 0x17, 0x6f, 0x5c, 0x39, 0x7c, 0x2a, 0x80,
	0xd4, 0x0d, 0x1d, 0xd7, 0x0e, 0x2b, 0x00, 0xad, 0x37, 0xa2, 0x00, 0x85, 0x75, 0xf8, 0xc6, 0xd4,
	0xf2, 0x57, 0xda, 0x9c, 0xc2, 0x2a, 0x86, 0xd9, 0x3f, 0xc6, 0x61, 0xac, 0x1d, 0xcd, 0x3a, 0x7b,
	0x13, 0x45, 0x5f, 0x0b, 0x10, 0x63, 0xca, 0x19, 0xc9, 0xfd, 0xbd, 0x9d, 0x88, 0xbd, 0x91, 0x4a,
	0xab, 0x7b, 0x07, 0xa9, 0x54, 0x57, 0x69, 0x3e, 0xdc, 0xfe, 0xf4, 0xc9, 0x8f, 0xbf, 0x3c, 0x1d,
	0x38, 0x2e, 0x0d, 0x3b, 0xaf, 0x7a, 0xb6, 0x92, 0x5c, 0x12, 0x52, 0xc8, 0x82, 0xc8, 0x0d, 0x6c,
	0xa1, 0x8b, 0xbe, 0x00, 0xfd, 0x45, 0xb9, 0xd8, 0x5b, 0xa9, 0x4a, 0x93, 0x74, 0xbf, 0x53, 0xe8,
	0x44, 0xfb, 0x7e, 0x99, 0xc7, 0xac, 0x62, 0x3e, 0x44, 0x8f, 0x21, 0x6a, 0x9f, 0x21, 0x4a, 0xfb,
	0x46, 0x0a, 0xd2, 0xf2, 0xa2, 0x1c, 0xd6, 0x9c, 0x15, 0x81, 0x34, 0x4e, 0x51, 0x8c, 0xa0, 0x8e,
	0xac, 0xd1, 0x37, 0x02, 0x0c, 0xdb, 0x3e, 0x2d, 0x69, 0x38, 0x1f, 0x2a, 0xac, 0x4b, 0x3a, 0x8b,
	0x0b, 0x7d, 0x7a, 0x71, 0x4c, 0x17, 0x28, 0xa6, 0x24, 0x3a, 0xe3, 0xcb, 0x4c, 0xc6, 0x11, 0xbb,
	0xe8, 0x99, 0x00, 0x31, 0x26, 0x04, 0x02, 0xaa, 0x27, 0x50, 0x6c, 0x85, 0xa9, 0x9e, 0x77, 0x58,
	0xf5, 0x74, 0x51, 0x1a, 0xde, 0xea, 0x11, 0x67, 0xfd, 0x4f, 0xd3, 0x2e, 0xa3, 0x6f, 0x05, 0x88,
	0x31, 0xfd, 0x10, 0x80, 0x36, 0x50, 0x9e, 0x84, 0x41, 0x7b, 0x8b, 0xa1, 0xed, 0x22, 0x50, 0xbc,
	0x68, 0x4f, 0xa5, 0x02, 0x6a, 0xef, 0x67, 0x01, 0x8e, 0x1f, 0x6a, 0x07, 0x7e, 0x3e, 0x68, 0xd1,
	0xbf, 0xa6, 0x43, 0xa8, 0x9b, 0x30, 0x09, 0x94, 0xf7, 0x0e, 0x52, 0x0b, 0x61, 0x25, 0x8b, 0x37,
	0x97, 0x19, 0x69, 0xca, 0x9f, 0x79, 0xe2, 0xce, 0xc3, 0x3e, 0x8b, 0xdd, 0x01, 0x10, 0x9d, 0x51,
	0xea, 0x1d, 0x0e, 0x28, 0xef, 0x9f, 0x69, 0x3f, 0x0a, 0x22, 0x4c, 0xca, 0x9f, 0x08, 0x7b, 0x07,
	0xa9, 0xd5, 0xbe, 0x87, 0xfa, 0x98, 0x8f, 0x1d, 0xe5, 0x60, 0x41, 0xca, 0x06, 0x70, 0x10, 0x98,
	0xaa, 0x4d, 0xc6, 0x93, 0x01, 0x48, 0xb0, 0x99, 0xe9, 0x43, 0xc5, 0xb2, 0x7f, 0x5b, 0x0e, 0x3f,
	0xe3, 0xc3, 0x10, 0xf1, 0xb1, 0x4d, 0xc4, 0xb5, 0x3e, 0x27, 0x77, 0x20, 0x0d, 0x73, 0x92, 0xec,
	0x4f, 0x43, 0x31, 0x20, 0x49, 0x9b, 0x84, 0xef, 0x05, 0x88, 0x31, 0x35, 0x1a, 0x70, 0x3b, 0x03,
	0xc5, 0x6e, 0x98, 0x04, 0x15, 0x76, 0x3b, 0xbb, 0xc8, 0x5d, 0x6f, 0x45, 0x9f, 0x91, 0x4e, 0xfb,
	0xa7, 0x61, 0x32, 0x98, 0xcf, 0x04, 0x18, 0xb1, 0x5b, 0xe9, 0xe1, 0x64, 0x47, 0x97, 0x42, 0xf5,
	0x5b, 0x8f, 0x50, 0x11, 0xff, 0xd7, 0xb7, 0x1f, 0xef, 0xd4, 0xd3, 0x14, 0xa9, 0x84, 0x92, 0xfe,
	0x9d, 0xba, 0x4d, 0x29, 0x7c, 0x27, 0x00, 0xb2, 0x03, 0xae, 0xd0, 0xaf, 0x72, 0xf3, 0x3a, 0x15,
	0xb6, 0xc4, 0xcd, 0x35, 0xff, 0xa2, 0xd7, 0x6b, 0xe8, 0x20, 0xcd, 0x84, 0xb6, 0xe7, 0x08, 0x17,
	0x28, 0xc2, 0x0c, 0x4a, 0x77, 0x22, 0x34, 0x31, 0x31, 0x1a, 0x66, 0x11, 0x53, 0x42, 0x2b, 0x5e,
	0x5c, 0x3f, 0xb1, 0x0e, 0xe8, 0x7a, 0x9a, 0xf6, 0xdd, 0xdd, 0x63, 0xd7, 0x47, 0x61, 0x58, 0x7b,
	0x07, 0xa9, 0x45, 0x48, 0x06, 0x45, 0x3a, 0x94, 0xa9, 0x6e, 0xf5, 0xbd, 0x5a, 0xad, 0x5b, 0xac,
	0x4e, 0x72, 0xd2, 0x4c, 0x97, 0xdc, 0x88, 0x3b, 0xa4, 0x5d, 0xec, 0xbf, 0x0a, 0x30, 0xce, 0xe6,
	0x9a, 0x2b, 0xc1, 0xac, 0x6f, 0x82, 0x7e, 0xa6, 0x7d, 0xe4, 0xb8, 0xb3, 0x77, 0x90, 0xba, 0x02,
	0xe7, 0xbb, 0x04, 0x0b, 0x93, 0xe6, 0xbc, 0x94, 0xe9, 0x92, 0x66, 0xc3, 0x27, 0xea, 0x92, 0x90,
	0xca, 0xdf, 0x83, 0x53, 0x9d, 0x19, 0xd5, 0x75, 0x5e, 0xde, 0xef, 0x5f, 0x2e, 0xe9, 0xd6, 0x56,
	0x63, 0x43, 0x2e, 0x1a, 0x55, 0xfe, 0xdb, 0x49, 0x9a, 0x7d, 0xd3, 0x5f, 0x32, 0xd2, 0x25, 0x5c,
	0xa3, 0x10, 0xfc, 0x7e, 0x54, 0xb9, 0x5c, 0xae, 0x92, 0x8d, 0x18, 0x5d, 0x9e, 0xfb, 0x27, 0x00,
	0x00, 0xff, 0xff, 0xc8, 0x72, 0x44, 0x01, 0x76, 0x19, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SymmetricKeyServiceClient is the client API for SymmetricKeyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SymmetricKeyServiceClient interface {
	// Creates a symmetric KMS key in the specified folder.
	Create(ctx context.Context, in *CreateSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the specified symmetric KMS key.
	//
	//  To get the list of available symmetric KMS keys, make a [SymmetricKeyService.List] request.
	Get(ctx context.Context, in *GetSymmetricKeyRequest, opts ...grpc.CallOption) (*SymmetricKey, error)
	// Returns the list of symmetric KMS keys in the specified folder.
	List(ctx context.Context, in *ListSymmetricKeysRequest, opts ...grpc.CallOption) (*ListSymmetricKeysResponse, error)
	// Returns the list of versions of the specified symmetric KMS key.
	ListVersions(ctx context.Context, in *ListSymmetricKeyVersionsRequest, opts ...grpc.CallOption) (*ListSymmetricKeyVersionsResponse, error)
	// Updates the specified symmetric KMS key.
	Update(ctx context.Context, in *UpdateSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified symmetric KMS key. This action also automatically schedules
	// the destruction of all of the key's versions in 72 hours.
	//
	// The key and its versions appear absent in [SymmetricKeyService.Get] and [SymmetricKeyService.List]
	// requests, but can be restored within 72 hours with a request to tech support.
	Delete(ctx context.Context, in *DeleteSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Sets the primary version for the specified key. The primary version is used
	// by default for all encrypt/decrypt operations where no version ID is specified.
	SetPrimaryVersion(ctx context.Context, in *SetPrimarySymmetricKeyVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Schedules the specified key version for destruction.
	//
	// Scheduled destruction can be cancelled with the [SymmetricKeyService.CancelVersionDestruction] method.
	ScheduleVersionDestruction(ctx context.Context, in *ScheduleSymmetricKeyVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Cancels previously scheduled version destruction, if the version hasn't been destroyed yet.
	CancelVersionDestruction(ctx context.Context, in *CancelSymmetricKeyVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Rotates the specified key: creates a new key version and makes it the primary version.
	// The old version remains available for decryption of ciphertext encrypted with it.
	Rotate(ctx context.Context, in *RotateSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified symmetric KMS key.
	ListOperations(ctx context.Context, in *ListSymmetricKeyOperationsRequest, opts ...grpc.CallOption) (*ListSymmetricKeyOperationsResponse, error)
	// Lists existing access bindings for the specified key.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the key.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified key.
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type symmetricKeyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSymmetricKeyServiceClient(cc grpc.ClientConnInterface) SymmetricKeyServiceClient {
	return &symmetricKeyServiceClient{cc}
}

func (c *symmetricKeyServiceClient) Create(ctx context.Context, in *CreateSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) Get(ctx context.Context, in *GetSymmetricKeyRequest, opts ...grpc.CallOption) (*SymmetricKey, error) {
	out := new(SymmetricKey)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) List(ctx context.Context, in *ListSymmetricKeysRequest, opts ...grpc.CallOption) (*ListSymmetricKeysResponse, error) {
	out := new(ListSymmetricKeysResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) ListVersions(ctx context.Context, in *ListSymmetricKeyVersionsRequest, opts ...grpc.CallOption) (*ListSymmetricKeyVersionsResponse, error) {
	out := new(ListSymmetricKeyVersionsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/ListVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) Update(ctx context.Context, in *UpdateSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) Delete(ctx context.Context, in *DeleteSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) SetPrimaryVersion(ctx context.Context, in *SetPrimarySymmetricKeyVersionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/SetPrimaryVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) ScheduleVersionDestruction(ctx context.Context, in *ScheduleSymmetricKeyVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/ScheduleVersionDestruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) CancelVersionDestruction(ctx context.Context, in *CancelSymmetricKeyVersionDestructionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/CancelVersionDestruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) Rotate(ctx context.Context, in *RotateSymmetricKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/Rotate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) ListOperations(ctx context.Context, in *ListSymmetricKeyOperationsRequest, opts ...grpc.CallOption) (*ListSymmetricKeyOperationsResponse, error) {
	out := new(ListSymmetricKeyOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/ListAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/SetAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *symmetricKeyServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.kms.v1.SymmetricKeyService/UpdateAccessBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SymmetricKeyServiceServer is the server API for SymmetricKeyService service.
type SymmetricKeyServiceServer interface {
	// Creates a symmetric KMS key in the specified folder.
	Create(context.Context, *CreateSymmetricKeyRequest) (*operation.Operation, error)
	// Returns the specified symmetric KMS key.
	//
	//  To get the list of available symmetric KMS keys, make a [SymmetricKeyService.List] request.
	Get(context.Context, *GetSymmetricKeyRequest) (*SymmetricKey, error)
	// Returns the list of symmetric KMS keys in the specified folder.
	List(context.Context, *ListSymmetricKeysRequest) (*ListSymmetricKeysResponse, error)
	// Returns the list of versions of the specified symmetric KMS key.
	ListVersions(context.Context, *ListSymmetricKeyVersionsRequest) (*ListSymmetricKeyVersionsResponse, error)
	// Updates the specified symmetric KMS key.
	Update(context.Context, *UpdateSymmetricKeyRequest) (*operation.Operation, error)
	// Deletes the specified symmetric KMS key. This action also automatically schedules
	// the destruction of all of the key's versions in 72 hours.
	//
	// The key and its versions appear absent in [SymmetricKeyService.Get] and [SymmetricKeyService.List]
	// requests, but can be restored within 72 hours with a request to tech support.
	Delete(context.Context, *DeleteSymmetricKeyRequest) (*operation.Operation, error)
	// Sets the primary version for the specified key. The primary version is used
	// by default for all encrypt/decrypt operations where no version ID is specified.
	SetPrimaryVersion(context.Context, *SetPrimarySymmetricKeyVersionRequest) (*operation.Operation, error)
	// Schedules the specified key version for destruction.
	//
	// Scheduled destruction can be cancelled with the [SymmetricKeyService.CancelVersionDestruction] method.
	ScheduleVersionDestruction(context.Context, *ScheduleSymmetricKeyVersionDestructionRequest) (*operation.Operation, error)
	// Cancels previously scheduled version destruction, if the version hasn't been destroyed yet.
	CancelVersionDestruction(context.Context, *CancelSymmetricKeyVersionDestructionRequest) (*operation.Operation, error)
	// Rotates the specified key: creates a new key version and makes it the primary version.
	// The old version remains available for decryption of ciphertext encrypted with it.
	Rotate(context.Context, *RotateSymmetricKeyRequest) (*operation.Operation, error)
	// Lists operations for the specified symmetric KMS key.
	ListOperations(context.Context, *ListSymmetricKeyOperationsRequest) (*ListSymmetricKeyOperationsResponse, error)
	// Lists existing access bindings for the specified key.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Sets access bindings for the key.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified key.
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
}

// UnimplementedSymmetricKeyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSymmetricKeyServiceServer struct {
}

func (*UnimplementedSymmetricKeyServiceServer) Create(ctx context.Context, req *CreateSymmetricKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) Get(ctx context.Context, req *GetSymmetricKeyRequest) (*SymmetricKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) List(ctx context.Context, req *ListSymmetricKeysRequest) (*ListSymmetricKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) ListVersions(ctx context.Context, req *ListSymmetricKeyVersionsRequest) (*ListSymmetricKeyVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) Update(ctx context.Context, req *UpdateSymmetricKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) Delete(ctx context.Context, req *DeleteSymmetricKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) SetPrimaryVersion(ctx context.Context, req *SetPrimarySymmetricKeyVersionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetPrimaryVersion not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) ScheduleVersionDestruction(ctx context.Context, req *ScheduleSymmetricKeyVersionDestructionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScheduleVersionDestruction not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) CancelVersionDestruction(ctx context.Context, req *CancelSymmetricKeyVersionDestructionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelVersionDestruction not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) Rotate(ctx context.Context, req *RotateSymmetricKeyRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rotate not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) ListOperations(ctx context.Context, req *ListSymmetricKeyOperationsRequest) (*ListSymmetricKeyOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) ListAccessBindings(ctx context.Context, req *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) SetAccessBindings(ctx context.Context, req *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (*UnimplementedSymmetricKeyServiceServer) UpdateAccessBindings(ctx context.Context, req *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}

func RegisterSymmetricKeyServiceServer(s *grpc.Server, srv SymmetricKeyServiceServer) {
	s.RegisterService(&_SymmetricKeyService_serviceDesc, srv)
}

func _SymmetricKeyService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSymmetricKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).Create(ctx, req.(*CreateSymmetricKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSymmetricKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).Get(ctx, req.(*GetSymmetricKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSymmetricKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).List(ctx, req.(*ListSymmetricKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSymmetricKeyVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).ListVersions(ctx, req.(*ListSymmetricKeyVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSymmetricKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).Update(ctx, req.(*UpdateSymmetricKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSymmetricKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).Delete(ctx, req.(*DeleteSymmetricKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_SetPrimaryVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetPrimarySymmetricKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).SetPrimaryVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/SetPrimaryVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).SetPrimaryVersion(ctx, req.(*SetPrimarySymmetricKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_ScheduleVersionDestruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleSymmetricKeyVersionDestructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).ScheduleVersionDestruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/ScheduleVersionDestruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).ScheduleVersionDestruction(ctx, req.(*ScheduleSymmetricKeyVersionDestructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_CancelVersionDestruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelSymmetricKeyVersionDestructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).CancelVersionDestruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/CancelVersionDestruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).CancelVersionDestruction(ctx, req.(*CancelSymmetricKeyVersionDestructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_Rotate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RotateSymmetricKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).Rotate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/Rotate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).Rotate(ctx, req.(*RotateSymmetricKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSymmetricKeyOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).ListOperations(ctx, req.(*ListSymmetricKeyOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/ListAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/SetAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SymmetricKeyService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SymmetricKeyServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.kms.v1.SymmetricKeyService/UpdateAccessBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SymmetricKeyServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SymmetricKeyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.kms.v1.SymmetricKeyService",
	HandlerType: (*SymmetricKeyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _SymmetricKeyService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SymmetricKeyService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SymmetricKeyService_List_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _SymmetricKeyService_ListVersions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SymmetricKeyService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SymmetricKeyService_Delete_Handler,
		},
		{
			MethodName: "SetPrimaryVersion",
			Handler:    _SymmetricKeyService_SetPrimaryVersion_Handler,
		},
		{
			MethodName: "ScheduleVersionDestruction",
			Handler:    _SymmetricKeyService_ScheduleVersionDestruction_Handler,
		},
		{
			MethodName: "CancelVersionDestruction",
			Handler:    _SymmetricKeyService_CancelVersionDestruction_Handler,
		},
		{
			MethodName: "Rotate",
			Handler:    _SymmetricKeyService_Rotate_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _SymmetricKeyService_ListOperations_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _SymmetricKeyService_ListAccessBindings_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _SymmetricKeyService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _SymmetricKeyService_UpdateAccessBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/kms/v1/symmetric_key_service.proto",
}
