// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/clickhouse/v1/cluster.proto

package clickhouse

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/clickhouse/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Deployment environment.
type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}

var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}

func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}

func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{0, 2}
}

type Host_Type int32

const (
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// ClickHouse host.
	Host_CLICKHOUSE Host_Type = 1
	// ZooKeeper host.
	Host_ZOOKEEPER Host_Type = 2
)

var Host_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CLICKHOUSE",
	2: "ZOOKEEPER",
}

var Host_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"CLICKHOUSE":       1,
	"ZOOKEEPER":        2,
}

func (x Host_Type) String() string {
	return proto.EnumName(Host_Type_name, int32(x))
}

func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{6, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Host_Health_value = map[string]int32{
	"UNKNOWN":  0,
	"ALIVE":    1,
	"DEAD":     2,
	"DEGRADED": 3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}

func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{6, 1}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a ClickHouse server.
	Service_CLICKHOUSE Service_Type = 1
	// The host is a ZooKeeper server.
	Service_ZOOKEEPER Service_Type = 2
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "CLICKHOUSE",
	2: "ZOOKEEPER",
}

var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"CLICKHOUSE":       1,
	"ZOOKEEPER":        2,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}

func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{7, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}

var Service_Health_value = map[string]int32{
	"UNKNOWN": 0,
	"ALIVE":   1,
	"DEAD":    2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}

func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{7, 1}
}

// A ClickHouse Cluster resource. For more information, see the
// [Cluster](/docs/managed-clickhouse/concepts) section in the Developer's Guide.
type Cluster struct {
	// ID of the ClickHouse cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the ClickHouse cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the ClickHouse cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the ClickHouse cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the ClickHouse cluster as `key:value` pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the ClickHouse cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the ClickHouse cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the ClickHouse cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Cluster_Status" json:"status,omitempty"`
	// ID of the service account used for access to Yandex Object Storage.
	ServiceAccountId     string   `protobuf:"bytes,13,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (m *Cluster) GetServiceAccountId() string {
	if m != nil {
		return m.ServiceAccountId
	}
	return ""
}

// Monitoring system metadata.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the ClickHouse cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{1}
}

func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (m *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(m, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of the ClickHouse server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration and resource allocation for ClickHouse hosts.
	Clickhouse *ClusterConfig_Clickhouse `protobuf:"bytes,2,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	// Configuration and resource allocation for ZooKeeper hosts.
	Zookeeper *ClusterConfig_Zookeeper `protobuf:"bytes,3,opt,name=zookeeper,proto3" json:"zookeeper,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,5,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{2}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ClusterConfig) GetClickhouse() *ClusterConfig_Clickhouse {
	if m != nil {
		return m.Clickhouse
	}
	return nil
}

func (m *ClusterConfig) GetZookeeper() *ClusterConfig_Zookeeper {
	if m != nil {
		return m.Zookeeper
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ClusterConfig) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

type ClusterConfig_Clickhouse struct {
	// Configuration settings of a ClickHouse server.
	Config *config.ClickhouseConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to ClickHouse hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ClusterConfig_Clickhouse) Reset()         { *m = ClusterConfig_Clickhouse{} }
func (m *ClusterConfig_Clickhouse) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig_Clickhouse) ProtoMessage()    {}
func (*ClusterConfig_Clickhouse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{2, 0}
}

func (m *ClusterConfig_Clickhouse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig_Clickhouse.Unmarshal(m, b)
}
func (m *ClusterConfig_Clickhouse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig_Clickhouse.Marshal(b, m, deterministic)
}
func (m *ClusterConfig_Clickhouse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig_Clickhouse.Merge(m, src)
}
func (m *ClusterConfig_Clickhouse) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig_Clickhouse.Size(m)
}
func (m *ClusterConfig_Clickhouse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig_Clickhouse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig_Clickhouse proto.InternalMessageInfo

func (m *ClusterConfig_Clickhouse) GetConfig() *config.ClickhouseConfigSet {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ClusterConfig_Clickhouse) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type ClusterConfig_Zookeeper struct {
	// Resources allocated to ZooKeeper hosts.
	Resources            *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ClusterConfig_Zookeeper) Reset()         { *m = ClusterConfig_Zookeeper{} }
func (m *ClusterConfig_Zookeeper) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig_Zookeeper) ProtoMessage()    {}
func (*ClusterConfig_Zookeeper) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{2, 1}
}

func (m *ClusterConfig_Zookeeper) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig_Zookeeper.Unmarshal(m, b)
}
func (m *ClusterConfig_Zookeeper) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig_Zookeeper.Marshal(b, m, deterministic)
}
func (m *ClusterConfig_Zookeeper) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig_Zookeeper.Merge(m, src)
}
func (m *ClusterConfig_Zookeeper) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig_Zookeeper.Size(m)
}
func (m *ClusterConfig_Zookeeper) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig_Zookeeper.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig_Zookeeper proto.InternalMessageInfo

func (m *ClusterConfig_Zookeeper) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Shard struct {
	// Name of the shard.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configuration of the shard.
	Config               *ShardConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{3}
}

func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (m *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(m, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Shard) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Shard) GetConfig() *ShardConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

type ShardGroup struct {
	// Name of the shard group
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Description of the ClickHouse cluster shard group. 0-256 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// List of shard names contained in shard group
	ShardNames           []string `protobuf:"bytes,4,rep,name=shard_names,json=shardNames,proto3" json:"shard_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShardGroup) Reset()         { *m = ShardGroup{} }
func (m *ShardGroup) String() string { return proto.CompactTextString(m) }
func (*ShardGroup) ProtoMessage()    {}
func (*ShardGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{4}
}

func (m *ShardGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardGroup.Unmarshal(m, b)
}
func (m *ShardGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardGroup.Marshal(b, m, deterministic)
}
func (m *ShardGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardGroup.Merge(m, src)
}
func (m *ShardGroup) XXX_Size() int {
	return xxx_messageInfo_ShardGroup.Size(m)
}
func (m *ShardGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ShardGroup proto.InternalMessageInfo

func (m *ShardGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ShardGroup) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ShardGroup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ShardGroup) GetShardNames() []string {
	if m != nil {
		return m.ShardNames
	}
	return nil
}

type ShardConfig struct {
	// ClickHouse configuration for a shard.
	Clickhouse           *ShardConfig_Clickhouse `protobuf:"bytes,1,opt,name=clickhouse,proto3" json:"clickhouse,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ShardConfig) Reset()         { *m = ShardConfig{} }
func (m *ShardConfig) String() string { return proto.CompactTextString(m) }
func (*ShardConfig) ProtoMessage()    {}
func (*ShardConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{5}
}

func (m *ShardConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardConfig.Unmarshal(m, b)
}
func (m *ShardConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardConfig.Marshal(b, m, deterministic)
}
func (m *ShardConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardConfig.Merge(m, src)
}
func (m *ShardConfig) XXX_Size() int {
	return xxx_messageInfo_ShardConfig.Size(m)
}
func (m *ShardConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShardConfig proto.InternalMessageInfo

func (m *ShardConfig) GetClickhouse() *ShardConfig_Clickhouse {
	if m != nil {
		return m.Clickhouse
	}
	return nil
}

type ShardConfig_Clickhouse struct {
	// ClickHouse settings for a shard.
	Config *config.ClickhouseConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Computational resources for a shard.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Relative weight of a shard considered when writing data to the cluster.
	// For details, see [ClickHouse documentation](https://clickhouse.yandex/docs/en/operations/table_engines/distributed/).
	Weight               *wrappers.Int64Value `protobuf:"bytes,3,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ShardConfig_Clickhouse) Reset()         { *m = ShardConfig_Clickhouse{} }
func (m *ShardConfig_Clickhouse) String() string { return proto.CompactTextString(m) }
func (*ShardConfig_Clickhouse) ProtoMessage()    {}
func (*ShardConfig_Clickhouse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{5, 0}
}

func (m *ShardConfig_Clickhouse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardConfig_Clickhouse.Unmarshal(m, b)
}
func (m *ShardConfig_Clickhouse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardConfig_Clickhouse.Marshal(b, m, deterministic)
}
func (m *ShardConfig_Clickhouse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardConfig_Clickhouse.Merge(m, src)
}
func (m *ShardConfig_Clickhouse) XXX_Size() int {
	return xxx_messageInfo_ShardConfig_Clickhouse.Size(m)
}
func (m *ShardConfig_Clickhouse) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardConfig_Clickhouse.DiscardUnknown(m)
}

var xxx_messageInfo_ShardConfig_Clickhouse proto.InternalMessageInfo

func (m *ShardConfig_Clickhouse) GetConfig() *config.ClickhouseConfigSet {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ShardConfig_Clickhouse) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ShardConfig_Clickhouse) GetWeight() *wrappers.Int64Value {
	if m != nil {
		return m.Weight
	}
	return nil
}

type Host struct {
	// Name of the ClickHouse host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the ClickHouse host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the ClickHouse host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Type of the host.
	Type Host_Type `protobuf:"varint,4,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Host_Type" json:"type,omitempty"`
	// Resources allocated to the ClickHouse host.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp       bool     `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	ShardName            string   `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{6}
}

func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (m *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(m, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetType() Host_Type {
	if m != nil {
		return m.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *Host) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.clickhouse.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{7}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-clickhouse/concepts/instance-types)
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-ssd — network SSD drive,
	// * local-ssd — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{8}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

type Access struct {
	// Allow access for DataLens
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	// Allow access for Web SQL
	WebSql bool `protobuf:"varint,2,opt,name=web_sql,json=webSql,proto3" json:"web_sql,omitempty"`
	// Allow access for Metrika
	Metrika bool `protobuf:"varint,3,opt,name=metrika,proto3" json:"metrika,omitempty"`
	// Allow access for Serverless
	Serverless           bool     `protobuf:"varint,4,opt,name=serverless,proto3" json:"serverless,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Access) Reset()         { *m = Access{} }
func (m *Access) String() string { return proto.CompactTextString(m) }
func (*Access) ProtoMessage()    {}
func (*Access) Descriptor() ([]byte, []int) {
	return fileDescriptor_1a6d463853631481, []int{9}
}

func (m *Access) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Access.Unmarshal(m, b)
}
func (m *Access) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Access.Marshal(b, m, deterministic)
}
func (m *Access) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Access.Merge(m, src)
}
func (m *Access) XXX_Size() int {
	return xxx_messageInfo_Access.Size(m)
}
func (m *Access) XXX_DiscardUnknown() {
	xxx_messageInfo_Access.DiscardUnknown(m)
}

var xxx_messageInfo_Access proto.InternalMessageInfo

func (m *Access) GetDataLens() bool {
	if m != nil {
		return m.DataLens
	}
	return false
}

func (m *Access) GetWebSql() bool {
	if m != nil {
		return m.WebSql
	}
	return false
}

func (m *Access) GetMetrika() bool {
	if m != nil {
		return m.Metrika
	}
	return false
}

func (m *Access) GetServerless() bool {
	if m != nil {
		return m.Serverless
	}
	return false
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Host_Type", Host_Type_name, Host_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.clickhouse.v1.Service_Health", Service_Health_name, Service_Health_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.clickhouse.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.clickhouse.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.clickhouse.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.clickhouse.v1.ClusterConfig")
	proto.RegisterType((*ClusterConfig_Clickhouse)(nil), "yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Clickhouse")
	proto.RegisterType((*ClusterConfig_Zookeeper)(nil), "yandex.cloud.mdb.clickhouse.v1.ClusterConfig.Zookeeper")
	proto.RegisterType((*Shard)(nil), "yandex.cloud.mdb.clickhouse.v1.Shard")
	proto.RegisterType((*ShardGroup)(nil), "yandex.cloud.mdb.clickhouse.v1.ShardGroup")
	proto.RegisterType((*ShardConfig)(nil), "yandex.cloud.mdb.clickhouse.v1.ShardConfig")
	proto.RegisterType((*ShardConfig_Clickhouse)(nil), "yandex.cloud.mdb.clickhouse.v1.ShardConfig.Clickhouse")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.clickhouse.v1.Host")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.clickhouse.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.clickhouse.v1.Resources")
	proto.RegisterType((*Access)(nil), "yandex.cloud.mdb.clickhouse.v1.Access")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/clickhouse/v1/cluster.proto", fileDescriptor_1a6d463853631481)
}

var fileDescriptor_1a6d463853631481 = []byte{
	// 1381 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x57, 0xcb, 0x6e, 0xdb, 0x46,
	0x17, 0x0e, 0x25, 0x59, 0x12, 0x0f, 0x1d, 0x83, 0xff, 0xfc, 0x41, 0x43, 0xd8, 0x48, 0x62, 0x70,
	0xd1, 0xba, 0xb9, 0x50, 0x88, 0x53, 0xa4, 0xb9, 0xa0, 0x17, 0x45, 0x62, 0x6c, 0xd6, 0x8e, 0x24,
	0x8c, 0x24, 0xa7, 0xcd, 0x86, 0xa0, 0xc8, 0xb1, 0x4c, 0x88, 0x22, 0x19, 0x0e, 0x65, 0x47, 0xde,
	0x14, 0xe8, 0xdb, 0xf4, 0x31, 0xba, 0xe9, 0x63, 0x74, 0xd5, 0xc7, 0x68, 0x81, 0x62, 0x66, 0xa8,
	0x9b, 0xdd, 0x44, 0x72, 0xb2, 0xea, 0x4e, 0x73, 0xce, 0xf9, 0x3e, 0xce, 0x9c, 0xbb, 0xe0, 0xfe,
	0xd8, 0x09, 0x3d, 0xf2, 0xae, 0xe2, 0x06, 0xd1, 0xc8, 0xab, 0x0c, 0xbd, 0x5e, 0xc5, 0x0d, 0x7c,
	0x77, 0x70, 0x12, 0x8d, 0x28, 0xa9, 0x9c, 0x3e, 0xac, 0xb8, 0xc1, 0x88, 0xa6, 0x24, 0x31, 0xe2,
	0x24, 0x4a, 0x23, 0x74, 0x5b, 0x58, 0x1b, 0xdc, 0xda, 0x18, 0x7a, 0x3d, 0x63, 0x66, 0x6d, 0x9c,
	0x3e, 0xdc, 0xbc, 0xd3, 0x8f, 0xa2, 0x7e, 0x40, 0x2a, 0xdc, 0xba, 0x37, 0x3a, 0xae, 0xa4, 0xfe,
	0x90, 0xd0, 0xd4, 0x19, 0xc6, 0x82, 0x60, 0xf3, 0xf6, 0x45, 0x83, 0xb3, 0xc4, 0x89, 0x63, 0x92,
	0xd0, 0x4c, 0xbf, 0x95, 0xe9, 0xd3, 0x71, 0x4c, 0x38, 0x38, 0x3a, 0xf6, 0x9c, 0x71, 0xa6, 0x7c,
	0xbc, 0xec, 0xae, 0x51, 0x78, 0xec, 0xf7, 0xe7, 0x84, 0x02, 0xa7, 0xff, 0x5d, 0x82, 0x52, 0x4d,
	0xbc, 0x03, 0x6d, 0x40, 0xce, 0xf7, 0x34, 0x69, 0x5b, 0xda, 0x91, 0x71, 0xce, 0xf7, 0xd0, 0x16,
	0xc8, 0xc7, 0x51, 0xe0, 0x91, 0xc4, 0xf6, 0x3d, 0x2d, 0xc7, 0xc5, 0x65, 0x21, 0xb0, 0x3c, 0xf4,
	0x14, 0xc0, 0x4d, 0x88, 0x93, 0x12, 0xcf, 0x76, 0x52, 0x2d, 0xbf, 0x2d, 0xed, 0x28, 0xbb, 0x9b,
	0x86, 0xb8, 0xa2, 0x31, 0x79, 0x82, 0xd1, 0x99, 0xbc, 0x11, 0xcb, 0x99, 0x75, 0x35, 0x45, 0x08,
	0x0a, 0xa1, 0x33, 0x24, 0x5a, 0x81, 0x53, 0xf2, 0xdf, 0x68, 0x1b, 0x14, 0x8f, 0x50, 0x37, 0xf1,
	0xe3, 0xd4, 0x8f, 0x42, 0x6d, 0x8d, 0xab, 0xe6, 0x45, 0xe8, 0x00, 0x8a, 0x81, 0xd3, 0x23, 0x01,
	0xd5, 0x8a, 0xdb, 0xf9, 0x1d, 0x65, 0xf7, 0x91, 0xf1, 0x61, 0x87, 0x1b, 0xd9, 0xb3, 0x8c, 0x43,
	0x8e, 0x32, 0xc3, 0x34, 0x19, 0xe3, 0x8c, 0x02, 0x75, 0x41, 0x21, 0xe1, 0xa9, 0x9f, 0x44, 0xe1,
	0x90, 0x84, 0xa9, 0x56, 0xda, 0x96, 0x76, 0x36, 0x56, 0x67, 0x34, 0x67, 0x50, 0x3c, 0xcf, 0x83,
	0x7e, 0x00, 0x18, 0x46, 0xa1, 0x9f, 0x46, 0x89, 0x1f, 0xf6, 0xb5, 0x32, 0xbf, 0xe7, 0xdd, 0x65,
	0xac, 0xaf, 0xa6, 0x08, 0x3c, 0x87, 0x46, 0x26, 0x14, 0x45, 0xd0, 0x34, 0x99, 0x3b, 0xf7, 0xc1,
	0x8a, 0xb7, 0xab, 0x71, 0x10, 0xce, 0xc0, 0xe8, 0x16, 0x40, 0x48, 0xd2, 0xb3, 0x28, 0x19, 0xb0,
	0x28, 0x02, 0xf7, 0xab, 0x9c, 0x49, 0x2c, 0x0f, 0xbd, 0x84, 0xe2, 0x09, 0x71, 0x82, 0xf4, 0x44,
	0x53, 0xb8, 0x0f, 0x8c, 0x55, 0x7d, 0xb0, 0xcf, 0x51, 0x38, 0x43, 0x33, 0x1e, 0x9a, 0x3a, 0xe9,
	0x88, 0x6a, 0xeb, 0x57, 0xe3, 0x69, 0x73, 0x14, 0xce, 0xd0, 0xe8, 0x3e, 0x20, 0x4a, 0x92, 0x53,
	0xdf, 0x25, 0xb6, 0xe3, 0xba, 0xd1, 0x28, 0x4c, 0xd9, 0xb5, 0xaf, 0xf3, 0x6b, 0xab, 0x99, 0xa6,
	0x2a, 0x14, 0x96, 0xb7, 0xf9, 0x14, 0x94, 0xb9, 0xe8, 0x22, 0x15, 0xf2, 0x03, 0x32, 0xce, 0x32,
	0x98, 0xfd, 0x44, 0x37, 0x60, 0xed, 0xd4, 0x09, 0x46, 0x24, 0x4b, 0x5f, 0x71, 0x78, 0x96, 0x7b,
	0x22, 0xe9, 0x16, 0x28, 0x73, 0x61, 0x44, 0x5b, 0x70, 0xd3, 0x6c, 0x1c, 0x59, 0xb8, 0xd9, 0x78,
	0x65, 0x36, 0x3a, 0x76, 0xb7, 0xd1, 0x6e, 0x99, 0x35, 0xeb, 0xa5, 0x65, 0xd6, 0xd5, 0x6b, 0x68,
	0x03, 0xa0, 0x85, 0x9b, 0xf5, 0x6e, 0xad, 0x63, 0x35, 0x1b, 0xaa, 0x84, 0xae, 0x83, 0xdc, 0xc2,
	0x66, 0xbb, 0x53, 0x7d, 0x71, 0x68, 0xaa, 0x39, 0xfd, 0x3b, 0x28, 0x0a, 0x6f, 0x20, 0x04, 0x1b,
	0xfb, 0x66, 0xf5, 0xb0, 0xb3, 0x6f, 0x77, 0x1b, 0x07, 0x8d, 0xe6, 0xeb, 0x86, 0x7a, 0x0d, 0xc9,
	0xb0, 0x56, 0x3d, 0xb4, 0x8e, 0x4c, 0x55, 0x42, 0x65, 0x28, 0xd4, 0xcd, 0x6a, 0x5d, 0xcd, 0xa1,
	0x75, 0x28, 0xd7, 0xcd, 0x3d, 0x5c, 0xad, 0x9b, 0x75, 0x35, 0xaf, 0x8f, 0xa1, 0x28, 0xdc, 0xc0,
	0x08, 0xda, 0x9d, 0x6a, 0xa7, 0xdb, 0x9e, 0x23, 0x58, 0x87, 0x72, 0x0d, 0x9b, 0xd5, 0x8e, 0xd5,
	0xd8, 0x53, 0x25, 0xa4, 0x40, 0x09, 0x77, 0x1b, 0x0d, 0x76, 0xc8, 0x31, 0x6e, 0x13, 0xe3, 0x26,
	0x56, 0xf3, 0xcc, 0xaa, 0xdb, 0xaa, 0x0b, 0xab, 0x02, 0x3b, 0xb5, 0x3b, 0xcd, 0x56, 0x8b, 0x9d,
	0xd6, 0x18, 0x86, 0x9f, 0xcc, 0xba, 0x5a, 0x14, 0xaa, 0x2a, 0xe6, 0x86, 0x25, 0xfd, 0x08, 0x60,
	0x96, 0x7f, 0xd3, 0xca, 0x94, 0xde, 0x5f, 0x99, 0xb9, 0xcb, 0x95, 0x89, 0xa0, 0x10, 0xf8, 0xe1,
	0x80, 0x37, 0x01, 0x19, 0xf3, 0xdf, 0xfa, 0x9f, 0x05, 0xb8, 0xbe, 0x90, 0x90, 0x48, 0x83, 0xd2,
	0x29, 0x49, 0x28, 0xe3, 0x10, 0xf4, 0x93, 0x23, 0xfa, 0x11, 0x60, 0x96, 0x1b, 0xfc, 0x03, 0xca,
	0xee, 0x93, 0x2b, 0x65, 0xbb, 0x51, 0x9b, 0xea, 0xf0, 0x1c, 0x17, 0xea, 0x82, 0x7c, 0x1e, 0x45,
	0x03, 0x42, 0x62, 0x92, 0x64, 0x3d, 0xea, 0xeb, 0xab, 0x11, 0xbf, 0x99, 0xc0, 0xf1, 0x8c, 0x09,
	0xbd, 0x84, 0xff, 0xf7, 0x1c, 0x77, 0x30, 0x8a, 0xed, 0x33, 0x3f, 0xf4, 0xa2, 0x33, 0x9b, 0xa6,
	0x4e, 0x92, 0xf2, 0x7e, 0xa6, 0xec, 0x7e, 0x36, 0x69, 0x82, 0xac, 0x4f, 0xf3, 0x06, 0xd8, 0x3c,
	0xae, 0x3b, 0x63, 0xfc, 0x3f, 0x01, 0x79, 0xcd, 0x11, 0x6d, 0x06, 0x40, 0xdf, 0x42, 0xd1, 0x71,
	0x5d, 0x42, 0x29, 0xef, 0x77, 0xca, 0xee, 0xe7, 0xcb, 0xee, 0x56, 0xe5, 0xd6, 0x38, 0x43, 0x6d,
	0xfe, 0x2a, 0x01, 0xcc, 0x5e, 0x8e, 0xf0, 0xb4, 0x63, 0x48, 0x9c, 0xee, 0xd9, 0x32, 0x3a, 0xf7,
	0xa2, 0xf3, 0xc4, 0xa3, 0xdb, 0x24, 0x9d, 0xb6, 0x8f, 0x3d, 0x90, 0x13, 0x42, 0xa3, 0x51, 0xe2,
	0x12, 0x9a, 0x85, 0xe6, 0xcb, 0x65, 0xb4, 0x78, 0x02, 0xc0, 0x33, 0xec, 0x66, 0x07, 0xe4, 0xa9,
	0x2f, 0x17, 0x59, 0xa5, 0x8f, 0x67, 0xd5, 0x7f, 0x86, 0xb5, 0xf6, 0x89, 0x93, 0x78, 0xff, 0x9a,
	0xb9, 0xb7, 0x58, 0x5e, 0xf1, 0x60, 0xce, 0x06, 0x98, 0x9c, 0x49, 0x2c, 0x0f, 0xd5, 0xa6, 0xee,
	0x12, 0x99, 0x71, 0x6f, 0xd9, 0x0d, 0xf8, 0x97, 0x16, 0xdb, 0xab, 0xfe, 0x8b, 0x04, 0xc0, 0xe5,
	0x7b, 0x49, 0x34, 0x8a, 0x3f, 0xe6, 0x1a, 0x17, 0xea, 0x2b, 0x7f, 0xb9, 0xbe, 0xee, 0x80, 0x42,
	0xd9, 0x27, 0x6c, 0x46, 0x47, 0xb5, 0xc2, 0x76, 0x7e, 0x47, 0xc6, 0xc0, 0x45, 0x0d, 0x26, 0xd1,
	0x7f, 0xcf, 0x81, 0x32, 0x77, 0x39, 0x74, 0xb4, 0x50, 0x50, 0xc2, 0xbf, 0x8f, 0xaf, 0xf0, 0xba,
	0xf7, 0x94, 0xd3, 0xe6, 0x1f, 0xff, 0x9d, 0x7c, 0x43, 0x8f, 0xa0, 0x78, 0x46, 0xfc, 0xfe, 0xc9,
	0x64, 0x37, 0xd9, 0xba, 0xb4, 0x9b, 0x58, 0x61, 0xfa, 0xf8, 0xab, 0x23, 0x36, 0x10, 0x70, 0x66,
	0xaa, 0xff, 0x56, 0x80, 0xc2, 0x7e, 0x44, 0xd3, 0x8f, 0x89, 0xe3, 0x4d, 0x28, 0x9d, 0x47, 0x21,
	0x61, 0x3a, 0x11, 0xc3, 0x22, 0x3b, 0x5a, 0x1e, 0xfa, 0x06, 0x0a, 0xac, 0x15, 0xf0, 0xf6, 0xb0,
	0xb1, 0xfc, 0x35, 0xec, 0xfb, 0x46, 0x67, 0x1c, 0x13, 0xcc, 0x61, 0x8b, 0x1e, 0x59, 0xfb, 0x04,
	0x8f, 0xd4, 0xa6, 0xa3, 0xbe, 0xc8, 0x6f, 0x72, 0x6f, 0xa5, 0x9b, 0x5c, 0x98, 0xf3, 0x35, 0x28,
	0x67, 0x53, 0x98, 0x6a, 0x25, 0xbe, 0xdf, 0x7c, 0xb1, 0x34, 0xb1, 0x84, 0x3d, 0x9e, 0x02, 0xd9,
	0x62, 0x49, 0x47, 0xbd, 0x90, 0xf0, 0xd9, 0x5e, 0x16, 0x8b, 0xa5, 0x10, 0x58, 0x1e, 0xda, 0x01,
	0xd5, 0xa1, 0xd4, 0xef, 0x87, 0x76, 0x3c, 0xea, 0x05, 0xbe, 0x6b, 0xfb, 0x31, 0xdf, 0x80, 0xca,
	0x78, 0x43, 0xc8, 0x5b, 0x5c, 0x6c, 0xc5, 0x2c, 0x20, 0xb3, 0xba, 0x98, 0xac, 0x36, 0xd3, 0xb2,
	0xd0, 0x9f, 0x43, 0x81, 0xb9, 0x11, 0xdd, 0x00, 0xb5, 0xf3, 0x53, 0xcb, 0xbc, 0x3c, 0xd3, 0x6b,
	0x87, 0x56, 0xed, 0x60, 0xbf, 0xd9, 0x6d, 0x9b, 0x62, 0xa6, 0xbf, 0x69, 0x36, 0x0f, 0x4c, 0xb3,
	0x65, 0x62, 0x35, 0xa7, 0x3f, 0x99, 0xce, 0x74, 0x05, 0x4a, 0x57, 0x1a, 0xe6, 0x7f, 0x49, 0x50,
	0xca, 0x9e, 0x8c, 0xbe, 0xcf, 0x42, 0x2f, 0x71, 0x87, 0xdf, 0x5f, 0xd1, 0x53, 0xf3, 0xd1, 0x9f,
	0xed, 0x67, 0xb9, 0xd5, 0xf6, 0xaa, 0x09, 0xc7, 0x62, 0xdc, 0x3e, 0xcd, 0x19, 0x77, 0x57, 0x77,
	0x86, 0xfe, 0x0e, 0xe4, 0x69, 0xf6, 0xb1, 0x6d, 0x6e, 0x92, 0x7f, 0x76, 0x9c, 0x10, 0x2a, 0x22,
	0x2e, 0x8a, 0x4a, 0x9d, 0x68, 0x5a, 0x5c, 0x61, 0xf1, 0xff, 0x1b, 0x9e, 0x4f, 0x07, 0x36, 0xf5,
	0xcf, 0xc5, 0x1a, 0x90, 0xc7, 0x65, 0x26, 0x68, 0xfb, 0xe7, 0x6c, 0x0d, 0x59, 0xe7, 0x4a, 0xe6,
	0x95, 0x59, 0x8d, 0x01, 0x93, 0xb1, 0x87, 0x59, 0x9e, 0xfe, 0x0e, 0x8a, 0x62, 0x3e, 0x72, 0x22,
	0x27, 0x75, 0xec, 0x80, 0x84, 0x62, 0xbc, 0x94, 0x71, 0x99, 0x09, 0x0e, 0x49, 0x48, 0x59, 0x9d,
	0x9e, 0x91, 0x9e, 0x4d, 0xdf, 0x06, 0xfc, 0x1b, 0x65, 0x56, 0xfc, 0xbd, 0xf6, 0xdb, 0x80, 0x2d,
	0x28, 0x43, 0x92, 0x26, 0xfe, 0xc0, 0xe1, 0xe4, 0x65, 0x3c, 0x39, 0xa2, 0xdb, 0x00, 0x2c, 0x77,
	0x49, 0x12, 0xb0, 0x59, 0x5d, 0xe0, 0xca, 0x39, 0xc9, 0x0b, 0x0a, 0xfa, 0x42, 0x54, 0x9c, 0xd8,
	0xbf, 0x1c, 0x99, 0x37, 0xaf, 0xfa, 0x7e, 0x7a, 0x32, 0xea, 0x19, 0x6e, 0x34, 0xac, 0x08, 0xf3,
	0x07, 0xe2, 0xdf, 0x5a, 0x3f, 0x7a, 0xd0, 0x27, 0x21, 0xef, 0x4b, 0x95, 0x0f, 0xff, 0x8d, 0x7b,
	0x3e, 0x3b, 0xf5, 0x8a, 0x1c, 0xf0, 0xe8, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x38, 0x32, 0x45,
	0x42, 0xa6, 0x0e, 0x00, 0x00,
}
