// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/clickhouse/v1/ml_model_service.proto

package clickhouse

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetMlModelRequest struct {
	// ID of the cluster that the model belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the model to return.
	//
	// To get a model name make a [MlModelService.List] request.
	MlModelName          string   `protobuf:"bytes,2,opt,name=ml_model_name,json=mlModelName,proto3" json:"ml_model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMlModelRequest) Reset()         { *m = GetMlModelRequest{} }
func (m *GetMlModelRequest) String() string { return proto.CompactTextString(m) }
func (*GetMlModelRequest) ProtoMessage()    {}
func (*GetMlModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{0}
}

func (m *GetMlModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMlModelRequest.Unmarshal(m, b)
}
func (m *GetMlModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMlModelRequest.Marshal(b, m, deterministic)
}
func (m *GetMlModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMlModelRequest.Merge(m, src)
}
func (m *GetMlModelRequest) XXX_Size() int {
	return xxx_messageInfo_GetMlModelRequest.Size(m)
}
func (m *GetMlModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMlModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMlModelRequest proto.InternalMessageInfo

func (m *GetMlModelRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetMlModelRequest) GetMlModelName() string {
	if m != nil {
		return m.MlModelName
	}
	return ""
}

type ListMlModelsRequest struct {
	// ID of the cluster that models belongs to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `page_size`, the service returns a [ListMlModelsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListMlModelsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMlModelsRequest) Reset()         { *m = ListMlModelsRequest{} }
func (m *ListMlModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMlModelsRequest) ProtoMessage()    {}
func (*ListMlModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{1}
}

func (m *ListMlModelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMlModelsRequest.Unmarshal(m, b)
}
func (m *ListMlModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMlModelsRequest.Marshal(b, m, deterministic)
}
func (m *ListMlModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMlModelsRequest.Merge(m, src)
}
func (m *ListMlModelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMlModelsRequest.Size(m)
}
func (m *ListMlModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMlModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMlModelsRequest proto.InternalMessageInfo

func (m *ListMlModelsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListMlModelsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListMlModelsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListMlModelsResponse struct {
	// List of models in the specified cluster.
	MlModels []*MlModel `protobuf:"bytes,1,rep,name=ml_models,json=mlModels,proto3" json:"ml_models,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListMlModelsRequest.page_size], use `next_page_token` as the value
	// for the [ListMlModelsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMlModelsResponse) Reset()         { *m = ListMlModelsResponse{} }
func (m *ListMlModelsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMlModelsResponse) ProtoMessage()    {}
func (*ListMlModelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{2}
}

func (m *ListMlModelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMlModelsResponse.Unmarshal(m, b)
}
func (m *ListMlModelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMlModelsResponse.Marshal(b, m, deterministic)
}
func (m *ListMlModelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMlModelsResponse.Merge(m, src)
}
func (m *ListMlModelsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMlModelsResponse.Size(m)
}
func (m *ListMlModelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMlModelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMlModelsResponse proto.InternalMessageInfo

func (m *ListMlModelsResponse) GetMlModels() []*MlModel {
	if m != nil {
		return m.MlModels
	}
	return nil
}

func (m *ListMlModelsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateMlModelRequest struct {
	// ID of the cluster to create a model in.
	//
	// To get a cluster ID make a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Model name. The model name is one of the arguments of the modelEvaluate() function, which is used to call the model in ClickHouse.
	MlModelName string `protobuf:"bytes,2,opt,name=ml_model_name,json=mlModelName,proto3" json:"ml_model_name,omitempty"`
	// Type of the model.
	Type MlModelType `protobuf:"varint,3,opt,name=type,proto3,enum=yandex.cloud.mdb.clickhouse.v1.MlModelType" json:"type,omitempty"`
	// Model file URL. You can only use models stored in Yandex Object Storage.
	Uri                  string   `protobuf:"bytes,4,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMlModelRequest) Reset()         { *m = CreateMlModelRequest{} }
func (m *CreateMlModelRequest) String() string { return proto.CompactTextString(m) }
func (*CreateMlModelRequest) ProtoMessage()    {}
func (*CreateMlModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{3}
}

func (m *CreateMlModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMlModelRequest.Unmarshal(m, b)
}
func (m *CreateMlModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMlModelRequest.Marshal(b, m, deterministic)
}
func (m *CreateMlModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMlModelRequest.Merge(m, src)
}
func (m *CreateMlModelRequest) XXX_Size() int {
	return xxx_messageInfo_CreateMlModelRequest.Size(m)
}
func (m *CreateMlModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMlModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMlModelRequest proto.InternalMessageInfo

func (m *CreateMlModelRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateMlModelRequest) GetMlModelName() string {
	if m != nil {
		return m.MlModelName
	}
	return ""
}

func (m *CreateMlModelRequest) GetType() MlModelType {
	if m != nil {
		return m.Type
	}
	return MlModelType_ML_MODEL_TYPE_UNSPECIFIED
}

func (m *CreateMlModelRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

type CreateMlModelMetadata struct {
	// ID of the cluster that a model is being added to.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the the model that is being created.
	MlModelName          string   `protobuf:"bytes,2,opt,name=ml_model_name,json=mlModelName,proto3" json:"ml_model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMlModelMetadata) Reset()         { *m = CreateMlModelMetadata{} }
func (m *CreateMlModelMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateMlModelMetadata) ProtoMessage()    {}
func (*CreateMlModelMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{4}
}

func (m *CreateMlModelMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMlModelMetadata.Unmarshal(m, b)
}
func (m *CreateMlModelMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMlModelMetadata.Marshal(b, m, deterministic)
}
func (m *CreateMlModelMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMlModelMetadata.Merge(m, src)
}
func (m *CreateMlModelMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateMlModelMetadata.Size(m)
}
func (m *CreateMlModelMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMlModelMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMlModelMetadata proto.InternalMessageInfo

func (m *CreateMlModelMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateMlModelMetadata) GetMlModelName() string {
	if m != nil {
		return m.MlModelName
	}
	return ""
}

type UpdateMlModelRequest struct {
	// ID of the cluster to update the model in.
	//
	// To get a cluster ID make a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the the model to update.
	MlModelName string                `protobuf:"bytes,2,opt,name=ml_model_name,json=mlModelName,proto3" json:"ml_model_name,omitempty"`
	UpdateMask  *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The new model file URL. You can only use models stored in Yandex Object Storage.
	Uri                  string   `protobuf:"bytes,4,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateMlModelRequest) Reset()         { *m = UpdateMlModelRequest{} }
func (m *UpdateMlModelRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateMlModelRequest) ProtoMessage()    {}
func (*UpdateMlModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{5}
}

func (m *UpdateMlModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateMlModelRequest.Unmarshal(m, b)
}
func (m *UpdateMlModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateMlModelRequest.Marshal(b, m, deterministic)
}
func (m *UpdateMlModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateMlModelRequest.Merge(m, src)
}
func (m *UpdateMlModelRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateMlModelRequest.Size(m)
}
func (m *UpdateMlModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateMlModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateMlModelRequest proto.InternalMessageInfo

func (m *UpdateMlModelRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateMlModelRequest) GetMlModelName() string {
	if m != nil {
		return m.MlModelName
	}
	return ""
}

func (m *UpdateMlModelRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateMlModelRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

type UpdateMlModelMetadata struct {
	// ID of the cluster that contains the model being updated.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the the model that is being updated.
	MlModelName          string   `protobuf:"bytes,2,opt,name=ml_model_name,json=mlModelName,proto3" json:"ml_model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateMlModelMetadata) Reset()         { *m = UpdateMlModelMetadata{} }
func (m *UpdateMlModelMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateMlModelMetadata) ProtoMessage()    {}
func (*UpdateMlModelMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{6}
}

func (m *UpdateMlModelMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateMlModelMetadata.Unmarshal(m, b)
}
func (m *UpdateMlModelMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateMlModelMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateMlModelMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateMlModelMetadata.Merge(m, src)
}
func (m *UpdateMlModelMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateMlModelMetadata.Size(m)
}
func (m *UpdateMlModelMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateMlModelMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateMlModelMetadata proto.InternalMessageInfo

func (m *UpdateMlModelMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateMlModelMetadata) GetMlModelName() string {
	if m != nil {
		return m.MlModelName
	}
	return ""
}

type DeleteMlModelRequest struct {
	// ID of the cluster to delete the model in.
	//
	// To get a cluster ID make a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the the model to delete.
	MlModelName          string   `protobuf:"bytes,2,opt,name=ml_model_name,json=mlModelName,proto3" json:"ml_model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteMlModelRequest) Reset()         { *m = DeleteMlModelRequest{} }
func (m *DeleteMlModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteMlModelRequest) ProtoMessage()    {}
func (*DeleteMlModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{7}
}

func (m *DeleteMlModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteMlModelRequest.Unmarshal(m, b)
}
func (m *DeleteMlModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteMlModelRequest.Marshal(b, m, deterministic)
}
func (m *DeleteMlModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteMlModelRequest.Merge(m, src)
}
func (m *DeleteMlModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteMlModelRequest.Size(m)
}
func (m *DeleteMlModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteMlModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteMlModelRequest proto.InternalMessageInfo

func (m *DeleteMlModelRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteMlModelRequest) GetMlModelName() string {
	if m != nil {
		return m.MlModelName
	}
	return ""
}

type DeleteMlModelMetadata struct {
	// ID of the cluster that contains the model being deleted.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Name of the the model that is being deleted.
	MlModelName          string   `protobuf:"bytes,2,opt,name=ml_model_name,json=mlModelName,proto3" json:"ml_model_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteMlModelMetadata) Reset()         { *m = DeleteMlModelMetadata{} }
func (m *DeleteMlModelMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteMlModelMetadata) ProtoMessage()    {}
func (*DeleteMlModelMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f35e6f9d9932e714, []int{8}
}

func (m *DeleteMlModelMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteMlModelMetadata.Unmarshal(m, b)
}
func (m *DeleteMlModelMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteMlModelMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteMlModelMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteMlModelMetadata.Merge(m, src)
}
func (m *DeleteMlModelMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteMlModelMetadata.Size(m)
}
func (m *DeleteMlModelMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteMlModelMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteMlModelMetadata proto.InternalMessageInfo

func (m *DeleteMlModelMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteMlModelMetadata) GetMlModelName() string {
	if m != nil {
		return m.MlModelName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetMlModelRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.GetMlModelRequest")
	proto.RegisterType((*ListMlModelsRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.ListMlModelsRequest")
	proto.RegisterType((*ListMlModelsResponse)(nil), "yandex.cloud.mdb.clickhouse.v1.ListMlModelsResponse")
	proto.RegisterType((*CreateMlModelRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.CreateMlModelRequest")
	proto.RegisterType((*CreateMlModelMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.CreateMlModelMetadata")
	proto.RegisterType((*UpdateMlModelRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateMlModelRequest")
	proto.RegisterType((*UpdateMlModelMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.UpdateMlModelMetadata")
	proto.RegisterType((*DeleteMlModelRequest)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteMlModelRequest")
	proto.RegisterType((*DeleteMlModelMetadata)(nil), "yandex.cloud.mdb.clickhouse.v1.DeleteMlModelMetadata")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/clickhouse/v1/ml_model_service.proto", fileDescriptor_f35e6f9d9932e714)
}

var fileDescriptor_f35e6f9d9932e714 = []byte{
	// 813 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x96, 0xcf, 0x6b, 0xdb, 0x48,
	0x14, 0xc7, 0x51, 0xec, 0x75, 0xe2, 0xf1, 0x26, 0xbb, 0x3b, 0xeb, 0x2c, 0xc6, 0x6c, 0x82, 0x57,
	0x87, 0x24, 0x38, 0x48, 0xb2, 0x9c, 0xcd, 0x2e, 0x9b, 0x1f, 0x87, 0x75, 0x93, 0x86, 0x96, 0xba,
	0x2d, 0x4a, 0x7a, 0x49, 0x29, 0x66, 0x6c, 0x4d, 0x1c, 0x61, 0xfd, 0xaa, 0x67, 0x64, 0xe2, 0x84,
	0x50, 0x28, 0x85, 0x42, 0xae, 0xa5, 0xff, 0x47, 0xc9, 0x3f, 0xe1, 0x9c, 0x53, 0x68, 0xef, 0xa5,
	0x94, 0x9e, 0x7b, 0xec, 0xa5, 0x45, 0x33, 0xfe, 0xa5, 0xda, 0x89, 0xdd, 0x60, 0x48, 0x6f, 0xd6,
	0xbc, 0xf7, 0x66, 0xbe, 0x9f, 0xe7, 0x79, 0x5f, 0x09, 0x2c, 0xd7, 0x91, 0xad, 0xe3, 0x03, 0xa5,
	0x64, 0x3a, 0x9e, 0xae, 0x58, 0x7a, 0x51, 0x29, 0x99, 0x46, 0xa9, 0xb2, 0xef, 0x78, 0x04, 0x2b,
	0x35, 0x55, 0xb1, 0xcc, 0x82, 0xe5, 0xe8, 0xd8, 0x2c, 0x10, 0x5c, 0xad, 0x19, 0x25, 0x2c, 0xbb,
	0x55, 0x87, 0x3a, 0x70, 0x96, 0x97, 0xc9, 0xac, 0x4c, 0xb6, 0xf4, 0xa2, 0xdc, 0x29, 0x93, 0x6b,
	0x6a, 0xf2, 0xcf, 0xb2, 0xe3, 0x94, 0x4d, 0xac, 0x20, 0xd7, 0x50, 0x90, 0x6d, 0x3b, 0x14, 0x51,
	0xc3, 0xb1, 0x09, 0xaf, 0x4e, 0xa6, 0x9a, 0x51, 0xf6, 0x54, 0xf4, 0xf6, 0x94, 0x3d, 0x03, 0x9b,
	0x7a, 0xc1, 0x42, 0xa4, 0xd2, 0xca, 0x08, 0xc8, 0xf2, 0x77, 0x71, 0x5c, 0x5c, 0x65, 0x9b, 0x34,
	0x33, 0xe6, 0x02, 0x19, 0xed, 0x68, 0x4f, 0xde, 0x4c, 0x20, 0xaf, 0x86, 0x4c, 0x43, 0xef, 0x0e,
	0x4b, 0x43, 0xf2, 0xf3, 0x74, 0xf1, 0x99, 0x00, 0x7e, 0xdb, 0xc2, 0x34, 0x6f, 0xe6, 0xfd, 0x45,
	0x0d, 0x3f, 0xf6, 0x30, 0xa1, 0x70, 0x11, 0x80, 0x92, 0xe9, 0x11, 0x8a, 0xab, 0x05, 0x43, 0x4f,
	0x08, 0x29, 0x61, 0x21, 0x9a, 0xfb, 0xf9, 0x63, 0x43, 0x15, 0x4e, 0xce, 0xd4, 0xf0, 0xda, 0xfa,
	0x72, 0x46, 0x8b, 0x36, 0xe3, 0xb7, 0x74, 0x98, 0x03, 0x93, 0xed, 0xa6, 0xda, 0xc8, 0xc2, 0x89,
	0x31, 0x96, 0x3f, 0xeb, 0xe7, 0x7f, 0x6a, 0xa8, 0x53, 0x0f, 0x91, 0x74, 0xf8, 0xbf, 0xb4, 0x9b,
	0x91, 0xfe, 0x2b, 0x48, 0x8f, 0xd2, 0x7c, 0x87, 0x7f, 0x96, 0xb4, 0x98, 0xc5, 0xcf, 0xbc, 0x8b,
	0x2c, 0x2c, 0xbe, 0x14, 0xc0, 0xef, 0x77, 0x0c, 0xd2, 0xd2, 0x41, 0xae, 0x24, 0x64, 0x1e, 0x44,
	0x5d, 0x54, 0xc6, 0x05, 0x62, 0x1c, 0x72, 0x11, 0xa1, 0x1c, 0xf8, 0xdc, 0x50, 0x23, 0x6b, 0xeb,
	0x6a, 0x26, 0x93, 0xd1, 0x26, 0xfc, 0xe0, 0xb6, 0x71, 0x88, 0xe1, 0x02, 0x00, 0x2c, 0x91, 0x3a,
	0x15, 0x6c, 0x27, 0x42, 0x6c, 0xd7, 0xe8, 0xc9, 0x99, 0xfa, 0x13, 0xcb, 0xd4, 0xd8, 0x2e, 0x3b,
	0x7e, 0xcc, 0x6f, 0x4f, 0x3c, 0xa8, 0x8b, 0xb8, 0x8e, 0x4d, 0x30, 0xdc, 0x00, 0xd1, 0x16, 0x34,
	0x49, 0x08, 0xa9, 0xd0, 0x42, 0x2c, 0x3b, 0x2f, 0x5f, 0x7e, 0x87, 0xe4, 0x56, 0x93, 0x27, 0x9a,
	0xe4, 0x04, 0xce, 0x81, 0x5f, 0x6c, 0x7c, 0x40, 0x0b, 0x5d, 0x6a, 0x58, 0xf3, 0xb4, 0x49, 0x7f,
	0xf9, 0x7e, 0x5b, 0xc6, 0x07, 0x01, 0xc4, 0x6f, 0x54, 0x31, 0xa2, 0xf8, 0x9a, 0xff, 0x28, 0xb8,
	0x09, 0xc2, 0xb4, 0xee, 0x62, 0xd6, 0xb4, 0xa9, 0xec, 0xe2, 0x90, 0xc8, 0x3b, 0x75, 0x17, 0xe7,
	0xc2, 0xfe, 0x39, 0x1a, 0x2b, 0x87, 0x7f, 0x80, 0x90, 0x57, 0x35, 0x12, 0x61, 0x26, 0x80, 0x07,
	0xfc, 0x05, 0x71, 0x17, 0x4c, 0x07, 0x38, 0xf3, 0x98, 0x22, 0x1d, 0x51, 0x04, 0x67, 0x7a, 0x41,
	0xbb, 0xd1, 0xc4, 0xbe, 0x68, 0xc1, 0x3b, 0xf6, 0x46, 0x00, 0xf1, 0x07, 0xae, 0xfe, 0x03, 0x34,
	0x71, 0x15, 0xc4, 0x3c, 0x26, 0x84, 0x39, 0x04, 0xeb, 0x65, 0x2c, 0x9b, 0x94, 0xb9, 0x89, 0xc8,
	0x2d, 0x13, 0x91, 0x6f, 0xfa, 0x26, 0x92, 0x47, 0xa4, 0xa2, 0x01, 0x9e, 0xee, 0xff, 0x86, 0xbf,
	0x76, 0xb5, 0xae, 0xdd, 0xb4, 0x00, 0xd7, 0x28, 0x9b, 0xf6, 0x5c, 0x00, 0xf1, 0x0d, 0x6c, 0xe2,
	0x6b, 0x6f, 0x9a, 0x4f, 0x19, 0x10, 0x32, 0x42, 0xca, 0xec, 0x97, 0x71, 0x30, 0xd5, 0xdc, 0x76,
	0x9b, 0xbf, 0x16, 0xe0, 0x2b, 0x01, 0x84, 0xb6, 0x30, 0x85, 0xea, 0xa0, 0x2b, 0xde, 0xe3, 0x9e,
	0xc9, 0x61, 0x8d, 0x40, 0xcc, 0x3f, 0x7d, 0xfd, 0xfe, 0xc5, 0xd8, 0x16, 0xdc, 0x54, 0x2c, 0x64,
	0xa3, 0x32, 0xd6, 0xa5, 0xa0, 0x57, 0x37, 0x21, 0x88, 0x72, 0xd4, 0x01, 0x3c, 0x56, 0x5a, 0xee,
	0xa1, 0x1c, 0x05, 0xb8, 0x8e, 0x7d, 0xc9, 0x61, 0xdf, 0xac, 0xe0, 0xd2, 0x20, 0x01, 0x7d, 0xac,
	0x36, 0xf9, 0xf7, 0xf7, 0x15, 0x71, 0x1f, 0x14, 0xd7, 0x19, 0xc2, 0xbf, 0x70, 0xf9, 0x4a, 0x08,
	0xb0, 0x21, 0x80, 0x08, 0x1f, 0x78, 0x38, 0xf0, 0xfc, 0x7e, 0x06, 0x98, 0xfc, 0x2b, 0x58, 0xd5,
	0x79, 0x59, 0xde, 0x6b, 0xfd, 0x12, 0xf5, 0xd3, 0xf3, 0x74, 0xea, 0x22, 0x5f, 0x19, 0x6f, 0x2e,
	0x30, 0x8c, 0x15, 0xf1, 0x6a, 0x18, 0x2b, 0x42, 0x1a, 0xbe, 0x15, 0x40, 0x84, 0x4f, 0xe1, 0x60,
	0x92, 0x7e, 0x2e, 0x34, 0x0c, 0x09, 0xe5, 0x24, 0xfd, 0x87, 0x3d, 0x40, 0x72, 0x3b, 0x3b, 0x9a,
	0x3b, 0xe5, 0x93, 0xbd, 0x13, 0x40, 0x84, 0x4f, 0xde, 0x60, 0xb2, 0x7e, 0x56, 0x31, 0x0c, 0xd9,
	0x93, 0xd3, 0xf3, 0xb4, 0x7c, 0xd1, 0x80, 0x4f, 0x7f, 0x6b, 0x8c, 0x9b, 0x96, 0x4b, 0xeb, 0x7c,
	0x76, 0xd2, 0xa3, 0xe1, 0xcc, 0x11, 0x20, 0x06, 0x44, 0x22, 0xd7, 0xe8, 0xc5, 0xdb, 0xcd, 0x97,
	0x0d, 0xba, 0xef, 0x15, 0xe5, 0x92, 0x63, 0x29, 0x3c, 0x5d, 0xe2, 0xdf, 0x59, 0x65, 0x47, 0x2a,
	0x63, 0x9b, 0x09, 0x54, 0x2e, 0xff, 0x00, 0x5b, 0xed, 0x3c, 0x15, 0x23, 0xac, 0x60, 0xe9, 0x6b,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xd6, 0xb7, 0xc5, 0x33, 0xb4, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MlModelServiceClient is the client API for MlModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MlModelServiceClient interface {
	// Returns the specified machine learning model.
	//
	// To get the list of all available models, make a [List] request.
	Get(ctx context.Context, in *GetMlModelRequest, opts ...grpc.CallOption) (*MlModel, error)
	// Retrieves the list of machine learning models in the specified cluster.
	List(ctx context.Context, in *ListMlModelsRequest, opts ...grpc.CallOption) (*ListMlModelsResponse, error)
	// Creates a machine learning model in the specified cluster.
	Create(ctx context.Context, in *CreateMlModelRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified machine learning model.
	Update(ctx context.Context, in *UpdateMlModelRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified machine learning model.
	Delete(ctx context.Context, in *DeleteMlModelRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type mlModelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMlModelServiceClient(cc grpc.ClientConnInterface) MlModelServiceClient {
	return &mlModelServiceClient{cc}
}

func (c *mlModelServiceClient) Get(ctx context.Context, in *GetMlModelRequest, opts ...grpc.CallOption) (*MlModel, error) {
	out := new(MlModel)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mlModelServiceClient) List(ctx context.Context, in *ListMlModelsRequest, opts ...grpc.CallOption) (*ListMlModelsResponse, error) {
	out := new(ListMlModelsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.MlModelService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mlModelServiceClient) Create(ctx context.Context, in *CreateMlModelRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mlModelServiceClient) Update(ctx context.Context, in *UpdateMlModelRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mlModelServiceClient) Delete(ctx context.Context, in *DeleteMlModelRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MlModelServiceServer is the server API for MlModelService service.
type MlModelServiceServer interface {
	// Returns the specified machine learning model.
	//
	// To get the list of all available models, make a [List] request.
	Get(context.Context, *GetMlModelRequest) (*MlModel, error)
	// Retrieves the list of machine learning models in the specified cluster.
	List(context.Context, *ListMlModelsRequest) (*ListMlModelsResponse, error)
	// Creates a machine learning model in the specified cluster.
	Create(context.Context, *CreateMlModelRequest) (*operation.Operation, error)
	// Updates the specified machine learning model.
	Update(context.Context, *UpdateMlModelRequest) (*operation.Operation, error)
	// Deletes the specified machine learning model.
	Delete(context.Context, *DeleteMlModelRequest) (*operation.Operation, error)
}

// UnimplementedMlModelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMlModelServiceServer struct {
}

func (*UnimplementedMlModelServiceServer) Get(ctx context.Context, req *GetMlModelRequest) (*MlModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedMlModelServiceServer) List(ctx context.Context, req *ListMlModelsRequest) (*ListMlModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedMlModelServiceServer) Create(ctx context.Context, req *CreateMlModelRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedMlModelServiceServer) Update(ctx context.Context, req *UpdateMlModelRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedMlModelServiceServer) Delete(ctx context.Context, req *DeleteMlModelRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}

func RegisterMlModelServiceServer(s *grpc.Server, srv MlModelServiceServer) {
	s.RegisterService(&_MlModelService_serviceDesc, srv)
}

func _MlModelService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMlModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MlModelServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MlModelServiceServer).Get(ctx, req.(*GetMlModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MlModelService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMlModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MlModelServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.MlModelService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MlModelServiceServer).List(ctx, req.(*ListMlModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MlModelService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMlModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MlModelServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MlModelServiceServer).Create(ctx, req.(*CreateMlModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MlModelService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMlModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MlModelServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MlModelServiceServer).Update(ctx, req.(*UpdateMlModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MlModelService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMlModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MlModelServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.clickhouse.v1.MlModelService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MlModelServiceServer).Delete(ctx, req.(*DeleteMlModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MlModelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.clickhouse.v1.MlModelService",
	HandlerType: (*MlModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _MlModelService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _MlModelService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _MlModelService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _MlModelService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _MlModelService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/mdb/clickhouse/v1/ml_model_service.proto",
}
