// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/mongodb/v1/cluster.proto

package mongodb

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Deployment environment.
type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy: only hotfixes
	// are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}

var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}

func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}

func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0, 2}
}

type Host_Type int32

const (
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// A mongod host.
	Host_MONGOD Host_Type = 1
	// A mongos host.
	Host_MONGOS Host_Type = 2
	// A mongocfg host.
	Host_MONGOCFG Host_Type = 3
)

var Host_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "MONGOD",
	2: "MONGOS",
	3: "MONGOCFG",
}

var Host_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"MONGOD":           1,
	"MONGOS":           2,
	"MONGOCFG":         3,
}

func (x Host_Type) String() string {
	return proto.EnumName(Host_Type_name, int32(x))
}

func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{7, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the primary MongoDB server in the cluster.
	Host_PRIMARY Host_Role = 1
	// Host is a secondary MongoDB server in the cluster.
	Host_SECONDARY Host_Role = 2
)

var Host_Role_name = map[int32]string{
	0: "ROLE_UNKNOWN",
	1: "PRIMARY",
	2: "SECONDARY",
}

var Host_Role_value = map[string]int32{
	"ROLE_UNKNOWN": 0,
	"PRIMARY":      1,
	"SECONDARY":    2,
}

func (x Host_Role) String() string {
	return proto.EnumName(Host_Role_name, int32(x))
}

func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{7, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Host_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}

func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{7, 2}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is running a mongod daemon.
	Service_MONGOD Service_Type = 1
	// The host is running a mongos daemon.
	Service_MONGOS Service_Type = 2
	// The host is running a MongoDB config server.
	Service_MONGOCFG Service_Type = 3
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "MONGOD",
	2: "MONGOS",
	3: "MONGOCFG",
}

var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"MONGOD":           1,
	"MONGOS":           2,
	"MONGOCFG":         3,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}

func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{8, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}

var Service_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}

func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{8, 1}
}

// A managed MongoDB cluster. For more information, see the [documentation](/docs/managed-mongodb/concepts).
type Cluster struct {
	// ID of the MongoDB cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the MongoDB cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the MongoDB cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MongoDB cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as `` key:value `` pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the MongoDB cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the MongoDB cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Status" json:"status,omitempty"`
	// Indicates current sharding status of the cluster.
	Sharded              bool     `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (m *Cluster) GetSharded() bool {
	if m != nil {
		return m.Sharded
	}
	return false
}

// Monitoring system.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the MongoDB cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{1}
}

func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (m *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(m, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of MongoDB server software. Possible values: `3.6`, `4.0`, `4.2`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// MongoDB feature compatibility version. See usage details in [MongoDB documentation](https://docs.mongodb.com/manual/reference/command/setFeatureCompatibilityVersion/).
	//
	// Possible values:
	// * `3.6` — persist data compatibility for version 3.6. After setting this option the data will not be compatible with 3.4 or lower.
	// * `4.0` — persist data compatibility for version 4.0. After setting this option the data will not be compatible with 3.6 or lower.
	// * `4.2` — persist data compatibility for version 4.2. After setting this option the data will not be compatible with 4.0 or lower.
	FeatureCompatibilityVersion string `protobuf:"bytes,5,opt,name=feature_compatibility_version,json=featureCompatibilityVersion,proto3" json:"feature_compatibility_version,omitempty"`
	// Configuration for MongoDB servers in the cluster.
	//
	// Types that are valid to be assigned to Mongodb:
	//	*ClusterConfig_Mongodb_3_6
	//	*ClusterConfig_Mongodb_4_0
	//	*ClusterConfig_Mongodb_4_2
	Mongodb isClusterConfig_Mongodb `protobuf_oneof:"mongodb"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,6,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{2}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ClusterConfig) GetFeatureCompatibilityVersion() string {
	if m != nil {
		return m.FeatureCompatibilityVersion
	}
	return ""
}

type isClusterConfig_Mongodb interface {
	isClusterConfig_Mongodb()
}

type ClusterConfig_Mongodb_3_6 struct {
	Mongodb_3_6 *Mongodb3_6 `protobuf:"bytes,2,opt,name=mongodb_3_6,json=mongodb36,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_0 struct {
	Mongodb_4_0 *Mongodb4_0 `protobuf:"bytes,4,opt,name=mongodb_4_0,json=mongodb40,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_2 struct {
	Mongodb_4_2 *Mongodb4_2 `protobuf:"bytes,7,opt,name=mongodb_4_2,json=mongodb42,proto3,oneof"`
}

func (*ClusterConfig_Mongodb_3_6) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_2) isClusterConfig_Mongodb() {}

func (m *ClusterConfig) GetMongodb() isClusterConfig_Mongodb {
	if m != nil {
		return m.Mongodb
	}
	return nil
}

func (m *ClusterConfig) GetMongodb_3_6() *Mongodb3_6 {
	if x, ok := m.GetMongodb().(*ClusterConfig_Mongodb_3_6); ok {
		return x.Mongodb_3_6
	}
	return nil
}

func (m *ClusterConfig) GetMongodb_4_0() *Mongodb4_0 {
	if x, ok := m.GetMongodb().(*ClusterConfig_Mongodb_4_0); ok {
		return x.Mongodb_4_0
	}
	return nil
}

func (m *ClusterConfig) GetMongodb_4_2() *Mongodb4_2 {
	if x, ok := m.GetMongodb().(*ClusterConfig_Mongodb_4_2); ok {
		return x.Mongodb_4_2
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ClusterConfig) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ClusterConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ClusterConfig_Mongodb_3_6)(nil),
		(*ClusterConfig_Mongodb_4_0)(nil),
		(*ClusterConfig_Mongodb_4_2)(nil),
	}
}

type Mongodb3_6 struct {
	// Configuration and resource allocation for mongod in a MongoDB 3.6 cluster.
	Mongod *Mongodb3_6_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 3.6 cluster.
	Mongocfg *Mongodb3_6_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 3.6 cluster.
	Mongos               *Mongodb3_6_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Mongodb3_6) Reset()         { *m = Mongodb3_6{} }
func (m *Mongodb3_6) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6) ProtoMessage()    {}
func (*Mongodb3_6) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3}
}

func (m *Mongodb3_6) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6.Unmarshal(m, b)
}
func (m *Mongodb3_6) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6.Merge(m, src)
}
func (m *Mongodb3_6) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6.Size(m)
}
func (m *Mongodb3_6) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6 proto.InternalMessageInfo

func (m *Mongodb3_6) GetMongod() *Mongodb3_6_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *Mongodb3_6) GetMongocfg() *Mongodb3_6_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *Mongodb3_6) GetMongos() *Mongodb3_6_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type Mongodb3_6_Mongod struct {
	// Configuration for a mongod 3.6 hosts.
	Config *config.MongodConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to MongoDB hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_Mongod) Reset()         { *m = Mongodb3_6_Mongod{} }
func (m *Mongodb3_6_Mongod) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_Mongod) ProtoMessage()    {}
func (*Mongodb3_6_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3, 0}
}

func (m *Mongodb3_6_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_Mongod.Unmarshal(m, b)
}
func (m *Mongodb3_6_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_Mongod.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_Mongod.Merge(m, src)
}
func (m *Mongodb3_6_Mongod) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_Mongod.Size(m)
}
func (m *Mongodb3_6_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_Mongod proto.InternalMessageInfo

func (m *Mongodb3_6_Mongod) GetConfig() *config.MongodConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb3_6_MongoCfg struct {
	Config *config.MongoCfgConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_MongoCfg) Reset()         { *m = Mongodb3_6_MongoCfg{} }
func (m *Mongodb3_6_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_MongoCfg) ProtoMessage()    {}
func (*Mongodb3_6_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3, 1}
}

func (m *Mongodb3_6_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Unmarshal(m, b)
}
func (m *Mongodb3_6_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_MongoCfg.Merge(m, src)
}
func (m *Mongodb3_6_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_MongoCfg.Size(m)
}
func (m *Mongodb3_6_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_MongoCfg proto.InternalMessageInfo

func (m *Mongodb3_6_MongoCfg) GetConfig() *config.MongoCfgConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb3_6_Mongos struct {
	Config *config.MongosConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb3_6_Mongos) Reset()         { *m = Mongodb3_6_Mongos{} }
func (m *Mongodb3_6_Mongos) String() string { return proto.CompactTextString(m) }
func (*Mongodb3_6_Mongos) ProtoMessage()    {}
func (*Mongodb3_6_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{3, 2}
}

func (m *Mongodb3_6_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb3_6_Mongos.Unmarshal(m, b)
}
func (m *Mongodb3_6_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb3_6_Mongos.Marshal(b, m, deterministic)
}
func (m *Mongodb3_6_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb3_6_Mongos.Merge(m, src)
}
func (m *Mongodb3_6_Mongos) XXX_Size() int {
	return xxx_messageInfo_Mongodb3_6_Mongos.Size(m)
}
func (m *Mongodb3_6_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb3_6_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb3_6_Mongos proto.InternalMessageInfo

func (m *Mongodb3_6_Mongos) GetConfig() *config.MongosConfigSet3_6 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb3_6_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_0 struct {
	// Configuration and resource allocation for mongod in a MongoDB 4.0 cluster.
	Mongod *Mongodb4_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.0 cluster.
	Mongocfg *Mongodb4_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.0 cluster.
	Mongos               *Mongodb4_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Mongodb4_0) Reset()         { *m = Mongodb4_0{} }
func (m *Mongodb4_0) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0) ProtoMessage()    {}
func (*Mongodb4_0) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4}
}

func (m *Mongodb4_0) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0.Unmarshal(m, b)
}
func (m *Mongodb4_0) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0.Merge(m, src)
}
func (m *Mongodb4_0) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0.Size(m)
}
func (m *Mongodb4_0) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0 proto.InternalMessageInfo

func (m *Mongodb4_0) GetMongod() *Mongodb4_0_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *Mongodb4_0) GetMongocfg() *Mongodb4_0_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *Mongodb4_0) GetMongos() *Mongodb4_0_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type Mongodb4_0_Mongod struct {
	// Configuration for mongod 4.0 hosts.
	Config *config.MongodConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_0_Mongod) Reset()         { *m = Mongodb4_0_Mongod{} }
func (m *Mongodb4_0_Mongod) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0_Mongod) ProtoMessage()    {}
func (*Mongodb4_0_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4, 0}
}

func (m *Mongodb4_0_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0_Mongod.Unmarshal(m, b)
}
func (m *Mongodb4_0_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0_Mongod.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0_Mongod.Merge(m, src)
}
func (m *Mongodb4_0_Mongod) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0_Mongod.Size(m)
}
func (m *Mongodb4_0_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0_Mongod proto.InternalMessageInfo

func (m *Mongodb4_0_Mongod) GetConfig() *config.MongodConfigSet4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_0_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_0_MongoCfg struct {
	// Configuration for mongocfg 4.0 hosts.
	Config *config.MongoCfgConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_0_MongoCfg) Reset()         { *m = Mongodb4_0_MongoCfg{} }
func (m *Mongodb4_0_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0_MongoCfg) ProtoMessage()    {}
func (*Mongodb4_0_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4, 1}
}

func (m *Mongodb4_0_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0_MongoCfg.Unmarshal(m, b)
}
func (m *Mongodb4_0_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0_MongoCfg.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0_MongoCfg.Merge(m, src)
}
func (m *Mongodb4_0_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0_MongoCfg.Size(m)
}
func (m *Mongodb4_0_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0_MongoCfg proto.InternalMessageInfo

func (m *Mongodb4_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_0_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_0_Mongos struct {
	// Configuration for mongos 4.0 hosts.
	Config *config.MongosConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_0_Mongos) Reset()         { *m = Mongodb4_0_Mongos{} }
func (m *Mongodb4_0_Mongos) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_0_Mongos) ProtoMessage()    {}
func (*Mongodb4_0_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{4, 2}
}

func (m *Mongodb4_0_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_0_Mongos.Unmarshal(m, b)
}
func (m *Mongodb4_0_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_0_Mongos.Marshal(b, m, deterministic)
}
func (m *Mongodb4_0_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_0_Mongos.Merge(m, src)
}
func (m *Mongodb4_0_Mongos) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_0_Mongos.Size(m)
}
func (m *Mongodb4_0_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_0_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_0_Mongos proto.InternalMessageInfo

func (m *Mongodb4_0_Mongos) GetConfig() *config.MongosConfigSet4_0 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_0_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_2 struct {
	// Configuration and resource allocation for mongod in a MongoDB 4.2 cluster.
	Mongod *Mongodb4_2_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.2 cluster.
	Mongocfg *Mongodb4_2_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.2 cluster.
	Mongos               *Mongodb4_2_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Mongodb4_2) Reset()         { *m = Mongodb4_2{} }
func (m *Mongodb4_2) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_2) ProtoMessage()    {}
func (*Mongodb4_2) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{5}
}

func (m *Mongodb4_2) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_2.Unmarshal(m, b)
}
func (m *Mongodb4_2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_2.Marshal(b, m, deterministic)
}
func (m *Mongodb4_2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_2.Merge(m, src)
}
func (m *Mongodb4_2) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_2.Size(m)
}
func (m *Mongodb4_2) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_2.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_2 proto.InternalMessageInfo

func (m *Mongodb4_2) GetMongod() *Mongodb4_2_Mongod {
	if m != nil {
		return m.Mongod
	}
	return nil
}

func (m *Mongodb4_2) GetMongocfg() *Mongodb4_2_MongoCfg {
	if m != nil {
		return m.Mongocfg
	}
	return nil
}

func (m *Mongodb4_2) GetMongos() *Mongodb4_2_Mongos {
	if m != nil {
		return m.Mongos
	}
	return nil
}

type Mongodb4_2_Mongod struct {
	// Configuration for mongod 4.2 hosts.
	Config *config.MongodConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_2_Mongod) Reset()         { *m = Mongodb4_2_Mongod{} }
func (m *Mongodb4_2_Mongod) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_2_Mongod) ProtoMessage()    {}
func (*Mongodb4_2_Mongod) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{5, 0}
}

func (m *Mongodb4_2_Mongod) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_2_Mongod.Unmarshal(m, b)
}
func (m *Mongodb4_2_Mongod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_2_Mongod.Marshal(b, m, deterministic)
}
func (m *Mongodb4_2_Mongod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_2_Mongod.Merge(m, src)
}
func (m *Mongodb4_2_Mongod) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_2_Mongod.Size(m)
}
func (m *Mongodb4_2_Mongod) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_2_Mongod.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_2_Mongod proto.InternalMessageInfo

func (m *Mongodb4_2_Mongod) GetConfig() *config.MongodConfigSet4_2 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_2_Mongod) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_2_MongoCfg struct {
	// Configuration for mongocfg 4.2 hosts.
	Config *config.MongoCfgConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_2_MongoCfg) Reset()         { *m = Mongodb4_2_MongoCfg{} }
func (m *Mongodb4_2_MongoCfg) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_2_MongoCfg) ProtoMessage()    {}
func (*Mongodb4_2_MongoCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{5, 1}
}

func (m *Mongodb4_2_MongoCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_2_MongoCfg.Unmarshal(m, b)
}
func (m *Mongodb4_2_MongoCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_2_MongoCfg.Marshal(b, m, deterministic)
}
func (m *Mongodb4_2_MongoCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_2_MongoCfg.Merge(m, src)
}
func (m *Mongodb4_2_MongoCfg) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_2_MongoCfg.Size(m)
}
func (m *Mongodb4_2_MongoCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_2_MongoCfg.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_2_MongoCfg proto.InternalMessageInfo

func (m *Mongodb4_2_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_2 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_2_MongoCfg) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Mongodb4_2_Mongos struct {
	// Configuration for mongos 4.2 hosts.
	Config *config.MongosConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources            *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Mongodb4_2_Mongos) Reset()         { *m = Mongodb4_2_Mongos{} }
func (m *Mongodb4_2_Mongos) String() string { return proto.CompactTextString(m) }
func (*Mongodb4_2_Mongos) ProtoMessage()    {}
func (*Mongodb4_2_Mongos) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{5, 2}
}

func (m *Mongodb4_2_Mongos) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mongodb4_2_Mongos.Unmarshal(m, b)
}
func (m *Mongodb4_2_Mongos) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mongodb4_2_Mongos.Marshal(b, m, deterministic)
}
func (m *Mongodb4_2_Mongos) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mongodb4_2_Mongos.Merge(m, src)
}
func (m *Mongodb4_2_Mongos) XXX_Size() int {
	return xxx_messageInfo_Mongodb4_2_Mongos.Size(m)
}
func (m *Mongodb4_2_Mongos) XXX_DiscardUnknown() {
	xxx_messageInfo_Mongodb4_2_Mongos.DiscardUnknown(m)
}

var xxx_messageInfo_Mongodb4_2_Mongos proto.InternalMessageInfo

func (m *Mongodb4_2_Mongos) GetConfig() *config.MongosConfigSet4_2 {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Mongodb4_2_Mongos) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Shard struct {
	// Name of the shard.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId            string   `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{6}
}

func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (m *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(m, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Shard) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type Host struct {
	// Name of the MongoDB host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the MongoDB host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the MongoDB host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the MongoDB host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Shard which this host belongs to.
	ShardName string `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// Host type
	Type                 Host_Type `protobuf:"varint,11,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{7}
}

func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (m *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(m, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetRole() Host_Role {
	if m != nil {
		return m.Role
	}
	return Host_ROLE_UNKNOWN
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *Host) GetShardName() string {
	if m != nil {
		return m.ShardName
	}
	return ""
}

func (m *Host) GetType() Host_Type {
	if m != nil {
		return m.Type
	}
	return Host_TYPE_UNSPECIFIED
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{8}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-mongodb/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-ssd — network SSD drive,
	// * local-ssd — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{9}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

type Access struct {
	// Allow access for DataLens
	DataLens             bool     `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Access) Reset()         { *m = Access{} }
func (m *Access) String() string { return proto.CompactTextString(m) }
func (*Access) ProtoMessage()    {}
func (*Access) Descriptor() ([]byte, []int) {
	return fileDescriptor_ccaf7a2567168975, []int{10}
}

func (m *Access) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Access.Unmarshal(m, b)
}
func (m *Access) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Access.Marshal(b, m, deterministic)
}
func (m *Access) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Access.Merge(m, src)
}
func (m *Access) XXX_Size() int {
	return xxx_messageInfo_Access.Size(m)
}
func (m *Access) XXX_DiscardUnknown() {
	xxx_messageInfo_Access.DiscardUnknown(m)
}

var xxx_messageInfo_Access proto.InternalMessageInfo

func (m *Access) GetDataLens() bool {
	if m != nil {
		return m.DataLens
	}
	return false
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Type", Host_Type_name, Host_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Role", Host_Role_name, Host_Role_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.mongodb.v1.Service_Health", Service_Health_name, Service_Health_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.mongodb.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.mongodb.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.mongodb.v1.ClusterConfig")
	proto.RegisterType((*Mongodb3_6)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6")
	proto.RegisterType((*Mongodb3_6_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod")
	proto.RegisterType((*Mongodb3_6_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg")
	proto.RegisterType((*Mongodb3_6_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos")
	proto.RegisterType((*Mongodb4_0)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0")
	proto.RegisterType((*Mongodb4_0_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod")
	proto.RegisterType((*Mongodb4_0_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg")
	proto.RegisterType((*Mongodb4_0_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos")
	proto.RegisterType((*Mongodb4_2)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_2")
	proto.RegisterType((*Mongodb4_2_Mongod)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod")
	proto.RegisterType((*Mongodb4_2_MongoCfg)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg")
	proto.RegisterType((*Mongodb4_2_Mongos)(nil), "yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos")
	proto.RegisterType((*Shard)(nil), "yandex.cloud.mdb.mongodb.v1.Shard")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.mongodb.v1.Host")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.mongodb.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.mongodb.v1.Resources")
	proto.RegisterType((*Access)(nil), "yandex.cloud.mdb.mongodb.v1.Access")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/mongodb/v1/cluster.proto", fileDescriptor_ccaf7a2567168975)
}

var fileDescriptor_ccaf7a2567168975 = []byte{
	// 1460 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0xdb, 0x6e, 0xdb, 0x46,
	0x13, 0x8e, 0x0e, 0xa6, 0xc4, 0x91, 0x63, 0xf0, 0xdf, 0x3f, 0x68, 0x04, 0x1b, 0x41, 0x0c, 0xf5,
	0xe4, 0xb4, 0x0d, 0xa5, 0xc8, 0x86, 0x91, 0x38, 0x28, 0x1a, 0x59, 0xa2, 0x6d, 0xa2, 0x32, 0x25,
	0xac, 0x64, 0x07, 0xe9, 0x0d, 0x41, 0x89, 0x2b, 0x99, 0x35, 0x45, 0x0a, 0x24, 0xe5, 0x44, 0xb9,
	0xee, 0x73, 0xf4, 0xa2, 0xef, 0xd0, 0x07, 0xe9, 0x55, 0xef, 0xfa, 0x2c, 0xc5, 0x1e, 0x28, 0xd3,
	0x6e, 0xab, 0xc8, 0xae, 0x0c, 0xa4, 0x77, 0xbb, 0xb3, 0xf3, 0x7d, 0x9a, 0xf9, 0x76, 0x76, 0xc5,
	0x59, 0x78, 0x32, 0xb5, 0x3c, 0x9b, 0xbc, 0x2b, 0xf7, 0x5d, 0x7f, 0x62, 0x97, 0x47, 0x76, 0xaf,
	0x3c, 0xf2, 0xbd, 0xa1, 0x6f, 0xf7, 0xca, 0x17, 0xcf, 0xca, 0x7d, 0x77, 0x12, 0x46, 0x24, 0x50,
	0xc7, 0x81, 0x1f, 0xf9, 0x68, 0x83, 0xbb, 0xaa, 0xcc, 0x55, 0x1d, 0xd9, 0x3d, 0x55, 0xb8, 0xaa,
	0x17, 0xcf, 0xd6, 0x1f, 0x0f, 0x7d, 0x7f, 0xe8, 0x92, 0x32, 0x73, 0xed, 0x4d, 0x06, 0xe5, 0xc8,
	0x19, 0x91, 0x30, 0xb2, 0x46, 0x63, 0x8e, 0x5e, 0xdf, 0x10, 0x0e, 0xd1, 0x74, 0x4c, 0xd8, 0xa2,
	0x3f, 0xb0, 0xad, 0xa9, 0x58, 0xdc, 0x9e, 0x1b, 0x85, 0xef, 0x0d, 0x9c, 0x61, 0x6c, 0xd9, 0x36,
	0x77, 0x6f, 0x0e, 0xda, 0x31, 0x2b, 0xb7, 0x01, 0x55, 0x39, 0xa8, 0xf4, 0x7b, 0x0e, 0x72, 0x75,
	0xae, 0x05, 0x5a, 0x83, 0xb4, 0x63, 0x17, 0x53, 0x9b, 0xa9, 0x2d, 0x19, 0xa7, 0x1d, 0x1b, 0x6d,
	0x80, 0x3c, 0xf0, 0x5d, 0x9b, 0x04, 0xa6, 0x63, 0x17, 0xd3, 0xcc, 0x9c, 0xe7, 0x06, 0xdd, 0x46,
	0x2f, 0x00, 0xfa, 0x01, 0xb1, 0x22, 0x62, 0x9b, 0x56, 0x54, 0xcc, 0x6c, 0xa6, 0xb6, 0x0a, 0xd5,
	0x75, 0x95, 0x2b, 0xa1, 0xc6, 0x52, 0xa9, 0xdd, 0x58, 0x2a, 0x2c, 0x0b, 0xef, 0x5a, 0x84, 0x10,
	0x64, 0x3d, 0x6b, 0x44, 0x8a, 0x59, 0x46, 0xc9, 0xc6, 0x68, 0x13, 0x0a, 0x36, 0x09, 0xfb, 0x81,
	0x33, 0x8e, 0x1c, 0xdf, 0x2b, 0xae, 0xb0, 0xa5, 0xa4, 0x09, 0x1d, 0x81, 0xe4, 0x5a, 0x3d, 0xe2,
	0x86, 0x45, 0x69, 0x33, 0xb3, 0x55, 0xa8, 0x56, 0xd4, 0x39, 0x9b, 0xa6, 0x8a, 0x9c, 0xd4, 0x26,
	0x83, 0x68, 0x5e, 0x14, 0x4c, 0xb1, 0xc0, 0x23, 0x0c, 0x05, 0xe2, 0x5d, 0x38, 0x81, 0xef, 0x8d,
	0x88, 0x17, 0x15, 0x73, 0x9b, 0xa9, 0xad, 0xb5, 0x05, 0xe9, 0xb4, 0x4b, 0x1c, 0x4e, 0x92, 0xa0,
	0x43, 0x80, 0x91, 0xef, 0x39, 0x91, 0x1f, 0x38, 0xde, 0xb0, 0x98, 0x67, 0x11, 0x7e, 0x39, 0x97,
	0xf2, 0x78, 0xe6, 0x8e, 0x13, 0x50, 0xb4, 0x0f, 0x12, 0xdf, 0xab, 0xa2, 0xcc, 0x34, 0xfd, 0x6a,
	0x91, 0xb8, 0xea, 0x0c, 0x81, 0x05, 0x12, 0x3d, 0x02, 0xf0, 0x48, 0xf4, 0xd6, 0x0f, 0xce, 0xe9,
	0xce, 0x01, 0xd3, 0x52, 0x16, 0x16, 0xdd, 0x46, 0x75, 0x90, 0xce, 0x88, 0xe5, 0x46, 0x67, 0xc5,
	0x02, 0x4b, 0xfd, 0xeb, 0x85, 0x52, 0x3f, 0x62, 0x10, 0x2c, 0xa0, 0x94, 0x24, 0x8c, 0xac, 0x68,
	0x12, 0x16, 0x57, 0x6f, 0x40, 0xd2, 0x61, 0x10, 0x2c, 0xa0, 0xa8, 0x08, 0xb9, 0xf0, 0xcc, 0x0a,
	0x6c, 0x62, 0x17, 0xef, 0x6f, 0xa6, 0xb6, 0xf2, 0x38, 0x9e, 0xae, 0xbf, 0x80, 0x42, 0x62, 0xeb,
	0x90, 0x02, 0x99, 0x73, 0x32, 0x15, 0xb5, 0x49, 0x87, 0xe8, 0x01, 0xac, 0x5c, 0x58, 0xee, 0x84,
	0x88, 0xc2, 0xe4, 0x93, 0xbd, 0xf4, 0xf3, 0x54, 0x49, 0x87, 0x42, 0x62, 0x9b, 0xd0, 0x06, 0x3c,
	0xd4, 0x8c, 0x53, 0x1d, 0xb7, 0x8c, 0x63, 0xcd, 0xe8, 0x9a, 0x27, 0x46, 0xa7, 0xad, 0xd5, 0xf5,
	0x03, 0x5d, 0x6b, 0x28, 0xf7, 0xd0, 0x1a, 0x40, 0x1b, 0xb7, 0x1a, 0x27, 0xf5, 0xae, 0xde, 0x32,
	0x94, 0x14, 0xba, 0x0f, 0x72, 0x1b, 0x6b, 0x9d, 0x6e, 0x6d, 0xbf, 0xa9, 0x29, 0xe9, 0xd2, 0x77,
	0x20, 0xf1, 0xb4, 0x11, 0x82, 0xb5, 0x23, 0xad, 0xd6, 0xec, 0x1e, 0x99, 0x27, 0xc6, 0xf7, 0x46,
	0xeb, 0xb5, 0xa1, 0xdc, 0x43, 0x32, 0xac, 0xd4, 0x9a, 0xfa, 0xa9, 0xa6, 0xa4, 0x50, 0x1e, 0xb2,
	0x0d, 0xad, 0xd6, 0x50, 0xd2, 0x68, 0x15, 0xf2, 0x0d, 0xed, 0x10, 0xd7, 0x1a, 0x5a, 0x43, 0xc9,
	0x94, 0xa6, 0x20, 0xf1, 0x94, 0x29, 0x41, 0xa7, 0x5b, 0xeb, 0x9e, 0x74, 0x12, 0x04, 0xab, 0x90,
	0xaf, 0x63, 0xad, 0xd6, 0xd5, 0x8d, 0x43, 0x25, 0x85, 0x0a, 0x90, 0xc3, 0x27, 0x86, 0x41, 0x27,
	0x69, 0xca, 0xad, 0x61, 0xdc, 0xc2, 0x4a, 0x86, 0x7a, 0x9d, 0xb4, 0x1b, 0xdc, 0x2b, 0x4b, 0x67,
	0x9d, 0x6e, 0xab, 0xdd, 0xa6, 0xb3, 0x15, 0x8a, 0x61, 0x33, 0xad, 0xa1, 0x48, 0x7c, 0xa9, 0x86,
	0x99, 0x63, 0xae, 0x74, 0x0a, 0x70, 0x59, 0x62, 0xb3, 0x33, 0x97, 0xfa, 0xe7, 0x33, 0x97, 0xfe,
	0xeb, 0x99, 0x43, 0x90, 0x75, 0x1d, 0xef, 0x9c, 0x1d, 0x6f, 0x19, 0xb3, 0x71, 0xe9, 0x8f, 0x0c,
	0xdc, 0xbf, 0x52, 0x76, 0x74, 0x17, 0x2f, 0x48, 0x10, 0x52, 0x0e, 0x4e, 0x1f, 0x4f, 0xd1, 0x3e,
	0x3c, 0x1a, 0x10, 0x2b, 0x9a, 0x04, 0xc4, 0xec, 0xfb, 0xa3, 0xb1, 0x15, 0x39, 0x3d, 0xc7, 0x75,
	0xa2, 0xa9, 0x19, 0xfb, 0xf3, 0x73, 0xbe, 0x21, 0x9c, 0xea, 0x49, 0x9f, 0x53, 0xc1, 0xa1, 0x43,
	0x41, 0x14, 0x92, 0xb9, 0x6d, 0xee, 0xb2, 0x28, 0x17, 0x38, 0x5a, 0xe2, 0x3e, 0x3d, 0xba, 0x87,
	0xe5, 0xf8, 0x76, 0xdd, 0x4d, 0x52, 0xed, 0x98, 0x15, 0x76, 0xff, 0x2c, 0x48, 0xb5, 0x63, 0x56,
	0x12, 0x54, 0x3b, 0x95, 0xab, 0x54, 0x55, 0x76, 0x87, 0x2c, 0x4c, 0x55, 0x4d, 0x52, 0x55, 0xd1,
	0x01, 0xfc, 0xbf, 0x67, 0xf5, 0xcf, 0x27, 0x63, 0xf3, 0xad, 0xe3, 0xd9, 0xfe, 0x5b, 0x33, 0x8c,
	0xac, 0x20, 0xbe, 0x52, 0x3f, 0x89, 0xaf, 0x54, 0xfa, 0xe7, 0xc2, 0xae, 0xd3, 0xd6, 0xa0, 0x61,
	0x4d, 0xf1, 0xff, 0x38, 0xe4, 0x35, 0x43, 0x74, 0x28, 0x00, 0xbd, 0x04, 0xc9, 0xea, 0xf7, 0x49,
	0x48, 0x2f, 0x48, 0x0a, 0xfd, 0x74, 0x6e, 0x34, 0x35, 0xe6, 0x8a, 0x05, 0x64, 0x5f, 0x86, 0x9c,
	0x58, 0x2c, 0xfd, 0xb6, 0xc2, 0x2a, 0x47, 0x28, 0x88, 0x0e, 0x40, 0xe2, 0x2b, 0x6c, 0x73, 0x0b,
	0x55, 0x75, 0x41, 0xe9, 0xc5, 0x10, 0x0b, 0x34, 0x6a, 0x42, 0x9e, 0x8d, 0xfa, 0x83, 0xa1, 0xd8,
	0xc4, 0xca, 0x8d, 0x98, 0xea, 0x83, 0x21, 0x9e, 0x31, 0xcc, 0xa2, 0x0a, 0x85, 0x4e, 0x37, 0x8b,
	0x2a, 0x14, 0x51, 0x85, 0xeb, 0x3f, 0xa7, 0x40, 0xe2, 0xab, 0xc8, 0x98, 0xdd, 0xbc, 0x3c, 0xd1,
	0xdd, 0xb9, 0x94, 0xdc, 0x55, 0x30, 0xf3, 0x83, 0xd0, 0x21, 0xd1, 0xb6, 0xb9, 0x3b, 0xbb, 0x85,
	0x1b, 0x20, 0x07, 0x24, 0xf4, 0x27, 0x41, 0x9f, 0x84, 0x22, 0xe3, 0x2f, 0xe6, 0x52, 0xe2, 0xd8,
	0x1b, 0x5f, 0x02, 0xd7, 0x7f, 0x49, 0x41, 0x3e, 0xce, 0x1f, 0xb5, 0xaf, 0x85, 0xf8, 0x7c, 0xe1,
	0x10, 0xeb, 0x83, 0xe1, 0x1d, 0x06, 0x39, 0x53, 0x31, 0xfc, 0x17, 0x2a, 0x86, 0x77, 0x17, 0x60,
	0xb2, 0xa6, 0x77, 0xcc, 0xca, 0xed, 0x6a, 0x9a, 0x7e, 0x69, 0x2d, 0xa7, 0xa6, 0x67, 0x4c, 0x4b,
	0xa8, 0xe9, 0x19, 0xd7, 0x9d, 0xd5, 0xf4, 0x8e, 0x59, 0xf9, 0xf8, 0x6b, 0x7a, 0xf9, 0x41, 0x2e,
	0xb9, 0xa6, 0x97, 0x1e, 0xe0, 0xd5, 0x9a, 0xae, 0xde, 0xb6, 0xa6, 0xab, 0x4b, 0xab, 0xe9, 0xea,
	0x12, 0x6b, 0xba, 0x7a, 0xe7, 0x35, 0x5d, 0xfd, 0x2f, 0xd4, 0x74, 0xf5, 0x63, 0xaf, 0xe9, 0x25,
	0x07, 0x58, 0xda, 0x83, 0x95, 0x0e, 0xed, 0x00, 0xfe, 0xf6, 0x7b, 0xf5, 0x11, 0x80, 0x68, 0xdb,
	0x2f, 0x1b, 0x52, 0x59, 0x58, 0x74, 0xbb, 0xf4, 0xeb, 0x0a, 0x64, 0x8f, 0xfc, 0x30, 0xba, 0x05,
	0x16, 0x3d, 0x84, 0xdc, 0x7b, 0xdf, 0x23, 0x74, 0x8d, 0x7f, 0xeb, 0x4a, 0x74, 0xaa, 0xdb, 0x57,
	0xd3, 0xca, 0xde, 0x32, 0x2d, 0xb4, 0x07, 0xd9, 0xc0, 0x77, 0x09, 0xfb, 0xdc, 0x5d, 0xfb, 0x00,
	0x01, 0x4d, 0x41, 0xc5, 0xbe, 0x4b, 0x30, 0xc3, 0xa0, 0x57, 0xb3, 0x6e, 0x4d, 0x62, 0xe8, 0xad,
	0x0f, 0xa3, 0xaf, 0xb5, 0x6a, 0xaf, 0x20, 0x1f, 0x92, 0xe0, 0xc2, 0xa1, 0x29, 0xe4, 0x58, 0x67,
	0xfa, 0xd9, 0x5c, 0x8e, 0x0e, 0x77, 0xc6, 0x33, 0x14, 0xda, 0x00, 0x39, 0x9c, 0xf4, 0x3c, 0x12,
	0x51, 0x81, 0xf2, 0xfc, 0x25, 0x80, 0x1b, 0x74, 0x1b, 0x6d, 0x81, 0x62, 0x85, 0xa1, 0x33, 0xf4,
	0xcc, 0xf1, 0xa4, 0xe7, 0x3a, 0x7d, 0xd3, 0x19, 0xb3, 0xde, 0x35, 0x8f, 0xd7, 0xb8, 0xbd, 0xcd,
	0xcc, 0xfa, 0x98, 0x6e, 0x02, 0xeb, 0xef, 0x4c, 0xb6, 0x3d, 0xa2, 0x2f, 0x65, 0x16, 0x83, 0xee,
	0xd1, 0x1e, 0x64, 0xe9, 0x57, 0xae, 0xe8, 0x4a, 0x17, 0x50, 0xa9, 0x3b, 0x1d, 0x13, 0xcc, 0x30,
	0xa5, 0x7d, 0xc8, 0xd2, 0x19, 0x7a, 0x00, 0x4a, 0xf7, 0x4d, 0x5b, 0xbb, 0xd6, 0xe6, 0x01, 0x48,
	0xc7, 0x2d, 0xe3, 0xb0, 0xd5, 0x50, 0x52, 0xb3, 0x71, 0x87, 0x37, 0x6b, 0x6c, 0x5c, 0x3f, 0x38,
	0x54, 0x32, 0xa5, 0x1d, 0xc8, 0x52, 0xdd, 0x91, 0x02, 0xab, 0xb8, 0xd5, 0xd4, 0x12, 0x8d, 0x5a,
	0x01, 0x72, 0x6d, 0xac, 0x1f, 0xd7, 0xf0, 0x1b, 0xde, 0x23, 0x76, 0xb4, 0x7a, 0xcb, 0x68, 0xd0,
	0xe9, 0x12, 0x7a, 0xc4, 0x9f, 0xd2, 0x90, 0x13, 0x92, 0xa3, 0x6f, 0x85, 0x04, 0x29, 0x26, 0xc1,
	0x93, 0x45, 0xb6, 0x29, 0xa1, 0x42, 0xa2, 0xb3, 0x4f, 0x2f, 0xd0, 0x94, 0xc7, 0x04, 0x57, 0xcb,
	0x65, 0x29, 0x52, 0x3e, 0xbb, 0xb1, 0x28, 0xa5, 0x77, 0x20, 0xcf, 0xce, 0x0e, 0xfa, 0x06, 0x50,
	0x7c, 0x7a, 0xcc, 0x71, 0x40, 0x42, 0x5e, 0x79, 0xfc, 0x40, 0x2b, 0xf1, 0x4a, 0x9b, 0x2d, 0xe8,
	0xec, 0xa1, 0xca, 0x76, 0xc2, 0x73, 0x33, 0x74, 0xde, 0xf3, 0xf7, 0x80, 0x0c, 0xce, 0x53, 0x43,
	0xc7, 0x79, 0x4f, 0xbb, 0xdc, 0x55, 0xb6, 0x48, 0x05, 0xba, 0x3c, 0xdf, 0x40, 0x6d, 0x34, 0x4d,
	0xdd, 0x2e, 0x7d, 0x0e, 0x12, 0xef, 0x86, 0x18, 0x91, 0x15, 0x59, 0xa6, 0x4b, 0xbc, 0x90, 0xfd,
	0x5a, 0x1e, 0xe7, 0xa9, 0xa1, 0x49, 0xbc, 0x70, 0xff, 0x47, 0x78, 0x7c, 0x45, 0x4d, 0x6b, 0xec,
	0x5c, 0x53, 0xf4, 0x87, 0xc3, 0xa1, 0x13, 0x9d, 0x4d, 0x7a, 0x6a, 0xdf, 0x1f, 0x95, 0xb9, 0xef,
	0x53, 0xfe, 0x1a, 0x37, 0xf4, 0x9f, 0x0e, 0x89, 0xc7, 0x9e, 0xc5, 0xca, 0x73, 0x9e, 0xe9, 0x5e,
	0x8a, 0x61, 0x4f, 0x62, 0xae, 0xdb, 0x7f, 0x06, 0x00, 0x00, 0xff, 0xff, 0x1d, 0x69, 0x6a, 0x68,
	0xc4, 0x14, 0x00, 0x00,
}
