// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/mysql/v1/cluster.proto

package mysql

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mysql/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}

var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}

func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}

func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{0, 2}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the master MySQL server in the cluster.
	Host_MASTER Host_Role = 1
	// Host is a replica MySQL server in the cluster.
	Host_REPLICA Host_Role = 2
)

var Host_Role_name = map[int32]string{
	0: "ROLE_UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
}

var Host_Role_value = map[string]int32{
	"ROLE_UNKNOWN": 0,
	"MASTER":       1,
	"REPLICA":      2,
}

func (x Host_Role) String() string {
	return proto.EnumName(Host_Role_name, int32(x))
}

func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{3, 0}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Host_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}

func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{3, 1}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a MySQL server.
	Service_MYSQL Service_Type = 1
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "MYSQL",
}

var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"MYSQL":            1,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}

func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{4, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}

var Service_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}

func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{4, 1}
}

// A MySQL cluster. For more information, see
// the [documentation](/docs/managed-mysql/concepts).
type Cluster struct {
	// ID of the MySQL cluster.
	// This ID is assigned by Managed Service for MySQL at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the MySQL cluster belongs to.
	FolderId  string               `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the MySQL cluster.
	// The name must be unique within the folder, comply with RFC 1035
	// and be 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MySQL cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MySQL cluster as `key:value` pairs.
	// Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MySQL cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mysql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the MySQL cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the MySQL cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.mysql.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status               Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.mysql.v1.Cluster_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the MySQL cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{1}
}

func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (m *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(m, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of MySQL server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for MySQL servers in the cluster.
	//
	// Types that are valid to be assigned to MysqlConfig:
	//	*ClusterConfig_MysqlConfig_5_7
	//	*ClusterConfig_MysqlConfig_8_0
	MysqlConfig isClusterConfig_MysqlConfig `protobuf_oneof:"mysql_config"`
	// Resources allocated to MySQL hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,5,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{2}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isClusterConfig_MysqlConfig interface {
	isClusterConfig_MysqlConfig()
}

type ClusterConfig_MysqlConfig_5_7 struct {
	MysqlConfig_5_7 *config.MysqlConfigSet5_7 `protobuf:"bytes,2,opt,name=mysql_config_5_7,json=mysqlConfig57,proto3,oneof"`
}

type ClusterConfig_MysqlConfig_8_0 struct {
	MysqlConfig_8_0 *config.MysqlConfigSet8_0 `protobuf:"bytes,6,opt,name=mysql_config_8_0,json=mysqlConfig80,proto3,oneof"`
}

func (*ClusterConfig_MysqlConfig_5_7) isClusterConfig_MysqlConfig() {}

func (*ClusterConfig_MysqlConfig_8_0) isClusterConfig_MysqlConfig() {}

func (m *ClusterConfig) GetMysqlConfig() isClusterConfig_MysqlConfig {
	if m != nil {
		return m.MysqlConfig
	}
	return nil
}

func (m *ClusterConfig) GetMysqlConfig_5_7() *config.MysqlConfigSet5_7 {
	if x, ok := m.GetMysqlConfig().(*ClusterConfig_MysqlConfig_5_7); ok {
		return x.MysqlConfig_5_7
	}
	return nil
}

func (m *ClusterConfig) GetMysqlConfig_8_0() *config.MysqlConfigSet8_0 {
	if x, ok := m.GetMysqlConfig().(*ClusterConfig_MysqlConfig_8_0); ok {
		return x.MysqlConfig_8_0
	}
	return nil
}

func (m *ClusterConfig) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ClusterConfig) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ClusterConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ClusterConfig_MysqlConfig_5_7)(nil),
		(*ClusterConfig_MysqlConfig_8_0)(nil),
	}
}

type Host struct {
	// Name of the MySQL host. The host name is assigned by Managed Service for MySQL
	// at creation time, and cannot be changed. 1-63 characters long.
	//
	// The name is unique across all existing database hosts in Yandex.Cloud,
	// as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the MySQL host. The ID is assigned by Managed Service for MySQL
	// at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the MySQL host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.mysql.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.mysql.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp       bool     `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{3}
}

func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (m *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(m, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetRole() Host_Role {
	if m != nil {
		return m.Role
	}
	return Host_ROLE_UNKNOWN
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.mysql.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.mysql.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{4}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-mysql/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-ssd — network SSD drive,
	// * local-ssd — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{5}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

type Access struct {
	// Allow access for DataLens
	DataLens             bool     `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Access) Reset()         { *m = Access{} }
func (m *Access) String() string { return proto.CompactTextString(m) }
func (*Access) ProtoMessage()    {}
func (*Access) Descriptor() ([]byte, []int) {
	return fileDescriptor_4544583b17c4e771, []int{6}
}

func (m *Access) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Access.Unmarshal(m, b)
}
func (m *Access) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Access.Marshal(b, m, deterministic)
}
func (m *Access) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Access.Merge(m, src)
}
func (m *Access) XXX_Size() int {
	return xxx_messageInfo_Access.Size(m)
}
func (m *Access) XXX_DiscardUnknown() {
	xxx_messageInfo_Access.DiscardUnknown(m)
}

var xxx_messageInfo_Access proto.InternalMessageInfo

func (m *Access) GetDataLens() bool {
	if m != nil {
		return m.DataLens
	}
	return false
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.Host_Role", Host_Role_name, Host_Role_value)
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.mysql.v1.Service_Health", Service_Health_name, Service_Health_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.mysql.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.mysql.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.mysql.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.mysql.v1.ClusterConfig")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.mysql.v1.Host")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.mysql.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.mysql.v1.Resources")
	proto.RegisterType((*Access)(nil), "yandex.cloud.mdb.mysql.v1.Access")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/mysql/v1/cluster.proto", fileDescriptor_4544583b17c4e771)
}

var fileDescriptor_4544583b17c4e771 = []byte{
	// 1177 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xef, 0x72, 0xda, 0xc6,
	0x17, 0x0d, 0x20, 0x0b, 0x74, 0x21, 0x8c, 0x7e, 0xfb, 0xcb, 0x34, 0xaa, 0x33, 0x99, 0xba, 0x9a,
	0xa6, 0xa1, 0x33, 0x8d, 0xb0, 0xc9, 0x78, 0x4c, 0x9a, 0x99, 0xb4, 0x32, 0x28, 0xb1, 0xa6, 0x18,
	0xe8, 0x4a, 0x24, 0x93, 0x7e, 0xa8, 0x46, 0xa0, 0x35, 0xd6, 0x58, 0x48, 0x54, 0x12, 0x38, 0xf8,
	0x15, 0xfa, 0x34, 0x7d, 0x83, 0xbe, 0x4c, 0xdf, 0xa3, 0xb3, 0xbb, 0xc2, 0x60, 0xa7, 0xc6, 0x4e,
	0xa6, 0xdf, 0x74, 0xff, 0x9c, 0xa3, 0xbd, 0x77, 0xef, 0x9e, 0x5d, 0x78, 0xba, 0x70, 0x43, 0x8f,
	0x7c, 0xa8, 0x8f, 0x82, 0x68, 0xe6, 0xd5, 0x27, 0xde, 0xb0, 0x3e, 0x59, 0x24, 0xbf, 0x07, 0xf5,
	0xf9, 0x5e, 0x7d, 0x14, 0xcc, 0x92, 0x94, 0xc4, 0xda, 0x34, 0x8e, 0xd2, 0x08, 0x7d, 0xc9, 0x13,
	0x35, 0x96, 0xa8, 0x4d, 0xbc, 0xa1, 0xc6, 0x12, 0xb5, 0xf9, 0xde, 0xf6, 0x57, 0xe3, 0x28, 0x1a,
	0x07, 0xa4, 0xce, 0x12, 0x87, 0xb3, 0x93, 0x7a, 0xea, 0x4f, 0x48, 0x92, 0xba, 0x93, 0x29, 0xc7,
	0x6e, 0x3f, 0xca, 0x12, 0xd2, 0xc5, 0x94, 0xb0, 0x60, 0x74, 0xe2, 0xb9, 0x8b, 0x2c, 0x58, 0xdf,
	0xb0, 0x82, 0x28, 0x3c, 0xf1, 0xc7, 0xdc, 0xde, 0x77, 0x0e, 0x3e, 0x0d, 0xd0, 0x74, 0x76, 0x39,
	0x40, 0xfd, 0xb3, 0x08, 0xc5, 0x16, 0x2f, 0x06, 0x55, 0x21, 0xef, 0x7b, 0x4a, 0x6e, 0x27, 0x57,
	0x93, 0x70, 0xde, 0xf7, 0xd0, 0x23, 0x90, 0x4e, 0xa2, 0xc0, 0x23, 0xb1, 0xe3, 0x7b, 0x4a, 0x9e,
	0xb9, 0x4b, 0xdc, 0x61, 0x7a, 0xe8, 0x05, 0xc0, 0x28, 0x26, 0x6e, 0x4a, 0x3c, 0xc7, 0x4d, 0x95,
	0xc2, 0x4e, 0xae, 0x56, 0x6e, 0x6c, 0x6b, 0xbc, 0x18, 0x6d, 0x59, 0xad, 0x66, 0x2f, 0xab, 0xc5,
	0x52, 0x96, 0xad, 0xa7, 0x08, 0x81, 0x10, 0xba, 0x13, 0xa2, 0x08, 0x8c, 0x92, 0x7d, 0xa3, 0x1d,
	0x28, 0x7b, 0x24, 0x19, 0xc5, 0xfe, 0x34, 0xf5, 0xa3, 0x50, 0xd9, 0x62, 0xa1, 0x75, 0x17, 0x7a,
	0x0d, 0x62, 0xe0, 0x0e, 0x49, 0x90, 0x28, 0xe2, 0x4e, 0xa1, 0x56, 0x6e, 0x68, 0xda, 0x8d, 0x5d,
	0xd7, 0xb2, 0x8a, 0xb4, 0x0e, 0x03, 0x18, 0x61, 0x1a, 0x2f, 0x70, 0x86, 0x46, 0x7d, 0x28, 0x93,
	0x70, 0xee, 0xc7, 0x51, 0x38, 0x21, 0x61, 0xaa, 0x14, 0x77, 0x72, 0xb5, 0xea, 0x9d, 0xc8, 0x8c,
	0x15, 0x0a, 0xaf, 0x53, 0x20, 0x03, 0x60, 0x12, 0x85, 0x7e, 0x1a, 0xc5, 0x7e, 0x38, 0x56, 0x4a,
	0x6c, 0x75, 0x4f, 0x36, 0x10, 0x1e, 0x5f, 0x26, 0xe3, 0x35, 0x20, 0xfa, 0x09, 0x44, 0xbe, 0x47,
	0x8a, 0xc4, 0xba, 0x59, 0xbb, 0x7d, 0x4d, 0x2d, 0x96, 0x8f, 0x33, 0x1c, 0x7a, 0x0c, 0x10, 0x92,
	0xf4, 0x3c, 0x8a, 0xcf, 0xe8, 0x8e, 0x01, 0xeb, 0xa1, 0x94, 0x79, 0x4c, 0x0f, 0xe9, 0x20, 0x9e,
	0x12, 0x37, 0x48, 0x4f, 0x95, 0x32, 0x2b, 0xfa, 0xbb, 0x3b, 0x14, 0x7d, 0xc4, 0x00, 0x38, 0x03,
	0x52, 0x8a, 0x24, 0x75, 0xd3, 0x59, 0xa2, 0x54, 0xee, 0x4c, 0x61, 0x31, 0x00, 0xce, 0x80, 0xdb,
	0x2f, 0xa0, 0xbc, 0xb6, 0x2d, 0x48, 0x86, 0xc2, 0x19, 0x59, 0x64, 0x53, 0x47, 0x3f, 0xd1, 0x03,
	0xd8, 0x9a, 0xbb, 0xc1, 0x8c, 0x64, 0x23, 0xc7, 0x8d, 0x1f, 0xf2, 0xcd, 0x9c, 0x6a, 0x42, 0x79,
	0x6d, 0x13, 0xd0, 0x23, 0x78, 0x68, 0x74, 0xdf, 0x9a, 0xb8, 0xd7, 0x3d, 0x36, 0xba, 0xb6, 0x33,
	0xe8, 0x5a, 0x7d, 0xa3, 0x65, 0xbe, 0x36, 0x8d, 0xb6, 0x7c, 0x0f, 0x55, 0x01, 0xfa, 0xb8, 0xd7,
	0x1e, 0xb4, 0x6c, 0xb3, 0xd7, 0x95, 0x73, 0xe8, 0x3e, 0x48, 0x7d, 0x6c, 0x58, 0xb6, 0x7e, 0xd8,
	0x31, 0xe4, 0xbc, 0xfa, 0x23, 0x88, 0xbc, 0x34, 0x84, 0xa0, 0x7a, 0x64, 0xe8, 0x1d, 0xfb, 0xc8,
	0x19, 0x74, 0x7f, 0xee, 0xf6, 0xde, 0x75, 0xe5, 0x7b, 0x48, 0x82, 0x2d, 0xbd, 0x63, 0xbe, 0x35,
	0xe4, 0x1c, 0x2a, 0x81, 0xd0, 0x36, 0xf4, 0xb6, 0x9c, 0x47, 0x15, 0x28, 0xb5, 0x8d, 0x37, 0x58,
	0x6f, 0x1b, 0x6d, 0xb9, 0xa0, 0x2e, 0x40, 0xe4, 0x85, 0x51, 0x02, 0xcb, 0xd6, 0xed, 0x81, 0xb5,
	0x46, 0x50, 0x81, 0x52, 0x0b, 0x1b, 0xba, 0x6d, 0x76, 0xdf, 0xc8, 0x39, 0x54, 0x86, 0x22, 0x1e,
	0x74, 0xbb, 0xd4, 0xc8, 0x53, 0x6e, 0x03, 0xe3, 0x1e, 0x96, 0x0b, 0x34, 0x6b, 0xd0, 0x6f, 0xf3,
	0x2c, 0x81, 0x5a, 0x96, 0xdd, 0xeb, 0xf7, 0xa9, 0xb5, 0x45, 0x31, 0xcc, 0x32, 0xda, 0xb2, 0xc8,
	0x43, 0x3a, 0x66, 0x89, 0x45, 0xf5, 0x2d, 0xc0, 0x6a, 0x84, 0x2e, 0x4f, 0x53, 0xee, 0xe6, 0xd3,
	0x94, 0xff, 0xf8, 0x34, 0x21, 0x10, 0x02, 0x3f, 0x3c, 0x63, 0x07, 0x57, 0xc2, 0xec, 0x5b, 0xfd,
	0xab, 0x00, 0xf7, 0xaf, 0x0c, 0x16, 0x52, 0xa0, 0x38, 0x27, 0x71, 0x42, 0x39, 0x38, 0xfd, 0xd2,
	0x44, 0xbf, 0x81, 0xcc, 0x36, 0xda, 0xe1, 0xa3, 0xe7, 0xec, 0x3b, 0x07, 0xec, 0x37, 0xe5, 0xc6,
	0xf3, 0x0d, 0x23, 0xc1, 0x93, 0xb5, 0x63, 0x6a, 0xf3, 0x5f, 0x58, 0x24, 0xdd, 0x77, 0x0e, 0x8e,
	0xee, 0xe1, 0xfb, 0x93, 0x95, 0x73, 0xff, 0xe0, 0x23, 0xfe, 0xa6, 0xb3, 0xab, 0x88, 0x9f, 0xc7,
	0xdf, 0x74, 0x76, 0xaf, 0xf1, 0x37, 0x77, 0xd1, 0x21, 0x48, 0x31, 0x49, 0xa2, 0x59, 0x3c, 0x22,
	0x49, 0xa6, 0x5e, 0xdf, 0x6c, 0x20, 0xc6, 0xcb, 0x5c, 0xbc, 0x82, 0xa1, 0xd7, 0xf0, 0xff, 0xa1,
	0x3b, 0x3a, 0x9b, 0x4d, 0x9d, 0x73, 0x3f, 0xf4, 0xa2, 0x73, 0x27, 0x49, 0xdd, 0x38, 0x65, 0xb2,
	0x56, 0x6e, 0x7c, 0xb1, 0xd4, 0x42, 0x2a, 0xec, 0x4c, 0x07, 0x7b, 0x27, 0x6d, 0x77, 0x81, 0xff,
	0xc7, 0x21, 0xef, 0x18, 0xc2, 0xa2, 0x00, 0xf4, 0x02, 0x44, 0x77, 0x34, 0x22, 0x49, 0xc2, 0x64,
	0xaf, 0xdc, 0xf8, 0x7a, 0xc3, 0x42, 0x74, 0x96, 0x88, 0x33, 0xc0, 0x61, 0x15, 0x2a, 0xeb, 0x6d,
	0x52, 0xff, 0x10, 0x40, 0x38, 0x8a, 0x92, 0xf4, 0x5f, 0xa7, 0xe2, 0x31, 0x40, 0x76, 0x6f, 0xad,
	0x04, 0x5d, 0xca, 0x3c, 0xa6, 0x87, 0x1e, 0x42, 0xf1, 0x22, 0x0a, 0x09, 0x8d, 0xf1, 0xa9, 0x10,
	0xa9, 0x69, 0x7a, 0x57, 0x7b, 0x25, 0x7c, 0x5e, 0xaf, 0x9a, 0x20, 0xc4, 0x51, 0x40, 0x58, 0x85,
	0xd5, 0x8d, 0x70, 0xba, 0x7c, 0x0d, 0x47, 0x01, 0xc1, 0x0c, 0x81, 0x5e, 0x5d, 0xaa, 0x96, 0xc8,
	0xb0, 0xdf, 0xde, 0x86, 0xbd, 0x26, 0x59, 0xaf, 0xa0, 0x94, 0x90, 0x78, 0xee, 0xd3, 0xc5, 0x17,
	0x99, 0x36, 0xab, 0x1b, 0x18, 0x2c, 0x9e, 0x8a, 0x2f, 0x31, 0xf4, 0x16, 0x4c, 0x66, 0xc3, 0x90,
	0xa4, 0xb4, 0x31, 0x25, 0x7e, 0x0b, 0x72, 0x87, 0xe9, 0xa1, 0x1a, 0xc8, 0x6e, 0x92, 0xf8, 0xe3,
	0xd0, 0x99, 0xce, 0x86, 0x81, 0x3f, 0x72, 0xfc, 0x29, 0x53, 0xef, 0x12, 0xae, 0x72, 0x7f, 0x9f,
	0xb9, 0xcd, 0xa9, 0xba, 0x07, 0x02, 0x2d, 0x0a, 0xc9, 0x50, 0xc1, 0xbd, 0x8e, 0xb1, 0xa6, 0x15,
	0x00, 0xe2, 0xb1, 0x6e, 0xd9, 0x06, 0xce, 0x94, 0xc2, 0xe8, 0x77, 0xcc, 0x96, 0xfe, 0x5f, 0x68,
	0xd4, 0xdf, 0x39, 0x28, 0x66, 0x05, 0xa1, 0x97, 0x20, 0xd0, 0x49, 0x64, 0x03, 0x51, 0x6d, 0x3c,
	0xbd, 0xbd, 0x05, 0x9a, 0xbd, 0x98, 0x12, 0xcc, 0x40, 0x6b, 0x37, 0x47, 0xfe, 0x56, 0xd9, 0x5f,
	0xc2, 0xaf, 0x6e, 0x83, 0xfa, 0x14, 0x04, 0x4a, 0x88, 0x1e, 0x80, 0x6c, 0xbf, 0xef, 0x1b, 0xd7,
	0xd4, 0x5a, 0x82, 0xad, 0xe3, 0xf7, 0xd6, 0x2f, 0x1d, 0x39, 0xa7, 0xee, 0x7d, 0x72, 0xd5, 0xea,
	0x07, 0x90, 0x2e, 0x87, 0x0e, 0x7d, 0x0f, 0x68, 0x39, 0x76, 0xce, 0x34, 0x26, 0x09, 0xdf, 0x38,
	0x7e, 0x0e, 0xe4, 0x65, 0xa4, 0xcf, 0x02, 0x26, 0x7b, 0xe3, 0x78, 0x7e, 0x72, 0xe6, 0x24, 0xfe,
	0x05, 0xbf, 0x70, 0x0a, 0xb8, 0x44, 0x1d, 0x96, 0x7f, 0x41, 0x65, 0xb4, 0xc2, 0x82, 0xb4, 0x07,
	0xab, 0x63, 0x01, 0xd4, 0x47, 0x6b, 0x31, 0x3d, 0xf5, 0x09, 0x88, 0xfc, 0x44, 0x32, 0x22, 0x37,
	0x75, 0x9d, 0x80, 0x84, 0x09, 0xfb, 0x5b, 0x09, 0x97, 0xa8, 0xa3, 0x43, 0xc2, 0xe4, 0xd0, 0x83,
	0xc7, 0x57, 0x1a, 0xe6, 0x4e, 0xfd, 0x2b, 0x4d, 0xfb, 0xb5, 0x35, 0xf6, 0xd3, 0xd3, 0xd9, 0x50,
	0x1b, 0x45, 0x93, 0xec, 0x09, 0xf7, 0x8c, 0x3f, 0xe1, 0xc6, 0xd1, 0xb3, 0x31, 0x09, 0xd9, 0x7b,
	0xea, 0xe6, 0xb7, 0xdd, 0x4b, 0xf6, 0x31, 0x14, 0x59, 0xda, 0xf3, 0x7f, 0x02, 0x00, 0x00, 0xff,
	0xff, 0xc1, 0x23, 0xf8, 0xe8, 0xb8, 0x0a, 0x00, 0x00,
}
