// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/postgresql/v1/cluster.proto

package postgresql

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy:
	// only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

var Cluster_Environment_name = map[int32]string{
	0: "ENVIRONMENT_UNSPECIFIED",
	1: "PRODUCTION",
	2: "PRESTABLE",
}

var Cluster_Environment_value = map[string]int32{
	"ENVIRONMENT_UNSPECIFIED": 0,
	"PRODUCTION":              1,
	"PRESTABLE":               2,
}

func (x Cluster_Environment) String() string {
	return proto.EnumName(Cluster_Environment_name, int32(x))
}

func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

var Cluster_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Cluster_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Cluster_Health) String() string {
	return proto.EnumName(Cluster_Health_name, int32(x))
}

func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "UPDATING",
	5: "STOPPING",
	6: "STOPPED",
	7: "STARTING",
}

var Cluster_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"CREATING":       1,
	"RUNNING":        2,
	"ERROR":          3,
	"UPDATING":       4,
	"STOPPING":       5,
	"STOPPED":        6,
	"STARTING":       7,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}

func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{0, 2}
}

type ConnectionPoolerConfig_PoolingMode int32

const (
	ConnectionPoolerConfig_POOLING_MODE_UNSPECIFIED ConnectionPoolerConfig_PoolingMode = 0
	// Session pooling mode.
	ConnectionPoolerConfig_SESSION ConnectionPoolerConfig_PoolingMode = 1
	// Transaction pooling mode.
	ConnectionPoolerConfig_TRANSACTION ConnectionPoolerConfig_PoolingMode = 2
	// Statement pooling mode.
	ConnectionPoolerConfig_STATEMENT ConnectionPoolerConfig_PoolingMode = 3
)

var ConnectionPoolerConfig_PoolingMode_name = map[int32]string{
	0: "POOLING_MODE_UNSPECIFIED",
	1: "SESSION",
	2: "TRANSACTION",
	3: "STATEMENT",
}

var ConnectionPoolerConfig_PoolingMode_value = map[string]int32{
	"POOLING_MODE_UNSPECIFIED": 0,
	"SESSION":                  1,
	"TRANSACTION":              2,
	"STATEMENT":                3,
}

func (x ConnectionPoolerConfig_PoolingMode) String() string {
	return proto.EnumName(ConnectionPoolerConfig_PoolingMode_name, int32(x))
}

func (ConnectionPoolerConfig_PoolingMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{3, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the master PostgreSQL server in the cluster.
	Host_MASTER Host_Role = 1
	// Host is a replica (standby) PostgreSQL server in the cluster.
	Host_REPLICA Host_Role = 2
)

var Host_Role_name = map[int32]string{
	0: "ROLE_UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
}

var Host_Role_value = map[string]int32{
	"ROLE_UNKNOWN": 0,
	"MASTER":       1,
	"REPLICA":      2,
}

func (x Host_Role) String() string {
	return proto.EnumName(Host_Role_name, int32(x))
}

func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{4, 0}
}

type Host_ReplicaType int32

const (
	Host_REPLICA_TYPE_UNKNOWN Host_ReplicaType = 0
	Host_ASYNC                Host_ReplicaType = 1
	Host_SYNC                 Host_ReplicaType = 2
	Host_QUORUM               Host_ReplicaType = 3
)

var Host_ReplicaType_name = map[int32]string{
	0: "REPLICA_TYPE_UNKNOWN",
	1: "ASYNC",
	2: "SYNC",
	3: "QUORUM",
}

var Host_ReplicaType_value = map[string]int32{
	"REPLICA_TYPE_UNKNOWN": 0,
	"ASYNC":                1,
	"SYNC":                 2,
	"QUORUM":               3,
}

func (x Host_ReplicaType) String() string {
	return proto.EnumName(Host_ReplicaType_name, int32(x))
}

func (Host_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{4, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

var Host_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
	3: "DEGRADED",
}

var Host_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
	"DEGRADED":       3,
}

func (x Host_Health) String() string {
	return proto.EnumName(Host_Health_name, int32(x))
}

func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{4, 2}
}

type Service_Type int32

const (
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is a PostgreSQL server.
	Service_POSTGRESQL Service_Type = 1
	// The host is a PgBouncer server.
	Service_POOLER Service_Type = 2
)

var Service_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "POSTGRESQL",
	2: "POOLER",
}

var Service_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"POSTGRESQL":       1,
	"POOLER":           2,
}

func (x Service_Type) String() string {
	return proto.EnumName(Service_Type_name, int32(x))
}

func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{6, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

var Service_Health_name = map[int32]string{
	0: "HEALTH_UNKNOWN",
	1: "ALIVE",
	2: "DEAD",
}

var Service_Health_value = map[string]int32{
	"HEALTH_UNKNOWN": 0,
	"ALIVE":          1,
	"DEAD":           2,
}

func (x Service_Health) String() string {
	return proto.EnumName(Service_Health_name, int32(x))
}

func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{6, 1}
}

// A PostgreSQL Cluster resource. For more information, see
// the [Concepts](/docs/managed-postgresql/concepts) section of the documentation.
type Cluster struct {
	// ID of the PostgreSQL cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the PostgreSQL cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the PostgreSQL cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the PostgreSQL cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs.
	// Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the PostgreSQL cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the PostgreSQL cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the PostgreSQL cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status               Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{0}
}

func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (m *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(m, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Cluster) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *Cluster) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *Cluster) GetMonitoring() []*Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *Cluster) GetHealth() Cluster_Health {
	if m != nil {
		return m.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNKNOWN
}

// Monitoring system.
type Monitoring struct {
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the PostgreSQL cluster.
	Link                 string   `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{1}
}

func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (m *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(m, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Monitoring) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Monitoring) GetLink() string {
	if m != nil {
		return m.Link
	}
	return ""
}

type ClusterConfig struct {
	// Version of PostgreSQL server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration for PostgreSQL servers in the cluster.
	//
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*ClusterConfig_PostgresqlConfig_9_6
	//	*ClusterConfig_PostgresqlConfig_10_1C
	//	*ClusterConfig_PostgresqlConfig_10
	//	*ClusterConfig_PostgresqlConfig_11
	//	*ClusterConfig_PostgresqlConfig_12
	PostgresqlConfig isClusterConfig_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	// Configuration of the connection pooler.
	PoolerConfig *ConnectionPoolerConfig `protobuf:"bytes,4,opt,name=pooler_config,json=poolerConfig,proto3" json:"pooler_config,omitempty"`
	// Resources allocated to PostgreSQL hosts.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Configuration setting which enables/disables autofailover in cluster.
	Autofailover *wrappers.BoolValue `protobuf:"bytes,6,opt,name=autofailover,proto3" json:"autofailover,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,7,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,9,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterConfig) Reset()         { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()    {}
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{2}
}

func (m *ClusterConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterConfig.Unmarshal(m, b)
}
func (m *ClusterConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterConfig.Marshal(b, m, deterministic)
}
func (m *ClusterConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfig.Merge(m, src)
}
func (m *ClusterConfig) XXX_Size() int {
	return xxx_messageInfo_ClusterConfig.Size(m)
}
func (m *ClusterConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfig proto.InternalMessageInfo

func (m *ClusterConfig) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isClusterConfig_PostgresqlConfig interface {
	isClusterConfig_PostgresqlConfig()
}

type ClusterConfig_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlConfigSet9_6 `protobuf:"bytes,2,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_10_1C struct {
	PostgresqlConfig_10_1C *config.PostgresqlConfigSet10_1C `protobuf:"bytes,10,opt,name=postgresql_config_10_1c,json=postgresqlConfig101c,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlConfigSet10 `protobuf:"bytes,3,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlConfigSet11 `protobuf:"bytes,8,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

type ClusterConfig_PostgresqlConfig_12 struct {
	PostgresqlConfig_12 *config.PostgresqlConfigSet12 `protobuf:"bytes,11,opt,name=postgresql_config_12,json=postgresqlConfig12,proto3,oneof"`
}

func (*ClusterConfig_PostgresqlConfig_9_6) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_10_1C) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_10) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_11) isClusterConfig_PostgresqlConfig() {}

func (*ClusterConfig_PostgresqlConfig_12) isClusterConfig_PostgresqlConfig() {}

func (m *ClusterConfig) GetPostgresqlConfig() isClusterConfig_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_9_6() *config.PostgresqlConfigSet9_6 {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_10_1C() *config.PostgresqlConfigSet10_1C {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_10_1C); ok {
		return x.PostgresqlConfig_10_1C
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_10() *config.PostgresqlConfigSet10 {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_11() *config.PostgresqlConfigSet11 {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (m *ClusterConfig) GetPostgresqlConfig_12() *config.PostgresqlConfigSet12 {
	if x, ok := m.GetPostgresqlConfig().(*ClusterConfig_PostgresqlConfig_12); ok {
		return x.PostgresqlConfig_12
	}
	return nil
}

func (m *ClusterConfig) GetPoolerConfig() *ConnectionPoolerConfig {
	if m != nil {
		return m.PoolerConfig
	}
	return nil
}

func (m *ClusterConfig) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ClusterConfig) GetAutofailover() *wrappers.BoolValue {
	if m != nil {
		return m.Autofailover
	}
	return nil
}

func (m *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ClusterConfig) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ClusterConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ClusterConfig_PostgresqlConfig_9_6)(nil),
		(*ClusterConfig_PostgresqlConfig_10_1C)(nil),
		(*ClusterConfig_PostgresqlConfig_10)(nil),
		(*ClusterConfig_PostgresqlConfig_11)(nil),
		(*ClusterConfig_PostgresqlConfig_12)(nil),
	}
}

type ConnectionPoolerConfig struct {
	// Mode that the connection pooler is working in.
	// See descriptions of all modes in the [documentation for PgBouncer](https://pgbouncer.github.io/usage).
	PoolingMode ConnectionPoolerConfig_PoolingMode `protobuf:"varint,1,opt,name=pooling_mode,json=poolingMode,proto3,enum=yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig_PoolingMode" json:"pooling_mode,omitempty"`
	// Setting `server_reset_query_always` parameter in PgBouncer.
	PoolDiscard          *wrappers.BoolValue `protobuf:"bytes,2,opt,name=pool_discard,json=poolDiscard,proto3" json:"pool_discard,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ConnectionPoolerConfig) Reset()         { *m = ConnectionPoolerConfig{} }
func (m *ConnectionPoolerConfig) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolerConfig) ProtoMessage()    {}
func (*ConnectionPoolerConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{3}
}

func (m *ConnectionPoolerConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectionPoolerConfig.Unmarshal(m, b)
}
func (m *ConnectionPoolerConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectionPoolerConfig.Marshal(b, m, deterministic)
}
func (m *ConnectionPoolerConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionPoolerConfig.Merge(m, src)
}
func (m *ConnectionPoolerConfig) XXX_Size() int {
	return xxx_messageInfo_ConnectionPoolerConfig.Size(m)
}
func (m *ConnectionPoolerConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionPoolerConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionPoolerConfig proto.InternalMessageInfo

func (m *ConnectionPoolerConfig) GetPoolingMode() ConnectionPoolerConfig_PoolingMode {
	if m != nil {
		return m.PoolingMode
	}
	return ConnectionPoolerConfig_POOLING_MODE_UNSPECIFIED
}

func (m *ConnectionPoolerConfig) GetPoolDiscard() *wrappers.BoolValue {
	if m != nil {
		return m.PoolDiscard
	}
	return nil
}

type Host struct {
	// Name of the PostgreSQL host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all existing MDB hosts in Yandex.Cloud, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the PostgreSQL host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the PostgreSQL host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the PostgreSQL host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_Role" json:"role,omitempty"`
	// Status code of the aggregated health of the host.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Name of the host to be used as the replication source for cascading replication.
	ReplicationSource string `protobuf:"bytes,9,opt,name=replication_source,json=replicationSource,proto3" json:"replication_source,omitempty"`
	// Priority of the host as a replica. Higher value means higher priority.
	//
	// The host with the highest priority is the synchronous replica. All others are asynchronous.
	// The synchronous replica replaces the master when needed.
	//
	// When a replica becomes the master, its priority is ignored.
	Priority *wrappers.Int64Value `protobuf:"bytes,10,opt,name=priority,proto3" json:"priority,omitempty"`
	// Configuration of a PostgreSQL server for the host.
	Config *HostConfig `protobuf:"bytes,11,opt,name=config,proto3" json:"config,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp       bool             `protobuf:"varint,12,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	ReplicaType          Host_ReplicaType `protobuf:"varint,13,opt,name=replica_type,json=replicaType,proto3,enum=yandex.cloud.mdb.postgresql.v1.Host_ReplicaType" json:"replica_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Host) Reset()         { *m = Host{} }
func (m *Host) String() string { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()    {}
func (*Host) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{4}
}

func (m *Host) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Host.Unmarshal(m, b)
}
func (m *Host) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Host.Marshal(b, m, deterministic)
}
func (m *Host) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Host.Merge(m, src)
}
func (m *Host) XXX_Size() int {
	return xxx_messageInfo_Host.Size(m)
}
func (m *Host) XXX_DiscardUnknown() {
	xxx_messageInfo_Host.DiscardUnknown(m)
}

var xxx_messageInfo_Host proto.InternalMessageInfo

func (m *Host) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Host) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *Host) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *Host) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Host) GetRole() Host_Role {
	if m != nil {
		return m.Role
	}
	return Host_ROLE_UNKNOWN
}

func (m *Host) GetHealth() Host_Health {
	if m != nil {
		return m.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (m *Host) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Host) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *Host) GetReplicationSource() string {
	if m != nil {
		return m.ReplicationSource
	}
	return ""
}

func (m *Host) GetPriority() *wrappers.Int64Value {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *Host) GetConfig() *HostConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Host) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *Host) GetReplicaType() Host_ReplicaType {
	if m != nil {
		return m.ReplicaType
	}
	return Host_REPLICA_TYPE_UNKNOWN
}

type HostConfig struct {
	// Configuration of a PostgreSQL server for the host.
	//
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*HostConfig_PostgresqlConfig_9_6
	//	*HostConfig_PostgresqlConfig_10_1C
	//	*HostConfig_PostgresqlConfig_10
	//	*HostConfig_PostgresqlConfig_11
	//	*HostConfig_PostgresqlConfig_12
	PostgresqlConfig     isHostConfig_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *HostConfig) Reset()         { *m = HostConfig{} }
func (m *HostConfig) String() string { return proto.CompactTextString(m) }
func (*HostConfig) ProtoMessage()    {}
func (*HostConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{5}
}

func (m *HostConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostConfig.Unmarshal(m, b)
}
func (m *HostConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostConfig.Marshal(b, m, deterministic)
}
func (m *HostConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostConfig.Merge(m, src)
}
func (m *HostConfig) XXX_Size() int {
	return xxx_messageInfo_HostConfig.Size(m)
}
func (m *HostConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HostConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HostConfig proto.InternalMessageInfo

type isHostConfig_PostgresqlConfig interface {
	isHostConfig_PostgresqlConfig()
}

type HostConfig_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlHostConfig9_6 `protobuf:"bytes,1,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_10_1C struct {
	PostgresqlConfig_10_1C *config.PostgresqlHostConfig10_1C `protobuf:"bytes,4,opt,name=postgresql_config_10_1c,json=postgresqlConfig101c,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlHostConfig10 `protobuf:"bytes,2,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlHostConfig11 `protobuf:"bytes,3,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

type HostConfig_PostgresqlConfig_12 struct {
	PostgresqlConfig_12 *config.PostgresqlHostConfig12 `protobuf:"bytes,5,opt,name=postgresql_config_12,json=postgresqlConfig12,proto3,oneof"`
}

func (*HostConfig_PostgresqlConfig_9_6) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_10_1C) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_10) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_11) isHostConfig_PostgresqlConfig() {}

func (*HostConfig_PostgresqlConfig_12) isHostConfig_PostgresqlConfig() {}

func (m *HostConfig) GetPostgresqlConfig() isHostConfig_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_9_6() *config.PostgresqlHostConfig9_6 {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_10_1C() *config.PostgresqlHostConfig10_1C {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_10_1C); ok {
		return x.PostgresqlConfig_10_1C
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_10() *config.PostgresqlHostConfig10 {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_11() *config.PostgresqlHostConfig11 {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (m *HostConfig) GetPostgresqlConfig_12() *config.PostgresqlHostConfig12 {
	if x, ok := m.GetPostgresqlConfig().(*HostConfig_PostgresqlConfig_12); ok {
		return x.PostgresqlConfig_12
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HostConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HostConfig_PostgresqlConfig_9_6)(nil),
		(*HostConfig_PostgresqlConfig_10_1C)(nil),
		(*HostConfig_PostgresqlConfig_10)(nil),
		(*HostConfig_PostgresqlConfig_11)(nil),
		(*HostConfig_PostgresqlConfig_12)(nil),
	}
}

type Service struct {
	// Type of the service provided by the host.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.postgresql.v1.Service_Type" json:"type,omitempty"`
	// Status code of server availability.
	Health               Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.postgresql.v1.Service_Health" json:"health,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Service) Reset()         { *m = Service{} }
func (m *Service) String() string { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()    {}
func (*Service) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{6}
}

func (m *Service) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Service.Unmarshal(m, b)
}
func (m *Service) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Service.Marshal(b, m, deterministic)
}
func (m *Service) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Service.Merge(m, src)
}
func (m *Service) XXX_Size() int {
	return xxx_messageInfo_Service.Size(m)
}
func (m *Service) XXX_DiscardUnknown() {
	xxx_messageInfo_Service.DiscardUnknown(m)
}

var xxx_messageInfo_Service proto.InternalMessageInfo

func (m *Service) GetType() Service_Type {
	if m != nil {
		return m.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (m *Service) GetHealth() Service_Health {
	if m != nil {
		return m.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-postgresql/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd — network HDD drive,
	// * network-ssd — network SSD drive,
	// * local-ssd — local SSD storage.
	DiskTypeId           string   `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{7}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetResourcePresetId() string {
	if m != nil {
		return m.ResourcePresetId
	}
	return ""
}

func (m *Resources) GetDiskSize() int64 {
	if m != nil {
		return m.DiskSize
	}
	return 0
}

func (m *Resources) GetDiskTypeId() string {
	if m != nil {
		return m.DiskTypeId
	}
	return ""
}

type Access struct {
	// Allow access for DataLens
	DataLens             bool     `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Access) Reset()         { *m = Access{} }
func (m *Access) String() string { return proto.CompactTextString(m) }
func (*Access) ProtoMessage()    {}
func (*Access) Descriptor() ([]byte, []int) {
	return fileDescriptor_66e5c6384d029c45, []int{8}
}

func (m *Access) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Access.Unmarshal(m, b)
}
func (m *Access) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Access.Marshal(b, m, deterministic)
}
func (m *Access) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Access.Merge(m, src)
}
func (m *Access) XXX_Size() int {
	return xxx_messageInfo_Access.Size(m)
}
func (m *Access) XXX_DiscardUnknown() {
	xxx_messageInfo_Access.DiscardUnknown(m)
}

var xxx_messageInfo_Access proto.InternalMessageInfo

func (m *Access) GetDataLens() bool {
	if m != nil {
		return m.DataLens
	}
	return false
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Cluster_Environment", Cluster_Environment_name, Cluster_Environment_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Cluster_Health", Cluster_Health_name, Cluster_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig_PoolingMode", ConnectionPoolerConfig_PoolingMode_name, ConnectionPoolerConfig_PoolingMode_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Host_Role", Host_Role_name, Host_Role_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Host_ReplicaType", Host_ReplicaType_name, Host_ReplicaType_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Host_Health", Host_Health_name, Host_Health_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Service_Type", Service_Type_name, Service_Type_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.Service_Health", Service_Health_name, Service_Health_value)
	proto.RegisterType((*Cluster)(nil), "yandex.cloud.mdb.postgresql.v1.Cluster")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.Cluster.LabelsEntry")
	proto.RegisterType((*Monitoring)(nil), "yandex.cloud.mdb.postgresql.v1.Monitoring")
	proto.RegisterType((*ClusterConfig)(nil), "yandex.cloud.mdb.postgresql.v1.ClusterConfig")
	proto.RegisterType((*ConnectionPoolerConfig)(nil), "yandex.cloud.mdb.postgresql.v1.ConnectionPoolerConfig")
	proto.RegisterType((*Host)(nil), "yandex.cloud.mdb.postgresql.v1.Host")
	proto.RegisterType((*HostConfig)(nil), "yandex.cloud.mdb.postgresql.v1.HostConfig")
	proto.RegisterType((*Service)(nil), "yandex.cloud.mdb.postgresql.v1.Service")
	proto.RegisterType((*Resources)(nil), "yandex.cloud.mdb.postgresql.v1.Resources")
	proto.RegisterType((*Access)(nil), "yandex.cloud.mdb.postgresql.v1.Access")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/postgresql/v1/cluster.proto", fileDescriptor_66e5c6384d029c45)
}

var fileDescriptor_66e5c6384d029c45 = []byte{
	// 1656 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0x6d, 0x77, 0xda, 0xc8,
	0x15, 0x0e, 0x2f, 0xe6, 0xe5, 0x8a, 0xb8, 0xca, 0xac, 0xbb, 0xd1, 0x49, 0xba, 0x5b, 0x1f, 0x9d,
	0xd3, 0xd6, 0xdd, 0x26, 0x22, 0x90, 0xd6, 0x8d, 0xbb, 0x4d, 0x76, 0x31, 0x28, 0xb6, 0xba, 0x18,
	0xd8, 0x11, 0x64, 0xbb, 0xed, 0x07, 0x1d, 0x81, 0xc6, 0x44, 0xc7, 0x42, 0xa3, 0x48, 0xc2, 0x0e,
	0xf9, 0xd4, 0x9f, 0xd1, 0x7f, 0xd5, 0xff, 0x91, 0x4f, 0xfd, 0x09, 0x7b, 0x66, 0x46, 0x06, 0x8c,
	0x8d, 0xc1, 0xe6, 0x9b, 0x66, 0xe6, 0x3e, 0xcf, 0xd5, 0xdc, 0xb9, 0x73, 0xef, 0x23, 0xc1, 0xb3,
	0x89, 0xed, 0x3b, 0xe4, 0x63, 0x79, 0xe0, 0xd1, 0xb1, 0x53, 0x1e, 0x39, 0xfd, 0x72, 0x40, 0xa3,
	0x78, 0x18, 0x92, 0xe8, 0x83, 0x57, 0x3e, 0xaf, 0x94, 0x07, 0xde, 0x38, 0x8a, 0x49, 0xa8, 0x05,
	0x21, 0x8d, 0x29, 0xfa, 0x5a, 0x58, 0x6b, 0xdc, 0x5a, 0x1b, 0x39, 0x7d, 0x6d, 0x66, 0xad, 0x9d,
	0x57, 0x9e, 0xfc, 0x76, 0x48, 0xe9, 0xd0, 0x23, 0x65, 0x6e, 0xdd, 0x1f, 0x9f, 0x96, 0x63, 0x77,
	0x44, 0xa2, 0xd8, 0x1e, 0x05, 0x82, 0xe0, 0xc9, 0xd7, 0x8b, 0x06, 0x17, 0xa1, 0x1d, 0x04, 0x24,
	0x8c, 0x92, 0xf5, 0xa7, 0xc9, 0x7a, 0x3c, 0x09, 0x08, 0x07, 0xd3, 0x53, 0xc7, 0x9e, 0x24, 0x8b,
	0x07, 0xab, 0xde, 0x95, 0xfa, 0xa7, 0xee, 0x70, 0x6e, 0xf2, 0xc0, 0xda, 0x4f, 0xa0, 0xaf, 0xee,
	0x0a, 0xad, 0xbc, 0x48, 0x90, 0xdf, 0xde, 0x1d, 0x69, 0x55, 0x06, 0xf7, 0x76, 0x5b, 0xb9, 0x37,
	0xb2, 0x9a, 0x20, 0x5f, 0xae, 0x87, 0x7c, 0x4f, 0xa3, 0x78, 0x16, 0x9f, 0xea, 0xfa, 0xa0, 0x69,
	0x64, 0xfe, 0x72, 0x17, 0xcc, 0x2c, 0x26, 0x77, 0x71, 0x55, 0xb9, 0x07, 0x26, 0x89, 0x83, 0xfa,
	0xbf, 0x3c, 0xe4, 0xeb, 0x22, 0x7b, 0xd1, 0x36, 0xa4, 0x5d, 0x47, 0x49, 0xed, 0xa6, 0xf6, 0x8a,
	0x38, 0xed, 0x3a, 0xe8, 0x29, 0x14, 0x4f, 0xa9, 0xe7, 0x90, 0xd0, 0x72, 0x1d, 0x25, 0xcd, 0xa7,
	0x0b, 0x62, 0xc2, 0x70, 0xd0, 0x01, 0xc0, 0x20, 0x24, 0x76, 0x4c, 0x1c, 0xcb, 0x8e, 0x95, 0xcc,
	0x6e, 0x6a, 0x4f, 0xaa, 0x3e, 0xd1, 0x44, 0x62, 0x6a, 0x97, 0x89, 0xab, 0x75, 0x2f, 0x33, 0x1b,
	0x17, 0x13, 0xeb, 0x5a, 0x8c, 0x10, 0x64, 0x7d, 0x7b, 0x44, 0x94, 0x2c, 0xa7, 0xe4, 0xcf, 0x68,
	0x17, 0x24, 0x87, 0x44, 0x83, 0xd0, 0x0d, 0x62, 0x97, 0xfa, 0xca, 0x16, 0x5f, 0x9a, 0x9f, 0x42,
	0x3f, 0x40, 0xce, 0xb3, 0xfb, 0xc4, 0x8b, 0x94, 0xdc, 0x6e, 0x66, 0x4f, 0xaa, 0xbe, 0xd4, 0x6e,
	0xbf, 0x66, 0x5a, 0xb2, 0x2d, 0xad, 0xc9, 0x51, 0xba, 0x1f, 0x87, 0x13, 0x9c, 0x50, 0xa0, 0x1e,
	0x48, 0xc4, 0x3f, 0x77, 0x43, 0xea, 0x8f, 0x88, 0x1f, 0x2b, 0xf9, 0xdd, 0xd4, 0xde, 0xf6, 0xfa,
	0x8c, 0xfa, 0x0c, 0x8a, 0xe7, 0x79, 0xd0, 0x3f, 0x00, 0x46, 0xd4, 0x77, 0x63, 0x1a, 0xba, 0xfe,
	0x50, 0x29, 0xf0, 0xf7, 0xfc, 0x66, 0x15, 0xeb, 0xc9, 0x14, 0x81, 0xe7, 0xd0, 0x48, 0x87, 0x9c,
	0x38, 0x30, 0xa5, 0xc8, 0x83, 0xfb, 0x7c, 0xcd, 0xb7, 0xab, 0x73, 0x10, 0x4e, 0xc0, 0xe8, 0x2b,
	0x00, 0x9f, 0xc4, 0x17, 0x34, 0x3c, 0x63, 0xa7, 0x08, 0x3c, 0xae, 0xc5, 0x64, 0xc6, 0x70, 0xd0,
	0x5b, 0xc8, 0xbd, 0x27, 0xb6, 0x17, 0xbf, 0x57, 0x24, 0x1e, 0x03, 0x6d, 0xdd, 0x18, 0x1c, 0x73,
	0x14, 0x4e, 0xd0, 0x8c, 0x27, 0x8a, 0xed, 0x78, 0x1c, 0x29, 0xa5, 0xbb, 0xf1, 0x98, 0x1c, 0x85,
	0x13, 0xf4, 0x93, 0x03, 0x90, 0xe6, 0xce, 0x0b, 0xc9, 0x90, 0x39, 0x23, 0x93, 0x24, 0x27, 0xd9,
	0x23, 0xda, 0x81, 0xad, 0x73, 0xdb, 0x1b, 0x93, 0x24, 0x21, 0xc5, 0xe0, 0x6f, 0xe9, 0x57, 0x29,
	0xd5, 0x00, 0x69, 0xee, 0x60, 0xd0, 0x53, 0x78, 0xac, 0xb7, 0xde, 0x19, 0xb8, 0xdd, 0x3a, 0xd1,
	0x5b, 0x5d, 0xab, 0xd7, 0x32, 0x3b, 0x7a, 0xdd, 0x78, 0x6b, 0xe8, 0x0d, 0xf9, 0x01, 0xda, 0x06,
	0xe8, 0xe0, 0x76, 0xa3, 0x57, 0xef, 0x1a, 0xed, 0x96, 0x9c, 0x42, 0x0f, 0xa1, 0xd8, 0xc1, 0xba,
	0xd9, 0xad, 0x1d, 0x36, 0x75, 0x39, 0xad, 0x7e, 0x07, 0x39, 0xb1, 0x3f, 0x84, 0x60, 0xfb, 0x58,
	0xaf, 0x35, 0xbb, 0xc7, 0x56, 0xaf, 0xf5, 0x43, 0xab, 0xfd, 0x53, 0x4b, 0x7e, 0x80, 0x8a, 0xb0,
	0x55, 0x6b, 0x1a, 0xef, 0x74, 0x39, 0x85, 0x0a, 0x90, 0x6d, 0xe8, 0xb5, 0x86, 0x9c, 0x46, 0x25,
	0x28, 0x34, 0xf4, 0x23, 0x5c, 0x6b, 0xe8, 0x0d, 0x39, 0xa3, 0x4e, 0x20, 0x27, 0x36, 0xc6, 0x08,
	0xcc, 0x6e, 0xad, 0xdb, 0x33, 0xe7, 0x08, 0x4a, 0x50, 0xa8, 0x63, 0xbd, 0xd6, 0x35, 0x5a, 0x47,
	0x72, 0x0a, 0x49, 0x90, 0xc7, 0xbd, 0x56, 0x8b, 0x0d, 0xd2, 0x8c, 0x5b, 0xc7, 0xb8, 0x8d, 0xe5,
	0x0c, 0xb3, 0xea, 0x75, 0x1a, 0xc2, 0x2a, 0xcb, 0x46, 0x66, 0xb7, 0xdd, 0xe9, 0xb0, 0xd1, 0x16,
	0xc3, 0xf0, 0x91, 0xde, 0x90, 0x73, 0x62, 0xa9, 0x86, 0xb9, 0x61, 0x5e, 0x7d, 0x07, 0x30, 0xcb,
	0xa8, 0xe9, 0x5d, 0x4b, 0x2d, 0xbf, 0x6b, 0xe9, 0xeb, 0x77, 0x0d, 0x41, 0xd6, 0x73, 0xfd, 0x33,
	0x7e, 0xad, 0x8b, 0x98, 0x3f, 0xab, 0xff, 0xcf, 0xc3, 0xc3, 0x2b, 0x29, 0x86, 0x14, 0xc8, 0x9f,
	0x93, 0x30, 0x62, 0x1c, 0x82, 0xfe, 0x72, 0x88, 0x42, 0xf8, 0xf5, 0xec, 0xb4, 0x2d, 0x91, 0x89,
	0xd6, 0x81, 0xb5, 0xcf, 0x7d, 0x49, 0xd5, 0xd7, 0xab, 0x92, 0x43, 0x20, 0xb4, 0xce, 0x74, 0x52,
	0x78, 0x34, 0x09, 0x2b, 0xc6, 0xc7, 0x0f, 0x30, 0x0a, 0x16, 0x56, 0x0e, 0xf6, 0xd1, 0x47, 0x78,
	0x7c, 0xdd, 0x27, 0x2f, 0xa9, 0x3c, 0xeb, 0xa5, 0xea, 0x77, 0xf7, 0xf7, 0xca, 0x68, 0xea, 0xc7,
	0x0f, 0xf0, 0xce, 0xa2, 0xdf, 0xca, 0x8b, 0xca, 0x00, 0x05, 0xb0, 0x73, 0x93, 0xe7, 0xa4, 0x28,
	0xfe, 0x7d, 0x13, 0xb7, 0x37, 0xed, 0xb5, 0xf2, 0x62, 0x89, 0xc7, 0x8a, 0x52, 0xd8, 0xd8, 0x63,
	0xe5, 0x46, 0x8f, 0x95, 0x25, 0x1e, 0xab, 0xbc, 0x6a, 0x6c, 0xe6, 0xb1, 0x7a, 0xa3, 0xc7, 0x2a,
	0xfa, 0x37, 0x3c, 0x0c, 0x28, 0xf5, 0x48, 0x98, 0x78, 0xe3, 0xed, 0x42, 0xaa, 0xee, 0xaf, 0x2c,
	0x2c, 0xd4, 0xf7, 0xc9, 0x80, 0xa5, 0x71, 0x87, 0xc3, 0x93, 0x7a, 0x58, 0x0a, 0xe6, 0x46, 0xe8,
	0x08, 0x8a, 0x21, 0x89, 0xe8, 0x38, 0x1c, 0x90, 0x88, 0x37, 0x1b, 0xa9, 0xfa, 0xc7, 0x55, 0xc4,
	0xf8, 0x12, 0x80, 0x67, 0x58, 0xf4, 0x06, 0x4a, 0xf6, 0x38, 0xa6, 0xa7, 0xb6, 0xeb, 0xd1, 0x73,
	0x12, 0x2a, 0xb9, 0x25, 0x8d, 0xf0, 0x90, 0x52, 0xef, 0x1d, 0x2b, 0x55, 0xf8, 0x8a, 0x3d, 0x7a,
	0x0b, 0x5f, 0xf4, 0xed, 0xc1, 0xd9, 0x38, 0xb0, 0x2e, 0x5c, 0xdf, 0xa1, 0x17, 0x56, 0x14, 0xdb,
	0xa1, 0x68, 0x48, 0x52, 0xf5, 0xcb, 0x4b, 0x1a, 0x26, 0xf4, 0x78, 0x2f, 0x6d, 0x9f, 0x36, 0xec,
	0x09, 0x7e, 0x24, 0x20, 0x3f, 0x71, 0x84, 0xc9, 0x00, 0xe8, 0x0d, 0xe4, 0xec, 0xc1, 0x80, 0x44,
	0x51, 0xd2, 0x2d, 0x7e, 0xbf, 0x6a, 0x37, 0x35, 0x6e, 0x8d, 0x13, 0xd4, 0xe1, 0x17, 0xf0, 0xe8,
	0xda, 0xf9, 0xaa, 0xff, 0x4d, 0xc3, 0x97, 0x37, 0x87, 0x13, 0x11, 0xe0, 0x01, 0x75, 0xfd, 0xa1,
	0x35, 0xa2, 0x8e, 0xa8, 0x2f, 0xdb, 0xd5, 0xc3, 0xfb, 0x1d, 0x8e, 0xd6, 0x11, 0x54, 0x27, 0xd4,
	0x21, 0x58, 0x0a, 0x66, 0x03, 0xf4, 0x5a, 0xb8, 0xb1, 0x1c, 0x37, 0x1a, 0xd8, 0xa1, 0x93, 0xd4,
	0x8f, 0xdb, 0xc2, 0xcb, 0xe1, 0x0d, 0x61, 0xae, 0xfe, 0x13, 0xa4, 0x39, 0x6a, 0xf4, 0x1b, 0x50,
	0x3a, 0xed, 0x76, 0xd3, 0x68, 0x1d, 0x59, 0x27, 0xed, 0x86, 0xbe, 0xd0, 0x13, 0x58, 0x4d, 0xd5,
	0x4d, 0x53, 0x34, 0x84, 0x5f, 0x81, 0xd4, 0xc5, 0xb5, 0x96, 0x59, 0x13, 0x1d, 0x22, 0xcd, 0x3a,
	0x04, 0xab, 0xe3, 0x3a, 0x6b, 0x26, 0x72, 0x46, 0xfd, 0x9c, 0x83, 0xec, 0x31, 0x8d, 0xe2, 0x1b,
	0x0b, 0xec, 0x57, 0x00, 0xc9, 0x17, 0xc1, 0x4c, 0x39, 0x15, 0x93, 0x19, 0xc3, 0x41, 0x8f, 0x21,
	0xff, 0x89, 0xfa, 0x84, 0xad, 0x89, 0x02, 0x9b, 0x63, 0x43, 0xc3, 0xb9, 0x9a, 0x95, 0xd9, 0x0d,
	0xb2, 0xf2, 0x35, 0x64, 0x43, 0xea, 0x11, 0x9e, 0xd9, 0xdb, 0xab, 0x39, 0xd8, 0x46, 0x34, 0x4c,
	0x3d, 0x82, 0x39, 0x0c, 0xd5, 0xa7, 0xa2, 0x20, 0xc7, 0x09, 0xfe, 0xb4, 0x16, 0xc1, 0x82, 0x22,
	0xa8, 0x43, 0x21, 0x22, 0xe1, 0xb9, 0xcb, 0xf6, 0x92, 0xe7, 0x4a, 0xe8, 0x0f, 0xab, 0x68, 0x4c,
	0x61, 0x8f, 0xa7, 0x40, 0x26, 0x41, 0xa3, 0x71, 0xdf, 0x27, 0x31, 0x0b, 0x56, 0x41, 0x48, 0x50,
	0x31, 0x61, 0x38, 0xe8, 0x39, 0xa0, 0x90, 0x04, 0x9e, 0x3b, 0xb0, 0x59, 0x42, 0x59, 0x62, 0xf3,
	0x3c, 0xff, 0x8b, 0xf8, 0xd1, 0xdc, 0x8a, 0xc9, 0x17, 0xd0, 0x5f, 0xa1, 0x10, 0x84, 0x2e, 0x0d,
	0xdd, 0x78, 0x92, 0x74, 0x84, 0xa7, 0xd7, 0xf2, 0xc8, 0xf0, 0xe3, 0xfd, 0x3f, 0x8b, 0x44, 0x9a,
	0x1a, 0xa3, 0xc3, 0xa9, 0x12, 0x13, 0xd5, 0xee, 0x9b, 0x75, 0xc2, 0xb1, 0x20, 0xc3, 0xf6, 0x40,
	0xb6, 0xa3, 0xc8, 0x1d, 0xfa, 0x56, 0x30, 0xee, 0x7b, 0xee, 0xc0, 0x72, 0x03, 0xae, 0x94, 0x0a,
	0x78, 0x5b, 0xcc, 0x77, 0xf8, 0xb4, 0x11, 0x20, 0x13, 0x4a, 0xc9, 0xbb, 0x5b, 0xec, 0xda, 0x2b,
	0x0f, 0xf9, 0x11, 0xbc, 0x58, 0xef, 0x0c, 0x05, 0xb0, 0x3b, 0x09, 0x08, 0x96, 0xc2, 0xd9, 0x40,
	0xad, 0x40, 0x96, 0x9d, 0x2f, 0x92, 0xa1, 0x84, 0xdb, 0x4d, 0x7d, 0x4e, 0x8b, 0x00, 0xe4, 0x4e,
	0x6a, 0x66, 0x57, 0xc7, 0x89, 0x12, 0xd1, 0x3b, 0x4d, 0xa3, 0x5e, 0x93, 0xd3, 0xea, 0x31, 0x48,
	0x73, 0x74, 0x48, 0x81, 0x9d, 0x64, 0xcd, 0xea, 0xfe, 0xdc, 0xd1, 0x17, 0xe4, 0x90, 0xf9, 0x73,
	0xab, 0x2e, 0xe4, 0x10, 0x7f, 0x4a, 0x33, 0xda, 0x1f, 0x7b, 0x6d, 0xdc, 0x3b, 0x91, 0x33, 0x9b,
	0xab, 0xa9, 0xcf, 0x59, 0x80, 0x59, 0x4c, 0x51, 0xb4, 0x4c, 0x5d, 0xa4, 0xf8, 0xf1, 0xbc, 0xb9,
	0x73, 0x33, 0x9a, 0x71, 0x2f, 0x97, 0x17, 0x93, 0xe5, 0xf2, 0x42, 0xdc, 0xd4, 0xef, 0x37, 0x70,
	0x7b, 0xbb, 0xbe, 0xf8, 0xb0, 0x44, 0x5f, 0xdc, 0x57, 0x4c, 0xcd, 0xfb, 0x5d, 0x22, 0x30, 0x3e,
	0x2c, 0x11, 0x18, 0x99, 0xcd, 0x5d, 0x2e, 0x53, 0x18, 0x1f, 0x96, 0x28, 0x8c, 0xad, 0xcd, 0x5d,
	0x2e, 0x91, 0x18, 0x37, 0x37, 0xbd, 0xff, 0xa4, 0x21, 0x9f, 0x14, 0x22, 0xf4, 0x3d, 0x64, 0xf9,
	0x1d, 0x14, 0xdd, 0xed, 0xd9, 0x9a, 0xf5, 0x4b, 0xe3, 0xf7, 0x8f, 0x23, 0xe7, 0xbe, 0xaf, 0xd2,
	0xeb, 0x7d, 0x17, 0x5d, 0x72, 0x5c, 0xad, 0xa6, 0xea, 0x2b, 0xc8, 0xf2, 0x6b, 0xb8, 0x03, 0x72,
	0x72, 0xfd, 0x16, 0x3f, 0x67, 0xda, 0x66, 0xf7, 0x08, 0xeb, 0xe6, 0x8f, 0x4d, 0x39, 0xc5, 0x6e,
	0x1f, 0x6b, 0x74, 0x3a, 0x96, 0xd3, 0x6a, 0xe5, 0xce, 0xb7, 0x4f, 0xfd, 0x08, 0xc5, 0x69, 0x5b,
	0x41, 0xcf, 0x58, 0x95, 0x15, 0x03, 0x2b, 0x08, 0x49, 0x24, 0x6a, 0xb1, 0x68, 0x77, 0xf2, 0xe5,
	0x4a, 0x87, 0x2f, 0x18, 0xfc, 0x9f, 0x81, 0xe3, 0x46, 0x67, 0x56, 0xe4, 0x7e, 0x12, 0x9f, 0x68,
	0x19, 0x5c, 0x60, 0x13, 0xa6, 0xfb, 0x89, 0x7d, 0x78, 0x94, 0xf8, 0x22, 0x8b, 0xcc, 0xac, 0xfb,
	0x01, 0x9b, 0x63, 0x9b, 0x33, 0x1c, 0xf5, 0x77, 0x90, 0x13, 0xc2, 0x84, 0x13, 0xd9, 0xb1, 0x6d,
	0x79, 0xc4, 0x8f, 0xb8, 0xb7, 0x02, 0x2e, 0xb0, 0x89, 0x26, 0xf1, 0xa3, 0xc3, 0x08, 0xd4, 0x2b,
	0x61, 0xb4, 0x03, 0xf7, 0x7a, 0x28, 0xff, 0x75, 0x32, 0x74, 0xe3, 0xf7, 0xe3, 0xbe, 0x36, 0xa0,
	0xa3, 0xb2, 0x30, 0x7f, 0x2e, 0x7e, 0x8d, 0x0c, 0xe9, 0xf3, 0x21, 0xf1, 0x79, 0xd1, 0x2f, 0xdf,
	0xfe, 0xcf, 0xe4, 0xdb, 0xd9, 0xa8, 0x9f, 0xe3, 0x80, 0x97, 0xbf, 0x04, 0x00, 0x00, 0xff, 0xff,
	0xe3, 0x20, 0xa0, 0x2e, 0x0d, 0x14, 0x00, 0x00,
}
