// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/mdb/postgresql/v1/cluster_service.proto

package postgresql

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1/config"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ListClusterLogsRequest_ServiceType int32

const (
	ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED ListClusterLogsRequest_ServiceType = 0
	// Logs of PostgreSQL activity.
	ListClusterLogsRequest_POSTGRESQL ListClusterLogsRequest_ServiceType = 1
	// Logs of connection pooler activity.
	ListClusterLogsRequest_POOLER ListClusterLogsRequest_ServiceType = 2
)

var ListClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "POSTGRESQL",
	2: "POOLER",
}

var ListClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"POSTGRESQL":               1,
	"POOLER":                   2,
}

func (x ListClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(ListClusterLogsRequest_ServiceType_name, int32(x))
}

func (ListClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{22, 0}
}

type StreamClusterLogsRequest_ServiceType int32

const (
	StreamClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED StreamClusterLogsRequest_ServiceType = 0
	// Logs of PostgreSQL activity.
	StreamClusterLogsRequest_POSTGRESQL StreamClusterLogsRequest_ServiceType = 1
	// Logs of connection pooler activity.
	StreamClusterLogsRequest_POOLER StreamClusterLogsRequest_ServiceType = 2
)

var StreamClusterLogsRequest_ServiceType_name = map[int32]string{
	0: "SERVICE_TYPE_UNSPECIFIED",
	1: "POSTGRESQL",
	2: "POOLER",
}

var StreamClusterLogsRequest_ServiceType_value = map[string]int32{
	"SERVICE_TYPE_UNSPECIFIED": 0,
	"POSTGRESQL":               1,
	"POOLER":                   2,
}

func (x StreamClusterLogsRequest_ServiceType) String() string {
	return proto.EnumName(StreamClusterLogsRequest_ServiceType_name, int32(x))
}

func (StreamClusterLogsRequest_ServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{24, 0}
}

type GetClusterRequest struct {
	// ID of the PostgreSQL Cluster resource to return.
	// To get the cluster ID use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{0}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type ListClustersRequest struct {
	// ID of the folder to list PostgreSQL clusters in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the [ListClustersResponse.next_page_token]
	// returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can only use filtering with the [Cluster.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Мust be 1-63 characters long and match the regular expression `^[a-zA-Z0-9_-]+$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{1}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListClustersResponse struct {
	// List of PostgreSQL Cluster resources.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClustersRequest.page_size], use the [next_page_token] as the value
	// for the [ListClustersRequest.page_token] parameter in the next list request. Each subsequent
	// list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{2}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateClusterRequest struct {
	// ID of the folder to create the PostgreSQL cluster in.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the PostgreSQL cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the PostgreSQL cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the PostgreSQL cluster.
	Environment Cluster_Environment `protobuf:"varint,5,opt,name=environment,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration and resources for hosts that should be created for the PostgreSQL cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Descriptions of databases to be created in the PostgreSQL cluster.
	DatabaseSpecs []*DatabaseSpec `protobuf:"bytes,7,rep,name=database_specs,json=databaseSpecs,proto3" json:"database_specs,omitempty"`
	// Descriptions of database users to be created in the PostgreSQL cluster.
	UserSpecs []*UserSpec `protobuf:"bytes,8,rep,name=user_specs,json=userSpecs,proto3" json:"user_specs,omitempty"`
	// Individual configurations for hosts that should be created for the PostgreSQL cluster.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the cluster in.
	NetworkId            string   `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{3}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *CreateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *CreateClusterRequest) GetDatabaseSpecs() []*DatabaseSpec {
	if m != nil {
		return m.DatabaseSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetUserSpecs() []*UserSpec {
	if m != nil {
		return m.UserSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *CreateClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type CreateClusterMetadata struct {
	// ID of the PostgreSQL cluster that is being created.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterMetadata) Reset()         { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()    {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{4}
}

func (m *CreateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterMetadata.Unmarshal(m, b)
}
func (m *CreateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *CreateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterMetadata.Merge(m, src)
}
func (m *CreateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateClusterMetadata.Size(m)
}
func (m *CreateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterMetadata proto.InternalMessageInfo

func (m *CreateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type UpdateClusterRequest struct {
	// ID of the PostgreSQL Cluster resource to update.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Field mask that specifies which fields of the PostgreSQL Cluster resource should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New description of the PostgreSQL cluster.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	//
	// The new set of labels will completely replace the old ones. To add a label, request the current
	// set with the [ClusterService.Get] method, then send an [ClusterService.Update] request with the new label added to the set.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// New configuration and resources for hosts in the cluster.
	ConfigSpec *ConfigSpec `protobuf:"bytes,5,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// New name for the cluster.
	Name                 string   `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterRequest) Reset()         { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()    {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{5}
}

func (m *UpdateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterRequest.Unmarshal(m, b)
}
func (m *UpdateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterRequest.Merge(m, src)
}
func (m *UpdateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterRequest.Size(m)
}
func (m *UpdateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterRequest proto.InternalMessageInfo

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *UpdateClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *UpdateClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type UpdateClusterMetadata struct {
	// ID of the PostgreSQL Cluster resource that is being updated.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterMetadata) Reset()         { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()    {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{6}
}

func (m *UpdateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterMetadata.Merge(m, src)
}
func (m *UpdateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterMetadata.Size(m)
}
func (m *UpdateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterMetadata proto.InternalMessageInfo

func (m *UpdateClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterRequest struct {
	// ID of the PostgreSQL cluster to delete.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{7}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type DeleteClusterMetadata struct {
	// ID of the PostgreSQL cluster that is being deleted.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterMetadata) Reset()         { *m = DeleteClusterMetadata{} }
func (m *DeleteClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterMetadata) ProtoMessage()    {}
func (*DeleteClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{8}
}

func (m *DeleteClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterMetadata.Merge(m, src)
}
func (m *DeleteClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterMetadata.Size(m)
}
func (m *DeleteClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterMetadata proto.InternalMessageInfo

func (m *DeleteClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterRequest struct {
	// ID of the PostgreSQL cluster to start.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterRequest) Reset()         { *m = StartClusterRequest{} }
func (m *StartClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterRequest) ProtoMessage()    {}
func (*StartClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{9}
}

func (m *StartClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterRequest.Unmarshal(m, b)
}
func (m *StartClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterRequest.Marshal(b, m, deterministic)
}
func (m *StartClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterRequest.Merge(m, src)
}
func (m *StartClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterRequest.Size(m)
}
func (m *StartClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterRequest proto.InternalMessageInfo

func (m *StartClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StartClusterMetadata struct {
	// ID of the PostgreSQL cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterMetadata) Reset()         { *m = StartClusterMetadata{} }
func (m *StartClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterMetadata) ProtoMessage()    {}
func (*StartClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{10}
}

func (m *StartClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterMetadata.Unmarshal(m, b)
}
func (m *StartClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StartClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterMetadata.Merge(m, src)
}
func (m *StartClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterMetadata.Size(m)
}
func (m *StartClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterMetadata proto.InternalMessageInfo

func (m *StartClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterRequest struct {
	// ID of the PostgreSQL cluster to stop.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterRequest) Reset()         { *m = StopClusterRequest{} }
func (m *StopClusterRequest) String() string { return proto.CompactTextString(m) }
func (*StopClusterRequest) ProtoMessage()    {}
func (*StopClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{11}
}

func (m *StopClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterRequest.Unmarshal(m, b)
}
func (m *StopClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterRequest.Marshal(b, m, deterministic)
}
func (m *StopClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterRequest.Merge(m, src)
}
func (m *StopClusterRequest) XXX_Size() int {
	return xxx_messageInfo_StopClusterRequest.Size(m)
}
func (m *StopClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterRequest proto.InternalMessageInfo

func (m *StopClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type StopClusterMetadata struct {
	// ID of the PostgreSQL cluster.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopClusterMetadata) Reset()         { *m = StopClusterMetadata{} }
func (m *StopClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*StopClusterMetadata) ProtoMessage()    {}
func (*StopClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{12}
}

func (m *StopClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopClusterMetadata.Unmarshal(m, b)
}
func (m *StopClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopClusterMetadata.Marshal(b, m, deterministic)
}
func (m *StopClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopClusterMetadata.Merge(m, src)
}
func (m *StopClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_StopClusterMetadata.Size(m)
}
func (m *StopClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StopClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StopClusterMetadata proto.InternalMessageInfo

func (m *StopClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type MoveClusterRequest struct {
	// ID of the PostgreSQL cluster to move.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the destination folder.
	DestinationFolderId  string   `protobuf:"bytes,2,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterRequest) Reset()         { *m = MoveClusterRequest{} }
func (m *MoveClusterRequest) String() string { return proto.CompactTextString(m) }
func (*MoveClusterRequest) ProtoMessage()    {}
func (*MoveClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{13}
}

func (m *MoveClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterRequest.Unmarshal(m, b)
}
func (m *MoveClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterRequest.Marshal(b, m, deterministic)
}
func (m *MoveClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterRequest.Merge(m, src)
}
func (m *MoveClusterRequest) XXX_Size() int {
	return xxx_messageInfo_MoveClusterRequest.Size(m)
}
func (m *MoveClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterRequest proto.InternalMessageInfo

func (m *MoveClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterRequest) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type MoveClusterMetadata struct {
	// ID of the PostgreSQL cluster being moved.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the source folder.
	SourceFolderId string `protobuf:"bytes,2,opt,name=source_folder_id,json=sourceFolderId,proto3" json:"source_folder_id,omitempty"`
	// ID of the destnation folder.
	DestinationFolderId  string   `protobuf:"bytes,3,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveClusterMetadata) Reset()         { *m = MoveClusterMetadata{} }
func (m *MoveClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*MoveClusterMetadata) ProtoMessage()    {}
func (*MoveClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{14}
}

func (m *MoveClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveClusterMetadata.Unmarshal(m, b)
}
func (m *MoveClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveClusterMetadata.Marshal(b, m, deterministic)
}
func (m *MoveClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveClusterMetadata.Merge(m, src)
}
func (m *MoveClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_MoveClusterMetadata.Size(m)
}
func (m *MoveClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MoveClusterMetadata proto.InternalMessageInfo

func (m *MoveClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *MoveClusterMetadata) GetSourceFolderId() string {
	if m != nil {
		return m.SourceFolderId
	}
	return ""
}

func (m *MoveClusterMetadata) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type BackupClusterRequest struct {
	// ID of the PostgreSQL cluster to back up.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterRequest) Reset()         { *m = BackupClusterRequest{} }
func (m *BackupClusterRequest) String() string { return proto.CompactTextString(m) }
func (*BackupClusterRequest) ProtoMessage()    {}
func (*BackupClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{15}
}

func (m *BackupClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterRequest.Unmarshal(m, b)
}
func (m *BackupClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterRequest.Marshal(b, m, deterministic)
}
func (m *BackupClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterRequest.Merge(m, src)
}
func (m *BackupClusterRequest) XXX_Size() int {
	return xxx_messageInfo_BackupClusterRequest.Size(m)
}
func (m *BackupClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterRequest proto.InternalMessageInfo

func (m *BackupClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type BackupClusterMetadata struct {
	// ID of the PostgreSQL cluster that is being backed up.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupClusterMetadata) Reset()         { *m = BackupClusterMetadata{} }
func (m *BackupClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*BackupClusterMetadata) ProtoMessage()    {}
func (*BackupClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{16}
}

func (m *BackupClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackupClusterMetadata.Unmarshal(m, b)
}
func (m *BackupClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackupClusterMetadata.Marshal(b, m, deterministic)
}
func (m *BackupClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupClusterMetadata.Merge(m, src)
}
func (m *BackupClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_BackupClusterMetadata.Size(m)
}
func (m *BackupClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BackupClusterMetadata proto.InternalMessageInfo

func (m *BackupClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type RestoreClusterRequest struct {
	// ID of the backup to create a cluster from.
	// To get the backup ID, use a [ClusterService.ListBackups] request.
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Timestamp of the moment to which the PostgreSQL cluster should be restored.
	Time *timestamp.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Flag that indicates whether a database should be restored to the first backup point
	// available just after the timestamp specified in the [time] field instead of just before.
	//
	// Possible values:
	// * false (default) — the restore point refers to the first backup moment before [time].
	// * true — the restore point refers to the first backup point after [time].
	TimeInclusive bool `protobuf:"varint,3,opt,name=time_inclusive,json=timeInclusive,proto3" json:"time_inclusive,omitempty"`
	// Name of the new PostgreSQL cluster. The name must be unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the new PostgreSQL cluster.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the PostgreSQL cluster as `` key:value `` pairs. Maximum 64 per resource.
	// For example, "project": "mvp" or "source": "dictionary".
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the new PostgreSQL cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.postgresql.v1.Cluster_Environment" json:"environment,omitempty"`
	// Configuration for the PostgreSQL cluster to be created.
	ConfigSpec *ConfigSpec `protobuf:"bytes,8,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	// Configurations for PostgreSQL hosts that should be created for
	// the cluster that is being created from the backup.
	HostSpecs []*HostSpec `protobuf:"bytes,9,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	// ID of the network to create the PostgreSQL cluster in.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// ID of the folder to create the PostgreSQL cluster in.
	FolderId             string   `protobuf:"bytes,11,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterRequest) Reset()         { *m = RestoreClusterRequest{} }
func (m *RestoreClusterRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterRequest) ProtoMessage()    {}
func (*RestoreClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{17}
}

func (m *RestoreClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterRequest.Unmarshal(m, b)
}
func (m *RestoreClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterRequest.Marshal(b, m, deterministic)
}
func (m *RestoreClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterRequest.Merge(m, src)
}
func (m *RestoreClusterRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterRequest.Size(m)
}
func (m *RestoreClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterRequest proto.InternalMessageInfo

func (m *RestoreClusterRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *RestoreClusterRequest) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *RestoreClusterRequest) GetTimeInclusive() bool {
	if m != nil {
		return m.TimeInclusive
	}
	return false
}

func (m *RestoreClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RestoreClusterRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *RestoreClusterRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *RestoreClusterRequest) GetEnvironment() Cluster_Environment {
	if m != nil {
		return m.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (m *RestoreClusterRequest) GetConfigSpec() *ConfigSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

func (m *RestoreClusterRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

func (m *RestoreClusterRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *RestoreClusterRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

type RestoreClusterMetadata struct {
	// ID of the new PostgreSQL cluster that is being created from a backup.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the backup that is being used for creating a cluster.
	BackupId             string   `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreClusterMetadata) Reset()         { *m = RestoreClusterMetadata{} }
func (m *RestoreClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*RestoreClusterMetadata) ProtoMessage()    {}
func (*RestoreClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{18}
}

func (m *RestoreClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreClusterMetadata.Unmarshal(m, b)
}
func (m *RestoreClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreClusterMetadata.Marshal(b, m, deterministic)
}
func (m *RestoreClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreClusterMetadata.Merge(m, src)
}
func (m *RestoreClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_RestoreClusterMetadata.Size(m)
}
func (m *RestoreClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreClusterMetadata proto.InternalMessageInfo

func (m *RestoreClusterMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RestoreClusterMetadata) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

type StartClusterFailoverRequest struct {
	// ID of PostgreSQL cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// New master host. Switch to the most up-to-date replica if not provided.
	HostName             string   `protobuf:"bytes,2,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterFailoverRequest) Reset()         { *m = StartClusterFailoverRequest{} }
func (m *StartClusterFailoverRequest) String() string { return proto.CompactTextString(m) }
func (*StartClusterFailoverRequest) ProtoMessage()    {}
func (*StartClusterFailoverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{19}
}

func (m *StartClusterFailoverRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterFailoverRequest.Unmarshal(m, b)
}
func (m *StartClusterFailoverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterFailoverRequest.Marshal(b, m, deterministic)
}
func (m *StartClusterFailoverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterFailoverRequest.Merge(m, src)
}
func (m *StartClusterFailoverRequest) XXX_Size() int {
	return xxx_messageInfo_StartClusterFailoverRequest.Size(m)
}
func (m *StartClusterFailoverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterFailoverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterFailoverRequest proto.InternalMessageInfo

func (m *StartClusterFailoverRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StartClusterFailoverRequest) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

type StartClusterFailoverMetadata struct {
	// ID of the PostgreSQL cluster being failovered.
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartClusterFailoverMetadata) Reset()         { *m = StartClusterFailoverMetadata{} }
func (m *StartClusterFailoverMetadata) String() string { return proto.CompactTextString(m) }
func (*StartClusterFailoverMetadata) ProtoMessage()    {}
func (*StartClusterFailoverMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{20}
}

func (m *StartClusterFailoverMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartClusterFailoverMetadata.Unmarshal(m, b)
}
func (m *StartClusterFailoverMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartClusterFailoverMetadata.Marshal(b, m, deterministic)
}
func (m *StartClusterFailoverMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartClusterFailoverMetadata.Merge(m, src)
}
func (m *StartClusterFailoverMetadata) XXX_Size() int {
	return xxx_messageInfo_StartClusterFailoverMetadata.Size(m)
}
func (m *StartClusterFailoverMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StartClusterFailoverMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StartClusterFailoverMetadata proto.InternalMessageInfo

func (m *StartClusterFailoverMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

type LogRecord struct {
	// Log record timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Contents of the log record.
	Message              map[string]string `protobuf:"bytes,2,rep,name=message,proto3" json:"message,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LogRecord) Reset()         { *m = LogRecord{} }
func (m *LogRecord) String() string { return proto.CompactTextString(m) }
func (*LogRecord) ProtoMessage()    {}
func (*LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{21}
}

func (m *LogRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogRecord.Unmarshal(m, b)
}
func (m *LogRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogRecord.Marshal(b, m, deterministic)
}
func (m *LogRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogRecord.Merge(m, src)
}
func (m *LogRecord) XXX_Size() int {
	return xxx_messageInfo_LogRecord.Size(m)
}
func (m *LogRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_LogRecord.DiscardUnknown(m)
}

var xxx_messageInfo_LogRecord proto.InternalMessageInfo

func (m *LogRecord) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogRecord) GetMessage() map[string]string {
	if m != nil {
		return m.Message
	}
	return nil
}

type ListClusterLogsRequest struct {
	// ID of the PostgreSQL cluster to request logs for.
	// To get the PostgreSQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from the logs table to request.
	// If no columns are specified, entire log records are returned.
	ColumnFilter []string `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	// Type of the service to request logs about.
	ServiceType ListClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.postgresql.v1.ListClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ToTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterLogsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListClusterLogsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Always return `next_page_token`, even if current page is empty.
	AlwaysNextPageToken  bool     `protobuf:"varint,8,opt,name=always_next_page_token,json=alwaysNextPageToken,proto3" json:"always_next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsRequest) Reset()         { *m = ListClusterLogsRequest{} }
func (m *ListClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsRequest) ProtoMessage()    {}
func (*ListClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{22}
}

func (m *ListClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsRequest.Unmarshal(m, b)
}
func (m *ListClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsRequest.Merge(m, src)
}
func (m *ListClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsRequest.Size(m)
}
func (m *ListClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsRequest proto.InternalMessageInfo

func (m *ListClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *ListClusterLogsRequest) GetServiceType() ListClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return ListClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *ListClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

func (m *ListClusterLogsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListClusterLogsRequest) GetAlwaysNextPageToken() bool {
	if m != nil {
		return m.AlwaysNextPageToken
	}
	return false
}

type ListClusterLogsResponse struct {
	// Requested log records.
	Logs []*LogRecord `protobuf:"bytes,1,rep,name=logs,proto3" json:"logs,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterLogsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterLogsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterLogsResponse) Reset()         { *m = ListClusterLogsResponse{} }
func (m *ListClusterLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterLogsResponse) ProtoMessage()    {}
func (*ListClusterLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{23}
}

func (m *ListClusterLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterLogsResponse.Unmarshal(m, b)
}
func (m *ListClusterLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterLogsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterLogsResponse.Merge(m, src)
}
func (m *ListClusterLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterLogsResponse.Size(m)
}
func (m *ListClusterLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterLogsResponse proto.InternalMessageInfo

func (m *ListClusterLogsResponse) GetLogs() []*LogRecord {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *ListClusterLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type StreamClusterLogsRequest struct {
	// Required. ID of the PostgreSQL cluster.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Columns from logs table to get in the response.
	ColumnFilter []string                             `protobuf:"bytes,2,rep,name=column_filter,json=columnFilter,proto3" json:"column_filter,omitempty"`
	ServiceType  StreamClusterLogsRequest_ServiceType `protobuf:"varint,3,opt,name=service_type,json=serviceType,proto3,enum=yandex.cloud.mdb.postgresql.v1.StreamClusterLogsRequest_ServiceType" json:"service_type,omitempty"`
	// Start timestamp for the logs request.
	FromTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=from_time,json=fromTime,proto3" json:"from_time,omitempty"`
	// End timestamp for the logs request.
	// If this field is not set, all existing logs will be sent and then the new ones as
	// they appear. In essence it has 'tail -f' semantics.
	ToTime               *timestamp.Timestamp `protobuf:"bytes,5,opt,name=to_time,json=toTime,proto3" json:"to_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StreamClusterLogsRequest) Reset()         { *m = StreamClusterLogsRequest{} }
func (m *StreamClusterLogsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamClusterLogsRequest) ProtoMessage()    {}
func (*StreamClusterLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{24}
}

func (m *StreamClusterLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamClusterLogsRequest.Unmarshal(m, b)
}
func (m *StreamClusterLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamClusterLogsRequest.Marshal(b, m, deterministic)
}
func (m *StreamClusterLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamClusterLogsRequest.Merge(m, src)
}
func (m *StreamClusterLogsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamClusterLogsRequest.Size(m)
}
func (m *StreamClusterLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamClusterLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamClusterLogsRequest proto.InternalMessageInfo

func (m *StreamClusterLogsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *StreamClusterLogsRequest) GetColumnFilter() []string {
	if m != nil {
		return m.ColumnFilter
	}
	return nil
}

func (m *StreamClusterLogsRequest) GetServiceType() StreamClusterLogsRequest_ServiceType {
	if m != nil {
		return m.ServiceType
	}
	return StreamClusterLogsRequest_SERVICE_TYPE_UNSPECIFIED
}

func (m *StreamClusterLogsRequest) GetFromTime() *timestamp.Timestamp {
	if m != nil {
		return m.FromTime
	}
	return nil
}

func (m *StreamClusterLogsRequest) GetToTime() *timestamp.Timestamp {
	if m != nil {
		return m.ToTime
	}
	return nil
}

type ListClusterOperationsRequest struct {
	// ID of the PostgreSQL Cluster resource to list operations for.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterOperationsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsRequest) Reset()         { *m = ListClusterOperationsRequest{} }
func (m *ListClusterOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsRequest) ProtoMessage()    {}
func (*ListClusterOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{25}
}

func (m *ListClusterOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsRequest.Unmarshal(m, b)
}
func (m *ListClusterOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsRequest.Merge(m, src)
}
func (m *ListClusterOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsRequest.Size(m)
}
func (m *ListClusterOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsRequest proto.InternalMessageInfo

func (m *ListClusterOperationsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterOperationsResponse struct {
	// List of Operation resources for the specified PostgreSQL cluster.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterOperationsResponse) Reset()         { *m = ListClusterOperationsResponse{} }
func (m *ListClusterOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterOperationsResponse) ProtoMessage()    {}
func (*ListClusterOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{26}
}

func (m *ListClusterOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterOperationsResponse.Unmarshal(m, b)
}
func (m *ListClusterOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterOperationsResponse.Merge(m, src)
}
func (m *ListClusterOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterOperationsResponse.Size(m)
}
func (m *ListClusterOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterOperationsResponse proto.InternalMessageInfo

func (m *ListClusterOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListClusterOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterBackupsRequest struct {
	// ID of the PostgreSQL cluster.
	// To get the PostgreSQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterBackupsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterBackupsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsRequest) Reset()         { *m = ListClusterBackupsRequest{} }
func (m *ListClusterBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsRequest) ProtoMessage()    {}
func (*ListClusterBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{27}
}

func (m *ListClusterBackupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsRequest.Unmarshal(m, b)
}
func (m *ListClusterBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsRequest.Merge(m, src)
}
func (m *ListClusterBackupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsRequest.Size(m)
}
func (m *ListClusterBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsRequest proto.InternalMessageInfo

func (m *ListClusterBackupsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterBackupsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterBackupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterBackupsResponse struct {
	// List of PostgreSQL Backup resources.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterBackupsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterBackupsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterBackupsResponse) Reset()         { *m = ListClusterBackupsResponse{} }
func (m *ListClusterBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterBackupsResponse) ProtoMessage()    {}
func (*ListClusterBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{28}
}

func (m *ListClusterBackupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterBackupsResponse.Unmarshal(m, b)
}
func (m *ListClusterBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterBackupsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterBackupsResponse.Merge(m, src)
}
func (m *ListClusterBackupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterBackupsResponse.Size(m)
}
func (m *ListClusterBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterBackupsResponse proto.InternalMessageInfo

func (m *ListClusterBackupsResponse) GetBackups() []*Backup {
	if m != nil {
		return m.Backups
	}
	return nil
}

func (m *ListClusterBackupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListClusterHostsRequest struct {
	// ID of the PostgreSQL cluster.
	// To get the PostgreSQL cluster ID use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.  To get the next page of results, set [page_token] to the [ListClusterHostsResponse.next_page_token]
	// returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsRequest) Reset()         { *m = ListClusterHostsRequest{} }
func (m *ListClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsRequest) ProtoMessage()    {}
func (*ListClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{29}
}

func (m *ListClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsRequest.Unmarshal(m, b)
}
func (m *ListClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsRequest.Merge(m, src)
}
func (m *ListClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsRequest.Size(m)
}
func (m *ListClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsRequest proto.InternalMessageInfo

func (m *ListClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ListClusterHostsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClusterHostsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListClusterHostsResponse struct {
	// List of Host resources.
	Hosts []*Host `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListClusterHostsRequest.page_size], use the [next_page_token] as the value
	// for the [ListClusterHostsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClusterHostsResponse) Reset()         { *m = ListClusterHostsResponse{} }
func (m *ListClusterHostsResponse) String() string { return proto.CompactTextString(m) }
func (*ListClusterHostsResponse) ProtoMessage()    {}
func (*ListClusterHostsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{30}
}

func (m *ListClusterHostsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClusterHostsResponse.Unmarshal(m, b)
}
func (m *ListClusterHostsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClusterHostsResponse.Marshal(b, m, deterministic)
}
func (m *ListClusterHostsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClusterHostsResponse.Merge(m, src)
}
func (m *ListClusterHostsResponse) XXX_Size() int {
	return xxx_messageInfo_ListClusterHostsResponse.Size(m)
}
func (m *ListClusterHostsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClusterHostsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClusterHostsResponse proto.InternalMessageInfo

func (m *ListClusterHostsResponse) GetHosts() []*Host {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *ListClusterHostsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type AddClusterHostsRequest struct {
	// ID of the PostgreSQL cluster to add hosts to.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Configurations for PostgreSQL hosts that should be added to the cluster.
	HostSpecs            []*HostSpec `protobuf:"bytes,2,rep,name=host_specs,json=hostSpecs,proto3" json:"host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AddClusterHostsRequest) Reset()         { *m = AddClusterHostsRequest{} }
func (m *AddClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsRequest) ProtoMessage()    {}
func (*AddClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{31}
}

func (m *AddClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsRequest.Unmarshal(m, b)
}
func (m *AddClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *AddClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsRequest.Merge(m, src)
}
func (m *AddClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsRequest.Size(m)
}
func (m *AddClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsRequest proto.InternalMessageInfo

func (m *AddClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsRequest) GetHostSpecs() []*HostSpec {
	if m != nil {
		return m.HostSpecs
	}
	return nil
}

type AddClusterHostsMetadata struct {
	// ID of the PostgreSQL cluster to which the hosts are being added.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being added to the cluster.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddClusterHostsMetadata) Reset()         { *m = AddClusterHostsMetadata{} }
func (m *AddClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*AddClusterHostsMetadata) ProtoMessage()    {}
func (*AddClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{32}
}

func (m *AddClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddClusterHostsMetadata.Unmarshal(m, b)
}
func (m *AddClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *AddClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddClusterHostsMetadata.Merge(m, src)
}
func (m *AddClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_AddClusterHostsMetadata.Size(m)
}
func (m *AddClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AddClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AddClusterHostsMetadata proto.InternalMessageInfo

func (m *AddClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AddClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsRequest struct {
	// ID of the PostgreSQL cluster to remove hosts from.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts to delete.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsRequest) Reset()         { *m = DeleteClusterHostsRequest{} }
func (m *DeleteClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsRequest) ProtoMessage()    {}
func (*DeleteClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{33}
}

func (m *DeleteClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsRequest.Unmarshal(m, b)
}
func (m *DeleteClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsRequest.Merge(m, src)
}
func (m *DeleteClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsRequest.Size(m)
}
func (m *DeleteClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsRequest proto.InternalMessageInfo

func (m *DeleteClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsRequest) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type DeleteClusterHostsMetadata struct {
	// ID of the PostgreSQL cluster to remove hosts from.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being deleted.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterHostsMetadata) Reset()         { *m = DeleteClusterHostsMetadata{} }
func (m *DeleteClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterHostsMetadata) ProtoMessage()    {}
func (*DeleteClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{34}
}

func (m *DeleteClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Unmarshal(m, b)
}
func (m *DeleteClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterHostsMetadata.Merge(m, src)
}
func (m *DeleteClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterHostsMetadata.Size(m)
}
func (m *DeleteClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterHostsMetadata proto.InternalMessageInfo

func (m *DeleteClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type UpdateClusterHostsRequest struct {
	// ID of the PostgreSQL cluster to update hosts in.
	// To get the PostgreSQL cluster ID, use a [ClusterService.List] request.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// New configurations to apply to hosts.
	UpdateHostSpecs      []*UpdateHostSpec `protobuf:"bytes,2,rep,name=update_host_specs,json=updateHostSpecs,proto3" json:"update_host_specs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateClusterHostsRequest) Reset()         { *m = UpdateClusterHostsRequest{} }
func (m *UpdateClusterHostsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterHostsRequest) ProtoMessage()    {}
func (*UpdateClusterHostsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{35}
}

func (m *UpdateClusterHostsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterHostsRequest.Unmarshal(m, b)
}
func (m *UpdateClusterHostsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterHostsRequest.Marshal(b, m, deterministic)
}
func (m *UpdateClusterHostsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterHostsRequest.Merge(m, src)
}
func (m *UpdateClusterHostsRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterHostsRequest.Size(m)
}
func (m *UpdateClusterHostsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterHostsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterHostsRequest proto.InternalMessageInfo

func (m *UpdateClusterHostsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterHostsRequest) GetUpdateHostSpecs() []*UpdateHostSpec {
	if m != nil {
		return m.UpdateHostSpecs
	}
	return nil
}

type UpdateClusterHostsMetadata struct {
	// ID of the PostgreSQL cluster to update hosts in.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Names of hosts that are being updated.
	HostNames            []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateClusterHostsMetadata) Reset()         { *m = UpdateClusterHostsMetadata{} }
func (m *UpdateClusterHostsMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterHostsMetadata) ProtoMessage()    {}
func (*UpdateClusterHostsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{36}
}

func (m *UpdateClusterHostsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterHostsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateClusterHostsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterHostsMetadata.Merge(m, src)
}
func (m *UpdateClusterHostsMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterHostsMetadata.Size(m)
}
func (m *UpdateClusterHostsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterHostsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterHostsMetadata proto.InternalMessageInfo

func (m *UpdateClusterHostsMetadata) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterHostsMetadata) GetHostNames() []string {
	if m != nil {
		return m.HostNames
	}
	return nil
}

type UpdateHostSpec struct {
	// Name of the host to update.
	// To get the PostgreSQL host name, use a [ClusterService.ListHosts] request.
	HostName string `protobuf:"bytes,1,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	// [Host.name] of the host to be used as the replication source (for cascading replication).
	// To get the PostgreSQL host name, use a [ClusterService.ListHosts] request.
	ReplicationSource string `protobuf:"bytes,2,opt,name=replication_source,json=replicationSource,proto3" json:"replication_source,omitempty"`
	// The host with the highest priority is the synchronous replica. All others are asynchronous.
	// The synchronous replica replaces the master when needed.
	//
	// When a replica becomes the master, its priority is ignored.
	Priority *wrappers.Int64Value `protobuf:"bytes,3,opt,name=priority,proto3" json:"priority,omitempty"`
	// Configuration of a PostgreSQL server for the host.
	ConfigSpec           *ConfigHostSpec `protobuf:"bytes,4,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *UpdateHostSpec) Reset()         { *m = UpdateHostSpec{} }
func (m *UpdateHostSpec) String() string { return proto.CompactTextString(m) }
func (*UpdateHostSpec) ProtoMessage()    {}
func (*UpdateHostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{37}
}

func (m *UpdateHostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateHostSpec.Unmarshal(m, b)
}
func (m *UpdateHostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateHostSpec.Marshal(b, m, deterministic)
}
func (m *UpdateHostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateHostSpec.Merge(m, src)
}
func (m *UpdateHostSpec) XXX_Size() int {
	return xxx_messageInfo_UpdateHostSpec.Size(m)
}
func (m *UpdateHostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateHostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateHostSpec proto.InternalMessageInfo

func (m *UpdateHostSpec) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *UpdateHostSpec) GetReplicationSource() string {
	if m != nil {
		return m.ReplicationSource
	}
	return ""
}

func (m *UpdateHostSpec) GetPriority() *wrappers.Int64Value {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *UpdateHostSpec) GetConfigSpec() *ConfigHostSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

type HostSpec struct {
	// ID of the availability zone where the host resides.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host should belong to. This subnet should be a part
	// of the network that the cluster belongs to.
	// The ID of the network is set in the field [Cluster.network_id].
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Whether the host should get a public IP address on creation.
	//
	// After a host has been created, this setting cannot be changed. To remove an assigned public IP, or to assign
	// a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.
	//
	// Possible values:
	// * false — don't assign a public IP to the host.
	// * true — the host should have a public IP address.
	AssignPublicIp bool `protobuf:"varint,3,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// [Host.name] of the host to be used as the replication source (for cascading replication).
	ReplicationSource string `protobuf:"bytes,4,opt,name=replication_source,json=replicationSource,proto3" json:"replication_source,omitempty"`
	// Priority of the host as a replica. A higher value corresponds to higher priority.
	//
	// The host with the highest priority is the synchronous replica. All others are asynchronous.
	// The synchronous replica replaces the master when needed.
	//
	// When a replica becomes the master, its priority is ignored.
	Priority *wrappers.Int64Value `protobuf:"bytes,5,opt,name=priority,proto3" json:"priority,omitempty"`
	// Configuration of a PostgreSQL server for the host.
	ConfigSpec           *ConfigHostSpec `protobuf:"bytes,6,opt,name=config_spec,json=configSpec,proto3" json:"config_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *HostSpec) Reset()         { *m = HostSpec{} }
func (m *HostSpec) String() string { return proto.CompactTextString(m) }
func (*HostSpec) ProtoMessage()    {}
func (*HostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{38}
}

func (m *HostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HostSpec.Unmarshal(m, b)
}
func (m *HostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HostSpec.Marshal(b, m, deterministic)
}
func (m *HostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HostSpec.Merge(m, src)
}
func (m *HostSpec) XXX_Size() int {
	return xxx_messageInfo_HostSpec.Size(m)
}
func (m *HostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_HostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_HostSpec proto.InternalMessageInfo

func (m *HostSpec) GetZoneId() string {
	if m != nil {
		return m.ZoneId
	}
	return ""
}

func (m *HostSpec) GetSubnetId() string {
	if m != nil {
		return m.SubnetId
	}
	return ""
}

func (m *HostSpec) GetAssignPublicIp() bool {
	if m != nil {
		return m.AssignPublicIp
	}
	return false
}

func (m *HostSpec) GetReplicationSource() string {
	if m != nil {
		return m.ReplicationSource
	}
	return ""
}

func (m *HostSpec) GetPriority() *wrappers.Int64Value {
	if m != nil {
		return m.Priority
	}
	return nil
}

func (m *HostSpec) GetConfigSpec() *ConfigHostSpec {
	if m != nil {
		return m.ConfigSpec
	}
	return nil
}

type ConfigSpec struct {
	// Version of PostgreSQL used in the cluster.
	// Possible values: `9.6`, `10`, `10_1c`, `11`, `12`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Configuration of a PostgreSQL cluster.
	//
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*ConfigSpec_PostgresqlConfig_9_6
	//	*ConfigSpec_PostgresqlConfig_10_1C
	//	*ConfigSpec_PostgresqlConfig_10
	//	*ConfigSpec_PostgresqlConfig_11
	//	*ConfigSpec_PostgresqlConfig_12
	PostgresqlConfig isConfigSpec_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	// Configuration of the connection pooler.
	PoolerConfig *ConnectionPoolerConfig `protobuf:"bytes,4,opt,name=pooler_config,json=poolerConfig,proto3" json:"pooler_config,omitempty"`
	// Resources allocated to PostgreSQL hosts.
	Resources *Resources `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Configuration setting which enables/disables autofailover in cluster.
	Autofailover *wrappers.BoolValue `protobuf:"bytes,6,opt,name=autofailover,proto3" json:"autofailover,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,8,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy to DB
	Access               *Access  `protobuf:"bytes,9,opt,name=access,proto3" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigSpec) Reset()         { *m = ConfigSpec{} }
func (m *ConfigSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigSpec) ProtoMessage()    {}
func (*ConfigSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{39}
}

func (m *ConfigSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSpec.Unmarshal(m, b)
}
func (m *ConfigSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSpec.Marshal(b, m, deterministic)
}
func (m *ConfigSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSpec.Merge(m, src)
}
func (m *ConfigSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigSpec.Size(m)
}
func (m *ConfigSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSpec proto.InternalMessageInfo

func (m *ConfigSpec) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type isConfigSpec_PostgresqlConfig interface {
	isConfigSpec_PostgresqlConfig()
}

type ConfigSpec_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlConfig9_6 `protobuf:"bytes,2,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type ConfigSpec_PostgresqlConfig_10_1C struct {
	PostgresqlConfig_10_1C *config.PostgresqlConfig10_1C `protobuf:"bytes,10,opt,name=postgresql_config_10_1c,json=postgresqlConfig101c,proto3,oneof"`
}

type ConfigSpec_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlConfig10 `protobuf:"bytes,3,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type ConfigSpec_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlConfig11 `protobuf:"bytes,7,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

type ConfigSpec_PostgresqlConfig_12 struct {
	PostgresqlConfig_12 *config.PostgresqlConfig12 `protobuf:"bytes,11,opt,name=postgresql_config_12,json=postgresqlConfig12,proto3,oneof"`
}

func (*ConfigSpec_PostgresqlConfig_9_6) isConfigSpec_PostgresqlConfig() {}

func (*ConfigSpec_PostgresqlConfig_10_1C) isConfigSpec_PostgresqlConfig() {}

func (*ConfigSpec_PostgresqlConfig_10) isConfigSpec_PostgresqlConfig() {}

func (*ConfigSpec_PostgresqlConfig_11) isConfigSpec_PostgresqlConfig() {}

func (*ConfigSpec_PostgresqlConfig_12) isConfigSpec_PostgresqlConfig() {}

func (m *ConfigSpec) GetPostgresqlConfig() isConfigSpec_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_9_6() *config.PostgresqlConfig9_6 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_10_1C() *config.PostgresqlConfig10_1C {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_10_1C); ok {
		return x.PostgresqlConfig_10_1C
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_10() *config.PostgresqlConfig10 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_11() *config.PostgresqlConfig11 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (m *ConfigSpec) GetPostgresqlConfig_12() *config.PostgresqlConfig12 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigSpec_PostgresqlConfig_12); ok {
		return x.PostgresqlConfig_12
	}
	return nil
}

func (m *ConfigSpec) GetPoolerConfig() *ConnectionPoolerConfig {
	if m != nil {
		return m.PoolerConfig
	}
	return nil
}

func (m *ConfigSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ConfigSpec) GetAutofailover() *wrappers.BoolValue {
	if m != nil {
		return m.Autofailover
	}
	return nil
}

func (m *ConfigSpec) GetBackupWindowStart() *timeofday.TimeOfDay {
	if m != nil {
		return m.BackupWindowStart
	}
	return nil
}

func (m *ConfigSpec) GetAccess() *Access {
	if m != nil {
		return m.Access
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ConfigSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ConfigSpec_PostgresqlConfig_9_6)(nil),
		(*ConfigSpec_PostgresqlConfig_10_1C)(nil),
		(*ConfigSpec_PostgresqlConfig_10)(nil),
		(*ConfigSpec_PostgresqlConfig_11)(nil),
		(*ConfigSpec_PostgresqlConfig_12)(nil),
	}
}

type ConfigHostSpec struct {
	// Types that are valid to be assigned to PostgresqlConfig:
	//	*ConfigHostSpec_PostgresqlConfig_9_6
	//	*ConfigHostSpec_PostgresqlConfig_10_1C
	//	*ConfigHostSpec_PostgresqlConfig_10
	//	*ConfigHostSpec_PostgresqlConfig_11
	//	*ConfigHostSpec_PostgresqlConfig_12
	PostgresqlConfig     isConfigHostSpec_PostgresqlConfig `protobuf_oneof:"postgresql_config"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ConfigHostSpec) Reset()         { *m = ConfigHostSpec{} }
func (m *ConfigHostSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigHostSpec) ProtoMessage()    {}
func (*ConfigHostSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_fd68e7d7288beb05, []int{40}
}

func (m *ConfigHostSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigHostSpec.Unmarshal(m, b)
}
func (m *ConfigHostSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigHostSpec.Marshal(b, m, deterministic)
}
func (m *ConfigHostSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigHostSpec.Merge(m, src)
}
func (m *ConfigHostSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigHostSpec.Size(m)
}
func (m *ConfigHostSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigHostSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigHostSpec proto.InternalMessageInfo

type isConfigHostSpec_PostgresqlConfig interface {
	isConfigHostSpec_PostgresqlConfig()
}

type ConfigHostSpec_PostgresqlConfig_9_6 struct {
	PostgresqlConfig_9_6 *config.PostgresqlHostConfig9_6 `protobuf:"bytes,1,opt,name=postgresql_config_9_6,json=postgresqlConfig96,proto3,oneof"`
}

type ConfigHostSpec_PostgresqlConfig_10_1C struct {
	PostgresqlConfig_10_1C *config.PostgresqlHostConfig10_1C `protobuf:"bytes,4,opt,name=postgresql_config_10_1c,json=postgresqlConfig101c,proto3,oneof"`
}

type ConfigHostSpec_PostgresqlConfig_10 struct {
	PostgresqlConfig_10 *config.PostgresqlHostConfig10 `protobuf:"bytes,2,opt,name=postgresql_config_10,json=postgresqlConfig10,proto3,oneof"`
}

type ConfigHostSpec_PostgresqlConfig_11 struct {
	PostgresqlConfig_11 *config.PostgresqlHostConfig11 `protobuf:"bytes,3,opt,name=postgresql_config_11,json=postgresqlConfig11,proto3,oneof"`
}

type ConfigHostSpec_PostgresqlConfig_12 struct {
	PostgresqlConfig_12 *config.PostgresqlHostConfig12 `protobuf:"bytes,5,opt,name=postgresql_config_12,json=postgresqlConfig12,proto3,oneof"`
}

func (*ConfigHostSpec_PostgresqlConfig_9_6) isConfigHostSpec_PostgresqlConfig() {}

func (*ConfigHostSpec_PostgresqlConfig_10_1C) isConfigHostSpec_PostgresqlConfig() {}

func (*ConfigHostSpec_PostgresqlConfig_10) isConfigHostSpec_PostgresqlConfig() {}

func (*ConfigHostSpec_PostgresqlConfig_11) isConfigHostSpec_PostgresqlConfig() {}

func (*ConfigHostSpec_PostgresqlConfig_12) isConfigHostSpec_PostgresqlConfig() {}

func (m *ConfigHostSpec) GetPostgresqlConfig() isConfigHostSpec_PostgresqlConfig {
	if m != nil {
		return m.PostgresqlConfig
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_9_6() *config.PostgresqlHostConfig9_6 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_9_6); ok {
		return x.PostgresqlConfig_9_6
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_10_1C() *config.PostgresqlHostConfig10_1C {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_10_1C); ok {
		return x.PostgresqlConfig_10_1C
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_10() *config.PostgresqlHostConfig10 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_10); ok {
		return x.PostgresqlConfig_10
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_11() *config.PostgresqlHostConfig11 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_11); ok {
		return x.PostgresqlConfig_11
	}
	return nil
}

func (m *ConfigHostSpec) GetPostgresqlConfig_12() *config.PostgresqlHostConfig12 {
	if x, ok := m.GetPostgresqlConfig().(*ConfigHostSpec_PostgresqlConfig_12); ok {
		return x.PostgresqlConfig_12
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ConfigHostSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ConfigHostSpec_PostgresqlConfig_9_6)(nil),
		(*ConfigHostSpec_PostgresqlConfig_10_1C)(nil),
		(*ConfigHostSpec_PostgresqlConfig_10)(nil),
		(*ConfigHostSpec_PostgresqlConfig_11)(nil),
		(*ConfigHostSpec_PostgresqlConfig_12)(nil),
	}
}

func init() {
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.ListClusterLogsRequest_ServiceType", ListClusterLogsRequest_ServiceType_name, ListClusterLogsRequest_ServiceType_value)
	proto.RegisterEnum("yandex.cloud.mdb.postgresql.v1.StreamClusterLogsRequest_ServiceType", StreamClusterLogsRequest_ServiceType_name, StreamClusterLogsRequest_ServiceType_value)
	proto.RegisterType((*GetClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClustersResponse")
	proto.RegisterType((*CreateClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.CreateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.CreateClusterRequest.LabelsEntry")
	proto.RegisterType((*CreateClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterRequest.LabelsEntry")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterMetadata")
	proto.RegisterType((*DeleteClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterRequest")
	proto.RegisterType((*DeleteClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterMetadata")
	proto.RegisterType((*StartClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.StartClusterRequest")
	proto.RegisterType((*StartClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.StartClusterMetadata")
	proto.RegisterType((*StopClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.StopClusterRequest")
	proto.RegisterType((*StopClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.StopClusterMetadata")
	proto.RegisterType((*MoveClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.MoveClusterRequest")
	proto.RegisterType((*MoveClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.MoveClusterMetadata")
	proto.RegisterType((*BackupClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.BackupClusterRequest")
	proto.RegisterType((*BackupClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.BackupClusterMetadata")
	proto.RegisterType((*RestoreClusterRequest)(nil), "yandex.cloud.mdb.postgresql.v1.RestoreClusterRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.RestoreClusterRequest.LabelsEntry")
	proto.RegisterType((*RestoreClusterMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.RestoreClusterMetadata")
	proto.RegisterType((*StartClusterFailoverRequest)(nil), "yandex.cloud.mdb.postgresql.v1.StartClusterFailoverRequest")
	proto.RegisterType((*StartClusterFailoverMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.StartClusterFailoverMetadata")
	proto.RegisterType((*LogRecord)(nil), "yandex.cloud.mdb.postgresql.v1.LogRecord")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.mdb.postgresql.v1.LogRecord.MessageEntry")
	proto.RegisterType((*ListClusterLogsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterLogsRequest")
	proto.RegisterType((*ListClusterLogsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterLogsResponse")
	proto.RegisterType((*StreamClusterLogsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.StreamClusterLogsRequest")
	proto.RegisterType((*ListClusterOperationsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterOperationsRequest")
	proto.RegisterType((*ListClusterOperationsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterOperationsResponse")
	proto.RegisterType((*ListClusterBackupsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterBackupsRequest")
	proto.RegisterType((*ListClusterBackupsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterBackupsResponse")
	proto.RegisterType((*ListClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterHostsRequest")
	proto.RegisterType((*ListClusterHostsResponse)(nil), "yandex.cloud.mdb.postgresql.v1.ListClusterHostsResponse")
	proto.RegisterType((*AddClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.AddClusterHostsRequest")
	proto.RegisterType((*AddClusterHostsMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.AddClusterHostsMetadata")
	proto.RegisterType((*DeleteClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterHostsRequest")
	proto.RegisterType((*DeleteClusterHostsMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.DeleteClusterHostsMetadata")
	proto.RegisterType((*UpdateClusterHostsRequest)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterHostsRequest")
	proto.RegisterType((*UpdateClusterHostsMetadata)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateClusterHostsMetadata")
	proto.RegisterType((*UpdateHostSpec)(nil), "yandex.cloud.mdb.postgresql.v1.UpdateHostSpec")
	proto.RegisterType((*HostSpec)(nil), "yandex.cloud.mdb.postgresql.v1.HostSpec")
	proto.RegisterType((*ConfigSpec)(nil), "yandex.cloud.mdb.postgresql.v1.ConfigSpec")
	proto.RegisterType((*ConfigHostSpec)(nil), "yandex.cloud.mdb.postgresql.v1.ConfigHostSpec")
}

func init() {
	proto.RegisterFile("yandex/cloud/mdb/postgresql/v1/cluster_service.proto", fileDescriptor_fd68e7d7288beb05)
}

var fileDescriptor_fd68e7d7288beb05 = []byte{
	// 2953 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x1b, 0x4d, 0x6f, 0x1b, 0xc7,
	0x35, 0x2b, 0x51, 0x14, 0xf9, 0x68, 0x2b, 0xf6, 0x48, 0x76, 0x18, 0xfa, 0x23, 0xf2, 0x36, 0xb1,
	0x65, 0xc6, 0x22, 0x45, 0x4a, 0x96, 0x2d, 0xf9, 0x23, 0x96, 0x64, 0xc9, 0x11, 0x2a, 0x59, 0xca,
	0xca, 0x4e, 0x90, 0x18, 0xee, 0x62, 0xc5, 0x1d, 0xd1, 0x0b, 0x93, 0xbb, 0xeb, 0xdd, 0xa5, 0x1c,
	0xb9, 0x48, 0x91, 0x26, 0x40, 0x0f, 0x46, 0x0f, 0x45, 0x0b, 0xb4, 0x48, 0x0a, 0xf4, 0x17, 0xf4,
	0x52, 0x01, 0x6d, 0x80, 0xb4, 0xcd, 0x21, 0x17, 0xbb, 0x97, 0x16, 0x50, 0xee, 0x05, 0x0a, 0xe4,
	0xd0, 0x43, 0x91, 0x43, 0x8e, 0x3d, 0x15, 0xf3, 0xb1, 0xe4, 0x2e, 0x3f, 0xb4, 0xbb, 0xa4, 0x5d,
	0xf8, 0x64, 0xed, 0xcc, 0xfb, 0x9e, 0xf7, 0xde, 0xbc, 0x79, 0x8f, 0x86, 0xa9, 0x1d, 0x45, 0x57,
	0xf1, 0x87, 0xf9, 0x52, 0xc5, 0xa8, 0xa9, 0xf9, 0xaa, 0xba, 0x99, 0x37, 0x0d, 0xdb, 0x29, 0x5b,
	0xd8, 0x7e, 0x50, 0xc9, 0x6f, 0x17, 0xf2, 0xa5, 0x4a, 0xcd, 0x76, 0xb0, 0x25, 0xdb, 0xd8, 0xda,
	0xd6, 0x4a, 0x38, 0x67, 0x5a, 0x86, 0x63, 0xa0, 0x93, 0x0c, 0x2b, 0x47, 0xb1, 0x72, 0x55, 0x75,
	0x33, 0xd7, 0xc0, 0xca, 0x6d, 0x17, 0x32, 0xc7, 0xcb, 0x86, 0x51, 0xae, 0xe0, 0xbc, 0x62, 0x6a,
	0x79, 0x45, 0xd7, 0x0d, 0x47, 0x71, 0x34, 0x43, 0xb7, 0x19, 0x76, 0x66, 0x94, 0xef, 0xd2, 0xaf,
	0xcd, 0xda, 0x56, 0x7e, 0x4b, 0xc3, 0x15, 0x55, 0xae, 0x2a, 0xf6, 0x7d, 0x0e, 0xf1, 0x5a, 0x33,
	0x84, 0xa3, 0x55, 0xb1, 0xed, 0x28, 0x55, 0x93, 0x03, 0x9c, 0x6c, 0x06, 0x78, 0x68, 0x29, 0xa6,
	0x89, 0x2d, 0x97, 0xc5, 0x31, 0xbe, 0xef, 0xec, 0x98, 0x98, 0x22, 0x1b, 0x5b, 0xaa, 0xb2, 0xe3,
	0xf2, 0xf7, 0xe9, 0x4c, 0x64, 0x34, 0x4c, 0x6c, 0x51, 0x11, 0x39, 0xc4, 0x69, 0x1f, 0x44, 0x7d,
	0xb7, 0x05, 0xee, 0x84, 0x0f, 0x6e, 0x5b, 0xa9, 0x68, 0xaa, 0x77, 0xfb, 0xcd, 0x00, 0xe3, 0x6e,
	0x2a, 0xa5, 0xfb, 0x35, 0x57, 0xa5, 0x73, 0xe1, 0x4e, 0x82, 0x43, 0x8f, 0x07, 0x40, 0xab, 0x8a,
	0xa3, 0x6c, 0x2a, 0x36, 0x3f, 0xb0, 0xcc, 0xd9, 0x00, 0xf0, 0x9a, 0x5d, 0xa7, 0x3c, 0x13, 0x24,
	0x87, 0xa1, 0x6f, 0x69, 0x65, 0xcf, 0xe2, 0x8c, 0x3c, 0xcd, 0x51, 0x2f, 0x46, 0x45, 0x2d, 0x4c,
	0x70, 0xcc, 0x4b, 0xd1, 0x31, 0xe5, 0x42, 0xa9, 0x6b, 0xb6, 0x85, 0xae, 0x31, 0x8b, 0x1c, 0x73,
	0x32, 0x1c, 0xe6, 0x3d, 0xc3, 0x76, 0x1a, 0xf6, 0x29, 0x86, 0x47, 0xaa, 0x5b, 0xe6, 0x7c, 0x14,
	0x9c, 0x86, 0x4d, 0xa2, 0xb0, 0x2a, 0x74, 0x81, 0xc3, 0xed, 0x20, 0x5e, 0x83, 0xc3, 0x37, 0xb0,
	0xb3, 0xc0, 0x7c, 0x53, 0xc2, 0x0f, 0x6a, 0xd8, 0x76, 0xd0, 0x9b, 0x00, 0x6e, 0xde, 0xd0, 0xd4,
	0xb4, 0x30, 0x2a, 0x8c, 0x25, 0xe7, 0x0f, 0xfc, 0xfb, 0x49, 0x41, 0x78, 0xfc, 0xb4, 0x10, 0xbb,
	0x7c, 0xe5, 0xfc, 0x84, 0x94, 0xe4, 0xfb, 0xcb, 0xaa, 0xf8, 0x85, 0x00, 0xc3, 0x2b, 0x9a, 0xed,
	0xd2, 0xb0, 0x5d, 0x22, 0x67, 0x21, 0xb9, 0x65, 0x54, 0xd4, 0xce, 0x34, 0x12, 0x6c, 0x7b, 0x59,
	0x45, 0x67, 0x20, 0x69, 0x2a, 0x65, 0x2c, 0xdb, 0xda, 0x23, 0x9c, 0xee, 0x1b, 0x15, 0xc6, 0xfa,
	0xe7, 0xe1, 0xbf, 0x4f, 0x0a, 0xf1, 0xcb, 0x57, 0x0a, 0x13, 0x13, 0x13, 0x52, 0x82, 0x6c, 0x6e,
	0x68, 0x8f, 0x30, 0x1a, 0x03, 0xa0, 0x80, 0x8e, 0x71, 0x1f, 0xeb, 0xe9, 0x7e, 0x4a, 0x34, 0xf9,
	0xf8, 0x69, 0x61, 0x80, 0x42, 0x4a, 0x94, 0xca, 0x2d, 0xb2, 0x87, 0x44, 0x88, 0x6f, 0x69, 0x15,
	0x07, 0x5b, 0xe9, 0x18, 0x85, 0x82, 0xc7, 0x4f, 0xeb, 0xf4, 0xf8, 0x8e, 0xf8, 0xa9, 0x00, 0x23,
	0x7e, 0xc9, 0x6d, 0xd3, 0xd0, 0x6d, 0x8c, 0x16, 0x20, 0xc1, 0xf5, 0xb3, 0xd3, 0xc2, 0x68, 0xff,
	0x58, 0xaa, 0x78, 0x26, 0xb7, 0x7f, 0xc6, 0xcc, 0xb9, 0x16, 0xac, 0x23, 0xa2, 0xd3, 0xf0, 0xb2,
	0x8e, 0x3f, 0x74, 0x64, 0x8f, 0xc0, 0x44, 0xb5, 0xa4, 0x74, 0x90, 0x2c, 0xaf, 0xbb, 0x92, 0x8a,
	0xff, 0x88, 0xc3, 0xc8, 0x82, 0x85, 0x15, 0x07, 0x37, 0x9d, 0x42, 0x04, 0x03, 0x16, 0x21, 0xa6,
	0x2b, 0x55, 0x66, 0xbb, 0xe4, 0xfc, 0x49, 0x02, 0xf5, 0xfd, 0x93, 0xc2, 0xd0, 0x1d, 0x65, 0xfc,
	0xd1, 0xdc, 0xf8, 0x07, 0x13, 0xe3, 0x33, 0xf2, 0xf8, 0xdd, 0x2c, 0xc3, 0x9b, 0x9e, 0x94, 0x28,
	0x2c, 0x7a, 0x13, 0x52, 0x2a, 0xb6, 0x4b, 0x96, 0x66, 0x92, 0x8c, 0xe7, 0x37, 0x66, 0xf1, 0xfc,
	0xb4, 0xe4, 0xdd, 0x45, 0x9f, 0x09, 0x10, 0xaf, 0x28, 0x9b, 0xb8, 0x62, 0xa7, 0x63, 0xd4, 0x20,
	0xd7, 0x02, 0x0d, 0xd2, 0x46, 0xa5, 0xdc, 0x0a, 0x25, 0xb1, 0xa8, 0x3b, 0xd6, 0xce, 0xfc, 0x5b,
	0xdf, 0x3f, 0x29, 0xa4, 0xee, 0x8c, 0xcb, 0x13, 0xe3, 0x33, 0xca, 0xf8, 0xa3, 0xbb, 0xd9, 0x4f,
	0x98, 0x78, 0x53, 0xae, 0x98, 0xbb, 0x4f, 0x0b, 0xf1, 0x8c, 0xfb, 0x17, 0x42, 0x87, 0x88, 0x32,
	0x77, 0x3d, 0xf0, 0x12, 0x17, 0x08, 0xdd, 0x81, 0x14, 0xd6, 0xb7, 0x35, 0xcb, 0xd0, 0xab, 0x58,
	0x77, 0xd2, 0x03, 0xa3, 0xc2, 0xd8, 0x50, 0x71, 0x32, 0xe4, 0x81, 0xe5, 0x16, 0x1b, 0xa8, 0xf3,
	0x31, 0x62, 0x38, 0xc9, 0x4b, 0x0d, 0xbd, 0x03, 0x29, 0x16, 0x36, 0xb2, 0x6d, 0xe2, 0x52, 0x3a,
	0x3e, 0x2a, 0x8c, 0xa5, 0x8a, 0xd9, 0x40, 0xe2, 0x14, 0x65, 0xc3, 0xc4, 0x25, 0x4e, 0x13, 0x4a,
	0xf5, 0x15, 0xf4, 0x3e, 0x0c, 0xb9, 0xd9, 0x9d, 0x12, 0xb5, 0xd3, 0x83, 0xd4, 0xa4, 0xe7, 0x82,
	0xa8, 0x5e, 0xe7, 0x58, 0x1e, 0xba, 0x07, 0x55, 0xcf, 0x9a, 0x8d, 0x56, 0x01, 0xc8, 0x4d, 0xc0,
	0xc9, 0x26, 0x28, 0xd9, 0xb1, 0x20, 0xb2, 0xb7, 0x6d, 0x6c, 0x79, 0x48, 0x26, 0x6b, 0xfc, 0x9b,
	0x92, 0x23, 0xc9, 0x82, 0x93, 0x4b, 0x86, 0x23, 0xf7, 0xb6, 0x61, 0x3b, 0x5e, 0x72, 0xf7, 0xf8,
	0xb7, 0x4d, 0xd2, 0x8a, 0x8e, 0x9d, 0x87, 0x86, 0x75, 0x9f, 0x78, 0x34, 0xb4, 0x4b, 0x2b, 0x7c,
	0x7f, 0x59, 0xcd, 0xcc, 0x40, 0xca, 0xe3, 0x2d, 0xe8, 0x10, 0xf4, 0xdf, 0xc7, 0x3b, 0x2c, 0x0c,
	0x24, 0xf2, 0x27, 0x1a, 0x81, 0x81, 0x6d, 0xa5, 0x52, 0xe3, 0x4e, 0x2f, 0xb1, 0x8f, 0xd9, 0xbe,
	0x8b, 0x82, 0x38, 0x0d, 0x47, 0x7c, 0xde, 0xb7, 0x8a, 0x1d, 0x85, 0xd8, 0x09, 0x9d, 0x68, 0xcd,
	0x6b, 0xde, 0x4c, 0xf6, 0xd3, 0x18, 0x8c, 0xdc, 0x36, 0xd5, 0xd6, 0x48, 0x8c, 0x92, 0x0f, 0xd1,
	0x25, 0x48, 0xd5, 0x28, 0x11, 0x5a, 0x10, 0x51, 0xe9, 0x52, 0xc5, 0x4c, 0x8e, 0x15, 0x34, 0x39,
	0xb7, 0xe0, 0xc9, 0x2d, 0x91, 0x9a, 0x69, 0x55, 0xb1, 0xef, 0x4b, 0xc0, 0xc0, 0xc9, 0xdf, 0xcf,
	0x3b, 0x28, 0xdb, 0x69, 0xf7, 0x7c, 0x82, 0xf2, 0x87, 0xfe, 0xb8, 0x19, 0x88, 0x1a, 0x37, 0xbe,
	0x88, 0xc9, 0xf1, 0xf4, 0x16, 0xa7, 0xe6, 0xc8, 0x04, 0xa5, 0xb6, 0x1e, 0x7d, 0xc7, 0x67, 0xa4,
	0xb0, 0xbe, 0xb3, 0x00, 0x23, 0xd7, 0x71, 0x05, 0xf7, 0xe4, 0x3a, 0x84, 0xb9, 0x8f, 0x48, 0x58,
	0xe6, 0xf3, 0x30, 0xbc, 0xe1, 0x28, 0x56, 0x4f, 0xd7, 0xf8, 0x79, 0x18, 0xf1, 0xd2, 0x08, 0xcb,
	0x7a, 0x0e, 0xd0, 0x86, 0x63, 0x98, 0xbd, 0x70, 0x9e, 0x22, 0xd2, 0xd7, 0x49, 0x84, 0x65, 0xfc,
	0xa9, 0x00, 0x68, 0xd5, 0xd8, 0xee, 0x29, 0x54, 0xaf, 0xc1, 0x11, 0x15, 0xdb, 0x8e, 0xa6, 0xd3,
	0xa2, 0x5f, 0x6e, 0xdc, 0xb6, 0x7d, 0x6d, 0xf0, 0x86, 0x3d, 0xa0, 0x4b, 0xfc, 0xe2, 0x15, 0x7f,
	0x29, 0xc0, 0xb0, 0x47, 0x8a, 0x90, 0xc2, 0xa3, 0x31, 0x38, 0x64, 0x1b, 0x35, 0xab, 0x84, 0x9b,
	0x79, 0x4a, 0x43, 0x6c, 0x7d, 0xa9, 0x71, 0xb3, 0x77, 0x10, 0x91, 0xa6, 0x86, 0xf6, 0x42, 0x2d,
	0xc0, 0xc8, 0x3c, 0x7d, 0x99, 0xf4, 0xe8, 0x8b, 0x3e, 0x22, 0x61, 0xcf, 0xe5, 0xb3, 0x38, 0x1c,
	0x91, 0xb0, 0xed, 0x18, 0x56, 0xf3, 0xd1, 0x9c, 0x82, 0x24, 0x7b, 0x30, 0x35, 0xb8, 0xb3, 0x2b,
	0x22, 0xc1, 0x96, 0x97, 0x55, 0x34, 0x05, 0x31, 0xf2, 0xd8, 0xeb, 0x98, 0x34, 0x6f, 0xb9, 0xcf,
	0x48, 0x8e, 0x49, 0xa1, 0xd1, 0x1b, 0x30, 0x44, 0xfe, 0x95, 0x35, 0x9d, 0x88, 0xa1, 0x6d, 0x63,
	0x6a, 0x9c, 0x84, 0x74, 0x90, 0xac, 0x2e, 0xbb, 0x8b, 0xf5, 0x22, 0x29, 0xd6, 0x7d, 0x91, 0x34,
	0xb0, 0x6f, 0x3e, 0xfe, 0xbc, 0x91, 0x8f, 0xe3, 0x34, 0x1f, 0xcf, 0x05, 0xe5, 0xbb, 0xb6, 0x86,
	0x7a, 0x3e, 0x09, 0xf9, 0xb6, 0xbf, 0x4a, 0x1a, 0xec, 0xba, 0x4a, 0xf2, 0xd7, 0x47, 0x4d, 0x79,
	0x3e, 0xd1, 0x53, 0x9e, 0x5f, 0xeb, 0xa9, 0xde, 0x88, 0x7f, 0xf2, 0xb4, 0xd0, 0x77, 0x75, 0xa2,
	0xdb, 0x8a, 0x03, 0xbd, 0xe1, 0xad, 0xb7, 0x53, 0x14, 0x36, 0xd1, 0x5a, 0x6b, 0xf7, 0x72, 0xb9,
	0xdc, 0x82, 0xa3, 0xfe, 0x13, 0x0f, 0x9b, 0x2f, 0x8e, 0x79, 0x43, 0x87, 0x91, 0xad, 0x07, 0x8d,
	0x68, 0xc1, 0x31, 0x6f, 0xe6, 0x5e, 0x52, 0xb4, 0x8a, 0xb1, 0xdd, 0x65, 0x46, 0x3c, 0x0d, 0xd4,
	0x7a, 0xb2, 0xe7, 0x35, 0x51, 0xf7, 0xf6, 0x49, 0x29, 0x41, 0xf6, 0x6e, 0x2a, 0x55, 0x2c, 0x5e,
	0x81, 0xe3, 0xed, 0x78, 0x86, 0x4d, 0x12, 0xdf, 0x08, 0x90, 0x5c, 0x31, 0xca, 0x12, 0x2e, 0x19,
	0x96, 0x8a, 0x2e, 0x42, 0xb2, 0xde, 0x1f, 0xa2, 0xb0, 0xfb, 0x86, 0xbe, 0xd4, 0x00, 0x46, 0xeb,
	0x30, 0x58, 0xc5, 0xb6, 0xad, 0x94, 0x89, 0xb0, 0xc4, 0x5b, 0xa6, 0x83, 0xbc, 0xa5, 0xce, 0x35,
	0xb7, 0xca, 0x10, 0xe9, 0x29, 0x4a, 0x2e, 0x99, 0xcc, 0x2c, 0x1c, 0xf0, 0x6e, 0x44, 0x3a, 0xde,
	0x5f, 0xc4, 0xe0, 0xa8, 0xe7, 0x3d, 0xb9, 0x62, 0x94, 0xed, 0xae, 0x0e, 0xe1, 0x07, 0x70, 0xb0,
	0x64, 0x54, 0x6a, 0x55, 0x5d, 0xe6, 0x4f, 0x58, 0xa2, 0x5b, 0x52, 0x3a, 0xc0, 0x16, 0x97, 0xe8,
	0x1a, 0xc2, 0x70, 0x80, 0xf7, 0xf4, 0x64, 0x67, 0xc7, 0x64, 0x29, 0x6f, 0xa8, 0x38, 0x1f, 0xa8,
	0x7f, 0x5b, 0xf9, 0x72, 0x1b, 0x8c, 0xd4, 0xad, 0x1d, 0x13, 0x4b, 0x29, 0xbb, 0xf1, 0x81, 0x2e,
	0x40, 0x72, 0xcb, 0x32, 0xaa, 0x32, 0x4d, 0xcb, 0xb1, 0xc0, 0xb3, 0x49, 0x10, 0x60, 0xf2, 0x89,
	0x26, 0x61, 0xd0, 0x31, 0x18, 0xda, 0x40, 0x20, 0x5a, 0xdc, 0x31, 0x28, 0x92, 0xaf, 0x11, 0x10,
	0x0f, 0xdd, 0x08, 0x18, 0xdc, 0xa7, 0x11, 0x30, 0x09, 0x47, 0x95, 0xca, 0x43, 0x65, 0xc7, 0x96,
	0x9b, 0x5f, 0xe3, 0x09, 0x7a, 0x49, 0x0c, 0xb3, 0xdd, 0x9b, 0xbe, 0x37, 0xf9, 0x0d, 0x48, 0x79,
	0x2c, 0x82, 0x8e, 0x43, 0x7a, 0x63, 0x51, 0x7a, 0x77, 0x79, 0x61, 0x51, 0xbe, 0xf5, 0xfe, 0xfa,
	0xa2, 0x7c, 0xfb, 0xe6, 0xc6, 0xfa, 0xe2, 0xc2, 0xf2, 0xd2, 0xf2, 0xe2, 0xf5, 0x43, 0x2f, 0xa1,
	0x21, 0x80, 0xf5, 0xb5, 0x8d, 0x5b, 0x37, 0xa4, 0xc5, 0x8d, 0x77, 0x56, 0x0e, 0x09, 0x08, 0x20,
	0xbe, 0xbe, 0xb6, 0xb6, 0xb2, 0x28, 0x1d, 0xea, 0x13, 0x3f, 0x16, 0xe0, 0x95, 0x16, 0x93, 0xf3,
	0x2e, 0xc3, 0x15, 0x88, 0x55, 0x8c, 0xb2, 0xdb, 0x61, 0x38, 0x1b, 0xda, 0x73, 0x25, 0x8a, 0x16,
	0xba, 0xbf, 0xf0, 0xf3, 0x7e, 0x48, 0x6f, 0x38, 0x16, 0x56, 0xaa, 0xff, 0x17, 0xbf, 0x2c, 0xb7,
	0xf5, 0xcb, 0xeb, 0x41, 0xda, 0x75, 0x92, 0xf0, 0x05, 0xf1, 0xcc, 0x67, 0xe7, 0x11, 0xbf, 0x13,
	0xe0, 0xb8, 0xc7, 0x23, 0xd6, 0xdc, 0x8e, 0x74, 0x77, 0x47, 0xf2, 0xec, 0x3b, 0x67, 0xe2, 0x63,
	0x01, 0x4e, 0x74, 0x10, 0x90, 0x3b, 0xee, 0x1c, 0x40, 0xbd, 0x91, 0xee, 0xba, 0xef, 0x29, 0xff,
	0x01, 0x37, 0x1a, 0xed, 0x75, 0x7c, 0xc9, 0x83, 0x14, 0xda, 0x79, 0x7f, 0x2b, 0xc0, 0xab, 0x1e,
	0x61, 0x58, 0x45, 0xfa, 0xc2, 0x98, 0xea, 0x67, 0x02, 0x64, 0xda, 0x49, 0xc7, 0xed, 0x74, 0x0d,
	0x06, 0xd9, 0x25, 0xed, 0x1a, 0xe9, 0x74, 0x50, 0x14, 0x30, 0x0a, 0x92, 0x8b, 0x16, 0xda, 0x4c,
	0x9f, 0xf9, 0xd3, 0x0c, 0x29, 0x89, 0x5e, 0x18, 0x23, 0xfd, 0x04, 0xd2, 0xad, 0xa2, 0x71, 0x0b,
	0xcd, 0xc2, 0x00, 0x29, 0x29, 0x5c, 0xfb, 0xbc, 0x1e, 0xa6, 0xd6, 0x93, 0x18, 0x4a, 0x68, 0xdb,
	0xfc, 0x5a, 0x80, 0xa3, 0x73, 0xaa, 0xda, 0xb3, 0x69, 0xfc, 0xc5, 0x69, 0x5f, 0xcf, 0xc5, 0xa9,
	0xf8, 0x1e, 0xbc, 0xd2, 0x24, 0x57, 0xd8, 0x72, 0xf0, 0x04, 0x17, 0x85, 0x54, 0x69, 0x36, 0xcf,
	0xc2, 0x49, 0xb7, 0x36, 0xb3, 0xc5, 0x0f, 0xe1, 0x55, 0x5f, 0x1b, 0xa1, 0x7b, 0x9d, 0x73, 0xad,
	0x8c, 0xe6, 0x5f, 0x66, 0x9a, 0x34, 0xaa, 0x42, 0x0f, 0xe7, 0x0f, 0x20, 0xd3, 0xca, 0xf9, 0x19,
	0x69, 0xf5, 0x7b, 0x01, 0x5e, 0xf5, 0xb5, 0x66, 0xba, 0x57, 0x6b, 0x13, 0x0e, 0xf3, 0x16, 0x5d,
	0xcb, 0x89, 0xe6, 0xc2, 0xb5, 0xd0, 0x5a, 0xce, 0xf5, 0xe5, 0x9a, 0x6f, 0x9d, 0x9a, 0xa2, 0x55,
	0xda, 0x67, 0x64, 0x8a, 0xff, 0x08, 0x30, 0xe4, 0x97, 0x83, 0x3c, 0xae, 0x1b, 0x85, 0xbb, 0xef,
	0x71, 0xed, 0xa2, 0xa1, 0x71, 0x40, 0x16, 0x36, 0x2b, 0x5a, 0x89, 0xb5, 0x12, 0x58, 0xa3, 0x81,
	0xc7, 0xcc, 0x61, 0xcf, 0xce, 0x06, 0xdd, 0x40, 0x17, 0x20, 0x61, 0x5a, 0x9a, 0x61, 0x69, 0xce,
	0x0e, 0x8d, 0xef, 0x54, 0xf1, 0x58, 0xcb, 0x3d, 0xb9, 0xac, 0x3b, 0xd3, 0x53, 0xef, 0x92, 0x02,
	0x58, 0xaa, 0x03, 0xa3, 0x35, 0xff, 0x93, 0x90, 0x5d, 0xcd, 0xb9, 0x70, 0x4f, 0x42, 0x57, 0x1f,
	0xef, 0xb3, 0x50, 0xfc, 0xa2, 0x0f, 0x12, 0x1e, 0x45, 0x07, 0x1f, 0x19, 0x3a, 0x6e, 0x9c, 0x72,
	0xe3, 0x8d, 0x16, 0x27, 0x1b, 0xec, 0x21, 0x67, 0xd7, 0x36, 0x75, 0xec, 0x34, 0x5a, 0x39, 0x9e,
	0x87, 0x1c, 0xdb, 0x62, 0x4d, 0x18, 0xc5, 0xb6, 0xb5, 0xb2, 0x2e, 0x9b, 0xb5, 0xcd, 0x8a, 0x56,
	0x92, 0x35, 0x93, 0x37, 0x0e, 0x86, 0xd8, 0xfa, 0x3a, 0x5d, 0x5e, 0x36, 0x3b, 0x58, 0x2e, 0x16,
	0xc6, 0x72, 0x03, 0x3d, 0x58, 0x2e, 0xde, 0xb3, 0xe5, 0xfe, 0x39, 0x08, 0xd0, 0x78, 0x6b, 0xa3,
	0x34, 0x0c, 0x6e, 0x63, 0xcb, 0xd6, 0x0c, 0x9d, 0xbb, 0x9c, 0xfb, 0x89, 0x0c, 0x38, 0xd2, 0x20,
	0x2a, 0x73, 0x21, 0x66, 0xe4, 0x69, 0xde, 0x89, 0x99, 0x0d, 0x92, 0x81, 0x61, 0xe4, 0xd6, 0xeb,
	0x8b, 0x8c, 0xeb, 0x8c, 0x3c, 0xfd, 0xf6, 0x4b, 0x12, 0x32, 0x9b, 0x97, 0xa7, 0x51, 0x0d, 0x5e,
	0x69, 0x65, 0x48, 0x07, 0xa0, 0xf4, 0x99, 0x9e, 0x2a, 0x5e, 0xee, 0x92, 0x25, 0xa1, 0xb1, 0xf0,
	0xf6, 0x4b, 0xd2, 0x88, 0xd9, 0xb2, 0x51, 0x28, 0xa1, 0x2a, 0x8c, 0xb4, 0x63, 0xcb, 0x1d, 0x7c,
	0xa6, 0x6b, 0x9e, 0xed, 0xb4, 0x2c, 0x4c, 0x74, 0x60, 0x57, 0xa0, 0x0f, 0x96, 0x1e, 0xd8, 0x15,
	0xda, 0xb2, 0x2b, 0x74, 0x60, 0x57, 0xa4, 0xcd, 0x8c, 0x1e, 0xd8, 0x15, 0xdb, 0xb2, 0x2b, 0xa2,
	0x3b, 0x70, 0xd0, 0x34, 0x8c, 0x0a, 0xb6, 0x38, 0x2b, 0x1e, 0xea, 0xd3, 0x21, 0x1c, 0x56, 0xc7,
	0x25, 0x12, 0x30, 0xeb, 0x14, 0x9d, 0x11, 0x94, 0x0e, 0x98, 0x9e, 0x2f, 0x74, 0x03, 0x92, 0x16,
	0x66, 0x91, 0x66, 0xf3, 0x28, 0x3a, 0x1b, 0xa2, 0x9d, 0xc6, 0x10, 0xa4, 0x06, 0x2e, 0xba, 0x0a,
	0x07, 0x94, 0x9a, 0x63, 0x6c, 0xf1, 0x16, 0x05, 0x8f, 0xaa, 0xd6, 0x9a, 0x7f, 0xde, 0x30, 0x2a,
	0x2c, 0x20, 0x7d, 0xf0, 0x68, 0x09, 0x86, 0x79, 0xef, 0xe5, 0xa1, 0xa6, 0xab, 0xc6, 0x43, 0xd9,
	0x76, 0x14, 0xcb, 0xe1, 0x9d, 0xae, 0xa3, 0x2e, 0x19, 0xf2, 0xd6, 0xa1, 0xcf, 0x86, 0xb5, 0xad,
	0xeb, 0xca, 0x8e, 0x74, 0x98, 0xa1, 0xbc, 0x47, 0x31, 0x68, 0xa7, 0x04, 0x5d, 0x85, 0xb8, 0x52,
	0x2a, 0x61, 0xdb, 0x4e, 0x27, 0x29, 0x6a, 0x60, 0x31, 0x38, 0x47, 0xa1, 0x25, 0x8e, 0x35, 0x3f,
	0x0c, 0x87, 0x5b, 0x0e, 0x57, 0xfc, 0x2e, 0x06, 0x43, 0xfe, 0xf8, 0x47, 0x76, 0xa7, 0x50, 0x66,
	0x9d, 0x95, 0xab, 0x91, 0xbd, 0x80, 0x50, 0x0e, 0x0a, 0xe7, 0x9d, 0xce, 0xe1, 0xcc, 0x9c, 0xe2,
	0x5a, 0x0f, 0x6c, 0xf7, 0x0f, 0xe9, 0x07, 0x1d, 0x42, 0x9a, 0x65, 0xae, 0x2b, 0x3d, 0xf1, 0xed,
	0x10, 0xd6, 0x0f, 0x3a, 0x84, 0x75, 0x7f, 0xef, 0x2c, 0x3b, 0x85, 0xf6, 0x83, 0x0e, 0xa1, 0x3d,
	0xd0, 0x3b, 0xcb, 0x0e, 0xe1, 0xdd, 0xd6, 0xe1, 0x8a, 0x7f, 0x3e, 0x01, 0x43, 0xbc, 0xa2, 0xe1,
	0xef, 0x61, 0xf4, 0x1b, 0x01, 0xfa, 0x6f, 0x60, 0x07, 0x15, 0x82, 0x84, 0x68, 0xf9, 0xa1, 0x49,
	0x26, 0xec, 0xcf, 0x2a, 0xc4, 0xa9, 0x4f, 0xbe, 0xf9, 0xf6, 0x57, 0x7d, 0x39, 0x74, 0x2e, 0x5f,
	0x55, 0x74, 0xa5, 0x8c, 0xd5, 0xf1, 0xb6, 0x3f, 0xae, 0xb2, 0xf3, 0x3f, 0x6e, 0x94, 0x55, 0x1f,
	0xa1, 0xcf, 0x05, 0x88, 0x91, 0xb7, 0x07, 0x9a, 0x8c, 0xd0, 0x16, 0x73, 0x4b, 0xca, 0xcc, 0x54,
	0x34, 0x24, 0xf6, 0xa4, 0x11, 0xcf, 0x50, 0x49, 0x4f, 0xa1, 0xd7, 0x02, 0x24, 0x45, 0x7f, 0x10,
	0x20, 0xce, 0xc6, 0xd4, 0x68, 0xaa, 0x9b, 0x1f, 0x53, 0x64, 0x82, 0x9f, 0xdc, 0xe2, 0xcd, 0xdd,
	0xbd, 0xec, 0x68, 0xa7, 0x69, 0xf8, 0x20, 0x5f, 0xa0, 0x02, 0xbf, 0x2e, 0x06, 0x09, 0x3c, 0x2b,
	0x64, 0xd1, 0x57, 0x02, 0xc4, 0x59, 0xe1, 0x19, 0x2c, 0x73, 0xbb, 0x59, 0x73, 0x18, 0x99, 0xef,
	0x30, 0x99, 0xdb, 0x4f, 0x61, 0x7d, 0x32, 0x17, 0x8a, 0x91, 0xdc, 0x81, 0x28, 0xf0, 0x37, 0x01,
	0xe2, 0xec, 0x85, 0x12, 0xac, 0x40, 0xbb, 0x79, 0x6e, 0x18, 0x05, 0xb6, 0x76, 0xf7, 0xb2, 0xb9,
	0x4e, 0x93, 0xdc, 0x23, 0xcd, 0xd7, 0xce, 0x62, 0xd5, 0x74, 0x76, 0x98, 0x77, 0x67, 0xa3, 0x79,
	0xf7, 0x57, 0x02, 0x0c, 0xb0, 0xab, 0x65, 0x32, 0xb8, 0xbb, 0xd6, 0x32, 0x1d, 0x0e, 0xa3, 0xc9,
	0xdd, 0xdd, 0xbd, 0xec, 0x6b, 0x1d, 0xe6, 0xc2, 0xbe, 0x93, 0x98, 0x12, 0x8b, 0x91, 0x4e, 0x82,
	0x5e, 0xa1, 0xe8, 0x4b, 0x01, 0x62, 0x1b, 0x8e, 0x61, 0xa2, 0x62, 0xb0, 0xfc, 0xcd, 0x23, 0xe6,
	0xb0, 0x9e, 0x74, 0xb2, 0xfd, 0x70, 0xd9, 0x27, 0xfd, 0xa4, 0x58, 0x88, 0x28, 0xbd, 0x61, 0xa2,
	0xbf, 0x0a, 0x10, 0x5b, 0x35, 0xb6, 0x71, 0xb0, 0xf0, 0xad, 0x53, 0xea, 0x30, 0xc2, 0xff, 0x88,
	0x09, 0xdf, 0x6e, 0xb8, 0xec, 0x13, 0x7e, 0x3a, 0xa2, 0xf0, 0x55, 0x63, 0x1b, 0x93, 0x48, 0xf8,
	0x5a, 0x80, 0x38, 0x6b, 0x37, 0x05, 0x47, 0x42, 0xbb, 0x69, 0x72, 0x18, 0x1d, 0x64, 0x16, 0xca,
	0xed, 0xe7, 0xc8, 0x3e, 0x2d, 0xce, 0x8b, 0x93, 0x91, 0xb4, 0x60, 0xe5, 0x15, 0xfa, 0x8b, 0x00,
	0x83, 0x7c, 0xa2, 0x86, 0xce, 0x77, 0x35, 0x6c, 0x0d, 0xa3, 0xc6, 0x7b, 0xbb, 0x7b, 0xd9, 0x53,
	0x1d, 0x47, 0x77, 0x3e, 0x3d, 0xce, 0x89, 0x67, 0x82, 0xd2, 0xa8, 0xc5, 0xc8, 0x90, 0x33, 0xf8,
	0x97, 0x00, 0x07, 0x69, 0x70, 0xb9, 0xf3, 0x33, 0x74, 0x29, 0x4a, 0x24, 0x37, 0x4d, 0xfa, 0xc2,
	0xa8, 0x62, 0xee, 0xee, 0x65, 0xcf, 0x04, 0xcc, 0xee, 0x7c, 0x0a, 0xbd, 0x25, 0xce, 0x46, 0x8f,
	0x6c, 0x97, 0x24, 0xd1, 0xf1, 0x4f, 0x02, 0x24, 0xc8, 0x45, 0xb9, 0x62, 0x94, 0x6d, 0x34, 0xdd,
	0xdd, 0x78, 0x2a, 0x73, 0x21, 0x32, 0x1e, 0xbf, 0x8d, 0x67, 0x58, 0x80, 0xa3, 0x68, 0x31, 0x42,
	0xe7, 0x2b, 0x7f, 0x14, 0x00, 0xd8, 0x54, 0x82, 0x8a, 0x7e, 0xb1, 0xdb, 0x09, 0x46, 0x26, 0xfc,
	0x64, 0x47, 0xbc, 0x46, 0xc5, 0x9d, 0x45, 0x17, 0x23, 0xda, 0x9c, 0x70, 0x96, 0x89, 0xd4, 0x13,
	0x02, 0xfa, 0xbb, 0x00, 0x43, 0xc4, 0x1c, 0x8d, 0xc6, 0x3d, 0xba, 0x1c, 0xc1, 0x7c, 0x2d, 0x03,
	0x89, 0xcc, 0x95, 0x2e, 0xb1, 0xf9, 0x11, 0xbc, 0x45, 0x75, 0x9a, 0x41, 0x17, 0xa2, 0xe8, 0x94,
	0xf7, 0xcc, 0x0a, 0xbe, 0x16, 0x20, 0x45, 0x58, 0xf0, 0xf6, 0x3a, 0x9a, 0x89, 0x20, 0x8f, 0x7f,
	0x60, 0x90, 0x99, 0xed, 0x06, 0x95, 0xeb, 0x71, 0x99, 0xa5, 0x5b, 0x34, 0x15, 0x49, 0x0f, 0xb7,
	0x93, 0xff, 0xa5, 0x00, 0x49, 0x42, 0x9c, 0xb6, 0x01, 0x51, 0x14, 0x7f, 0xf6, 0xb6, 0x39, 0x33,
	0x17, 0xa3, 0x23, 0x72, 0xf1, 0x67, 0xd9, 0x45, 0x8d, 0x22, 0x5d, 0xd4, 0x79, 0xd6, 0x6a, 0xff,
	0x56, 0x80, 0xc4, 0x9c, 0xaa, 0x32, 0xd9, 0x03, 0x63, 0xb8, 0x7d, 0xb3, 0x3d, 0x4c, 0x76, 0xfa,
	0x68, 0x77, 0x2f, 0x3b, 0xd1, 0xb9, 0x2b, 0xbe, 0x4f, 0xed, 0xb4, 0x20, 0x5e, 0x8d, 0xae, 0xd7,
	0xec, 0xa6, 0xe2, 0x94, 0xee, 0xb1, 0xe2, 0x98, 0xa4, 0xaa, 0xef, 0x04, 0x48, 0xb1, 0xaa, 0x8d,
	0x69, 0x3a, 0x13, 0xa9, 0x42, 0x8c, 0xaa, 0xec, 0xc7, 0xc2, 0xee, 0x5e, 0x76, 0x72, 0xdf, 0x86,
	0xf9, 0xf3, 0x51, 0x98, 0x31, 0x74, 0x15, 0x6e, 0xf4, 0x91, 0x43, 0x28, 0xdc, 0xb1, 0xff, 0x1e,
	0x45, 0xe1, 0x7d, 0xda, 0xe2, 0xcf, 0x47, 0x61, 0xc6, 0x70, 0x56, 0xc8, 0xce, 0xdb, 0x20, 0xfa,
	0xc4, 0x54, 0x4c, 0xad, 0x55, 0xcb, 0x0f, 0x56, 0xcb, 0x9a, 0x73, 0xaf, 0xb6, 0x99, 0x2b, 0x19,
	0xd5, 0x3c, 0x03, 0x1f, 0x67, 0xff, 0xa5, 0xa2, 0x6c, 0x8c, 0x97, 0xb1, 0x4e, 0x85, 0xcb, 0xef,
	0xff, 0x7f, 0x2d, 0x2e, 0x35, 0xbe, 0x36, 0xe3, 0x14, 0x61, 0xf2, 0x7f, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x0c, 0x8c, 0xb1, 0xff, 0xab, 0x35, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClusterServiceClient is the client API for ClusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ClusterServiceClient interface {
	// Returns the specified PostgreSQL Cluster resource.
	//
	// To get the list of available PostgreSQL Cluster resources, make a [List] request.
	Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Retrieves the list of PostgreSQL Cluster resources that belong
	// to the specified folder.
	List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Creates a PostgreSQL cluster in the specified folder.
	Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified PostgreSQL cluster.
	Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified PostgreSQL cluster.
	Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Start the specified PostgreSQL cluster.
	Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Stop the specified PostgreSQL cluster.
	Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Moves the specified PostgreSQL cluster to the specified folder.
	Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a backup for the specified PostgreSQL cluster.
	Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates a new PostgreSQL cluster using the specified backup.
	Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Start a manual failover on the specified PostgreSQL cluster.
	StartFailover(ctx context.Context, in *StartClusterFailoverRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves logs for the specified PostgreSQL cluster.
	ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error)
	// Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics.
	StreamLogs(ctx context.Context, in *StreamClusterLogsRequest, opts ...grpc.CallOption) (ClusterService_StreamLogsClient, error)
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified PostgreSQL cluster.
	ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified hosts.
	UpdateHosts(ctx context.Context, in *UpdateClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type clusterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClusterServiceClient(cc grpc.ClientConnInterface) ClusterServiceClient {
	return &clusterServiceClient{cc}
}

func (c *clusterServiceClient) Get(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) List(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Create(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Update(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Delete(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Start(ctx context.Context, in *StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Start", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Stop(ctx context.Context, in *StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Move(ctx context.Context, in *MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Move", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Backup(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Backup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) Restore(ctx context.Context, in *RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/Restore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) StartFailover(ctx context.Context, in *StartClusterFailoverRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/StartFailover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListLogs(ctx context.Context, in *ListClusterLogsRequest, opts ...grpc.CallOption) (*ListClusterLogsResponse, error) {
	out := new(ListClusterLogsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) StreamLogs(ctx context.Context, in *StreamClusterLogsRequest, opts ...grpc.CallOption) (ClusterService_StreamLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ClusterService_serviceDesc.Streams[0], "/yandex.cloud.mdb.postgresql.v1.ClusterService/StreamLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterServiceStreamLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ClusterService_StreamLogsClient interface {
	Recv() (*LogRecord, error)
	grpc.ClientStream
}

type clusterServiceStreamLogsClient struct {
	grpc.ClientStream
}

func (x *clusterServiceStreamLogsClient) Recv() (*LogRecord, error) {
	m := new(LogRecord)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterServiceClient) ListOperations(ctx context.Context, in *ListClusterOperationsRequest, opts ...grpc.CallOption) (*ListClusterOperationsResponse, error) {
	out := new(ListClusterOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListBackups(ctx context.Context, in *ListClusterBackupsRequest, opts ...grpc.CallOption) (*ListClusterBackupsResponse, error) {
	out := new(ListClusterBackupsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) ListHosts(ctx context.Context, in *ListClusterHostsRequest, opts ...grpc.CallOption) (*ListClusterHostsResponse, error) {
	out := new(ListClusterHostsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) AddHosts(ctx context.Context, in *AddClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/AddHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) DeleteHosts(ctx context.Context, in *DeleteClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/DeleteHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterServiceClient) UpdateHosts(ctx context.Context, in *UpdateClusterHostsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.mdb.postgresql.v1.ClusterService/UpdateHosts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClusterServiceServer is the server API for ClusterService service.
type ClusterServiceServer interface {
	// Returns the specified PostgreSQL Cluster resource.
	//
	// To get the list of available PostgreSQL Cluster resources, make a [List] request.
	Get(context.Context, *GetClusterRequest) (*Cluster, error)
	// Retrieves the list of PostgreSQL Cluster resources that belong
	// to the specified folder.
	List(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Creates a PostgreSQL cluster in the specified folder.
	Create(context.Context, *CreateClusterRequest) (*operation.Operation, error)
	// Updates the specified PostgreSQL cluster.
	Update(context.Context, *UpdateClusterRequest) (*operation.Operation, error)
	// Deletes the specified PostgreSQL cluster.
	Delete(context.Context, *DeleteClusterRequest) (*operation.Operation, error)
	// Start the specified PostgreSQL cluster.
	Start(context.Context, *StartClusterRequest) (*operation.Operation, error)
	// Stop the specified PostgreSQL cluster.
	Stop(context.Context, *StopClusterRequest) (*operation.Operation, error)
	// Moves the specified PostgreSQL cluster to the specified folder.
	Move(context.Context, *MoveClusterRequest) (*operation.Operation, error)
	// Creates a backup for the specified PostgreSQL cluster.
	Backup(context.Context, *BackupClusterRequest) (*operation.Operation, error)
	// Creates a new PostgreSQL cluster using the specified backup.
	Restore(context.Context, *RestoreClusterRequest) (*operation.Operation, error)
	// Start a manual failover on the specified PostgreSQL cluster.
	StartFailover(context.Context, *StartClusterFailoverRequest) (*operation.Operation, error)
	// Retrieves logs for the specified PostgreSQL cluster.
	ListLogs(context.Context, *ListClusterLogsRequest) (*ListClusterLogsResponse, error)
	// Same as ListLogs but using server-side streaming. Also allows for 'tail -f' semantics.
	StreamLogs(*StreamClusterLogsRequest, ClusterService_StreamLogsServer) error
	// Retrieves the list of Operation resources for the specified cluster.
	ListOperations(context.Context, *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error)
	// Retrieves the list of available backups for the specified PostgreSQL cluster.
	ListBackups(context.Context, *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error)
	// Retrieves a list of hosts for the specified cluster.
	ListHosts(context.Context, *ListClusterHostsRequest) (*ListClusterHostsResponse, error)
	// Creates new hosts for a cluster.
	AddHosts(context.Context, *AddClusterHostsRequest) (*operation.Operation, error)
	// Deletes the specified hosts for a cluster.
	DeleteHosts(context.Context, *DeleteClusterHostsRequest) (*operation.Operation, error)
	// Updates the specified hosts.
	UpdateHosts(context.Context, *UpdateClusterHostsRequest) (*operation.Operation, error)
}

// UnimplementedClusterServiceServer can be embedded to have forward compatible implementations.
type UnimplementedClusterServiceServer struct {
}

func (*UnimplementedClusterServiceServer) Get(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedClusterServiceServer) List(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedClusterServiceServer) Create(ctx context.Context, req *CreateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedClusterServiceServer) Update(ctx context.Context, req *UpdateClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedClusterServiceServer) Delete(ctx context.Context, req *DeleteClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedClusterServiceServer) Start(ctx context.Context, req *StartClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (*UnimplementedClusterServiceServer) Stop(ctx context.Context, req *StopClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}
func (*UnimplementedClusterServiceServer) Move(ctx context.Context, req *MoveClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (*UnimplementedClusterServiceServer) Backup(ctx context.Context, req *BackupClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Backup not implemented")
}
func (*UnimplementedClusterServiceServer) Restore(ctx context.Context, req *RestoreClusterRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Restore not implemented")
}
func (*UnimplementedClusterServiceServer) StartFailover(ctx context.Context, req *StartClusterFailoverRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartFailover not implemented")
}
func (*UnimplementedClusterServiceServer) ListLogs(ctx context.Context, req *ListClusterLogsRequest) (*ListClusterLogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLogs not implemented")
}
func (*UnimplementedClusterServiceServer) StreamLogs(req *StreamClusterLogsRequest, srv ClusterService_StreamLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamLogs not implemented")
}
func (*UnimplementedClusterServiceServer) ListOperations(ctx context.Context, req *ListClusterOperationsRequest) (*ListClusterOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedClusterServiceServer) ListBackups(ctx context.Context, req *ListClusterBackupsRequest) (*ListClusterBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedClusterServiceServer) ListHosts(ctx context.Context, req *ListClusterHostsRequest) (*ListClusterHostsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHosts not implemented")
}
func (*UnimplementedClusterServiceServer) AddHosts(ctx context.Context, req *AddClusterHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddHosts not implemented")
}
func (*UnimplementedClusterServiceServer) DeleteHosts(ctx context.Context, req *DeleteClusterHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHosts not implemented")
}
func (*UnimplementedClusterServiceServer) UpdateHosts(ctx context.Context, req *UpdateClusterHostsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHosts not implemented")
}

func RegisterClusterServiceServer(s *grpc.Server, srv ClusterServiceServer) {
	s.RegisterService(&_ClusterService_serviceDesc, srv)
}

func _ClusterService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Get(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).List(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Create(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Update(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Delete(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Start(ctx, req.(*StartClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Stop(ctx, req.(*StopClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Move",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Move(ctx, req.(*MoveClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Backup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Backup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Backup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Backup(ctx, req.(*BackupClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).Restore(ctx, req.(*RestoreClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_StartFailover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartClusterFailoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).StartFailover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/StartFailover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).StartFailover(ctx, req.(*StartClusterFailoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListLogs(ctx, req.(*ListClusterLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_StreamLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamClusterLogsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ClusterServiceServer).StreamLogs(m, &clusterServiceStreamLogsServer{stream})
}

type ClusterService_StreamLogsServer interface {
	Send(*LogRecord) error
	grpc.ServerStream
}

type clusterServiceStreamLogsServer struct {
	grpc.ServerStream
}

func (x *clusterServiceStreamLogsServer) Send(m *LogRecord) error {
	return x.ServerStream.SendMsg(m)
}

func _ClusterService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListOperations(ctx, req.(*ListClusterOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListBackups(ctx, req.(*ListClusterBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_ListHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).ListHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/ListHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).ListHosts(ctx, req.(*ListClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_AddHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).AddHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/AddHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).AddHosts(ctx, req.(*AddClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_DeleteHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/DeleteHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).DeleteHosts(ctx, req.(*DeleteClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterService_UpdateHosts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterHostsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterServiceServer).UpdateHosts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.mdb.postgresql.v1.ClusterService/UpdateHosts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterServiceServer).UpdateHosts(ctx, req.(*UpdateClusterHostsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.mdb.postgresql.v1.ClusterService",
	HandlerType: (*ClusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ClusterService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ClusterService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ClusterService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ClusterService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ClusterService_Delete_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _ClusterService_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _ClusterService_Stop_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _ClusterService_Move_Handler,
		},
		{
			MethodName: "Backup",
			Handler:    _ClusterService_Backup_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _ClusterService_Restore_Handler,
		},
		{
			MethodName: "StartFailover",
			Handler:    _ClusterService_StartFailover_Handler,
		},
		{
			MethodName: "ListLogs",
			Handler:    _ClusterService_ListLogs_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterService_ListOperations_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _ClusterService_ListBackups_Handler,
		},
		{
			MethodName: "ListHosts",
			Handler:    _ClusterService_ListHosts_Handler,
		},
		{
			MethodName: "AddHosts",
			Handler:    _ClusterService_AddHosts_Handler,
		},
		{
			MethodName: "DeleteHosts",
			Handler:    _ClusterService_DeleteHosts_Handler,
		},
		{
			MethodName: "UpdateHosts",
			Handler:    _ClusterService_UpdateHosts_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamLogs",
			Handler:       _ClusterService_StreamLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "yandex/cloud/mdb/postgresql/v1/cluster_service.proto",
}
