// Code generated by protoc-gen-go. DO NOT EDIT.
// source: yandex/cloud/vpc/v1/network_service.proto

package vpc

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetNetworkRequest struct {
	// ID of the Network resource to return.
	// To get the network ID, use a [NetworkService.List] request.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNetworkRequest) Reset()         { *m = GetNetworkRequest{} }
func (m *GetNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*GetNetworkRequest) ProtoMessage()    {}
func (*GetNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{0}
}

func (m *GetNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNetworkRequest.Unmarshal(m, b)
}
func (m *GetNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNetworkRequest.Marshal(b, m, deterministic)
}
func (m *GetNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNetworkRequest.Merge(m, src)
}
func (m *GetNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_GetNetworkRequest.Size(m)
}
func (m *GetNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNetworkRequest proto.InternalMessageInfo

func (m *GetNetworkRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type ListNetworksRequest struct {
	// ID of the folder to list networks in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListNetworksResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListNetworksResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Network.name] field.
	// 2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
	// 3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]$`.
	Filter               string   `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworksRequest) Reset()         { *m = ListNetworksRequest{} }
func (m *ListNetworksRequest) String() string { return proto.CompactTextString(m) }
func (*ListNetworksRequest) ProtoMessage()    {}
func (*ListNetworksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{1}
}

func (m *ListNetworksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworksRequest.Unmarshal(m, b)
}
func (m *ListNetworksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworksRequest.Marshal(b, m, deterministic)
}
func (m *ListNetworksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworksRequest.Merge(m, src)
}
func (m *ListNetworksRequest) XXX_Size() int {
	return xxx_messageInfo_ListNetworksRequest.Size(m)
}
func (m *ListNetworksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworksRequest proto.InternalMessageInfo

func (m *ListNetworksRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *ListNetworksRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNetworksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListNetworksRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

type ListNetworksResponse struct {
	// List of Network resources.
	Networks []*Network `protobuf:"bytes,1,rep,name=networks,proto3" json:"networks,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNetworksRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListNetworksRequest.page_token] query parameter
	// in the next list request. Subsequent list requests will have their own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworksResponse) Reset()         { *m = ListNetworksResponse{} }
func (m *ListNetworksResponse) String() string { return proto.CompactTextString(m) }
func (*ListNetworksResponse) ProtoMessage()    {}
func (*ListNetworksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{2}
}

func (m *ListNetworksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworksResponse.Unmarshal(m, b)
}
func (m *ListNetworksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworksResponse.Marshal(b, m, deterministic)
}
func (m *ListNetworksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworksResponse.Merge(m, src)
}
func (m *ListNetworksResponse) XXX_Size() int {
	return xxx_messageInfo_ListNetworksResponse.Size(m)
}
func (m *ListNetworksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworksResponse proto.InternalMessageInfo

func (m *ListNetworksResponse) GetNetworks() []*Network {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *ListNetworksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateNetworkRequest struct {
	// ID of the folder for this request to create a network in.
	// To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the network.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the network.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateNetworkRequest) Reset()         { *m = CreateNetworkRequest{} }
func (m *CreateNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNetworkRequest) ProtoMessage()    {}
func (*CreateNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{3}
}

func (m *CreateNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNetworkRequest.Unmarshal(m, b)
}
func (m *CreateNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNetworkRequest.Marshal(b, m, deterministic)
}
func (m *CreateNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNetworkRequest.Merge(m, src)
}
func (m *CreateNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNetworkRequest.Size(m)
}
func (m *CreateNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNetworkRequest proto.InternalMessageInfo

func (m *CreateNetworkRequest) GetFolderId() string {
	if m != nil {
		return m.FolderId
	}
	return ""
}

func (m *CreateNetworkRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateNetworkRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CreateNetworkRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type CreateNetworkMetadata struct {
	// ID of the Network that is being created.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateNetworkMetadata) Reset()         { *m = CreateNetworkMetadata{} }
func (m *CreateNetworkMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateNetworkMetadata) ProtoMessage()    {}
func (*CreateNetworkMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{4}
}

func (m *CreateNetworkMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNetworkMetadata.Unmarshal(m, b)
}
func (m *CreateNetworkMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNetworkMetadata.Marshal(b, m, deterministic)
}
func (m *CreateNetworkMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNetworkMetadata.Merge(m, src)
}
func (m *CreateNetworkMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateNetworkMetadata.Size(m)
}
func (m *CreateNetworkMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNetworkMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNetworkMetadata proto.InternalMessageInfo

func (m *CreateNetworkMetadata) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type UpdateNetworkRequest struct {
	// ID of the Network resource to update.
	// To get the network ID use a [NetworkService.List] request.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Field mask that specifies which fields of the Network resource are going to be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the network.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the network.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `` key:value `` pairs.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateNetworkRequest) Reset()         { *m = UpdateNetworkRequest{} }
func (m *UpdateNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNetworkRequest) ProtoMessage()    {}
func (*UpdateNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{5}
}

func (m *UpdateNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNetworkRequest.Unmarshal(m, b)
}
func (m *UpdateNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNetworkRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNetworkRequest.Merge(m, src)
}
func (m *UpdateNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNetworkRequest.Size(m)
}
func (m *UpdateNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNetworkRequest proto.InternalMessageInfo

func (m *UpdateNetworkRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *UpdateNetworkRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateNetworkRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateNetworkRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UpdateNetworkRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type UpdateNetworkMetadata struct {
	// ID of the Network resource that is being updated.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateNetworkMetadata) Reset()         { *m = UpdateNetworkMetadata{} }
func (m *UpdateNetworkMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateNetworkMetadata) ProtoMessage()    {}
func (*UpdateNetworkMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{6}
}

func (m *UpdateNetworkMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNetworkMetadata.Unmarshal(m, b)
}
func (m *UpdateNetworkMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNetworkMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateNetworkMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNetworkMetadata.Merge(m, src)
}
func (m *UpdateNetworkMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateNetworkMetadata.Size(m)
}
func (m *UpdateNetworkMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNetworkMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNetworkMetadata proto.InternalMessageInfo

func (m *UpdateNetworkMetadata) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type DeleteNetworkRequest struct {
	// ID of the Network resource to update.
	// To get the network ID, use a [NetworkService.List] request.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNetworkRequest) Reset()         { *m = DeleteNetworkRequest{} }
func (m *DeleteNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNetworkRequest) ProtoMessage()    {}
func (*DeleteNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{7}
}

func (m *DeleteNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNetworkRequest.Unmarshal(m, b)
}
func (m *DeleteNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNetworkRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNetworkRequest.Merge(m, src)
}
func (m *DeleteNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNetworkRequest.Size(m)
}
func (m *DeleteNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNetworkRequest proto.InternalMessageInfo

func (m *DeleteNetworkRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type DeleteNetworkMetadata struct {
	// ID of the network that is being deleted.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNetworkMetadata) Reset()         { *m = DeleteNetworkMetadata{} }
func (m *DeleteNetworkMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteNetworkMetadata) ProtoMessage()    {}
func (*DeleteNetworkMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{8}
}

func (m *DeleteNetworkMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNetworkMetadata.Unmarshal(m, b)
}
func (m *DeleteNetworkMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNetworkMetadata.Marshal(b, m, deterministic)
}
func (m *DeleteNetworkMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNetworkMetadata.Merge(m, src)
}
func (m *DeleteNetworkMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteNetworkMetadata.Size(m)
}
func (m *DeleteNetworkMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNetworkMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNetworkMetadata proto.InternalMessageInfo

func (m *DeleteNetworkMetadata) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

type ListNetworkSubnetsRequest struct {
	// ID of the Network resource to list subnets for.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListNetworkSubnetsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListNetworkSubnetsResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkSubnetsRequest) Reset()         { *m = ListNetworkSubnetsRequest{} }
func (m *ListNetworkSubnetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNetworkSubnetsRequest) ProtoMessage()    {}
func (*ListNetworkSubnetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{9}
}

func (m *ListNetworkSubnetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkSubnetsRequest.Unmarshal(m, b)
}
func (m *ListNetworkSubnetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkSubnetsRequest.Marshal(b, m, deterministic)
}
func (m *ListNetworkSubnetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkSubnetsRequest.Merge(m, src)
}
func (m *ListNetworkSubnetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNetworkSubnetsRequest.Size(m)
}
func (m *ListNetworkSubnetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkSubnetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkSubnetsRequest proto.InternalMessageInfo

func (m *ListNetworkSubnetsRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *ListNetworkSubnetsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNetworkSubnetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListNetworkSubnetsResponse struct {
	// List of subnets that belong to the network which is specified in the request.
	Subnets []*Subnet `protobuf:"bytes,1,rep,name=subnets,proto3" json:"subnets,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNetworkSubnetsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListNetworkSubnetsRequest.page_token] query parameter
	// in the next list request. Subsequent list requests will have their own
	// [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkSubnetsResponse) Reset()         { *m = ListNetworkSubnetsResponse{} }
func (m *ListNetworkSubnetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNetworkSubnetsResponse) ProtoMessage()    {}
func (*ListNetworkSubnetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{10}
}

func (m *ListNetworkSubnetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkSubnetsResponse.Unmarshal(m, b)
}
func (m *ListNetworkSubnetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkSubnetsResponse.Marshal(b, m, deterministic)
}
func (m *ListNetworkSubnetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkSubnetsResponse.Merge(m, src)
}
func (m *ListNetworkSubnetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNetworkSubnetsResponse.Size(m)
}
func (m *ListNetworkSubnetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkSubnetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkSubnetsResponse proto.InternalMessageInfo

func (m *ListNetworkSubnetsResponse) GetSubnets() []*Subnet {
	if m != nil {
		return m.Subnets
	}
	return nil
}

func (m *ListNetworkSubnetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type ListNetworkOperationsRequest struct {
	// ID of the Network resource to list operations for.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than [page_size], the service returns a [ListNetworkOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set [page_token] to the
	// [ListNetworkOperationsResponse.next_page_token] returned by a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkOperationsRequest) Reset()         { *m = ListNetworkOperationsRequest{} }
func (m *ListNetworkOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNetworkOperationsRequest) ProtoMessage()    {}
func (*ListNetworkOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{11}
}

func (m *ListNetworkOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkOperationsRequest.Unmarshal(m, b)
}
func (m *ListNetworkOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkOperationsRequest.Marshal(b, m, deterministic)
}
func (m *ListNetworkOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkOperationsRequest.Merge(m, src)
}
func (m *ListNetworkOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNetworkOperationsRequest.Size(m)
}
func (m *ListNetworkOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkOperationsRequest proto.InternalMessageInfo

func (m *ListNetworkOperationsRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *ListNetworkOperationsRequest) GetPageSize() int64 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNetworkOperationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListNetworkOperationsResponse struct {
	// List of operations for the specified network.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListNetworkOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListNetworkOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNetworkOperationsResponse) Reset()         { *m = ListNetworkOperationsResponse{} }
func (m *ListNetworkOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNetworkOperationsResponse) ProtoMessage()    {}
func (*ListNetworkOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{12}
}

func (m *ListNetworkOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNetworkOperationsResponse.Unmarshal(m, b)
}
func (m *ListNetworkOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNetworkOperationsResponse.Marshal(b, m, deterministic)
}
func (m *ListNetworkOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNetworkOperationsResponse.Merge(m, src)
}
func (m *ListNetworkOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNetworkOperationsResponse.Size(m)
}
func (m *ListNetworkOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNetworkOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNetworkOperationsResponse proto.InternalMessageInfo

func (m *ListNetworkOperationsResponse) GetOperations() []*operation.Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListNetworkOperationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type MoveNetworkRequest struct {
	// ID of the Network resource to move.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// ID of the destination folder.
	DestinationFolderId  string   `protobuf:"bytes,2,opt,name=destination_folder_id,json=destinationFolderId,proto3" json:"destination_folder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveNetworkRequest) Reset()         { *m = MoveNetworkRequest{} }
func (m *MoveNetworkRequest) String() string { return proto.CompactTextString(m) }
func (*MoveNetworkRequest) ProtoMessage()    {}
func (*MoveNetworkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{13}
}

func (m *MoveNetworkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveNetworkRequest.Unmarshal(m, b)
}
func (m *MoveNetworkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveNetworkRequest.Marshal(b, m, deterministic)
}
func (m *MoveNetworkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveNetworkRequest.Merge(m, src)
}
func (m *MoveNetworkRequest) XXX_Size() int {
	return xxx_messageInfo_MoveNetworkRequest.Size(m)
}
func (m *MoveNetworkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveNetworkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveNetworkRequest proto.InternalMessageInfo

func (m *MoveNetworkRequest) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *MoveNetworkRequest) GetDestinationFolderId() string {
	if m != nil {
		return m.DestinationFolderId
	}
	return ""
}

type MoveNetworkMetadata struct {
	// ID of the network that is being moved.
	NetworkId            string   `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveNetworkMetadata) Reset()         { *m = MoveNetworkMetadata{} }
func (m *MoveNetworkMetadata) String() string { return proto.CompactTextString(m) }
func (*MoveNetworkMetadata) ProtoMessage()    {}
func (*MoveNetworkMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1f3ed0db5a46b68e, []int{14}
}

func (m *MoveNetworkMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveNetworkMetadata.Unmarshal(m, b)
}
func (m *MoveNetworkMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveNetworkMetadata.Marshal(b, m, deterministic)
}
func (m *MoveNetworkMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveNetworkMetadata.Merge(m, src)
}
func (m *MoveNetworkMetadata) XXX_Size() int {
	return xxx_messageInfo_MoveNetworkMetadata.Size(m)
}
func (m *MoveNetworkMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveNetworkMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_MoveNetworkMetadata proto.InternalMessageInfo

func (m *MoveNetworkMetadata) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func init() {
	proto.RegisterType((*GetNetworkRequest)(nil), "yandex.cloud.vpc.v1.GetNetworkRequest")
	proto.RegisterType((*ListNetworksRequest)(nil), "yandex.cloud.vpc.v1.ListNetworksRequest")
	proto.RegisterType((*ListNetworksResponse)(nil), "yandex.cloud.vpc.v1.ListNetworksResponse")
	proto.RegisterType((*CreateNetworkRequest)(nil), "yandex.cloud.vpc.v1.CreateNetworkRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.CreateNetworkRequest.LabelsEntry")
	proto.RegisterType((*CreateNetworkMetadata)(nil), "yandex.cloud.vpc.v1.CreateNetworkMetadata")
	proto.RegisterType((*UpdateNetworkRequest)(nil), "yandex.cloud.vpc.v1.UpdateNetworkRequest")
	proto.RegisterMapType((map[string]string)(nil), "yandex.cloud.vpc.v1.UpdateNetworkRequest.LabelsEntry")
	proto.RegisterType((*UpdateNetworkMetadata)(nil), "yandex.cloud.vpc.v1.UpdateNetworkMetadata")
	proto.RegisterType((*DeleteNetworkRequest)(nil), "yandex.cloud.vpc.v1.DeleteNetworkRequest")
	proto.RegisterType((*DeleteNetworkMetadata)(nil), "yandex.cloud.vpc.v1.DeleteNetworkMetadata")
	proto.RegisterType((*ListNetworkSubnetsRequest)(nil), "yandex.cloud.vpc.v1.ListNetworkSubnetsRequest")
	proto.RegisterType((*ListNetworkSubnetsResponse)(nil), "yandex.cloud.vpc.v1.ListNetworkSubnetsResponse")
	proto.RegisterType((*ListNetworkOperationsRequest)(nil), "yandex.cloud.vpc.v1.ListNetworkOperationsRequest")
	proto.RegisterType((*ListNetworkOperationsResponse)(nil), "yandex.cloud.vpc.v1.ListNetworkOperationsResponse")
	proto.RegisterType((*MoveNetworkRequest)(nil), "yandex.cloud.vpc.v1.MoveNetworkRequest")
	proto.RegisterType((*MoveNetworkMetadata)(nil), "yandex.cloud.vpc.v1.MoveNetworkMetadata")
}

func init() {
	proto.RegisterFile("yandex/cloud/vpc/v1/network_service.proto", fileDescriptor_1f3ed0db5a46b68e)
}

var fileDescriptor_1f3ed0db5a46b68e = []byte{
	// 1125 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x4d, 0x73, 0xdb, 0x54,
	0x14, 0x9d, 0x17, 0x3b, 0x6e, 0x7c, 0x0d, 0x25, 0xbc, 0x24, 0x83, 0x11, 0x09, 0x24, 0x9a, 0x69,
	0xe2, 0xb8, 0x48, 0xb2, 0xdc, 0x26, 0xd3, 0x24, 0xed, 0xb4, 0xa4, 0xb4, 0x9d, 0xce, 0x24, 0x94,
	0x51, 0xf9, 0x98, 0x21, 0xd3, 0xf1, 0x28, 0xd6, 0x8b, 0xd1, 0x58, 0x96, 0x84, 0x24, 0x9b, 0x7c,
	0xd0, 0x4d, 0xd9, 0x65, 0xc1, 0x86, 0x05, 0x0b, 0x06, 0x36, 0xb0, 0x61, 0x05, 0x93, 0x0d, 0x3f,
	0x21, 0x59, 0x87, 0x3f, 0xc0, 0x82, 0x05, 0x5b, 0xba, 0x64, 0xc5, 0xe8, 0x3d, 0xc9, 0x91, 0x62,
	0xd9, 0x51, 0x48, 0x17, 0xdd, 0x59, 0xbe, 0xe7, 0xdd, 0x7b, 0xde, 0xbd, 0xc7, 0xe7, 0xca, 0x30,
	0xbf, 0xa3, 0x9a, 0x1a, 0xd9, 0x96, 0xea, 0x86, 0xd5, 0xd6, 0xa4, 0x8e, 0x5d, 0x97, 0x3a, 0xb2,
	0x64, 0x12, 0xef, 0x4b, 0xcb, 0x69, 0xd6, 0x5c, 0xe2, 0x74, 0xf4, 0x3a, 0x11, 0x6d, 0xc7, 0xf2,
	0x2c, 0x3c, 0xc6, 0xa0, 0x22, 0x85, 0x8a, 0x1d, 0xbb, 0x2e, 0x76, 0x64, 0x6e, 0xb2, 0x61, 0x59,
	0x0d, 0x83, 0x48, 0xaa, 0xad, 0x4b, 0xaa, 0x69, 0x5a, 0x9e, 0xea, 0xe9, 0x96, 0xe9, 0xb2, 0x23,
	0xdc, 0x74, 0x10, 0xa5, 0x4f, 0x9b, 0xed, 0x2d, 0x69, 0x4b, 0x27, 0x86, 0x56, 0x6b, 0xa9, 0x6e,
	0x33, 0x44, 0xc4, 0xea, 0xfb, 0x59, 0x2c, 0x9b, 0x38, 0x34, 0x49, 0x80, 0x98, 0x19, 0xc0, 0x30,
	0x31, 0x49, 0x00, 0x71, 0xdb, 0x9b, 0x26, 0xf1, 0x02, 0xc4, 0x6c, 0x0c, 0xd1, 0x2d, 0xd1, 0x53,
	0x6c, 0x2a, 0x9e, 0x49, 0x35, 0x74, 0x2d, 0x12, 0xe6, 0xef, 0xc0, 0xeb, 0x0f, 0x88, 0xf7, 0x01,
	0x2b, 0xae, 0x90, 0x2f, 0xda, 0xc4, 0xf5, 0xf0, 0x55, 0x80, 0xb0, 0x61, 0xba, 0x56, 0x44, 0xd3,
	0xa8, 0x94, 0x5f, 0x7d, 0xe5, 0xef, 0x43, 0x19, 0xed, 0x1f, 0xc9, 0xd9, 0x9b, 0xb7, 0x16, 0x2a,
	0x4a, 0x3e, 0x88, 0x3f, 0xd4, 0xf8, 0xdf, 0x11, 0x8c, 0xad, 0xe9, 0x6e, 0x98, 0xc3, 0x0d, 0x93,
	0xcc, 0x43, 0x7e, 0xcb, 0x32, 0x34, 0xe2, 0xf4, 0xcb, 0x31, 0xc2, 0xc2, 0x0f, 0x35, 0x3c, 0x07,
	0x79, 0x5b, 0x6d, 0x90, 0x9a, 0xab, 0xef, 0x92, 0xe2, 0xd0, 0x34, 0x2a, 0x65, 0x56, 0xe1, 0xdf,
	0x43, 0x39, 0x77, 0xf3, 0x96, 0x5c, 0xa9, 0x54, 0x94, 0x11, 0x3f, 0xf8, 0x58, 0xdf, 0x25, 0xb8,
	0x04, 0x40, 0x81, 0x9e, 0xd5, 0x24, 0x66, 0x31, 0x43, 0x93, 0xe6, 0xf7, 0x8f, 0xe4, 0x61, 0x8a,
	0x54, 0x68, 0x96, 0x8f, 0xfc, 0x18, 0xe6, 0x21, 0xb7, 0xa5, 0x1b, 0x1e, 0x71, 0x8a, 0x59, 0x8a,
	0x82, 0xfd, 0xa3, 0x6e, 0xbe, 0x20, 0xc2, 0x6f, 0xc3, 0x78, 0x9c, 0xb8, 0x6b, 0x5b, 0xa6, 0x4b,
	0xf0, 0x0d, 0x18, 0x09, 0xae, 0xe7, 0x16, 0xd1, 0x74, 0xa6, 0x54, 0xa8, 0x4e, 0x8a, 0x09, 0x4a,
	0x11, 0xc3, 0xae, 0x75, 0xd1, 0x78, 0x16, 0x5e, 0x33, 0xc9, 0xb6, 0x57, 0x8b, 0x90, 0xf4, 0xaf,
	0x93, 0x57, 0x5e, 0xf5, 0xbf, 0xfe, 0x30, 0x64, 0xc7, 0xff, 0x33, 0x04, 0xe3, 0x77, 0x1d, 0xa2,
	0x7a, 0xe4, 0x54, 0xe7, 0xcf, 0xd1, 0xb4, 0x05, 0xc8, 0x9a, 0x6a, 0x8b, 0xf5, 0x2b, 0xbf, 0x3a,
	0xf3, 0xfc, 0x50, 0x9e, 0xfa, 0x6a, 0x43, 0x15, 0x76, 0x9f, 0x6c, 0x08, 0xaa, 0xb0, 0x5b, 0x11,
	0x96, 0x9e, 0xec, 0xc9, 0xef, 0x2e, 0xca, 0x4f, 0x37, 0x82, 0x27, 0x85, 0xc2, 0xf1, 0x55, 0x28,
	0x68, 0xc4, 0xad, 0x3b, 0xba, 0xed, 0xab, 0x20, 0xde, 0xc3, 0xea, 0xc2, 0xa2, 0x12, 0x8d, 0xe2,
	0x6f, 0x10, 0xe4, 0x0c, 0x75, 0x93, 0x18, 0x6e, 0x31, 0x4b, 0x1b, 0xb1, 0x90, 0xd8, 0x88, 0xa4,
	0xab, 0x88, 0x6b, 0xf4, 0xdc, 0x3d, 0xd3, 0x73, 0x76, 0x56, 0x6f, 0x3f, 0x3f, 0x94, 0x0b, 0x1b,
	0x42, 0xad, 0x22, 0x2c, 0xf9, 0x0c, 0xcb, 0xcf, 0xe8, 0x75, 0x16, 0xaf, 0xb3, 0x6b, 0x2d, 0x5e,
	0x3b, 0x38, 0x92, 0x73, 0x5c, 0x56, 0x16, 0xe8, 0x27, 0x8c, 0x47, 0x83, 0x7b, 0x74, 0xf1, 0x4a,
	0xc0, 0x82, 0x5b, 0x82, 0x42, 0x24, 0x2f, 0x1e, 0x85, 0x4c, 0x93, 0xec, 0xb0, 0x46, 0x29, 0xfe,
	0x47, 0x3c, 0x0e, 0xc3, 0x1d, 0xd5, 0x68, 0x07, 0x6d, 0x51, 0xd8, 0xc3, 0xf2, 0xd0, 0x0d, 0xc4,
	0x2f, 0xc2, 0x44, 0x8c, 0xe7, 0x3a, 0xf1, 0x54, 0x4d, 0xf5, 0x54, 0x3c, 0xd5, 0xab, 0xf6, 0xa8,
	0xbe, 0x7f, 0xcb, 0xc0, 0xf8, 0xc7, 0xb6, 0xd6, 0x3b, 0xab, 0xf3, 0xfc, 0x4a, 0xf0, 0x0a, 0x14,
	0xda, 0x34, 0x09, 0xb5, 0x0a, 0xca, 0xae, 0x50, 0xe5, 0x44, 0xe6, 0x26, 0x62, 0xe8, 0x26, 0xe2,
	0x7d, 0xdf, 0x4d, 0xd6, 0x55, 0xb7, 0xa9, 0x00, 0x83, 0xfb, 0x9f, 0xbb, 0xa3, 0xce, 0x5c, 0x68,
	0xd4, 0xd9, 0xb4, 0xa3, 0x1e, 0x1e, 0x30, 0xea, 0xa4, 0x4e, 0xbc, 0x8c, 0xa3, 0x8e, 0xf1, 0x4c,
	0x3b, 0xea, 0xbb, 0x30, 0xfe, 0x3e, 0x31, 0xc8, 0x85, 0x26, 0xed, 0x17, 0x8f, 0x25, 0x49, 0x5b,
	0xfc, 0x7b, 0x04, 0x6f, 0x46, 0xec, 0xe8, 0x31, 0x35, 0x7b, 0xf7, 0x7f, 0x89, 0xed, 0xc5, 0xfb,
	0x29, 0xbf, 0x07, 0x5c, 0x12, 0xb9, 0xc0, 0x31, 0x17, 0xe0, 0x12, 0x5b, 0x4e, 0xa1, 0x61, 0xbe,
	0x95, 0x28, 0x1e, 0x76, 0x4c, 0x09, 0xb1, 0xa9, 0xed, 0xf2, 0x47, 0x04, 0x93, 0x91, 0xea, 0x8f,
	0xc2, 0x15, 0xf7, 0xd2, 0x74, 0x67, 0x1f, 0xc1, 0x54, 0x1f, 0x82, 0x41, 0x87, 0xde, 0x03, 0xe8,
	0x6e, 0xe6, 0xb0, 0x49, 0x33, 0xf1, 0x26, 0x9d, 0x6c, 0xee, 0xee, 0x79, 0x25, 0x72, 0x28, 0x75,
	0xb7, 0xbe, 0x46, 0x80, 0xd7, 0xad, 0xce, 0x85, 0xec, 0xea, 0x0e, 0x4c, 0x68, 0xc4, 0xf5, 0x74,
	0x93, 0xd6, 0xae, 0x9d, 0xec, 0xa4, 0xa1, 0x84, 0x73, 0x63, 0x11, 0xe8, 0xfd, 0x60, 0x3d, 0xf1,
	0xd7, 0x61, 0x2c, 0x42, 0x22, 0xe5, 0x8f, 0xa0, 0xfa, 0x67, 0x1e, 0x2e, 0x87, 0x1a, 0x63, 0xaf,
	0x6a, 0xd8, 0x81, 0xcc, 0x03, 0xe2, 0xe1, 0xd9, 0x44, 0x45, 0xf5, 0xbc, 0xbb, 0x70, 0x03, 0x57,
	0x35, 0x7f, 0xe5, 0xd9, 0x1f, 0x7f, 0x7d, 0x3b, 0xf4, 0x0e, 0x9e, 0x3a, 0xf5, 0xda, 0xe5, 0x4a,
	0x7b, 0x27, 0xb4, 0x9e, 0xe2, 0x36, 0x64, 0xfd, 0x71, 0xe2, 0x52, 0x62, 0xb2, 0x84, 0xb7, 0x1d,
	0x6e, 0x3e, 0x05, 0x92, 0x49, 0x81, 0x2f, 0x52, 0x0e, 0x18, 0x8f, 0x9e, 0xe6, 0x80, 0xbf, 0x43,
	0x90, 0x63, 0x3b, 0x0a, 0xcf, 0xa7, 0x5e, 0xb4, 0xdc, 0xd9, 0x32, 0xe2, 0x6f, 0x1f, 0x1c, 0x97,
	0xa7, 0xfb, 0xed, 0xbf, 0x4b, 0xc1, 0x17, 0x94, 0xd6, 0x04, 0xdf, 0x43, 0x6b, 0x19, 0x95, 0xf1,
	0xcf, 0x08, 0x72, 0xcc, 0x52, 0xfb, 0x30, 0x4b, 0xda, 0x0b, 0x69, 0x98, 0xad, 0x31, 0x66, 0xc9,
	0x76, 0x1d, 0x63, 0xc6, 0x57, 0x07, 0x0f, 0xcd, 0xa7, 0xf9, 0x2b, 0x82, 0x1c, 0x33, 0xdf, 0x3e,
	0x34, 0x93, 0xec, 0x3d, 0x0d, 0xcd, 0x4f, 0x0f, 0x8e, 0xcb, 0x62, 0x3f, 0x63, 0x9f, 0x38, 0xbd,
	0xc5, 0xef, 0xb5, 0x6c, 0x6f, 0x87, 0x29, 0xad, 0x7c, 0x86, 0xd2, 0x7e, 0x40, 0x50, 0xf0, 0x55,
	0x12, 0x38, 0x2a, 0x16, 0xcf, 0xd2, 0x51, 0x7c, 0x2f, 0x70, 0x52, 0x6a, 0x7c, 0xa0, 0x3e, 0x81,
	0xf2, 0x9a, 0xc3, 0x57, 0x06, 0xf2, 0x92, 0x42, 0x8b, 0xfe, 0x05, 0xc1, 0x65, 0x3f, 0xdb, 0x89,
	0xa5, 0x61, 0xf9, 0xac, 0x92, 0x3d, 0xfe, 0xcc, 0x55, 0xcf, 0x73, 0x24, 0x20, 0x5a, 0xa1, 0x44,
	0xcb, 0xb8, 0x34, 0x98, 0x68, 0xc4, 0x20, 0x7f, 0x42, 0x90, 0xf5, 0x3d, 0x07, 0xcf, 0x25, 0x96,
	0xeb, 0xf5, 0xc4, 0x34, 0x93, 0x7f, 0x74, 0x70, 0x5c, 0x7e, 0x3b, 0xd9, 0xcb, 0x62, 0xf2, 0x9c,
	0xe3, 0xf9, 0xc1, 0xf2, 0x6c, 0x59, 0x1d, 0xb2, 0x8c, 0xca, 0xab, 0x9f, 0xc0, 0x1b, 0xb1, 0xa2,
	0xaa, 0xad, 0x07, 0x0c, 0x3f, 0x5b, 0x69, 0xe8, 0xde, 0xe7, 0xed, 0x4d, 0xb1, 0x6e, 0xb5, 0x24,
	0x86, 0x11, 0xd8, 0xdf, 0xb6, 0x86, 0x25, 0x34, 0x88, 0x49, 0xf5, 0x25, 0x25, 0xfc, 0x33, 0x5c,
	0xe9, 0xd8, 0xf5, 0xcd, 0x1c, 0x0d, 0x5f, 0xfb, 0x2f, 0x00, 0x00, 0xff, 0xff, 0xc5, 0x46, 0xed,
	0x6f, 0x00, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NetworkServiceClient is the client API for NetworkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NetworkServiceClient interface {
	// Returns the specified Network resource.
	//
	// Get the list of available Network resources by making a [List] request.
	Get(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error)
	// Retrieves the list of Network resources in the specified folder.
	List(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error)
	// Creates a network in the specified folder using the data specified in the request.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(ctx context.Context, in *CreateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified network.
	Delete(ctx context.Context, in *DeleteNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists subnets from the specified network.
	ListSubnets(ctx context.Context, in *ListNetworkSubnetsRequest, opts ...grpc.CallOption) (*ListNetworkSubnetsResponse, error)
	// Lists operations for the specified network.
	ListOperations(ctx context.Context, in *ListNetworkOperationsRequest, opts ...grpc.CallOption) (*ListNetworkOperationsResponse, error)
	// Move network to another folder.
	Move(ctx context.Context, in *MoveNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type networkServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkServiceClient(cc grpc.ClientConnInterface) NetworkServiceClient {
	return &networkServiceClient{cc}
}

func (c *networkServiceClient) Get(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) List(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error) {
	out := new(ListNetworksResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) Create(ctx context.Context, in *CreateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) Update(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) Delete(ctx context.Context, in *DeleteNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) ListSubnets(ctx context.Context, in *ListNetworkSubnetsRequest, opts ...grpc.CallOption) (*ListNetworkSubnetsResponse, error) {
	out := new(ListNetworkSubnetsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/ListSubnets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) ListOperations(ctx context.Context, in *ListNetworkOperationsRequest, opts ...grpc.CallOption) (*ListNetworkOperationsResponse, error) {
	out := new(ListNetworkOperationsResponse)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/ListOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkServiceClient) Move(ctx context.Context, in *MoveNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, "/yandex.cloud.vpc.v1.NetworkService/Move", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkServiceServer is the server API for NetworkService service.
type NetworkServiceServer interface {
	// Returns the specified Network resource.
	//
	// Get the list of available Network resources by making a [List] request.
	Get(context.Context, *GetNetworkRequest) (*Network, error)
	// Retrieves the list of Network resources in the specified folder.
	List(context.Context, *ListNetworksRequest) (*ListNetworksResponse, error)
	// Creates a network in the specified folder using the data specified in the request.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Create(context.Context, *CreateNetworkRequest) (*operation.Operation, error)
	// Updates the specified network.
	// Method starts an asynchronous operation that can be cancelled while it is in progress.
	Update(context.Context, *UpdateNetworkRequest) (*operation.Operation, error)
	// Deletes the specified network.
	Delete(context.Context, *DeleteNetworkRequest) (*operation.Operation, error)
	// Lists subnets from the specified network.
	ListSubnets(context.Context, *ListNetworkSubnetsRequest) (*ListNetworkSubnetsResponse, error)
	// Lists operations for the specified network.
	ListOperations(context.Context, *ListNetworkOperationsRequest) (*ListNetworkOperationsResponse, error)
	// Move network to another folder.
	Move(context.Context, *MoveNetworkRequest) (*operation.Operation, error)
}

// UnimplementedNetworkServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNetworkServiceServer struct {
}

func (*UnimplementedNetworkServiceServer) Get(ctx context.Context, req *GetNetworkRequest) (*Network, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedNetworkServiceServer) List(ctx context.Context, req *ListNetworksRequest) (*ListNetworksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedNetworkServiceServer) Create(ctx context.Context, req *CreateNetworkRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedNetworkServiceServer) Update(ctx context.Context, req *UpdateNetworkRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedNetworkServiceServer) Delete(ctx context.Context, req *DeleteNetworkRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedNetworkServiceServer) ListSubnets(ctx context.Context, req *ListNetworkSubnetsRequest) (*ListNetworkSubnetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubnets not implemented")
}
func (*UnimplementedNetworkServiceServer) ListOperations(ctx context.Context, req *ListNetworkOperationsRequest) (*ListNetworkOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperations not implemented")
}
func (*UnimplementedNetworkServiceServer) Move(ctx context.Context, req *MoveNetworkRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}

func RegisterNetworkServiceServer(s *grpc.Server, srv NetworkServiceServer) {
	s.RegisterService(&_NetworkService_serviceDesc, srv)
}

func _NetworkService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Get(ctx, req.(*GetNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).List(ctx, req.(*ListNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Create(ctx, req.(*CreateNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Update(ctx, req.(*UpdateNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Delete(ctx, req.(*DeleteNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_ListSubnets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkSubnetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).ListSubnets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/ListSubnets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).ListSubnets(ctx, req.(*ListNetworkSubnetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).ListOperations(ctx, req.(*ListNetworkOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkService_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkServiceServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/yandex.cloud.vpc.v1.NetworkService/Move",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkServiceServer).Move(ctx, req.(*MoveNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NetworkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.vpc.v1.NetworkService",
	HandlerType: (*NetworkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _NetworkService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NetworkService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _NetworkService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _NetworkService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NetworkService_Delete_Handler,
		},
		{
			MethodName: "ListSubnets",
			Handler:    _NetworkService_ListSubnets_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _NetworkService_ListOperations_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _NetworkService_Move_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/vpc/v1/network_service.proto",
}
