// Code generated by sdkgen. DO NOT EDIT.

//nolint
package dataproc

import (
	"context"

	"google.golang.org/grpc"

	dataproc "github.com/yandex-cloud/go-genproto/yandex/cloud/dataproc/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ClusterServiceClient is a dataproc.ClusterServiceClient with
// lazy GRPC connection initialization.
type ClusterServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) Create(ctx context.Context, in *dataproc.CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) Delete(ctx context.Context, in *dataproc.DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) Get(ctx context.Context, in *dataproc.GetClusterRequest, opts ...grpc.CallOption) (*dataproc.Cluster, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).Get(ctx, in, opts...)
}

// List implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) List(ctx context.Context, in *dataproc.ListClustersRequest, opts ...grpc.CallOption) (*dataproc.ListClustersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).List(ctx, in, opts...)
}

type ClusterIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *dataproc.ListClustersRequest

	items []*dataproc.Cluster
}

func (c *ClusterServiceClient) ClusterIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *ClusterIterator {
	return &ClusterIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &dataproc.ListClustersRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *ClusterIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Clusters
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterIterator) Value() *dataproc.Cluster {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterIterator) Error() error {
	return it.err
}

// ListHosts implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) ListHosts(ctx context.Context, in *dataproc.ListClusterHostsRequest, opts ...grpc.CallOption) (*dataproc.ListClusterHostsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).ListHosts(ctx, in, opts...)
}

type ClusterHostsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *dataproc.ListClusterHostsRequest

	items []*dataproc.Host
}

func (c *ClusterServiceClient) ClusterHostsIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *ClusterHostsIterator {
	return &ClusterHostsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &dataproc.ListClusterHostsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *ClusterHostsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListHosts(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Hosts
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterHostsIterator) Value() *dataproc.Host {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterHostsIterator) Error() error {
	return it.err
}

// ListOperations implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) ListOperations(ctx context.Context, in *dataproc.ListClusterOperationsRequest, opts ...grpc.CallOption) (*dataproc.ListClusterOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).ListOperations(ctx, in, opts...)
}

type ClusterOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *ClusterServiceClient
	request *dataproc.ListClusterOperationsRequest

	items []*operation.Operation
}

func (c *ClusterServiceClient) ClusterOperationsIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *ClusterOperationsIterator {
	return &ClusterOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &dataproc.ListClusterOperationsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *ClusterOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterOperationsIterator) Error() error {
	return it.err
}

// Start implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) Start(ctx context.Context, in *dataproc.StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).Start(ctx, in, opts...)
}

// Stop implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) Stop(ctx context.Context, in *dataproc.StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).Stop(ctx, in, opts...)
}

// Update implements dataproc.ClusterServiceClient
func (c *ClusterServiceClient) Update(ctx context.Context, in *dataproc.UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewClusterServiceClient(conn).Update(ctx, in, opts...)
}
