## Styleguides

### Developer Certificate of Origin

Please read the [Developer Certificate of Origin](./dco.md) before contributing.
The project is licensed under MIT.

### Git Commit Messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
* Limit the first line to 72 characters or less
* Reference issues and pull requests liberally
* Consider starting the commit message with an applicable emoji :smiley: :
    * :art: `:art:` when improving the format/structure of the code
    * :rocket: `:rocket:` when improving performance
    * :bulb: `:bulb:` new idea
    * :books: `:books:` To add new reference
    * :construction: `:construction:` work in progress
    * :computer: `:computer:` when adding feature
    * :heavy_minus_sign: `:heavy_minus_sign:` when removing feature
    * :non-potable_water: `:non-potable_water:` when plugging memory leaks
    * :pencil2: `:pencil2:` when writing docs
    * :penguin: `:penguin:` when fixing something on Linux
    * :apple: `:apple:` when fixing something on macOS
    * :checkered_flag: `:checkered_flag:` when closing pull requests
    * :bug: `:bug:` when fixing a bug
    * :fire: `:fire:` when removing code or files
    * :green_heart: `:green_heart:` when fixing the CI build
    * :dart: `:dart:` when adding tests
    * :lock: `:lock:` when dealing with security
    * :arrow_up: `:arrow_up:` when upgrading dependencies
    * :arrow_down: `:arrow_down:` when downgrading dependencies
    * :speaker: `:speaker:` when adding logging
    * :mute: `:mute:` when reducing logging
    * :shirt: `:shirt:` when removing linter warnings
    * :hammer: `:hammer:` Refactor


