## Upload 上传

通过点击或者拖拽上传文件

### 点击上传

:::demo 通过 slot 你可以传入自定义的上传按钮类型和文字提示。可通过设置`limit`和`on-exceed`来限制上传文件的个数和定义超出限制时的行为。可通过设置`before-remove`来阻止文件移除操作。
```html
<el-upload
  class="upload-demo"
  action="https://jsonplaceholder.typicode.com/posts/"
  :on-preview="handlePreview"
  :on-remove="handleRemove"
  :before-remove="beforeRemove"
  multiple
  :limit="3"
  :on-exceed="handleExceed"
  :file-list="fileList">
  <el-button size="small" type="primary">点击上传</el-button>
  <template v-slot:tip>
      <div class="el-upload__tip">只能上传jpg/png文件，且不超过500kb</div>
  </template>
</el-upload>
<script>
  import { reactive , toRefs , getCurrentInstance } from 'vue';
  export default {
    setup(){
      let state = reactive({
        fileList: [{name: 'food.jpeg', url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'}, {name: 'food2.jpeg', url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'}]
      });
      const self = getCurrentInstance().ctx;
      const handleRemove = (file, fileList) => {
        console.log(file, fileList);
      }
      const handlePreview = (file) => {
        console.log(file);
      }
      const handleExceed = (files, fileList) => {
        self.$message.warning(`当前限制选择 3 个文件，本次选择了 ${files.length} 个文件，共选择了 ${files.length + fileList.length} 个文件`);
      }
      const beforeRemove = (file, fileList) => {
        // return self.$confirm(`确定移除 ${ file.name }？`);
      }

      return {
        ...toRefs(state),
        handleRemove,
        handlePreview,
        handleExceed,
        beforeRemove
      }
    }
  }
</script>
```
:::

### 用户头像上传

使用 `before-upload` 限制用户上传的图片格式和大小。

:::demo
```html
<el-upload
  class="avatar-uploader"
  action="https://jsonplaceholder.typicode.com/posts/"
  :show-file-list="false"
  :on-success="handleAvatarSuccess"
  :before-upload="beforeAvatarUpload">
<img v-if="imageUrl" :src="imageUrl" class="avatar">
<i v-else class="el-icon-plus avatar-uploader-icon"></i>
</el-upload>

<style>
  .avatar-uploader .el-upload {
    border: 1px dashed #d9d9d9;
    border-radius: 6px;
    cursor: pointer;
    position: relative;
    overflow: hidden;
  }
  .avatar-uploader .el-upload:hover {
    border-color: #409EFF;
  }
  .avatar-uploader .avatar-uploader-icon {
    font-size: 28px;
    color: #8c939d;
    width: 178px;
    height: 178px;
    line-height: 178px;
    text-align: center;
  }
  .avatar {
    width: 178px;
    height: 178px;
    display: block;
  }
</style>

<script>
  import { ref } from 'vue';
  import { Message } from 'element3';
  export default {
    setup(){
      const imageUrl = ref('');

      const handleAvatarSuccess = (res, file) => {
        imageUrl.value = URL.createObjectURL(file.raw);
      }
      const beforeAvatarUpload = (file) => {
        const isJPG = file.type === 'image/jpeg';
        const isLt2M = file.size / 1024 / 1024 < 2;

        if (!isJPG) {
          Message.error('上传头像图片只能是 JPG 格式!');
        }
        if (!isLt2M) {
          Message.error('上传头像图片大小不能超过 2MB!');
        }
        return isJPG && isLt2M;
      }

      return {
        imageUrl,
        handleAvatarSuccess,
        beforeAvatarUpload
      }
    }
  }
</script>
```
:::

### 照片墙

使用 `list-type` 属性来设置文件列表的样式。

:::demo
```html
<el-upload
  action="https://jsonplaceholder.typicode.com/posts/"
  list-type="picture-card"
  :on-preview="handlePictureCardPreview"
  :on-remove="handleRemove">
  <i class="el-icon-plus"></i>
</el-upload>
<el-dialog :visible.sync="dialogVisible" v-model:visible="dialogVisible">
  <img :src="dialogImageUrl" alt="" style="width: 100%;">
</el-dialog>
<script>
  import { ref, unref } from 'vue';
  export default {
    setup(){
      const dialogImageUrl = ref('');
      const dialogVisible = ref(false);

      const handleRemove = (file, fileList) => {
        console.log(file, fileList);
      }
      const handlePictureCardPreview = (file) => {
        dialogImageUrl.value = unref(file).url;
        dialogVisible.value = true;
      }

      return {
        dialogImageUrl,
        dialogVisible,
        handleRemove,
        handlePictureCardPreview
      }
    }
  }
</script>
```
:::

### 文件缩略图

使用 `scoped-slot` 去设置缩略图模版。

:::demo
```html
  <el-upload
    action="https://jsonplaceholder.typicode.com/posts/"
    list-type="picture-card"
    ref="uploadRef"
    :auto-upload="false">
    <template #default>
      <i class="el-icon-plus"></i>
    </template>
    <template #file="{file}">
      <img class="el-upload-list__item-thumbnail" :src="file.url" alt="">
      <span class="el-upload-list__item-actions">
        <span class="el-upload-list__item-preview" @click="handlePictureCardPreview(file)">
          <i class="el-icon-zoom-in"></i>
        </span>
        <span class="el-upload-list__item-delete" @click="handleDownload(file)">
          <i class="el-icon-download"></i>
        </span>
        <span class="el-upload-list__item-delete" @click="handleRemove(file)">
          <i class="el-icon-delete"></i>
        </span>
      </span>
    </template>
  </el-upload>
  <el-dialog :visible.sync="dialogVisible" v-model:visible="dialogVisible">
    <img width="100%" :src="dialogImageUrl" style="width: 100%">
  </el-dialog>
<script>
import { ref, unref } from 'vue'

export default {
  setup() {
    const dialogImageUrl = ref('')
    const dialogVisible = ref(false)
    const uploadRef = ref(null)

    const handleRemove = (file) => {
      console.log('remove')
      uploadRef.value.handleRemove(file)
    }

    const handlePictureCardPreview = (file) => {
      dialogImageUrl.value = unref(file).url
      dialogVisible.value = true
    }

    const handleDownload = (file) => {
      console.log('DownLoad')
    }

    return {
      dialogImageUrl,
      dialogVisible,
      uploadRef,
      handleRemove,
      handlePictureCardPreview,
      handleDownload
    }
  }
}
</script>
```
:::

### 图片列表缩略图
上传图片文件, 点击已上传的图片列表可查看缩略图

:::demo
```html
  <el-upload
    action="https://jsonplaceholder.typicode.com/posts/"
    :on-preview="handlePreview"
    :on-remove="handleRemove"
    :file-list="fileList"
    list-type="picture">
    <el-button size="small" type="primary">选择文件</el-button>
  </el-upload>
  <el-dialog :visible.sync="dialogVisible" v-model:visible="dialogVisible">
    <img width="100%" :src="dialogImageUrl" style="width: 100%">
  </el-dialog>
<script>
import { reactive, ref, unref, toRefs } from 'vue'

export default {
  setup() {
    const state = reactive({
      fileList: [
        {
          name: 'food.jpeg',
          url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'
        },
        {
          name: 'food2.jpeg',
          url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'
        }]
    })
    const dialogImageUrl = ref('');
    const dialogVisible = ref(false)

    const handleRemove = (file, fileList) => {
      console.log(file, fileList)
    }

    const handlePreview = (file) => {
      dialogImageUrl.value = unref(file).url
      dialogVisible.value = true
    }

    return {
      ...toRefs(state),
      dialogVisible,
      dialogImageUrl,
      handleRemove,
      handlePreview,
    }
  }
}
</script>
```
:::

### 上传文件列表控制

上传文件之前、上传成功、失败都触发 `on-change` 钩子, 可通过该钩子函数来对列表进行控制, 

:::demo
```html
  <el-upload
    action="https://jsonplaceholder.typicode.com/posts/"
    :on-change="handleChange"
    :file-list="fileList">
    <el-button size="small" type="primary">点击上传</el-button>
  </el-upload>
<script>
import { reactive, toRefs } from 'vue'

export default {
  setup() {
    const state = reactive({
      fileList: [
        {
          name: 'food.jpeg',
          url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'
        },
        {
          name: 'food2.jpeg',
          url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'
        }]
    })

    const handleChange = (file, fileList) => {
      console.log(file)
      console.log(fileList)
    }

    return {
      ...toRefs(state),
      handleChange
    }
  }
}
</script>
```
:::

### 拖拽上传

:::demo
```html
<el-upload
  class="upload-demo"
  drag
  action="https://jsonplaceholder.typicode.com/posts/"
  multiple>
  <i class="el-icon-upload"></i>
  <div class="el-upload__text">将文件拖到此处，或<em>点击上传</em></div>
  <div class="el-upload__tip" slot="tip">只能上传jpg/png文件，且不超过500kb</div>
</el-upload>
```
:::

### 手动上传
可控制已选择文件列表上传的时机，调用 `upload` 实例的 `submit` 方法

:::demo
```html
<template>
  <el-upload
    ref="upload"
    action="https://jsonplaceholder.typicode.com/posts/"
    :on-preview="handlePreview"
    :on-remove="handleRemove"
    :file-list="fileList"
    :auto-upload="false">
    <template v-slot:trigger>
      <el-button size="small" type="primary">选取文件</el-button>
    </template>
    <el-button style="margin-left: 10px;" size="small" type="success" @click="submitUpload">开始上传至服务器</el-button>
  </el-upload>
</template>
<script>
import { reactive, ref, toRefs } from 'vue'

export default {
  setup() {
    const state = reactive({
      fileList: [
        {
          name: 'food.jpeg',
          url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'
        },
        {
          name: 'food2.jpeg',
          url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'
        }]
    })

    const upload = ref(null)

    const submitUpload = () => {
      upload.value.submit()
    }
    const handleRemove = (file, fileList) => {
      console.log(file, fileList)
    }
    const handlePreview = (file) => {
      console.log(file)
    }

    return {
      ...toRefs(state),
      submitUpload,
      handleRemove,
      handlePreview,
      upload
    }
  }
}
</script>
```
:::

### Attribute
| 参数      | 说明          | 类型      | 可选值                           | 默认值  |
|---------- |-------------- |---------- |--------------------------------  |-------- |
| action | 必选参数，上传的地址 | string | — | — |
| headers | 设置上传的请求头部 | object | — | — |
| multiple | 是否支持多选文件 | boolean | — | — |
| data | 上传时附带的额外参数 | object | — | — |
| name | 上传的文件字段名 | string | — | file |
| with-credentials | 支持发送 cookie 凭证信息 | boolean | — | false |
| show-file-list | 是否显示已上传文件列表 | boolean | — | true |
| drag | 是否启用拖拽上传 | boolean | — | false |
| accept | 接受上传的[文件类型](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-accept)（thumbnail-mode 模式下此参数无效）| string | — | — |
| on-preview | 点击文件列表中已上传的文件时的钩子 | function(file) | — | — |
| on-remove | 文件列表移除文件时的钩子 | function(file, fileList) | — | — |
| on-success | 文件上传成功时的钩子 | function(response, file, fileList) | — | — |
| on-error | 文件上传失败时的钩子 | function(err, file, fileList) | — | — |
| on-progress | 文件上传时的钩子 | function(event, file, fileList) | — | — |
| on-change | 文件状态改变时的钩子，添加文件、上传成功和上传失败时都会被调用 | function(file, fileList) | — | — |
| before-upload | 上传文件之前的钩子，参数为上传的文件，若返回 false 或者返回 Promise 且被 reject，则停止上传。 | function(file) | — | — |
| before-remove | 删除文件之前的钩子，参数为上传的文件和文件列表，若返回 false 或者返回 Promise 且被 reject，则停止删除。| function(file, fileList) | — | — |
| list-type | 文件列表的类型 | string | text/picture/picture-card | text |
| auto-upload | 是否在选取文件后立即进行上传 | boolean | — | true |
| file-list | 上传的文件列表, 例如: [{name: 'food.jpg', url: 'https://xxx.cdn.com/xxx.jpg'}] | array | — | [] |
| http-request | 覆盖默认的上传行为，可以自定义上传的实现 | function | — | — |
| disabled | 是否禁用 | boolean | — | false |
| limit | 最大允许上传个数 |  number | — | — |
| on-exceed | 文件超出个数限制时的钩子 | function(files, fileList) | — | - |

### Slot
| name | 说明 |
|------|--------|
| trigger | 触发文件选择框的内容 |
| tip | 提示说明文字 |

### Methods
| 方法名      | 说明          | 参数 |
|----------- |-------------- | -- |
| clearFiles | 清空已上传的文件列表（该方法不支持在 before-upload 中调用） | — |
| abort      | 取消上传请求    | （ file: fileList 中的 file 对象 ） |
| submit     | 手动上传文件列表 |  —                                |
