### `tf.contrib.legacy_seq2seq.embedding_attention_decoder(decoder_inputs, initial_state, attention_states, cell, num_symbols, embedding_size, num_heads=1, output_size=None, output_projection=None, feed_previous=False, update_embedding_for_previous=True, dtype=None, scope=None, initial_state_attention=False)` {#embedding_attention_decoder}

RNN decoder with embedding and attention and a pure-decoding option.

##### Args:


*  <b>`decoder_inputs`</b>: A list of 1D batch-sized int32 Tensors (decoder inputs).
*  <b>`initial_state`</b>: 2D Tensor [batch_size x cell.state_size].
*  <b>`attention_states`</b>: 3D Tensor [batch_size x attn_length x attn_size].
*  <b>`cell`</b>: core_rnn_cell.RNNCell defining the cell function.
*  <b>`num_symbols`</b>: Integer, how many symbols come into the embedding.
*  <b>`embedding_size`</b>: Integer, the length of the embedding vector for each symbol.
*  <b>`num_heads`</b>: Number of attention heads that read from attention_states.
*  <b>`output_size`</b>: Size of the output vectors; if None, use output_size.
*  <b>`output_projection`</b>: None or a pair (W, B) of output projection weights and
    biases; W has shape [output_size x num_symbols] and B has shape
    [num_symbols]; if provided and feed_previous=True, each fed previous
    output will first be multiplied by W and added B.
*  <b>`feed_previous`</b>: Boolean; if True, only the first of decoder_inputs will be
    used (the "GO" symbol), and all other decoder inputs will be generated by:
      next = embedding_lookup(embedding, argmax(previous_output)),
    In effect, this implements a greedy decoder. It can also be used
    during training to emulate http://arxiv.org/abs/1506.03099.
    If False, decoder_inputs are used as given (the standard decoder case).
*  <b>`update_embedding_for_previous`</b>: Boolean; if False and feed_previous=True,
    only the embedding for the first symbol of decoder_inputs (the "GO"
    symbol) will be updated by back propagation. Embeddings for the symbols
    generated from the decoder itself remain unchanged. This parameter has
    no effect if feed_previous=False.
*  <b>`dtype`</b>: The dtype to use for the RNN initial states (default: tf.float32).
*  <b>`scope`</b>: VariableScope for the created subgraph; defaults to
    "embedding_attention_decoder".
*  <b>`initial_state_attention`</b>: If False (default), initial attentions are zero.
    If True, initialize the attentions from the initial state and attention
    states -- useful when we wish to resume decoding from a previously
    stored decoder state and attention states.

##### Returns:

  A tuple of the form (outputs, state), where:

*  <b>`outputs`</b>: A list of the same length as decoder_inputs of 2D Tensors with
      shape [batch_size x output_size] containing the generated outputs.
*  <b>`state`</b>: The state of each decoder cell at the final time-step.
      It is a 2D Tensor of shape [batch_size x cell.state_size].

##### Raises:


*  <b>`ValueError`</b>: When output_projection has the wrong shape.

