#
# Copyright (c) 2009 Christophe Varoqui <christophe.varoqui@free.fr>'
# Copyright (c) 2009 Cyril Galibern <cyril.galibern@free.fr>'
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

from subprocess import *

import rcIfconfigLinux
from rcGlobalEnv import rcEnv
from rcUtilities import which
import os

class ifconfig(rcIfconfigLinux.ifconfig):
    def __init__(self, hostname):
        self.intf = []

        if which('lxc-attach') and os.path.exists('/proc/1/ns/pid'):
            self.rsh = ['lxc-attach', '-n', hostname]
            cmd = ['echo', '/sbin/ifconfig', '-a']
            p1 = Popen(cmd, stdout=PIPE)
            out = Popen(self.rsh, stdout=PIPE, stdin=p1.stdout).communicate()[0]
        else:
            self.rsh = rcEnv.rsh.split() + [hostname, '--', 'env', 'LANG=C']
            cmd = self.rsh + ['/sbin/ifconfig', '-a']
            out = Popen(cmd, stdout=PIPE).communicate()[0]
        self.parse(out)
