#if !NET_4_0

// THIS IS AUTOGENERATED DO NOT EDIT
//
// Authors:
//    Ben Maurer (bmaurer@novell.com)
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using MonoTests.stand_alone.WebHarness;


using NUnit.Framework;
namespace MonoTests.System.Web.UI.WebControls {
[TestFixture]
public class RepeatInfo_Autogen {
	public class RepeatInfoUser : IRepeatInfoUser {

		private bool footer;
		private bool header;
		private bool separators;
		private int count;
		private int counter;


		public RepeatInfoUser (bool header, bool footer, bool separators, int count)
		{
			this.footer = footer;
			this.header = header;
			this.separators = separators;
			this.count = count;
		}

		static HtmlTextWriter GetWriter ()
		{
			StringWriter sw = new StringWriter ();
			sw.NewLine = "\n";
			return new HtmlTextWriter (sw);
		}

		public static string DoTest (int cols, int cnt, RepeatDirection d, RepeatLayout l, bool OuterTableImplied, bool hdr, bool ftr, bool sep)
		{
			HtmlTextWriter htw = GetWriter ();
			RepeatInfo ri = new RepeatInfo ();
			ri.RepeatColumns = cols;
			ri.RepeatDirection = d;
			ri.RepeatLayout = l;
			ri.OuterTableImplied = OuterTableImplied;
			Style s = new Style ();
			if (cols != 3)
				s.CssClass = "mainstyle";

			ri.RenderRepeater (htw, new RepeatInfoUser (hdr, ftr, sep, cnt), s, new DataList ());
			return htw.InnerWriter.ToString ();
		}


		public bool HasFooter {
			get { return footer; }
		}

		public bool HasHeader {
			get { return header; }
		}
		
		public bool HasSeparators {
			get { return separators; }
		}

		public int RepeatedItemCount {
			get { return count; }
		}

		public Style GetItemStyle (ListItemType itemType, int repeatIndex)
		{
			Style s = new Style ();
			s.CssClass = String.Format ("{0}{1}", itemType, repeatIndex);
			return s;
		}

		public void RenderItem (ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer)
		{
			writer.Write ("({0},{1},{2})", counter++, itemType, repeatIndex);
		}
	}

	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td colspan=""0"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
        
        HtmlDiff.AssertAreEqual(exp, v, "#0");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#1");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(4,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#2");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""10"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""10"" class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#3");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#4");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#5");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#6");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(14,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#7");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td class=""Separator6"">(14,Separator,6)</td><td class=""Item7"">(15,Item,7)</td><td class=""Separator7"">(16,Separator,7)</td><td class=""Item8"">(17,Item,8)</td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(18,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#8");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(14,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#9");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#10");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#11");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#12");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)(10,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#13");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#14");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)(10,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#15");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,2)(4,Separator,2)(5,Item,1)(6,Separator,1)(7,Item,3)(8,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#16");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,4)(4,Separator,4)(5,Item,1)(6,Separator,1)(7,Item,5)(8,Separator,5)(9,Item,2)(10,Separator,2)(11,Item,6)(12,Item,3)(13,Separator,3)(14,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#17");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,6)(6,Separator,6)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,7)(12,Separator,7)(13,Item,2)(14,Separator,2)(15,Item,5)(16,Separator,5)(17,Item,8)(18,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#18");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,5)(6,Separator,5)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,6)(12,Item,2)(13,Separator,2)(14,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#19");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#20");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#21");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#22");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#23");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#24");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)<br />(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)<br />(9,Item,4)<br />(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#25");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#26");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)<br />(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br />(14,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#27");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)(14,Separator,6)(15,Item,7)(16,Separator,7)(17,Item,8)<br />(18,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#28");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br />(14,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#29");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#30");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#31");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#32");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)(10,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#33");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#34");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)(10,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#35");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,2)(4,Separator,2)(5,Item,1)(6,Separator,1)(7,Item,3)(8,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#36");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,4)(4,Separator,4)(5,Item,1)(6,Separator,1)(7,Item,5)(8,Separator,5)(9,Item,2)(10,Separator,2)(11,Item,6)(12,Item,3)(13,Separator,3)(14,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#37");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,6)(6,Separator,6)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,7)(12,Separator,7)(13,Item,2)(14,Separator,2)(15,Item,5)(16,Separator,5)(17,Item,8)(18,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#38");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,5)(6,Separator,5)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,6)(12,Item,2)(13,Separator,2)(14,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#39");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td colspan=""0"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#40");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#41");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(4,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#42");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""10"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""10"" class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#43");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#44");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#45");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#46");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(14,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#47");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td class=""Separator6"">(14,Separator,6)</td><td class=""Item7"">(15,Item,7)</td><td class=""Separator7"">(16,Separator,7)</td><td class=""Item8"">(17,Item,8)</td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(18,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#48");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(14,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#49");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#50");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#51");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td>
	</tr><tr>
		<td class=""Footer-1"">(4,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#52");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#53");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#54");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#55");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item2"">(3,Item,2)</td><td class=""Separator2"">(4,Separator,2)</td>
	</tr><tr>
		<td class=""Item1"">(5,Item,1)</td><td class=""Separator1"">(6,Separator,1)</td><td class=""Item3"">(7,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#56");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item4"">(3,Item,4)</td><td class=""Separator4"">(4,Separator,4)</td>
	</tr><tr>
		<td class=""Item1"">(5,Item,1)</td><td class=""Separator1"">(6,Separator,1)</td><td class=""Item5"">(7,Item,5)</td><td class=""Separator5"">(8,Separator,5)</td>
	</tr><tr>
		<td class=""Item2"">(9,Item,2)</td><td class=""Separator2"">(10,Separator,2)</td><td class=""Item6"">(11,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item3"">(12,Item,3)</td><td class=""Separator3"">(13,Separator,3)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(14,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#57");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item3"">(3,Item,3)</td><td class=""Separator3"">(4,Separator,3)</td><td class=""Item6"">(5,Item,6)</td><td class=""Separator6"">(6,Separator,6)</td>
	</tr><tr>
		<td class=""Item1"">(7,Item,1)</td><td class=""Separator1"">(8,Separator,1)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item7"">(11,Item,7)</td><td class=""Separator7"">(12,Separator,7)</td>
	</tr><tr>
		<td class=""Item2"">(13,Item,2)</td><td class=""Separator2"">(14,Separator,2)</td><td class=""Item5"">(15,Item,5)</td><td class=""Separator5"">(16,Separator,5)</td><td class=""Item8"">(17,Item,8)</td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(18,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#58");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item3"">(3,Item,3)</td><td class=""Separator3"">(4,Separator,3)</td><td class=""Item5"">(5,Item,5)</td><td class=""Separator5"">(6,Separator,5)</td>
	</tr><tr>
		<td class=""Item1"">(7,Item,1)</td><td class=""Separator1"">(8,Separator,1)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item6"">(11,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item2"">(12,Item,2)</td><td class=""Separator2"">(13,Separator,2)</td><td></td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(14,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#59");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#60");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#61");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#62");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#63");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#64");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)<br />(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)<br />(9,Item,4)<br />(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#65");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#66");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)<br />(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br />(14,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#67");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)(14,Separator,6)(15,Item,7)(16,Separator,7)(17,Item,8)<br />(18,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#68");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br />(14,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#69");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#70");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#71");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Separator,0)<br />(3,Item,1)<br />(4,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#72");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Separator,0)<br />(3,Item,1)<br />(4,Separator,1)<br />(5,Item,2)<br />(6,Separator,2)<br />(7,Item,3)<br />(8,Separator,3)<br />(9,Item,4)<br />(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#73");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#74");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Separator,0)<br />(3,Item,1)<br />(4,Separator,1)<br />(5,Item,2)<br />(6,Separator,2)<br />(7,Item,3)<br />(8,Separator,3)<br />(9,Item,4)<br />(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#75");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,2)(4,Separator,2)<br />(5,Item,1)(6,Separator,1)(7,Item,3)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#76");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,4)(4,Separator,4)<br />(5,Item,1)(6,Separator,1)(7,Item,5)(8,Separator,5)<br />(9,Item,2)(10,Separator,2)(11,Item,6)<br />(12,Item,3)(13,Separator,3)<br />(14,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#77");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,6)(6,Separator,6)<br />(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,7)(12,Separator,7)<br />(13,Item,2)(14,Separator,2)(15,Item,5)(16,Separator,5)(17,Item,8)<br />(18,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#78");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_hdr_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,5)(6,Separator,5)<br />(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,6)<br />(12,Item,2)(13,Separator,2)<br />(14,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#79");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#80");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#81");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(3,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#82");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""10"" class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#83");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#84");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#85");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#86");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(13,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#87");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td class=""Separator6"">(13,Separator,6)</td><td class=""Item7"">(14,Item,7)</td><td class=""Separator7"">(15,Separator,7)</td><td class=""Item8"">(16,Item,8)</td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(17,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#88");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(13,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#89");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#90");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#91");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#92");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)(9,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#93");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#94");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)(9,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#95");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,2)(3,Separator,2)(4,Item,1)(5,Separator,1)(6,Item,3)(7,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#96");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,4)(3,Separator,4)(4,Item,1)(5,Separator,1)(6,Item,5)(7,Separator,5)(8,Item,2)(9,Separator,2)(10,Item,6)(11,Item,3)(12,Separator,3)(13,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#97");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,6)(5,Separator,6)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,7)(11,Separator,7)(12,Item,2)(13,Separator,2)(14,Item,5)(15,Separator,5)(16,Item,8)(17,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#98");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,5)(5,Separator,5)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,6)(11,Item,2)(12,Separator,2)(13,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#99");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#100");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#101");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#102");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#103");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#104");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)<br />(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)<br />(8,Item,4)<br />(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#105");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#106");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)<br />(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br />(13,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#107");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)(13,Separator,6)(14,Item,7)(15,Separator,7)(16,Item,8)<br />(17,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#108");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br />(13,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#109");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#110");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#111");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#112");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)(9,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#113");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#114");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)(9,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#115");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,2)(3,Separator,2)(4,Item,1)(5,Separator,1)(6,Item,3)(7,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#116");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,4)(3,Separator,4)(4,Item,1)(5,Separator,1)(6,Item,5)(7,Separator,5)(8,Item,2)(9,Separator,2)(10,Item,6)(11,Item,3)(12,Separator,3)(13,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#117");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,6)(5,Separator,6)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,7)(11,Separator,7)(12,Item,2)(13,Separator,2)(14,Item,5)(15,Separator,5)(16,Item,8)(17,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#118");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,5)(5,Separator,5)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,6)(11,Item,2)(12,Separator,2)(13,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#119");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#120");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#121");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(3,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#122");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""10"" class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#123");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#124");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#125");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#126");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(13,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#127");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td class=""Separator6"">(13,Separator,6)</td><td class=""Item7"">(14,Item,7)</td><td class=""Separator7"">(15,Separator,7)</td><td class=""Item8"">(16,Item,8)</td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(17,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#128");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(13,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#129");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#130");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#131");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Footer-1"">(3,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#132");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#133");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#134");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#135");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item2"">(2,Item,2)</td><td class=""Separator2"">(3,Separator,2)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Separator1"">(5,Separator,1)</td><td class=""Item3"">(6,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#136");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item4"">(2,Item,4)</td><td class=""Separator4"">(3,Separator,4)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Separator1"">(5,Separator,1)</td><td class=""Item5"">(6,Item,5)</td><td class=""Separator5"">(7,Separator,5)</td>
	</tr><tr>
		<td class=""Item2"">(8,Item,2)</td><td class=""Separator2"">(9,Separator,2)</td><td class=""Item6"">(10,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item3"">(11,Item,3)</td><td class=""Separator3"">(12,Separator,3)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""4"" class=""Footer-1"">(13,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#137");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Separator3"">(3,Separator,3)</td><td class=""Item6"">(4,Item,6)</td><td class=""Separator6"">(5,Separator,6)</td>
	</tr><tr>
		<td class=""Item1"">(6,Item,1)</td><td class=""Separator1"">(7,Separator,1)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item7"">(10,Item,7)</td><td class=""Separator7"">(11,Separator,7)</td>
	</tr><tr>
		<td class=""Item2"">(12,Item,2)</td><td class=""Separator2"">(13,Separator,2)</td><td class=""Item5"">(14,Item,5)</td><td class=""Separator5"">(15,Separator,5)</td><td class=""Item8"">(16,Item,8)</td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(17,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#138");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Separator3"">(3,Separator,3)</td><td class=""Item5"">(4,Item,5)</td><td class=""Separator5"">(5,Separator,5)</td>
	</tr><tr>
		<td class=""Item1"">(6,Item,1)</td><td class=""Separator1"">(7,Separator,1)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item6"">(10,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item2"">(11,Item,2)</td><td class=""Separator2"">(12,Separator,2)</td><td></td><td></td><td></td><td></td>
	</tr><tr>
		<td colspan=""6"" class=""Footer-1"">(13,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#139");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#140");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#141");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#142");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#143");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#144");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)<br />(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)<br />(8,Item,4)<br />(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#145");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#146");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)<br />(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br />(13,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#147");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)(13,Separator,6)(14,Item,7)(15,Separator,7)(16,Item,8)<br />(17,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#148");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br />(13,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#149");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#150");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#151");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Separator,0)<br />(2,Item,1)<br />(3,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#152");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_ftr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Separator,0)<br />(2,Item,1)<br />(3,Separator,1)<br />(4,Item,2)<br />(5,Separator,2)<br />(6,Item,3)<br />(7,Separator,3)<br />(8,Item,4)<br />(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#153");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#154");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_ftr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Separator,0)<br />(2,Item,1)<br />(3,Separator,1)<br />(4,Item,2)<br />(5,Separator,2)<br />(6,Item,3)<br />(7,Separator,3)<br />(8,Item,4)<br />(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#155");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,2)(3,Separator,2)<br />(4,Item,1)(5,Separator,1)(6,Item,3)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#156");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_ftr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,4)(3,Separator,4)<br />(4,Item,1)(5,Separator,1)(6,Item,5)(7,Separator,5)<br />(8,Item,2)(9,Separator,2)(10,Item,6)<br />(11,Item,3)(12,Separator,3)<br />(13,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#157");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,6)(5,Separator,6)<br />(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,7)(11,Separator,7)<br />(12,Item,2)(13,Separator,2)(14,Item,5)(15,Separator,5)(16,Item,8)<br />(17,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#158");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_ftr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,5)(5,Separator,5)<br />(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,6)<br />(11,Item,2)(12,Separator,2)<br />(13,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#159");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#160");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#161");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#162");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""10"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#163");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#164");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#165");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#166");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#167");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td class=""Separator6"">(14,Separator,6)</td><td class=""Item7"">(15,Item,7)</td><td class=""Separator7"">(16,Separator,7)</td><td class=""Item8"">(17,Item,8)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#168");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#169");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#170");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#171");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#172");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#173");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#174");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#175");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,2)(4,Separator,2)(5,Item,1)(6,Separator,1)(7,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#176");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,4)(4,Separator,4)(5,Item,1)(6,Separator,1)(7,Item,5)(8,Separator,5)(9,Item,2)(10,Separator,2)(11,Item,6)(12,Item,3)(13,Separator,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#177");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,6)(6,Separator,6)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,7)(12,Separator,7)(13,Item,2)(14,Separator,2)(15,Item,5)(16,Separator,5)(17,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#178");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,5)(6,Separator,5)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,6)(12,Item,2)(13,Separator,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#179");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#180");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#181");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#182");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#183");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#184");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)<br />(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)<br />(9,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#185");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#186");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)<br />(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#187");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)(14,Separator,6)(15,Item,7)(16,Separator,7)(17,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#188");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#189");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#190");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#191");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#192");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#193");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#194");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#195");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,2)(4,Separator,2)(5,Item,1)(6,Separator,1)(7,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#196");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,4)(4,Separator,4)(5,Item,1)(6,Separator,1)(7,Item,5)(8,Separator,5)(9,Item,2)(10,Separator,2)(11,Item,6)(12,Item,3)(13,Separator,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#197");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,6)(6,Separator,6)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,7)(12,Separator,7)(13,Item,2)(14,Separator,2)(15,Item,5)(16,Separator,5)(17,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#198");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, true);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,5)(6,Separator,5)(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,6)(12,Item,2)(13,Separator,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#199");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#200");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#201");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#202");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""10"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#203");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#204");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#205");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#206");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td><td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#207");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td class=""Separator6"">(14,Separator,6)</td><td class=""Item7"">(15,Item,7)</td><td class=""Separator7"">(16,Separator,7)</td><td class=""Item8"">(17,Item,8)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#208");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item1"">(3,Item,1)</td><td class=""Separator1"">(4,Separator,1)</td><td class=""Item2"">(5,Item,2)</td><td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td class=""Separator3"">(8,Separator,3)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item5"">(11,Item,5)</td><td class=""Separator5"">(12,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(13,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#209");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#210");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#211");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#212");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#213");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#214");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(2,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(4,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(6,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(8,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(9,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#215");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item2"">(3,Item,2)</td><td class=""Separator2"">(4,Separator,2)</td>
	</tr><tr>
		<td class=""Item1"">(5,Item,1)</td><td class=""Separator1"">(6,Separator,1)</td><td class=""Item3"">(7,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#216");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""4"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item4"">(3,Item,4)</td><td class=""Separator4"">(4,Separator,4)</td>
	</tr><tr>
		<td class=""Item1"">(5,Item,1)</td><td class=""Separator1"">(6,Separator,1)</td><td class=""Item5"">(7,Item,5)</td><td class=""Separator5"">(8,Separator,5)</td>
	</tr><tr>
		<td class=""Item2"">(9,Item,2)</td><td class=""Separator2"">(10,Separator,2)</td><td class=""Item6"">(11,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item3"">(12,Item,3)</td><td class=""Separator3"">(13,Separator,3)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#217");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item3"">(3,Item,3)</td><td class=""Separator3"">(4,Separator,3)</td><td class=""Item6"">(5,Item,6)</td><td class=""Separator6"">(6,Separator,6)</td>
	</tr><tr>
		<td class=""Item1"">(7,Item,1)</td><td class=""Separator1"">(8,Separator,1)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item7"">(11,Item,7)</td><td class=""Separator7"">(12,Separator,7)</td>
	</tr><tr>
		<td class=""Item2"">(13,Item,2)</td><td class=""Separator2"">(14,Separator,2)</td><td class=""Item5"">(15,Item,5)</td><td class=""Separator5"">(16,Separator,5)</td><td class=""Item8"">(17,Item,8)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#218");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""6"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Separator0"">(2,Separator,0)</td><td class=""Item3"">(3,Item,3)</td><td class=""Separator3"">(4,Separator,3)</td><td class=""Item5"">(5,Item,5)</td><td class=""Separator5"">(6,Separator,5)</td>
	</tr><tr>
		<td class=""Item1"">(7,Item,1)</td><td class=""Separator1"">(8,Separator,1)</td><td class=""Item4"">(9,Item,4)</td><td class=""Separator4"">(10,Separator,4)</td><td class=""Item6"">(11,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item2"">(12,Item,2)</td><td class=""Separator2"">(13,Separator,2)</td><td></td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#219");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#220");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#221");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#222");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)(9,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#223");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#224");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)<br />(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)<br />(9,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#225");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#226");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)<br />(5,Item,2)(6,Separator,2)(7,Item,3)(8,Separator,3)<br />(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#227");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)(14,Separator,6)(15,Item,7)(16,Separator,7)(17,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#228");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,1)(4,Separator,1)(5,Item,2)(6,Separator,2)<br />(7,Item,3)(8,Separator,3)(9,Item,4)(10,Separator,4)(11,Item,5)(12,Separator,5)<br />(13,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#229");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#230");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#231");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Separator,0)<br />(3,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#232");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_hdr_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Separator,0)<br />(3,Item,1)<br />(4,Separator,1)<br />(5,Item,2)<br />(6,Separator,2)<br />(7,Item,3)<br />(8,Separator,3)<br />(9,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#233");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#234");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_hdr_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Separator,0)<br />(3,Item,1)<br />(4,Separator,1)<br />(5,Item,2)<br />(6,Separator,2)<br />(7,Item,3)<br />(8,Separator,3)<br />(9,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#235");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,2)(4,Separator,2)<br />(5,Item,1)(6,Separator,1)(7,Item,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#236");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_hdr_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,4)(4,Separator,4)<br />(5,Item,1)(6,Separator,1)(7,Item,5)(8,Separator,5)<br />(9,Item,2)(10,Separator,2)(11,Item,6)<br />(12,Item,3)(13,Separator,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#237");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,6)(6,Separator,6)<br />(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,7)(12,Separator,7)<br />(13,Item,2)(14,Separator,2)(15,Item,5)(16,Separator,5)(17,Item,8)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#238");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_hdr_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, true);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Separator,0)(3,Item,3)(4,Separator,3)(5,Item,5)(6,Separator,5)<br />(7,Item,1)(8,Separator,1)(9,Item,4)(10,Separator,4)(11,Item,6)<br />(12,Item,2)(13,Separator,2)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#239");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#240");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#241");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#242");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#243");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#244");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#245");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#246");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#247");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td class=""Separator6"">(13,Separator,6)</td><td class=""Item7"">(14,Item,7)</td><td class=""Separator7"">(15,Separator,7)</td><td class=""Item8"">(16,Item,8)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#248");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#249");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#250");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#251");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#252");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#253");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#254");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#255");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,2)(3,Separator,2)(4,Item,1)(5,Separator,1)(6,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#256");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,4)(3,Separator,4)(4,Item,1)(5,Separator,1)(6,Item,5)(7,Separator,5)(8,Item,2)(9,Separator,2)(10,Item,6)(11,Item,3)(12,Separator,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#257");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,6)(5,Separator,6)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,7)(11,Separator,7)(12,Item,2)(13,Separator,2)(14,Item,5)(15,Separator,5)(16,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#258");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,5)(5,Separator,5)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,6)(11,Item,2)(12,Separator,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#259");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#260");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#261");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#262");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#263");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#264");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)<br />(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)<br />(8,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#265");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#266");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)<br />(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#267");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)(13,Separator,6)(14,Item,7)(15,Separator,7)(16,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#268");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#269");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#270");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#271");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#272");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#273");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#274");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#275");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,2)(3,Separator,2)(4,Item,1)(5,Separator,1)(6,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#276");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,4)(3,Separator,4)(4,Item,1)(5,Separator,1)(6,Item,5)(7,Separator,5)(8,Item,2)(9,Separator,2)(10,Item,6)(11,Item,3)(12,Separator,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#277");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,6)(5,Separator,6)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,7)(11,Separator,7)(12,Item,2)(13,Separator,2)(14,Item,5)(15,Separator,5)(16,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#278");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, true);
		string exp = @"(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,5)(5,Separator,5)(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,6)(11,Item,2)(12,Separator,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#279");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#280");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#281");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#282");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#283");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#284");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#285");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#286");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td><td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#287");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td class=""Separator6"">(13,Separator,6)</td><td class=""Item7"">(14,Item,7)</td><td class=""Separator7"">(15,Separator,7)</td><td class=""Item8"">(16,Item,8)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#288");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Separator1"">(3,Separator,1)</td><td class=""Item2"">(4,Item,2)</td><td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td class=""Separator3"">(7,Separator,3)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item5"">(10,Item,5)</td><td class=""Separator5"">(11,Separator,5)</td>
	</tr><tr>
		<td class=""Item6"">(12,Item,6)</td><td></td><td></td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#289");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#290");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#291");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#292");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#293");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#294");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Separator0"">(1,Separator,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Separator1"">(3,Separator,1)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td>
	</tr><tr>
		<td class=""Separator2"">(5,Separator,2)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td>
	</tr><tr>
		<td class=""Separator3"">(7,Separator,3)</td>
	</tr><tr>
		<td class=""Item4"">(8,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#295");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item2"">(2,Item,2)</td><td class=""Separator2"">(3,Separator,2)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Separator1"">(5,Separator,1)</td><td class=""Item3"">(6,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#296");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item4"">(2,Item,4)</td><td class=""Separator4"">(3,Separator,4)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Separator1"">(5,Separator,1)</td><td class=""Item5"">(6,Item,5)</td><td class=""Separator5"">(7,Separator,5)</td>
	</tr><tr>
		<td class=""Item2"">(8,Item,2)</td><td class=""Separator2"">(9,Separator,2)</td><td class=""Item6"">(10,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item3"">(11,Item,3)</td><td class=""Separator3"">(12,Separator,3)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#297");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Separator3"">(3,Separator,3)</td><td class=""Item6"">(4,Item,6)</td><td class=""Separator6"">(5,Separator,6)</td>
	</tr><tr>
		<td class=""Item1"">(6,Item,1)</td><td class=""Separator1"">(7,Separator,1)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item7"">(10,Item,7)</td><td class=""Separator7"">(11,Separator,7)</td>
	</tr><tr>
		<td class=""Item2"">(12,Item,2)</td><td class=""Separator2"">(13,Separator,2)</td><td class=""Item5"">(14,Item,5)</td><td class=""Separator5"">(15,Separator,5)</td><td class=""Item8"">(16,Item,8)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#298");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, true);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Separator0"">(1,Separator,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Separator3"">(3,Separator,3)</td><td class=""Item5"">(4,Item,5)</td><td class=""Separator5"">(5,Separator,5)</td>
	</tr><tr>
		<td class=""Item1"">(6,Item,1)</td><td class=""Separator1"">(7,Separator,1)</td><td class=""Item4"">(8,Item,4)</td><td class=""Separator4"">(9,Separator,4)</td><td class=""Item6"">(10,Item,6)</td><td></td>
	</tr><tr>
		<td class=""Item2"">(11,Item,2)</td><td class=""Separator2"">(12,Separator,2)</td><td></td><td></td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#299");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#300");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#301");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#302");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)(8,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#303");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#304");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)<br />(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)<br />(8,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#305");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#306");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)<br />(4,Item,2)(5,Separator,2)(6,Item,3)(7,Separator,3)<br />(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#307");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)(13,Separator,6)(14,Item,7)(15,Separator,7)(16,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#308");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,1)(3,Separator,1)(4,Item,2)(5,Separator,2)<br />(6,Item,3)(7,Separator,3)(8,Item,4)(9,Separator,4)(10,Item,5)(11,Separator,5)<br />(12,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#309");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#310");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#311");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Separator,0)<br />(2,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#312");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_sep ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Separator,0)<br />(2,Item,1)<br />(3,Separator,1)<br />(4,Item,2)<br />(5,Separator,2)<br />(6,Item,3)<br />(7,Separator,3)<br />(8,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#313");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_sep ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#314");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_sep ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Separator,0)<br />(2,Item,1)<br />(3,Separator,1)<br />(4,Item,2)<br />(5,Separator,2)<br />(6,Item,3)<br />(7,Separator,3)<br />(8,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#315");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_sep ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,2)(3,Separator,2)<br />(4,Item,1)(5,Separator,1)(6,Item,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#316");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_sep ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Separator,0)(2,Item,4)(3,Separator,4)<br />(4,Item,1)(5,Separator,1)(6,Item,5)(7,Separator,5)<br />(8,Item,2)(9,Separator,2)(10,Item,6)<br />(11,Item,3)(12,Separator,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#317");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_sep ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,6)(5,Separator,6)<br />(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,7)(11,Separator,7)<br />(12,Item,2)(13,Separator,2)(14,Item,5)(15,Separator,5)(16,Item,8)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#318");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_sep ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : True


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, true);
		string exp = @"<span>(0,Item,0)(1,Separator,0)(2,Item,3)(3,Separator,3)(4,Item,5)(5,Separator,5)<br />(6,Item,1)(7,Separator,1)(8,Item,4)(9,Separator,4)(10,Item,6)<br />(11,Item,2)(12,Separator,2)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#319");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td colspan=""0"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#320");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#321");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(3,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#322");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""5"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td>
	</tr><tr>
		<td colspan=""5"" class=""Footer-1"">(6,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#323");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#324");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(6,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#325");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#326");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#327");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td class=""Item7"">(8,Item,7)</td><td class=""Item8"">(9,Item,8)</td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#328");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#329");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#330");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#331");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#332");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)(6,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#333");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#334");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)(6,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#335");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,2)(3,Item,1)(4,Item,3)(5,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#336");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,4)(3,Item,1)(4,Item,5)(5,Item,2)(6,Item,6)(7,Item,3)(8,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#337");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,6)(4,Item,1)(5,Item,4)(6,Item,7)(7,Item,2)(8,Item,5)(9,Item,8)(10,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#338");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,5)(4,Item,1)(5,Item,4)(6,Item,6)(7,Item,2)(8,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#339");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#340");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#341");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)(3,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#342");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)(6,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#343");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#344");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)<br />(6,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#345");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br />(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#346");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br />(5,Item,4)(6,Item,5)<br />(7,Item,6)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#347");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)(8,Item,7)(9,Item,8)<br />(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#348");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, true, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#349");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#350");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#351");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#352");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)(6,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#353");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#354");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)(6,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#355");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,2)(3,Item,1)(4,Item,3)(5,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#356");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,4)(3,Item,1)(4,Item,5)(5,Item,2)(6,Item,6)(7,Item,3)(8,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#357");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,6)(4,Item,1)(5,Item,4)(6,Item,7)(7,Item,2)(8,Item,5)(9,Item,8)(10,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#358");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, true, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,5)(4,Item,1)(5,Item,4)(6,Item,6)(7,Item,2)(8,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#359");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td colspan=""0"" class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#360");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#361");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(3,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#362");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""5"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td>
	</tr><tr>
		<td colspan=""5"" class=""Footer-1"">(6,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#363");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#364");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(6,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#365");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#366");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#367");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td class=""Item7"">(8,Item,7)</td><td class=""Item8"">(9,Item,8)</td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#368");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#369");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#370");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#371");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Footer-1"">(3,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#372");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(6,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#373");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#374");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(6,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#375");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#376");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item4"">(2,Item,4)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item5"">(4,Item,5)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Item6"">(6,Item,6)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#377");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Item6"">(3,Item,6)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item7"">(6,Item,7)</td>
	</tr><tr>
		<td class=""Item2"">(7,Item,2)</td><td class=""Item5"">(8,Item,5)</td><td class=""Item8"">(9,Item,8)</td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(10,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#378");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Item5"">(3,Item,5)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item6"">(6,Item,6)</td>
	</tr><tr>
		<td class=""Item2"">(7,Item,2)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(8,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#379");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#380");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#381");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)(3,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#382");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)(6,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#383");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#384");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)<br />(6,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#385");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br />(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#386");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br />(5,Item,4)(6,Item,5)<br />(7,Item,6)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#387");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)(8,Item,7)(9,Item,8)<br />(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#388");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#389");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#390");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#391");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#392");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)<br />(6,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#393");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#394");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)<br />(6,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#395");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,2)<br />(3,Item,1)(4,Item,3)<br />(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#396");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,4)<br />(3,Item,1)(4,Item,5)<br />(5,Item,2)(6,Item,6)<br />(7,Item,3)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#397");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,3)(3,Item,6)<br />(4,Item,1)(5,Item,4)(6,Item,7)<br />(7,Item,2)(8,Item,5)(9,Item,8)<br />(10,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#398");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_hdr_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, true, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,3)(3,Item,5)<br />(4,Item,1)(5,Item,4)(6,Item,6)<br />(7,Item,2)<br />(8,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#399");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#400");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#401");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#402");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td>
	</tr><tr>
		<td colspan=""5"" class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#403");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#404");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#405");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(4,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#406");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#407");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td class=""Item7"">(7,Item,7)</td><td class=""Item8"">(8,Item,8)</td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#408");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#409");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#410");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#411");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#412");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)(5,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#413");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#414");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)(5,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#415");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,2)(2,Item,1)(3,Item,3)(4,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#416");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,4)(2,Item,1)(3,Item,5)(4,Item,2)(5,Item,6)(6,Item,3)(7,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#417");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,6)(3,Item,1)(4,Item,4)(5,Item,7)(6,Item,2)(7,Item,5)(8,Item,8)(9,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#418");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,5)(3,Item,1)(4,Item,4)(5,Item,6)(6,Item,2)(7,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#419");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#420");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#421");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#422");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#423");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#424");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)<br />(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#425");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br />(4,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#426");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br />(4,Item,4)(5,Item,5)<br />(6,Item,6)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#427");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)(7,Item,7)(8,Item,8)<br />(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#428");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, true, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#429");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#430");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#431");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#432");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)(5,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#433");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#434");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)(5,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#435");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,2)(2,Item,1)(3,Item,3)(4,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#436");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,4)(2,Item,1)(3,Item,5)(4,Item,2)(5,Item,6)(6,Item,3)(7,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#437");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,6)(3,Item,1)(4,Item,4)(5,Item,7)(6,Item,2)(7,Item,5)(8,Item,8)(9,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#438");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, true, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,5)(3,Item,1)(4,Item,4)(5,Item,6)(6,Item,2)(7,Footer,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#439");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#440");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#441");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#442");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td>
	</tr><tr>
		<td colspan=""5"" class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#443");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#444");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#445");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(4,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#446");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#447");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td class=""Item7"">(7,Item,7)</td><td class=""Item8"">(8,Item,8)</td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#448");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#449");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#450");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Footer-1"">(1,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#451");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Footer-1"">(2,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#452");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#453");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Footer-1"">(0,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#454");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr><tr>
		<td class=""Footer-1"">(5,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#455");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item2"">(1,Item,2)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(4,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#456");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item4"">(1,Item,4)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Item5"">(3,Item,5)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Item6"">(5,Item,6)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td></td>
	</tr><tr>
		<td colspan=""2"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#457");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item3"">(1,Item,3)</td><td class=""Item6"">(2,Item,6)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item7"">(5,Item,7)</td>
	</tr><tr>
		<td class=""Item2"">(6,Item,2)</td><td class=""Item5"">(7,Item,5)</td><td class=""Item8"">(8,Item,8)</td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(9,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#458");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, true, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item3"">(1,Item,3)</td><td class=""Item5"">(2,Item,5)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item6"">(5,Item,6)</td>
	</tr><tr>
		<td class=""Item2"">(6,Item,2)</td><td></td><td></td>
	</tr><tr>
		<td colspan=""3"" class=""Footer-1"">(7,Footer,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#459");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#460");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#461");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#462");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#463");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#464");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)<br />(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#465");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br />(4,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#466");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br />(4,Item,4)(5,Item,5)<br />(6,Item,6)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#467");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)(7,Item,7)(8,Item,8)<br />(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#468");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#469");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#470");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#471");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#472");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_ftr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)<br />(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#473");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_ftr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#474");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_ftr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)<br />(5,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#475");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_ftr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,2)<br />(2,Item,1)(3,Item,3)<br />(4,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#476");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_ftr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,4)<br />(2,Item,1)(3,Item,5)<br />(4,Item,2)(5,Item,6)<br />(6,Item,3)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#477");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_ftr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span>(0,Item,0)(1,Item,3)(2,Item,6)<br />(3,Item,1)(4,Item,4)(5,Item,7)<br />(6,Item,2)(7,Item,5)(8,Item,8)<br />(9,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#478");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_ftr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : True
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, true, false);
		string exp = @"<span>(0,Item,0)(1,Item,3)(2,Item,5)<br />(3,Item,1)(4,Item,4)(5,Item,6)<br />(6,Item,2)<br />(7,Footer,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#479");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#480");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#481");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#482");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""5"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#483");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#484");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#485");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#486");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#487");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td class=""Item7"">(8,Item,7)</td><td class=""Item8"">(9,Item,8)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#488");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, true, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#489");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#490");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#491");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#492");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#493");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#494");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#495");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,2)(3,Item,1)(4,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#496");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,4)(3,Item,1)(4,Item,5)(5,Item,2)(6,Item,6)(7,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#497");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,6)(4,Item,1)(5,Item,4)(6,Item,7)(7,Item,2)(8,Item,5)(9,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#498");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,5)(4,Item,1)(5,Item,4)(6,Item,6)(7,Item,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#499");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#500");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#501");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#502");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#503");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#504");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#505");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#506");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br />(5,Item,4)(6,Item,5)<br />(7,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#507");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)(8,Item,7)(9,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#508");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, true, false, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#509");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#510");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#511");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#512");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#513");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)";
		HtmlDiff.AssertAreEqual (exp, v, "#514");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#515");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,2)(3,Item,1)(4,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#516");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,4)(3,Item,1)(4,Item,5)(5,Item,2)(6,Item,6)(7,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#517");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,6)(4,Item,1)(5,Item,4)(6,Item,7)(7,Item,2)(8,Item,5)(9,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#518");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, true, false, false);
		string exp = @"(0,Header,-1)(1,Item,0)(2,Item,3)(3,Item,5)(4,Item,1)(5,Item,4)(6,Item,6)(7,Item,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#519");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""0"" class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#520");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#521");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#522");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""5"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#523");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#524");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#525");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#526");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td><td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#527");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td class=""Item7"">(8,Item,7)</td><td class=""Item8"">(9,Item,8)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#528");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item1"">(2,Item,1)</td><td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item5"">(6,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(7,Item,6)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#529");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#530");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#531");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#532");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#533");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#534");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(3,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(4,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(5,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#535");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item3"">(4,Item,3)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#536");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td colspan=""2"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item4"">(2,Item,4)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item5"">(4,Item,5)</td>
	</tr><tr>
		<td class=""Item2"">(5,Item,2)</td><td class=""Item6"">(6,Item,6)</td>
	</tr><tr>
		<td class=""Item3"">(7,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#537");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Item6"">(3,Item,6)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item7"">(6,Item,7)</td>
	</tr><tr>
		<td class=""Item2"">(7,Item,2)</td><td class=""Item5"">(8,Item,5)</td><td class=""Item8"">(9,Item,8)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#538");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, true, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td colspan=""3"" class=""Header-1"">(0,Header,-1)</td>
	</tr><tr>
		<td class=""Item0"">(1,Item,0)</td><td class=""Item3"">(2,Item,3)</td><td class=""Item5"">(3,Item,5)</td>
	</tr><tr>
		<td class=""Item1"">(4,Item,1)</td><td class=""Item4"">(5,Item,4)</td><td class=""Item6"">(6,Item,6)</td>
	</tr><tr>
		<td class=""Item2"">(7,Item,2)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#539");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#540");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#541");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#542");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)(1,Item,0)(2,Item,1)(3,Item,2)(4,Item,3)(5,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#543");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#544");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#545");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#546");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,1)<br />(3,Item,2)(4,Item,3)<br />(5,Item,4)(6,Item,5)<br />(7,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#547");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)(8,Item,7)(9,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#548");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,1)(3,Item,2)<br />(4,Item,3)(5,Item,4)(6,Item,5)<br />(7,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#549");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#550");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#551");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#552");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_hdr ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#553");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_hdr ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#554");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_hdr ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)<br />(2,Item,1)<br />(3,Item,2)<br />(4,Item,3)<br />(5,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#555");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_hdr ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,2)<br />(3,Item,1)(4,Item,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#556");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_hdr ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span class=""mainstyle"">(0,Header,-1)<br />(1,Item,0)(2,Item,4)<br />(3,Item,1)(4,Item,5)<br />(5,Item,2)(6,Item,6)<br />(7,Item,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#557");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_hdr ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,3)(3,Item,6)<br />(4,Item,1)(5,Item,4)(6,Item,7)<br />(7,Item,2)(8,Item,5)(9,Item,8)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#558");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_hdr ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : True
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, true, false, false);
		string exp = @"<span>(0,Header,-1)<br />(1,Item,0)(2,Item,3)(3,Item,5)<br />(4,Item,1)(5,Item,4)(6,Item,6)<br />(7,Item,2)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#559");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#560");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#561");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#562");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#563");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#564");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#565");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#566");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#567");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td class=""Item7"">(7,Item,7)</td><td class=""Item8"">(8,Item,8)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#568");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, true, false, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#569");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#570");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#571");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#572");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#573");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#574");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#575");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,2)(2,Item,1)(3,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#576");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,4)(2,Item,1)(3,Item,5)(4,Item,2)(5,Item,6)(6,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#577");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,6)(3,Item,1)(4,Item,4)(5,Item,7)(6,Item,2)(7,Item,5)(8,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#578");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,5)(3,Item,1)(4,Item,4)(5,Item,6)(6,Item,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#579");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#580");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#581");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#582");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#583");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#584");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#585");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#586");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br />(4,Item,4)(5,Item,5)<br />(6,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#587");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)(7,Item,7)(8,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#588");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, true, false, false, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#589");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#590");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)";
		HtmlDiff.AssertAreEqual (exp, v, "#591");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,1)";
		HtmlDiff.AssertAreEqual (exp, v, "#592");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow_otrtblimp ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#593");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"";
		HtmlDiff.AssertAreEqual (exp, v, "#594");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow_otrtblimp ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)";
		HtmlDiff.AssertAreEqual (exp, v, "#595");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,2)(2,Item,1)(3,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#596");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow_otrtblimp ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,4)(2,Item,1)(3,Item,5)(4,Item,2)(5,Item,6)(6,Item,3)";
		HtmlDiff.AssertAreEqual (exp, v, "#597");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,6)(3,Item,1)(4,Item,4)(5,Item,7)(6,Item,2)(7,Item,5)(8,Item,8)";
		HtmlDiff.AssertAreEqual (exp, v, "#598");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow_otrtblimp ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : True
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, true, false, false, false);
		string exp = @"(0,Item,0)(1,Item,3)(2,Item,5)(3,Item,1)(4,Item,4)(5,Item,6)(6,Item,2)";
		HtmlDiff.AssertAreEqual (exp, v, "#599");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_tbl ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#600");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_tbl ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#601");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_tbl ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#602");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_tbl ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#603");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_tbl ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#604");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_tbl ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#605");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_tbl ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#606");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_tbl ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td><td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#607");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_tbl ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td class=""Item7"">(7,Item,7)</td><td class=""Item8"">(8,Item,8)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#608");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_tbl ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item1"">(1,Item,1)</td><td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item5"">(5,Item,5)</td>
	</tr><tr>
		<td class=""Item6"">(6,Item,6)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#609");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_tbl ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#610");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_tbl ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#611");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_tbl ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#612");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_tbl ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#613");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_tbl ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">

</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#614");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_tbl ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td>
	</tr><tr>
		<td class=""Item1"">(1,Item,1)</td>
	</tr><tr>
		<td class=""Item2"">(2,Item,2)</td>
	</tr><tr>
		<td class=""Item3"">(3,Item,3)</td>
	</tr><tr>
		<td class=""Item4"">(4,Item,4)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#615");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_tbl ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item2"">(1,Item,2)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Item3"">(3,Item,3)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#616");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_tbl ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table class=""mainstyle"" border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item4"">(1,Item,4)</td>
	</tr><tr>
		<td class=""Item1"">(2,Item,1)</td><td class=""Item5"">(3,Item,5)</td>
	</tr><tr>
		<td class=""Item2"">(4,Item,2)</td><td class=""Item6"">(5,Item,6)</td>
	</tr><tr>
		<td class=""Item3"">(6,Item,3)</td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#617");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_tbl ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item3"">(1,Item,3)</td><td class=""Item6"">(2,Item,6)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item7"">(5,Item,7)</td>
	</tr><tr>
		<td class=""Item2"">(6,Item,2)</td><td class=""Item5"">(7,Item,5)</td><td class=""Item8"">(8,Item,8)</td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#618");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_tbl ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Table
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Table, false, false, false, false);
		string exp = @"<table border=""0"">
	<tr>
		<td class=""Item0"">(0,Item,0)</td><td class=""Item3"">(1,Item,3)</td><td class=""Item5"">(2,Item,5)</td>
	</tr><tr>
		<td class=""Item1"">(3,Item,1)</td><td class=""Item4"">(4,Item,4)</td><td class=""Item6"">(5,Item,6)</td>
	</tr><tr>
		<td class=""Item2"">(6,Item,2)</td><td></td><td></td>
	</tr>
</table>";
		HtmlDiff.AssertAreEqual (exp, v, "#619");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_horiz_flow ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#620");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_horiz_flow ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#621");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_horiz_flow ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#622");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_horiz_flow ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)(2,Item,2)(3,Item,3)(4,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#623");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_horiz_flow ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#624");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_horiz_flow ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#625");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_horiz_flow ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#626");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_horiz_flow ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,1)<br />(2,Item,2)(3,Item,3)<br />(4,Item,4)(5,Item,5)<br />(6,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#627");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_horiz_flow ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)(7,Item,7)(8,Item,8)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#628");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_horiz_flow ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Horizontal
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Horizontal, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span>(0,Item,0)(1,Item,1)(2,Item,2)<br />(3,Item,3)(4,Item,4)(5,Item,5)<br />(6,Item,6)<br /></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#629");
	}


	[Test]
	public void RepeatInfo_0cols_0itms_vert_flow ()
	{
 		// cols              : 0
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#630");
	}


	[Test]
	public void RepeatInfo_0cols_1itms_vert_flow ()
	{
 		// cols              : 0
		// cnt               : 1
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 1, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#631");
	}


	[Test]
	public void RepeatInfo_0cols_2itms_vert_flow ()
	{
 		// cols              : 0
		// cnt               : 2
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 2, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#632");
	}


	[Test]
	public void RepeatInfo_0cols_5itms_vert_flow ()
	{
 		// cols              : 0
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (0, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#633");
	}


	[Test]
	public void RepeatInfo_1cols_0itms_vert_flow ()
	{
 		// cols              : 1
		// cnt               : 0
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 0, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle""></span>";
		HtmlDiff.AssertAreEqual (exp, v, "#634");
	}


	[Test]
	public void RepeatInfo_1cols_5itms_vert_flow ()
	{
 		// cols              : 1
		// cnt               : 5
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (1, 5, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)<br />(1,Item,1)<br />(2,Item,2)<br />(3,Item,3)<br />(4,Item,4)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#635");
	}


	[Test]
	public void RepeatInfo_2cols_4itms_vert_flow ()
	{
 		// cols              : 2
		// cnt               : 4
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 4, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,2)<br />(2,Item,1)(3,Item,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#636");
	}


	[Test]
	public void RepeatInfo_2cols_7itms_vert_flow ()
	{
 		// cols              : 2
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (2, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span class=""mainstyle"">(0,Item,0)(1,Item,4)<br />(2,Item,1)(3,Item,5)<br />(4,Item,2)(5,Item,6)<br />(6,Item,3)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#637");
	}


	[Test]
	public void RepeatInfo_3cols_9itms_vert_flow ()
	{
 		// cols              : 3
		// cnt               : 9
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 9, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span>(0,Item,0)(1,Item,3)(2,Item,6)<br />(3,Item,1)(4,Item,4)(5,Item,7)<br />(6,Item,2)(7,Item,5)(8,Item,8)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#638");
	}


	[Test]
	public void RepeatInfo_3cols_7itms_vert_flow ()
	{
 		// cols              : 3
		// cnt               : 7
		// RepeatDirection   : Vertical
		// RepeatLayout      : Flow
		// OuterTableImplied : False
		// Header            : False
		// Footer            : False
		// Separator         : False


		string v = RepeatInfoUser.DoTest (3, 7, RepeatDirection.Vertical, RepeatLayout.Flow, false, false, false, false);
		string exp = @"<span>(0,Item,0)(1,Item,3)(2,Item,5)<br />(3,Item,1)(4,Item,4)(5,Item,6)<br />(6,Item,2)</span>";
		HtmlDiff.AssertAreEqual (exp, v, "#639");
	}


}
}
#endif
