export type MinimizedResult = import('./index').MinimizedResult;
export type CustomOptions = import('./index').CustomOptions;
/** @typedef {import('./index').MinimizedResult} MinimizedResult */
/** @typedef {import('./index').CustomOptions} CustomOptions */
/**
 * @template T
 * @param {import('./index').InternalOptions<T>} options
 * @returns {Promise<MinimizedResult>}
 */
export function minify<T>(
  options: import('./index').InternalOptions<T>
): Promise<MinimizedResult>;
/**
 * @param {string} options
 * @returns {Promise<MinimizedResult>}
 */
export function transform(options: string): Promise<MinimizedResult>;
