// sort-object-keys
import { NpmClientEnum } from '@umijs/utils';
import type { Root } from '@umijs/utils/compiled/@hapi/joi';

export function getSchemas(): Record<string, (Joi: Root) => any> {
  return {
    base: (Joi) =>
      Joi.string().label('base').pattern(/\/$/, { name: `"endsWith '/'"` }),
    conventionRoutes: (Joi) =>
      Joi.object({
        base: Joi.string(),
        exclude: Joi.array().items(Joi.any()),
      }),
    headScripts: (Joi) => Joi.array(),
    history: (Joi) =>
      Joi.object({
        type: Joi.string().valid('browser', 'hash', 'memory'),
      }),
    historyWithQuery: (Joi) => Joi.object(),
    links: (Joi) => Joi.array(),
    metas: (Joi) => Joi.array(),
    mountElementId: (Joi) => Joi.string(),
    npmClient: (Joi) =>
      Joi.string().valid(
        NpmClientEnum.pnpm,
        NpmClientEnum.tnpm,
        NpmClientEnum.cnpm,
        NpmClientEnum.yarn,
        NpmClientEnum.npm,
      ),
    plugins: (Joi) => Joi.array().items(Joi.string()),
    presets: (Joi) => Joi.array().items(Joi.string()),
    publicPath: (Joi) =>
      Joi.string()
        .regex(/(\/|^auto)$/)
        .error(new Error('publicPath must be "auto" or end with /')),
    reactRouter5Compat: (Joi) => Joi.object(),
    routes: (Joi) => Joi.array().items(Joi.object()),
    scripts: (Joi) => Joi.array(),
    styles: (Joi) => Joi.array(),
    title: (Joi) => Joi.string(),
  };
}
