/*******************************************************************************
 * Copyright (c) 2017 Eclipse RDF4J contributors, Aduna, and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Distribution License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *******************************************************************************/
package org.eclipse.rdf4j.repository.manager;

import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;

public class SystemRepositoryFactory implements RepositoryFactory {

	@Override
	public String getRepositoryType() {
		return SystemRepository.REPOSITORY_TYPE;
	}

	@Override
	public RepositoryImplConfig getConfig() {
		return new SystemRepositoryConfig();
	}

	@Override
	public Repository getRepository(RepositoryImplConfig config)
		throws RepositoryConfigException
	{
		return new SystemRepository();
	}

}
