/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.lang.model.type.TypeMirror;

public class VisitorState {
    private final DescriptionListener descriptionListener;
    public final Context context;
    private final TreePath path;
    private final Map<String, BugPattern.SeverityLevel> severityMap;
    private final ErrorProneOptions errorProneOptions;
    private final LoadingCache<String, Optional<Type>> typeCache;
    private static final DescriptionListener NULL_LISTENER = new DescriptionListener(){

        @Override
        public void onDescribed(Description description) {
        }
    };

    public VisitorState(Context context) {
        this(context, NULL_LISTENER);
    }

    public VisitorState(Context context, DescriptionListener listener) {
        this(context, listener, Collections.emptyMap(), ErrorProneOptions.empty());
    }

    public VisitorState(Context context, DescriptionListener listener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions) {
        this(context, null, listener, severityMap, errorProneOptions, null);
    }

    private VisitorState(Context context, TreePath path, DescriptionListener descriptionListener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions, LoadingCache<String, Optional<Type>> typeCache) {
        this.context = context;
        this.path = path;
        this.descriptionListener = descriptionListener;
        this.severityMap = severityMap;
        this.errorProneOptions = errorProneOptions;
        this.typeCache = typeCache != null ? typeCache : CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<Type>>(){

            public Optional<Type> load(String key) throws Exception {
                return Optional.fromNullable((Object)VisitorState.this.getTypeFromStringInternal(key));
            }
        });
    }

    public VisitorState withPath(TreePath path) {
        return new VisitorState(this.context, path, this.descriptionListener, this.severityMap, this.errorProneOptions, this.typeCache);
    }

    public TreePath getPath() {
        return this.path;
    }

    public TreeMaker getTreeMaker() {
        return TreeMaker.instance(this.context);
    }

    public Types getTypes() {
        return Types.instance(this.context);
    }

    public Symtab getSymtab() {
        return Symtab.instance(this.context);
    }

    public NullnessAnalysis getNullnessAnalysis() {
        return NullnessAnalysis.instance(this.context);
    }

    public ErrorProneOptions errorProneOptions() {
        return this.errorProneOptions;
    }

    public void reportMatch(Description description) {
        BugPattern.SeverityLevel override = this.severityMap.get(description.checkName);
        if (override != null) {
            description = description.applySeverityOverride(override);
        }
        this.descriptionListener.onDescribed(description);
    }

    public Name getName(String nameStr) {
        return Names.instance(this.context).fromString(nameStr);
    }

    public Type getTypeFromString(String typeStr) {
        try {
            return (Type)((Optional)this.typeCache.get((Object)typeStr)).orNull();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private Type getTypeFromStringInternal(String typeStr) {
        VisitorState.validateTypeStr(typeStr);
        if (VisitorState.isPrimitiveType(typeStr)) {
            return this.getPrimitiveType(typeStr);
        }
        Name typeName = this.getName(typeStr);
        try {
            Symbol.ClassSymbol typeSymbol = (Symbol.ClassSymbol)((Object)this.getSymtab().classes.get(typeName));
            if (typeSymbol == null) {
                JavaCompiler compiler = JavaCompiler.instance(this.context);
                Symbol sym = compiler.resolveIdent(typeStr);
                if (!(sym instanceof Symbol.ClassSymbol)) {
                    return null;
                }
                typeSymbol = (Symbol.ClassSymbol)sym;
            }
            TypeMirror type = typeSymbol.asType();
            ((Type)type).complete();
            if (((Type)type).isErroneous()) {
                return null;
            }
            return type;
        }
        catch (Symbol.CompletionFailure failure) {
            return null;
        }
    }

    public Symbol getSymbolFromString(String symStr) {
        try {
            Name symName = this.getName(symStr);
            Symbol result = (Symbol)((Object)this.getSymtab().classes.get(symName));
            if (result != null) {
                result.complete();
            }
            return result;
        }
        catch (Symbol.CompletionFailure failure) {
            return null;
        }
    }

    public Type getType(Type baseType, boolean isArray, List<Type> typeParams) {
        boolean isGeneric;
        boolean bl = isGeneric = typeParams != null && !typeParams.equals(List.nil());
        if (!isArray && !isGeneric) {
            return baseType;
        }
        if (isArray && !isGeneric) {
            Symbol.ClassSymbol arraySymbol = this.getSymtab().arrayClass;
            return new Type.ArrayType(baseType, arraySymbol);
        }
        if (!isArray && isGeneric) {
            return new Type.ClassType(Type.noType, typeParams, baseType.tsym);
        }
        throw new IllegalArgumentException("Unsupported arguments to getType");
    }

    public Type getType(Type baseType, boolean isArray, java.util.List<Type> typeParams) {
        boolean isGeneric;
        boolean bl = isGeneric = typeParams != null && !typeParams.equals(List.nil());
        if (!isArray && !isGeneric) {
            return baseType;
        }
        if (isArray && !isGeneric) {
            Symbol.ClassSymbol arraySymbol = this.getSymtab().arrayClass;
            return new Type.ArrayType(baseType, arraySymbol);
        }
        if (!isArray && isGeneric) {
            List<Type> typeParamsCopy = List.from(typeParams.toArray(new Type[typeParams.size()]));
            return new Type.ClassType(Type.noType, typeParamsCopy, baseType.tsym);
        }
        throw new IllegalArgumentException("Unsupported arguments to getType");
    }

    @SafeVarargs
    public final TreePath findPathToEnclosing(Class<? extends Tree> ... classes) {
        for (TreePath enclosingPath = this.getPath(); enclosingPath != null; enclosingPath = enclosingPath.getParentPath()) {
            for (Class<? extends Tree> clazz : classes) {
                if (!clazz.isInstance(enclosingPath.getLeaf())) continue;
                return enclosingPath;
            }
        }
        return null;
    }

    @SafeVarargs
    public final <T extends Tree> T findEnclosing(Class<? extends T> ... classes) {
        TreePath pathToEnclosing = this.findPathToEnclosing(classes);
        return (T)(pathToEnclosing == null ? null : pathToEnclosing.getLeaf());
    }

    public CharSequence getSourceCode() {
        try {
            return this.getPath().getCompilationUnit().getSourceFile().getCharContent(false);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getSourceForNode(Tree tree) {
        JCTree node = (JCTree)tree;
        int start = node.getStartPosition();
        int end = this.getEndPosition(node);
        if (end < 0) {
            return null;
        }
        return this.getSourceCode().subSequence(start, end).toString();
    }

    public ImmutableList<ErrorProneToken> getTokensForNode(Tree tree) {
        return ErrorProneTokens.getTokens(this.getSourceForNode(tree), this.context);
    }

    public int getEndPosition(Tree node) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)this.getPath().getCompilationUnit();
        if (compilationUnit.endPositions == null) {
            return -1;
        }
        return ((JCTree)node).getEndPosition(compilationUnit.endPositions);
    }

    private static void validateTypeStr(String typeStr) {
        if (typeStr.contains("[") || typeStr.contains("]")) {
            throw new IllegalArgumentException("Cannot convert array types, please build them using getType()");
        }
        if (typeStr.contains("<") || typeStr.contains(">")) {
            throw new IllegalArgumentException("Cannot covnert generic types, please build them using getType()");
        }
    }

    private Type getPrimitiveType(String typeStr) {
        if (typeStr.equals("byte")) {
            return this.getSymtab().byteType;
        }
        if (typeStr.equals("short")) {
            return this.getSymtab().shortType;
        }
        if (typeStr.equals("int")) {
            return this.getSymtab().intType;
        }
        if (typeStr.equals("long")) {
            return this.getSymtab().longType;
        }
        if (typeStr.equals("float")) {
            return this.getSymtab().floatType;
        }
        if (typeStr.equals("double")) {
            return this.getSymtab().doubleType;
        }
        if (typeStr.equals("boolean")) {
            return this.getSymtab().booleanType;
        }
        if (typeStr.equals("char")) {
            return this.getSymtab().charType;
        }
        throw new IllegalStateException("Type string " + typeStr + " expected to be primitive");
    }

    private static boolean isPrimitiveType(String typeStr) {
        return typeStr.equals("byte") || typeStr.equals("short") || typeStr.equals("int") || typeStr.equals("long") || typeStr.equals("float") || typeStr.equals("double") || typeStr.equals("boolean") || typeStr.equals("char");
    }

    public boolean isAndroidCompatible() {
        return Options.instance(this.context).getBoolean("androidCompatible");
    }
}

