/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.errorprone.apply.FileDestination;
import com.google.errorprone.apply.SourceFile;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class PatchFileDestination
implements FileDestination {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private final Path baseDir;
    private final Path rootPath;
    private final Map<String, String> diffByFile = new TreeMap<String, String>();

    public PatchFileDestination(Path baseDir, Path rootPath) {
        this.baseDir = baseDir;
        this.rootPath = rootPath;
    }

    @Override
    public void writeFile(SourceFile update) throws IOException {
        String newSource;
        Path originalFilePath = this.rootPath.resolve(update.getPath());
        String oldSource = new String(Files.readAllBytes(originalFilePath), StandardCharsets.UTF_8);
        if (!oldSource.equals(newSource = update.getSourceText())) {
            List originalLines = LINE_SPLITTER.splitToList((CharSequence)oldSource);
            Patch diff = DiffUtils.diff((List)originalLines, (List)LINE_SPLITTER.splitToList((CharSequence)newSource));
            String relativePath = this.relativize(update);
            List unifiedDiff = DiffUtils.generateUnifiedDiff((String)relativePath, (String)relativePath, (List)originalLines, (Patch)diff, (int)2);
            String diffString = Joiner.on((String)"\n").join((Iterable)unifiedDiff);
            this.diffByFile.put(originalFilePath.toString(), diffString);
        }
    }

    private String relativize(SourceFile update) {
        return this.baseDir.relativize(this.rootPath.resolve(update.getPath())).toString();
    }

    public String patchFile() {
        return this.diffByFile.values().stream().collect(Collectors.joining("\n"));
    }

    @Override
    public void flush() throws IOException {
    }
}

