/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue.client;

import com.hazelcast.collection.impl.queue.client.QueueRequest;
import com.hazelcast.collection.impl.queue.operations.CompareAndRemoveOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;

public class CompareAndRemoveRequest
extends QueueRequest {
    private Collection<Data> dataList;
    private boolean retain;

    public CompareAndRemoveRequest() {
    }

    public CompareAndRemoveRequest(String name, Collection<Data> dataList, boolean retain) {
        super(name);
        this.dataList = dataList;
        this.retain = retain;
    }

    @Override
    protected Operation prepareOperation() {
        return new CompareAndRemoveOperation(this.name, this.dataList, this.retain);
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeBoolean("r", this.retain);
        writer.writeInt("s", this.dataList.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data data : this.dataList) {
            out.writeData(data);
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.retain = reader.readBoolean("r");
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = in.readData();
            this.dataList.add(data);
        }
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "remove");
    }

    @Override
    public String getMethodName() {
        if (this.retain) {
            return "retainAll";
        }
        return "removeAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.dataList};
    }
}

