/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.OutboundFrame;
import java.nio.ByteBuffer;

public final class Packet
extends HeapData
implements OutboundFrame {
    public static final byte VERSION = 4;
    public static final int HEADER_OP = 0;
    public static final int HEADER_RESPONSE = 1;
    public static final int HEADER_EVENT = 2;
    public static final int HEADER_WAN_REPLICATION = 3;
    public static final int HEADER_URGENT = 4;
    public static final int HEADER_BIND = 5;
    private static final short PERSIST_VERSION = 1;
    private static final short PERSIST_HEADER = 2;
    private static final short PERSIST_PARTITION = 3;
    private static final short PERSIST_SIZE = 4;
    private static final short PERSIST_VALUE = 5;
    private static final short PERSIST_COMPLETED = Short.MAX_VALUE;
    private short header;
    private int partitionId;
    private transient Connection conn;
    private int valueOffset;
    private int size;
    private short persistStatus;

    public Packet() {
    }

    public Packet(byte[] payload) {
        this(payload, -1);
    }

    public Packet(byte[] payload, int partitionId) {
        super(payload);
        this.partitionId = partitionId;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void setHeader(int bit) {
        this.header = (short)(this.header | 1 << bit);
    }

    public boolean isHeaderSet(int bit) {
        return (this.header & 1 << bit) != 0;
    }

    public short getHeader() {
        return this.header;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isUrgent() {
        return this.isHeaderSet(4);
    }

    public boolean writeTo(ByteBuffer dst) {
        if (!this.writeVersion(dst)) {
            return false;
        }
        if (!this.writeHeader(dst)) {
            return false;
        }
        if (!this.writePartition(dst)) {
            return false;
        }
        if (!this.writeSize(dst)) {
            return false;
        }
        if (!this.writeValue(dst)) {
            return false;
        }
        this.setPersistStatus((short)Short.MAX_VALUE);
        return true;
    }

    public boolean readFrom(ByteBuffer src) {
        if (!this.readVersion(src)) {
            return false;
        }
        if (!this.readHeader(src)) {
            return false;
        }
        if (!this.readPartition(src)) {
            return false;
        }
        if (!this.readSize(src)) {
            return false;
        }
        if (!this.readValue(src)) {
            return false;
        }
        this.setPersistStatus((short)Short.MAX_VALUE);
        return true;
    }

    private boolean readVersion(ByteBuffer src) {
        if (!this.isPersistStatusSet((short)1)) {
            if (!src.hasRemaining()) {
                return false;
            }
            byte version = src.get();
            this.setPersistStatus((short)1);
            if (4 != version) {
                throw new IllegalArgumentException("Packet versions are not matching! Expected -> 4, Incoming -> " + version);
            }
        }
        return true;
    }

    private boolean writeVersion(ByteBuffer dst) {
        if (!this.isPersistStatusSet((short)1)) {
            if (!dst.hasRemaining()) {
                return false;
            }
            dst.put((byte)4);
            this.setPersistStatus((short)1);
        }
        return true;
    }

    private boolean readHeader(ByteBuffer src) {
        if (!this.isPersistStatusSet((short)2)) {
            if (src.remaining() < 2) {
                return false;
            }
            this.header = src.getShort();
            this.setPersistStatus((short)2);
        }
        return true;
    }

    private boolean writeHeader(ByteBuffer dst) {
        if (!this.isPersistStatusSet((short)2)) {
            if (dst.remaining() < 2) {
                return false;
            }
            dst.putShort(this.header);
            this.setPersistStatus((short)2);
        }
        return true;
    }

    private boolean readPartition(ByteBuffer src) {
        if (!this.isPersistStatusSet((short)3)) {
            if (src.remaining() < 4) {
                return false;
            }
            this.partitionId = src.getInt();
            this.setPersistStatus((short)3);
        }
        return true;
    }

    private boolean writePartition(ByteBuffer dst) {
        if (!this.isPersistStatusSet((short)3)) {
            if (dst.remaining() < 4) {
                return false;
            }
            dst.putInt(this.partitionId);
            this.setPersistStatus((short)3);
        }
        return true;
    }

    private boolean readSize(ByteBuffer src) {
        if (!this.isPersistStatusSet((short)4)) {
            if (src.remaining() < 4) {
                return false;
            }
            this.size = src.getInt();
            this.setPersistStatus((short)4);
        }
        return true;
    }

    private boolean writeSize(ByteBuffer dst) {
        if (!this.isPersistStatusSet((short)4)) {
            if (dst.remaining() < 4) {
                return false;
            }
            this.size = this.totalSize();
            dst.putInt(this.size);
            this.setPersistStatus((short)4);
        }
        return true;
    }

    private boolean readValue(ByteBuffer src) {
        if (!this.isPersistStatusSet((short)5)) {
            if (this.payload == null) {
                this.payload = new byte[this.size];
            }
            if (this.size > 0) {
                boolean done;
                int bytesRead;
                int bytesNeeded;
                int bytesReadable = src.remaining();
                if (bytesReadable >= (bytesNeeded = this.size - this.valueOffset)) {
                    bytesRead = bytesNeeded;
                    done = true;
                } else {
                    bytesRead = bytesReadable;
                    done = false;
                }
                src.get(this.payload, this.valueOffset, bytesRead);
                this.valueOffset += bytesRead;
                if (!done) {
                    return false;
                }
            }
            this.setPersistStatus((short)5);
        }
        return true;
    }

    private boolean writeValue(ByteBuffer dst) {
        if (!this.isPersistStatusSet((short)5)) {
            if (this.size > 0) {
                boolean done;
                int bytesWrite;
                int bytesNeeded;
                int bytesWritable = dst.remaining();
                if (bytesWritable >= (bytesNeeded = this.size - this.valueOffset)) {
                    bytesWrite = bytesNeeded;
                    done = true;
                } else {
                    bytesWrite = bytesWritable;
                    done = false;
                }
                byte[] byteArray = this.toByteArray();
                dst.put(byteArray, this.valueOffset, bytesWrite);
                this.valueOffset += bytesWrite;
                if (!done) {
                    return false;
                }
            }
            this.setPersistStatus((short)5);
        }
        return true;
    }

    public int packetSize() {
        return (this.payload != null ? this.totalSize() : 0) + 11;
    }

    public boolean done() {
        return this.isPersistStatusSet((short)Short.MAX_VALUE);
    }

    public void reset() {
        this.payload = null;
        this.persistStatus = 0;
    }

    private void setPersistStatus(short persistStatus) {
        this.persistStatus = persistStatus;
    }

    private boolean isPersistStatusSet(short status) {
        return this.persistStatus >= status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Packet)) {
            return false;
        }
        Packet packet = (Packet)o;
        if (!super.equals(packet)) {
            return false;
        }
        if (this.header != packet.header) {
            return false;
        }
        return this.partitionId == packet.partitionId;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.header;
        result = 31 * result + this.partitionId;
        return result;
    }

    @Override
    public String toString() {
        return "Packet{header=" + this.header + ", isResponse=" + this.isHeaderSet(1) + ", isOperation=" + this.isHeaderSet(0) + ", isEvent=" + this.isHeaderSet(2) + ", partitionId=" + this.partitionId + ", conn=" + this.conn + '}';
    }
}

