/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.PatternReferenceTypeSpec;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.util.ArrayList;

abstract class EventRequestSpec {
    final ReferenceTypeSpec refSpec;
    int suspendPolicy = 2;
    EventRequest resolved = null;
    ClassPrepareRequest prepareRequest = null;

    EventRequestSpec(ReferenceTypeSpec refSpec) {
        this.refSpec = refSpec;
    }

    abstract EventRequest resolveEventRequest(ReferenceType var1) throws Exception;

    synchronized EventRequest resolve(ClassPrepareEvent event) throws Exception {
        if (this.resolved == null && this.prepareRequest != null && this.prepareRequest.equals(event.request())) {
            PatternReferenceTypeSpec prs;
            this.resolved = this.resolveEventRequest(event.referenceType());
            this.prepareRequest.disable();
            Env.vm().eventRequestManager().deleteEventRequest(this.prepareRequest);
            this.prepareRequest = null;
            if (this.refSpec instanceof PatternReferenceTypeSpec && !(prs = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
                this.resolved = null;
                this.prepareRequest = this.refSpec.createPrepareRequest();
                this.prepareRequest.enable();
            }
        }
        return this.resolved;
    }

    synchronized void remove() {
        PatternReferenceTypeSpec prs;
        if (this.isResolved()) {
            Env.vm().eventRequestManager().deleteEventRequest(this.resolved());
        }
        if (this.refSpec instanceof PatternReferenceTypeSpec && !(prs = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
            ArrayList<ExceptionRequest> deleteList = new ArrayList<ExceptionRequest>();
            for (ExceptionRequest er : Env.vm().eventRequestManager().exceptionRequests()) {
                if (!prs.matches(er.exception())) continue;
                deleteList.add(er);
            }
            Env.vm().eventRequestManager().deleteEventRequests(deleteList);
        }
    }

    private EventRequest resolveAgainstPreparedClasses() throws Exception {
        for (ReferenceType refType : Env.vm().allClasses()) {
            if (!refType.isPrepared() || !this.refSpec.matches(refType)) continue;
            this.resolved = this.resolveEventRequest(refType);
        }
        return this.resolved;
    }

    synchronized EventRequest resolveEagerly() throws Exception {
        try {
            PatternReferenceTypeSpec prs;
            if (this.resolved == null) {
                this.prepareRequest = this.refSpec.createPrepareRequest();
                this.prepareRequest.enable();
                this.resolveAgainstPreparedClasses();
                if (this.resolved != null) {
                    this.prepareRequest.disable();
                    Env.vm().eventRequestManager().deleteEventRequest(this.prepareRequest);
                    this.prepareRequest = null;
                }
            }
            if (this.refSpec instanceof PatternReferenceTypeSpec && !(prs = (PatternReferenceTypeSpec)this.refSpec).isUnique()) {
                this.resolved = null;
                if (this.prepareRequest == null) {
                    this.prepareRequest = this.refSpec.createPrepareRequest();
                    this.prepareRequest.enable();
                }
            }
        }
        catch (VMNotConnectedException vMNotConnectedException) {
            // empty catch block
        }
        return this.resolved;
    }

    EventRequest resolved() {
        return this.resolved;
    }

    boolean isResolved() {
        return this.resolved != null;
    }

    protected boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        int cp = s.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    String errorMessageFor(Exception e) {
        if (e instanceof IllegalArgumentException) {
            return MessageOutput.format("Invalid command syntax");
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return MessageOutput.format("Internal error; unable to set", this.refSpec.toString());
    }
}

