/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VMState;

public class MonitorInfoImpl
extends MirrorImpl
implements MonitorInfo,
ThreadListener {
    private boolean isValid = true;
    ObjectReference monitor;
    ThreadReference thread;
    int stack_depth;

    MonitorInfoImpl(VirtualMachine vm, ObjectReference mon, ThreadReferenceImpl thread, int dpth) {
        super(vm);
        this.monitor = mon;
        this.thread = thread;
        this.stack_depth = dpth;
        thread.addListener(this);
    }

    @Override
    public boolean threadResumable(ThreadAction action) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.isValid) {
                this.isValid = false;
                return false;
            }
            throw new InternalException("Invalid stack frame thread listener");
        }
    }

    private void validateMonitorInfo() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    @Override
    public ObjectReference monitor() {
        this.validateMonitorInfo();
        return this.monitor;
    }

    @Override
    public int stackDepth() {
        this.validateMonitorInfo();
        return this.stack_depth;
    }

    @Override
    public ThreadReference thread() {
        this.validateMonitorInfo();
        return this.thread;
    }
}

