/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.internal.jline.Terminal;
import jdk.internal.jline.TerminalFactory;
import jdk.internal.jline.internal.Log;
import jdk.internal.jline.internal.ShutdownHooks;

public abstract class TerminalSupport
implements Terminal {
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_HEIGHT = 24;
    private ShutdownHooks.Task shutdownTask;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;

    protected TerminalSupport(boolean supported) {
        this.supported = supported;
    }

    @Override
    public void init() throws Exception {
        if (this.shutdownTask != null) {
            ShutdownHooks.remove(this.shutdownTask);
        }
        this.shutdownTask = ShutdownHooks.add(new ShutdownHooks.Task(){

            @Override
            public void run() throws Exception {
                TerminalSupport.this.restore();
            }
        });
    }

    @Override
    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        if (this.shutdownTask != null) {
            ShutdownHooks.remove(this.shutdownTask);
            this.shutdownTask = null;
        }
    }

    @Override
    public void reset() throws Exception {
        this.restore();
        this.init();
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    @Override
    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean supported) {
        this.ansiSupported = supported;
        Log.debug("Ansi supported: ", supported);
    }

    @Override
    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return out;
    }

    @Override
    public boolean hasWeirdWrap() {
        return true;
    }

    @Override
    public int getWidth() {
        return 80;
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    @Override
    public synchronized void setEchoEnabled(boolean enabled) {
        this.echoEnabled = enabled;
        Log.debug("Echo enabled: ", enabled);
    }

    @Override
    public InputStream wrapInIfNeeded(InputStream in) throws IOException {
        return in;
    }

    @Override
    public String getOutputEncoding() {
        return null;
    }
}

