/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import com.sun.source.doctree.DocTree;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor8;
import jdk.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.ClassWriter;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.builders.MemberSummaryBuilder;
import jdk.javadoc.internal.doclets.toolkit.taglets.ParamTaglet;
import jdk.javadoc.internal.doclets.toolkit.util.ClassTree;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.DocletConstants;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class ClassWriterImpl
extends SubWriterHolderWriter
implements ClassWriter {
    protected final TypeElement typeElement;
    protected final ClassTree classtree;
    protected final TypeElement prev;
    protected final TypeElement next;

    public ClassWriterImpl(ConfigurationImpl configuration, TypeElement typeElement, TypeElement prevClass, TypeElement nextClass, ClassTree classTree) throws IOException {
        super(configuration, DocPath.forClass(configuration.utils, typeElement));
        this.typeElement = typeElement;
        configuration.currentTypeElement = typeElement;
        this.classtree = classTree;
        this.prev = prevClass;
        this.next = nextClass;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_SUMMARY, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.classLabel);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content linkContent = this.getHyperLink(DocPaths.CLASS_USE.resolve(this.filename), this.useLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev != null) {
            Content prevLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.prev).label(this.prevclassLabel).strong(true));
            li = HtmlTree.LI(prevLink);
        } else {
            li = HtmlTree.LI(this.prevclassLabel);
        }
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next != null) {
            Content nextLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.next).label(this.nextclassLabel).strong(true));
            li = HtmlTree.LI(nextLink);
        } else {
            li = HtmlTree.LI(this.nextclassLabel);
        }
        return li;
    }

    @Override
    public Content getHeader(String header) {
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(this.utils.getSimpleName(this.typeElement)));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        bodyTree.addContent(HtmlConstants.START_OF_CLASS_DATA);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        PackageElement pkg = this.utils.containingPackage(this.typeElement);
        if (!pkg.isUnnamed()) {
            HtmlTree classPackageLabel = HtmlTree.SPAN(HtmlStyle.packageLabelInClass, this.packageLabel);
            HtmlTree pkgNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, classPackageLabel);
            ((Content)pkgNameDiv).addContent(this.getSpace());
            Content pkgNameContent = this.getPackageLink(pkg, new StringContent(pkg.getQualifiedName()));
            ((Content)pkgNameDiv).addContent(pkgNameContent);
            div.addContent(pkgNameDiv);
        }
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_HEADER, this.typeElement);
        linkInfo.linkToSelf = false;
        StringContent headerContent = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headerContent);
        ((Content)heading).addContent(this.getTypeParameterLinks(linkInfo));
        div.addContent(heading);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
        } else {
            bodyTree.addContent(div);
        }
        return bodyTree;
    }

    @Override
    public Content getClassContentHeader() {
        return this.getContentHeader();
    }

    @Override
    public void addFooter(Content contentTree) {
        contentTree.addContent(HtmlConstants.END_OF_CLASS_DATA);
        Content htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : contentTree;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            contentTree.addContent(htmlTree);
        }
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.typeElement), true, contentTree);
    }

    @Override
    public Content getClassInfoTreeHeader() {
        return this.getMemberTreeHeader();
    }

    @Override
    public Content getClassInfo(Content classInfoTree) {
        return this.getMemberTree(HtmlStyle.description, classInfoTree);
    }

    @Override
    public void addClassSignature(String modifiers, Content classInfoTree) {
        List<? extends TypeMirror> interfaces;
        TypeMirror superclass;
        classInfoTree.addContent(new HtmlTree(HtmlTag.BR));
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.addAnnotationInfo(this.typeElement, (Content)pre);
        ((Content)pre).addContent(modifiers);
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE, this.typeElement);
        linkInfo.linkToSelf = false;
        StringContent className = new StringContent(this.utils.getSimpleName(this.typeElement));
        Content parameterLinks = this.getTypeParameterLinks(linkInfo);
        if (this.configuration.linksource) {
            this.addSrcLink(this.typeElement, className, pre);
            ((Content)pre).addContent(parameterLinks);
        } else {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.typeNameLabel, className);
            ((Content)span).addContent(parameterLinks);
            ((Content)pre).addContent(span);
        }
        if (!this.utils.isInterface(this.typeElement) && (superclass = this.utils.getFirstVisibleSuperClass(this.typeElement)) != null) {
            ((Content)pre).addContent(DocletConstants.NL);
            ((Content)pre).addContent("extends ");
            Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE_PARENT_NAME, superclass));
            ((Content)pre).addContent(link);
        }
        if (!(interfaces = this.typeElement.getInterfaces()).isEmpty()) {
            boolean isFirst = true;
            for (TypeMirror typeMirror : interfaces) {
                TypeElement tDoc = this.utils.asTypeElement(typeMirror);
                if (!this.utils.isPublic(tDoc) && !this.utils.isLinkable(tDoc)) continue;
                if (isFirst) {
                    ((Content)pre).addContent(DocletConstants.NL);
                    ((Content)pre).addContent(this.utils.isInterface(this.typeElement) ? "extends " : "implements ");
                    isFirst = false;
                } else {
                    ((Content)pre).addContent(", ");
                }
                Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE_PARENT_NAME, typeMirror));
                ((Content)pre).addContent(link);
            }
        }
        classInfoTree.addContent(pre);
    }

    @Override
    public void addClassDescription(Content classInfoTree) {
        if (!this.configuration.nocomment && !this.utils.getBody(this.typeElement).isEmpty()) {
            this.addInlineComment(this.typeElement, classInfoTree);
        }
    }

    @Override
    public void addClassTagInfo(Content classInfoTree) {
        if (!this.configuration.nocomment) {
            this.addTagsInfo(this.typeElement, classInfoTree);
        }
    }

    private Content getClassInheritenceTree(TypeMirror type) {
        TypeMirror sup;
        HtmlTree classTreeUl = new HtmlTree(HtmlTag.UL);
        classTreeUl.addStyle(HtmlStyle.inheritance);
        HtmlTree liTree = null;
        do {
            if ((sup = this.utils.getFirstVisibleSuperClass(type)) != null) {
                HtmlTree li;
                HtmlTree ul = new HtmlTree(HtmlTag.UL);
                ul.addStyle(HtmlStyle.inheritance);
                ul.addContent(this.getTreeForClassHelper(type));
                if (liTree != null) {
                    ul.addContent(liTree);
                }
                liTree = li = HtmlTree.LI(ul);
                type = sup;
                continue;
            }
            classTreeUl.addContent(this.getTreeForClassHelper(type));
        } while (sup != null);
        if (liTree != null) {
            classTreeUl.addContent(liTree);
        }
        return classTreeUl;
    }

    private Content getTreeForClassHelper(TypeMirror type) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        if (type.equals(this.typeElement.asType())) {
            Content typeParameters = this.getTypeParameterLinks(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.TREE, this.typeElement));
            if (this.configuration.shouldExcludeQualifier(this.utils.containingPackage(this.typeElement).toString())) {
                ((Content)li).addContent(this.utils.asTypeElement(type).getSimpleName());
                ((Content)li).addContent(typeParameters);
            } else {
                ((Content)li).addContent(this.utils.asTypeElement(type).getQualifiedName());
                ((Content)li).addContent(typeParameters);
            }
        } else {
            Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_TREE_PARENT, type).label(this.configuration.getClassName(this.utils.asTypeElement(type))));
            ((Content)li).addContent(link);
        }
        return li;
    }

    @Override
    public void addClassTree(Content classContentTree) {
        if (!this.utils.isClass(this.typeElement)) {
            return;
        }
        classContentTree.addContent(this.getClassInheritenceTree(this.typeElement.asType()));
    }

    @Override
    public void addTypeParamInfo(Content classInfoTree) {
        if (!this.utils.getTypeParamTrees(this.typeElement).isEmpty()) {
            Content typeParam = new ParamTaglet().getTagletOutput(this.typeElement, this.getTagletWriterInstance(false));
            HtmlTree dl = HtmlTree.DL(typeParam);
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addSubClassInfo(Content classInfoTree) {
        if (this.utils.isClass(this.typeElement)) {
            if (this.typeElement.getQualifiedName().toString().equals("java.lang.Object") || this.typeElement.getQualifiedName().toString().equals("org.omg.CORBA.Object")) {
                return;
            }
            SortedSet<TypeElement> subclasses = this.classtree.directSubClasses(this.typeElement, false);
            if (!subclasses.isEmpty()) {
                Content label = this.getResource("doclet.Subclasses");
                HtmlTree dt = HtmlTree.DT(label);
                HtmlTree dl = HtmlTree.DL(dt);
                ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.SUBCLASSES, subclasses));
                classInfoTree.addContent(dl);
            }
        }
    }

    @Override
    public void addSubInterfacesInfo(Content classInfoTree) {
        SortedSet<TypeElement> subInterfaces;
        if (this.utils.isInterface(this.typeElement) && !(subInterfaces = this.classtree.allSubClasses(this.typeElement, false)).isEmpty()) {
            Content label = this.getResource("doclet.Subinterfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.SUBINTERFACES, subInterfaces));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addInterfaceUsageInfo(Content classInfoTree) {
        if (!this.utils.isInterface(this.typeElement)) {
            return;
        }
        if (this.typeElement.getQualifiedName().toString().equals("java.lang.Cloneable") || this.typeElement.getQualifiedName().toString().equals("java.io.Serializable")) {
            return;
        }
        SortedSet<TypeElement> implcl = this.classtree.implementingClasses(this.typeElement);
        if (!implcl.isEmpty()) {
            Content label = this.getResource("doclet.Implementing_Classes");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.IMPLEMENTED_CLASSES, implcl));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addImplementedInterfacesInfo(Content classInfoTree) {
        TreeSet<TypeMirror> interfaces = new TreeSet<TypeMirror>(this.utils.makeTypeMirrorClassUseComparator());
        interfaces.addAll(this.utils.getAllInterfaces(this.typeElement));
        if (this.utils.isClass(this.typeElement) && !interfaces.isEmpty()) {
            Content label = this.getResource("doclet.All_Implemented_Interfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.IMPLEMENTED_INTERFACES, interfaces));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addSuperInterfacesInfo(Content classInfoTree) {
        TreeSet<TypeMirror> interfaces = new TreeSet<TypeMirror>(this.utils.makeTypeMirrorIndexUseComparator());
        interfaces.addAll(this.utils.getAllInterfaces(this.typeElement));
        if (this.utils.isInterface(this.typeElement) && !interfaces.isEmpty()) {
            Content label = this.getResource("doclet.All_Superinterfaces");
            HtmlTree dt = HtmlTree.DT(label);
            HtmlTree dl = HtmlTree.DL(dt);
            ((Content)dl).addContent(this.getClassLinks(LinkInfoImpl.Kind.SUPER_INTERFACES, interfaces));
            classInfoTree.addContent(dl);
        }
    }

    @Override
    public void addNestedClassInfo(final Content classInfoTree) {
        Element outerClass = this.typeElement.getEnclosingElement();
        if (outerClass == null) {
            return;
        }
        new SimpleElementVisitor8<Void, Void>(){

            @Override
            public Void visitType(TypeElement e, Void p) {
                String label = ClassWriterImpl.this.utils.isInterface(e) ? "doclet.Enclosing_Interface" : "doclet.Enclosing_Class";
                HtmlTree dt = HtmlTree.DT(ClassWriterImpl.this.getResource(label));
                HtmlTree dl = HtmlTree.DL(dt);
                HtmlTree dd = new HtmlTree(HtmlTag.DD);
                ((Content)dd).addContent(ClassWriterImpl.this.getLink(new LinkInfoImpl(ClassWriterImpl.this.configuration, LinkInfoImpl.Kind.CLASS, e)));
                ((Content)dl).addContent(dd);
                classInfoTree.addContent(dl);
                return null;
            }
        }.visit(outerClass);
    }

    @Override
    public void addFunctionalInterfaceInfo(Content classInfoTree) {
        if (this.isFunctionalInterface()) {
            HtmlTree dt = HtmlTree.DT(this.getResource("doclet.Functional_Interface"));
            HtmlTree dl = HtmlTree.DL(dt);
            HtmlTree dd = new HtmlTree(HtmlTag.DD);
            ((Content)dd).addContent(this.getResource("doclet.Functional_Interface_Message"));
            ((Content)dl).addContent(dd);
            classInfoTree.addContent(dl);
        }
    }

    public boolean isFunctionalInterface() {
        List<? extends AnnotationMirror> annotationMirrors = this.typeElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!this.utils.isFunctionalInterface(annotationMirror)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addClassDeprecationInfo(Content classInfoTree) {
        HtmlTree hr = new HtmlTree(HtmlTag.HR);
        classInfoTree.addContent(hr);
        List<? extends DocTree> deprs = this.utils.getBlockTags((Element)this.typeElement, DocTree.Kind.DEPRECATED);
        if (this.utils.isDeprecated(this.typeElement)) {
            DocTree dt;
            CommentHelper ch;
            List<? extends DocTree> commentTags;
            HtmlTree deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
            if (!deprs.isEmpty() && !(commentTags = (ch = this.utils.getCommentHelper(this.typeElement)).getBody(this.configuration, dt = deprs.get(0))).isEmpty()) {
                ((Content)div).addContent(this.getSpace());
                this.addInlineDeprecatedComment(this.typeElement, deprs.get(0), div);
            }
            classInfoTree.addContent(div);
        }
    }

    private Content getClassLinks(LinkInfoImpl.Kind context, Collection<?> list) {
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        boolean isFirst = true;
        for (Object type : list) {
            Content link;
            if (!isFirst) {
                StringContent separator = new StringContent(", ");
                ((Content)dd).addContent(separator);
            } else {
                isFirst = false;
            }
            if (type instanceof TypeElement) {
                link = this.getLink(new LinkInfoImpl(this.configuration, context, (TypeElement)type));
                ((Content)dd).addContent(link);
                continue;
            }
            link = this.getLink(new LinkInfoImpl(this.configuration, context, (TypeMirror)type));
            ((Content)dd).addContent(link);
        }
        return dd;
    }

    @Override
    protected Content getNavLinkTree() {
        Content treeLinkContent = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(treeLinkContent);
        return li;
    }

    @Override
    protected void addSummaryDetailLinks(Content subDiv) {
        try {
            HtmlTree div = HtmlTree.DIV(this.getNavSummaryLinks());
            ((Content)div).addContent(this.getNavDetailLinks());
            subDiv.addContent(div);
        }
        catch (Exception e) {
            throw new DocletAbortException(e);
        }
    }

    protected Content getNavSummaryLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.summaryLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        for (VisibleMemberMap.Kind kind : VisibleMemberMap.Kind.summarySet) {
            HtmlTree liNav = new HtmlTree(HtmlTag.LI);
            if (kind == VisibleMemberMap.Kind.ENUM_CONSTANTS && !this.utils.isEnum(this.typeElement) || kind == VisibleMemberMap.Kind.CONSTRUCTORS && this.utils.isEnum(this.typeElement)) continue;
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(kind));
            if (writer == null) {
                ((Content)liNav).addContent(this.getResource(VisibleMemberMap.Kind.getNavLinkLabels(kind)));
            } else {
                writer.addNavSummaryLink(memberSummaryBuilder.members(kind), memberSummaryBuilder.getVisibleMemberMap(kind), liNav);
            }
            if (kind != VisibleMemberMap.Kind.METHODS) {
                this.addNavGap(liNav);
            }
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected Content getNavDetailLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.detailLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        for (VisibleMemberMap.Kind kind : VisibleMemberMap.Kind.detailSet) {
            HtmlTree liNav = new HtmlTree(HtmlTag.LI);
            AbstractMemberWriter writer = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(kind));
            if (kind == VisibleMemberMap.Kind.ENUM_CONSTANTS && !this.utils.isEnum(this.typeElement) || kind == VisibleMemberMap.Kind.CONSTRUCTORS && this.utils.isEnum(this.typeElement)) continue;
            if (writer == null) {
                ((Content)liNav).addContent(this.getResource(VisibleMemberMap.Kind.getNavLinkLabels(kind)));
            } else {
                writer.addNavDetailLink(memberSummaryBuilder.members(kind), (Content)liNav);
            }
            if (kind != VisibleMemberMap.Kind.METHODS) {
                this.addNavGap(liNav);
            }
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected void addNavGap(Content liNav) {
        liNav.addContent(this.getSpace());
        liNav.addContent("|");
        liNav.addContent(this.getSpace());
    }

    @Override
    public TypeElement getTypeElement() {
        return this.typeElement;
    }
}

