/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import com.sun.source.doctree.DocTree;
import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.SectionName;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.RawHtml;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.PackageSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;

public class PackageWriterImpl
extends HtmlDocletWriter
implements PackageSummaryWriter {
    protected PackageElement prev;
    protected PackageElement next;
    protected PackageElement packageElement;
    protected HtmlTree mainTree = HtmlTree.MAIN();
    protected HtmlTree sectionTree = HtmlTree.SECTION();

    public PackageWriterImpl(ConfigurationImpl configuration, PackageElement packageElement, PackageElement prev, PackageElement next) throws IOException {
        super(configuration, DocPath.forPackage(packageElement).resolve(DocPaths.PACKAGE_SUMMARY));
        this.prev = prev;
        this.next = next;
        this.packageElement = packageElement;
    }

    @Override
    public Content getPackageHeader(String heading) {
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(this.utils.getPackageName(this.packageElement)));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        HtmlTree annotationContent = new HtmlTree(HtmlTag.P);
        this.addAnnotationInfo(this.packageElement, (Content)annotationContent);
        div.addContent(annotationContent);
        HtmlTree tHeading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, this.packageLabel);
        ((Content)tHeading).addContent(this.getSpace());
        StringContent packageHead = new StringContent(heading);
        ((Content)tHeading).addContent(packageHead);
        div.addContent(tHeading);
        this.addDeprecationInfo(div);
        if (!this.utils.getBody(this.packageElement).isEmpty() && !this.configuration.nocomment) {
            HtmlTree docSummaryDiv = new HtmlTree(HtmlTag.DIV);
            docSummaryDiv.addStyle(HtmlStyle.docSummary);
            this.addSummaryComment(this.packageElement, docSummaryDiv);
            div.addContent(docSummaryDiv);
            Content space = this.getSpace();
            Content descLink = this.getHyperLink(this.getDocLink(SectionName.PACKAGE_DESCRIPTION), this.descriptionLabel, "", "");
            HtmlTree descPara = new HtmlTree(HtmlTag.P, this.seeLabel, space, descLink);
            div.addContent(descPara);
        }
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
        } else {
            bodyTree.addContent(div);
        }
        return bodyTree;
    }

    @Override
    public Content getContentHeader() {
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.contentContainer);
        return div;
    }

    public void addDeprecationInfo(Content div) {
        List<? extends DocTree> deprs = this.utils.getBlockTags((Element)this.packageElement, DocTree.Kind.DEPRECATED);
        if (this.utils.isDeprecated(this.packageElement)) {
            List<? extends DocTree> commentTags;
            CommentHelper ch = this.utils.getCommentHelper(this.packageElement);
            HtmlTree deprDiv = new HtmlTree(HtmlTag.DIV);
            deprDiv.addStyle(HtmlStyle.deprecatedContent);
            HtmlTree deprPhrase = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            deprDiv.addContent(deprPhrase);
            if (!deprs.isEmpty() && !(commentTags = ch.getDescription(this.configuration, deprs.get(0))).isEmpty()) {
                this.addInlineDeprecatedComment(this.packageElement, deprs.get(0), deprDiv);
            }
            div.addContent(deprDiv);
        }
    }

    @Override
    public Content getSummaryHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public void addClassesSummary(SortedSet<TypeElement> classes, String label, String tableSummary, List<String> tableHeader, Content summaryContentTree) {
        if (!classes.isEmpty()) {
            Content caption = this.getTableCaption(new RawHtml(label));
            HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.typeSummary, caption) : HtmlTree.TABLE(HtmlStyle.typeSummary, tableSummary, caption);
            ((Content)table).addContent(this.getSummaryTableHeader(tableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            boolean altColor = false;
            for (TypeElement klass : classes) {
                boolean bl = altColor = !altColor;
                if (!this.utils.isCoreClass(klass) || !this.configuration.isGeneratedDoc(klass)) continue;
                Content classContent = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE, klass));
                HtmlTree tdClass = HtmlTree.TD(HtmlStyle.colFirst, classContent);
                HtmlTree tr = HtmlTree.TR(tdClass);
                tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
                HtmlTree tdClassDescription = new HtmlTree(HtmlTag.TD);
                tdClassDescription.addStyle(HtmlStyle.colLast);
                if (this.utils.isDeprecated(klass)) {
                    tdClassDescription.addContent(this.deprecatedLabel);
                    List<? extends DocTree> tags = this.utils.getDeprecatedTrees(klass);
                    if (!tags.isEmpty()) {
                        this.addSummaryDeprecatedComment(klass, tags.get(0), tdClassDescription);
                    }
                } else {
                    this.addSummaryComment(klass, tdClassDescription);
                }
                tr.addContent(tdClassDescription);
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
            summaryContentTree.addContent(li);
        }
    }

    @Override
    public void addPackageDescription(Content packageContentTree) {
        if (!this.utils.getBody(this.packageElement).isEmpty()) {
            packageContentTree.addContent(this.getMarkerAnchor(SectionName.PACKAGE_DESCRIPTION));
            StringContent h2Content = new StringContent(this.configuration.getText("doclet.Package_Description", this.packageElement.isUnnamed() ? "" : this.utils.getPackageName(this.packageElement)));
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, (Content)h2Content);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                this.sectionTree.addContent(heading);
                this.addInlineComment(this.packageElement, this.sectionTree);
            } else {
                packageContentTree.addContent(heading);
                this.addInlineComment(this.packageElement, packageContentTree);
            }
        }
    }

    @Override
    public void addPackageTags(Content packageContentTree) {
        Content htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? this.sectionTree : packageContentTree;
        this.addTagsInfo(this.packageElement, htmlTree);
    }

    @Override
    public void addPackageContent(Content contentTree, Content packageContentTree) {
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            packageContentTree.addContent(this.sectionTree);
            this.mainTree.addContent(packageContentTree);
            contentTree.addContent(this.mainTree);
        } else {
            contentTree.addContent(packageContentTree);
        }
    }

    @Override
    public void addPackageFooter(Content contentTree) {
        Content htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : contentTree;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            contentTree.addContent(htmlTree);
        }
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.packageElement), true, contentTree);
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content useLink = this.getHyperLink(DocPaths.PACKAGE_USE, this.useLabel, "", "");
        HtmlTree li = HtmlTree.LI(useLink);
        return li;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev == null) {
            li = HtmlTree.LI(this.prevpackageLabel);
        } else {
            DocPath path = DocPath.relativePath(this.packageElement, this.prev);
            li = HtmlTree.LI(this.getHyperLink(path.resolve(DocPaths.PACKAGE_SUMMARY), this.prevpackageLabel, "", ""));
        }
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next == null) {
            li = HtmlTree.LI(this.nextpackageLabel);
        } else {
            DocPath path = DocPath.relativePath(this.packageElement, this.next);
            li = HtmlTree.LI(this.getHyperLink(path.resolve(DocPaths.PACKAGE_SUMMARY), this.nextpackageLabel, "", ""));
        }
        return li;
    }

    @Override
    protected Content getNavLinkTree() {
        Content useLink = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(useLink);
        return li;
    }

    @Override
    protected Content getNavLinkPackage() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.packageLabel);
        return li;
    }
}

