/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.builders;

import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.EnumConstantWriter;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractMemberBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.XMLNode;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class EnumConstantBuilder
extends AbstractMemberBuilder {
    private final TypeElement typeElement;
    private final VisibleMemberMap visibleMemberMap;
    private final EnumConstantWriter writer;
    private final SortedSet<Element> enumConstants;
    private VariableElement currentElement;

    private EnumConstantBuilder(AbstractBuilder.Context context, TypeElement typeElement, EnumConstantWriter writer) {
        super(context);
        this.typeElement = typeElement;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.ENUM_CONSTANTS, this.configuration);
        this.enumConstants = this.visibleMemberMap.getMembersFor(typeElement);
    }

    public static EnumConstantBuilder getInstance(AbstractBuilder.Context context, TypeElement typeElement, EnumConstantWriter writer) {
        return new EnumConstantBuilder(context, typeElement, writer);
    }

    @Override
    public String getName() {
        return "EnumConstantDetails";
    }

    public SortedSet<Element> members(TypeElement typeElement) {
        return this.visibleMemberMap.getMembersFor(typeElement);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.enumConstants.size() > 0;
    }

    public void buildEnumConstant(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        if (!this.enumConstants.isEmpty()) {
            Content enumConstantsDetailsTree = this.writer.getEnumConstantsDetailsTreeHeader(this.typeElement, memberDetailsTree);
            for (Element element : this.enumConstants) {
                this.currentElement = (VariableElement)element;
                Content enumConstantsTree = this.writer.getEnumConstantsTreeHeader(this.currentElement, enumConstantsDetailsTree);
                this.buildChildren(node, enumConstantsTree);
                enumConstantsDetailsTree.addContent(this.writer.getEnumConstants(enumConstantsTree, this.currentElement.equals(this.enumConstants.last())));
            }
            memberDetailsTree.addContent(this.writer.getEnumConstantsDetails(enumConstantsDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content enumConstantsTree) {
        enumConstantsTree.addContent(this.writer.getSignature(this.currentElement));
    }

    public void buildDeprecationInfo(XMLNode node, Content enumConstantsTree) {
        this.writer.addDeprecated(this.currentElement, enumConstantsTree);
    }

    public void buildEnumConstantComments(XMLNode node, Content enumConstantsTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments(this.currentElement, enumConstantsTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content enumConstantsTree) {
        this.writer.addTags(this.currentElement, enumConstantsTree);
    }

    public EnumConstantWriter getWriter() {
        return this.writer;
    }
}

