/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TransportFrameUtil;
import io.grpc.netty.GrpcHttp2Headers;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

@VisibleForTesting
class Utils {
    public static final AsciiString STATUS_OK = AsciiString.of((CharSequence)"200");
    public static final AsciiString HTTP_METHOD = AsciiString.of((CharSequence)"POST");
    public static final AsciiString HTTPS = AsciiString.of((CharSequence)"https");
    public static final AsciiString HTTP = AsciiString.of((CharSequence)"http");
    public static final AsciiString CONTENT_TYPE_HEADER = AsciiString.of((CharSequence)GrpcUtil.CONTENT_TYPE_KEY.name());
    public static final AsciiString CONTENT_TYPE_GRPC = AsciiString.of((CharSequence)"application/grpc");
    public static final AsciiString TE_HEADER = AsciiString.of((CharSequence)"te");
    public static final AsciiString TE_TRAILERS = AsciiString.of((CharSequence)"trailers");
    public static final AsciiString USER_AGENT = AsciiString.of((CharSequence)GrpcUtil.USER_AGENT_KEY.name());
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(1, "grpc-default-boss-ELG");
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(0, "grpc-default-worker-ELG");
    public static final AttributeKey<SSLSession> SSL_SESSION_ATTR_KEY = AttributeKey.valueOf(SSLSession.class, (String)"ssl-session");
    @VisibleForTesting
    static boolean validateHeaders = false;

    public static Metadata convertHeaders(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(Http2Headers http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Map.Entry entry : http2Headers) {
            headerValues[i++] = Utils.bytes((CharSequence)entry.getKey());
            headerValues[i++] = Utils.bytes((CharSequence)entry.getValue());
        }
        return TransportFrameUtil.toRawSerializedHeaders((byte[][])headerValues);
    }

    private static byte[] bytes(CharSequence seq) {
        if (seq instanceof AsciiString) {
            AsciiString str = (AsciiString)seq;
            return str.isEntireArrayUsed() ? str.array() : str.toByteArray();
        }
        return seq.toString().getBytes(CharsetUtil.UTF_8);
    }

    public static Http2Headers convertClientHeaders(Metadata headers, AsciiString scheme, AsciiString defaultPath, AsciiString authority, AsciiString userAgent) {
        Preconditions.checkNotNull((Object)defaultPath, (Object)"defaultPath");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        return GrpcHttp2Headers.clientRequestHeaders(TransportFrameUtil.toHttp2Headers((Metadata)headers), authority, defaultPath, HTTP_METHOD, scheme, userAgent);
    }

    public static Http2Headers convertServerHeaders(Metadata headers) {
        return GrpcHttp2Headers.serverResponseHeaders(TransportFrameUtil.toHttp2Headers((Metadata)headers));
    }

    public static Metadata convertTrailers(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Http2Headers convertTrailers(Metadata trailers, boolean headersSent) {
        if (!headersSent) {
            return Utils.convertServerHeaders(trailers);
        }
        return GrpcHttp2Headers.serverResponseTrailers(TransportFrameUtil.toHttp2Headers((Metadata)trailers));
    }

    public static Status statusFromThrowable(Throwable t) {
        Status s = Status.fromThrowable((Throwable)t);
        if (s.getCode() != Status.Code.UNKNOWN) {
            return s;
        }
        if (t instanceof IOException) {
            return Status.UNAVAILABLE.withCause(t);
        }
        if (t instanceof Http2Exception) {
            return Status.INTERNAL.withCause(t);
        }
        return s;
    }

    private Utils() {
    }

    private static class ThreadGroupSavingDefaultThreadFactory
    extends DefaultThreadFactory {
        final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();

        ThreadGroupSavingDefaultThreadFactory(String name, boolean daemon) {
            super(name, daemon);
        }

        protected Thread newThread(Runnable r, String name) {
            return new FastThreadLocalThread(this.threadGroup, r, name);
        }
    }

    private static class DefaultEventLoopGroupResource
    implements SharedResourceHolder.Resource<EventLoopGroup> {
        private final String name;
        private final int numEventLoops;

        DefaultEventLoopGroupResource(int numEventLoops, String name) {
            this.name = name;
            this.numEventLoops = numEventLoops;
        }

        public EventLoopGroup create() {
            boolean useDaemonThreads = true;
            ThreadGroupSavingDefaultThreadFactory threadFactory = new ThreadGroupSavingDefaultThreadFactory(this.name, useDaemonThreads);
            int parallelism = this.numEventLoops == 0 ? Runtime.getRuntime().availableProcessors() * 2 : this.numEventLoops;
            return new NioEventLoopGroup(parallelism, (ThreadFactory)((Object)threadFactory));
        }

        public void close(EventLoopGroup instance) {
            instance.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        public String toString() {
            return this.name;
        }
    }
}

