/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class Arguments {
    protected static final Context.Key<Arguments> argsKey = new Context.Key();
    private String ownName;
    private Set<String> classNames;
    private Set<File> files;
    private Map<Option, String> deferredFileManagerOptions;
    private Set<JavaFileObject> fileObjects;
    private final Options options;
    private JavaFileManager fileManager;
    private final Log log;
    private final Context context;
    private ErrorMode errorMode;
    private boolean errors;
    private final OptionHelper cmdLineHelper = new OptionHelper(){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String string, String string2) {
            Arguments.this.options.put(string, string2);
        }

        @Override
        public void remove(String string) {
            Arguments.this.options.remove(string);
        }

        @Override
        public boolean handleFileManagerOption(Option option, String string) {
            Arguments.this.options.put(option.getText(), string);
            Arguments.this.deferredFileManagerOptions.put(option, string);
            return true;
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }

        @Override
        public String getOwnName() {
            return Arguments.this.ownName;
        }

        @Override
        public void error(String string, Object ... objectArray) {
            Arguments.this.error(string, objectArray);
        }

        @Override
        public void addFile(File file) {
            Arguments.this.files.add(file);
        }

        @Override
        public void addClassName(String string) {
            Arguments.this.classNames.add(string);
        }
    };
    private final OptionHelper apiHelper = new OptionHelper.GrumpyHelper(null){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option.getText());
        }

        @Override
        public void put(String string, String string2) {
            Arguments.this.options.put(string, string2);
        }

        @Override
        public void remove(String string) {
            Arguments.this.options.remove(string);
        }

        @Override
        public void error(String string, Object ... objectArray) {
            Arguments.this.error(string, objectArray);
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }
    };

    public static Arguments instance(Context context) {
        Arguments arguments = context.get(argsKey);
        if (arguments == null) {
            arguments = new Arguments(context);
        }
        return arguments;
    }

    protected Arguments(Context context) {
        context.put(argsKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
        this.context = context;
    }

    public void init(String string, String ... stringArray) {
        this.ownName = string;
        this.errorMode = ErrorMode.LOG;
        this.files = new LinkedHashSet<File>();
        this.deferredFileManagerOptions = new LinkedHashMap<Option, String>();
        this.fileObjects = null;
        this.classNames = new LinkedHashSet<String>();
        this.processArgs(List.from(stringArray), Option.getJavaCompilerOptions(), this.cmdLineHelper, true, false);
    }

    public void init(String string, Iterable<String> iterable, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3) {
        this.ownName = string;
        this.classNames = this.toSet(iterable2);
        this.fileObjects = this.toSet(iterable3);
        this.files = null;
        this.errorMode = ErrorMode.ILLEGAL_ARGUMENT;
        if (iterable != null) {
            this.processArgs(this.toList(iterable), Option.getJavacToolOptions(), this.apiHelper, false, true);
        }
        this.errorMode = ErrorMode.ILLEGAL_STATE;
    }

    public Set<JavaFileObject> getFileObjects() {
        if (this.fileObjects == null) {
            if (this.files == null) {
                this.fileObjects = Collections.emptySet();
            } else {
                this.fileObjects = new LinkedHashSet<JavaFileObject>();
                JavacFileManager javacFileManager = (JavacFileManager)this.getFileManager();
                for (JavaFileObject javaFileObject : javacFileManager.getJavaFileObjectsFromFiles(this.files)) {
                    this.fileObjects.add(javaFileObject);
                }
            }
        }
        return this.fileObjects;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    private boolean processArgs(Iterable<String> iterable, Set<Option> set, OptionHelper optionHelper, boolean bl, boolean bl2) {
        JavaFileManager javaFileManager = bl2 ? this.getFileManager() : null;
        Iterator<String> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.isEmpty()) {
                this.error("err.invalid.flag", string);
                return false;
            }
            Option option = null;
            if (string.startsWith("-")) {
                for (Option option2 : set) {
                    if (!option2.matches(string)) continue;
                    option = option2;
                    break;
                }
            } else if (bl && Option.SOURCEFILE.matches(string)) {
                option = Option.SOURCEFILE;
            }
            if (option == null) {
                if (javaFileManager != null && javaFileManager.handleOption(string, iterator)) continue;
                this.error("err.invalid.flag", string);
                return false;
            }
            if (option.hasArg()) {
                if (!iterator.hasNext()) {
                    this.error("err.req.arg", string);
                    return false;
                }
                String string2 = iterator.next();
                if (!option.process(optionHelper, string, string2)) continue;
                return false;
            }
            if (!option.process(optionHelper, string)) continue;
            return false;
        }
        this.options.notifyListeners();
        return true;
    }

    public boolean validate() {
        JavaFileManager javaFileManager;
        boolean bl;
        String string;
        Target target;
        if (this.isEmpty()) {
            if (this.options.isSet(Option.HELP) || this.options.isSet(Option.X) || this.options.isSet(Option.VERSION) || this.options.isSet(Option.FULLVERSION)) {
                return true;
            }
            if (JavaCompiler.explicitAnnotationProcessingRequested(this.options)) {
                this.error("err.no.source.files.classes", new Object[0]);
            } else {
                this.error("err.no.source.files", new Object[0]);
            }
            return false;
        }
        if (!this.checkDirectory(Option.D)) {
            return false;
        }
        if (!this.checkDirectory(Option.S)) {
            return false;
        }
        String string2 = this.options.get(Option.SOURCE);
        Source source = string2 != null ? Source.lookup(string2) : Source.DEFAULT;
        String string3 = this.options.get(Option.TARGET);
        Target target2 = target = string3 != null ? Target.lookup(string3) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0)) && target.compareTo(source.requiredTarget()) < 0) {
            if (string3 != null) {
                if (string2 == null) {
                    this.error("warn.target.default.source.conflict", string3, source.requiredTarget().name);
                } else {
                    this.error("warn.source.target.conflict", string2, source.requiredTarget().name);
                }
                return false;
            }
            target = source.requiredTarget();
            this.options.put("-target", target.name);
        }
        if ((string = this.options.get(Option.PROFILE)) != null) {
            Profile profile = Profile.lookup(string);
            if (!profile.isValid(target)) {
                this.error("warn.profile.target.conflict", string, target.name);
            }
            if (this.options.get(Option.BOOTCLASSPATH) != null) {
                this.error("err.profile.bootclasspath.conflict", new Object[0]);
            }
        }
        if ((bl = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.OPTIONS.option)) && source.compareTo(Source.DEFAULT) < 0 && (javaFileManager = this.getFileManager()) instanceof BaseFileManager && ((BaseFileManager)javaFileManager).isDefaultBootClassPath()) {
            this.log.warning(Lint.LintCategory.OPTIONS, "source.no.bootclasspath", source.name);
        }
        boolean bl2 = false;
        if (source.compareTo(Source.MIN) < 0) {
            this.log.error("option.removed.source", source.name, Source.MIN.name);
        } else if (source == Source.MIN && bl) {
            this.log.warning(Lint.LintCategory.OPTIONS, "option.obsolete.source", source.name);
            bl2 = true;
        }
        if (target.compareTo(Target.MIN) < 0) {
            this.log.error("option.removed.target", target.name, Target.MIN.name);
        } else if (target == Target.MIN && bl) {
            this.log.warning(Lint.LintCategory.OPTIONS, "option.obsolete.target", target.name);
            bl2 = true;
        }
        if (bl2) {
            this.log.warning(Lint.LintCategory.OPTIONS, "option.obsolete.suppression", new Object[0]);
        }
        return !this.errors;
    }

    public boolean isEmpty() {
        return !(this.files != null && !this.files.isEmpty() || this.fileObjects != null && !this.fileObjects.isEmpty() || !this.classNames.isEmpty());
    }

    public Map<Option, String> getDeferredFileManagerOptions() {
        return this.deferredFileManagerOptions;
    }

    public Set<List<String>> getPluginOpts() {
        String string = this.options.get(Option.PLUGIN);
        if (string == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<List<String>> linkedHashSet = new LinkedHashSet<List<String>>();
        for (String string2 : string.split("\\x00")) {
            linkedHashSet.add(List.from(string2.split("\\s+")));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public List<String> getDocLintOpts() {
        String string = this.options.get(Option.XDOCLINT);
        String string2 = this.options.get(Option.XDOCLINT_CUSTOM);
        if (string == null && string2 == null) {
            return List.nil();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (string != null) {
            linkedHashSet.add("-Xmsgs");
        }
        if (string2 != null) {
            for (String string3 : string2.split("\\s+")) {
                if (string3.isEmpty()) continue;
                linkedHashSet.add(string3.replace(Option.XDOCLINT_CUSTOM.text, "-Xmsgs:"));
            }
        }
        if (linkedHashSet.equals(Collections.singleton("-Xmsgs:none"))) {
            return List.nil();
        }
        linkedHashSet.add("-XimplicitHeaders:2");
        return List.from(linkedHashSet.toArray(new String[linkedHashSet.size()]));
    }

    private boolean checkDirectory(Option option) {
        String string = this.options.get(option);
        if (string == null) {
            return true;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.error("err.dir.not.found", string);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", string);
            return false;
        }
        return true;
    }

    void error(String string, Object ... objectArray) {
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                String string2 = this.log.localize(Log.PrefixKind.JAVAC, string, objectArray);
                throw new PropagatedException(new IllegalArgumentException(string2));
            }
            case ILLEGAL_STATE: {
                String string3 = this.log.localize(Log.PrefixKind.JAVAC, string, objectArray);
                throw new PropagatedException(new IllegalStateException(string3));
            }
            case LOG: {
                this.report(string, objectArray);
                this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
            }
        }
    }

    void warning(String string, Object ... objectArray) {
        this.report(string, objectArray);
    }

    private void report(String string, Object ... objectArray) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, string, objectArray));
    }

    private JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = this.context.get(JavaFileManager.class);
        }
        return this.fileManager;
    }

    <T> ListBuffer<T> toList(Iterable<? extends T> iterable) {
        ListBuffer<T> listBuffer = new ListBuffer<T>();
        if (iterable != null) {
            for (T t : iterable) {
                listBuffer.add(t);
            }
        }
        return listBuffer;
    }

    <T> Set<T> toSet(Iterable<? extends T> iterable) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        if (iterable != null) {
            for (T t : iterable) {
                linkedHashSet.add(t);
            }
        }
        return linkedHashSet;
    }

    private static enum ErrorMode {
        ILLEGAL_ARGUMENT,
        ILLEGAL_STATE,
        LOG;

    }
}

