/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.javac.util.Options;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.tools.JavaFileObject;

public abstract class Dependencies {
    protected static final Context.Key<Dependencies> dependenciesKey = new Context.Key();

    public static Dependencies instance(Context context) {
        Dependencies dependencies = context.get(dependenciesKey);
        if (dependencies == null) {
            dependencies = new DummyDependencies(context);
        }
        return dependencies;
    }

    Dependencies(Context context) {
        context.put(dependenciesKey, this);
    }

    public abstract void push(Symbol.ClassSymbol var1);

    public abstract void push(AttributionKind var1, JCTree var2);

    public abstract void pop();

    private static class DummyDependencies
    extends Dependencies {
        private DummyDependencies(Context context) {
            super(context);
        }

        @Override
        public void push(Symbol.ClassSymbol classSymbol) {
        }

        @Override
        public void push(AttributionKind attributionKind, JCTree jCTree) {
        }

        @Override
        public void pop() {
        }
    }

    public static class GraphDependencies
    extends Dependencies
    implements Closeable,
    Symbol.Completer {
        private EnumSet<DependenciesMode> dependenciesModes;
        private String dependenciesFile;
        Stack<Node> nodeStack = new Stack();
        Map<String, Node> dependencyNodeMap = new LinkedHashMap<String, Node>();

        public static void preRegister(final Context context) {
            context.put(dependenciesKey, new Context.Factory<Dependencies>(){

                @Override
                public Dependencies make(Context context2) {
                    GraphDependencies graphDependencies = new GraphDependencies(context);
                    return graphDependencies;
                }
            });
        }

        GraphDependencies(Context context) {
            super(context);
            String[] stringArray;
            Options options = Options.instance(context);
            for (String string : stringArray = options.get("completionDeps").split(",")) {
                if (!string.startsWith("file=")) continue;
                this.dependenciesFile = string.substring(5);
            }
            this.dependenciesModes = DependenciesMode.getDependenciesModes(stringArray);
            JavaCompiler javaCompiler = JavaCompiler.instance(context);
            javaCompiler.closeables = javaCompiler.closeables.prepend(this);
        }

        @Override
        public void push(Symbol.ClassSymbol classSymbol) {
            CompletionNode completionNode = new CompletionNode(classSymbol);
            if (completionNode == this.push(completionNode)) {
                classSymbol.completer = this;
            }
        }

        @Override
        public void push(AttributionKind attributionKind, JCTree jCTree) {
            this.push(new AttributionNode(attributionKind, jCTree));
        }

        protected Node push(Node node) {
            Node node2 = this.dependencyNodeMap.get(node.data);
            if (node2 == null) {
                this.dependencyNodeMap.put((String)node.data, node);
            } else {
                node = node2;
            }
            if (!this.nodeStack.isEmpty()) {
                Node node3 = this.nodeStack.peek();
                node3.addDependency(Node.DependencyKind.REQUIRES, node);
            }
            this.nodeStack.push(node);
            return node;
        }

        @Override
        public void pop() {
            this.nodeStack.pop();
        }

        @Override
        public void close() throws IOException {
            if (this.dependenciesFile != null) {
                if (!this.dependenciesModes.contains((Object)DependenciesMode.REDUNDANT)) {
                    new PruneVisitor().visit(this.dependencyNodeMap.values(), null);
                }
                if (!this.dependenciesModes.contains((Object)DependenciesMode.CLASS)) {
                    new FilterVisitor(CompletionNode.Kind.SOURCE).visit(this.dependencyNodeMap.values(), null);
                }
                if (!this.dependenciesModes.contains((Object)DependenciesMode.SOURCE)) {
                    new FilterVisitor(CompletionNode.Kind.CLASS).visit(this.dependencyNodeMap.values(), null);
                }
                if (this.dependenciesModes.contains((Object)DependenciesMode.SIDE_EFFECTS)) {
                    new SideEffectVisitor().visit(this.dependencyNodeMap.values(), null);
                }
                try (FileWriter fileWriter = new FileWriter(this.dependenciesFile);){
                    fileWriter.append(GraphUtils.toDot(this.dependencyNodeMap.values(), "CompletionDeps", ""));
                }
            }
        }

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            this.push((Symbol.ClassSymbol)symbol);
            this.pop();
            symbol.completer = this;
        }

        private class FilterVisitor
        extends GraphUtils.NodeVisitor<String, Node, Void> {
            CompletionNode.Kind ck;

            private FilterVisitor(CompletionNode.Kind kind) {
                this.ck = kind;
            }

            @Override
            public void visitNode(Node node, Void void_) {
                if (node instanceof CompletionNode && ((CompletionNode)node).ck != this.ck) {
                    GraphDependencies.this.dependencyNodeMap.remove(node.data);
                }
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dependencyKind, Node node, Node node2, Void void_) {
                if (node2 instanceof CompletionNode && ((CompletionNode)node2).ck != this.ck) {
                    node.depsByKind.get(dependencyKind).remove(node2);
                }
            }
        }

        private static class PruneVisitor
        extends GraphUtils.NodeVisitor<String, Node, Void> {
            private PruneVisitor() {
            }

            @Override
            public void visitNode(Node node, Void void_) {
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dependencyKind, Node node, Node node2, Void void_) {
                if (node.equals(node2) || node.depsByKind.get(Node.DependencyKind.REQUIRES).contains(node2)) {
                    node2.depsByKind.get(dependencyKind).remove(node);
                }
            }
        }

        private static class SideEffectVisitor
        extends GraphUtils.NodeVisitor<String, Node, Void> {
            private SideEffectVisitor() {
            }

            @Override
            public void visitNode(Node node, Void void_) {
            }

            @Override
            public void visitDependency(GraphUtils.DependencyKind dependencyKind, Node node, Node node2, Void void_) {
                List<Node> list = node.depsByKind.get(dependencyKind);
                int n = list.indexOf(node2);
                if (dependencyKind == Node.DependencyKind.REQUIRES && n > 0) {
                    node2.addDependency(Node.DependencyKind.SIDE_EFFECTS, list.get(n - 1));
                }
            }
        }

        static class AttributionNode
        extends Node {
            AttributionNode(AttributionKind attributionKind, JCTree jCTree) {
                super(attributionKind.format(jCTree));
            }

            @Override
            public Properties nodeAttributes() {
                Properties properties = super.nodeAttributes();
                properties.put("shape", "box");
                properties.put("style", "solid");
                return properties;
            }
        }

        static class CompletionNode
        extends Node {
            final Kind ck;

            CompletionNode(Symbol.ClassSymbol classSymbol) {
                super(classSymbol.getQualifiedName().toString());
                boolean bl = classSymbol.classfile == null && classSymbol.sourcefile == null || classSymbol.classfile != null && classSymbol.classfile.getKind() == JavaFileObject.Kind.CLASS;
                this.ck = bl ? Kind.CLASS : Kind.SOURCE;
            }

            @Override
            public Properties nodeAttributes() {
                Properties properties = super.nodeAttributes();
                properties.put("style", this.ck.dotStyle);
                properties.put("shape", "ellipse");
                return properties;
            }

            static enum Kind {
                SOURCE("solid"),
                CLASS("dotted");

                final String dotStyle;

                private Kind(String string2) {
                    this.dotStyle = string2;
                }
            }
        }

        static abstract class Node
        extends GraphUtils.AbstractNode<String, Node>
        implements GraphUtils.DottableNode<String, Node> {
            EnumMap<DependencyKind, List<Node>> depsByKind = new EnumMap(DependencyKind.class);

            Node(String string) {
                super(string);
                for (DependencyKind dependencyKind : DependencyKind.values()) {
                    this.depsByKind.put(dependencyKind, new ArrayList());
                }
            }

            void addDependency(DependencyKind dependencyKind, Node node) {
                List<Node> list = this.depsByKind.get(dependencyKind);
                if (!list.contains(node)) {
                    list.add(node);
                }
            }

            public boolean equals(Object object) {
                return object instanceof Node && ((String)this.data).equals(((Node)object).data);
            }

            public int hashCode() {
                return ((String)this.data).hashCode();
            }

            @Override
            public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                return DependencyKind.values();
            }

            @Override
            public Collection<? extends Node> getDependenciesByKind(GraphUtils.DependencyKind dependencyKind) {
                List<Node> list = this.depsByKind.get(dependencyKind);
                if (dependencyKind == DependencyKind.REQUIRES) {
                    return list;
                }
                HashSet<Node> hashSet = new HashSet<Node>(list);
                hashSet.removeAll((Collection)this.depsByKind.get(DependencyKind.REQUIRES));
                return hashSet;
            }

            @Override
            public Properties nodeAttributes() {
                Properties properties = new Properties();
                properties.put("label", GraphUtils.DotVisitor.wrap(this.toString()));
                return properties;
            }

            @Override
            public Properties dependencyAttributes(Node node, GraphUtils.DependencyKind dependencyKind) {
                Properties properties = new Properties();
                properties.put("style", ((DependencyKind)dependencyKind).dotStyle);
                return properties;
            }

            static enum DependencyKind implements GraphUtils.DependencyKind
            {
                REQUIRES("solid"),
                SIDE_EFFECTS("dashed");

                final String dotStyle;

                private DependencyKind(String string2) {
                    this.dotStyle = string2;
                }
            }
        }

        static enum DependenciesMode {
            SOURCE("source"),
            CLASS("class"),
            REDUNDANT("redundant"),
            SIDE_EFFECTS("side-effects");

            final String opt;

            private DependenciesMode(String string2) {
                this.opt = string2;
            }

            static EnumSet<DependenciesMode> getDependenciesModes(String[] stringArray) {
                EnumSet<DependenciesMode> enumSet = EnumSet.noneOf(DependenciesMode.class);
                List<String> list = Arrays.asList(stringArray);
                if (list.contains("all")) {
                    enumSet = EnumSet.allOf(DependenciesMode.class);
                }
                for (DependenciesMode dependenciesMode : DependenciesMode.values()) {
                    if (list.contains(dependenciesMode.opt)) {
                        enumSet.add(dependenciesMode);
                        continue;
                    }
                    if (!list.contains("-" + dependenciesMode.opt)) continue;
                    enumSet.remove((Object)dependenciesMode);
                }
                return enumSet;
            }
        }
    }

    public static enum AttributionKind {
        EXTENDS{

            @Override
            String format(JCTree jCTree) {
                return "extends " + super.format(jCTree);
            }
        }
        ,
        IMPLEMENTS{

            @Override
            String format(JCTree jCTree) {
                return "implements " + super.format(jCTree);
            }
        }
        ,
        IMPORT,
        TVAR{

            @Override
            String format(JCTree jCTree) {
                return "<" + super.format(jCTree) + ">";
            }
        };


        String format(JCTree jCTree) {
            return jCTree.toString();
        }
    }
}

