## Migration guide from RailwayJS 1.0 to CompoundJS 1.1.3

### General guidelines

* The app variable is no longer global, but accessible via compound.app . Make sure to change all your files that reference app directly
* The same goes for models. They are now accessible via compound.models.<ModelName> . This also applies to model relations, for example: model.hasMany(compound.models.anotherModel);
* The following files, autogenerated by railwayjs, should be regeneraterd or rewritten since they changed
    * server.js
    * config/environment.js, config/environments/\*, and config/initializers (see below)
    * app/models/\* (see below)
    * config/initializers/db-tools.js
    * views using `formTag` and `formFor`(see below)

### config/environment.js, config/environments/\*, and config/initializers

now should export function

```javascript
module.exports = function (compound) {
    var app = compound.app;
    var User = compound.models.User;
    // rest of file goes here
};
```

### app/models/\*

now should export function

```javascript
module.exports = function (compound, ModelName) {
    ModelName.validatesPresenceOf(...);
    ModelName.prototype.method = function () {
    };
};
```

As mentioned before, remember the new way to reference other models:

```javascript
module.exports = function (compound, ModelName) {
    ModelName.hasMany(compound.models.anotherModelName, {as: anotherMode});
};
```

### views

1. Avoid using `formTag` and `formFor` with blocks, new syntax:

    ```
    <% var form = formFor(resource) %>
    <%- form.begin() %>
    <%- form.input('propertyname') %>
    <%- form.submit() %>
    <%- form.end() %>
    ```

2. Use include instead of partial:

    <%- partial('post/form', {form: form, resource: resource}) %>
    becomes
    <%- include '_form' %>

### csrf protection

In newest CompoundJS version PUT and DELETE methods also protected from CSRF,
so you need to obtain latest `javascripts/rails.js` 
from compoundjs (generate new project and copy to existing one).

### config/autoload

This is replacement for npmfile. File should export function which return array
of extensions:

    module.exports = function (compound) {
        return [
            require('jugglingdb'),
            require('ejs-ext'),
            require('seedjs')
        ]
    };

### update /javascripts/rails.js

Compound protects PUT and DELETE requests from request forgery, so you need to
update old public/javascripts/rails.js file to get working ajax requests.

### something else?

fix this file, request pull
