# Dockerfiles

## About this Repository

This repo is used to store the Dockerfiles which can be used to build Docker images 
for each product released in the stack. Those Dockerfiles were generated from the 
products' own repositories for which you can get the links in the sections below. 
Please note that **issues are disabled on this repo** and that all issues and PRs 
must be filed in the products' repositories.

## Elasticsearch

**Elasticsearch** is a distributed, RESTful search and analytics engine capable of
solving a growing number of use cases. As the heart of the Elastic Stack, it
centrally stores your data so you can discover the expected and uncover the
unexpected.

For more information about Elasticsearch, please visit
https://www.elastic.co/products/elasticsearch.

### Where to file issues and PRs

- [Issues](https://github.com/elastic/elasticsearch/issues)
- [PRs](https://github.com/elastic/elasticsearch/pulls)

### Where to get help

- [Elasticsearch Discuss Forums](https://discuss.elastic.co/c/elasticsearch) 
- [Elasticsearch Documentation](https://www.elastic.co/guide/en/elasticsearch/reference/master/index.html)

## Kibana

**Kibana** lets you visualize your Elasticsearch data and navigate the Elastic Stack, 
so you can do anything from learning why you're getting paged at 2:00 a.m. to 
understanding the impact rain might have on your quarterly numbers.

For more information about Kibana, please visit
https://www.elastic.co/products/kibana.

### Where to file issues and PRs

- [Issues](https://github.com/elastic/kibana/issues)
- [PRs](https://github.com/elastic/kibana/pulls)


### Where to get help

- [Kibana Discuss Forums](https://discuss.elastic.co/c/kibana) 
- [Kibana Documentation](https://www.elastic.co/guide/en/kibana/current/index.html)

## Logstash

**Logstash** is a server-side data processing pipeline that ingests data from a
multitude of sources simultaneously, transforms it, and then sends it to your
favorite "stash." 

For more information about Logstash, please visit
https://www.elastic.co/products/logstash.

### Where to file issues and PRs

- [Issues](https://github.com/elastic/logstash/issues)
- [PRs](https://github.com/elastic/logstash/pulls)

### Where to get help

- [Logstash Discuss Forums](https://discuss.elastic.co/c/logstash) 
- [Logstash Documentation](https://www.elastic.co/guide/en/logstash/current/index.html)

## Still need help?

You can learn more about the Elastic Community and also understand how to get more help 
visiting [Elastic Community](https://www.elastic.co/community).


This software is governed by their applicable licenses,
and includes the full set of [free
features](https://www.elastic.co/subscriptions).

View the detailed release notes
[here](https://www.elastic.co/guide/en/elasticsearch/reference/8.14/es-release-notes.html).
