use pyo3::prelude::{Py, PyAny};

pub(crate) struct ResponseStartEvent {
    pub headers: Vec<(String, Box<[u8]>)>,
    pub trailers: bool,
}

pub(crate) struct ResponseBodyEvent {
    pub body: Box<[u8]>,
    pub more_body: bool,
    pub future: Py<PyAny>,
}

pub(crate) struct ResponseTrailersEvent {
    pub headers: Vec<(String, Box<[u8]>)>,
    pub more_trailers: bool,
}

pub(crate) enum ResponseEvent {
    Start(ResponseStartEvent, ResponseBodyEvent),
    Body(ResponseBodyEvent),
    Trailers(ResponseTrailersEvent),
    Exception,
}

pub(crate) const EVENT_ID_REQUEST: u64 = 1;
pub(crate) const EVENT_ID_RESPONSE: u64 = 2;
pub(crate) const EVENT_ID_EXCEPTION: u64 = 3;
