set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "${PROJECT_DESCRIPTION}")
set(CPACK_PACKAGE_DESCRIPTION "${PROJECT_LONG_DESCRIPTION}")
set(CPACK_RESOURCE_FILE_LICENSE "${PROJECT_SOURCE_DIR}/LICENSE")

set(CPACK_PACKAGE_CONTACT "${PROJECT_MAINTAINER_NAME} <${PROJECT_MAINTAINER_EMAIL}>")

set(CPACK_DEBIAN_PACKAGE_DEPENDS "trlib (>= 0.3)")
set(CPACK_DEBIAN_PACKAGE_SECTION "science")
# set(CPACK_DEBIAN_PACKAGE_DESCRIPTION "${CPACK_PACKAGE_DESCRIPTION}")

set(CPACK_DEB_PACKAGE_COMPONENT On)
set(CPACK_DEB_COMPONENT_INSTALL On)

set(ADDITIONAL_DEPS "")

if(SLEQP_LPS_DEPS_DEBIAN)
  list(APPEND ADDITIONAL_DEPS ${SLEQP_LPS_DEPS_DEBIAN})
endif()

if(SLEQP_FACT_DEPS_DEBIAN)
  list(APPEND ADDITIONAL_DEPS ${SLEQP_FACT_DEPS_DEBIAN})
endif()

set(LIB_PKG_NAME "${PROJECT_NAME}${PROJECT_VERSION}")

set(CPACK_DEBIAN_LIBRARIES_PACKAGE_NAME "${LIB_PKG_NAME}")
set(CPACK_DEBIAN_LIBRARIES_PACKAGE_SHLIBDEPS On)
set(CPACK_DEBIAN_LIBRARIES_DEBUGINFO_PACKAGE On)

if(ADDITIONAL_DEPS)
  string(JOIN ", " CPACK_DEBIAN_LIBRARIES_PACKAGE_DEPENDS ${ADDITIONAL_DEPS})
endif()

set(CPACK_DEBIAN_HEADERS_PACKAGE_DEPENDS "${CPACK_DEBIAN_PACKAGE_DEPENDS}")
set(CPACK_DEBIAN_HEADERS_PACKAGE_NAME "${PROJECT_NAME}-dev")
set(CPACK_DEBIAN_HEADERS_PACKAGE_DEPENDS "${LIB_PKG_NAME}")
set(CPACK_DEBIAN_HEADERS_PACKAGE_SECTION "devel")

set(CPACK_DEBIAN_PYTHON_PACKAGE_NAME "python3-${PROJECT_NAME}")
set(CPACK_DEBIAN_PYTHON_PACKAGE_DEPENDS "${LIB_PKG_NAME}, python3")
set(CPACK_DEBIAN_PYTHON_DESCRIPTION "${PROJECT_DESCRIPTION} (Python 3)")
set(CPACK_DEBIAN_PYTHON_PACKAGE_SECTION "python")

set(CPACK_DEBIAN_AMPL_PACKAGE_NAME "${PROJECT_NAME}-ampl")
set(CPACK_DEBIAN_AMPL_PACKAGE_DEPENDS "${LIB_PKG_NAME}")
set(CPACK_DEBIAN_AMPL_DESCRIPTION "${PROJECT_DESCRIPTION} (AMPL)")

set(CPACK_GENERATOR "DEB;TBZ2")

get_cmake_property(CPACK_COMPONENTS_ALL COMPONENTS)
list(REMOVE_ITEM CPACK_COMPONENTS_ALL "Unspecified")

include(CPack)
