#ifndef SLEQP_LSQR_H
#define SLEQP_LSQR_H

/**
 * @file lsqr.h
 * @brief Solve a linear least-squares problem.
 *
 * Solves \f$ \min_{x} \|Ax - b\|_2^2 \f$ where
 * \f$ A \f$ is given in terms of forward and
 * adjoint products using the LSQR iterative
 * algorithm. Optionally, a trust region can be
 * specified, in which case the iterations are
 * aborted as soon as the iterates leave the
 * trust region.
 **/

#include "lsqr_types.h"
#include "settings.h"

typedef struct SleqpLSQRSolver SleqpLSQRSolver;

SLEQP_WARNUNUSED
SLEQP_RETCODE
sleqp_lsqr_solver_create(SleqpLSQRSolver** star,
                         SleqpSettings* settings,
                         int forward_dim,
                         int adjoint_dim,
                         SleqpLSQRCallbacks* callbacks,
                         void* data);

SLEQP_WARNUNUSED
SLEQP_RETCODE
sleqp_lsqr_set_time_limit(SleqpLSQRSolver* solver, double time_limit);

SLEQP_WARNUNUSED
SLEQP_RETCODE
sleqp_lsqr_solver_resize(SleqpLSQRSolver* solver,
                         int forward_dim,
                         int adjoint_dim);

SLEQP_WARNUNUSED
SLEQP_RETCODE
sleqp_lsqr_solver_solve(SleqpLSQRSolver* solver,
                        const SleqpVec* rhs,
                        double rel_tol,
                        double trust_radius,
                        SleqpVec* sol);

SLEQP_WARNUNUSED
SLEQP_RETCODE
sleqp_lsqr_solver_capture(SleqpLSQRSolver* solver);

SLEQP_WARNUNUSED
SLEQP_RETCODE
sleqp_lsqr_solver_release(SleqpLSQRSolver** star);

#endif /* SLEQP_LSQR_H */
