/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(category=BugPattern.Category.JDK, name="FunctionalInterfaceMethodChanged", summary="Casting a lambda to this @FunctionalInterface can cause a behavior change from casting to a functional superinterface, which is surprising to users.  Prefer decorator methods to this surprising behavior.", severity=BugPattern.SeverityLevel.ERROR, generateExamplesFromTestCases=false)
public class FunctionalInterfaceMethodChanged
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<Tree> IS_FUNCTIONAL_INTERFACE = Matchers.hasAnnotation(FunctionalInterface.class);

    public Description matchMethod(MethodTree tree, VisitorState state) {
        ClassTree enclosingClazz = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (tree.getModifiers().getFlags().contains((Object)Modifier.DEFAULT) && IS_FUNCTIONAL_INTERFACE.matches((Tree)enclosingClazz, state)) {
            Types types = Types.instance(state.context);
            Set functionalSuperInterfaceSams = (Set)enclosingClazz.getImplementsClause().stream().filter(t -> IS_FUNCTIONAL_INTERFACE.matches(t, state)).map(ASTHelpers::getSymbol).map(Symbol.TypeSymbol.class::cast).map(types::findDescriptorSymbol).collect(ImmutableSet.toImmutableSet());
            final Symbol thisInterfaceSam = types.findDescriptorSymbol(ASTHelpers.getSymbol((ClassTree)enclosingClazz));
            SimpleTreeVisitor<Boolean, VisitorState> behaviorPreserving = new SimpleTreeVisitor<Boolean, VisitorState>(Boolean.valueOf(false)){

                @Override
                public Boolean visitMethod(MethodTree node, VisitorState state) {
                    return node.getBody() != null && node.getBody().accept(this, state) != false;
                }

                @Override
                public Boolean visitBlock(BlockTree node, VisitorState state) {
                    return node.getStatements().size() == 1 && ((StatementTree)Iterables.getOnlyElement(node.getStatements())).accept(this, state) != false;
                }

                @Override
                public Boolean visitExpressionStatement(ExpressionStatementTree node, VisitorState state) {
                    return node.getExpression().accept(this, state);
                }

                @Override
                public Boolean visitReturn(ReturnTree node, VisitorState state) {
                    return node.getExpression().accept(this, state);
                }

                @Override
                public Boolean visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
                    return ASTHelpers.getSymbol((MethodInvocationTree)node) == thisInterfaceSam;
                }
            };
            if (!Collections.disjoint(ASTHelpers.findSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)tree), (Types)types), functionalSuperInterfaceSams) && !tree.accept(behaviorPreserving, state).booleanValue()) {
                return this.describeMatch(tree);
            }
        }
        return Description.NO_MATCH;
    }
}

